diff -cr gcc-2.5/aux-outp.c g:gcc-2.5/aux-outp.c
*** gcc-2.5/aux-outp.c	Sun Jan 30 17:00:04 1994
--- g:gcc-2.5/aux-outp.c	Sat Jan 29 21:18:54 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* aux-outp.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Subroutines for insn-output.c for Intel 80386.
     Copyright (C) 1988, 1992 Free Software Foundation, Inc.
  
***************
*** 857,863 ****
--- 859,869 ----
  {
    register int regno;
    int limit;
+ #ifndef EMX
    rtx xops[4];
+ #else /* EMX */
+   rtx xops[5];
+ #endif /* EMX */
    int pic_reg_used = flag_pic && (current_function_uses_pic_offset_table
  				  || current_function_uses_const_pool);
  
***************
*** 871,877 ****
--- 877,911 ----
      }
  
    if (size)
+ #ifndef EMX
      output_asm_insn (AS2 (sub%L0,%2,%0), xops);
+ #else /* EMX */
+     {
+       if (TARGET_PROBE && size >= PROBE_SIZE)
+         {
+         if (size > PROBE_MAX_INLINE)
+           {
+             output_asm_insn (AS1 (push%L0,%2), xops);
+             output_asm_insn (AS1 (call,___probe), xops);
+           }
+         else
+           {
+             int i = size, j = 0;
+             xops[3] = const0_rtx;
+             while (i >= PROBE_SIZE)
+               {
+                 i -= PROBE_SIZE; j += PROBE_SIZE;
+                 xops[4] = gen_rtx (MEM, QImode,
+                             gen_rtx (PLUS, SImode,
+                               gen_rtx (REG, SImode, 7),
+                               gen_rtx (CONST_INT, VOIDmode, -j)));
+                 output_asm_insn (AS2 (movb,%3,%4), xops);
+               }
+           }
+         }
+       output_asm_insn (AS2 (sub%L0,%2,%0), xops);
+     }
+ #endif /* EMX */
  
    /* Note If use enter it is NOT reversed args.
       This one is not reversed from intel!!
diff -cr gcc-2.5/cccp.c g:gcc-2.5/cccp.c
*** gcc-2.5/cccp.c	Sat Dec 11 14:49:38 1993
--- g:gcc-2.5/cccp.c	Sat Jan 29 21:18:58 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* cccp.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* C Compatible Compiler Preprocessor (CCCP)
  Copyright (C) 1986, 1987, 1989, 1992, 1993 Free Software Foundation, Inc.
                      Written by Paul Rubin, June 1986
***************
*** 372,377 ****
--- 374,387 ----
  
  static int print_deps = 0;
  
+ #ifdef EMX
+ /* Nonzero means use .obj instead of .o for target file when printing
+    dependencies. */
+ 
+ static int omf = 0;
+ 
+ #endif
+ 
  /* Nonzero means print names of header files (-H).  */
  
  static int print_include_names = 0;
***************
*** 1110,1115 ****
--- 1120,1129 ----
    }
  #endif
  
+ #ifdef __EMX__
+   _emxload_env ("GCCLOAD");
+ #endif
+ 
    in_fname = NULL;
    out_fname = NULL;
  
***************
*** 1517,1522 ****
--- 1531,1548 ----
  	inhibit_predefs = 1;
  	break;
  
+ #ifdef EMX
+       case 'Z':
+         if (!strcmp (argv[i], "-Zomf"))
+           omf = 1;
+         else if (!strcmp (argv[i], "-Zc++-comments")
+                  || !strcmp (argv[i], "-ZC++-comments"))
+           cplusplus_comments = 1;
+         else
+           fatal ("Invalid option `%s'", argv[i]);
+         break;
+ #endif /* EMX */
+ 
        case '\0': /* JF handle '-' as file name meaning stdin or stdout */
  	if (in_fname == NULL) {
  	  in_fname = "";
***************
*** 1904,1910 ****
--- 1930,1940 ----
  	deps_output (p, 0);
        /* Supply our own suffix.  */
  #ifndef VMS
+ #ifndef EMX
        deps_output (".o : ", 0);
+ #else /* EMX */
+       deps_output (omf ? ".obj : " : ".o : ", 0);
+ #endif /* EMX */
  #else
        deps_output (".obj : ", 0);
  #endif
***************
*** 4061,4067 ****
--- 4091,4101 ----
  
    /* If specified file name is absolute, just open it.  */
  
+ #ifndef EMX
    if (*fbeg == '/') {
+ #else /* EMX */
+   if (*fbeg == '/' || *fbeg == '\\' || _fngetdrive (fbeg) != 0) {
+ #endif /* EMX */
      strncpy (fname, fbeg, flen);
      fname[flen] = 0;
      if (redundant_include_p (fname))
diff -cr gcc-2.5/cp-lex.c g:gcc-2.5/cp-lex.c
*** gcc-2.5/cp-lex.c	Wed Nov 24 06:19:16 1993
--- g:gcc-2.5/cp-lex.c	Sat Jan 29 21:19:00 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* cp-lex.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Separate lexical analyzer for GNU C++.
     Copyright (C) 1987, 1989, 1992, 1993 Free Software Foundation, Inc.
     Hacked by Michael Tiemann (tiemann@cygnus.com)
***************
*** 2306,2311 ****
--- 2308,2367 ----
  		      TREE_INT_CST_HIGH (fileinfo) = interface_unknown;
  		    }
  		}
+ #ifdef EMX
+               else if (c == 'p'
+                        && getch () == 'a'
+                        && getch () == 'c'
+ 		       && getch () == 'k')
+                 {
+                   int align;
+                   extern int maximum_field_alignment;
+ 
+                   align = -1;
+                   do
+                     {
+                       nextchar = getch ();
+                     } while (nextchar == ' ' || nextchar == '\t');
+                   if (nextchar == '(')
+                     {
+                       do
+                         {
+                           nextchar = getch ();
+                         } while (nextchar == ' ' || nextchar == '\t');
+                       switch (nextchar)
+                         {
+                         case ')':
+                           align = 0;
+                           break;
+                         case '1':
+                         case '2':
+                         case '4':
+                           align = nextchar - '0';
+                           break;
+                         }
+                       if (nextchar != ')')
+                         do
+                           {
+                             nextchar = getch ();
+                           } while (nextchar == ' ' || nextchar == '\t');
+                       if (nextchar != ')')
+                         align = -1;
+                     }
+                   if (align < 0)
+                     {
+                       error ("invalid #pragma pack");
+                       goto skipline;
+                     }
+                   maximum_field_alignment = align * 8;
+                   do
+                     {
+                       nextchar = getch ();
+                     } while (nextchar == ' ' || nextchar == '\t');
+                   c = nextchar;
+ 		  if (c != '\n')
+ 		    warning ("trailing characters ignored");
+ 		}
+ #endif /* EMX */
  	    }
  	  goto skipline;
  	}
diff -cr gcc-2.5/explow.c g:gcc-2.5/explow.c
*** gcc-2.5/explow.c	Mon Oct 11 02:11:34 1993
--- g:gcc-2.5/explow.c	Sat Jan 29 21:19:00 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* explow.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Subroutines for manipulating rtx's in semantically interesting ways.
     Copyright (C) 1987, 1991 Free Software Foundation, Inc.
  
***************
*** 647,652 ****
--- 649,689 ----
    if (adjust == const0_rtx)
      return;
  
+ #ifdef EMX
+   if (TARGET_PROBE &&
+           (GET_CODE (adjust) != CONST_INT || INTVAL (adjust) >= PROBE_SIZE))
+     {
+       int i, j;
+ 
+       if (GET_CODE (adjust) == CONST_INT && INTVAL (adjust) <= PROBE_MAX_INLINE)
+         {
+           i = INTVAL (adjust); j = 0;
+           while (i >= PROBE_SIZE)
+             {
+               i -= PROBE_SIZE; j += PROBE_SIZE;
+ /* (set (mem:QI (plus:SI (reg:SI 7) (const_int -j)) (const_int 0))) */
+               emit_insn (gen_rtx (SET, VOIDmode,
+                            gen_rtx (MEM, QImode,
+                              gen_rtx (PLUS, Pmode,
+                                gen_rtx (REG, Pmode, 7), /* esp */
+                                gen_rtx (CONST_INT, SImode, -j))),
+                            const0_rtx));
+             }
+         }
+       else
+         {
+           emit_push_insn (adjust, SImode, 0, 0, 0, 0, 0, 0, 0, 0);
+ /* (call (mem:QI (symbol_ref:SI ("__probe"))) (const_int 1)) */
+           emit_insn (gen_rtx (CALL, VOIDmode,
+                        gen_rtx (MEM, QImode,
+                          gen_rtx (SYMBOL_REF, Pmode, "__probe")),
+                        const1_rtx));
+           /*
+           emit_insn (gen_rtx (ASM_INPUT, VOIDmode, "call ___probe"));
+           */
+         }
+     }
+ #endif /* EMX */
    temp = expand_binop (Pmode,
  #ifdef STACK_GROWS_DOWNWARD
  		       sub_optab,
diff -cr gcc-2.5/gcc.c g:gcc-2.5/gcc.c
*** gcc-2.5/gcc.c	Thu Dec 23 23:50:00 1993
--- g:gcc-2.5/gcc.c	Sat Jan 29 21:19:02 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* gcc.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Compiler driver program that can handle many languages.
     Copyright (C) 1987, 1989, 1992, 1993 Free Software Foundation, Inc.
  
***************
*** 65,70 ****
--- 67,78 ----
  #define NULL_PTR ((GENERIC_PTR)0)
  #endif
  
+ #ifdef EMX
+ #include <process.h>
+ #include <stdlib.h>
+ extern char *_getname();
+ #endif /* EMX */
+ 
  #ifdef USG
  #define vfork fork
  #endif /* USG */
***************
*** 103,114 ****
--- 111,124 ----
  extern void free ();
  extern char *getenv ();
  
+ #ifndef EMX
  extern int errno, sys_nerr;
  #if defined(bsd4_4)
  extern const char *const sys_errlist[];
  #else
  extern char *sys_errlist[];
  #endif
+ #endif /* !EMX */
  
  extern int execv (), execvp ();
  
***************
*** 306,311 ****
--- 316,332 ----
  treated as compiler output files, and passed to the linker in their
  proper position among the other output files.  */
  
+ #ifndef EMX
+ 
+ #define EMX_ASM_SPEC_PATCH "%{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o} "
+ 
+ #else /* EMX */
+ 
+ #define EMX_ASM_SPEC_PATCH "%{Zomf:-o %d%g.o}%{!Zomf:\
+ 		            %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}} "
+ 
+ #endif /* EMX */
+ 
  /* Define the macros used for specs %a, %l, %L, %S, %c, %C, %1.  */
  
  /* config.h can define ASM_SPEC to provide extra args to the assembler
***************
*** 462,470 ****
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
! 		      %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
!                       %{!pipe:%g.s} %A\n }}}}"},
    {"-",
     "%{E:cpp -lang-c %{nostdinc*} %{C} %{v} %{A*} %{I*} %{P} %I\
  	%{C:%{!E:%eGNU C does not support -C without using -E}}\
--- 483,491 ----
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
!                       EMX_ASM_SPEC_PATCH
!                       "%{!pipe:%g.s} %A\n }}}}"},
    {"-",
     "%{E:cpp -lang-c %{nostdinc*} %{C} %{v} %{A*} %{I*} %{P} %I\
  	%{C:%{!E:%eGNU C does not support -C without using -E}}\
***************
*** 497,505 ****
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
! 		      %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
!                       %{!pipe:%g.s} %A\n }}}}"},
    {".h", "@c-header"},
    {"@c-header",
     "%{!E:%eCompilation of header file requested} \
--- 518,526 ----
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
! 		      EMX_ASM_SPEC_PATCH
!                       "%{!pipe:%g.s} %A\n }}}}"},
    {".h", "@c-header"},
    {"@c-header",
     "%{!E:%eCompilation of header file requested} \
***************
*** 515,520 ****
--- 536,544 ----
          %i %W{o*}"},
    {".cc", "@c++"},
    {".cxx", "@c++"},
+ #ifdef EMX
+   {".cpp", "@c++"},
+ #endif
    {".C", "@c++"},
    {"@c++",
     "cpp -lang-c++ %{nostdinc*} %{C} %{v} %{A*} %{I*} %{P} %I\
***************
*** 533,541 ****
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
! 		      %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
!                       %{!pipe:%g.s} %A\n }}}}"},
    {".i", "@cpp-output"},
    {"@cpp-output",
     "cc1 %i %1 %{!Q:-quiet} %{d*} %{m*} %{a}\
--- 557,565 ----
  		   %{aux-info*}\
  		   %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  		   %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!               %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
! 		      EMX_ASM_SPEC_PATCH
!                       "%{!pipe:%g.s} %A\n }}}}"},
    {".i", "@cpp-output"},
    {"@cpp-output",
     "cc1 %i %1 %{!Q:-quiet} %{d*} %{m*} %{a}\
***************
*** 544,551 ****
  	%{aux-info*}\
  	%{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  	%{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!     %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
!             %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o} %{!pipe:%g.s} %A\n }"},
    {".ii", "@c++-cpp-output"},
    {"@c++-cpp-output",
     "cc1plus %i %1 %2 %{!Q:-quiet} %{d*} %{m*} %{a}\
--- 568,576 ----
  	%{aux-info*}\
  	%{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  	%{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!     %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
!             EMX_ASM_SPEC_PATCH
!             "%{!pipe:%g.s} %A\n }"},
    {".ii", "@c++-cpp-output"},
    {"@c++-cpp-output",
     "cc1plus %i %1 %2 %{!Q:-quiet} %{d*} %{m*} %{a}\
***************
*** 554,566 ****
  	    %{aux-info*}\
  	    %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  	    %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!        %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
! 	       %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
! 	       %{!pipe:%g.s} %A\n }"},
    {".s", "@assembler"},
    {"@assembler",
!    "%{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
!             %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o} %i %A\n }"},
    {".S", "@assembler-with-cpp"},
    {"@assembler-with-cpp",
     "cpp -lang-asm %{nostdinc*} %{C} %{v} %{A*} %{I*} %{P} %I\
--- 579,590 ----
  	    %{aux-info*}\
  	    %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
  	    %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} |\n\
!        %{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
! 	       EMX_ASM_SPEC_PATCH "%{!pipe:%g.s} %A\n }"},
    {".s", "@assembler"},
    {"@assembler",
!    "%{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
!             EMX_ASM_SPEC_PATCH "%i %A\n }"},
    {".S", "@assembler-with-cpp"},
    {"@assembler-with-cpp",
     "cpp -lang-asm %{nostdinc*} %{C} %{v} %{A*} %{I*} %{P} %I\
***************
*** 571,579 ****
          %{traditional-cpp:-traditional}\
  	%{g*} %{W*} %{w} %{pedantic*} %{H} %{d*} %C %{D*} %{U*} %{i*}\
          %i %{!M:%{!MM:%{!E:%{!pipe:%g.s}}}}%{E:%W{o*}}%{M:%W{o*}}%{MM:%W{o*}} |\n",
!    "%{!M:%{!MM:%{!E:%{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
!                     %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
! 		    %{!pipe:%g.s} %A\n }}}}"},
    {".ads", "@ada"},
    {".adb", "@ada"},
    {".ada", "@ada"},
--- 595,603 ----
          %{traditional-cpp:-traditional}\
  	%{g*} %{W*} %{w} %{pedantic*} %{H} %{d*} %C %{D*} %{U*} %{i*}\
          %i %{!M:%{!MM:%{!E:%{!pipe:%g.s}}}}%{E:%W{o*}}%{M:%W{o*}}%{MM:%W{o*}} |\n",
!    "%{!M:%{!MM:%{!E:%{!S:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
!                     EMX_ASM_SPEC_PATCH
! 		    "%{!pipe:%g.s} %A\n }}}}"},
    {".ads", "@ada"},
    {".adb", "@ada"},
    {".ada", "@ada"},
***************
*** 583,591 ****
         %{g*} %{O*} %{p} %{pg:-p} %{f*} %{d*}\
         %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
         %i %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} | \n",
!    "%{!S:%{!gnatc:%{!gnats:as %{R} %{j} %{J} %{h} %{d2} %a %Y\
!         %{c:%W{o*}%{!o*:-o %w%b.o}}%{!c:-o %d%w%u.o}\
!         %{!pipe:%g.s} %A\n}}} "},
    /* Mark end of table */
    {0, 0}
  };
--- 607,615 ----
         %{g*} %{O*} %{p} %{pg:-p} %{f*} %{d*}\
         %{pg:%{fomit-frame-pointer:%e-pg and -fomit-frame-pointer are incompatible}}\
         %i %{S:%W{o*}%{!o*:-o %b.s}}%{!S:-o %{|!pipe:%g.s}} | \n",
!    "%{!S:%{!gnatc:%{!gnats:as %{R} %{j} %{J} %{h} %{d2} %a %Y"
!         EMX_ASM_SPEC_PATCH
!         "%{!pipe:%g.s} %A\n}}} "},
    /* Mark end of table */
    {0, 0}
  };
***************
*** 622,633 ****
--- 646,673 ----
  			%{L*} %{T*} %o %{!nostdlib:libgcc.a%s %L libgcc.a%s %{!A:%E}}\n }}}}}}";
  #else
  /* Use -L and have the linker do the search for -lgcc.  */
+ #ifndef EMX
  static char *link_command_spec = "\
  %{!fsyntax-only: \
   %{!c:%{!M:%{!MM:%{!E:%{!S:ld %l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} \
  			%{r} %{s} %{t} %{u*} %{x} %{z}\
  			%{!A:%{!nostartfiles:%{!nostdlib:%S}}} %{static:}\
  			%{L*} %D %{T*} %o %{!nostdlib:-lgcc %L -lgcc %{!A:%E}}\n }}}}}}";
+ #else /* EMX */
+ static char *link_command_spec = "\
+ %{!fsyntax-only: \
+  %{!c:%{!M:%{!MM:%{!E:%{!S:%{!Zomf:ld}%{Zomf:emxomfld %{-Zdll}}\
+ 			%l %X %{o*} %{A} %{d} %{e*} %{m} %{N} %{n} \
+ 			%{r} %{s} %{t} %{u*} %{x} %{z} %{Zexe} %{Zstack*} \
+ 			%{!A:%{!nostartfiles:%{!nostdlib:%S}}} %{static:}\
+ 			%{L*} %D %{T*} %o \
+                         %{!nostdlib:%{Zmtd:-lcdll -los2 -lemx2} \
+                         %{!Zmtd:-lgcc %L -lgcc \
+                         %{Zsys:%{!Zmts:-lsysst}%{Zmts:-lsysmt} -los2} \
+                         %{!Zsys:%{!Zmts:-lemxst}%{Zmts:-lemxmt} \
+                         -los2 -lemx2}} \
+                         %{!A:%E}}\n }}}}}}";
+ #endif /* EMX */
  #endif
  #endif
  
***************
*** 1408,1414 ****
--- 1448,1458 ----
    len = strlen (base);
    temp_filename = xmalloc (len + sizeof("/ccXXXXXX") + 1);
    strcpy (temp_filename, base);
+ #ifndef EMX
    if (len > 0 && temp_filename[len-1] != '/')
+ #else /* EMX */
+   if (len > 0 && temp_filename[len-1] != '/' && temp_filename[len-1] != '\\')
+ #endif /* EMX */
      temp_filename[len++] = '/';
    strcpy (temp_filename + len, "ccXXXXXX");
  
***************
*** 1812,1817 ****
--- 1856,1924 ----
  
  #else /* not __MSDOS__ */
  
+ #ifdef EMX
+ 
+ static int
+ pexecute (search_flag, program, argv, not_last)
+      int search_flag;
+      char *program;
+      char *argv[];
+      int not_last;
+ {
+   int pid;
+   int pdes[2], org_stdin, org_stdout;
+   int input_desc = last_pipe_input;
+   int output_desc = STDOUT_FILE_NO;
+ 
+   /* If this isn't the last process, make a pipe for its output,
+      and record it as waiting to be the input to the next process.  */
+ 
+   if (not_last)
+     {
+       if (pipe (pdes) < 0)
+ 	pfatal_with_name ("pipe");
+       output_desc = pdes[WRITE_PORT];
+       last_pipe_input = pdes[READ_PORT];
+     }
+   else
+     last_pipe_input = STDIN_FILE_NO;
+ 
+   if (_osmode != DOS_MODE && input_desc != STDIN_FILE_NO)
+     {
+       org_stdin = dup (STDIN_FILE_NO);
+       dup2 (input_desc, STDIN_FILE_NO);
+       close (input_desc); 
+     }
+   if (_osmode != DOS_MODE && output_desc != STDOUT_FILE_NO)
+     {
+       org_stdout = dup (STDOUT_FILE_NO);
+       dup2 (output_desc, STDOUT_FILE_NO);
+       close (output_desc);
+     }
+   pid = (search_flag ? spawnv : spawnvp) (P_NOWAIT, program,
+                                           (char const * const *)argv);
+   if (_osmode != DOS_MODE && input_desc != STDIN_FILE_NO)
+     {
+       dup2 (org_stdin, STDIN_FILE_NO);
+       close (org_stdin);
+     }
+   if (_osmode != DOS_MODE && output_desc != STDOUT_FILE_NO)
+     {
+       dup2 (org_stdout, STDOUT_FILE_NO);
+       close (org_stdout);
+     }
+ 
+   if (pid == -1)
+     {
+       perror_exec (program);
+       exit (-1);
+     }
+ 
+   return pid;
+ }
+ 
+ #else /* !EMX */
+ 
  static int
  pexecute (search_flag, program, argv, not_last)
       int search_flag;
***************
*** 1900,1905 ****
--- 2007,2013 ----
      }
  }
  
+ #endif /* !EMX */
  #endif /* not __MSDOS__ */
  #else /* not OS2 */
  
***************
*** 1960,1965 ****
--- 2068,2077 ----
  #ifdef __MSDOS__
          fatal ("-pipe not supported under MS-DOS");
  #endif
+ #ifdef EMX
+         if (_osmode == DOS_MODE)
+           fatal ("-pipe not supported under MS-DOS");
+ #endif
  	argbuf[i] = 0;	/* termination of command args.  */
  	commands[n_commands].prog = argbuf[i + 1];
  	commands[n_commands].argv = &argbuf[i + 1];
***************
*** 2283,2288 ****
--- 2395,2421 ----
  
  	  linker_options[n_linker_options - 1] = argv[++i];
  	}
+ #ifdef EMX
+       else if (! strcmp (argv[i], "-Zlinker"))
+ 	{
+ 	  /* Pass the argument of this option to LINK386 when we link.	*/
+ 
+ 	  if (i + 1 == argc)
+ 	    fatal ("argument to `-Zlinker' is missing");
+ 
+ 	  n_linker_options += 2;
+ 	  if (!linker_options)
+ 	    linker_options
+ 	      = (char **) xmalloc (n_linker_options * sizeof (char **));
+ 	  else
+ 	    linker_options
+ 	      = (char **) xrealloc (linker_options,
+ 				    n_linker_options * sizeof (char **));
+ 
+ 	  linker_options[n_linker_options - 2] = "-O";
+ 	  linker_options[n_linker_options - 1] = argv[++i];
+ 	}
+ #endif
        else if (! strncmp (argv[i], "-Wl,", 4))
  	{
  	  int prev, j;
***************
*** 2483,2488 ****
--- 2616,2625 ----
        /* Just skip the switches that were handled by the preceding loop.  */
        if (!strcmp (argv[i], "-Xlinker"))
  	i++;
+ #ifdef EMX
+       if (!strcmp (argv[i], "-Zlinker"))
+ 	i++;
+ #endif
        else if (! strncmp (argv[i], "-Wl,", 4))
  	;
        else if (! strncmp (argv[i], "-Wa,", 4))
***************
*** 3688,3696 ****
--- 3825,3844 ----
    char *specs_file;
    char *p;
  
+ #ifndef EMX
    p = argv[0] + strlen (argv[0]);
    while (p != argv[0] && p[-1] != '/') --p;
+ #else /* EMX */
+   p = _getname (argv[0]);
+ #endif /* EMX */
    programname = p;
+ 
+ #ifdef EMX
+   _emxload_env ("GCCLOAD");
+   _envargs (&argc, &argv, "GCCOPT");
+   _response (&argc, &argv);
+   _wildcard (&argc, &argv);
+ #endif /* EMX */
  
    if (signal (SIGINT, SIG_IGN) != SIG_IGN)
      signal (SIGINT, fatal_error);
diff -cr gcc-2.5/toplev.c g:gcc-2.5/toplev.c
*** gcc-2.5/toplev.c	Sat Dec 11 01:59:54 1993
--- g:gcc-2.5/toplev.c	Sat Jan 29 21:19:04 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* toplev.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Top level of GNU C compiler
     Copyright (C) 1987, 1988, 1989, 1992, 1993 Free Software Foundation, Inc.
  
***************
*** 1581,1586 ****
--- 1583,1597 ----
    if (dump_base_name == 0)
      dump_base_name = name ? name : "gccdump";
    dump_base_name_length = strlen (dump_base_name);
+ #ifdef EMX
+   {
+     char *tmp = (char *) xmalloc (dump_base_name_length + 1);
+     strcpy (tmp, dump_base_name);
+     dump_base_name = tmp;
+     strip_off_ending (dump_base_name, dump_base_name_length);
+     dump_base_name_length = strlen (dump_base_name);
+   }
+ #endif /* EMX */
  
    parse_time = 0;
    varconst_time = 0;
***************
*** 1665,1671 ****
--- 1676,1686 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".jump");
+ #else /* EMX */
+       strcat (dumpname, ".jp1");
+ #endif /* EMX */
        jump_opt_dump_file = fopen (dumpname, "w");
        if (jump_opt_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1676,1682 ****
--- 1691,1701 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".cse");
+ #else /* EMX */
+       strcat (dumpname, ".cs1");
+ #endif /* EMX */
        cse_dump_file = fopen (dumpname, "w");
        if (cse_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1687,1693 ****
--- 1706,1716 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".loop");
+ #else /* EMX */
+       strcat (dumpname, ".loo");
+ #endif /* EMX */
        loop_dump_file = fopen (dumpname, "w");
        if (loop_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1698,1704 ****
--- 1721,1731 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".cse2");
+ #else /* EMX */
+       strcat (dumpname, ".cs2");
+ #endif /* EMX */
        cse2_dump_file = fopen (dumpname, "w");
        if (cse2_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1709,1715 ****
--- 1736,1746 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".flow");
+ #else /* EMX */
+       strcat (dumpname, ".flo");
+ #endif /* EMX */
        flow_dump_file = fopen (dumpname, "w");
        if (flow_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1720,1726 ****
--- 1751,1761 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 10);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".combine");
+ #else /* EMX */
+       strcat (dumpname, ".cmb");
+ #endif /* EMX */
        combine_dump_file = fopen (dumpname, "w");
        if (combine_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1731,1737 ****
--- 1766,1776 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 7);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".sched");
+ #else /* EMX */
+       strcat (dumpname, ".sd1");
+ #endif /* EMX */
        sched_dump_file = fopen (dumpname, "w");
        if (sched_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1742,1748 ****
--- 1781,1791 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".lreg");
+ #else /* EMX */
+       strcat (dumpname, ".lre");
+ #endif /* EMX */
        local_reg_dump_file = fopen (dumpname, "w");
        if (local_reg_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1753,1759 ****
--- 1796,1806 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 6);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".greg");
+ #else /* EMX */
+       strcat (dumpname, ".gre");
+ #endif /* EMX */
        global_reg_dump_file = fopen (dumpname, "w");
        if (global_reg_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1764,1770 ****
--- 1811,1821 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 8);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".sched2");
+ #else /* EMX */
+       strcat (dumpname, ".sd2");
+ #endif /* EMX */
        sched2_dump_file = fopen (dumpname, "w");
        if (sched2_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1775,1781 ****
--- 1826,1836 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 7);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".jump2");
+ #else /* EMX */
+       strcat (dumpname, ".jp2");
+ #endif /* EMX */
        jump2_opt_dump_file = fopen (dumpname, "w");
        if (jump2_opt_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 1799,1805 ****
--- 1854,1864 ----
      {
        register char *dumpname = (char *) xmalloc (dump_base_name_length + 10);
        strcpy (dumpname, dump_base_name);
+ #ifndef EMX
        strcat (dumpname, ".stack");
+ #else /* EMX */
+       strcat (dumpname, ".stk");
+ #endif /* EMX */
        stack_reg_dump_file = fopen (dumpname, "w");
        if (stack_reg_dump_file == 0)
  	pfatal_with_name (dumpname);
***************
*** 2926,2931 ****
--- 2985,2994 ----
    int version_flag = 0;
    char *p;
  
+ #ifdef __EMX__
+   _emxload_env ("GCCLOAD");
+ #endif
+ 
    /* save in case md file wants to emit args as a comment.  */
    save_argc = argc;
    save_argv = argv;
***************
*** 3515,3525 ****
--- 3578,3590 ----
  	       lim - (char *) &environ);
        fflush (stderr);
  
+ #ifndef EMX
  #ifdef USG
        system ("ps -l 1>&2");
  #else /* not USG */
        system ("ps v");
  #endif /* not USG */
+ #endif /* !EMX */
      }
  #endif /* not VMS */
  #endif /* not OS2 */
diff -cr gcc-2.5/varasm.c g:gcc-2.5/varasm.c
*** gcc-2.5/varasm.c	Tue Jan 11 01:17:54 1994
--- g:gcc-2.5/varasm.c	Sat Jan 29 21:19:06 1994
***************
*** 1,3 ****
--- 1,5 ----
+ /* varasm.c -- changed for emx by Eberhard Mattes -- Jan 1994 */
+ 
  /* Output variables, constants and external declarations, for GNU compiler.
     Copyright (C) 1987, 1988, 1989, 1992, 1993 Free Software Foundation, Inc.
  
***************
*** 672,677 ****
--- 674,680 ----
  
  
    /* Tell assembler to move to target machine's alignment for functions.  */
+ #ifndef EMX
    align = floor_log2 (FUNCTION_BOUNDARY / BITS_PER_UNIT);
    if (align > 0)
      {
***************
*** 680,685 ****
--- 683,698 ----
        else
  	ASM_OUTPUT_ALIGN (asm_out_file, align);
      }
+ #else /* EMX */
+   if (output_bytecode)
+     {
+       align = floor_log2 (FUNCTION_BOUNDARY / BITS_PER_UNIT);
+       if (align > 0)
+ 	BC_OUTPUT_ALIGN (asm_out_file, align);
+     }
+   else
+     ASM_OUTPUT_ALIGN_CODE (asm_out_file);
+ #endif /* EMX */
  
  #ifdef ASM_OUTPUT_FUNCTION_PREFIX
    ASM_OUTPUT_FUNCTION_PREFIX (asm_out_file, fnname);
***************
*** 1488,1494 ****
--- 1501,1509 ----
  {
    char label[256];
    char *name;
+ #ifndef EMX
    int align;
+ #endif
  
    /* Shouldn't get here */
    if (output_bytecode)
***************
*** 1503,1511 ****
--- 1518,1530 ----
  #endif
  
    /* Write the assembler code to define one.  */
+ #ifndef EMX
    align = floor_log2 (FUNCTION_BOUNDARY / BITS_PER_UNIT);
    if (align > 0)
      ASM_OUTPUT_ALIGN (asm_out_file, align);
+ #else /* EMX */
+   ASM_OUTPUT_ALIGN_CODE (asm_out_file);
+ #endif /* EMX */
  
    ASM_OUTPUT_INTERNAL_LABEL (asm_out_file, "LTRAMP", 0);
    TRAMPOLINE_TEMPLATE (asm_out_file);
