/*
*       Hello World
*       Sample Application for OS/2 Presentation Manager
*/

/*---    Include files    ---*/
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "sizedlg.h"

/*---       Defines       ---*/
#define ID_TIMER 1

/*--- Function Prototypes ---*/
void cdecl main(void);
MRESULT EXPENTRY MyWindowProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY SizeDlgProc(HWND, ULONG, MPARAM, MPARAM);

/*---  Global Variables  ---*/
HAB hab;                        /* Anchor Block Handle */


/*---   Main Procedure   ---*/
void cdecl main()
  {
  HMQ hmq;                      /* Message Queue Handle */
  HWND hwndClient;              /* Client Window Handle */
  HWND hwndFrame;               /* Frame Window Handle */
  QMSG msg;                     /* Message from window Queue */
  ULONG flCreate;               /* Window Creation Flags */

  /* set up */
  hab = WinInitialize(0);      /* Initialize Presentation Manager */
  hmq = WinCreateMsgQueue (hab, 0); /* Create Message Queue */

  /* Register the window procedure  with the system */
  WinRegisterClass(hab,
        "MyWindow",             /* Arbitrary Class Name */
        MyWindowProc,           /* Window Procedure */
        CS_SIZEREDRAW,          /* Redraw when window is sized */
        0);                     /* No window words */

  /* Now create the Window */
  flCreate = FCF_TASKLIST |        /* Add Application to task list */
             FCF_TITLEBAR |        /* Put a title bar on window */
             FCF_SIZEBORDER |      /* Add a resizeable border */
             FCF_MINMAX |          /* Add the Minimize / Maximize buttons */
             FCF_MENU |            /* Add the Action-Bar Menu */
             FCF_SYSMENU;          /* Give it a system menu */

  hwndFrame = WinCreateStdWindow(
                HWND_DESKTOP,       /* Handle of parent window */
                WS_VISIBLE,         /* frame window style  */
                &flCreate,          /* Frame window creation flags */
                "MyWindow",         /* Window Class Name */
                "Base PM Application", /* Text for the Title Bar */
                0L,                 /* Client window style */
                (HMODULE) 0,        /* Location of resources (in .exe) */
                ID_RESOURCE,        /* Frame window and menu resource ID */
                &hwndClient);       /* address of client window handle */

   WinSetWindowPos( hwndFrame,      /* Handle of window being set */
                    HWND_TOP,       /* Z - Placement order (ON TOP) */
                    100, 100,       /* Position of lower left corner */
                    250, 200,       /* width and height */
                    SWP_SIZE | SWP_MOVE |    /* flags telling what to do */
                    SWP_ACTIVATE | SWP_SHOW);

  /* Start Processing Messages */
  while (WinGetMsg(hab, &msg, (HWND)0, 0, 0))
    {
    WinDispatchMsg(hab, &msg);    /* send the message on its way */
    }

  /* Clean up */
  WinDestroyWindow( hwndFrame);         /* get rid of the frame window */
  WinDestroyMsgQueue(hmq);              /* get rid of message queue */
  WinTerminate(hab);                    /* Pull up anchor */
  }

/*---  Window Procedure ---*/
MRESULT EXPENTRY MyWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HPS hps;                              /* Presentation Space Handle */
  RECTL rcl;                            /* Rectangle Coordinates */
  POINTL ptl;                           /* point coordinates */
  USHORT i;
  USHORT usRet;                          /* return value from Dialog Box */

  switch (msg)
    {
    /* Window needs painted */
    case WM_PAINT:
      hps = WinBeginPaint( hwnd, (HPS)0, &rcl );  /* get a PS to paint on */
      WinFillRect(hps, &rcl, CLR_RED);
      WinEndPaint(hps);                        /* release the PS */
      break;

   case WM_COMMAND:
     switch (SHORT1FROMMP(mp1))
       {
       case IDM_OPTIONS:
          WinDlgBox(HWND_DESKTOP,       /* Parent Window */
               hwnd,                           /* Owner Window  */
               SizeDlgProc,                   /* Dialog Procedure */
               (HMODULE)0,                     /* Where to find resource */
               IDD_SIZEDLG,                /* Resource ID */
               NULL);              /* Creation parameter */
          return 0L;
        }
      break;


    /* The system wants you to close */
    case WM_CLOSE:
      WinPostMsg(hwnd, WM_QUIT, 0L, 0L);     /* Shut yourself down */
      break;

    /* All System Messages that we don't care about */
    default:
      return(WinDefWindowProc(hwnd, msg, mp1, mp2)); /* Let OS/2 handle them */
    }
  return 0L;
  }


// This is a magic number derived empirically for positioning an entry
// field.  You would think that you could query an entry field window's
// size, then set the size to the same values without changing it.  Not
// so simple.  You must subtract this value first.  I imagine it has
// something to do with the entry field having a margin.  The documentation
// claims this is related to the font size, but my experiments have shown
// otherwise.  This "Magic Number" works for OS/2 2.0 and 2.1 in CGA, EGA,
// and various VGA resolutions.
#define ENTRYFIELDBORDER 6

MRESULT EXPENTRY SizeDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  static BOOL minimized;

  switch (msg)
    {
    case WM_INITDLG:
      minimized = FALSE;
      return 0;

    // When the dialog box is resized, come here to resize the controls
    // in the way that makes sense.  I grow the MLE in both x and y, grow
    // the entry field only in x, and move the push button.
    case WM_WINDOWPOSCHANGED:
      {
      PSWP pOldSize;
      PSWP pNewSize;
      SHORT dx, dy;
      SWP ctrlpos;
      int i;
      BOOL change;

      pNewSize = (PSWP)mp1;
      pOldSize = pNewSize + 1;
      change = TRUE;
      if (pNewSize->fl & SWP_MINIMIZE)
        { // Don't shrink controls if minimizing. The size difference
          // is so great that the controls won't come back to normal
        minimized = TRUE;
        change = FALSE;
        }
      if (pNewSize->fl & SWP_RESTORE)
        { // Don't expand controls if restoring from minimized.
          // (we never shrank them)
        change = !minimized;
        minimized = FALSE;
        }
      if ((pNewSize->fl & SWP_SIZE) && change)
        {
        WinEnableWindowUpdate(hwnd, FALSE);
        dx = pNewSize->cx - pOldSize->cx;
        dy = pNewSize->cy - pOldSize->cy;
        WinQueryWindowPos(WinWindowFromID(hwnd, MLID_STDOUT), &ctrlpos);
        ctrlpos.cx += dx;
        ctrlpos.cy += dy;
        WinSetWindowPos(WinWindowFromID(hwnd, MLID_STDOUT), (HWND)0,
            0, 0, ctrlpos.cx, ctrlpos.cy, SWP_SIZE);
        WinQueryWindowPos(WinWindowFromID(hwnd, EFID_STDIN), &ctrlpos);
        ctrlpos.cx += dx - ENTRYFIELDBORDER;
        ctrlpos.cy -= ENTRYFIELDBORDER;
        WinSetWindowPos(WinWindowFromID(hwnd, EFID_STDIN), (HWND)0,
          0, 0, ctrlpos.cx, ctrlpos.cy, SWP_SIZE);
        WinQueryWindowPos(WinWindowFromID(hwnd, BID_ENTER), &ctrlpos);
        ctrlpos.x += dx;
        WinSetWindowPos(WinWindowFromID(hwnd, BID_ENTER), (HWND)0,
          ctrlpos.x, ctrlpos.y, 0, 0, SWP_MOVE);
        WinEnableWindowUpdate(hwnd, TRUE);
        }
      break;
      }
    // Process WM_QUERYTRACKINFO to limit the size of the dialog box.
    // This prevents the user from shrinking me down to an un-useable
    // size.  I picked the minimum size arbitrarily.
    case WM_QUERYTRACKINFO:
      {
      MRESULT mr;
      TRACKINFO *pti;
      SWP boxpos;

      mr = WinDefDlgProc(hwnd, msg, mp1, mp2);
      pti = (TRACKINFO *)mp2;
      pti->ptlMinTrackSize.x = 260L;
      pti->ptlMinTrackSize.y = 130L;
      return mr;
      }


     /* Process a message from one of the Push Buttons */
    case WM_COMMAND:
      WinDismissDlg(hwnd, 0);   /* All done */
      break;
    }
  return WinDefDlgProc(hwnd, msg, mp1, mp2); /* let OS/2 handle the rest */
  }
