
/* ccomment.c */
/* "C" and "C++" comment modifier */

/* Copyright 1994 (c) by Andrew Brault */
/* You may use this code for any purpose you want. */
/* I hold no responsibility for anything you may screw up with this code. */
/* (nyeah, nyeah, nyeah!) */

/* Syntax: */
/*  CCOMMENT <in-file> <out-file> [options, ...] */

#include <stdio.h>
#include <string.h>

static short find_switch(int arg_c, char ** arg_v, char * s);

void main(int argc, char ** argv)
{
  char line[1007];
  short continued = 0;
  short mode, count, spot;
  FILE * infile, * outfile;

  if(argc < 3) {
    printf("CComment v1.0 (c) 1994  by Andrew Brault");
    printf("\nSyntax: %s <infile> <outfile> [options, ...]", argv[0]);
    printf("\nOptions:");
    printf("\n /c       Convert C++ comments into C style /* */");
    printf("\n /strip   Strip all comments from source file");
    return;
  }
  mode = 0;
  if(find_switch(argc, argv, "c")) mode = 1;
  if(find_switch(argc, argv, "strip")) mode = 3;

  if(mode == 0) {
    printf("\nToo few parameters -- specify either /c or /strip");
    return;
  }
  infile = fopen(argv[1], "rt");
  if(infile == NULL) {
    printf("\nCould not open input file %s.", argv[1]);
    return;
  }
  fseek(infile, 0, SEEK_SET);
  outfile = fopen(argv[2], "wt");
  if(outfile == NULL) {
    printf("\nCould not open output file %s.", argv[2]);
    return;
  }
  fseek(outfile, 0, SEEK_SET);

  while(feof(infile) == 0) {
    fgets(line, 1000, infile);
    for(count = 0; count != 1000; count++) {
      if(line[count] == '\n' || line[count] == NULL) break;
      if((continued && count == 0) || line[count] == '/') {
        if(mode == 1) {
          if(line[count+1] != '/') continue;
          line[count+1] = '*';
          /* Search for newline .. */
          count += 2;
          while(line[count] && line[count] != '\n') ++count;
          line[count] = ' ';
          line[count+1] = '*';
          line[count+2] = '/';
          line[count+3] = '\n';
          line[count+4] = '\0';
          break;
        }
        else {
          /* Look for /* or // */
          if(line[count+1] == '/') {
            /* Erase the rest of the line (c++ style comment) */
            line[count] = '\n';
            line[count+1] = '\0';
            break;
          }
          if(line[count+1] == '*' || continued) {
            /* C style comment; these can span multiple lines */
            /* Look for the end */
            spot = count; /* Mark this spot */
            while(line[count] && line[count] != '\n' &&
                !(line[count] == '*' && line[count+1] == '/'))
              ++count;
            /* Truncate this line */
            line[spot] = '\n';
            line[spot+1] = '\0';
            if(line[count] == '\n' || line[count] == '\0')
              continued = 1;
            else continued = 0;
            break;
          }
        }
      }
    }
    if(!feof(infile)) fputs(line, outfile);
  }
  fclose(infile);
  fclose(outfile);
}

static short find_switch(int arg_c, char ** arg_v, char * s)
{
  short count;
  for(count = 1; count < arg_c; count++) {
    if(arg_v[count][0] == '-' || arg_v[count][0] == '/')
      if(strcmp(arg_v[count]+1, s) == 0) return 1;
  }
  return 0;
}
