/****************************************************************************\

\****************************************************************************/
#include "fginput.h"
#include "internal.h"
#include <dos.h>

int  _VMode;					//Video mode specific
int  _VType;					//Video mode type
int  _VLines;					//Number of text rows using
int  _Defined;					//Has define_parameters() been called?

int  BorderLcolor;
int  BorderRcolor;
int  BorderTcolor;
int  BorderBcolor;
int  Backcolor;
int  BackHighlightcolor;
int  TextNormalcolor;
int  TextHighlightcolor;
int  Cursorcolor;

int  Polled_Mode;
int  TextSize=8;

void (*_print)(char*,int);	//Points to fg_text() or fg_print()

/****************************************************************************\

	int restore_default_colors(void)

\****************************************************************************/
int restore_default_colors(void)
{

	if (!_Defined) return(IN_NOT_DEFINED);
	if (_VMode==NOTSUPPORTED) return(IN_NOT_SUPPORTED);

	BorderLcolor       =
	BorderBcolor       = 0;

	switch (_VMode) {

		case TEXTC:
		case COLOR16:
		case COLOR16b:
			BorderRcolor       =
			BorderTcolor       = WHITE;
			BorderBcolor       =
			BorderLcolor       = DARKGRAY;
			Backcolor          = BLACK;
			BackHighlightcolor =
			TextNormalcolor    = LIGHTGRAY;
			TextHighlightcolor = WHITE;
			Cursorcolor        = RED;
			break;

		case TEXTBW:
		case COLOR2:
			BorderRcolor       =
			BorderTcolor       =
			Backcolor          =
			TextHighlightcolor = 0;
			Cursorcolor        =
			BackHighlightcolor =
			TextNormalcolor    = 1;
			break;

		case COLOR4:
			BackHighlightcolor =
			BorderLcolor       =
			BorderBcolor       =
			BorderRcolor       =
			BorderTcolor       = 1;
			Backcolor          = 0;
			TextNormalcolor    =
			TextHighlightcolor = 3;
			Cursorcolor        = 2;
			break;

	}//Switch (mode)

	return(IN_SUCCESS);

}

/****************************************************************************\

	int define_parameters(void)

\****************************************************************************/
int define_parameters(void)
{

	int far *ptr;
	int current_mode=fg_getmode();

	switch (current_mode) {

		case 0:
		case 1:
		case 2:
		case 3:
		case -125:
			_VMode=TEXTC;
			break;

		case 7:
			_VMode=TEXTBW;
			break;

		case 9:
		case 11:
		case 12:
		case 15:
			_VMode=NOTSUPPORTED;
			break;

		case 6:
		case 17:
			_VMode=COLOR2;
			break;

		case 4:
		case 5:
			_VMode=COLOR4;
			break;

		case 16:
			TextSize=14;
			_VMode=COLOR16b;
			break;

		default:
			if (current_mode>=17&&current_mode<=29)
				_VMode=COLOR16;
			else if (current_mode==13||current_mode==14)
				_VMode=COLOR16;
			else
				_VMode=NOTSUPPORTED;
			break;

	}

	if (_VMode==TEXTC||_VMode==TEXTBW) {
		_VType=TEXT;
		_print=fg_text;
	}
	else {
		_VType=GRAPHICS;
		_print=fg_print;
	}

	_Defined=1;
	restore_default_colors();

	if (_VMode==NOTSUPPORTED) return(IN_NOT_SUPPORTED);

	/* Get number of text lines */
	ptr=MK_FP(0x40,0x84);   //BIOS data area 0x00484 stores number of lines
	_VLines=(*ptr)+1;       //Pointer is used for memory model compatibility

	return(IN_SUCCESS);

}

