/****************************************************************************\

\****************************************************************************/
#include "fginput.h"
#include "internal.h"

static char to_upper(char);

/****************************************************************************\

	int wait_key_masked(char mask)

			This function simply waits for a key to be pressed that is
		allowed by the masking character.  See FGINPUT.DOC for further info

\****************************************************************************/
int wait_key_masked(char mask)
{

	int Ch;

	asm mov ax,0x0C00;	//Clear keyboard
	asm int 0x21;


	do {

		Ch=wait_key();
		if ((Ch&0xF00))
			return(Ch);	//Allow any extended key

		if (Ch==CR||Ch==ESC||Ch==BS||Ch==TAB||Ch==' ')
			return(Ch); //Always allow CR, ESC, BS, TAB and space

		switch (mask) {
			case 'X':	//Allow any key, force to upper case
				Ch=to_upper(Ch);
			case 'x':	//Allow any key
				return(Ch);
			case '#':	//Allow only 0 thru 9 and +-,./
				if (Ch>32&&Ch<48) return(Ch);
			case '9':	//Allow only 0 thru 9
				if (Ch>47&&Ch<58) return(Ch);
				break;
			case 'N':	//Allow a - z, A - Z, 0 - 9, +-,./ and force to upper
				Ch=to_upper(Ch);
			case 'n':   //Allow a - z, A - Z, 0 - 9, +-,./
				if (Ch>32&&Ch<58) return(Ch);
			case 'A':	//Allow a - z, A - Z and force to upper
				if (mask!='n') Ch=to_upper(Ch);
			case 'a':	//Allow a - z, A - Z
				if (Ch>64&&Ch<91)  return(Ch);
				if (Ch>96&&Ch<123) return(Ch);
				break;
			case 'Y':
				Ch=to_upper(Ch);
				if (Ch=='Y'||Ch=='N') return(Ch);
				break;
		}//switch (mask)

	}while(1);	//Wait for key that fits mask

}

/****************************************************************************\

	static char to_upper(char ch)

			This function does the same thing as the Borland function
		toupper().  The difference is that when you include <ctype.h>
		you get a somewhat large index table that I think is redundant.

			If your program only uses toupper(), you are linking in a bunch
		of un-needed junk.  On the other hand, if you use many of the
		other ctype functions, you can benefit from all that junk.

\****************************************************************************/
static char to_upper(char ch)
{

	if (ch>='a'&&ch<='z') return(ch&0x5F);
	else return(ch);

}



