/*****************************************************************************
   MODULE: rcget.c
  PURPOSE: defines rcget series of functions for recio library
COPYRIGHT: (C) 1994 William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 1.10
  RELEASE: Mar 28, 1994
*****************************************************************************/

#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "_rcget.h"

#ifdef __BORLANDC__
#pragma warn -ccc
#endif

/****************************************************************************/
int                          /* return character; EOF on error              */
    rcgetc(                  /* get character at column position            */
        REC *rp,             /* record pointer                              */
        size_t col)          /* column position                             */
/****************************************************************************/
/* note: can't use rcget_fn macro since rcgetc has only one column position */
{
    int ch=EOF;              /* character */
    char *fldp;              /* field pointer */
    
    if (!_rstatus(rp)) {
        if (col >= rbegcolno(rp)) {
            rcol(rp) = col - rbegcolno(rp);
            fldp = _rfldstr(rp, 1);
            if (fldp) {
                /* loop while field empty or error cleared */
                for (;;) {
                    /* if field not empty, success */
                    if (*fldp != '\0') {
                        ch = *fldp;
                        goto done;
                    }
                    
                    /* field empty; see if errfn() replaces it */
                    fldp = _rerrs(rp, R_EMISDAT);
                    if (fldp) { 
                        continue; 
                    } else { 
                        goto done;
                    }
                }
            }
        }
        rseterr(rp, R_EINVAL);
    }
done:
    return (ch);
}

/****************************************************************************/
char *                       /* return pointer to string; NULL on error     */
    rcgets(                  /* get string between columns (inclusive)      */
        REC *rp,             /* record pointer                              */
        size_t begcol,       /* beginning column                            */
        size_t endcol)       /* ending column                               */
/****************************************************************************/
/* note: could use rcget_fn macro for rcgets, but callback error function 
         would have to return a string with at least one character in it.
         This function allows the callback error function to return an
         empty string. */
{
    char *retp=NULL;         /* return pointer */
    char *fldp;              /* pointer to field buffer */
    
    if (!_rstatus(rp)) {
        if (endcol >= begcol && begcol >= rbegcolno(rp)) {
            rcol(rp) = begcol - rbegcolno(rp);
            fldp = _rfldstr(rp, endcol-begcol+1);
            if (fldp) {
                    
                /* if field not empty, success */
                if (*fldp != '\0') {
                    retp = fldp;
                    goto done;
                    
                /* field empty; see if errfn() replaces it */
                } else {
                    fldp = _rerrs(rp, R_EMISDAT);
                    if (fldp) retp = fldp;
                    goto done;
                }
            }
        }
        rseterr(rp, R_EINVAL);
    }
done:
    return (retp);
}

/****************************************************************************/
/* rcget_fn() - define other rcget functions                                */
/****************************************************************************/

rcget_fn( float, rcgetf, 0.0, double, strtod, FLT_MIN, FLT_MAX)
rcget_fn(double, rcgetd, 0.0, double, strtod, BUILTIN, BUILTIN)
