/*****************************************************************************
   MODULE: recio.h
  PURPOSE: header file included in application
COPYRIGHT: (C) 1994 William Pierpoint
  VERSION: 1.10
  RELEASE: Mar 28, 1994
*****************************************************************************/

#ifndef RECIO_H
#define RECIO_H

typedef struct {
        int      r_fd;       /* descriptor */
        unsigned r_flags;    /* status flags */
        FILE    *r_fp;       /* file pointer */
  const char    *r_fname;    /* pointer to name of file */
        long     r_recno;    /* current record number */
        size_t   r_fldno;    /* current field number */
        size_t   r_colno;    /* current column number in current record */
        size_t   r_recsiz;   /* size of record buffer */
        size_t   r_reclen;   /* current length of record buffer */
        char    *r_recp;     /* pointer to record buffer */
        size_t   r_fldsiz;   /* size of field buffer */
        char    *r_fldp;     /* pointer to field buffer */
        int      r_fldch;    /* field separator character */
        int      r_txtch;    /* text delimiter character */
        int      r_cxtno;    /* context number */
} REC;

/* constant expression macros */
#define RECBUFSIZ  80        /* minimum size of record buffer */
#define FLDBUFSIZ  20        /* minimum size of field buffer */
#define RECFLDCH   ' '       /* record field separator character */
#define RECTXTCH   ' '       /* text delimiter character */

#define ROPEN_MAX  5         /* max no of rec streams open at same time */

/* enumerate errors */
enum {
    R_EINVAL=1,              /* invalid argument value */
    R_EINVDAT,               /* invalid data */
    R_EMISDAT,               /* missing data */
    R_ENOMEM,                /* could not allocate memory */
    R_ENOREG,                /* unable to register function (atexit full) */
    R_ERANGE                 /* data out of range */
};

/* define predetermined record streams */
extern REC *recin;           /* recin record pointer */
#define RECIN  -1            /* recin context number */

/* record status flags definitions */
#define _R_COL    1      /* beginning column flag */
#define _R_EOF    2      /* end-of-file flag */

/* functions implemented as macros */
#define rskipfld(rp)     (rskipnfld((rp), 1))
#define rnames(rp)       ((rp)->r_fname)
#define rrecs(rp)        ((rp)->r_recp)
#define rflds(rp)        ((rp)->r_fldp)
#define rrecno(rp)       ((rp)->r_recno)
#define rfldno(rp)       ((rp)->r_fldno)
#define rcolno(rp)       ((rp)->r_colno + rbegcolno(rp))
#define rcxtno(rp)       ((rp)->r_cxtno)
#define reof(rp)         ((rp)->r_flags & _R_EOF)
#define rbegcolno(rp)    ((rp)->r_flags & _R_COL)

#define rgeti(rp)        (rbgeti( (rp), 10))
#define rgetl(rp)        (rbgetl( (rp), 10))
#define rgetui(rp)       (rbgetui((rp), 10))
#define rgetul(rp)       (rbgetul((rp), 10))

#define rcgeti(rp, begcol, endcol)    (rcbgeti( (rp), (begcol), (endcol), 10))
#define rcgetl(rp, begcol, endcol)    (rcbgetl( (rp), (begcol), (endcol), 10))
#define rcgetui(rp, begcol, endcol)   (rcbgetui((rp), (begcol), (endcol), 10))
#define rcgetul(rp, begcol, endcol)   (rcbgetul((rp), (begcol), (endcol), 10))

#ifdef __cplusplus
extern "C" {
#endif
/* function prototypes */
/* source: recio.c */
extern void  rclearerr(REC *rp);
extern int   rclose(REC *rp);
extern int   rcloseall(void);
extern int   rerror(REC *rp);
extern int   risvalid(REC *rp);
extern char *rgetrec(REC *rp);
extern REC  *ropen(const char *filename, const char *mode);
extern int   rsetbegcolno(REC *rp, int colno);
extern int   rsetcxtno(REC *rp, int cxtno);
extern int   rseterr(REC *rp, int errnum);
extern void  rseterrfn(void(*rerrfn)(REC *rp));
extern int   rsetfldch(REC *rp, int ch);
extern int   rsetfldsiz(REC *rp, size_t fldsize);
extern int   rsetfldstr(REC *rp, char *s);
extern int   rsetrecsiz(REC *rp, size_t recsize);
extern int   rsettxtch(REC *rp, int ch);
extern int   rskipnfld(REC *rp, size_t num);

/* source: rget.c */
extern int    strtoc(const char  *nptr, char **endptr);
extern int    rgetc(REC *rp);
extern char  *rgets(REC *rp);
extern float  rgetf(REC *rp);
extern double rgetd(REC *rp);

/* source: rbget.c */
extern int           rbgeti( REC *rp, int base);
extern unsigned int  rbgetui(REC *rp, int base);
extern long          rbgetl( REC *rp, int base);
extern unsigned long rbgetul(REC *rp, int base);

/* source: rcget.c */
extern int    rcgetc(REC *rp, size_t col);
extern char  *rcgets(REC *rp, size_t begcol, size_t endcol);
extern float  rcgetf(REC *rp, size_t begcol, size_t endcol);
extern double rcgetd(REC *rp, size_t begcol, size_t endcol);

/* source: rcbget.c */
extern int           rcbgeti( REC *rp, size_t begcol, size_t endcol, int base);
extern unsigned int  rcbgetui(REC *rp, size_t begcol, size_t endcol, int base);
extern long          rcbgetl( REC *rp, size_t begcol, size_t endcol, int base);
extern unsigned long rcbgetul(REC *rp, size_t begcol, size_t endcol, int base);
#ifdef  __cplusplus
}
#endif

#endif
