FUNCTION GetProgramName$ PUBLIC

  LOCAL PSPAddr%, Offset%, EndPoint%, Temp$

  PSPAddr% = GetPSP%          ' call the GetPSP% function to locate the segment of the PSP
  DEF SEG = PSPAddr%
  DEF SEG = PEEKI(44)         ' location of the environment is at offset 44 in the PSP
  DO                          ' search the environment for the start of the file name
    IF PEEK(Offset%) = 0 THEN        ' the start of the executable file name is marked with 2 nulls
      IF PEEK(Offset% + 1) = 0 THEN
       INCR Offset%, 4
       EXIT LOOP
      END IF
    END IF
    INCR Offset%
  LOOP
  EndPoint% = Offset%
  DO                          ' search for the end of the file name
    IF PEEK(EndPoint%) = 0 THEN EXIT LOOP
    INCR EndPoint%
  LOOP
  Temp$ = PEEK$(Offset%, (EndPoint% - Offset% + 1))
  DEF SEG                     ' restore default data segment

  GetProgramName$ = Temp$

END FUNCTION
'----------------------------------------------------------------------------
FUNCTION GetPSP% LOCAL PUBLIC

  REG 1, &H62 * 256   ' set AH to 62h
  CALL INTERRUPT &H21 ' call DOS services
  GetPSP% = REG(2)    ' PSP segment is returned in BX

END FUNCTION
'----------------------------------------------------------------------------
SUB SplitPath(FilePath$, Path$, FileName$) PUBLIC

  LOCAL StartPos%, c%

  StartPos% = 0
  FOR c% = LEN(FilePath$) TO 1 STEP -1
    IF MID$(FilePath$, c%, 1) = "\" OR MID$(FilePath$, c%, 1) = ":" THEN
      StartPos% = c%
      EXIT FOR
    END IF
  NEXT c%

  FileName$ = RIGHT$(FilePath$, (LEN(FilePath$) - StartPos%))
  Path$ = LEFT$(FilePath$, StartPos%)

END SUB
