FUNCTION Printer%(Port%)PUBLIC

LOCAL Status%

REG 1, &H0200                           ' set AH to 2
REG 4, Port%                            ' set DX to the parallel port number
CALL INTERRUPT &H17                     ' call BIOS interrupt 17h
Status% = REG(1) \ 256                  ' Status% is a byte read from AH

IF (Status% AND &B00000001) THEN Printer% = 1  ' printer has timed out
IF (Status% AND &B00001000) THEN Printer% = 2  ' printer has had an I/O error
IF (Status% AND &B00100000) THEN Printer% = 3  ' printer is out of paper
IF (Status% AND &B10000000) = 0 THEN Printer% = 4  ' printer is OK

END FUNCTION
