'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        PBClone  Copyright (c) 1990-1994  Thomas G. Hanlin III        |
'   |                                                                      |
'   +----------------------------------------------------------------------+



DECLARE FUNCTION AscM% (St$, BYVAL Posn%)
DECLARE SUB Reverse (St$)



FUNCTION CreditCard$ (CardNumber$)

   Result$ = ""

   ' -- Clean up card number: remove non-numeric characters
   CardNr$ = ""
   FOR tmp% = 1 TO LEN(CardNumber$)
      ch% = AscM(CardNumber$, tmp%) - 48
      IF ch% >= 0 AND ch% <= 9 THEN
         CardNr$ = CardNr$ + CHR$(ch%)
      END IF
   NEXT

   ' -- Evaluate card type and check for appropriate number of digits
   CardType% = AscM(CardNr$, 1)
   IF CardType% >= 0 THEN
      IF LEN(CardNr$) >= AscM("<<<KIIL<<K", CardType% + 1) - 60 THEN
         IF LEN(CardNr$) <= AscM("<<<KLLL<<L", CardType% + 1) - 60 THEN
            Result$ = LTRIM$(MID$("            AMEXVISAMCARDISC        DINE", CardType% * 4 + 1, 4))
            Check% = AscM(CardNr$, LEN(CardNr$))
            CardNr$ = LEFT$(CardNr$, LEN(CardNr$) - 1)
            Reverse CardNr$
         END IF
      END IF
   END IF

   ' -- See if digits form a valid card number
   IF LEN(Result$) THEN
      total% = 0
      FOR tmp% = 1 TO LEN(CardNr$)
         total% = total% + (AscM("01234567890246813579", AscM(CardNr$, tmp%) + (tmp% AND 1) * 10 + 1) - 48)
      NEXT
      total% = (10 - total% MOD 10) MOD 10
      IF total% <> check% THEN
         Result$ = ""
      END IF
   END IF

   CreditCard$ = Result$

END FUNCTION
