(******************************************************************************
*                                    calc                                     *
* ISoft D&M CALC - Parser demo program.                                       *
* (c) 1992, Loewy Ron.                                                        *
* Version 2.0, Oct. 1993.                                                     *
******************************************************************************)
program calc;

uses
   parser
   ;

var
   exitFlag,
   validity : boolean;
   s        : string;
   result   : real;

(******************************************************************************
*                                  makeUpper                                  *
* receive a string, and convert it to upper-case                              *
******************************************************************************)
function makeUpper(s : string) : string;
var
   i : byte;
begin
   for i := 1 to length(s) do
      if (s[i] in ['a' .. 'z']) then
         s[i] := upCase(s[i]);
   makeUpper := s;
end; {makeUpper}

begin
   writeln('CALC V2.0, ISoft D&M, Parser demo program');
   writeln;
   writeln('Enter mathematical expression, or QUIT/EXIT to DOS');
   writeln;
   exitFlag := false;
   repeat
      write('CALC> ');
      readln(s);
      s := makeUpper(s);
      if ((copy(s, 1, 4) = 'QUIT') or (copy(s, 1, 4) = 'EXIT')) then 
         exitFlag := true
      else begin
         result :=  getExpr(s, validity);
         if (not validity) then
            writeln('Error in expression, at position ', errAt)
         else
            writeln('RSLT> ', result);
      end; { not a QUIT command }
   until (exitFlag);
   writeln;
   writeln('Thank you for using CALC, ISoft D&M');
   writeln;
end.
