(** Pull Down Menus For the Text Windowing Interface v2.01 **)
(** (C) David Pabst 1994 All Rights Reserved               **)

Unit Menus;
   {  THIS UNIT WILL NOT WORK WITH TWI2.TPU - THIS UNIT IS MEANT ONLY
      FOR TWI.TPU - TWI2.TPU HAS THIS UNIT BUILT INTO IT }

Interface
Uses Crt;
Var
 MenuA,Menub,MenuC,Menud,MenuE,MenuF,MENUG : String[10];
 Hfc, Hbc, Hc, Lc, Fgc, BGC : Integer;
  (**************************************************************************
   ** HFC - Highlight Foreground Color ** HBC - Highlight Background Color **
   ** HC  - Highlight Color            ** LC  - Line Color                 **
   ** FGC - Foreground Color           ** BGC - Background Color           **
   **************************************************************************
   ** Menua..menug are the options on the menu bar at the top of the screen**
   **************************************************************************)


 Procedure DrawMenus;
  (* Draws the menu bar at the top of the screen *)
  (* YOU MUST INTIALIZE MENUA...MENUG FOR IT WORK *)

 Procedure MoveToLocal(MoveToplace : integer);
  (* Moves you to one of the options on the menu bar *)
  (* Refer: CleanOldLocation *)
  (* Example: MoveToLocal(1); Would move you to MENUA *)

 Procedure CleanOldLocation(var oldLocation:integer);
  (* Removes the cursor placed by MOVETOLOCAL *)
  (* Refer: MoveToLocal *)
  (* Example: CleanOldLocation(1); Would take the highlighted cursor off of
     MENUA that was pot by MOVETOLOCAL *)

 Procedure DrawSubMenu(var Suba,Subb,Subc,Subd,Sube,Subf,Subg,Subh: string; x,y,lgth: integer);
  (* Draws a sub menu of up to 8 options; SUBA..SUBH are the options *)
  (* X,Y is the position of the submenu. LGTH is the length of the submenu *)
  (* Refer: WhereCursorIsReWrite, OldPlaceRewrite *)
  (* Example: DrawSubMenu(SubA,SubB,SubC,SubD,SubE,SubF,SubG,SubH,1,2,8); *)

 Procedure WhereCursorIsReWrite(Placex,Placey : integer; option : string);
  (* Though the procedure's name is strange, this basically writes over *)
  (* an option on the screen to make it look like it is highlighted *)
  (* Refer: DrawSubMenu, OldPlaceRewrite *)
  (* Example: WhereCursorIsRewrite(3,3,SUBA); *)

 Procedure OldPlaceReWrite(Placex,Placey: integer; option: string);
  (* Goes back over where "WHERECURSORISREWRITE" and changes the option *)
  (* in the submenu back to being normal, not highlighted *)
  (* Refer: DrawSubMenu, WhereCursorIsRewrite *)

Implementation

Procedure DrawMenus;
Begin
 GotoXY(1,1);
 TextColor(FGC);
 TextBackGround(BGC);
 GotoXY(1,1);
 Write(menua);
 GotoXY(10,1);
 Write(menub);
 GotoXY(20,1);
 Write(menuc);
 GotoXY(30,1);
 Write(menud);
 GotoXY(40,1);
 Write(menue);
 GotoXY(50,1);
 Write(menuf);
 GotoXY(60,1);
 Write(menug);
End;


(* ----------- *)
Procedure MoveToLocal(MoveToplace : integer);     { Moves highlighted block }
Begin
 If moveToplace = 1 then Begin                      { Information }
  GotoXY(1,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menua);
 End;
 If moveToplace = 2 then Begin                      { System }
  GotoXY(10,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menub);
 End;
 If moveToplace = 3 then Begin                      { Mail }
  GotoXY(20,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menuc);
 End;
 If moveToplace = 4 then Begin                      {  }
  GotoXY(30,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menud);
 End;
 If moveToplace = 5 then Begin                      { Special }
  GotoXY(40,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menue);
 End;
 If moveToplace = 6 then Begin                      {  Setup  }
  GotoXY(50,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menuf);
 End;
 If moveToplace = 7 then Begin                      { Help  }
  GotoXY(60,1);
  TextBackGround(hbc);
  TextColor (hfc);
  Write (menug);
 End;
End;
(* ----------- *)
Procedure CleanOldLocation(var oldLocation:integer);
Begin
 If oldLocation = 1 then Begin
  GotoXY(1,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menua);
 End;
 If oldLocation = 2 then Begin
  GotoXY(10,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menub);
 End;
 If oldLocation = 3 then Begin
  GotoXY(20,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menuc);
 End;
 If oldLocation = 4 then Begin
  GotoXY(30,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menud);
 End;
 If oldLocation = 5 then Begin
  GotoXY(40,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menue);
 End;
 If oldLocation = 6 then Begin
  GotoXY(50,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menuf);
 End;
 If oldLocation = 7 then Begin
  GotoXY(60,1);
  TextBackGround(BGC);
  TextColor (FGC);
  Write (menug);
 End;

End;
(* ----------- *)
Procedure DrawSubMenu(var Suba,Subb,Subc,Subd,Sube,Subf,Subg,Subh: string; x,y,lgth: integer);
var
 i,l : integer;
Begin
 TextColor(lc);
 TextBackGround(BGC);
 GotoXY(x,y);
 Write('͸');
 for i := (y+1) to (lgth+2) do
  Begin
    GotoXY(x,i);
    TextBackGround(BGC);
    TextColor(lc);
    Write('              ');
    TextColor(FGC);
   End;
   GotoXY(x,(lgth+3));
   TextColor(lc);
   Write(';');

   TextBackGround(black);
   TextColor(7);
   for i := (y+1) to (lgth+4) do
   Begin
    GotoXY((x+16),i);
    Write('');
   End;

  i:=x+2;
  l:=lgth+4;
  GotoXY(i,l);
  Write('');

   TextBackGround(BGC);
   TextColor(FGC);
   GotoXY(x+2,y+1);
   Write(Suba);
   GotoXY(x+2,y+2);
   Write(Subb);
   GotoXY(x+2,y+3);
   Write(Subc);
   GotoXY(x+2,y+4);
   Write(Subd);
   GotoXY(x+2,y+5);
   Write(Sube);
   GotoXY(x+2,y+6);
   Write(Subf);
   GotoXY(x+2,y+7);
   Write(Subg);
   GotoXY(x+2,y+8);
   Write(Subh);
End;
(* ----------- *)
Procedure WhereCursorIsReWrite(Placex,Placey : integer; option : string);
Begin
 GotoXY(Placex,Placey);
 TextBackGround(hc);
 TextColor(FGC);
 Write(option);
 TextColor(FGC);
 TextBackGround(BGC);
End;
(* ----------- *)
Procedure OldPlaceReWrite(Placex,Placey: integer; option: string);
Begin
 GotoXY(Placex,Placey);
 Write(option);
End;

(* ----------- *)

Begin
End.
