/****************************************************************************\
*                                                                            *
*  common.c -- functions we use a lot, such as video mode initialization     *
*  and termination, random number generator, etc.                            *
*                                                                            *
\****************************************************************************/

#define common_c
#include "defs.h"

/****************************************************************************\
*                                                                            *
*  file_exists -- is the file on the disk?                                   *                                       *
*                                                                            *
\****************************************************************************/

int file_exists(char *filename)
{
   if (access(filename,0) == 0)
      return(TRUE);
   else
      return(FALSE);
}

/****************************************************************************\
*                                                                            *
*  flushkey -- flush out the keystroke buffer                                *
*                                                                            *
\****************************************************************************/

void flushkey()
{
   unsigned char key,aux;

   fg_intkey(&key,&aux);
   while (key+aux > 0) fg_intkey(&key,&aux);
}

/****************************************************************************\
*                                                                            *
*      init_graphics -- initialize the graphics environment                  *
*                                                                            *
\****************************************************************************/

void init_graphics(int mode)
{
   /* initialize Fastgraph for the specified video mode */

   if (fg_testmode(mode,2) == 0)
   {
      printf("Required video mode not available on this system.\n");
      exit(1);
   }
   old_mode = fg_getmode();
   fg_setmode(mode);

   /* set up visual and hidden pages */

   fg_setpage(VISUAL);
   fg_setvpage(VISUAL);
   fg_sethpage(HIDDEN);

   clockspeed = fg_measure();
   stall_time = 0;

   white= 15; red = 12; grey = 8; black = 0; blue = 9; dkblue = 1;
}

/****************************************************************************\
*                                                                            *
*  init_mouse -- initialize the mouse if present                             *
*                                                                            *
\****************************************************************************/

init_mouse()
{
   if (fg_mouseini() > 0)
   {
      mouse = TRUE;
      xmouse = (fg_getmaxx()+1)/2;
      ymouse = (fg_getmaxy()+1)/2;
      fg_mousemov(xmouse,ymouse);
      fg_mousevis(ON);
      return(TRUE);
   }
   else
   {
      mouse = FALSE;
      return(FALSE);
   }
}

/****************************************************************************\
*                                                                            *
*  quit_graphics -- return the computer to its original state                *
*                                                                            *
\****************************************************************************/

void quit_graphics()
{
   fg_mousefin();
   fg_setmode(old_mode);
   fg_reset();

   exit(0);
}
