/* ************************************************************** */
/* redemo1.c For Turbo C - Demonstrates how to access a resource  */
/*                         file's header information.             */
/*                                                                */
/* ************************************************************** */

#include <stdio.h>

struct resheadrec {
    char         rfid[3];    /* resource file id - RES    */
    unsigned int resitems;   /* number of resource items  */
  };

struct resitemrec {
    int  rt;         /* resource type */
    char rid[12];    /* resource id   */
    long offset;     /* file offset   */
    long length;     /* file size     */
  };


void dis_res_header(char *filename)
{
 FILE *F;
 int i;
 struct resitemrec res;
 struct resheadrec resh;

 F=fopen(filename,"rb");

 if (F!=NULL)
 {
   fread(&resh,sizeof(resh),1,F);               /* res header       */
   printf(" RES ID = %.3s \n RES ITEMS = %u \n",resh.rfid,resh.resitems);
   for(i=0;i<resh.resitems;i++)
   {
     fread(&res,sizeof(res),1,F);               /* res item record  */
     printf(" ITEM# %d TYPE= %u ID= %.12s OFFSET= %lu LENGTH= %lu \n",
              i+1,res.rt,res.rid,res.offset,res.length);
   }
   fclose(F);
 }
}


void main()
{
  dis_res_header("pics.res");
  getch();
}
