/* ************************************************************ */
/* disxgf.c For Turbo C - Demonstrates how to display XGF files */
/*            that are larger than 64K                          */
/*                                                              */
/* Use Raster Clip/Rastport to convert PCX files to XGF format. */
/*                                                              */
/* ************************************************************ */

#include <stdio.h>
#include <graphics.h>


int huge DetectVGA256(void)
{
 return(0);   /* change 0 to other value for SVGA modes */
}

void setvga256(void)
{
 int gm,driver = DETECT;
 installuserdriver("svga256",DetectVGA256);
 initgraph(&driver,&gm,"");
}

void setvga16()
{
 int driver = VGA,
     mode = VGALO;

 initgraph(&driver, &mode, "");
}

void dis_xgf(int x, int y, char *filename)
{
 FILE *F;
 unsigned int width,height,bpl,i;
 int scanline[1030];

 F=fopen(filename,"rb");
 if (F!=NULL)
 {
   fread(&width,2,1,F);
   fread(&height,2,1,F);
   scanline[0]=width;
   scanline[1]=0;
   if (getmaxcolor()==255)
   {
     bpl=width+1;
   }
   else
   {
     bpl=imagesize(0,0,width,0)-6;
   }
   for(i=0;i<height;i++)
   {
     fread(&scanline[2],1,bpl,F);
     putimage(x,y+i,scanline,0);
   }
   fclose(F);
 }
}


void main()
{
  setvga16();          /* replace with setvga256 for 256 color XGF files */

  setfillstyle(SOLID_FILL,BLUE);
  bar(0,0,getmaxx(),getmaxy());
  dis_xgf(0,0,"image.xgf");
  getch();
  closegraph();
}
