(* ******************************************************************** *)
(* readxgf.pas For Turbo Pascal - Demonstrates how to display XGF files *)
(*                                that are 64K or less. Use disxgf.c    *)
(*                                for files that are greater than 64K   *)
(*                                                                      *)
(* Use Raster Clip/Rastport to convert PCX files to XGF format.         *)
(*                                                                      *)
(* ******************************************************************** *)

Program readxgf;
  uses crt,graph;

{$F+}
Function DetectVGA256 : integer;
begin
    DetectVGA256:=0;
end;
{$F-}


Procedure setVGA256;
Var
 gd,gm : Integer;
begin
 gd:=InstallUserDriver('svga256',@detectvga256);
 gd:=Detect;
 Initgraph(gd,gm,'');
end;


Procedure setvga16;
var
 gd,gm : integer;
begin
 gd:=VGA;
 gm:=VGALO;

 initgraph(gd, gm, '');
end;

Procedure read_xgf(x,y : Word; filename : string);
var
 F : File;
 imgBuf : Pointer;
 size   : word;
 error  : word;
begin
{$I-}
 Assign(F,filename);
 Reset(F,1);
 error:=IORESULT;
 if (error=0) then
 begin
   size:=filesize(F);
   getmem(imgbuf,size);
   blockread(F,imgBuf^,size);
   close(F);
   putimage(x,y,imgBuf^,NormalPut);
   freemem(imgBuf,size);
 end;
{$I-}
end;

begin
  setvga16;          (* replace with setvga256 for 256 color XGF files *)
  setfillstyle(SOLIDFILL,BLUE);
  bar(0,0,getmaxx,getmaxy);
  read_xgf(0,0,'image2.xgf');
  repeat until keypressed;
  closegraph;
end.
