/* Sear.C              search files 3Jun91 Boyer-Moore Search Sedgwick p287*/
/*                                           C.T.Skinner                   */
/*                                           (c)Cybanim NSW 7 Oct 93       */
/*                                           4/29B Nelson St NSW Australia */
/*                                           ph +02-3635884                */
/*                                           CompuServe 100033,132         */
/* uses   \asm\seara.asm */

// include <alloc.h>   /* calloc , free */
// include <stdlib.h>
#include <malloc.h>   /* malloc , _memavail */
# include <string.h>   /*  */
# include <dos.h>         /* time  */
# include <conio.h>
# include <stdio.h>
#include  <dir.h>             /* findfirst findnext */
# include <io.h>         /* low level open close..f */
# include <fcntl.h>      /* open mode */

/* External prototypes in searc.asm */
typedef unsigned char byte ;
typedef byte har;
typedef unsigned int word ;

word pascal searI ( char *targ , word targz, char *buf,  word bufz) ;
                    /* search buf for targ */
void pascal bufup ( char *buf,  word bufz) ;
                     /* convert buf to unppercase */
void pascal targi ( char *targ,  word targz) ;
                     /* initialize skip */

/* local proto */
int  wildfi (char * fin ) ;
int  wild   (char * fin) ; /* true if any * ? */
void exit   (int ) ;
int  fitail (char * fin) ; /* "aaaa bbb.cccddddd" -> bbb.ccc\0 */
void putp   (char ch );  /*  printables */
int  searf  (char *fin, char * targ, word tz ) ;
int  searp  (char * fin ) ;
int  getparms(void) ;
void shohelp (void) ;
void pause   (void) ; /* needed in Prime.C */
int  ropen   (char *rname ); /* open a file to Read , return handle or 0 */
void tat     (char b ) ;

#define M  257
#define N  65533  /*  buffer size */
typedef unsigned long int dword ;

 char skip [256] ; /*  xlat table Extrn in seara */
 char finin [67] ;
 char finil [67] ;
 char filez [67] ;
 unsigned int j,tz,pz,f ;
 char    targ[M] ;  /* 0..256 */
 int  targz ;
 int  toup ;
 char ch ;
 char *po ;
 word bufz = N ;
 FILE *fp ;
 char odir[MAXPATH];
 char *pbuf;
 int subdirz = 0, casez = 0, linez = 0 ; /* parameters */
 int fitot ;

int main()     /* mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm */
    {
    dword cor ;
    int j ;

    cor = coreleft() ;
    if (cor > 0x800)  cor = cor - 0x800 ; else exit(2) ;
    if ( (word)cor < bufz ) bufz = (word)cor ;
    if ((pbuf = (char *) malloc(bufz)) == NULL)
       printf("\n\r Memory malloc error 1 \n") ;
    if (! getparms ())        {   /*  target = parm 1     filez = parm 2 */
       shohelp() ;  exit(3) ; }
    targz = strlen(targ) ;
    if (casez) bufup(targ,targz) ;
    targi (targ,  targz) ;  /* initialize skip table */
    odir[0] = 00;

    if  (filez[0] == '@' )
       {   /* if  filez starts with @ it is a list of files */
       strcpy (finil,&filez[1]) ;
       if ((fp = fopen(finil,"rt")) == NULL)                        {
           printf ("\n error opening %s errno %d ",finil,errno) ;
           if ( errno == 8 )                                      {
              cor = coreleft() ;
              printf ("not enough memory, coreleft = %lX ",cor) ;  } }
       else
           {
           while (fgets(finin,sizeof(finin),fp))
             {
             fitail(finin) ; /* "zzz aaaaa.bbbccccc" -> "aaaaa.bbb\0" */
             wildfi(finin) ;
             }
          fclose(fp) ;
          }
      }  /* @ */
  else
       wildfi (filez) ;

    return 0 ;
    } /* main zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz    */
int wildfi ( char * fin )
    {
    struct ffblk fbk;
    int done, dirdone;
    struct directory {
                    char              dn [MAXPATH] ;
                    struct ffblk      fb ;
                    struct directory  *next  ;
                    } *fird, *newd ;
    fird = NULL ;
    done = findfirst(fin,&fbk,7);  /* find ervery matching file */
    while (!done)
       {
       // printf("%s ",&fbk.ff_name) ; //ttt
       fitot = fitot + 1 ;
       searp(&fbk.ff_name) ;
       done = findnext(&fbk);
       }
    /*    find each subdirectory in current directory*/
    dirdone = !subdirz ;
    dirdone = (!subdirz) || findfirst("*.*",&fbk,FA_DIREC);  /* find every dir */
    while (!dirdone)
       {
       if (((fbk.ff_attrib & FA_DIREC)>0)      &&
           (strcmp(&fbk.ff_name,"." ) != 0 )   &&
           (strcmp(&fbk.ff_name,"..") != 0 )      )
           {
           // get current dir    push curent dir  and fbk
           getcwd(odir,MAXPATH); /* eg c:\asm\sear */
           if ((newd = malloc(sizeof(struct directory))) == NULL) {
             fprintf(stderr," \n memory alloc error member Dir List ") ;
             exit(4) ; }
           memcpy (&(newd->fb),&fbk,sizeof(struct ffblk)) ;
           strcpy (&(newd->dn),odir) ;
           newd->next = fird ;
           fird = newd ;
           /* change to new directory */
           if (odir[strlen(odir)-1] != '\\') strcat(odir,"\\") ;
           strcat(odir,fbk.ff_name) ;
           if (chdir(odir)) {
               printf("\n cant change to %s ",odir) ;
               perror("chdir()"); exit(5); }
           /* recurse back into wildfi */
           wildfi(fin) ;
           /* when no more sub-directories, pop a sub-dir & its fbk context */
           /* then look for more sub-dirs at the lower context */
           }
       if (fird != NULL)
           {
           memcpy (&fbk,&(newd->fb),sizeof(struct ffblk)) ;
           strcpy (odir,&(newd->dn)) ;
           newd = fird ;
           fird = fird->next ;
           free (newd) ;
           if (chdir(odir)) {
               printf("\n cant change to %s ",odir) ;
               perror("chdir()"); exit(6); }
           }
       dirdone = findnext(&fbk);
       } /* while not dirdone */
    return(1);
    } /* wildfi */


int searp ( char * fin )
    {
    return ( searf(fin,targ,strlen(targ))) ;
    } /* searp */

int searf ( char *fin, char * targ, word targz )
    {
    int fih,firf ;
    long re ;
    word bj,j,h,k,f,rew ;
    fih = ropen(fin) ;
    if (fih <= 0 ) return(0) ; /* false = bad return */
    bj = 0 ;
    firf = 1 ; /* first find for this file */
    while (! eof(fih) )
	{
	re = read(fih,pbuf,bufz) ;
	if (re == -1 )
	    {
	    fprintf(stderr,"\n\r  error %d reading %s \n",errno,fin) ;
             return(0) ; /* false = bad return */
	    }
        if ( re > 0 )
            {
            rew = (word)re ;
            if (casez) bufup(&pbuf[bj],rew) ;
            if ( rew < bufz )  memset(&pbuf[rew],0,bufz-rew) ;
            do  {
                f = searI ( targ,targz,&pbuf[bj],rew) ;
                if (f > 0)                          {
                    if (firf )                            {
                        firf = 0 ;
                        printf( "\n") ;
                        if (strlen(odir) > 0 )
                            printf( "%s\\",odir) ;
                        printf( "%s",fin) ;  }
                    rew = rew + f ;
                    f  = f + bj ;
                    bj = f ;
                    if (linez)   {
                        printf( "\n") ;
                        if (f < 39)        {
                            j = 0 ;
                            h = 38-f ;
                            for (k = 1; k <= h ; k++) putp (' ') ;
                            h = 77-h ;     }
                        else               {
                            j = f - 38 ;
                            h = f + 40 ;   }
                        for (k = j ; k <= h ; k++)
                            putp (pbuf[k]) ;
                               } /* if linez */
                    } /* f > 0 */
                } /* d0 */
            while ( f > 0 ) ;
            } /* re >  0 */
        } /* eof fih */
        close(fih) ;
        return(1) ; /* true = good return */
    } /* searf */

void putp( char ch )  /*  printables */
  {
  if (   (ch == 0)  || (ch == 7)  || (ch == 8)
      || (ch == 10) || (ch == 13) || (ch == 255) )
      ch = 250 ;
  putch(ch) ;
  } /* putp */


int getparms()
    {
    char   aa[255] ;
    int j,k ;
    /*   generalize: -c or /c  interspersed amongst string parms  */
    /* argc 3 means progname + 2 params */
    /* Sear  targ filez  [Params lid]  */
    toup = 1 ; /* true */
    if (_argc < 3) return(0) ;  /* false = bad return */
    k = 1 ; /* index of stringparms, must be 2of   ie command and filename */
    for ( j = 1 ; j < _argc ; j++)
	{
	strcpy (aa,_argv[j]) ;
	if (( aa[0] == '/') || (aa[0] == '-'))
	    { /*set some parm switches */
            /* int subdirz = 0 ; casez = 0 ; linez = 0 ; /* parameters */
            if (strrchr(aa,'d')) subdirz = 1 ;
            if (strrchr(aa,'i')) casez = 1 ;
            if (strrchr(aa,'l')) linez = 1 ;
	    } /* - / */
	else
	    { /* parmstring */
	    if ( k == 1 )		{
		strcpy(targ,aa); k++ ;	}
	    else if (k == 2)            {
		k++; strcpy(filez,aa) ; } /* valid filechars ??  */
	    else return(0) ; /* error, only 2 parmstrings */
	    }
        } /* for j */
	return(1) ;     /* good return */
    } /* getparsms  */

void shohelp()
    {
    window(1,2,80,25) ;
    tat(0x70) ;
    clrscr() ;
cprintf(    "\n\r  Sear  1.0                             Search   (c)Cybanim 7 Oct 93 ") ; clreol() ;
cprintf("\n\r\n\r  Usage:    Sear target  filez   [-options] ") ; clreol() ;

cprintf("\n\r\n\r         target:    string to search for"); clreol();
cprintf("\n\r\n\r         filez:     file to search ");   clreol();
cprintf(    "\n\r                    or @filelist = list of files to search"); clreol();

cprintf("\n\r\n\r         Options    l   show line with target (default = filename only)"); clreol() ;
cprintf(    "\n\r                    i   case insensitive      (default = case sensitive)"); clreol() ;
cprintf(    "\n\r                    d   sub-directories       (default = current dir only)"); clreol() ;

cprintf("\n\r\n\r         eg:    Sear -i frog Pond.Txt"); clreol() ;
cprintf(    "\n\r                search for FROG in POND.TXT") ; clreol() ;
    }

void pause () /* needed in Prime.C */
  {
  char ch;
  putch('?') ; putch(8) ;  ch = getch();  putch(' ') ;
  if (ch == 0x1B)  exit(7) ;
  }
int ropen ( char *rname ) /* open a file to Read , return handle or 0 */
    {
    int j ;
    if (access(rname,04) )  // -1 = Not found         0 = found
	{
	fprintf(stderr,"\n\r File  %s not found \n",rname) ;
	return(0)  ;
	}
    if ((j = open(rname,O_BINARY | O_RDONLY)) == -1 )
	{
	fprintf(stderr,"\n\r  error %d opening %s \n",errno,rname) ;
	return(0) ;
	}
    return(j) ;
    } /* ropen */
void tat ( char b )
	{
	textcolor (b & 0x0F) ;
	textbackground (b >> 4) ;
	}

int  fitail(char * fin)  /* "aaaa bbb.cccddddd" -> bbb.ccc\0 */
    {
    char *p, *q ;
    p = strchr(fin, '\r') ;
    if (p) *p = 0 ;
    p = strchr(fin, '.') ;
    q = strchr(fin, ':') ;
    /* we want to use the output of grep  as a file list */
    /* grep produces    "file ffff.c:\r"  */
    /* so look for : after . and replace it with 0 */
    if ((p) && ( q > p ))  *q = 0 ;
    p = strchr(fin, ' ') ;
    if (p)
      {
      p = p + 1 ;
      strcpy (fin,p) ; /* ignore first space and any preceeding */
      }
   return(1) ;
    } /* fitail */
int wild (char * fin)  /* true if any * ? */
    {
    char *p ;
    p = strchr(fin, '*') ;
    if (p) return(1) ;
    p = strchr(fin, '?') ;
    if (p) return(1) ; else return(0) ;
    }




