/***********************************************************************/
/* COMM4.C - Commands P-S                                              */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\comm4.c 1.4 1993/09/01 16:25:43 MH Interim MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

#ifdef UNIX
#include <signal.h>
#endif

/*#define DEBUG 1*/

/*-------------------------- external data ----------------------------*/
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char display_screens;                      /* number of screens */
extern char number_of_views;                   /* number of open files */
extern bool horizontal;
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window,*divider;
extern bool error_on_screen;
extern char *rec;
extern unsigned short rec_len;
extern char *cmd_rec;
extern unsigned short cmd_rec_len;
extern char *pre_rec;
extern unsigned short pre_rec_len;
extern char *tempfilename;

extern char *temp_cmd;
extern char dir_filename[10];
extern char dir_pathname[MAX_FILE_NAME+1];
extern char curr_path[MAX_FILE_NAME+1] ;
extern char sp_path[MAX_FILE_NAME+1] ;
extern char sp_fname[MAX_FILE_NAME+1] ;
extern char dir_path[MAX_FILE_NAME+1] ;    /* for dir and ls commands */
extern short save_coord_x[VIEW_WINDOWS];
extern short save_coord_y[VIEW_WINDOWS];
/*man-start*********************************************************************
COMMAND
     print - send text to default printer or print spooler

SYNTAX
     PRint [target] [n]
     PRint LINE [text]
     PRint STRING [text]
     PRint FORMfeed
     PRint CLOSE

DESCRIPTION
     The PRINT command writes a portion of the current file to the default
     printer or print spooler, or text entered on the command line.
  
     PRINT [target] [n]
        Sends text from the file contents up to the target to the printer
        followed by a CR/LF (DOS) or LF(UNIX) after each line.
        When [n] is specified, this sends a formfeed after [n] successive
        lines of text.
     PRINT LINE [text]
        Sends the remainder of the text on the command line to the printer
        followed by a CR/LF (DOS) or LF(UNIX).
     PRINT STRING [text]
        Sends the remainder of the text on the command line to the printer
        without any trailing line terminator.
     PRINT FORMFEED
         Sends a formfeed (^L) character to the printer.
     PRINT CLOSE
         Closes the printer spooler.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     printer

STATUS
     Incomplete. OS/2 version does not work.
**man-end**********************************************************************/
#ifdef PROTO
int Print(char *params)
#else
int Print(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define PRT_PARAMS  2
 char *word[PRT_PARAMS+1];
 unsigned short num_params;
 long num_lines;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Print");
#endif
 num_params = param_split(params,word,PRT_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params == 0)
   {
    num_params = 1;
    word[0] = (char *)"1";
   }
 post_process_line(CURRENT_VIEW->focus_line);
 if (equal((char *)"line",word[0],4))
    print_line(NO,0L,0,(char *)word[1],
              (char *)"\r\n",FALSE);
 else
    if (equal((char *)"string",word[0],5))
       print_line(NO,0L,0,(char *)word[1],(char *)"",FALSE);
    else
       if (equal((char *)"formfeed",word[0],4))
         {
          if (num_params > 1)
            {
             display_error(1,word[1]);
#ifdef TRACE
             trace_return();
#endif
             return(RC_INVALID_OPERAND);
            }
          print_line(NO,0L,0,(char *)"",(char *)"\f",FALSE);
         }
       else
          if (equal((char *)"close",word[0],5))
            {
             if (num_params > 1)
               {
                display_error(1,word[1]);
#ifdef TRACE
                trace_return();
#endif
                return(RC_INVALID_OPERAND);
               }
             print_line(YES,0L,0,(char *)"",(char *)"",FALSE);
            }
          else
            {
             if ((num_lines = valid_target(word[0],get_true_line())) == TARGET_ERROR)
               {
                display_error(4,word[0]);
#ifdef TRACE
                trace_return();
#endif
                return(RC_INVALID_OPERAND);
               }
             if (num_params < 2)
                word[1] = (char *)"0";
             if (valid_positive_integer(word[1]) == NO)
               {
                display_error(4,word[0]);
#ifdef TRACE
                trace_return();
#endif
                return(RC_INVALID_OPERAND);
               }
             print_line(NO,num_lines,atoi(word[1]),(char *)"",
                        (char *)"\r\n",
                        (equal((char *)"all",word[0],3) ? TRUE : FALSE));
            }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     put - write part of a file to another

SYNTAX
     PUT [target] [fileid]

DESCRIPTION
     The PUT command writes a portion of the current file to another
     file, either explicit or temporary.
     When no fileid is supplied the temporary file is overwritten.
     When a fileid is supplied the portion of the file written out
     is appended to the specified file.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     putd,get

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Put(char *params)
#else
int Put(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Put");
#endif
 rc = execute_put(params,FALSE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     putd - write part of a file to another and delete

SYNTAX
     PUTD [target] [fileid]

DESCRIPTION
     The PUTD command writes a portion of the current file to another
     file, either explicit or temporary and deletes those lines written.
     When no fileid is supplied the temporary file is overwritten.
     When a fileid is supplied the portion of the file written out
     is appended to the specified file.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     put,get

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Putd(char *params)
#else
int Putd(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Putd");
#endif
 rc = execute_put(params,TRUE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     query - display various option settings

SYNTAX
     Query item

DESCRIPTION
     The QUERY command displays the various settings for options set
     by THE.

COMPATIBILITY
     XEDIT: Compatible functionality, but not all options.
     KEDIT: Compatible functionality, but not all options.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Query(char *params)
#else
int Query(params)
char *params;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern VALUE item_values[18];
/*--------------------------- local data ------------------------------*/
 register int i;
 int itemno;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Query");
#endif
 if ((itemno = find_item(params,QUERY_QUERY)) == (-1))
    {
     display_error(1,params);
#ifdef TRACE
     trace_return();
#endif
     return(RC_INVALID_OPERAND);
    }

 itemno = get_item_values(itemno,"",QUERY_QUERY,0L,NULL,0L);
 strcpy(temp_cmd,"");
 for (i=0;i<itemno+1;i++)
   {
    strcat(temp_cmd,item_values[i].value);
    strcat(temp_cmd," ");
   }
 display_error(0,temp_cmd);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     quit - exit from the current file

SYNTAX
     QUIT

DESCRIPTION
     The QUIT command exits the user from the current file, provided
     no changes have been made to the file. An error message will be
     displayed if changes have been made.
     The previous file in the ring then becomes the current file.
     If the current file is the only file in the ring, the user is
     returned to the Operating System.

COMPATIBILITY
     XEDIT: Does not support return code option.
     KEDIT: Compatible.

SEE ALSO
     qquit

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Quit(char *params)
#else
int Quit(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Quit");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 if (CURRENT_FILE->save_alt > 0)
   {
    display_error(22,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_FILE_CHANGED);
   }
 free_view_memory();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     qquit - exit from the current file

SYNTAX
     QQuit

DESCRIPTION
     The QQUIT command exits the user from the current file, whether
     changes have been made to the file or not.
     The previous file in the ring then becomes the current file.
     If the current file is the only file in the ring, the user is
     returned to the Operating System.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     quit

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Qquit(char *params)
#else
int Qquit(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Qquit");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 free_view_memory();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     recover - recover changed or deleted lines

SYNTAX
     RECover [n|*]

DESCRIPTION
     The RECOVER command restores the last n changed or deleted lines
     back into the body of the file.

COMPATIBILITY
     XEDIT: Also recovers changes to lines, not just lines deleted.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Recover(char *params)
#else
int Recover(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define REC_PARAMS  1
 char *word[REC_PARAMS+1];
 char parm[REC_PARAMS];
 unsigned short num_params;
 int num;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Recover");
#endif
/*---------------------------------------------------------------------*/
/* Validate the parameters that have been supplied. The one and only   */
/* parameter should be a positive integer greater than zero or '*'.    */
/* If no parameter is supplied, 1 is assumed.                          */
/*---------------------------------------------------------------------*/
 num_params = param_split(params,word,REC_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params == 0)
    {
     num_params = 1;
     word[0] = (char *)"1";
    }
 if (num_params != 1)
    {
     display_error(1,word[1]);
#ifdef TRACE
     trace_return();
#endif
     return(RC_INVALID_OPERAND);
    }
 if (strcmp(word[0],"*") == 0)
   {
    num = 99;
   }
 else
   {
    if (!valid_positive_integer(word[0]))
       {
        display_error(4,word[0]);
#ifdef TRACE
        trace_return();
#endif
        return(RC_INVALID_OPERAND);
       }
    num = atol(word[0]);
   }

 get_from_recovery_list(num);

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     redraw - redraw the current screen

SYNTAX
     REDRAW

DESCRIPTION
     The REDRAW command redraws the current contents of the screen.
     This is usually used when some outside influence has stuffed the
     display up.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: N/A

SEE ALSO
     REFRESH

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Redraw(char *params)
#else
int Redraw(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Redraw");
#endif
 if (strcmp(params,"") != 0)
   {
    display_error(1,params);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 restore_THE();
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     refresh - refresh the contents of the current screen

SYNTAX
     REFRESH

DESCRIPTION
     The REFRESH command refreshes what is being displayed on the screen.
     This is usually used from within a macro to indicate the progress
     of the macro.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Refresh(char *params)
#else
int Refresh(params)
char *params;
#endif
/***********************************************************************/
{
 extern char in_macro;
/*--------------------------- local data ------------------------------*/
 char save_in_macro = in_macro;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Refresh");
#endif
 if (strcmp(params,"") != 0)
   {
    display_error(1,params);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 in_macro = FALSE;
 show_page();
 doupdate();
 in_macro = save_in_macro;
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     replace - replace the current line with supplied text

SYNTAX
     Replace [text]

DESCRIPTION
     The REPLACE command replaces the current line with the supplied
     text.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Replace(char *params)
#else
int Replace(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int len_params,rc;
 long true_line;
 LINE *curr;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Replace");
#endif

 post_process_line(CURRENT_VIEW->focus_line);

 if (CURRENT_VIEW->hex == ON)
   {
    if ((len_params = convert_hex_strings(params)) == (-1))
      {
       display_error(32,(char *)"");
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }
   }
 else
   len_params = strlen(params);
 true_line = get_true_line();
 if (TOF(true_line)
 ||  BOF(true_line))
   {
    display_error(38,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }

#ifdef USE_VOID
 curr = (LINE *)ll_find((void *)CURRENT_FILE->first_line,true_line);
#else
 curr = lll_find(CURRENT_FILE->first_line,true_line);
#endif
 add_to_recovery_list(curr->line,curr->length);
 curr = delete_line(CURRENT_FILE->first_line,curr,DIRECTION_FORWARD);
 curr = curr->prev;
 if ((curr = add_line(CURRENT_FILE->first_line,curr,
                          params,len_params)) == NULL)
   {
    display_error(30,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 if ((rc = increment_alt(CURRENT_FILE)) != RC_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
 pre_process_line(CURRENT_VIEW->focus_line);

 show_page();

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     reset - cancel the marked block or prefix commands or both

SYNTAX
     RESet ALL|Block|Prefix

DESCRIPTION
     The RESET command unmarks any marked block or outstanding prefix
     commands or both.

COMPATIBILITY
     XEDIT: Adds Block and All options.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Reset(char *params)
#else
int Reset(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern char pending_prefix_command[PREFIX_WIDTH+1];
/*--------------------------- local data ------------------------------*/
#define RES_PARAMS  1
 char *word[RES_PARAMS+1];
 unsigned short num_params;
 register int i;
 LINE *curr;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Reset");
#endif
 num_params = param_split(params,word,RES_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params > 1)
   {
    display_error(1,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
/*---------------------------------------------------------------------*/
/* Reset the marked block, if any.                                     */
/*---------------------------------------------------------------------*/
 if (equal((char *)"block",word[0],1)
 ||  equal((char *)"all",word[0],3)
 ||  num_params == 0)
   {
    if (MARK_VIEW != (VIEW_DETAILS *)NULL)
      {
       MARK_VIEW->mark_start_line = MARK_VIEW->mark_end_line = (-1L);
       MARK_VIEW->mark_start_col =  MARK_VIEW->mark_end_col = (-1);
       MARK_VIEW = (VIEW_DETAILS *)NULL;
       show_page();
      }
   }
/*---------------------------------------------------------------------*/
/* Reset the pending prefix commands, if any.                          */
/*---------------------------------------------------------------------*/
 if (equal((char *)"prefix",word[0],1)
 ||  equal((char *)"all",word[0],3)
 ||  num_params == 0)
   {
    if (CURRENT_VIEW->prefix_command_index > 0)
      {
       for (i=0;i<CURRENT_VIEW->prefix_command_index;i++)
          clear_pending_prefix_command(i,(LINE *)NULL);
       CURRENT_VIEW->prefix_command_index = 0;
       strcpy(pending_prefix_command,"");
       show_page();
       memset(pre_rec,' ',PREFIX_WIDTH+1);
       pre_rec_len = 0;
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     right_arrow - move the cursor to the right

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The right_arrow key causes the cursor to move one column to the
     right. If the cursor is on the right most column of the main
     window, the window will scroll half a window.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Equivalent to CURSOR RIGHT.

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Right_arrow(char *params)
#else
int Right_arrow(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern bool CMDARROWSTABLRx;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Right_arrow");
#endif
 getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* Check for going past end of line - max_line_length                  */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col+x+1 > max_line_length)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* For all windows, if we are not at right column, move 1 pos to right.*/
/*---------------------------------------------------------------------*/
 if (x < getmaxx(CURRENT_WINDOW)-1)
   {
    wmove(CURRENT_WINDOW,y,x+1);
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* For all windows, determine if CMDARROWSTABLRx is set for tabbing or */
/* scrolling and act accordingly.                                      */
/*---------------------------------------------------------------------*/
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if (CMDARROWSTABLRx)
           {
            if (CURRENT_VIEW->prefix)
              {
               Tabpre("");
               wmove(CURRENT_WINDOW,y,0);
              }
            else
               wmove(CURRENT_WINDOW,y,0);
           }
         else
           {
            if (x == getmaxx(CURRENT_WINDOW)-1)
              {
               x = getmaxx(CURRENT_WINDOW) / 2;
               CURRENT_VIEW->verify_col += x;
               show_page();
               wmove(CURRENT_WINDOW,y,x);
              }
           }
         break;
    case WINDOW_PREFIX:
         if (CMDARROWSTABLRx)
            if (CURRENT_VIEW->prefix)
              {
               Tabpre("");
               wmove(CURRENT_WINDOW,y,0);
              }
         break;
    case WINDOW_COMMAND:
         if (CMDARROWSTABLRx)
            wmove(CURRENT_WINDOW,y,0);
         break;
    default:
         break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     save - save changes to current file

SYNTAX
     SAVE [fileid]

DESCRIPTION
     The save command writes the current file to disk. If a fileid is
     supplied, the current file is saved in that file, unless the file
     already exists when an error is displayed.
     The 'Alterations' counter on the heading line is reset to zero.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     ssave, file, ffile

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Save(char *params)
#else
int Save(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Save");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 if ((rc = save_file(CURRENT_FILE,params,NO,0L,0L,NO,0,max_line_length)) != RC_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
/*---------------------------------------------------------------------*/
/* Only set the alteration count to zero if save was successful.       */
/*---------------------------------------------------------------------*/
 CURRENT_FILE->autosave_alt = CURRENT_FILE->save_alt = 0;
/*---------------------------------------------------------------------*/
/* If autosave is on at the time of Saving, remove the .aus file...    */
/*---------------------------------------------------------------------*/
 if (CURRENT_FILE->autosave > 0)
    rc = remove_aus_file(CURRENT_FILE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     schange - selectively change strings

SYNTAX
     SCHange /string1/string2/ [target] [n] [m]

DESCRIPTION
     The CHANGE command changes one string of text to another.

     The first parameter to the change command is the old and new
     string values, seperated by delimiters.
     The allowable delimiters are '/' '\' and '@'.

     The second parameter is the target; how many lines are to be
     searched for occurrences of the first string to be changed.

     The third parameter determines how many occurrences of 'string1'
     are to be changed on each line.

     The fourth parameter determines at which occurrences of 'string1'
     on the line are changes to commence.

COMPATIBILITY
     XEDIT: Functionally compatible, but syntax different.
     KEDIT: Compatible.

DEFAULT
     1 1 1

SEE ALSO
     change

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Schange(char *params)
#else
int Schange(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Schange");
#endif

 rc = execute_change_command(params,TRUE);

#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     set - execute various set commands

SYNTAX
     SET set_command [set_command parameter(s) ...]

DESCRIPTION
     The SET command is a front end to existing 'set' commands. It treats
     the first parameter it receives as a command and executes it.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Set(char *params)
#else
int Set(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Set");
#endif
 rc = execute_set_sos_command(TRUE,params);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     shift - move text left or right

SYNTAX
     SHift Left|Right [n] [target]

DESCRIPTION
     The SHIFT command moves text in the direction specified the number
     of columns [n] for the specified target lines.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Shift(char *params)
#else
int Shift(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define SHI_PARAMS  3
 char *word[SHI_PARAMS+1];
 int shift_left=(-1);
 long num_lines,true_line;
 int num_cols,num_params;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Shift");
#endif
 num_params = param_split(params,word,SHI_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params == 0)                                     /* no params */
   {
    display_error(3,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
/*---------------------------------------------------------------------*/
/* Validate first parameter:                                           */
/*    must be Left or Right                                            */
/*---------------------------------------------------------------------*/
 if (equal((char *)"left",word[0],1))
     shift_left = TRUE;
 if (equal((char *)"right",word[0],1))
     shift_left = FALSE;
 if (shift_left == (-1))
   {
    display_error(1,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
/*---------------------------------------------------------------------*/
/* Validate second parameter (if there is one)                         */
/*    If present, must be valid positive integer.                      */
/*    If not present, default to 1.                                    */
/*---------------------------------------------------------------------*/
 if (num_params < 2)
    num_cols = 1;
 else
   {
    if (valid_positive_integer(word[1]) == NO)
      {
       display_error(4,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }
    num_cols = atoi(word[1]);
   }
/*---------------------------------------------------------------------*/
/* Get the value of true_line.                                         */
/*---------------------------------------------------------------------*/
 if (equal((char *)"all",word[2],3))
    true_line = 1L;
 else
    true_line = get_true_line();
/*---------------------------------------------------------------------*/
/* Validate third  parameter (if there is one)                         */
/*    If present, must be valid target.                                */
/*    If not present, default to 1.                                    */
/*---------------------------------------------------------------------*/
 if (num_params < 3)                                      /* no target */
    num_lines = 1L;
 else
   {
    num_lines = valid_target(word[2],true_line);
    if (num_lines == TARGET_ERROR)
      {
       display_error(17,word[2]);
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }
    if (num_lines == TARGET_NOT_FOUND)
      {
       display_error(17,word[2]);
#ifdef TRACE
       trace_return();
#endif
       return(RC_TARGET_NOT_FOUND);
      }
   }
/*---------------------------------------------------------------------*/
/* Now we are here, everything's OK, do the actual shift...            */
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/* If we are on the top of file line, start from the next line...      */
/*---------------------------------------------------------------------*/
 if (TOF(true_line)
 && num_lines > 0L)
   {
    true_line++;
    num_lines--;
   }
/*---------------------------------------------------------------------*/
/* If we are on the bottom of file line, start from the previous line..*/
/*---------------------------------------------------------------------*/
 if (BOF(true_line)
 && num_lines < 0L)
   {
    true_line--;
    num_lines++;
   }
 rc = execute_shift_command(shift_left,num_cols,true_line,num_lines);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     showkey - display current key value and command assignation

SYNTAX
     SHOWKey 

DESCRIPTION
     The SHOWKEY command prompts the user to enter a key and responds
     with the key name and associated command (if applicable).

COMPATIBILITY
     XEDIT: N/A
     KEDIT: N/A

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int ShowKey(char *params)
#else
int ShowKey(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short key;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   ShowKey");
#endif
 werase(foot);
 wnoutrefresh(foot);
 display_error(0,(char *)"Press the key to be translated...spacebar to exit");
 doupdate();
 key = 0;
 while(key != ' ')
   {
    key = my_getch(CURRENT_WINDOW);
    display_error(0,get_key_definition(key));
    wrefresh(error_window);
   }
 error_on_screen = FALSE;
 clear_footing();

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     sort - sort selected lines in a file

SYNTAX
     SORT target [[[Ascending|Descending] left_col right_col] [...]]

DESCRIPTION
     The SORT command sort a portion of a file based on the sort field
     specifications.
     target can be any valid target including ALL, *, -*, and BLOCK.
     Each sort field specification consists of an optional ordering
     flag and a left and right column.

     Only 10 sort fields are allowed.

COMPATIBILITY
     XEDIT: XEDIT only allows ordering flag for all fields
     KEDIT: Compatible.

BUGS
     Does not handle string targets with embedded blanks.

STATUS
     Incomplete.
**man-end**********************************************************************/
#ifdef PROTO
int Sort(char *params)
#else
int Sort(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Sort");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 rc = execute_sort(params);
 pre_process_line(CURRENT_VIEW->focus_line);
 show_page();
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     sos - execute various sos commands

SYNTAX
     SOS sos_command [sos_command ...]

DESCRIPTION
     The SOS command is a front end to existing 'sos' commands. It treats
     each parameter it receives as a command and executes it.

COMPATIBILITY
     XEDIT: XEDIT only permits 1 command
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos(char *params)
#else
int Sos(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
#define SOS_PARAMS  10
 char *word[SOS_PARAMS+1];
 int num_params;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Sos");
#endif
 num_params = param_split(params,word,SOS_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params == 0)                                     /* no params */
   {
    display_error(3,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
/*---------------------------------------------------------------------*/
/* For each "command" go an execute it.                                */
/*---------------------------------------------------------------------*/
 for (i=0;i<num_params;i++)
   {
    if ((rc = execute_set_sos_command(FALSE,word[i])) != RC_OK)
       break;
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     split - split a line

SYNTAX
     SPlit [ALigned]

DESCRIPTION
     The SPLIT command splits the focus line into two lines.
     If aligned is specified, the first non-blank character of the new
     line is positioned under the first non-blank character of the
     focus line. If aligned is not specified, the text of the new line
     starts in column 1.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Split(char *params)
#else
int Split(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
 bool aligned;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Split");
#endif
/*---------------------------------------------------------------------*/
/* Check here for parameter value of 'Aligned'.                        */
/*---------------------------------------------------------------------*/
 if (equal((char *)"aligned",params,2))
    aligned = ALIGNED_TRUE;
 else
    if (strcmp(params,"") == 0)
       aligned = ALIGNED_FALSE;
    else
      {
       display_error(1,(char *)params);
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_ENVIRON);
      }
 rc = execute_split_join(SPLIT_TRUE,aligned);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     spltjoin - split/join two lines

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The SPLTJOIN command splits the focus line into two or joins the
     focus line with the next line depending on the position of the
     cursor. If the cursor is after the last column of a line, a 'join'
     is executed, otherwise a 'split' is executed.
     The text in the new line is aligned with the text in the focus line.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Spltjoin(char *params)
#else
int Spltjoin(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,col;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Spltjoin");
#endif
/*---------------------------------------------------------------------*/
/* Determine whether a split or join is to be performed.               */
/* If after end of line, join, else split the line.                    */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 if (x+CURRENT_VIEW->verify_col-1 >= rec_len)
    rc = execute_split_join(SPLIT_FALSE,ALIGNED_TRUE);
 else
    rc = execute_split_join(SPLIT_TRUE,ALIGNED_TRUE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     ssave - save changes to current file

SYNTAX
     SSave [fileid]

DESCRIPTION
     The ssave command writes the current file to disk. If a fileid is
     supplied, the current file is saved in that file, otherwise the
     current name of the file is used.
     If a fileid is supplied and that fileid already exists, the previous
     contents of that fileid will be replaced with the current file.
     The 'Alterations' counter on the heading line is reset to zero.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.

SEE ALSO
     save, file, ffile

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Ssave(char *params)
#else
int Ssave(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Ssave");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 if ((rc = save_file(CURRENT_FILE,params,YES,0L,0L,NO,0,max_line_length)) != RC_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
/*---------------------------------------------------------------------*/
/* Only set the alteration count to zero if save was successful.       */
/*---------------------------------------------------------------------*/
 CURRENT_FILE->autosave_alt = CURRENT_FILE->save_alt = 0;
/*---------------------------------------------------------------------*/
/* If autosave is on at the time of SSaving, remove the .aus file...   */
/*---------------------------------------------------------------------*/
 if (CURRENT_FILE->autosave > 0)
    rc = remove_aus_file(CURRENT_FILE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     status - display current settings of various variables

SYNTAX
     STATus [filename]

DESCRIPTION
     The STATUS command, without the optional filename, displays a full
     screen of current settings for various variables. With the filename,
     the STATUS command creates a file containing a series of SET commands
     with the current values of these settings.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible. KEDIT does not support [filename] option.

SEE ALSO
     QUERY, EXTRACT, MODIFY

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Status(char *params)
#else
int Status(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
 extern char in_profile;
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Status");
#endif
 if (strcmp(params,"") == 0)
   {
    if (in_profile)
      {
       display_error(24,(char *)"status");
       rc = RC_INVALID_ENVIRON;
      }
    else
       rc = show_status();
   }
 else
    rc = save_status(params);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     suspend - suspend THE and return to operating system

SYNTAX
     SUSPend

DESCRIPTION
     The SUSPEND command suspends the current editing session and 
     returns control to the operating system. Under DOS and OS/2 this
     is the equivalent of OSNowait. Under UNIX, the process gets placed
     in the background until it is brought to the foreground.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: N/A

SEE ALSO
     OSQUIET

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Suspend(char *params)
#else
int Suspend(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
/*--------------------------- local data ------------------------------*/
 int rc;
#ifdef UNIX
 void (*func)();
#endif
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Suspend");
#endif
 if (strcmp(params,"") != 0)
   {
    display_error(2,params);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
#if defined(UNIX) && !defined(ATT) && !defined(M_XENIX)
 if (strcmp("/bin/sh",getenv("SHELL")) == 0)
   {
    display_error(40,(char *)"");
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 suspend_curses();
 func = signal(SIGTSTP,SIG_DFL);
 kill(0,SIGTSTP);
 signal(SIGTSTP,func);
 resume_curses();
 Redraw("");
#else
 rc = execute_os_command(params,FALSE,FALSE);
#endif
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
