/***********************************************************************/
/* REXX.C - REXX interface routines.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\rexx.c 1.4 1993/09/01 16:27:12 MH Interim MH $
*/

#if !defined(NOREXX)
/*--------------------------- global data -----------------------------*/
/* these are here because EMX include REXX definitions from within os2.h */
/*---------------------------------------------------------------------*/
#  define INCL_RXSUBCOM       /* Subcommand handler values */
#  define INCL_RXSHV          /* Shared variable support */
#  define INCL_RXSYSEXIT      /* System exit routines */
#  define INCL_DOSPROCESS     /* Process/Thread Info */
#  define INCL_RXFUNC         /* External functions */

#include "the.h"
#include "proto.h"
#include "query.h"
#include "rexx.h"

RexxSubcomHandler THE_Commands;
RexxExitHandler THE_Exit_Handler;
RexxFunctionHandler THE_Function_Handler;

FILE *rexxoutfp;
static unsigned short y,x;
static long captured_lines;
static bool rexx_halted;


struct function_item
 {
  char *name;                      /* name of item */
  int item_number;                  /* unique number for item */
  int item_index;                  /* index value for the whole item */
  char query;                         /* valid query response ? */
 };
typedef struct function_item FUNCTION_ITEM;

 static FUNCTION_ITEM item[] =
  {
   {"ALT.0",ITEM_ALT,0,QUERY_FUNCTION},
   {"ALT.1",ITEM_ALT,1,QUERY_FUNCTION},
   {"ALT.2",ITEM_ALT,2,QUERY_FUNCTION},
   {"ARBCHAR.0",ITEM_ARBCHAR,0,QUERY_FUNCTION},
   {"ARBCHAR.1",ITEM_ARBCHAR,1,QUERY_FUNCTION},
   {"ARBCHAR.2",ITEM_ARBCHAR,2,QUERY_FUNCTION},
   {"AUTOSAVE.0",ITEM_AUTOSAVE,0,QUERY_FUNCTION},
   {"AUTOSAVE.1",ITEM_AUTOSAVE,1,QUERY_FUNCTION},
   {"BACKUP.0",ITEM_BACKUP,0,QUERY_FUNCTION},
   {"BACKUP.1",ITEM_BACKUP,1,QUERY_FUNCTION},
   {"BEEP.0",ITEM_BEEP,0,QUERY_FUNCTION},
   {"BEEP.1",ITEM_BEEP,1,QUERY_FUNCTION},
   {"BLOCK.0",ITEM_BLOCK,0,QUERY_FUNCTION},
   {"BLOCK.1",ITEM_BLOCK,1,QUERY_FUNCTION},
   {"BLOCK.2",ITEM_BLOCK,2,QUERY_FUNCTION},
   {"BLOCK.3",ITEM_BLOCK,3,QUERY_FUNCTION},
   {"BLOCK.4",ITEM_BLOCK,4,QUERY_FUNCTION},
   {"BLOCK.5",ITEM_BLOCK,5,QUERY_FUNCTION},
   {"BLOCK.6",ITEM_BLOCK,6,QUERY_FUNCTION},
   {"CASE.0",ITEM_CASE,0,QUERY_FUNCTION},
   {"CASE.1",ITEM_CASE,1,QUERY_FUNCTION},
   {"CASE.2",ITEM_CASE,2,QUERY_FUNCTION},
   {"CASE.3",ITEM_CASE,3,QUERY_FUNCTION},
   {"CASE.4",ITEM_CASE,4,QUERY_FUNCTION},
   {"CLEARSCREEN.0",ITEM_CLEARSCREEN,0,QUERY_FUNCTION},
   {"CLEARSCREEN.1",ITEM_CLEARSCREEN,1,QUERY_FUNCTION},
   {"CLOCK.0",ITEM_CLOCK,0,QUERY_FUNCTION},
   {"CLOCK.1",ITEM_CLOCK,1,QUERY_FUNCTION},
   {"CMDARROWS.0",ITEM_CMDARROWS,0,QUERY_FUNCTION},
   {"CMDARROWS.1",ITEM_CMDARROWS,1,QUERY_FUNCTION},
   {"CMDARROWS.2",ITEM_CMDARROWS,2,QUERY_FUNCTION},
   {"CMDARROWS.3",ITEM_CMDARROWS,3,QUERY_FUNCTION},
   {"CMDLINE.0",ITEM_CMDLINE,0,QUERY_FUNCTION},
   {"CMDLINE.1",ITEM_CMDLINE,1,QUERY_FUNCTION},
   {"CMDLINE.2",ITEM_CMDLINE,2,QUERY_FUNCTION},
   {"CURLINE.0",ITEM_CURLINE,0,QUERY_FUNCTION},
   {"CURLINE.1",ITEM_CURLINE,1,QUERY_FUNCTION},
   {"CURLINE.2",ITEM_CURLINE,2,QUERY_FUNCTION},
   {"CURLINE.3",ITEM_CURLINE,3,QUERY_FUNCTION},
   {"DIRFILEID.0",ITEM_DIRFILEID,0,QUERY_FUNCTION},
   {"DIRFILEID.1",ITEM_DIRFILEID,1,QUERY_FUNCTION},
   {"DIRFILEID.2",ITEM_DIRFILEID,2,QUERY_FUNCTION},
   {"EOF.0",ITEM_EOF,0,QUERY_FUNCTION},
   {"EOF.1",ITEM_EOF,1,QUERY_FUNCTION},
   {"EOLOUT.0",ITEM_EOLOUT,0,QUERY_FUNCTION},
   {"EOLOUT.1",ITEM_EOLOUT,1,QUERY_FUNCTION},
   {"ETMODE.0",ITEM_ETMODE,0,QUERY_FUNCTION},
   {"ETMODE.1",ITEM_ETMODE,1,QUERY_FUNCTION},
   {"FNAME.0",ITEM_FNAME,0,QUERY_FUNCTION},
   {"FNAME.1",ITEM_FNAME,1,QUERY_FUNCTION},
   {"FPATH.0",ITEM_FPATH,0,QUERY_FUNCTION},
   {"FPATH.1",ITEM_FPATH,1,QUERY_FUNCTION},
   {"FTYPE.0",ITEM_FTYPE,0,QUERY_FUNCTION},
   {"FTYPE.1",ITEM_FTYPE,1,QUERY_FUNCTION},
   {"GETENV.0",ITEM_GETENV,0,QUERY_FUNCTION},
   {"GETENV.1",ITEM_GETENV,1,QUERY_FUNCTION},
   {"HEX.0",ITEM_HEX,0,QUERY_FUNCTION},
   {"HEX.1",ITEM_HEX,1,QUERY_FUNCTION},
   {"HEXDISPLAY.0",ITEM_HEXDISPLAY,0,QUERY_FUNCTION},
   {"HEXDISPLAY.1",ITEM_HEXDISPLAY,1,QUERY_FUNCTION},
   {"IMPMACRO.0",ITEM_IMPMACRO,0,QUERY_FUNCTION},
   {"IMPMACRO.1",ITEM_IMPMACRO,1,QUERY_FUNCTION},
   {"IMPMOS.0",ITEM_IMPOS,0,QUERY_FUNCTION},
   {"IMPMOS.1",ITEM_IMPOS,1,QUERY_FUNCTION},
   {"INSERTMODE.0",ITEM_INSERTMODE,0,QUERY_FUNCTION},
   {"INSERTMODE.1",ITEM_INSERTMODE,1,QUERY_FUNCTION},
   {"LASTMSG.0",ITEM_LASTMSG,0,QUERY_FUNCTION},
   {"LASTMSG.1",ITEM_LASTMSG,1,QUERY_FUNCTION},
   {"LASTRC.0",ITEM_LASTRC,0,QUERY_FUNCTION},
   {"LASTRC.1",ITEM_LASTRC,1,QUERY_FUNCTION},
   {"LENGTH.0",ITEM_LENGTH,0,QUERY_FUNCTION},
   {"LENGTH.1",ITEM_LENGTH,1,QUERY_FUNCTION},
   {"LINE.0",ITEM_LINE,0,QUERY_FUNCTION},
   {"LINE.1",ITEM_LINE,1,QUERY_FUNCTION},
   {"LINEND.0",ITEM_LINEND,0,QUERY_FUNCTION},
   {"LINEND.1",ITEM_LINEND,1,QUERY_FUNCTION},
   {"LINEND.2",ITEM_LINEND,2,QUERY_FUNCTION},
   {"MACROEXT.0",ITEM_MACROEXT,0,QUERY_FUNCTION},
   {"MACROEXT.1",ITEM_MACROEXT,1,QUERY_FUNCTION},
   {"MACROPATH.0",ITEM_MACROPATH,0,QUERY_FUNCTION},
   {"MACROPATH.1",ITEM_MACROPATH,1,QUERY_FUNCTION},
   {"MARGINS.0",ITEM_MARGINS,0,QUERY_FUNCTION},
   {"MARGINS.1",ITEM_MARGINS,1,QUERY_FUNCTION},
   {"MARGINS.2",ITEM_MARGINS,2,QUERY_FUNCTION},
   {"MARGINS.3",ITEM_MARGINS,3,QUERY_FUNCTION},
   {"MONITOR.0",ITEM_MONITOR,0,QUERY_FUNCTION},
   {"MONITOR.1",ITEM_MONITOR,1,QUERY_FUNCTION},
   {"MONITOR.2",ITEM_MONITOR,2,QUERY_FUNCTION},
   {"MSGMODE.0",ITEM_MSGMODE,0,QUERY_FUNCTION},
   {"MSGMODE.1",ITEM_MSGMODE,1,QUERY_FUNCTION},
   {"NBFILE.0",ITEM_NBFILE,0,QUERY_FUNCTION},
   {"NBFILE.1",ITEM_NBFILE,1,QUERY_FUNCTION},
   {"NEWLINES.0",ITEM_NEWLINES,0,QUERY_FUNCTION},
   {"NEWLINES.1",ITEM_NEWLINES,1,QUERY_FUNCTION},
   {"NONDISP.0",ITEM_NONDISP,0,QUERY_FUNCTION},
   {"NONDISP.1",ITEM_NONDISP,1,QUERY_FUNCTION},
   {"NUMBER.0",ITEM_NUMBER,0,QUERY_FUNCTION},
   {"NUMBER.1",ITEM_NUMBER,1,QUERY_FUNCTION},
   {"PREFIX.0",ITEM_PREFIX,0,QUERY_FUNCTION},
   {"PREFIX.1",ITEM_PREFIX,1,QUERY_FUNCTION},
   {"PREFIX.2",ITEM_PREFIX,2,QUERY_FUNCTION},
   {"PRINTER.0",ITEM_PRINTER,0,QUERY_FUNCTION},
   {"PRINTER.1",ITEM_PRINTER,1,QUERY_FUNCTION},
   {"REPROFILE.0",ITEM_REPROFILE,0,QUERY_FUNCTION},
   {"REPROFILE.1",ITEM_REPROFILE,1,QUERY_FUNCTION},
   {"REXXOUTPUT.0",ITEM_REXXOUTPUT,0,QUERY_FUNCTION},
   {"REXXOUTPUT.1",ITEM_REXXOUTPUT,1,QUERY_FUNCTION},
   {"REXXOUTPUT.2",ITEM_REXXOUTPUT,2,QUERY_FUNCTION},
   {"SIZE.0",ITEM_SIZE,0,QUERY_FUNCTION},
   {"SIZE.1",ITEM_SIZE,1,QUERY_FUNCTION},
   {"STAY.0",ITEM_STAY,0,QUERY_FUNCTION},
   {"STAY.1",ITEM_STAY,1,QUERY_FUNCTION},
   {"TABKEY.0",ITEM_TABKEY,0,QUERY_FUNCTION},
   {"TABKEY.1",ITEM_TABKEY,1,QUERY_FUNCTION},
   {"TABKEY.2",ITEM_TABKEY,2,QUERY_FUNCTION},
   {"TABS.0",ITEM_TABS,0,QUERY_FUNCTION},
   {"TABS.1",ITEM_TABS,1,QUERY_FUNCTION},
   {"TABSIN.0",ITEM_TABSIN,0,QUERY_FUNCTION},
   {"TABSIN.1",ITEM_TABSIN,1,QUERY_FUNCTION},
   {"TABSIN.2",ITEM_TABSIN,2,QUERY_FUNCTION},
   {"TABSOUT.0",ITEM_TABSOUT,0,QUERY_FUNCTION},
   {"TABSOUT.1",ITEM_TABSOUT,1,QUERY_FUNCTION},
   {"TABSOUT.2",ITEM_TABSOUT,2,QUERY_FUNCTION},
   {"TERMINAL.0",ITEM_TERMINAL,0,QUERY_FUNCTION},
   {"TERMINAL.1",ITEM_TERMINAL,1,QUERY_FUNCTION},
   {"TOF.0",ITEM_TOF,0,QUERY_FUNCTION},
   {"TOF.1",ITEM_TOF,1,QUERY_FUNCTION},
   {"VERIFY.0",ITEM_VERIFY,0,QUERY_FUNCTION},
   {"VERIFY.1",ITEM_VERIFY,1,QUERY_FUNCTION},
   {"VERSION.0",ITEM_VERSION,0,QUERY_FUNCTION},
   {"VERSION.1",ITEM_VERSION,1,QUERY_FUNCTION},
   {"VERSION.2",ITEM_VERSION,2,QUERY_FUNCTION},
   {"VERSION.3",ITEM_VERSION,3,QUERY_FUNCTION},
   {"VERSION.4",ITEM_VERSION,4,QUERY_FUNCTION},
   {"WIDTH.0",ITEM_WIDTH,0,QUERY_FUNCTION},
   {"WIDTH.1",ITEM_WIDTH,1,QUERY_FUNCTION},
   {"WORDWRAP.0",ITEM_WORDWRAP,0,QUERY_FUNCTION},
   {"WORDWRAP.1",ITEM_WORDWRAP,1,QUERY_FUNCTION},
   {"ZONE.0",ITEM_ZONE,0,QUERY_FUNCTION},
   {"ZONE.1",ITEM_ZONE,1,QUERY_FUNCTION},
   {"ZONE.2",ITEM_ZONE,2,QUERY_FUNCTION},
   {"AFTER",ITEM_AFTER_FUNCTION,1,QUERY_FUNCTION},
   {"BEFORE",ITEM_BEFORE_FUNCTION,1,QUERY_FUNCTION},
   {"BLANK",ITEM_BLANK_FUNCTION,1,QUERY_FUNCTION},
   {"BLOCK",ITEM_BLOCK_FUNCTION,1,QUERY_FUNCTION},
   {"BOTTOMEDGE",ITEM_BOTTOMEDGE_FUNCTION,1,QUERY_FUNCTION},
   {"COMMAND",ITEM_COMMAND_FUNCTION,1,QUERY_FUNCTION},
   {"CURRENT",ITEM_CURRENT_FUNCTION,1,QUERY_FUNCTION},
   {"DIR",ITEM_DIR_FUNCTION,1,QUERY_FUNCTION},
   {"END",ITEM_END_FUNCTION,1,QUERY_FUNCTION},
   {"EOF",ITEM_EOF_FUNCTION,1,QUERY_FUNCTION},
   {"FIRST",ITEM_FIRST_FUNCTION,1,QUERY_FUNCTION},
   {"FOCUSEOF",ITEM_FOCUSEOF_FUNCTION,1,QUERY_FUNCTION},
   {"FOCUSTOF",ITEM_FOCUSTOF_FUNCTION,1,QUERY_FUNCTION},
   {"INBLOCK",ITEM_INBLOCK_FUNCTION,1,QUERY_FUNCTION},
   {"INITIAL",ITEM_INITIAL_FUNCTION,1,QUERY_FUNCTION},
   {"INPREFIX",ITEM_INPREFIX_FUNCTION,1,QUERY_FUNCTION},
   {"LEFTEDGE",ITEM_LEFTEDGE_FUNCTION,1,QUERY_FUNCTION},
   {"MODIFIABLE",ITEM_MODIFIABLE_FUNCTION,1,QUERY_FUNCTION},
   {"RIGHTEDGE",ITEM_RIGHTEDGE_FUNCTION,1,QUERY_FUNCTION},
   {"SPACECHAR",ITEM_SPACECHAR_FUNCTION,1,QUERY_FUNCTION},
   {"TOF",ITEM_TOF_FUNCTION,1,QUERY_FUNCTION},
   {"TOPEDGE",ITEM_TOPEDGE_FUNCTION,1,QUERY_FUNCTION},
   {"VERONE",ITEM_VERONE_FUNCTION,1,QUERY_FUNCTION},
   {"VALID_TARGET",ITEM_VALID_TARGET_FUNCTION,1,QUERY_FUNCTION},
   {NULL,0,0,0},
  };

/*-------------------------- external data ----------------------------*/
extern char *temp_cmd;
extern char rexx_filename[10];
extern char rexx_pathname[MAX_FILE_NAME+1];
extern bool CAPREXXOUTx;
extern long CAPREXXMAXx;
extern bool rexx_output;
/***********************************************************************/
ULONG THE_Commands(
   PRXSTRING Command,    /* Command string passed from the caller    */
   PUSHORT   Flags,      /* pointer to short for return of flags     */
   PRXSTRING Retstr)     /* pointer to RXSTRING for RC return        */
{
/***********************************************************************/
/*--------------------------- local data ------------------------------*/
 int rc;
 SHVBLOCK shv;
 RXSTRING argstr;
/*--------------------------- processing ------------------------------*/
 if (allocate_temp_space(Command->strlength,TEMP_TEMP_CMD) != RC_OK)
   {
    display_error(30,(char *)"");
    *Flags = RXSUBCOM_ERROR;       /* raise an error condition   */
    sprintf(Retstr->strptr, "%d", rc);   /* format return code string  */
                                         /* and set the correct length */
    Retstr->strlength = strlen(Retstr->strptr);
    return 0;                            /* processing completed       */
   }
 memcpy((char *)temp_cmd,Command->strptr,Command->strlength);
 temp_cmd[Command->strlength] = '\0';

 if (strcmp("XXYYZZ",temp_cmd) == 0)
   {
    shv.shvnext=NULL;                     /* only one block */
    shv.shvcode=RXSHV_NEXTV;              /* direct set */

    argstr.strptr=NULL;
    argstr.strlength=0;
    shv.shvname=argstr;
    rc = 0;
    while(rc != 2)
     {
      rc = RexxVariablePool(&shv);     /* get the next variable */
      if (rc != 2)
        {
         sprintf(temp_cmd,"i <%s> <%s> <%d>",
             shv.shvname.strptr,shv.shvvalue.strptr,shv.shvvalue.strlength);
         command_line(temp_cmd,COMMAND_ONLY_FALSE);
        }
     }
   }
 else
   rc = command_line(temp_cmd,COMMAND_ONLY_FALSE);
 if (rc < 0)
    *Flags = RXSUBCOM_ERROR;       /* raise an error condition   */
 else
    *Flags = RXSUBCOM_OK;            /* not found is not an error  */

 sprintf(Retstr->strptr, "%d", rc);   /* format return code string  */
                                      /* and set the correct length */
 Retstr->strlength = strlen(Retstr->strptr);
 return 0;                            /* processing completed       */
}
/***********************************************************************/
LONG THE_Exit_Handler(
      LONG  ExitNumber,    /* code defining the exit function    */
      LONG  Subfunction,   /* code defining the exit subfunction */
      PEXIT ParmBlock)     /* function dependent control block   */
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern VIEW_DETAILS *vd_current;
extern WINDOW *foot;
extern char in_profile;
/*--------------------------- local data ------------------------------*/
 RXSIOTRC_PARM *trc_parm = (RXSIOTRC_PARM *)ParmBlock;
 LONG rc;
/*--------------------------- processing ------------------------------*/
 if (Subfunction != RXSIOSAY   /* ignore all but RXSIOSAY and RXSIOTRC */
 &&  Subfunction != RXSIOTRC)
    return(RXEXIT_NOT_HANDLED);
/*---------------------------------------------------------------------*/
/* If this is the first time this exit handler is called, set up the   */
/* handling of the result; either open the capture file, or set the    */
/* terminal out of curses mode so scrolling etc. work.                 */
/*---------------------------------------------------------------------*/
 if (!rexx_output)
   {
    rexx_output = TRUE;
    if (CAPREXXOUTx)
      {
       strcpy(temp_cmd,rexx_pathname);
       strcat(temp_cmd,rexx_filename);
       rexxoutfp = fopen(temp_cmd,"w");
      }
    else
      {
       if (!in_profile)
         {
          wmove(foot,0,COLS-1);
          wrefresh(foot);
          suspend_curses();
         }
       printf("\n");                       /* scroll the screen 1 line */
       fflush(stdout);
      }
   }
/*---------------------------------------------------------------------*/
/* If the REXX interpreter has been halted by line limit exceeded, just*/
/* return to the interpreter indicating that THE is hadnling the output*/
/* of messages. This is done to stop the "cluter" that comes back as   */
/* the interpreter tries to tell us that it is stopping.               */
/*---------------------------------------------------------------------*/
 if (rexx_halted)
    return(RXEXIT_HANDLED);
/*---------------------------------------------------------------------*/
/* If we are capturing the rexx output, print the string to the file.  */
/*---------------------------------------------------------------------*/
 if (CAPREXXOUTx)
   {
    fprintf(rexxoutfp,"%s\n",trc_parm->rxsio_string.strptr);
    rc = RXEXIT_HANDLED;
   }
 else
    rc = RXEXIT_NOT_HANDLED;
/*---------------------------------------------------------------------*/
/* If the number of lines processed exceeds the line limit, display our*/
/* own message telling what has happened and exit with                 */
/* RXEXIT_RAISE_ERROR. This tells the interpreter that it is to stop.  */
/*---------------------------------------------------------------------*/
 if (++captured_lines > CAPREXXMAXx)
   {
    if (CAPREXXOUTx)
       fprintf(rexxoutfp,"THE: REXX macro halted - line limit (%d) exceeded\n",CAPREXXMAXx);
    else
       printf("THE: REXX macro halted - line limit (%d) exceeded\n",CAPREXXMAXx);
    rc = RXEXIT_RAISE_ERROR;
    rexx_halted = TRUE;
   }
 return(rc);
}
/***********************************************************************/
ULONG THE_Function_Handler(
#if defined(EMX)
      CPSZ   FunctionName,  /* name of function */
      ULONG Argc,          /* number of arguments    */
      RXSTRING Argv[],     /* array of arguments in RXSTRINGs */
      CPSZ   QueueName,     /* name of queue */
      PRXSTRING Retstr)    /* return string   */
#else
      PSZ   FunctionName,  /* name of function */
      ULONG Argc,          /* number of arguments    */
      RXSTRING Argv[],     /* array of arguments in RXSTRINGs */
      PSZ   QueueName,     /* name of queue */
      PRXSTRING Retstr)    /* return string   */
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern VALUE item_values[MAX_VARIABLES_RETURNED];
/*--------------------------- local data ------------------------------*/
 ULONG rc;
 register int i;
/*--------------------------- processing ------------------------------*/
/*---------------------------------------------------------------------*/
/* Find the external function name in the array. Error if not found.   */
/*---------------------------------------------------------------------*/
 for (i=0;item[i].name != NULL;i++)
   {
/*  if (equal(FunctionName,item[i].name,strlen(FunctionName)))*/
    if (memcmpi(FunctionName,item[i].name,strlen(item[i].name))==0)
      {
       (void)get_item_values(item[i].item_number,"",item[i].query,Argc,Argv[0].strptr,Argv[0].strlength);
       Retstr->strptr = item_values[item[i].item_index].value;
       Retstr->strlength = item_values[item[i].item_index].len;
       return(0);
       break;
      }
   }
 return(1);                                    /* fatal error for REXX */
}
/***********************************************************************/
#ifdef PROTO
int initialise_rexx(void)
#else
int initialise_rexx()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 APIRET rc;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    initialise_rexx");
#endif

#if defined(USE_AIXREXX)
 rc = RexxRegisterSubcom((PSZ)"THE",
                         (PRXSUBCOM)&THE_Commands,
                         (PUCHAR)NULL);
#else
 rc = RexxRegisterSubcomExe((PSZ)"THE",
                           (PFN)&THE_Commands,
                           (PUCHAR)NULL);
#endif

 if (rc != RXSUBCOM_OK)
    return((int)rc);

#if defined(USE_AIXREXX)
 rc = RexxRegisterExit((PSZ)"THE_EXIT",
                       (PRXEXIT)&THE_Exit_Handler,
                       (PUCHAR)NULL);
#else
 rc = RexxRegisterExitExe((PSZ)"THE_EXIT",
                          (PFN)&THE_Exit_Handler,
                          (PUCHAR)NULL);
#endif
 if (rc != RXEXIT_OK)
    return((int)rc);

 for (i=0;item[i].name != NULL;i++)
   {
#if defined(USE_AIXREXX)
    rc = RexxRegisterFunction((PSZ)item[i].name,
                              (PRXFUNC)&THE_Function_Handler);
#else
    rc = RexxRegisterFunctionExe((PSZ)item[i].name,
                                 (PFN)&THE_Function_Handler);
#endif
    if (rc != RXFUNC_OK)
       return((int)rc);
   }

#ifdef TRACE
 trace_return();
#endif
 return((int)rc);
}
/***********************************************************************/
#ifdef PROTO
int finalise_rexx(void)
#else
int finalise_rexx()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 APIRET rc;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    finalise_rexx");
#endif

#if defined(USE_AIXREXX)
 rc = RexxDeregisterSubcom((PSZ)"THE");
 rc = RexxDeregisterExit((PSZ)"THE_EXIT");
#else
 rc = RexxDeregisterSubcom((PSZ)"THE",(PSZ)NULL);
 rc = RexxDeregisterExit((PSZ)"THE_EXIT",(PSZ)NULL);
#endif
 for (i=0;item[i].name != NULL;i++)
   {
    rc = RexxDeregisterFunction((PSZ)item[i].name);
   }
#ifdef TRACE
 trace_return();
#endif
 return((int)rc);
}

/***********************************************************************/
#ifdef PROTO
int execute_macro_file(char *filename,char *params)
#else
int execute_macro_file(filename,params)
char *filename;
char *params;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern VIEW_DETAILS *vd_current;
extern WINDOW *foot;
extern char in_profile;
extern bool error_on_screen;
extern char number_of_files;
/*--------------------------- local data ------------------------------*/
#if defined(USE_REGINA) || defined(USE_AIXREXX)
 LONG rexxrc;
#else
 USHORT rexxrc;
#endif
 RXSTRING retstr;
 RXSTRING argstr;
 APIRET rc;
 CHAR retbuf[250];
 LONG num_params;
 char *rexx_args=NULL;
 RXSYSEXIT exit_list[2];                /* system exit list           */
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    execute_macro_file");
#endif
/*---------------------------------------------------------------------*/
/* Determine how many parameters are to be passed to the interpreter.  */
/* Only 0 or 1 are valid values.                                       */
/*---------------------------------------------------------------------*/
 if (params == NULL
 || strcmp(params,"") == 0)
   {
    num_params = 0;
    MAKERXSTRING(argstr,"",0);
   }
 else
   {
    num_params = 1;
    if ((rexx_args = (char *)malloc(strlen(params)+1)) == (char *)NULL)
      {
       display_error(30,(char *)"");
#ifdef TRACE
       trace_return();
#endif
       return(RC_OUT_OF_MEMORY);
      }
    strcpy(rexx_args,params);
    MAKERXSTRING(argstr,rexx_args,strlen(rexx_args));
   }

 MAKERXSTRING(retstr,retbuf,sizeof(retbuf));

/*---------------------------------------------------------------------*/
/* Set up pointer to REXX Exit Handler.                                */
/*---------------------------------------------------------------------*/
 exit_list[0].sysexit_name = "THE_EXIT";
 exit_list[0].sysexit_code = RXSIO;
 exit_list[1].sysexit_code = RXENDLST;

 captured_lines = 0L;
 rexx_output = FALSE;
 rexx_halted = FALSE;
/*---------------------------------------------------------------------*/
/* Call the REXX interpreter.                                          */
/*---------------------------------------------------------------------*/
 rc = RexxStart((LONG)num_params,
               (PRXSTRING)&argstr,
               (PSZ)filename,
               (PRXSTRING)NULL,
               (PSZ)"THE",
               (LONG)RXCOMMAND,
               (PRXSYSEXIT)exit_list,
#if defined(USE_OS2REXX)
               (PSHORT)&rexxrc,
#else
               (PLONG)&rexxrc,
#endif
               (PRXSTRING)&retstr);

/*---------------------------------------------------------------------*/
/* Edit the captured file or clean up after REXX output displays.      */
/*---------------------------------------------------------------------*/
 if (rexx_output)
   {
    rexx_output = FALSE;
    if (CAPREXXOUTx)
      {
       fclose(rexxoutfp);
       strcpy(temp_cmd,rexx_pathname);
       strcat(temp_cmd,rexx_filename);
       if (!in_profile)
          Xedit(temp_cmd);
      }
    else
      {
       if (in_profile)
          error_on_screen = TRUE;
       else
/*---------------------------------------------------------------------*/
/* Pause for operator intervention and restore the screen to the       */
/* current screen if there are still file(s) in the ring.              */
/*---------------------------------------------------------------------*/
         {
          printf("\n%s",HIT_ANY_KEY);
          fflush(stdout);
          resume_curses();
          (void)my_getch(foot);
          if (number_of_files > 0)
             restore_THE();
         }
      }
   }

 if (rexx_args != NULL)
    free(rexx_args);
#ifdef TRACE
 trace_return();
#endif
 return((int)rc);
}
/***********************************************************************/
#ifdef PROTO
int set_extract_variables(char *item)
#else
int set_extract_variables(item)
char *item;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
extern VALUE item_values[MAX_VARIABLES_RETURNED];
/*--------------------------- local data ------------------------------*/
 register int i;
 int rc,number_values;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    set_extract_variables");
#endif
 number_values = atoi(item_values[0].value);
 for (i=0;i<number_values+1;i++)
  {
   rc = set_rexx_variable(item,item_values[i].value,i);
   if (rc != RXSHV_OK && rc != RXSHV_NEWV)
     {
      display_error(25,(char *)"");
      rc = RC_SYSTEM_ERROR;
      break;
     }
   else
      rc = RC_OK;
  } 
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
int set_rexx_variable(char *name,char *value,int suffix)
#else
int set_rexx_variable(name,value,suffix)
char *name;
char *value;
int suffix;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
 SHVBLOCK shv;
 CHAR variable_name[50];
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("rexx.c:    set_rexx_variable");
#endif

 shv.shvnext=NULL;                                   /* only one block */
 shv.shvcode=RXSHV_SYSET;                          /* symbolic set set */
/*---------------------------------------------------------------------*/
/* This calls the RexxVariablePool() function for each value. This is  */
/* not the most efficient way of doing this.                           */
/*---------------------------------------------------------------------*/
 sprintf(variable_name,"%s.%-d",name,suffix);
 make_upper(variable_name);            /* make variable name uppercase */
/*---------------------------------------------------------------------*/
/* Now (attempt to) set the REXX variable                              */
/* Add name/value to SHVBLOCK                                          */
/*---------------------------------------------------------------------*/
 MAKERXSTRING(shv.shvname, variable_name, strlen(variable_name));
 MAKERXSTRING(shv.shvvalue,value,strlen(value));
/*---------------------------------------------------------------------*/
/* One or both of these is needed, too <sigh>                          */
/*---------------------------------------------------------------------*/
 shv.shvnamelen=strlen(variable_name);
 shv.shvvaluelen=strlen(value);

#if defined(USE_OS2REXX) || defined(USE_AIXREXX)
 rc=(int)RexxVariablePool(&shv);              /* Set the REXX variable */
#else
 rc = RexxVariablePool(&shv);                 /* Set the REXX variable */
 rc = RXSHV_OK;
#endif
 if (rc != RXSHV_OK && rc != RXSHV_NEWV)
   {
    display_error(25,(char *)"");
    rc = RC_SYSTEM_ERROR;
   }
 else
    rc = RC_OK;
 return(rc);
}
#else
/***********************************************************************/
#ifdef PROTO
int set_rexx_variable(char *name,char *value,int suffix)
#else
int set_rexx_variable(name,value,suffix)
char *name;
char *value;
int suffix;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
/*---------------------------------------------------------------------*/
/* This is a dummy routine because this function is referenced in      */
/* query.c.                                                            */
/*---------------------------------------------------------------------*/
 return(0);
}
#endif
