#include <windows.h>
#include <commdlg.h>
#include <fstream.h>
#include <string.h>

int GetModuleDescription(const char *filename, char *descrip, BYTE len);
char achCmdLine[128];
OPENFILENAME ofn;

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
  {
  char achDescrip[0xFF];
  char szFile[128];
  UINT  i;
  char  szFilter[]=
    "Windows Programs|*.exe|"
    "Windows Libraries|*.dll|"
    "Control Panel Applets|*.cpl|"
    "Screen Savers|*.scr|"
    "All Files (*.*)|*.*|";
  char  szDefExt[]="exe";

  for (i = 0; szFilter[i] != '\0'; i++)
    {
    if (szFilter[i] == '|')
       szFilter[i] = '\0';
    }

  /* Set all structure members to zero. */
  memset(&ofn, 0, sizeof(OPENFILENAME));

  _fstrcpy(achCmdLine,lpCmdLine);


  if (achCmdLine[0] == '\0')
    {
    i=1;

    do
      {
      szFile[0] = '\0';
      ofn.lStructSize = sizeof(OPENFILENAME);
      ofn.hwndOwner = NULL;
      ofn.lpstrFilter = szFilter;
      ofn.nFilterIndex = 1;
      ofn.lpstrFile= szFile;
      ofn.nMaxFile = sizeof(szFile);
      ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
      ofn.lpstrDefExt = szDefExt;

      i = GetOpenFileName(&ofn);

      if ( i != 0)
        {
        switch(GetModuleDescription(szFile,achDescrip,sizeof(achDescrip)))
          {
	  case 0:  MessageBox(NULL,achDescrip,"Module Description",
	             MB_OK | MB_ICONINFORMATION);
                   break;
	  case 1:  MessageBox(NULL,"File processing error","Module Description",
		     MB_OK | MB_ICONINFORMATION);
                   break;
	  case 2:  MessageBox(NULL,"Invalid executable header information.\n\n"
				   "    May not be a Windows 3.1\n"
				   "    Executable or Dynamic Link\n"
				   "    Library","Module Description",
		     MB_OK | MB_ICONINFORMATION);
	  }
        }
      }
    while(i != 0);
    }

  else
    {
    switch(GetModuleDescription(achCmdLine,achDescrip,sizeof(achDescrip)))
      {
      case 0:  MessageBox(NULL,achDescrip,"Module Description",
                 MB_OK | MB_ICONINFORMATION);
               break;
      case 1:  MessageBox(NULL,"File processing error","Module Description",
                 MB_OK | MB_ICONINFORMATION);
               break;
      case 2:  MessageBox(NULL,"Invalid executable header information.\n\n"
                               "    May not be a Windows 3.1\n"
			       "    Executable or Dynamic Link\n"
			       "    Library","Module Description",
		               MB_OK | MB_ICONINFORMATION);
      }
    }

  return(0);
  }

int GetModuleDescription(const char *filename, char *descrip, BYTE len)
  {
  /* finds the module description found in the non-resident name table of the
           Windows Executable Header
     filename    path to the file
     descrip     address of return buffer
     len         size of the return buffer
     returns 0 and alters descrip if found
	     1 if file error
	     2 if invalid header information */

  ifstream ifsExeFile;
  UINT offset;
  BYTE bDescripSize;

  ifsExeFile.open( filename, ios::in|ios::binary);
  ifsExeFile.seekg(0x3C);
  ifsExeFile.read((char*)&offset,2);
  ifsExeFile.seekg(offset);
  ifsExeFile.read((char*)&offset,2);
  if (ifsExeFile.bad())
    return(1);

  if (!(LOBYTE(offset) == 'N' && HIBYTE(offset) == 'E'))
    return(2);
  else
    {
    ifsExeFile.seekg(0x2A,ios::cur);
    ifsExeFile.read((char*)&offset,2);
    ifsExeFile.seekg(offset);
    ifsExeFile.read(&bDescripSize,1);
    if (bDescripSize > len-1)
      bDescripSize = len-1;
    ifsExeFile.read(descrip,(int)bDescripSize);
    if (ifsExeFile.bad())
      return(1);

    descrip[bDescripSize] = '\0';
    }
  return(0);
  }