/*********************************************************************/
/*                                                                   */
/*    Name:    VDRIVE.H                                              */
/*                                                                   */
/*    Copyright (c) Stewart A. Berman 1992, All rights reserved      */
/*                                                                   */
/*********************************************************************/
#ifndef __VDRIVE_H__
#define __VDRIVE_H__

#include "IOStatus.h"
#include "HandleSt.h"

#define FD0000          0x0000
#define FD0360          0x0001
#define FD0720          0x0004
#define FD1200H         0x0002
#define FD1200          0x0003
#define FD1440H         0x0008
#define FD1440          0x000C
#define FD2880H         0x0010
#define FD2880          0x001C
#define FDALL           0x001F
#define FDUNKNOWN       0x4000

#define DRIVESECTORSIZE 512

#define FLAGS_ALLOCATED_CLUSTERS  0x0001
#define FLAGS_ALLOCATED_CYLINDERS 0x0002
#define FLAGSSUPPORTED FLAGS_ALLOCATED_CYLINDERS

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

UINT       FAR PASCAL VDriveFlag ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveForceReset ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveFormatTrack ( VOID far *pCVDrive, UINT nCylinders, UINT nHead ) ;
BOOL       FAR PASCAL VDriveIsDoubleSpaceCVF ( VOID far *pCVDrive ) ;
BOOL       FAR PASCAL VDriveIsDoubleSpaceHost ( VOID far *pCVDrive ) ;
BOOL       FAR PASCAL VDriveIsRemote ( VOID far *pCVDrive ) ;
BOOL       FAR PASCAL VDriveIsRemovable ( VOID far *pCVDrive ) ;
BOOL       FAR PASCAL VDriveIsUseable ( VOID far *pCVDrive ) ;
BOOL       FAR PASCAL VDriveIsUsed ( VOID far *pCVDrive ) ;
char       FAR PASCAL VDriveLetter ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveNumberOfCylinders ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveNumberOfHeads ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveNumberOfSectors ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveReadSectors ( VOID far *pCVDrive, UINT nCylinder, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer ) ;
UINT       FAR PASCAL VDriveReset ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveSetRead ( VOID far *pCVDrive, UINT nTempType ) ;
UINT       FAR PASCAL VDriveSetType ( VOID far *pCVDrive, UINT nNewType ) ;
UINT       FAR PASCAL VDriveSetWrite ( VOID far *pCVDrive, UINT nTempType ) ;
UINT       FAR PASCAL VDriveType ( VOID far *pCVDrive ) ;
UINT       FAR PASCAL VDriveWriteSectors ( VOID far *pCVDrive, UINT nCylinder, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer ) ;

#ifdef __cplusplus
           }
#endif /* __cplusplus */

#endif /* __VDRIVE_H__ */
