; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will return the status of a bit of a given integer.
;
; Usage:  Result% = BitTest (Input%, BitNum%)
; Declare: DECLARE FUNCTION BitTest% (BYVAL Input%, BYVAL BitNum%)
;
; Where Input% is the integer containing our flags, BitNum% is the bit
; number to test, and Result% contains a zero if the flag wasn't set, or a
; -1 (true) if the flag was set.
;
; Bit numbers range from 1 to 16.  Actual form: 16 15 14 ... 4 3 2 1 which
; corresponds to 64k 32k 16k ... 8 4 2 1.
;
; No error checking is done for 0 or numbers greater than 16.
;

.Model Medium, Basic
.Code

            PUBLIC  BitTest           ;Make this routine available to LINK.

BitTest     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            xor     ax,ax             ;Start with a zero.
            mov     bx,[bp + 08]      ;Get integer to test.
            mov     cx,[bp + 06]      ;Get size, all we really want is CL.
            ror     bx,cl
            jnc     Done
            dec     ax
      Done: pop     bp
            ret     4                 ;Pop-return past our input parameters.

BitTest     endp                      ;End of routine.

End


