; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will first convert any non-text characters to spaces, then
; all multiple spaces will be reduced to a single space.  CR/LF's aren't
; converted.
;
; Usage:  Result% = Crunch (Input$)
; Where Input$ is our string to work on, and Result% contains our new
; length for that string.
;
; Proper usage: Result% = Crunch (Input$)
;               NewString$ = LEFT$(Input$,Result%)
;
; Ideally one could simply change the string's length field--but this leads
; to string space corruption.
;
;
; The (more or less) equivalent Basic code:
;
; FUNCTION Crunch$ (K$)
; K0$ = HiStrip$
; MID$(K0$,1,13) = SPACE$(13)
; MID$(K0$,15,17) = SPACE$(17)
; CALL StrXLate(K$,K0$)
; K = StrSrch(1,K$,"  ")
; WHILE K > 0
;   K$ = LEFT$(K$,K - 1) + MID$(K$,K + 1)
;   K = StrSrch(K,K$,"  ")
; WEND
; Crunch$ = LTRIM$(RTRIM$(K$))
; END FUNCTION
;

.Model Medium, Basic
.Code

            PUBLIC  Crunch            ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc

Crunch      proc    uses DS, Descriptor

            cld                       ;Forward string operations.

            mov     ax,Descriptor     ;Get Input$'s descriptor.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;If null, then exit.

            mov     ds,dx
            xchg    si,ax             ;Get Input$'s address into SI.

            mov     di,si             ;Our starting placement location too.
            mov     dx,si             ;And save it for later.
            push    ds                ;Copy DS,
            pop     es                ;to ES for the string operations.
            mov     ah,32             ;To remove all leading spaces.
        R1: lodsb                     ;Get a byte into AL.
            cmp     al,13             ;If a CR,
            je      R3                ; then we want it.
            cmp     al,10             ;If a LF,
            je      R3                ; then we want it.
            cmp     al,126            ;If > CHR$(126),
            ja      R2                ; then we don't want it.
            cmp     al,32             ;If > CHR$(32),
            ja      R3                ; then we want it.
        R2: mov     al,32             ;Substitute with a space.
            cmp     ah,32             ;Was our last character a space?
            je      R4                ;Yes, so ignore this one.
            cmp     ah,13             ;Was our last character a CR?
            je      R4                ;Yes, so ignore this space.
            cmp     ah,10             ;Was our last character a LF?
            je      R4                ;Yes, so ignore this space.
        R3: mov     ah,al             ;Save AL to AH.
            stosb                     ;Save AL into DI.
        R4: loop    R1                ;Check the whole string.
            sub     di,dx             ;Obtain the new length of Input$.
            jz      Done              ;If zero, then jump.
            cmp     ah,32             ;Is the last character a space?
            jne     Done              ;Nope.
            dec     di                ;Yep, remove it.
      Done: xchg    ax,di             ;Return with the new size.
            ret

Crunch      endp                      ;End of routine.

End

