; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will convert 3 integers, containing a day, a month, and a
; year, to an integer (2 byte) representation.  Note, this is not DOS standard
; date format.  It's bit's form: YYYYYYYMMMMDDDDD, which is DOS standard, but
; unlike DOS, which starts it's year's at 1980, I start my year at 1900.
; Thus, the routine can handle the time period from 1/1/1900 to 12/31/2027.
;
; Usage:  Result% = DateInt(Day%, Month%, Year%)
; Declare:  DECLARE FUNCTION DateInt% (BYVAL Day%, BYVAL Month%, BYVAL Year%)
;
; Where Day% is a day of the month (1-31), Month% is a month of the year
; (1-12), Year% is a year (0-127 or 1900-2027), and Result% is the resulting
; integer form.
;
; It correctly handles non-DOS (ie. 1900-2027 not 1980 to whatever) years of
; either two or 4 digits.  To use this with a DOS standard integer date,
; subtract 80 from the year.
;
; The routine will properly handle out-of-range values, but those out-of-range
; for one field could screw up the data for all three fields.
;

.Model Medium, Basic
.Code

            PUBLIC  DateInt           ;Make this routine available to LINK.

DateInt     proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp
            mov     ax,[bp + 06]      ;Move Year% to AX (Result%).
            cmp     ax,1900           ;If Year% is less than 1900,
            jl      R1                ;then move on,
            sub     ax,1900           ;else subtract 1900.
        R1: mov     cl,04             ;Shift it over past Month%'s spot.
            shl     ax,cl             ;Do actual shift.
            add     ax,[bp + 08]      ;Insert Month% into AX.
            mov     cl,05             ;Shift it over past Day%'s spot.
            shl     ax,cl             ;Do actual shift.
            add     ax,[bp + 0AH]     ;Add Day% to AX.
            pop     bp
            ret     6                 ;Pop-return past our 3 input parameters.

DateInt     endp                      ;End of routine.

End

