; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will open a file using DOS's file handle abilities.
;
; Usage:  Result% = FileOpen (FileName$,Attr%)
; Declare:  DECLARE SUB FileOpen (FileName$, BYVAL Attr%)
;
; Where FileName$ is a string containing the drive\path\filename of the file
; to open.  Result% contains the file handle DOS has given us to use.
;
; If the file doesn't exist, it will be created.  If the string is null,
; nothing is done and -1 is returned.
;
; The code below sets the SHARE delay and retry values (if SHARE.EXE is not
; installed, nothing is changed).
; CX is the number of delay loops (not sure if there is any precise timing)
; DX is the number of retries to do (doing delay loops between each).
;
; When a share violation occurs (eg. one process attempts to open for read a
; file without open for read access) DOS brings up "share violation: abort,
; retry, fail?"  immediately.  Making it useless for BBS operations.  So
; I change the delay/retries (which also affects the delay/retries for all
; other processes too) to a really long version.   Thus, on the XT it'll
; wait up to an hour before giving up and asking the console.  Ideally
; however, a half-hour is probably best--I use the hour value because
; I'm just not sure what kind of delay there will be on faster processors.
; 
; Testing with an 10 MHZ XT:
;   CX  DX     Delay
;    1   3     none  (DOS default)
;   10  10     15 seconds
;   20  10     29 seconds
;   10  20     29 seconds
;    5  20     14 seconds
;    5  40     29 seconds
;    5  1000   11:45
;    5  5000   1 hour  (projected, based on (DX * .7) \ 60
;

.Model Medium, Basic


.data

FileNam2Buf DB      65 dup (0)


;
; Actual program code begins.
;
.Code

            PUBLIC  FileOpen          ;Make this routine available to LINK.

            extrn   StringLength: proc
            extrn   StringAddress: proc
            extrn   Delay:far

FileOpen    proc    uses DS, Descriptor, Attr

            cld                       ;Move forward in string.

            mov     ax,440BH          ;DOS service to set SHARE settings.
            mov     cx,5              ;Delay loops.
            mov     dx,5000           ;Retries to do.
            int     21H
            clc                       ;For when no SHARE is installed.

            mov     ax,Descriptor     ;Descriptor of FileName$.
            push    ax
            call    StringLength
            xchg    cx,ax             ;Put it's size in CX.
            jcxz    Done              ;Do nothing if null.

            push    cx                ;Save the length for later.

            push    ds
            pop     es
            lea     di,FileNam2Buf    ;DI for FileNam2Buf.
            push    di                ;Save it for the MOVSB.
            xor     ax,ax             ;Clear out the filename area.
            mov     cx,20H            ;32 x 2 bytes.  This allows us to not
            rep     stosw             ;need an ASCIIZ file name--we always
                                      ;give DOS 64 characters and a CHR$(0).

            push    es
            mov     ax,Descriptor     ;Descriptor of FileName$.
            push    ax
            call    StringAddress
            mov     ds,dx
            mov     si,ax
            pop     es

            pop     di                ;Location of FileNam2Buf.
            pop     cx                ;Get our length back.
            mov     dx,di             ;Save location for the DOS call.
            rep     movsb             ;Copy (ES:DI) <- (DS:SI).

            push    es
            pop     ds
        R0: mov     ax,3D00H          ;Subfunction 3DH.
            add     ax,Attr
            int     21H               ;DOS Services: Open a file handle.

            jnc     Done              ;If CF = 0, then we succeeded, so exit.
            cmp     ax,2              ;File not found.  We can handle that.
            je      R1
            cmp     ax,5              ;Access Denied, try again.
            jne     D1                ;Another error.  Very bad.
            call    Delay
            jmp     R0

        R1: mov     ah,3CH            ;Subfunction 3CH.
            xor     cx,cx             ;Normal file attributes.
            int     21H               ;DOS Services: Create a file.
                                      ;Also returns a handle.
            jnc     Done              ;File created OK, exit.

        D1: mov     ax,0FFFFh         ;Couldn't do it, exit with error.
      Done: ret

FileOpen    endp                      ;End of routine.

End

