; Copyright (c) 1991-1994, John David Rohner.  All rights reserved.

;
; This routine will retrieve a data string from a file at a specific location.
;
; Usage:  CALL FileGetSLoc(Handle%, Location&, Input$)
; Declare: DECLARE SUB FileGetSLoc (BYVAL Handle%, BYVAL Location&, Input$)
;
; Where Handle% is the file handle to use, Location& is the location - 1 to
; load from, and Input$ will contain the data loaded.
;
; Input$ must be buffered first to the size of the data we are to load.
;
; Location& specifies the location to load the data from--using a 0..n scale,
; which means we actually load from location Location& + 1.
;
; It does no negative number checking.  A zero put's it at position 1.  A 3
; put's it on the 4th character, and so on.  Thus, no more need for the "+ 1"
; when doing: (rec - 1) * len + 1   to position it, now (rec - 1) * len does
; it.
;

.Model Medium, Basic
.Code

            PUBLIC  FileGetSLoc       ;Make this routine available to LINK.

            extrn   StringAddress: proc
            extrn   StringLength: proc
            extrn   Delay:far

FileGetSLoc proc    far               ;Beginning of routine.

            push    bp
            mov     bp,sp

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
            mov     ax,4200H          ;Subfunction to seek to loc in file.
            mov     dx,[bp + 08]      ;Low order word of long offset.
            mov     cx,[bp + 0AH]     ;High order word of long offset.
            int     21H               ;Call DOS Services to do it.

            mov     ax,[bp + 06]      ;Descriptor of Input$.
            push    ax
            push    ax
            call    StringLength
            xchg    ax,di
            call    StringAddress
            mov     cx,di
            jcxz    Done              ;Quick exit if a null string.

            mov     bx,[bp + 0CH]     ;Get the file handle into BX.
            push    ds
            mov     ds,dx
            mov     dx,ax             ;Data buffer to read in.
        R0: mov     ah,3FH            ;Subfunction to read from a file.
            int     21H               ;CALL DOS Services to do it.
            jnc     R1                ;No errors, so continue.
            cmp     ax,5              ;Access Denied, try again.
            jne     R1
            call    Delay
            jmp     R0

        R1: pop     ds

      Done: pop     bp
            ret     8                 ;Pop-return past our input parameters.

FileGetSLoc endp                      ;End of routine.

End



