' $INCLUDE: 'JDRBBS.INC'
'
' Copyright (c) 1991-1994, John David Rohner.  All rights reserved.
'
' Included in this package:
'   Initializer
'   BuildPathFile
' CommPort is usually 0 for all this.




        '* * * * * *
        ' This routine will initialize various variables.  It will
        ' also do general array loading of externally defined stuff.
        '
        ' p0 number of directories
        '
        ' It's called when the BBS is started up, and when the system
        ' is restarted after a shutdown (for doors).
        '
        ' Date last checked for perfection: Sep 16 1992
        '
SUB Initializer (p,p0)

  '
  ' Turn the cursor off--a cursor jumping all over the screen is not a pretty
  ' sight.
  '
  CALL CursorOff
  K2& = FRE(-1)
  GInUse = 0
  UGInUse = 0
  DialSuccess = 0
  '
  ' Variables.
  '   Cx$      for global (used a lot) single or dual character strings.
  '   Chars$() for single characters (ASCII set, replaces slow CHR$).
  '   Short$() for no-text (usally short) strings.
  '   Lines$() for text (user changeable/multi-language) lines of various
  '            lengths.
  '
  '
  ' Miscellaneous other variables.
  '
  DIM Chars$(255)
  K$ = SPACE$(256)
  FOR K = 0 to 255
    Chars$(K) = CHR$(K)
    MID$(K$,K + 1,1) = Chars$(K)
  NEXT
  C0$    = Chars$(0)
  C1$    = Chars$(1)
  C7$    = Chars$(7)
  C8$    = Chars$(8)
  C13$   = Chars$(13)
  C32$   = " "
  C41$   = Chars$(41)
  Null$  = ""
  C1310$ = C13$ + Chars$(10)

  DIM GlobalStuff$(27)
  GlobalStuff$(14) = SPACE$(65) + MID$(K$,66,26) + "      " + MID$(K$,66,26) + _
                     SPACE$(133)                  'Upper case and strip.
  GlobalStuff$(15) = SPACE$(127) + MID$(K$,128)   'XLate normal chars.
  GlobalStuff$(16) = LEFT$(K$,127) + SPACE$(129)  'XLate special chars.
  GlobalStuff$(19) = Null$
  GlobalStuff$(21) = Null$      'Language carry-over.
  GlobalStuff$(23) = Null$  'Stores the clean pathname of the ICht file.
  GlobalStuff$(24) = Null$  'Stores the 8 char net-detect buffer.
  GlobalStuff$(25) = SPACE$(6)  'Stores base net address.
  GlobalStuff$(26) = Null$      'Stores current GIP object stuff to show.
  GlobalStuff$(27) = Null$      'Stores McEditor temp stuff.
  '
  ' Tell 'em who we are.
  '
  K$ = "[0m[2J" + C1310$ + Title1 + C1310$ + Title2 + C1310$ + C1310$
  CALL Ansi(K$)
  '
  ' Read in the path/file information.  Load up Paths$() and FileNames().
  '
  kk$ = Command$
  K1$ = UCASE$(kk$)
  zk = StrSrch1(K1$,63)
  Settings.Node = 1
  zzn = WordsCnt(K1$)

'I think /node=x is required for all non-1 nodes!  since I load files so early.

  FOR K0 = 1 TO zzn
    K2$ = WordsGet$(K1$,K0,0)
k1 = strsrch1(k2$,61)
if k1 = 0 then if k0 <> zzn then k3$ = WordsGet$(K1$,K0 + 1,0) _
                            else k3$ = null$
    SELECT CASE zk
      CASE IS > 0
           TT$ = "Usage: JDRBBS [/option][ /option][ /option...]" + C1310$ + _
                 "/?        this help." + C1310$ + _
                 "/NODE=x   to start up node x." + C1310$ + _
                 "/PORT=x   to reset the current COMx port to x." + C1310$ + _
                 "/BAUD=x   to reset the baud rate for this port (1200/2400/9600/19200/38400)." + C1310$ + _
                 "/INIT=x   to reset the modem initialization string." + C1310$ + _
                 "/LOG=x    to change the current logging amount (see docs)." + C1310$ + _
                 "/1STCMD=x to reset the first command to x (x is 4 characters)." + C1310$ + _
                 "/BIOS     to toggle BIOS screen writing (on to off, off to on)." + C1310$ + C1310$
           CALL Ansi(TT$)
           END
      CASE ELSE
           IF MID$(K1$,2,4) = "NODE" OR LEFT$(K1$,4) = "NODE" _
              THEN IF K1 > 0 THEN Settings.Node = Val2&(K2$) _
                             ELSE Settings.Node = Val2&(K3$) : _
                                  k0 = k0 + 1
    END SELECT
  NEXT
  CommPort = 0
  K20 = FindF2("PATHS.DAT",FFile)
  IF NOT K20 THEN CALL BuildPathFile(p)
  DIM Paths$(12)
  DIM FileNames(143) AS STRING * 40
  User.UserName = Null$
  User.Language = Null$
  GlobalStuff$(7) = Null$
  DIM Blocks&(3,99)
  TT = 0
  CALL LoadFixedFiles     'Load up filenames/etc. for ENGlish.

  '
  ' Read in RUN_DOOR.BAT, see if we are returning or not.
  '
  K = FileOpenR(FileNames(54))
  p = Val2&(FileGetLine$(K,0&))         'If not zero then don't show.
  CALL FileCloseR(K)
  '
  ' Display beginning memory.
  '


  CALL LoadShort

  IF p = 0 _
     THEN TT$ = Short$(887) + CopyRight + C1310$ + Short$(906) + _
                Form2$(17,FRE(C0$)) + Form2$(8,FRE(-2)) + Form2$(12,K2&) : _
          CALL Ansi(TT$)

  DIM Handle(30)                                     '30 file handles.

  '
  ' Read in system settings.  (everyone needs Settings.Node)
  ' jdrbbs.exe yields:  /baud=xxx -baud=xxx baud=xxx
  ' but shroom will yield:  baud xxx
  '
  K = FileOpenW(FileNames(75))
  K0 = Settings.Node
  CALL FileGetLoc(K,0&,901,Settings)
  Settings.Node = K0
  IF NOT K20 THEN Settings.CommPort = 0 : _
                  Settings.DrDrives = Chars$(65 + DrCurrent) : _
                  Settings.StartTime = TIME$ : _
                  Settings.StartDate = DateToInt(DATE$)
  zzn = WordsCnt(K1$)
  FOR K0 = 1 TO zzn
    K2$ = WordsGet$(K1$,K0,0)
    K1 = StrSrch1(K2$,61)
    IF K1 > 0 THEN K3$ = MID$(K2$,K1 + 1) : _
                   K2$ = LEFT$(K2$,K1 - 1) _
              ELSE if k0 <> zzn then K3$ = WordsGet$(K1$,K0 + 1,0) _
                                ELSE K3$ = Null$
    zk = AscNull(K2$)
    IF zk = 92 OR zk = 47 OR zk = 45 THEN K2$ = MID$(K2$,2)
    zk = 0
    FOR K2 = 1 TO 7
      IF K2$ = WordsGet$(Short$(924),K2,0) THEN zk = K2
      SELECT CASE zk
        CASE 1 : Settings.CommPort = Val2&(K3$)
                 CALL BitClear(Settings.Toggles2,15)
                 zk = -1
        CASE 2 : Settings.ModemBaud = Val2&(K3$)
        CASE 3 : Settings.LoggingAmount = AttrToInt(K3$)
        CASE 4 : IF K1 > 0 THEN K3$ = MID$(kk$,K1 + 1) _
                           ELSE if k0 <> zzn then K3$ = WordsGet$(kk$,K0 + 1,0) _
                                             ELSE K3$ = Null$
                 Settings.FirstCommand = K3$
        CASE 5 : CALL BitToggle(Settings.Toggles2,1)
                 zk = -1
        CASE 6 : Settings.ModemInit = K3$
        CASE 7 : SumLog.BaudRate = K3$
                 p = -2
      END SELECT
      IF zk <> 0 THEN EXIT FOR
    NEXT
  NEXT
  CALL FilePutLoc(K,0&,901,Settings)
  CALL FileCloseW(K)
  CALL KeyStuff(Settings.Key1,Settings.Key2,Settings.Key3,Settings.Sysop)
  CALL CursorOff
  '
  ' Open our always-opened files.
  '
  IF BitTest(Settings.Toggles2,8) THEN Handle(1) = FileOpenW(FileNames(51))
  '
  ' Load up some stuff.  Done this way to help readablity (and keeps it in
  ' order).
  '
  FOR K = 1 TO 6
    SELECT CASE K
      CASE 1 : K0 = 71
      CASE 2 : K0 = 20
      CASE 3 : K0 = 38
      CASE 4 : K0 = 68
      CASE 5 : K0 = 32
      CASE 6 : K0 = 72
    END SELECT
    K1 = FileOpenR(FileNames(K0))
    SELECT CASE K
      CASE 1
           '
           ' Read in the security level information.  Load up Levels().
           '
           LevelsSize = FileLof&(K1,28)
           REDIM Levels(LevelsSize) AS LevelRecord
           FOR K2 = 1 TO LevelsSize
             CALL FileGetRec(K1,K2,28,Levels(K2))
           NEXT
      CASE 2
           '
           ' Read in the file areas.  Load up FileAreaI().
           '
           p0 = FileLof&(K1,188)
           REDIM FileAreaI(p0) AS FileAreaIRecord
           FOR K2 = 1 TO p0
             CALL FileGetRec(K1,K2,188,FileArea)
             FileAreaI(K2).DLSL      = FileArea.DLSL
             FileAreaI(K2).ScanSL    = FileArea.ScanSL
             FileAreaI(K2).Attr      = FileArea.Attr
             FileAreaI(K2).HiFilePtr = FileArea.HiFilePtr
             FileAreaI(K2).FileOp    = StrCkSum(FileArea.FileOp)
           NEXT
      CASE 3
           '
           ' Read in the message bases.  Load up MsgAreaI().
           '
           BasesSize = FileLof&(K1,108) - 1
           REDIM MsgAreaI(BasesSize + 1) AS MsgAreaIRecord
           FOR K2 = 0 TO BasesSize
             CALL FileGetRec(K1,K2 + 1,108,MsgArea)
             IF MsgArea.NextNumber = 0 THEN MsgArea.NextNumber = 1
             MsgAreaI(K2 + 1).SubType    = MsgArea.SubType
             MsgAreaI(K2 + 1).SLen       = StripLen(RTRIM$(MsgArea.Title))
             MsgAreaI(K2 + 1).NextNumber = MsgArea.NextNumber
             MsgAreaI(K2 + 1).ScanSL     = MsgArea.ScanSL
           NEXT
           UserMsgInfo$  = STRING$(BasesSize * 5 + 5,0)
      CASE 4
           '
           ' Load up Languages.
           '
           GlobalStuff$(19) = SPACE$(FileLof&(K1,1))
           CALL FileGetSLoc(K1,0&,GlobalStuff$(19))
      CASE 5
           '
           ' Load up DoPaths$().
           '
           K2 = FileLof&(K1,144)
           REDIM DoPaths$(K2)
           K$ = SPACE$(72)
           K& = -144
           FOR K3 = 1 TO K2
             K& = K& + 144
             CALL FileGetSLoc(K1,K&,K$)
             DoPaths$(K3) = RTRIM$(K$)
           NEXT
      CASE 6
           '
           ' Load up Events.
           '
           k& = -54
           K$ = SPACE$(14)
           FOR K2 = 1 TO FileLof&(K1,54)
             k& = k& + 54
             CALL FileGetSLoc(K1,k&,K$)
             GlobalStuff$(18) = GlobalStuff$(18) + K$
           NEXT
    END SELECT
    CALL FileCloseR(K1)
  NEXT
  '
  ' Tell the sysop what's happening.
  '
  CommPort = Settings.CommPort
  IF p > 0 AND NOT BitTest(Settings.Toggles2,2) _
     THEN CALL Ansi(Short$(439)) : _
          IF NoCarrier THEN CALL Ansi(Short$(916))
  CommPort = 0

  '
  ' Define some global strings.
  '
  GlobalStuff$(1) = Chars$(90)        'CommProg default/current protocol.
  GlobalStuff$(2) = FileAreaInfo3$(1,2)  'CommProg download directory.
  GlobalStuff$(3) = C0$                 'For 'turn tables'.
  GlobalStuff$(4) = Null$               ''Gosub menu system' path.
  GlobalStuff$(5) = MKI$(0)             'Last loaded file list specs
  GlobalStuff$(6) = Null$               'The actual file list spec
  GlobalStuff$(8) = STRING$(350,0)      'Command counter.
  GlobalStuff$(11) = Null$              ''Hot List' of allowable users.
  GlobalStuff$(12) = Short$(190)        ''Hot List' reason text.
  GlobalStuff$(13) = Null$              'Time to turn hot list off.
  GlobalStuff$(17) = Null$              'Sysop chat request reason.
  GlobalStuff$(20) = Null$              'Names sending message TO.
  GlobalStuff$(22) = C0$                'LEN > 0 if should load overlays.


  K1 = FileOpenR(FileNames(120))
  CALL FileGetSLoc(K1,0&,GlobalStuff$(25))
  CALL FileCloseR(K1)



  '
  ' The DIM's below set system maximum's.
  '
  REDIM FWork(Settings.MaxFilesInDir) AS FileInfo    'Max files per directory.
  REDIM Work(Settings.MaxFilesInDir * 2)             'Simple integer workspace.
  REDIM o$(150)                                      'Overlay strings.
  REDIM PullDown$(25)
  REDIM GObjects$(255)
  '
  ' Build any need-to-be-built block index files for any language.
  '
  CALL Ansi("[6;1f[0;32mBlocks: ")
  K1$ = FileNames(113)
  K2$ = FileNames(114)
  K9 = LEN(GlobalStuff$(19))
  K1 = 1
  WHILE (K1 + 84) <= K9
    User.Language = MID$(GlobalStuff$(19),K1,3)
    FileNames(113) = NodeFix$(GlobalStuff$(9))
    FileNames(114) = NodeFix$(GlobalStuff$(10))
    CALL BlocksLoad(0,113,114,p)
    K1 = K1 + 85
  WEND
  User.Language = Null$
  FileNames(113) = K1$
  FileNames(114) = K2$
  CALL BlocksLoad(1,111,112,p)   'DB_BLKS
  CALL BlocksLoad(2,115,116,p)   'SYS_BLKS
  CALL BlocksLoad(3,134,135,p)   'PRG_BLKS
  CALL BlocksLoad(0,113,114,p)         'Reload ENGlish.
  CALL Ansi("[6;9f[0K")
  SqString$ = GetBlock$(3,53)
  '
  ' Rebuild the index for the menu cmds on-line help if needed.
  '
  K = FindF(FileNames(132),FFile)
  SELECT CASE K
    CASE 0, IS <> FindF(FileNames(131),FFile)
         CALL KillFile(FileNames(132))
         CALL KillFile(FileNames(133))
         K = FileOpenR(FileNames(131))
         K0 = FileOpenW(FileNames(132))
         K1 = FileOpenW(FileNames(133))
         K& = 0
         DO
           K0& = K&
           K$ = FileGetLine$(K,K&)
           IF LEN(K$) > 0 AND AscNull(K$) <> 32 _
              THEN CALL FilePutSEnd(K0,MKL$(K0&)) : _
                   CALL FilePutSEnd(K1,Form$(7697,K$)) : _
                   K$ = FileGetLine$(K,K&)
         LOOP UNTIL K& = -1
         CALL SameDate(K,K0)
         CALL FileCloseR(K)
         CALL FileCloseW(K0)
         CALL FileCloseW(K1)
  END SELECT
  '
  ' Build initial batch files if needed.
  '
  IF NOT FindF2(FileNames(55),FFile) _
     THEN K = FileOpenW(FileNames(55)) : _
          CALL FilePutSLoc(K,0&,Short$(171) + C1310$ + Short$(172) + _
                                RTRIM$(FileNames(27)) + C1310$ + Short$(922) + _
                                IntToStr$(Settings.Node) + _
                                C1310$ + RTRIM$(FileNames(54)) + C1310$) : _
          CALL FileCloseW(K)
  IF NOT FindF2(FileNames(40),FFile) THEN K = FileOpenW(FileNames(40)) : _
                                          CALL MakeFileFromBlock(K,3,48) : _
                                          CALL FileCloseW(K)
  SumLog.DateOn = DateToInt(DATE$)
  DIM Colors$(13)
  Colors$(1) = RTRIM$(Settings.Colors1)
  Colors$(2) = RTRIM$(Settings.Colors2)
  Colors$(3) = RTRIM$(Settings.Colors3)
  Colors$(4) = RTRIM$(Settings.Colors4)
  Colors$(5) = RTRIM$(Settings.Colors5)
  Colors$(6) = RTRIM$(Settings.Colors6)
  Colors$(7) = RTRIM$(Settings.Colors7)
  Colors$(8) = RTRIM$(Settings.Colors8)
  Colors$(9) = RTRIM$(Settings.Colors9)
  Colors$(10) = RTRIM$(Settings.Colors10)
  Colors$(11) = RTRIM$(Settings.Colors11)
  Colors$(12) = RTRIM$(Settings.Colors12)
  Colors$(13) = RTRIM$(Settings.Colors13)

END SUB
        '
        '* * * *




        '* * * * * *
        ' This routine, internal to initializer, builds the PATHS.DAT
        ' file from the PATHS.INI file.
        '
        ' Date last checked for perfection: Sep 10 1992
        '
SUB BuildPathFile (p0)

  K0$ = Chars$(65 + DrCurrent) + ":\"
  K0 = FileOpenR("PATHS.INI")
  IF FileLof&(K0,1) > 0 _
     THEN CALL Ansi("[1;32mFirst time set up, hang on...") _
     ELSE CALL Ansi("[1;32mYou must have PATHS.INI in this directory to recreate PATHS.DAT.") : _
          SYSTEM
  K1 = FileOpenWDA("PATHS.DAT")
  K& = 0
  DO
    K$ = FileGetLine$(K0,K&)
    CALL ReplaceStrings(K$,"C:\",K0$)
    CALL ReplaceStrings(K$,"c:\",K0$)
    K$ = LEFT$(K$ + SPACE$(40),40)
    CALL FilePutSEnd(K1,K$)
  LOOP UNTIL K& = -1
  CALL FileCloseR(K0)
  CALL FileCloseW(K1)
  '
  ' Replace all occurances of "C:\" with "d:\" in BLOCKS.TXT.
  '
  K0 = FileOpenW("GLOBAL\TEXT\DB_BLKS.TXT")
  K& = 0
  K0& = FileLof&(K0,1)
  DO
    K1& = K&
    K$ = FileGetBlock$(K0,K&,K0&)
    CALL ReplaceStrings(K$,"C:\",K0$)
    CALL ReplaceStrings(K$,"c:\",K0$)
    CALL FilePutSLoc(K0,K1&,K$)
  LOOP UNTIL K& = K0&
  CALL FileCloseW(K0)
  '
  ' Now replace the 'd:\' specification in our large menu files.
  '
  FOR A = 1 TO 3
    SELECT CASE A
      CASE 1 : K0 = FileOpenW("GLOBAL\SYSTEM\CMDS.DAT")
      CASE 2 : K0 = FileOpenW("NODE001\ENG\MENUS.DAT")
      CASE 3 : K0 = FileOpenW("GLOBAL\SYSOP\MENUS.DAT")
    END SELECT
    K& = 0
    K0& = FileLof&(K0,1)
    DO
      K1& = K&
      K$ = FileGetBlock$(K0,K&,K0&)
      CALL ReplaceStrings(K$,"C:\",K0$)
      CALL ReplaceStrings(K$,"c:\",K0$)
      CALL FilePutSLoc(K0,K1&,K$)
    LOOP UNTIL K0& = K&
    CALL FileCloseW(K0)
  NEXT
  '
  ' A little extra help, replace all the 'C:\'s with the proper
  ' drive in all the small .DAT files.
  '
  CALL CursorOn
  CALL Ansi(C1310$ + C1310$ + "[1;32mWhat is the sysop's name?  ")
  z$ = Null$
  DO
    zz = KBIn
    IF zz = 8 AND LEN(z$) > 0 THEN CALL Ansi(C8$ + C32$ + C8$) : _
                                   z$ = LEFT$(z$,LEN(z$) - 1)
    IF zz > 13 THEN z$ = z$ + Chars$(zz) :_
                   CALL Ansi(Chars$(zz))
  LOOP UNTIL zz = 13 OR zz = 27
  IF zz = 27 OR LEN(z$) < 4 THEN z$ = Null$ _
                            ELSE z$ = LEFT$(UCASE$(z$) + SPACE$(30),30)
  CALL Ansi(C1310$)
  CALL CursorOff
  K0 = FindF("GLOBAL\SYSTEM\*.*",FFile)
  WHILE K0 <> 0
    SELECT CASE FFile.FSize
      CASE IS < 8192
           K0 = FileOpenW("GLOBAL\SYSTEM\" + FFile.FName)
           K$ = SPACE$(FileLof&(K0,1))
           CALL FileGetSLoc(K0,0&,K$)
           CALL ReplaceStrings(K$,"C:\",K0$)
           CALL ReplaceStrings(K$,"c:\",K0$)
           IF LEN(z$) > 0 _
              THEN CALL ReplaceStrings(K$,"SYSTEM OPERATOR               ",z$)
           CALL FilePutSLoc(K0,0&,K$)
           CALL FileCloseW(K0)
    END SELECT
    K0 = FindF(Null$,FFile)
  WEND

END SUB
        '
        '* * * *


SUB LoadShort

  '
  ' Load up the Short$() array from SHORT.TXT.
  '
  K = FileOpenR(FileNames(60))
  K& = FileLof&(K,1)
  IF K& < 1 _
     THEN CALL Ansi("[1;32mCould not find: " + RTRIM$(FileNames(60)) + C1310$) : _
          CALL Ansi("Please be sure the d:\BBS directory tree structure is correct." + C1310$ + C1310$) : _
          SYSTEM
'  K1& = K&
'  DO : K0 = Val2&(LEFT$(FileGetLineR$(K,K1&),3))
'  LOOP UNTIL K0 > 0
k0 = 999
  REDIM Short$(K0)
  K$ = SPACE$(K&)
  CALL FileGetSLoc(K,0&,K$)
  CALL FileCloseR(K)
  K1 = 1
  K4 = 0
  K2 = StrSrch1(K$,13) - 1
  WHILE K2 > 0
    K0$ = MID$(K$,K1,K2)
    IF AscNull(K0$) <> 39 _
       THEN K3 = Val2&(LEFT$(K0$,3)) : _
            IF K3 <= K0 AND K3 > K4 _
               THEN Short$(K3) = MID$(K0$,4) : _
                    K4 = K3 _
               ELSE CALL ScreamError("SHORT.TXT bad line number: " + IntToStr$(K3))
    K1 = K1 + K2 + 2
    K2 = StrSrch2(K1 - 1,K$,13) - K1
  WEND

END SUB
