
 Rem * Filename: dnddoor.inc  Version: v4.0 r1.0
 Rem * Variables here are included common to all subprograms. If any of this
 Rem * include file is modified then all subprograms must be recompiled.

 DefInt A-Z   ' define all default variables as integers
 Rem $Dynamic ' allocate common variables and arrays at runtime

 '  define register type for interrupt function
 Type RegType
  AX As Integer ' A register
  BX As Integer ' B register
  CX As Integer ' C register
  DX As Integer ' D register
  BP As Integer ' base pointer (not used by dnddoor)
  SI As Integer ' source index (not used by dnddoor)
  DI As Integer ' destination index (not used by dnddoor)
  Flags As Integer ' cpu flags (not used by dnddoor)
 End Type

 '  define structure for containers
Type ContainerType
 Closed As Integer ' closed flag 1=closed, 0=n/a, -1=open
 ContainerName As String*30 ' container name from treasure.dat file
 Locked As Integer ' locked flag 1=locked, 0=n/a, -1=unlocked
 Keyed As Integer ' container key number 1-32767
 ShortName As String*30 ' mnemonic of container name from treasure.dat file
 Charges(1 To 5) As Integer ' treasure charges of container contents
 Inventory(1 To 5) As Integer ' index to treasure.dat of container contents
 Invisible(1 To 5) As Integer ' invisible flag -1/0 of container contents
 TreasureName(1 To 5) As String*30 ' treasure name of container contents
End Type

 '  action structure
Type ActionType
 Attribute1 As Integer ' room attribute one, 0=lit/2=dark
 Attribute2 As Integer  ' room attribute two, 0=land/1=air/2=underwater
 Level As Integer ' negative/positive value=lower/highest user level to enter
 Restrictions As Integer ' level direction is restricted to, 12 bit flags
 SpellTrigger As Integer ' number of room spell trigger
 MonsterTrigger As Integer ' number of room monster trigger
 HealthRate As Integer ' rate of action prompts to increase user health
 EncounterRate As Integer ' rate of action prompts to encounter monster
 HitPoints As Integer ' negative/positive hits for vit/fat result
 Inventory As Integer  ' weapons=1/shields=2/armor=3/magic items=4 breakage
 MonsterTalk As Integer ' talk to monster number trigger
 Fumble As Integer ' fumble weapons/shield result
 Teleport As Integer ' teleport trap room number result
 RustRate As Integer ' rate of action prompts weapons/shields rust
 StealRate As Integer ' rate of action prompts monsters steal
End Type

 '  define room structure. this main data file contains room descriptions,
 '  directions, one container, action number, object and treasure indexes.
Type RoomType
 LongDesc(1 To 4) As String*78 ' four line long description of room
 ShortDesc As String*78 ' one line short description of room for brief mode
 Direct(1 To 11) As Integer  ' direction link values to next room number
 Object(1 To 10) As Integer ' number of object from objects.dat file
 Treasure(1 To 10) As Integer ' number of treasure from treasure.dat file
 ObjCharges(1 To 10) As Integer ' object charges
 TreCharges(1 To 10) As Integer ' treasure charges
 Flags(1 To 10) As Integer ' hidden=1/trap=2/magically hidden=3
 Action As Integer ' index to action file
 MonsterClass As Integer ' number of room monster class in monclass.dat file
 Container As ContainerType ' single container per room
End Type

 '  define user structure. this main data file contains user statistics,
 '  values, flags, object and treasure indexes.
Type UserType
 CodeName As String*30 ' encrypted user codename
 PassWord As String*20 ' encrypted user password
 ClassName As String*20 ' encrypted user classname
 ClassType As Integer ' classname number 1-10
 Container(1 To 3) As ContainerType ' user's maximum of 3 containers
 Inv(1 To 15) As Integer ' user's inventory index to treasure.dat file
 Charges(1 To 15) As Integer ' treasure's charges/plus
 Object(1 To 5) As Integer ' user's object index to objects.dat file
 ObjCharges(1 To 5) As Integer ' object's charges/plus
 Stats(1 To 7) As Integer ' player statistics str/int/wis/dex/con/pie/cha
 Weapons(1 To 4) As Integer ' weapons proficiency percent blu/pol/sha/thr
 Room As Integer ' room number
 Level As Integer ' player's level
 Experience As Double ' player's experience
 Gold As Double ' collected gold
 NumCalls As Integer ' number of calls during one day
 Fatigue As Integer ' fatigue points during fighting
 FatigueMax As Integer ' maximum possible fatigue points
 Vitality As Integer ' vitality points during fighting
 VitalityMax As Integer ' maximum possible vitality points
 Magic As Integer ' magic points during fighting/using spells
 MagicMax As Integer ' maximum possible magic points
 Poison As Integer ' user is poisoned true/false, vitality decreasing
 Borrow As Double ' gold borrowed from bank
 Invisible As Integer ' user is invisible true/false
 Race As Integer ' player's race 1-8, hum/elf/gno/dwa/hal/hal-elf/hal-orc/ogr
 Proficiency As Integer ' weapon user is proficient in 1-4
 Bank As Double ' amount gold stored in bank
 Sort As Integer ' sort inventory true/false
 MonstersKilled As Single ' total of all monsters killed during play
 Brief As Integer ' brief mode true/false
 DateOn As String*10 ' last date user logged on, form: MM-DD-YYYY
 Beauty As Integer ' lady class beauty points
 Glamour As Integer ' lady class glamour points
 Psionic As Integer ' psionic points during fighting/casting psi spells
 PsionicMax As Integer ' maximum possible psionic points
 Align1 As Integer ' alignment type 1, good/neutral/evil
 Align2 As Integer ' alignment type 2, lawful/neutral/chaotic
 Flags As Integer ' 1=rerolled/2-128=stat wish/256=wish/512=realigned/chars
 MaxCalls As Integer ' maximum calls user is allowed per day
 FromHour As Integer ' time restriction logon from hour,
 FromMin As Integer ' time restriction logon from minute,
 ToHour As Integer ' time restriction logon to hour,
 ToMin As Integer ' time restriction logon to minute.
 Echo As Integer ' echo mode 0=on,-1=off
 LastMessage As Integer ' last message read
 Linefeeds As Integer ' linefeed mode 0=on,-1=off
 Linelength As Integer ' linelength for display
 Pagelength As Integer ' pagelength for display
 Wordwrap As Integer ' word wrap 0=on,-1=off
End Type

 '  define spell structure. this data file contains spell statistics,
 '  values, and flags. this struture is used by treasure and spells.
Type SpellType
 SpellName As String*30 ' full name of spell
 Chant As String*80 ' chant to be used for spell
 Level As Integer ' level of spell/level user must be at least to cast spell
 SpellType As Integer ' spell type 1-28
 Teleport As Integer ' spell teleports when cast
 Psionic As Integer ' spell is psionic, true/false
 PsionicMode As Integer ' spell is psionic, 1=attack/2=defense
 ClassType As Integer ' user class allowed to cast spell, flags 1-8
 Desc As String*80 ' description displayed when spell is cast
 Ingred(1 To 5) As Integer ' index to treasure.dat of required ingtedients
 SpellFlag As Integer ' ingredients type required flag, 1=use/2=read/4=cast
End Type

 '  define monster class structure. this data file contains lists of monsters.
Type MonclassType
 Monsters(1 To 10) As Integer ' indexed list of ten monsters from monster.dat
End Type

 '  define object structure. this data file contains object statistics,
 '  values, and flags. this struture is used by users and rooms.
Type ObjectType
 ObjectName As String*30 ' full name of object
 ShortName As String*30 ' mnemonic of object name
 RoomLink As Integer ' link to room number for entering object
 Invisible As Integer  ' is invisible
 JailTrap As Integer ' jails user if attacked
 DoorLock As Integer ' locked (0=n/a,1=unlocked/2=locked)
 Destination As Integer ' n/a (used to be room object was created)
 Permanent As Integer ' cannot be picked up. default.
 Hidden As Integer ' hidden (cannot not be seen or searched for)
 Closed As Integer  ' closed (-1=closed/0=open)
 Keyed As Integer ' key number 1-32767
 Relocks As Integer ' relocks after entering
 LongDesc As String*80 ' description displayed when object looked at
 FromHour As Integer ' lights room from hour,
 FromMin As Integer ' lights room from minute,
 ToHour As Integer ' lights room to hour,
 ToMin As Integer ' lights room to minute.
 LightRoom As Integer ' lights room (-1=true/0=false)
 LightTime As Integer ' light time (-1=from-to/0=anytime)
 ShortDesc As String*40 ' description displayed when object entered
 Trap As Integer ' trapped portal (1=poison/2=teleport/3=hits for fat/vit)
 Teleport As Integer ' (room number, trap=2), (hits -fat/hits +vit, trap=3)
End Type

 '  define monster structure. this data file contains monster statistics,
 '  values, and flags.
Type MonsterType
 Treasure(1 To 5) As Integer ' five indexes to treasure.dat
 Talk(1 To 5) As Integer ' five indexes to montalk.dat
 MonsterName As String*30 ' full name of monster
 PluralName As String*30 ' mnemonic plural of monster name
 NumberAppearing As Integer ' maximum monsters encontered at one time
 Level As Integer ' monster level/level of user required to kill monster
 Experience As Double ' experience gained by killing monster
 Gold As Double ' money gained by killing monster
 Hits As Double ' hit points monster has for user to kill
 Poison As Integer ' monster can poison=-1/monster is poisoned>0
 LevelDrain As Integer ' can drain user levels (-1/0)
 Spell As Integer ' can cast spells (equal to spell record number)
 Block As Integer ' can block user from exiting room
 Prevent As Integer ' can prevent user from taking treasure
 Follow As Integer ' can follow user
 Magic As Integer ' casts magic spell (equals index to spell record number)
 Jail As Integer ' can jail attacker (-1/0)
 Teleport As Integer ' can teleport (equals room number)
 FollowPercent As Integer ' percentage to follow
 BlockPercent As Integer ' percentage to block
 PreventPercent As Integer ' percentage to prevent
 SpellPercent As Integer ' percentage to cast spell
 PoisonPercent As Integer ' percentage to poison
 DrainPercent As Integer ' percentage to drain levels
 Rate As Integer ' encounter rate (action prompts)
 RatePercent As Integer ' percentage encountered at rate
 Permanent As Integer ' monster is permanent to room
 Psionic As Integer ' monster casts psionic spells
 PsionicSpell As Integer ' psionic spell casted
End Type

 '  define treasure structure. this data file contains treasure statistics,
 '  values, and flags. this struture is used by users and rooms.
Type TreasureType
 TreasureName As String*30 ' full treasure name
 ShortName As String*28 ' mnemonic treasure name
 Permanent As Integer ' treasure is permanent (not default)
 Weight As Integer ' weight in gold of treasure
 Gold As Double ' value in gold of treasure
 Spell As Integer ' treasure is magical (index of spell record)
 Plus As Integer ' treasure plus (0=normal treasure/greater>0=weapon plus)
 Coin As Integer ' coins (-1/0)
 Keyed As Integer ' key number (1-32767)
 Scroll As Integer ' scroll (-1/0)
 Charges As Integer ' charges for weapon/armor/shield/spell
 Container As Integer ' container (-1/0)
 Trap As Integer ' treasure has trap
 TrapType As Integer ' trap type
 TrapHits As Integer ' trap hit points
 TrapTeleport As Integer ' trap teleport room number
 Flags As Integer ' flag of bitfields
 Type As Integer ' treasure type (-1=shield/0=normal/1=armor/0,<plus>=weapon)
 Potion As Integer ' potion (-1/0)
 Locked As Integer ' container (1=locked,0=n/a,-1=unlocked)
 Closed As Integer ' container (1=closed,0=n/a,-1=open)
 Loadable As Integer ' can be loaded with ammunition (-1/0)
 Ammunition As Integer ' is ammunition (-1/0)
 AmmoLoads As Integer ' if ammunition, then index to treasure.dat it loads
 Invisible As Integer ' invisible (-1/0)
 Proficiency As Integer ' weapon proficiency related (1-4)
 RingType As Integer ' is a ring (1=antipoison/2=antileveldrain/3=antispell)
 RingSpell As Integer ' ring antispell (-1=generic/greater>0=spell number)
 Edible As Integer ' edible (-1/0)
 Rustable As Integer ' rusts (-1/0)
 RustPercent As Integer ' percentage rusts during room rust rate
 Stealable As Integer ' stealable (-1/0)
 StealPercent As Integer ' percentage monster steals during room steal rate
 Launchable As Integer ' can be launched with launch ammunition (-1/0)
 LaunchLoads As Integer ' is launch ammunition (-1/0)
 LaunchAmmo As Integer ' if launch ammo, then index to treasure.dat it loads
 Movable As Integer ' launchable device can be moved (-1/0)
 Vehicle As Integer ' vehicle (-1/0)
 VehicleHits As Integer ' vehicle hit points for combat
 VehicleType As Integer ' vehicle type (0=land,1=air,2=underwater,3=any)
 LightType As Integer ' is a light (-1/0)
 LightCharges As Integer ' light charges
 FuelType As Integer ' is light fuel (-1/0)
 FuelCharges As Integer ' fuel charges
End Type

 '  define monster talk structure. this data file contains lists of strings
 '  monsters can respond with when talked to.
Type MonsterTalkType
 TalkMessage As String*80 ' an 80 character string response
End Type

 '  help file record structure. used for help command during play,
 '  uses files help.dat, edithelp.dat, dmhelp.dat, and logon.dat.
Type HelpType
 Text As String*70 ' text to display
 CName As String*15 ' command name of command to display
End Type

 '  structure for messages text file. indexed by the table record structure.
Type MessageType
 Message As String*80 ' length of a message line
End Type

 '  table for messages. stores subject, from/to, date entered, private message
 '  and if the message is deleted. fields for start and length define the
 '  position of the message in the messages text file.
Type TableType
 ClassType As Integer ' class type of the player who entered the message
 Clock As String*21 ' stores the time the message was entered from FNclock$
 Date As String*10 ' system date message was stored
 Flags As Integer ' user record flags for special characters entered message
 From As String*30 ' field storing user who entered the message
 Killed As Integer ' true if the message is deleted
 Length As Integer ' length of lines in messages text file
 Private As Integer ' true if the message is private
 Received As Integer ' flag indicating message was read
 Reply As Integer ' flag for message reply
 Start As Single ' beginning of the line of the message in the text file
 Subject As String*20 ' stores the subject of the message
 Thread As Integer ' number of message replied to
 Time As String*10 ' stores system time message was entered
 Timer As Single ' stores system time in seconds message was entered
 TimesRead As Integer ' stores number of times message was read
 To As String*30 ' stores name of the user the message is to, or empty for all
End Type

 '  define variables, fixed length/variable strings, and
 '  dynamic arrays common to all subprograms.
Common Shared_
 ActionRecord As ActionType,_ ' action structure
 Action.Prompt As String,_ ' stores action prompt Next: or Command>
 Alignment.Name1() As String*7,_ ' stores three type 1 alignment names
 Alignment.Name2() As String*7,_ ' stores three type 2 alignment names
 Allow.Break As Integer,_ ' allows control-k checking during file output
 Array() As String,_ ' string array for mail
 Array.Number As Integer,_ ' contains number of array element searched for
 BBS.Name As String,_ ' name of calling bbs name from rbbs .def file
 Break As Integer,_ ' returns -1 is control-k pressed
 Buffer As String,_ ' stores modem i/o
 Carriage.Return As Integer,_ ' supresses linefeed during output
 Charges.Number As Integer,_ ' contains charges of item searched for
 Chat As Integer,_ ' chat mode flag
 Choice As Integer,_ ' monster number selected
 Class.Name() As String*15,_ ' stores ten class names
 Color.Code As Integer,_ ' current ansi color
 Color.Graphics As Integer,_ ' ansi color activated remote
 Command.Name As String,_ ' storage of user command
 Continue As Integer,_ ' flag for continuous output
 ContainerRec As ContainerType,_ ' container structure
 Direction As Integer,_ ' direction 1-10
 Direction() As String*9,_ ' stores ten direction names
 Door.Name As String,_ ' name of calling bbs user from rbbs .def file
 Door.Time As Single,_ ' time left from rbbs .def file
 Dungeon.Master As Integer,_ ' user is dungeon master (-1/0)
 Dungeon.Master.Assistant As Integer,_ ' user is asst. DM (-1/0)
 Entry.Command As Integer,_ ' last command number used for room entry
 FileName As String,_ ' file name storage
 Func.Buffer As String,_ ' buffer of interactive pressed function key
 Governor As Integer,_ ' user is governor (-1/0)
 Graphics.Off As Integer,_ ' set ansi graphics off (to white) (-1/0)
 Guild.Master As Integer,_ ' user is guild master (-1/0)
 HelpRecord As HelpType,_ ' help record structure
 Hidden.Player As Integer,_ ' player is hidden (-1/0)
 Hide As Integer,_ ' mask input for security i/o with Mask$
 High.Class.Name() As String*15,_ ' ten high class names
 Inpt As String,_ ' user i/o input
 Index.Number As Integer,_ ' contains index number of an item searched for
 Intoxicated As Integer,_ ' user is intoxicated (equal to action prompts)
 Invisible As Integer,_ ' user is invisible (-1/0)
 Last.Command As String,_ ' last command entered
 Last.Command.Number As Integer,_ ' number of last command entered
 Last.Monster As String,_ ' name of last monster attacked
 Learned.Spells As String,_ ' string of 1's and 0's of spells learned
 Line.Length As Integer,_ ' maximum length of input allowed
 Line.Limit As Integer,_ ' used with word wrap
 Local.Mode As Integer,_ ' user is logged in at console
 Locks.Smashed As Integer,_ ' used in launch routine
 Logged.In As Integer,_ ' flag indicating user is logged in
 Magic.Spell As Integer,_ ' magic spell number of spells.dat being cast
 Max.Row As Integer,_ ' maximum rows used for screen scrolling/output
 Message1 As String,_ ' stores message when user killed for death routine
 Message.Length As Integer,_ ' stores length of message in mail
 Message.Reply As Integer,_ ' flag for message reply
 Message.Thread As Integer,_ ' message number replied to
 Message.To As String,_ ' stores message to in mail
 MessageRecord As MessageType,_ ' message record structure for mail
 Monclass As Integer,_ ' current room monster class
 Monclass.Max As Integer,_ ' maximum monster classes in monclass array
 MonclassRecord As MonclassType,_ ' monster class record structure
 Monster.Class() As Integer,_ ' array of monster classes
 Monster.Cycle As Integer,_ ' incrementing counter for monster attacks
 Monster.Number As Integer,_ ' stores currently accessed monster number
 Monster.Percent() As Integer,_ ' array of monster percents
 Monster.Rate() As Integer,_ ' array of monster encounter rates
 Monster.Rate1 As Integer,_ ' counts file monster rates
 Monster.Rate2 As Integer,_ ' counts room monster rates
 MonsterArray() As MonsterType,_ ' array of 20 monster record structures
 MonsterIndex() As Integer,_ ' array of 20 indexes to monster.dat file
 MonsterRecord As MonsterType,_ ' defines monster structure
 Monsters.Killed As Integer,_ ' total monsters killed in session
 MonsterTalkRecord As MonsterTalkType,_ ' monster class structure
 Multiplier As Integer,_ ' multiplier used in combat
 New.Room As Integer,_ ' added new room flag
 Next.Room As Integer,_ ' next room storage
 No As Integer,_ ' entered Y during input (-1/0)
 No.Echo As Integer,_ ' do not echo user input
 No.Input As Integer,_ ' null was entered (-1/0)
 No.Input.Out As String,_ ' string to return if null entered during input
 Node As String,_ ' node in string form
 Node1 As Integer,_ ' node number (0-9,A-Z)
 Node2 As Integer,_ ' node number (0-99)
 Normal.User As Integer,_ ' user has special attributes (-1/0)
 Number.Appearing As Integer,_ ' maximum monsters of one type encountered
 Number.Monsters As Integer,_ ' current number of active monsters in room
 ObjectRecord As ObjectType,_ ' object structure
 Outpt As String,_ ' user i/o output
 Outpts As String,_ ' temporary user i/o output variable
 Parse.Count As Integer,_ ' parsed count to decrement
 Parse.Number As Integer,_ ' stores command numbers (pound sign) quantity
 Parsed.Command1 As String,_ ' first or second command parsed from input
 Parsed.Command2 As String,_ ' first or second command parsed from input
 Parser As Integer,_ ' position of command second word parsed 
 Pass.Door As Integer,_ ' passdoor spell cast
 Player.CodeName As String,_ ' storage for user codename
 Player.PassWord As String,_ ' storage for user password
 Port As Integer,_ ' modem port being used (0-7)
 Prefix1 As String,_ ' the/or/an
 Previous.Command As Integer,_ ' -1=use,0=n/a,equals last command number
 Previous.Command1 As String,_ ' storage of previous command 
 Previous.Command2 As String,_ ' storage of previous parsed command
 Previous.Command3 As String,_ ' storage of previous second parsed command
 Private.Message As Integer,_ ' flag for mail
 Psi.Attack.Mode As Integer,_ ' last offense psi spell cast
 Psi.Defense.Mode As Integer,_ ' last defense psi spell cast
 Quit As Integer,_ ' true if Q entered
 Race() As String*8,_ ' stores eight race names
 Room As Integer,_ ' current room number
 Room.Health.Rate As Integer,_ ' number of action prompts for health update
 Room.Monster.Rate As Integer,_ ' number of action promptsfor monster update
 Room.Rate As Integer,_ ' counter of action prompts for room rate
 Room.Rust.Rate As Integer,_ ' counter of room rust rate
 Room.Steal.Rate As Integer,_ ' counter of room steal rate
 RoomRecord As RoomType,_ ' room structure
 Rooms.Chained As Integer,_ ' used in launch routine
 Rust.Rate As Integer,_ ' rust rate in action prompts
 Sorting As Integer,_ ' inventory sorting (-1/0)
 SpellRecord As SpellType,_ ' spell structure
 Spell.Number As Integer,_ ' spell number being used
 Spell.Cast.Type As Integer,_ ' type of spell being cast
 Stat() As String*12,_ ' storage of eight statistics names
 Steal.Rate As Integer,_ ' steal rate in action prompts
 Stored.Parsed.Command1 As String,_ ' first parsed command from user input
 Stored.Parsed.Command2 As String,_ ' second parsed command from user input
 Subject As String,_ ' store mail subject
 Sysop As Integer,_ ' contains -1 if player is sysop
 TableRecord As TableType,_ ' message table for mail
 Teleported As Integer,_ ' user entered room by teleporting (-1/0)
 Time.Calc As Single,_ ' time storage variable
 Time.Left As Single,_ ' amount of time user is allowed on in seconds
 Time.On As String,_ ' time user logged on in Date$ format
 Timeon As Single,_ ' time user logged on in Timer format
 Town.Mayor As Integer,_ ' user is town mayor (-1/0)
 Training.Room() As Integer,_ ' storage for training room numbers
 TreasureRecord As TreasureType,_ ' treasure structure
 Two.Minutes.Left As Integer,_ ' flag indicating two minutes warning shown
 Type.Number As Integer,_ ' flag for type of object in room or inventory
 User.Command As String,_ ' stores original user input
 User.Index As Integer,_ ' index of user number to users.dat file
 User.Number As Integer,_ ' alternate user index variable
 UserRecord As UserType,_ ' user structure
 Vehicle1 As Integer,_ ' index to room treasure array (1-10)
 Vehicle2 As Integer,_ ' charges in vehicle
 Vehicle3 As Integer,_ ' index to treasure.dat file
 Vehicle4 As Integer,_ ' vehicle type (0-3)
 Weapon.Type.Name() As String*9,_ ' storage of four weapon names
 Weapon1 As Integer,_ ' plus of armor worn
 Weapon2 As Integer,_ ' plus of weapon held
 Weapon3 As Integer,_ ' plus in shield held
 Weapon4 As Integer,_ ' index to user inventory array of armor worn
 Weapon5 As Integer,_ ' index to user inventory array of shield held
 Weapon6 As Integer,_ ' index to user inventory array of weapon held
 Weapon7 As Integer,_ ' index to user inventory array of ring worn
 Weapon8 As Integer,_ ' ring type (1=antipoison/2=antileveldrain/3=antispell)
 Weapon9 As Integer,_ ' ring antispell (-1=generic/greater>0=spell number)
 Weapon10 As Integer,_ ' proficiency number of weapon held
 Weight As Integer,_ ' total amount in gold of user's inventory
 Word.Wrap As Integer,_ ' used for word wrap during input
 Yes As Integer ' user entered Y during input (-1/0)

 Common Shared Inregs As RegType, Outregs As RegType ' register structures

 '  constants used in place of variables inline programs
 Const Dead$="-dead-" ' used internal to user file
 Const Deleted$="<deleted>" ' used internal to data files
 Const Enter$="<enter>" ' generic response substring
 Const False=0 ' false
 Const More$="-more(y/n/c)-" ' generic response substring
 Const MaxInt=32767 ' maximum integer
 Const MaxStat=250 ' maximum player statistic
 Const MinInt=-32768 ' minimum integer
 Const None$="<null>" ' used internally
 Const Nul="" ' empty string
 Const Range$="Out of range." ' generic response substring
 Const Release$="1.0" ' program minor version
 Const True=Not False ' true
 Const UnTrue=False+1 ' untrue
 Const Version$="4.0" ' program major version

 '  constant variables corresponding to last command entered
 Const Picklock.Command=26 ' compare to picklock
 Const Hide.Command=49 ' compare to hide
 Const Identify.Command=52 ' compare to identify

 '  constant variables for driving vehicles
 Const RideVehicle=48 ' ride vehicle command number
 Const DriveVehicle=73 ' drive vehicle command number

 '  constant variables of weapon proficiency types
 Const Blunt=1 ' blunt weapon number
 Const Pole=2 ' pole weapon number
 Const Sharp=3 ' sharp weapon number
 Const Thrusting=4 ' thrusting weapon number

 '  bit constants of room record flags array attributes of room inventory
 Const Hidden.Object=1 ' object was hidden with hide command
 Const Magic.Trap=2 ' object was made into a trap with spell
 Const Magically.Hidden=4 ' object was magically hidden with spell

 '  constant variable used to indicate spell method being used
 Const Use.Spell.Type=1 ' spell cast is by the use command
 Const Scroll.Spell.Type=2 ' spell cast by using a scroll
 Const Cast.Spell.Type=4 ' spell cast with the cast command

 '  bit constants of player class, character, and command flags,
 '  bits 2 through 128 correspond to the seven statistics players may wish for.
 Const Rerolled=1 ' bit flag of user record flags field for rerolled player
 Const Wished=256 ' bit flag of user record flags field of player wished
 Const Alignmented=512 ' bit flag of user record flags field of player align
 Const Locked.User=1024 ' bit for locked mailbox
 Const Special.Char1=2048 ' bit flag of user record flags field town mayor
 Const Special.Char2=4096 ' bit flag of user record flags field governor
 Const Special.Char3=8192 ' bit flag of user record flags field guild master
 Const Special.Char4=16384 ' bit flag of user record flags field sysop

 ' constants of class type numbers
 Const Fighter=1 ' fighter class
 Const MagicUser=2 ' MU class
 Const Thief=3 ' thief class
 Const Cleric=4 ' cleric class
 Const Paladin=5 ' paladin class
 Const Ranger=6 ' ranger class
 Const Druid=7 ' druid class
 Const Lady=8 ' lady class
 Const AsstDM=9 ' asst. DM class
 Const DM=10 ' DM class

 ' constants of attack command numbers
 Const Charm=31 ' attack command number constant
 Const Beguile=32 ' attack command number constant
 Const Shield=34 ' attack command number constant
 Const Guard=35 ' attack command number constant
 Const Lunge=39 ' attack command number constant
 Const Dodge=40 ' attack command number constant
 Const Killed=55 ' attack command number constant
 Const Backstab=59 ' attack command number constant
 Const Circled=60 ' attack command number constant
 Const Feint=61 ' attack command number constant
 Const Parry=62 ' attack command number constant
 Const Thrust=63 ' attack command number constant
 Const Charge=64 ' attack command number constant
 Const Turn=65 ' attack command number constant
 Const Counter=66 ' attack command number constant
 Const Bemuse=67 ' attack command number constant
 Const Befuddle=68 ' attack command number constant
 Const Pummel=69 ' attack command number constant
 Const Resist=70 ' attack command number constant
 Const PsiMode=71 ' attack command number constant
 Const Beat=82 ' attack command number constant
 Const Punch=83 ' attack command number constant
 Const Bewitch=84 ' attack command number constant
 Const Bewilder=85 ' attack command number constant

 ' constants of spell type numbers
 Const Enchant=1 ' spell number constant
 Const Offense=2 ' spell number constant
 Const Bless=3 ' spell number constant
 Const Wish=4 ' spell number constant
 Const Poison=5 ' spell number constant
 Const Vigor=6 ' spell number constant
 Const Heal=7 ' spell number constant
 Const CurePoison=8 ' spell number constant
 Const LevelDrain=9 ' spell number constant
 Const Teleport=10 ' spell number constant
 Const Befuddled=11 ' spell number constant
 Const TurnUndead=12 ' spell number constant
 Const PassDoor=13 ' spell number constant
 Const Conjure=14 ' spell number constant
 Const Psionic=15 ' spell number constant
 Const DetectLock=16 ' spell number constant
 Const DetectEvil=17 ' spell number constant
 Const DetectTrap=18 ' spell number constant
 Const Intoxicate=19 ' spell number constant
 Const SetTrap=20 ' spell number constant
 Const Hiding=21 ' spell number constant
 Const Search=22 ' spell number constant
 Const Invisibility=23 ' spell number constant
 Const Identify=24 ' spell number constant
 Const Enlighten=25 ' spell number constant
 Const Illuminate=26 ' spell number constant
 Const Psyche=27 ' spell number constant
 Const Telepathy=28 ' spell number constant (not used)

 ' constants for psionic spells
 Const PsiAttack=1 ' psionic attack mode
 Const PsiDefense=2 ' psionic attack mode

 ' constants for room attribute 1
 Const LitRoom=2 ' bit flag constant for dark/lit room

 ' constants for room attribute 2
 Const Air=1 ' flag value for above ground room
 Const Underwater=2 ' flag value constant for underwater room

 ' constants of room entry command
 Const Fly=74 ' entry command number
 Const Swim=79 ' entry command number

 '  declaration of date/time routines,
 '  external to program, linked in from DTFMTER.LIB.
 Declare Function DateSerial#(Y%,M%,D%) ' converts date values to double
 Declare Function DateValue#(D$) ' converts date string to double
 Declare Function Hour&(S#) ' converts double to long hour
 Declare Function Minute&(S#) ' converts double to long minute
 Declare Function Now#() ' returns current date/time to double
 Declare Function Second&(S#) ' converts double to long second
 Declare Function TimeSerial#(H%,M%,S%) ' converts time values to double
 Declare Function TimeValue#(T$) ' converts time string to double
 Declare Function FormatD$(byval A#,B$) ' formats a string

 ' function creates a formatted strig containing the date and time.
 Def FNclock$=FormatD$(Now#,"ddd dd mmm yy\, hh:mma/p")
