
 Rem * Filename: dnds2.bas Version: v4.0 r1.0
 Rem * This subprogram contains most login routines, and display routines.

 Rem $Include: 'dnddoor.inc'

 Rem * routine to login user.
 Rem * output variables:
 Rem *   Time.On - contains time logged in.
 Rem *   Timeon - contains time logged in past midnight.
 Rem *   Time.Left - stores time limit in seconds past midnight.
 Rem *   User.Index - number of record in user file codename will use.
 Rem * processing variables:
 Rem *   Time.Left - during logging in.
 Rem *   Two.Minutes.Left - time remaining flag.
 Rem *   Login.Try - total login attempts.
 Rem *   New.User - flag indicates new user login.
 Rem *   Logged.User - flag indicates user exists in files.

Sub Login
 On Local Error Resume Next ' local error resume
 Time.On=Time$ ' store system time logged in (string form hh:mm:ss)
 Timeon=Timer ' store system time logged in (seconds past midnight)
 Time.Left=600! ' set time limit during logging in
 Two.Minutes.Left=False ' flag for two minute left display message
 Logged.In=False ' set user logged in flag
 ' format initial login display line
 Outpt="The Adventure Door v"+Version$+_
 ", Node: "+Node+", Online at "+FNclock$+"."
 Call IO.O ' display initial message
 ' format prompt for login welcome
 Outpt="Press <enter> to display the welcome, or <space> to skip:"
 No.Echo=True ' supress prompt input echo
 Line.Length=1 ' get only one keypress
 Call IO.I ' input routine
 No.Echo=False ' reset echo
 If Inpt=Nul Then ' check empty return
    Call Out.File("welcome.dat") ' display welcome file
 Endif ' end display welcome
 Do ' main login processing loop
    Login.Try=False ' reset login attempts
    Do ' get codename processing loop
       New.User=False ' reset new user flag
       Call Get.Codename ' prompt user for codename
       Call Get.PassWord ' prompt user for password
       Call Find.PassWord(Logged.User) ' find codename in user file
       If Logged.User Then ' compare user has entered an existing codename
          Call Verify.PassWord(Logged.Pass) ' compare entered password
          If Logged.Pass Then ' check if password matches
             Exit Do ' exit codename processing/entry loop
          Endif ' end check password match
          If Login.Try>=3 Then ' compare login attempts
             Call Hang.Up(7) ' routine to terminate program w/ message
             Exit Sub ' exit login routine/return to main
          Endif ' end compare login attempts
          Login.Try=Login.Try+1 ' increment login attempt
          Outpt="Illegal password attempt!" ' display error message
          Call IO.O ' send output/continue codename entry loop
       Else ' user has not entered an existing codename
          Call Get.Newuser.Record ' find an empty user file record
          Call Verify.Newuser(New.User) ' verify password entered
          If New.User>False Then ' user selected disconnect
             Call Hang.Up(8) ' routine to terminate program w/ message
             Exit Sub ' exit routine
          Endif ' end compare disconect
          If New.User<False Then ' user password verified
             Call Init.Newuser ' initialize some new user variables
             Call Verify.Newlogin(New.User,True) ' verify user is new
             If New.User Then ' user selects to continue as a new user
                Exit Do ' exit codename/password entry loop
             Endif ' end new user continue
          Endif ' end password verify
       Endif ' end compare existing codename
    Loop ' codename/password entry loop
    Call Update.Login ' intialize some login variables
    If New.User=False Then ' compare user is new user
       Exit Do ' exit main login processing loop
    Endif ' end compare new user
    If New.User Then ' compare new user login is verified
       Call Roll.Character ' get user selected character statistics
       Call Verify.Newlogin(New.User,False) ' verify new user to continue
       If New.User Then ' new user is logged in
          Exit Do ' exit main login processing loop
       Endif ' end compare new user login
    Endif ' end compare new user login
 Loop ' end main login processing loop
 Call Login.User ' routine to initialize some login variables
 Outpt=Nul ' send empty output
 Call IO.O ' send output
 Outpt="Press <enter> to begin the adventure:" ' format message
 No.Echo=True ' set flag to supress echo input
 Line.Length=1 ' get one keypress
 Call IO.I ' get input
 No.Echo=False ' reset echo flag
 Next.Room=Room ' store room number
 Call Enter.Room ' display room description
 Logged.In=True ' set user logged in flag
 Func.Buffer=Nul ' reset function key flag
End Sub ' end routine to login user

 Rem * routine to find codename entered in user file.
 Rem * output variables:
 Rem *   PassWord.Found - flag if codename is in user file.

Sub Find.PassWord(PassWord.Found)
 On Local Error Resume Next ' local error resume
 PassWord.Found=False ' set flag to false
 Inpt=Rtrim$(Player.CodeName) ' store codename
 For User.Index=1 To Lof(1)/Len(UserRecord) ' loop through entire user file
    Get 1,User.Index,UserRecord ' get next user file record
    Outpt=UserRecord.CodeName ' store user file codename
    Call Decrypt(Outpt) ' decrypt user file codename
    Outpt=Rtrim$(Outpt) ' trim user file codename
    If Outpt=Inpt Then ' compare user file codename to codename entered
       PassWord.Found=True ' set return variable flag
       Exit For ' exit user file loop
    Endif ' end check codenames
 Next ' loop through user file
End Sub ' end routine to find user file codename

 Rem * routine to verify valid password of codename entered.
 Rem * output variables:
 Rem *   PassWord.Found - flag indicates password exists.

Sub Verify.PassWord(PassWord.Found)
 On Local Error Resume Next ' local error resume
 PassWord.Found=False ' set flag to false
 Outpt=UserRecord.PassWord ' store user file password
 Call Decrypt(Outpt) ' decrypt password
 If Len(Outpt)=False Then ' verify decrypt result
    Outpt="Password has a checksum error!" ' format message
    Call IO.O ' send message
    PassWord.Found=False ' set flag to verify password
    Exit Sub ' exit check password routine
 Endif ' end check password
 Outpt=Rtrim$(Outpt) ' store trimmed user file password
 Inpt=Rtrim$(Player.PassWord) ' store password entered
 If Outpt=Inpt Then ' compare user file password to entered password
    PassWord.Found=True ' set flag to verify password
 Endif ' end compare passwords
End Sub ' end routine to check valid password

 Rem * routine to verify new user is continuing.
 Rem * input variables:
 Rem *   Message.Type - message to select.
 Rem * output variables:
 Rem *   Response.Type - returns true to continue, false if not.

Sub Verify.Newlogin(Response.Type,Message.Type)
 On Local Error Resume Next ' local error resume
 Do ' process input loop
    Graphics.Off=False ' reset color
    If Message.Type Then ' compare prompt
       Outpt="Press <enter> to roll character, or <space> to reenter:"
    Else ' select prompt
       Outpt="Press <enter> to use character, or <space> to reroll:"
    Endif ' end compare prompt
    No.Echo=True ' supress input echo
    Line.Length=1 ' input one keypress
    Call IO.I ' get user input
    No.Echo=False ' reset input echo
    If Inpt=" " Then ' selected space
       Response.Type=False ' set return flag
       Exit Do ' exit routine
    Endif ' end compare select
    If No.Input Then ' compare empty input
       Response.Type=True ' set return flag
       Exit Do ' exit routine
    Endif ' end compare select
 Loop ' process input loop
End Sub ' end routine to prompt to continue

 Rem * routine to get codename, check illegal character in codename, verify
 Rem * user has entered correct codename.
 Rem * output variables:
 Rem *   Player.CodeName - contains lowercased, trimmed codename entered.

Sub Get.Codename
 On Local Error Resume Next ' local error resume
 Do ' main codename entry processing loop
    Do ' loop until valid codename entered
       Outpt=Nul ' empty output
       Call IO.O ' send output
       Outpt="Codename? " ' codename prompt
       Line.Length=30 ' set line length of codename
       Call IO.I ' get codename input
       Inpt=Ltrim$(Inpt) ' trim blanks
       Inpt=Rtrim$(Inpt) ' trim blanks
       Inpt=Ucase$(Inpt) ' set input to uppercase
       Player.CodeName=Inpt ' store codename
       If Len(Player.CodeName)>False Then ' check length of codename
          Call Valid(Player.CodeName,30) ' verify valid characters
          If Len(Player.CodeName)>False Then ' check valid codename
             Exit Do ' exit codename entry loop
          Endif ' end check valid characters
          Outpt="Illegal characters in codename!" ' format message
          Call IO.O ' send output
       Endif ' end check codename length
    Loop ' continue entry loop
    Outpt=Rtrim$(Player.CodeName) ' store codename
    Outpt=Lcase$(Outpt) ' set to lowercase
    Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' make first character uppercase
    Outpt="You are "+Chr$(34)+Outpt+Chr$(34)+"(y/n)? " ' format prompt
    No.Input.Out="Y" ' set default input to yes
    Call IO.I ' prompt for correct codename entered
    If Yes Then ' verify user has verified correct codename
       Exit Do ' exit main codename entery loop
    Endif ' end verify user input
 Loop ' end codename entry loop
End Sub ' end routine to get and verify codename entry

 Rem * routine to prompt user for password, check valid characters in password.
 Rem * output variables:
 Rem *   Player.PassWord - contains lowercased, trimmed password entered.

Sub Get.PassWord
 On Local Error Resume Next ' local error resume
 Do ' password entry loop
    Outpt=Nul ' empty output
    Call IO.O ' send output
    Outpt="Password? " ' password prompt
    Line.Length=20 ' set line length of password
    Hide=True ' set flag to echo mask characters
    Call IO.I ' get input
    Hide=False ' reset mask flag
    Inpt=Ltrim$(Inpt) ' trim blanks
    Inpt=Rtrim$(Inpt) ' trim blanks
    Inpt=Ucase$(Inpt) ' set input to uppercase
    Player.PassWord=Inpt ' store password
    If Len(Player.PassWord)>False Then ' check length of password
       Call Valid(Player.PassWord,20) ' verify valid characters
       If Len(Player.PassWord)>False Then ' check valid password
          Exit Do ' exit password entry loop
       Endif ' end check valid characters
       Outpt="Illegal characters in password!" ' format message
       Call IO.O ' send output
    Endif ' end check password length
 Loop ' end password entry loop
End Sub ' end routine to enter password

 Rem * routine to find empty user file record.
 Rem * output variables:
 Rem *    User.Index - unused number of record in user file.

Sub Get.Newuser.Record
 On Local Error Resume Next ' local error resume
 For User.Index=1 To Lof(1)/Len(UserRecord) ' loop through entire user file
    Get 1,User.Index,UserRecord ' load the user record
    Outpt=UserRecord.CodeName ' store user file codename
    Call Decrypt(Outpt) ' routine to decrypt codename
    If Left$(Outpt,9)=Deleted$ Then ' compare to deleted record
       Exit For ' end loop through user file
    Endif ' end compare deleted record
 Next ' end loop through user file
 ' exit of loop w/o finding a deleted record will set User.Index to one
 ' record past the last in the user file, appending the next record.
 Get 1,User.Index,UserRecord ' get empty user file record
 Outpt="Codename not found in files!" ' make message
 Call IO.O ' send message
End Sub ' end routine to find empty user file record

 Rem * routine to verify new user login.
 Rem * output variables:
 Rem *   Response.Type - flag set to 1 to disconnect,
 Rem *   0 if password not verified, -1 if password is verified.

Sub Verify.Newuser(Response.Type)
 On Local Error Resume Next ' local error resume
 Do ' password verify loop
    Outpt="Press <C>ontinue, <H>angup, or <R>estart:" ' make message
    No.Input.Out="C" ' default empty input to continue
    Call IO.I ' get input
    Response.Type=False ' set return flag to unverified
    Select Case Ucase$(Inpt) ' compare input selection
    Case "C" ' continue selected
       Outpt=Nul ' set empty output
       Call IO.O ' send output
       Outpt="Verify password: " ' prompt for password
       Hide=True ' set echo characters masked
       Line.Length=20 ' line length of password
       Call IO.I ' get user input
       Hide=False ' reset echo mask flag
       Inpt=Ltrim$(Inpt) ' trim input
       Inpt=Rtrim$(Inpt) ' trim input
       Inpt=Ucase$(Inpt) ' set input uppercase
       Outpt=Rtrim$(Player.PassWord) ' store password entered
       If Outpt<>Inpt Then ' compare password entered to verify entry
          Outpt="Passwords don't match!" ' make error message
          Call IO.O ' send output
          Response.Type=False ' set flag to unverified
          Exit Do ' exit routine
       Endif ' end compare password
       Outpt="Memorize your password!" ' make message
       Call IO.O ' send output
       Call IO.O ' send empty line
       Response.Type=True ' set flag to verified
       Exit Do ' exit routine
    Case "H" ' hangup selected
       Response.Type=1 ' set flag to hangup user
       Exit Do ' exit routine
    Case "R" ' restart selected
       Response.Type=False ' set flag to restart/unverified
       Exit Do ' exit routine
    End Select ' end compare input selection
 Loop ' end password verify loop
End Sub ' end routine to verify new password

 Rem * routine to allow user to select new character statistics.
 Rem * processing variables:
 Rem *   Display.Help - flag to display login help messages.

Sub Roll.Character
 On Local Error Resume Next ' local error resume
 Display.Help=False ' set flag to display help text
 Outpt="List help text during character logon(y/n)? " ' prompt for help
 No.Input.Out="N" ' default prompt
 Call IO.I ' get user input
 If Yes Then ' check input
    Display.Help=True ' set help text flag
 Endif ' end check input
 If Display.Help Then ' check help flag
    Call Logon.Help(1) ' display class help text
 Endif ' end check help flag
 Call Modify.Class ' routine to select class type
 If Display.Help Then ' check help flag
    Call Logon.Help(2) ' display statistics entry help text
 Endif ' end check help flag
 Call Modify.Stats ' routine to select character statistics
 If Display.Help Then ' check help flag
    Call Logon.Help(3) ' display race entry help text
 Endif ' end check help flag
 Call Modify.Race ' routine to select character race
 Call Init.Race.Stats ' routine to initialize some race statistics
 If Display.Help Then ' check help flag
    Call Logon.Help(4) ' display weapon proficiency entry help text
 Endif ' end check help flag
 Call Modify.Proficiency ' routine to select weapon proficiency
 Call Init.Proficiency.Stats ' routine to intialize proficiency statistics
 Call Init.Stats ' routine to intialize some character statistics
 If Display.Help Then ' check help flag
    Call Logon.Help(5) ' display alignment entry help text
 Endif ' end check help flag
 Call Modify.Alignment ' routine to select character alignment
 Call Display.Init.Stats ' routine to display character statistics
End Sub ' end routine to get new character statistics

 Rem * routine to display help text.
 Rem * input variables:
 Rem *   Help.Number - range of help text file records to display.
 Rem * work variables:
 Rem *   Start.Help, End.Help, Help.Count.

Sub Logon.Help(Help.Number)
 On Local Error Resume Next ' local error resume
 Close #13 ' close work file number
 FileName="logon.dat" ' store logon helptext filename
 Open FileName For Random Shared As #13 Len=Len(HelpRecord) ' open file
 Graphics.Off=True ' set color flag
 Outpt=Nul ' send empty line
 Call IO.O ' send output
 Select Case Help.Number ' selection for logon help record ranges
 Case 1 ' help records
    Start.Help=2
    End.Help=6
 Case 2 ' help records
    Start.Help=7
    End.Help=15
 Case 3 ' help records
    Start.Help=16
    End.Help=25
 Case 4 ' help records
    Start.Help=26
    End.Help=32
 Case 5 ' help records
    Start.Help=33
    End.Help=36
 End Select ' end select record ranges
 For Help.Count=Start.Help To End.Help ' loop through help text file range
    Get 13,Help.Count,HelpRecord ' read help record
    Outpt=Rtrim$(HelpRecord.Text) ' format help text
    Call IO.O ' send help output
 Next  'end loop through help file
 Call IO.O ' send ampty output
 Call More.Prompt ' get keypress
 Graphics.Off=False ' reset color flag
End Sub ' end routine to display help text

 Rem * routine to allow user to modify character alignment.

Sub Modify.Alignment
 On Local Error Resume Next ' local error resume
 Do ' process modify alignment one loop
    Graphics.Off=False ' reset color
    Outpt="Player Alignment:" ' make message
    Call IO.O ' display message
    Outpt="Press "+Enter$+" for default." ' make message
    Call IO.O ' display message
    Graphics.Off=True ' reset color
    For Align.Count=1 To 3 ' display alignment choices
       Outpt=Mid$(Str$(Align.Count),2)+"> "+_
       Rtrim$(Alignment.Name1(Align.Count))
       Call IO.O ' send output
    Next ' loop through alignment choices
    Outpt="?" ' prompt for alignment number
    No.Input.Out="2" ' default to neutral
    Call IO.I ' get input
    Player.Alignment=Int(Val(Inpt)) ' convert to number
    If Player.Alignment>=1 And Player.Alignment<=3 Then ' compare valid choice
       Exit Do ' exit first loop
    Endif ' end compare choice
 Loop ' continue alignment loop
 UserRecord.Align1=Player.Alignment-2 ' store alignment as -1/0/1
 Do ' process modify alignment two loop
    Graphics.Off=False ' reset color
    Outpt="Player Alignment:" ' make message
    Call IO.O ' display message
    Outpt="Press "+Enter$+" for default." ' make message
    Call IO.O ' display message
    Graphics.Off=True ' reset color
    For Align.Count=1 To 3 ' display alignment choices
       Outpt=Mid$(Str$(Align.Count),2)+"> "+_
       Rtrim$(Alignment.Name2(Align.Count))
       Call IO.O ' send output
    Next ' loop through alignment chocies
    Outpt="?" ' prompt for alignment number
    No.Input.Out="2" ' default to neutral
    Call IO.I ' get input
    Player.Alignment=Int(Val(Inpt)) ' convert to number
    If Player.Alignment>=1 And Player.Alignment<=3 Then ' compare valid choice
       Exit Do ' exit second loop
    Endif ' end compare choice
 Loop ' continue alignment loop
 UserRecord.Align2=Player.Alignment-2 ' store alignment as -1/0/1
End Sub ' end routine to modify character alignment

 Rem * routine to allow user to modify character class type.

Sub Modify.Class
 On Local Error Resume Next ' local error resume
 Outpt=Nul ' make empty line
 Call IO.O ' send output
 Do ' class entry process loop
    Graphics.Off=False ' reset color
    Call IO.O ' send blank line
    Outpt="Select your character class:" ' make message
    Call IO.O ' send output
    Outpt="Press "+Enter$+" for default." ' make message
    Call IO.O ' send output
    If Local.Mode=False Then ' console mode allows DM/Asst. DM entries
       Max.Class=8 ' set number of class choices
    Else ' compare console mode
       Max.Class=10 ' set number of class choices
    Endif ' end compare console mode
    Graphics.Off=True ' reset color
    For List.Counter=1 To Max.Class ' loop through class chocies
       Outpt=Mid$(Str$(List.Counter),2) ' store class number
       If List.Counter=10 Then ' store DM class number
          Outpt="#" ' choice ten is pound sign
       Endif ' end compare DM class number
       Outpt=Outpt+"> "+Rtrim$(Class.Name(List.Counter)) ' append class name
       Call IO.O ' send output
    Next ' loop through class choices
    Outpt="?" ' set input prompt
    No.Input.Out="1" ' set default choice
    Call IO.I ' get user input
    Player.Class=Int(Val(Inpt)) ' convert to number
    If Inpt="#" Then ' compare DM selection
       Player.Class=10 ' set to ten
    Endif ' end compare DM selection
    If Player.Class>=1 And Player.Class<=Max.Class Then ' check class range
       Exit Do ' exit class type entry loop
    Endif ' end check class range
 Loop ' end class type entry loop
 UserRecord.ClassType=Player.Class ' store class number in user record
 Outpt=Class.Name(UserRecord.ClassType) ' get class name
 Call Valid(Outpt,20) ' validate class name
 If Outpt=Nul Then ' verify class name validity
    Outpt="<checksum>" ' set error message
    Call Valid(Outpt,20) ' validate error
 Endif ' end verify class name
 Call Encrypt(Outpt,True) ' encrypt class name
 UserRecord.ClassName=Outpt ' store class name in user record
End Sub ' end routine to modify character class type

 Rem * routine to allow user to modify character statistics.

Sub Modify.Stats
 On Local Error Resume Next ' local error resume
 Do ' loop until statistics selected are accepted
    Do ' loop until statistics are valid
       Graphics.Off=False ' reset color
       Outpt="Enter character statistics, range from 8 to 18." ' message
       Call IO.O ' send message
       Outpt="Average less than or equal to 12." ' message
       Call IO.O ' send message
       Outpt="Press "+Enter$+" for default." ' message
       Call IO.O ' send message
       Stat.Total!=False ' reset total of selected statistics
       For Class.Number=1 To 7 ' loop through entry of all statistics
          Do ' loop until a valid statistic entered
             Graphics.Off=True ' reset color
             Outpt=Rtrim$(Stat(Class.Number))+">" ' make message w/ stat name
             No.Input.Out="12" ' set default
             Call IO.I ' get input
             Stat=Int(Val(Inpt)) ' convert to number
             If Stat<8 Or Stat>18 Then ' check range
                Graphics.Off=False ' reset color
                Outpt="The average statistic must range from 8 to 18."
                Call IO.O ' send output message
             Else ' check range
                Stat.Total!=Stat.Total!+Stat ' increment stat total
                UserRecord.Stats(Class.Number)=Stat ' store stat in user record
                Exit Do ' exit validity loop
             Endif ' end check range
          Loop ' continue valid statistic loop
       Next ' loop through all statistics
       Stat.Total!=Stat.Total!/7! ' calculate average of total statistics
       Stats$=Str$(Stat.Total!) ' convert to string
       Stat.Delimit=Instr(Stats$,".") ' search string for decimal
       If Stat.Delimit=False Then ' compare decimal
          Inpt=Stats$ ' set output string to converted string
       Else ' check decimal, truncate to one place
          ' set string
          Inpt=Left$(Stats$,Stat.Delimit-1)+"."+Mid$(Stats$,Stat.Delimit+1,1)
       Endif ' end compare decimal
       Graphics.Off=False ' reset color
       If Stat.Total!<=12 Then ' verify average
          Exit Do ' exit validity loop
       Endif ' end verify average
       Outpt="Average"+Inpt+" to high! Try again.." ' set message
       Call IO.O ' send message
    Loop ' end statistic validity loop
    Outpt="Your average is"+Inpt+". Change anything(y/n)? " ' make message
    No.Input.Out="N" ' set default input
    Call IO.I ' get user input
    If No Then ' check no entered
       Exit Sub ' exit routine
    Endif ' end check entry
 Loop ' end loop to verify statistics accepted
End Sub ' end routine to modify character statistics

 Rem * routine to allow user to modify character race.

Sub Modify.Race
 On Local Error Resume Next ' local error resume
 Do ' loop until race entry is accepted
    Graphics.Off=False ' reset color
    Outpt="Select your character race:" ' make message
    Call IO.O ' send message
    Outpt="Press "+Enter$+" for default." ' make message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    For Race.Count=1 To 8 ' loop through all race choices
       ' choice display
       Outpt=Mid$(Str$(Race.Count),2)+">"+Rtrim$(Race(Race.Count))
       Call IO.O ' send choice
    Next ' end race display loop
    Outpt="?" ' set input prompt
    No.Input.Out="1" ' set default
    Call IO.I ' get user input
    Player.Race=Int(Val(Inpt)) ' convert to number
    If Player.Race>=1 And Player.Race<=8 Then ' check race range
       UserRecord.Race=Player.Race ' store race in user record
       Exit Sub ' exit routine
    Endif ' end compare race range
 Loop ' end loop to accept race entry
End Sub ' end routine to modify race

 Rem * routine to allow user to modify character weapon proficiency.

Sub Modify.Proficiency
 On Local Error Resume Next ' local error resume
 Do ' loop until proficiency entry accepted
    Graphics.Off=False ' reset color
    Outpt="Weapon Proficiency:" ' set message
    Call IO.O ' send output
    Outpt="Clerics may only use blunt or pole type weapons." ' message
    Call IO.O ' send output
    Outpt="Press "+Enter$+" for default." ' message
    Call IO.O ' send output
    Graphics.Off=True ' reset color
    For Prof.Count=1 To 4 ' loop through all weapon proficiencies
       Outpt=Mid$(Str$(Prof.Count),2)+"> "+_
       Rtrim$(Weapon.Type.Name(Prof.Count))
       Call IO.O ' send choice output
    Next ' end weapon choices
    Outpt="?" ' set user prompt
    If UserRecord.ClassType=Cleric Then ' compare class to cleric
       No.Input.Out="1" ' set default
    Else ' compare class
       No.Input.Out="3" ' set default
    Endif ' end compare class
    Call IO.I ' get user input
    Player.Prof=Int(Val(Inpt)) ' convert to number
    If UserRecord.ClassType=Cleric Then ' compare class to cleric
       ' compare valid choices for cleric
       If Player.Prof=1 Or Player.Prof=2 Then
          Exit Do ' exit weapon input loop
       Endif ' end compare valid chocies
    Else ' compare to non cleric
       If Player.Prof>=1 And Player.Prof<=4 Then ' compare valid choices
          Exit Do ' exit weapon input loop
       Endif ' end compare valid choices
    Endif ' end compare class type
 Loop ' end loop to accept weapon proficiency
 UserRecord.Proficiency=Player.Prof ' store character weapon selection
 For Weapon.Number=1 To 4 ' loop through user record weapon proficiencies
    UserRecord.Weapons(Weapon.Number)=False ' reset to zero
 Next ' end loop through weapon proficiencies
 ' set user record selected weapon profciency
 UserRecord.Weapons(Player.Prof)=10
End Sub ' end routine to modify character weapon proficinecy

 Rem * routine to initialize character proficiency statistics.

Sub Init.Proficiency.Stats
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Select Case UserRecord.Race ' compare player character race
 Case 3 ' gnome race
    UserRecord.Weapons(UserRecord.Proficiency)=15 ' increment proficiency
    Outpt="Gnomes weapon proficiency is raised to 15%" ' make message
    Call IO.O ' send message
 Case 6 ' half-elf race
    UserRecord.Weapons(4)=UserRecord.Weapons(4)+5 ' increment proficiency
    Outpt="Half-elves thrusting weapon proficiency is raised by 5%" ' message
    Call IO.O ' send message
 Case 7 ' half-orc race
    UserRecord.Weapons(3)=UserRecord.Weapons(3)+5 ' increment proficiency
    Outpt="Half-orcs sharp weapon proficiency is raised by 5%" ' message
    Call IO.O ' send message
 End Select ' end compare race
End Sub ' end routine to initialize proficiency statistics

 Rem * routine to initialize character race statistics.

Sub Init.Race.Stats
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Select Case UserRecord.Race ' compare player character race
 Case 1 ' human race
    UserRecord.Stats(1)=UserRecord.Stats(1)+1 ' increment statistics
    Outpt="Humans strength is raised one point!" ' make message
    Call IO.O ' send message
 Case 2 ' elf race
    UserRecord.Stats(4)=UserRecord.Stats(4)+1 ' increment statistics
    Outpt="Elves dexterity is raised by one point!" ' make message
    Call IO.O ' send message
 Case 4 ' dwarf race
    UserRecord.Stats(2)=UserRecord.Stats(2)+1 ' increment statistics
    Outpt="Dwarves intelligence is raised by one point!" ' make message
    Call IO.O ' send message
 Case 5 ' halfling race
    UserRecord.Stats(3)=UserRecord.Stats(3)+1 ' increment statistics
    Outpt="Halflings wisdom is raised by one point!" ' make message
    Call IO.O ' send message
 Case 8 ' ogre race
    UserRecord.Stats(1)=UserRecord.Stats(1)+1 ' increment statistics
    UserRecord.Stats(4)=UserRecord.Stats(4)+1 ' increment statistics
    Outpt="Ogres strength and dexterity are raised by one point!" ' message
    Call IO.O ' send output
 End Select ' end compare race
 UserRecord.Beauty=Int(Rnd*15+5) ' reset ladies beauty
 UserRecord.Glamour=Int(Rnd*15+5) ' reset ladies glamour
End Sub ' end routine to initialize character race statistics

 Rem * routine to initialize some character statistics.

Sub Init.Stats
 On Local Error Resume Next ' local error resume
 UserRecord.Room=51 ' reset user record room number
 UserRecord.Level=1 ' reset user record character level
 UserRecord.Experience=64 ' reset experience
 UserRecord.Gold=2048 ' reset user record gold
 UserRecord.Bank=False ' reset user record amount of gold in bank
 UserRecord.Borrow=False ' reset user record amount of gold borrowed from bank
 UserRecord.Brief=False ' reset user record brief mode
 UserRecord.Echo=False ' reset user echo mode
 UserRecord.Linefeeds=False ' reset user linefeed mode
 UserRecord.Linelength=80 ' reset user linelength
 UserRecord.Pagelength=24 ' reset pagelength
 UserRecord.Wordwrap=False ' reset user word wrap
 UserRecord.FatigueMax=Training.Room(UserRecord.ClassType,1) ' reset user
 UserRecord.VitalityMax=Training.Room(UserRecord.ClassType,2) ' record maximum
 UserRecord.MagicMax=Training.Room(UserRecord.ClassType,3) ' statistic
 UserRecord.PsionicMax=Training.Room(UserRecord.ClassType,4) ' points
 UserRecord.Fatigue=UserRecord.FatigueMax ' reset user
 UserRecord.Vitality=UserRecord.VitalityMax ' record working
 UserRecord.Magic=UserRecord.MagicMax ' statistic
 UserRecord.Psionic=UserRecord.PsionicMax ' points
 UserRecord.MaxCalls=False ' reset user record maximum calls
 UserRecord.FromHour=False ' reset user record time restrictions
 UserRecord.FromMin=False ' reset user record time restrictions
 UserRecord.ToHour=False ' reset user record time restrictions
 UserRecord.ToMin=False ' reset user record time restrictions
 UserRecord.Flags=False ' reset user record flags variable
 Call Clear.Container(0,True) ' routine to clear the container structure
 For Container.Item=1 To 3 ' loop through user record containers
    UserRecord.Container(Container.Item)=ContainerRec ' reset container record
 Next ' end loop through user record
End Sub ' end routine to initialize character statistics

 Rem * routine to display login character statistics.

Sub Display.Init.Stats
 On Local Error Resume Next ' local error resume
 Graphics.Off=False ' reset color
 Outpt="Your character statistics are:" ' message
 Call IO.O ' send output
 Graphics.Off=True ' reset color
 Outpt="Level:"+Str$(UserRecord.Level) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Alignment.Type$=Alignment.Name1(UserRecord.Align1+2) ' message
 Alignment.Type$=Rtrim$(Alignment.Type$) ' trim blanks
 ' first character uppercase
 Mid$(Alignment.Type$,1,1)=Ucase$(Mid$(Alignment.Type$,1,1))
 Outpt=Outpt+"Align1: "+Alignment.Type$ ' combine message
 Call IO.O ' send output
 Outpt="Gold: "+Str$(UserRecord.Gold) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Alignment.Type$=Alignment.Name2(UserRecord.Align2+2) ' message
 Alignment.Type$=Rtrim$(Alignment.Type$) ' trim blanks
 ' first character uppercase
 Mid$(Alignment.Type$,1,1)=Ucase$(Mid$(Alignment.Type$,1,1))
 Outpt=Outpt+"Align2: "+Alignment.Type$ ' combine message
 Call IO.O ' send output
 Outpt="Room: "+Str$(UserRecord.Room) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Player.Prof=UserRecord.Proficiency ' get statistic
 Weapon.Type$=Weapon.Type.Name(Player.Prof) ' message
 Weapon.Type$=Rtrim$(Weapon.Type$) ' trim blanks
 ' first character uppercase
 Mid$(Weapon.Type$,1,1)=Ucase$(Mid$(Weapon.Type$,1,1))
 Outpt=Outpt+"Prof:   "+Weapon.Type$ ' combine message
 Weapon.Proficiency$=Str$(UserRecord.Weapons(Player.Prof)) ' message
 Outpt=Outpt+">"+Weapon.Proficiency$+"%" ' combine message
 Call IO.O ' send output
 Outpt="Exp:  "+Str$(UserRecord.Experience) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(1),3)+":   "+Str$(UserRecord.Stats(1)) ' combine
 Call IO.O ' send output
 Outpt="Fat:  "+Str$(UserRecord.Fatigue) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(2),3)+":   "+Str$(UserRecord.Stats(2)) ' combine
 Call IO.O ' send output
 Outpt="Vit:  "+Str$(UserRecord.Vitality) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(3),3)+":   "+Str$(UserRecord.Stats(3)) ' combine
 Call IO.O ' send output
 Outpt="Mag:  "+Str$(UserRecord.Magic) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(4),3)+":   "+Str$(UserRecord.Stats(4)) ' combine
 Call IO.O ' send output
 Outpt="Psi:  "+Str$(UserRecord.Psionic) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(5),3)+":   "+Str$(UserRecord.Stats(5)) ' combine
 Call IO.O ' send output
 Outpt="Race:  "+Race(UserRecord.Race) ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(6),3)+":   "+Str$(UserRecord.Stats(6)) ' combine
 Call IO.O ' send output
 Class.Type$=UserRecord.ClassName ' message
 Call Decrypt(Class.Type$) ' decrypt string
 ' first character uppercase
 Mid$(Class.Type$,1,1)=Ucase$(Mid$(Class.Type$,1,1))
 Class.Type$=Left$(Class.Type$,15) ' truncate to right
 Outpt="Class: "+Class.Type$ ' message
 Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
 Outpt=Outpt+Left$(Stat(7),3)+":   "+Str$(UserRecord.Stats(7)) ' combine
 Call IO.O ' send output
 If UserRecord.ClassType=Lady Then ' compare class to lady
    Outpt="Lady stats:" ' message
    Call IO.O ' send output
    Outpt="Beauty:"+Str$(UserRecord.Beauty) ' message
    Outpt=Outpt+Space$(25-Len(Outpt)) ' append blanks
    Outpt=Outpt+"Glamour:"+Str$(UserRecord.Glamour) ' combine
    Call IO.O ' send output
 Endif ' end compare class type
 Call More.Prompt ' pause to continue
End Sub ' end routine to display character login statistics

 Rem * routine to initialize some variables after login.
 Rem * output variables:
 Rem *   Time.Left - player time left in seconds from login time.

Sub Update.Login        
 On Local Error Resume Next ' local error resume
 Outpt=UserRecord.DateOn ' get user's last login date
 Call Decrypt(Outpt) ' decrypt date
 If Outpt<>Date$ Then ' compare last login date to today
    UserRecord.NumCalls=False ' reset user's number of calls logged in per day
 Endif ' end compare last login date
 If UserRecord.ClassType<=Lady Then ' compare user to non DM status
    Calls.Exceeded=False ' set flag to maximum calls exceeded
    UserRecord.NumCalls=UserRecord.NumCalls+1 ' increment user's max calls
    If UserRecord.MaxCalls>False Then ' compare maximum calls
       If UserRecord.NumCalls>UserRecord.MaxCalls Then ' compare calls
          Calls.Exceeded=True ' set maximum call flag
       Endif ' end compare calls to maximum calls
    Else ' end compare maximum calls
       If UserRecord.NumCalls>5 Then ' compare maximum calls to default
          Calls.Exceeded=True ' set maximum call flag
       Endif ' end compare maximum default calls
    Endif ' end compare maximum calls
    If Calls.Exceeded Then ' check user has exceeded maximum calls
       Call Share.Record(1,User.Index) ' put user record
       Call Hang.Up(5) ' routine to terminate program w/ message
       Exit Sub ' exit routine
    Endif ' end check maximum calls
 Endif ' end non DM status
 Call Restricted.Login ' check user is restricted to a time to login
 If UserRecord.ClassType<AsstDM Then ' compare user is non DM status
    UserRecord.Invisible=False ' reset user invisibility
 Endif ' end compare non DM status
 Select Case UserRecord.ClassType ' compare the user class type
 Case Is>=AsstDM ' user is DM/Asst. DM
    Time.Left=3600! ' user gets 60 minutes
 Case Else ' user is non DM
    Select Case UserRecord.Level ' select by user level
    Case Is<2 ' user level is less than two
       Time.Left=900! ' user gets 15 mminutes
    Case Else ' user level is two or more
       Time.Left=1800! ' user gets 30 minutes
    End Select ' end user level
 End Select ' end user DM status
 If Time.Left>Door.Time Then ' compare user's time left to door file time left
    If Door.Time>False Then ' compare door file time
       Time.Left=Door.Time ' reset time left to door time left
    Endif ' end compare door file time
 Endif ' end compare user time left
 Two.Minutes.Left=False ' reset two minutes left message flag
End Sub ' end routine to initialize some login variables

 Rem * routine to check user is restricted to specific login times.
 Rem * work variables:
 Rem *   Restrict.Start! - time in seconds to restrict logon.
 Rem *   Restrict.End! - time in seconds to restrict logon.

Sub Restricted.Login
 On Local Error Resume Next ' local error resume
 ' calculate time restrictions
 Restrict.Start!=Csng(UserRecord.FromHour*3600!+UserRecord.FromMin*60!)
 Restrict.End!=Csng(UserRecord.ToHour*3600!+UserRecord.ToMin*60!)
 ' compare any time restriction
 If Restrict.Start!>False Or Restrict.End!>False Then
    If Timer<Restrict.Start! Or Timer>Restrict.End! Then ' compare time to now
       Call Hang.Up(6) ' routine to terminate program w/ message
    Endif ' end compare time
 Endif ' end compare time restriction
End Sub ' end routine to check restricted time login

 Rem * routine to intialize some new user variables in user file record.

Sub Init.Newuser
 On Local Error Resume Next ' local error resume
 UserRecord.NumCalls=False ' reset maximum calls made today
 UserRecord.ClassType=False ' reset class type
 Outpt=Player.CodeName ' store codename
 Call Valid(Outpt,30) ' validate codename
 Call Encrypt(Outpt,True) ' encrypt codename
 UserRecord.CodeName=Outpt ' restore codename
 Outpt=Player.PassWord ' store password
 Call Valid(Outpt,20) ' validate password
 Call Encrypt(Outpt,False) ' encrypt password
 UserRecord.PassWord=Outpt ' restore password
 Outpt=Deleted$ ' set deleted
 Call Valid(Outpt,20) ' validate deleted
 Call Encrypt(Outpt,True) ' encrypt deleted
 UserRecord.ClassName=Outpt ' reset classname
 Outpt=Date$ ' store current date
 Call Valid(Outpt,10) ' validate date
 Call Encrypt(Outpt,True) ' encrypt date
 UserRecord.DateOn=Outpt ' reset date
 UserRecord.MaxCalls=False ' reset maximum calls made
 UserRecord.FromHour=False ' reset time restrictions
 UserRecord.FromMin=False
 UserRecord.ToHour=False
 UserRecord.ToMin=False
End Sub ' end routine to intialize new user variables

 Rem * routine to initialize some user variables.

Sub Login.User
 On Local Error Resume Next ' local error resume
 Number.Monsters=False ' counter of monsters currently in the room
 Monsters.Killed=False ' counter of monster killed by player during session
 ' allocate room monster arrays
 Redim MonsterArray(1 To 20) As MonsterType,_
 MonsterIndex(1 To 20) As Integer
 Max.Spells=Lof(9)/Len(SpellRecord) ' compute number of spells in data file
 If Max.Spells=False Then ' compare empty file
    Max.Spells=1 ' set number to at least one
    Call Share.Record(9,1) ' put default spell record
 Endif ' end compare file
 ' make string of zeros length of spell file
 Learned.Spells=String$(Max.Spells,"0")
 If UserRecord.Race<=False Then ' check user race
    UserRecord.Race=1 ' reset to one
 Endif ' end check race
 Call Share.Record(1,User.Index) ' put the user record
 Room=UserRecord.Room ' store the room number
 If UserRecord.Level=False Then ' check user level
    Outpt="You are level zero. You can use the train command once free."
    Call IO.O ' send output message
 Endif ' end compare level
 Call Bank.Interest ' calculate bank interest for balance and loan
 Call Check.Mail ' routine to display number of new messages to player
 Weapon1=False ' reset working game weapon, shield, armor, and ring variables
 Weapon2=False ' reset variable
 Weapon3=False ' reset variable
 Weapon4=False ' reset variable
 Weapon5=False ' reset variable
 Weapon6=False ' reset variable
 Weapon7=False ' reset variable
 Weapon8=False ' reset variable
 Weapon9=False ' reset variable
 Weapon10=False ' reset variable
 Call Get.User.Record ' read the user record
 Call Status.Line(1) ' initialize the console status lines
 Func.Buffer=Nul ' reset function key buffer
End Sub ' end routine to initialize some user variables

 Rem * routine to display verbose text on an item entered on the game prompt,
 Rem * including a room number, an object, an item of treasure, monster, and
 Rem * contents of a container.

Sub Display.Information
 On Local Error Resume Next ' local error resume
 If Not Normal.User Then ' check non DM
    ' convert parameter to number (i.e. Look 12)
    Room.Number=Val(Parsed.Command1)
    ' check room bounds
    If Room.Number>False And Room.Number<=Lof(3)/Len(RoomRecord) Then
       Swap Room.Number, Room ' store current room number
       Get 3,Room,RoomRecord ' get room to display
       Call Show.Room ' routine to display room
       Swap Room.Number, Room ' restore current room number
       Get 3,Room,RoomRecord ' get current room
       Exit Sub ' exit routine
    Endif ' end check room number
 Endif ' end check normal user
 Outpt=UserRecord.CodeName ' get user codename
 Call Decrypt(Outpt) ' decrypt codename
 Outpt=Left$(Outpt,Len(Parsed.Command1)) ' store parameter
 If Outpt=Parsed.Command1 Then ' compare look command to user codename
    Call Display.Stats ' display player statistics
    Exit Sub ' exit routine
 Endif ' end check command parameter
 Call Examine.Treasure ' routine to compare parameter to treasure name
 If Index.Number Then ' compare returned index to treasure file
    Call Show.Treasure ' routine to display information on an item of treasure
    Exit Sub ' exit routine
 Endif ' end compare display treasure item
 Call Num ' reduce number of item
 Call Examine.Container ' compare parameter to container name
 If Index.Number Then ' check container to display
    Call Show.Container ' routine to display information on a container
    Exit Sub ' exit routine
 Endif ' end display container
 Call Num ' reduce number of item
 Call Examine.Objects ' compare parameter to object
 If Index.Number Then ' check index to object record
    Call Show.Object ' routine to display information on an object
    Exit Sub ' exit routine
 Endif ' end check object
 Call Num ' reduce number of item
 Call Check.Monster ' compare parameter to monster name in room
 If Monster.Number Then ' check index of monster array in room
    Call Show.Monster ' routine to display information on a monster
    Exit Sub ' exit routine
 Endif ' end check monster name
 Outpt="You can't examine that!" ' make error message
 Call IO.O ' send error message
End Sub ' end routine to display item

 Rem * routine to display treasure item.
 Rem * input variables:
 Rem *   Index.Number - treasure record number.
 Rem *   Type.Number - room/inventory flag.

Sub Show.Treasure
 On Local Error Resume Next ' local error resume
 If Type.Number Then ' compare treasure in room
    Prefix1="It's " ' format prefix
 Else ' compare treasure in player inventory
    Prefix1="You are carrying " ' format prefix
 Endif ' end compare treasure
 Graphics.Off=True ' reset color
 If TreasureRecord.Scroll Then ' compare treasure to scroll
    If TreasureRecord.Spell Then ' check scroll spell number
       Get 9,TreasureRecord.Spell,SpellRecord ' get spell record of treasure
       Inpt=SpellRecord.Chant ' store spell chant
       Inpt=Rtrim$(Inpt) ' trim chant
       Inpt=Lcase$(Inpt) ' trim chant
       Outpt="It reads: '"+Inpt+"'." ' display scroll chant
       Call IO.O ' send message
       Outpt="It disintegrated!" ' scroll vanished message
       Call IO.O ' send output
       If Type.Number=False Then ' compare treasure in room
          ' remove scroll from inventory
          Call Discard.Inventory(Array.Number,True)
       Else ' compare treasure
          Call Discard.Room.Treasure(Array.Number) ' remove scroll from room
       Endif ' end compare treasure
    Endif ' end compare scroll spell number
    Exit Sub ' exit routine
 Endif ' end compare treasure is scroll
 Outpt=Prefix1+Outpts ' format treasure name description
 If TreasureRecord.Keyed Then ' append key number to treasure name
    Outpt=Outpt+" (#"+Right$(Str$(TreasureRecord.Keyed+100000!),5)+")"
 Endif ' end compare treasure key number
 If TreasureRecord.Plus Then ' append plus number to treasure name
    Outpt=Outpt+"(+"+Mid$(Str$(Abs(TreasureRecord.Plus)),2)+")"
 Endif ' end compare treasure plus
 If TreasureRecord.Spell Then ' append spell plus to treasure name
    Get 9,TreasureRecord.Spell,SpellRecord ' get spell record of treasure
    Outpt=Outpt+"(+"+Mid$(Str$(SpellRecord.Level),2)+")"
 Endif ' end compare treasure spell plus
 If TreasureRecord.LightType Then ' compare treasure to a light
    If Charges.Number<False Then ' check treasure is also lit
       Outpt=Outpt+" [lit]" ' append to treasure name
    Endif ' end check lit treasure
 Endif ' end compare treasure to light
 If TreasureRecord.Invisible Then ' compare treasure is invisible
    Outpt=Outpt+" [inv]" ' append to treasure name
 Else ' compare treasure
    If Type.Number=1 Then ' check treasure is in room
       ' verify treasure in
       If RoomRecord.Flags(Array.Number)=Hidden.Object Then
          Outpt=Outpt+" [inv]" ' room is invisible, append to name
       Endif ' end verify treasure in room was hidden
    Endif ' end check treasure in room
 Endif ' end compare treasure is invisible
 Call IO.O ' display treasure name message
 If TreasureRecord.Proficiency Then ' compare treasure proficiency
    Outpt=Weapon.Type.Name(TreasureRecord.Proficiency) ' get proficiency
    Outpt=Rtrim$(Outpt) ' name and trim
    Outpt="This is a "+Outpt+" weapon." ' make weapon type message
    Call IO.O ' display weapon type message
 Endif ' end compare treasure proficiency
 If Last.Command.Number=Identify.Command Then ' check identify command used
    Outpt="It's worth"+Str$(TreasureRecord.Gold)+" gold peices."
    Call IO.O ' display treasure item gold value
    Outpt="It weighs"+Str$(TreasureRecord.Weight)+" pounds."
    Call IO.O ' display weight of item
    If TreasureRecord.RingType Then ' compare treasure ring type
       Select Case TreasureRecord.RingType ' determine ring type
       Case 1 ' ring type
          Outpt="protection from poison." ' ring type message
       Case 2 ' ring type
          Outpt="protection from level drain." ' ring type message
       Case 3 ' ring type
          Outpt="protection from spells." ' ring type message
       End Select ' end dtermine ring type
       Outpt="Its ring spell is "+Outpt ' make ring type message
       Call IO.O ' send ring type message
    Endif ' end compare treasure to ring
    If TreasureRecord.Spell Then ' compare treasure spell type
       Get 9,TreasureRecord.Spell,SpellRecord ' get treasure spell record
       Outpt="Its magical spell is "+Rtrim$(SpellRecord.SpellName)+"."
       Call IO.O ' display name of treasure spell
    Endif ' end compare treasure spell type
    ' compare treasure is loaded
    If TreasureRecord.Loadable Or TreasureRecord.Launchable Then
       If Charges.Number<=False Then ' compare treasure charges
          Outpt="It's not loaded." ' display message
       Else ' compare treasure charges
          Outpt="It's loaded with"+Str$(Charges.Number)+" charges." ' message
       Endif ' end compare loaded treasure charges
       Call IO.O ' send message of charges in loaded treasure
    Else ' compare treasure item
       If TreasureRecord.LightType Then ' compare treasure is a light
          If Charges.Number<False Then ' compare light charges (is negative)
             Outpt="It's fueled with"+Str$(Abs(Charges.Number))+" charges."
             Call IO.O ' send message of charges in light
          Endif ' end compare light charges
       Else ' compare other treasure plus
          If TreasureRecord.RingType Or TreasureRecord.Spell Or_
          TreasureRecord.Plus Then ' treasure has charges
             If Charges.Number<=False Then ' compare charges
                Outpt="It's empty of charges." ' message
             Else ' compare charges
                ' message of charges
                Outpt="It has"+Str$(Charges.Number)+" charges."
             Endif ' end compare charges
             Call IO.O ' send message of charges
          Endif ' end compare treasure charges
       Endif ' end compare treasure plus
    Endif ' end compare treasure
    ' compare treasure is ammunition
    If TreasureRecord.Ammunition Or TreasureRecord.LaunchAmmo Then
       Outpt="It's ammunition." ' treasure nessage
       Call IO.O ' send message
    Endif ' end compare treasure
    If TreasureRecord.Potion Then ' compare treasure to potion
       Outpt="It's a potion." ' make message
       Call IO.O ' send message
    Endif ' end compare to potion
    If TreasureRecord.Edible Then ' compare treasure to food
       Outpt="It's edible." ' make message
       Call IO.O ' send message
    Endif ' end compare to food
 Endif ' end identify command
 Graphics.Off=False ' reset color
End Sub ' end routine to display an itemof treasure

 Rem * routine to display container information.
 Rem * input variables:
 Rem *   ContainerRec - container record to display.
 Rem *   Type.Number - item is in room/inventory.

Sub Show.Container
 On Local Error Resume Next ' local error resume
 If Type.Number Then ' container in room
    Prefix1="It's " ' format prefix
 Else ' container in inventory
    Prefix1="You are carrying " ' format prefix
 Endif ' end container check
 Graphics.Off=True ' reset color
 Outpt=Prefix1+Rtrim$(ContainerRec.ContainerName) ' make container name
 If ContainerRec.Keyed Then ' check container has a lock number
    Outpt=Outpt+" (#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
 Endif ' end append container lock number
 Outpt=Outpt+"." ' append to message
 Call IO.O ' send message of container name
 If ContainerRec.Locked>False Then ' verify container is locked
    Outpt="It's locked." ' make message
    Call IO.O ' send output
    Exit Sub ' exit routine
 Endif ' end verify locked container
 If ContainerRec.Closed>False Then ' verify container is closed
    Outpt="It's closed." ' make message
    Call IO.O ' send output
    Exit Sub ' exit routine
 Endif ' end verify closed container
 Outpt="It contains the following treasure:" ' message
 Call IO.O ' send prefix message
 Container.Count=False ' reset number of container items displayed
 Outpt=Nul ' reset message of container item
 For Array.Index=1 To 5 ' loop through all container items
    ' store container invisibility flag
    Invisible.Container=ContainerRec.Invisible(Array.Index)
    ' store container inventory number
    Container.Number=ContainerRec.Inventory(Array.Index)
    Display.Item=True ' reset flag to display container item
    If Container.Number Then ' check container item
       If Invisible.Container=True Then ' verify item is invisible
          If Normal.User Then ' determine non DM
             Display.Item=False ' set flag not to display item
          Endif ' end normal user
       Endif ' end invisible item
       If Display.Item=True Then ' check flag to display item
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send message of previous item
          ' get treasure record of container item
          Get 6,Container.Number,TreasureRecord
          Outpts=TreasureRecord.TreasureName ' store treasure name
          Outpts=Rtrim$(Outpts) ' trim name
          If Invisible.Container=True Then ' compare invisible item
             Outpts=Outpts+" [inv]" ' sppend invisible message
          Endif ' end compare invisible
          Outpt=Outpts+", " ' append comma to item name
          ' increment number of items displayed
          Container.Count=Container.Count+1
          If Container.Count=1 Then ' check if first item displayed
             Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first item
          Endif ' end compare to first item
       Endif ' end check display flag
    Endif ' end check container item
 Next ' end loop through all five items
 If Container.Count=False Then ' check if any container items displayed
    Outpt="Nothing at all." ' make message
 Else ' check any container items displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
    If Container.Count>1 Then ' more than one item displayed
       Outpt="and "+Outpt ' append to message
    Endif ' end check item number
 Endif ' end check item number
 Call IO.O ' send message of last contaier item
 Graphics.Off=False ' reset color
End Sub ' end routine to display container information

 Rem * routine to display object information.
 Rem * input variables:
 Rem *   Index.Number - object record number.
 Rem *   Type.Number - object is in room/inventory.

Sub Show.Object
 On Local Error Resume Next ' local error resume
 If Type.Number Then ' determine object in room
    Prefix1="It's " ' make prefix
 Else ' object in inventory
    Prefix1="You are carrying " ' make prefix
 Endif ' end determine in room
 Graphics.Off=True ' reset color
 Outpt=Prefix1+Outpts ' make message with object name
 If ObjectRecord.DoorLock>1 Then ' compare object is locked
    Outpt=Outpt+" [locked]" ' append to object name
 Endif ' end compare locked object
 If ObjectRecord.DoorLock=1 Then ' compare object is unlocked
    If ObjectRecord.Closed Then ' compare object is closed
       Outpt=Outpt+" [closed]" ' append to object name
    Endif ' end compare closed object
 Endif ' end compare object lock
 If ObjectRecord.Invisible Then ' compare object is invisible
    Outpt=Outpt+" [inv]" ' append to object name
 Endif ' end compare object invisible
 If ObjectRecord.Keyed Then ' compare object key, append number to name
    Outpt=Outpt+" (#"+Right$(Str$(ObjectRecord.Keyed+100000!),5)+")"
 Endif ' end compare object key number
 Call IO.O ' display message with object name
 Outpt=ObjectRecord.LongDesc ' store object additional description
 Outpt=Rtrim$(Outpt) ' trim description
 If Outpt<>Nul Then ' compare length of description
    Call IO.O ' display additional object description
 Endif ' end compare object description length
 Graphics.Off=False ' reset color
End Sub ' end routine to display object information

 Rem * routine to display information on a monster.
 Rem * input variables:
 Rem *   Monster.Number - number of monster array.

Sub Show.Monster
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Call The.Or.An ' routine for monster name prefix (a, an, the)
 Level=MonsterArray(Monster.Number).Level ' store monster level
 Outpt="It's "+Prefix1+Outpts ' make message of monster name
 ' append monster level (range of player's level capable to kill monster)
 Outpt=Outpt+" (level"+Str$((Level-1)*2+1)+" to"+Str$(Level*2)+")"
 Call IO.O ' send message with monster name and level range
 If Last.Command.Number=Identify.Command Then ' compare identify command
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Hits)+" hits,"+_
    Str$(MonsterArray(Monster.Number).Experience)+" experience, and"+_
    Str$(MonsterArray(Monster.Number).Gold)+" gold."
    Call IO.O ' display message of monster gold
    Outpt="It carries the following treasure:" ' make message
    Call IO.O ' send message of treasure carried by monster
    Inventory.Count=False ' reset number of monster inventory items displayed
    For Array.Count=1 To 5 ' loop through all monster inventory
       ' get treasure
       Container.Number=MonsterArray(Monster.Number).Treasure(Array.Count)
       ' number and check range in treasure file
       If Container.Number>False And_
          Container.Number<=Lof(6)/Len(TreasureRecord) Then
          Carriage.Return=True ' flag to disable return/linefeed
          Call IO.O ' send output of previous item
          Get 6,Container.Number,TreasureRecord ' get treasure record of item
          Outpts=TreasureRecord.TreasureName ' store treasure name
          Outpt=Rtrim$(Outpts)+", " ' trim name, append comma
          Inventory.Count=Inventory.Count+1 ' increment items displayed flag
          If Inventory.Count=1 Then ' compare item to first displayed
             Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first item
          Endif ' end compare first item
       Endif ' end check treasure file range
    Next ' end loop through monster inventory
    If Inventory.Count=False Then ' check if any items displayed
       Outpt="Nothing at all." ' make message for none
    Else ' check items displayed
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
       If Inventory.Count>1 Then ' check more than one item displayed
          Outpt="and "+Outpt ' append to last item
       Endif ' end check items
    Endif ' end check item
    Call IO.O ' send output for last item
    ' compare monster spell ability
    Spell.Number=MonsterArray(Monster.Number).Spell
    ' check spell
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' range and get spell record
       Outpt="It can cast "+Rtrim$(SpellRecord.SpellName)+" spells!"
       Call IO.O ' send message of spell name monster can cast
    Endif ' end compare monster spell
    If MonsterArray(Monster.Number).Poison Then ' compare monster poisonous
       Outpt="It can poison!" ' make message
       Call IO.O ' send output message
    Endif ' end compare monster poisonous
    If MonsterArray(Monster.Number).LevelDrain Then ' compare monster undead
       Outpt="It can drain levels!" ' make message
       Call IO.O ' send output message
    Endif ' end compare monster undead
    If MonsterArray(Monster.Number).Psionic Then ' compare monster astral
       Outpt="It can cast psi spells!" ' make message
       Call IO.O ' send output message
    Endif ' end compare monster astral
 Endif ' end check identify command used
 Graphics.Off=False ' reset color
End Sub ' end routine to display monster information

 Rem * routine to determine validity of room number.
 Rem * input variables:
 Rem *   Room - contains room number to check.

Sub Check.Next.Room
 On Local Error Resume Next ' local error resume
 Do ' loop until room is valid, room is created, or nondescriptive hangup
    If Room>False And Room<=Lof(3)/Len(RoomRecord) Then ' check room range
       Get 3,Room,RoomRecord ' valid range, get room record
       Exit Sub ' exit routine
    Endif ' end check valid range
    If Room>Lof(3)/Len(RoomRecord) Then ' compare room number out of range
       If Not Normal.User Then ' check non DM status
          Call Add.Room(False,Room.Created) ' routine to create new room
          If Room.Created Then ' return variable indicates new room created
             Exit Sub ' exit routine
          Endif ' end create new room
       Endif ' end check normal user
    Endif ' end compare room number range
    ' otherwise, any room number out of range will be changed to room 1, or
    ' changed to the resurrection room number.
    If Lof(3)/Len(RoomRecord)>=51 Then ' check there is at least one room
       Graphics.Off=False ' reset color
       Outpt="Nondescriptive room number"+Str$(Room)+"!" ' make error message
       Call IO.O ' display room number error message
       Room=51 ' reset room number to resurrection room, continue loop
    Else ' room file is invalid, room file length is zero
       Graphics.Off=False ' reset color
       Room=1 ' reset room number
       Call Hang.Up(10) ' routine to terminate program w/ message
       Exit Sub ' exit routine
    Endif ' end check room file length
 Loop ' end loop until valid room number
End Sub ' end routine to check room number validity

 Rem * routine to initialize some room variables, check next room number, and
 Rem * display next room description.
 Rem * input variables:
 Rem *   Room - room number to move to.
 Rem * output variables:
 Rem *   Room.Rust.Rate - number of prompts to check weapon rusting.
 Rem *   Room.Steal.Rate - number of prompts to check monster stealing.
 Rem *   Room.Monster.Rate - number of prompts to check monster encounter.
 Rem *   Room.Health.Rate - number of prompts to check health increases.

Sub Display.Room
 On Local Error Resume Next ' local error resume
 Call Check.Next.Room ' routine to verify next room number
 Room.Rust.Rate=False ' store room rust rate
 Room.Steal.Rate=False ' store room steal rate
 Room.Monster.Rate=6 ' store default room encounter rate
 Room.Health.Rate=6 ' store default room health rate
 Room.Action=RoomRecord.Action
 If Room.Action>False And Room.Action<=Lof(12)/Len(ActionRecord) Then
    Get 12,Room.Action,ActionRecord
    If ActionRecord.RustRate>False Then ' check room record action rust rate
       Room.Rust.Rate=ActionRecord.RustRate ' store room rust rate
    Endif ' end check action
    If ActionRecord.StealRate>False Then ' check room record action steal rate
       Room.Steal.Rate=ActionRecord.StealRate ' store room steal rate
    Endif ' end check action
    ' check room record action encounter rate
    If ActionRecord.EncounterRate Then
       ' store action encounter rate
       Room.Monster.Rate=ActionRecord.EncounterRate
    Endif ' end check action
    If ActionRecord.HealthRate Then ' check room record action health rate
       Room.Health.Rate=ActionRecord.HealthRate ' store action health rate
    Endif ' end check action
 Endif
 Call Show.Room ' routine to display room
End Sub ' end routine to process next room

 Rem * routine to display room description (short or long), objects in room,
 Rem * monsters in room, containers in room, and directions/exits from room.
 Rem * working variables:
 Rem *   Lit.Room - returned true if room is unlit.

Sub Show.Room
 On Local Error Resume Next ' local error resume
 Call Check.Lit.Room(Lit.Room) ' routine to determine if room is unlit
 If Lit.Room Then ' check unlit room
    Outpt="It's too dark to see!" ' make message
    Call IO.O ' send message output
    Exit Sub ' exit routine
 Endif ' end check unlit room
 Graphics.Off=True ' reser color
 ' check if user is in brief mode, or room has no long description
 If UserRecord.Brief Or Rtrim$(RoomRecord.LongDesc(1))=Nul Then
    If Normal.User=False Then ' compare non DM status
       Outpt="(room:"+Str$(Room)+", monclass:" ' display DM room statistics
       If Room=51 Then ' check safe haven room
          Outpt=Outpt+" <safe haven>" ' append room message
       Else ' check safe haven
          Outpt=Outpt+Str$(RoomRecord.MonsterClass) ' display room number
       Endif ' end check safe haven room number
       Outpt=Outpt+", action:"+Str$(RoomRecord.Action)+")"
       Call IO.O ' display room monster class
    Endif ' end compare normal user in brief description
    Outpt=RoomRecord.ShortDesc ' store room short one line description
    Outpt=Rtrim$(Outpt) ' trim brief description
    ' find any null characters from old structures
    If Instr(Outpt,Chr$(0)) Then
       Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
    Endif ' end find old nulls
    Call IO.O ' display room short description
 Else ' display room four line long description
    For Desc.Line=1 To 4 ' loop through all four long room description lines
       Outpt=RoomRecord.LongDesc(Desc.Line) ' get next room description line
       Outpt=Rtrim$(Outpt) ' trim room description line
       If Instr(Outpt,Chr$(0)) Then ' find any nul characters from old files
          Outpt=Left$(Outpt,Instr(Outpt,Chr$(0))-1) ' truncate off nulls
       Endif ' end find old nulls
       If Outpt=Nul Then ' check if long description ends
          Exit For ' exit long description display loop
       Endif ' end check description end
       Call IO.O ' display room description line
    Next ' end long room description loop
 Endif ' end check room description to display
 Exit.Displayed=False ' set flag for an exit displayed
 If UserRecord.Brief Then ' check user is in brief mode
    Outpt=Nul ' assign empty display string
 Else ' user is not in brief mode
    Outpt="The exits are " ' assign initial display string
 Endif ' end check brief mode
 For Direction.Number=1 To 11 ' loop through all room directions
    ' compare room structure for direction
    If RoomRecord.Direct(Direction.Number) Then
       ' append exit to string
       Outpt=Outpt+Rtrim$(Direction(Direction.Number))+", "
       Exit.Displayed=True ' set flag for an exit displayed
    Endif ' end compare room direction exists
 Next ' end loop through room directions
 If Exit.Displayed Then ' compare flag for an exit displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' truncate trailing comma, add period
    If UserRecord.Brief Then ' check user in brief mode
       Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' set first letter uppercase
    Endif ' end check brief mode
    Call IO.O ' send room exit display
 Endif ' end compare exit displayed flag
 ' following displays all objects, treasure, monsters, and container in room
 If UserRecord.Brief=False Then ' check user is in brief mode
    Outpt="You see " ' assign intial string
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send initial string
 Endif ' end check brief mode
 Outpt=Nul ' assign empty display string
 Items.Displayed=False ' reset number of items displayed
 Object.Displayed=False ' reset flag indicating an item has been displayed
 For Array.Index=1 To 10 ' loop through all ten objects in room
    Display.Object=False ' set flag to show object
    Object.Number=RoomRecord.Object(Array.Index) ' store room object number
    ' compare range
    If Object.Number>False And Object.Number<=Lof(4)/Len(ObjectRecord) Then
       Get 4,Object.Number,ObjectRecord ' get object record
       If ObjectRecord.Invisible Then ' check object is invisible
          If Normal.User Then ' verify non DM
             Display.Object=True ' set flag to show object off
          Endif ' end verify normal user
       Endif ' end check invisible object
       If ObjectRecord.Hidden Then ' check object is hidden
          If Normal.User Then ' verify non DM
             Display.Object=True ' set flag to show object off
          Endif ' end verify normal user
       Endif ' end check hidden object
       If Display.Object=False Then ' check display flag
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send display of previous item
          ' increment number of items displayed
          Items.Displayed=Items.Displayed+1
          If Items.Displayed=1 Then ' verify first item being displayed
             If UserRecord.Brief Then ' check user in brief mode
                Outpt="You see " ' send initial display string
                Carriage.Return=True ' set flag to disable return/linefeed
                Call IO.O ' send previous string
             Endif ' end check brief mode
          Endif ' end verify first item
          Outpt=ObjectRecord.ObjectName ' store object name
          Outpt=Rtrim$(Outpt) ' trim object name
          If ObjectRecord.DoorLock>1 Then ' check object is locked
             Outpt=Outpt+" [locked]" ' append message
          Else ' compare unlocked object
             If ObjectRecord.DoorLock Then ' check object has lock
                If ObjectRecord.Closed Then ' check object is closed
                   Outpt=Outpt+" [closed]" ' append message
                Endif ' end check closed object
             Endif ' end check object is lock
          Endif ' end check object is locked
          If ObjectRecord.Hidden Then ' check object is hidden
             Outpt=Outpt+" [hidden]" ' append message
          Else ' check object not hidden
             If ObjectRecord.Invisible Then ' check object is invisible
                Outpt=Outpt+" [inv]" ' append message
             Endif ' end check invisible object
          Endif ' end check object hidden
          Outpt=Outpt+", " ' append comma
          Object.Displayed=True ' set flag indicating an item displayed
       Endif ' end check display flag
    Endif ' end compare object file record range
 Next ' end loop through objects in room
 For Array.Index=1 To 10 ' loop through all room treasure
    Display.Treasure=False ' set flag to display item
    Treasure.Number=RoomRecord.Treasure(Array.Index) ' store treasure number
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' compare range
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       ' compare invisible treasure flag
       If RoomRecord.Flags(Array.Index)>False Then
          If Normal.User Then ' check non DM
             Display.Treasure=True ' set flag to display item
          Endif ' end check normal user
       Endif ' end compare invisible treasure
       If TreasureRecord.Invisible Then ' check treasure is invisible
          If Normal.User Then ' check non DM
             Display.Treasure=True ' set display flag
          Endif ' end check normal user
       Endif ' end check invisible treasure
       If Display.Treasure=False Then ' compare display flag
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' display previous item
          ' increment number of items displayed
          Items.Displayed=Items.Displayed+1
          If Items.Displayed=1 Then ' check first item
             If UserRecord.Brief Then ' check user is in brief mode
                Outpt="You see " ' make initial string
                Carriage.Return=True ' set flag to disable return/linefeed
                Call IO.O ' send initial string
             Endif ' end check brief mode
          Endif
          Outpt=TreasureRecord.TreasureName ' get treasure name
          Outpt=Rtrim$(Outpt) ' trim treasure name
          If TreasureRecord.Locked>False Then ' check treasure is locked
             Outpt=Outpt+" [locked]" ' append message
          Else ' check treasure locks
             If TreasureRecord.Locked<False Then ' check treasure lock
                If TreasureRecord.Closed>False Then ' check treasure is closed
                   Outpt=Outpt+" [closed]" ' append message
                Endif ' end check closed treasure
             Endif ' end check treasure lock
          Endif ' end check locked treasure
          If TreasureRecord.Invisible Then ' check treasure is invisible
             Outpt=Outpt+" [inv]" ' append message
          Else ' treasure is not invisible
             ' check invisible
             If RoomRecord.Flags(Array.Index)=Hidden.Object Then
                Outpt=Outpt+" [inv]" ' treasure flag, append message
             Endif ' end check invisible flag
          Endif ' end check invisible treasure
          If RoomRecord.Flags(Array.Index)=Magic.Trap Then ' check magic trap
             Outpt=Outpt+" [trap]" ' treasure flag, append message
          Endif ' end check magic trap flag
          Outpt=Outpt+", " ' append comma
          Object.Displayed=True ' set item displayed flag
       Endif ' end compare display flag
    Endif ' end compare treasure file record range
 Next ' end loop through treasure
 ContainerRec=RoomRecord.Container ' store room container into record
 If Rtrim$(ContainerRec.ShortName)<>Nul Then ' compare container name length
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send previous string
    Items.Displayed=Items.Displayed+1 ' increment number of items displayed
    If Items.Displayed=1 Then ' check first item displayed
       If UserRecord.Brief Then ' check user is in brief mode
          Outpt="You see " ' make initial string
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send first string
       Endif ' end check brief mode
    Endif ' end check first display item
    Outpt=Rtrim$(ContainerRec.ContainerName) ' store container name
    If ContainerRec.Locked>False Then ' check container is locked
       Outpt=Outpt+" [locked]" ' append message
    Else ' container is not locked
       If ContainerRec.Closed>False Then ' check container is closed
          Outpt=Outpt+" [closed]" ' append message
       Endif ' end check closed container
    Endif ' end check locked container
    If ContainerRec.Keyed Then ' check container has a key number
       Outpt=Outpt+" (#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
    Endif ' append key number to container name
    Outpt=Outpt+", " ' append comma
    Object.Displayed=True ' set an item displayed flag
 Endif ' end compare container name length
 For Monster.Number=1 To Number.Monsters ' loop through all room monsters
    Carriage.Return=True ' set flag to disable return/linefeed
    Call IO.O ' send previous string
    Items.Displayed=Items.Displayed+1 ' increment number of items displayed
    If Items.Displayed=1 Then ' check first item
       If UserRecord.Brief Then ' check user is in brief mode
          Outpt="You see " ' make initial string
          Carriage.Return=True ' set flag to disable return/linefeed
          Call IO.O ' send initial string
       Endif ' end check brief mode
    Endif ' end check first item
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' trim monster name
    Call The.Or.An ' routine to get prefix (a, an, the)
    Outpt=Outpt+Prefix1+Outpts+", " ' make message of monster
    Object.Displayed=True ' set an item displayed flag
 Next ' end loop through monsters in room
 If Object.Displayed=False Then ' compare flag indicating an item is displayed
    If UserRecord.Brief=False Then ' check user is in brief mode
       Outpt="nothing special." ' make last item string
    Else ' user is in brief mode
       Outpt="You see nothing." ' make entire message
    Endif ' end check brief mode
 Else ' an item was displayed
    If Outpt<>Nul Then ' compare string length
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
       If Items.Displayed>1 Then ' check more than one item was displayed
          Outpt="and "+Outpt ' append to last item
       Endif ' end check item numbers
    Endif ' end check valid last item string
 Endif ' end check flag of items displayed
 Call IO.O ' send last display item
End Sub ' end routine to show room description, etc.

 Rem * routine to determine if a room is unlit.
 Rem * return variables:
 Rem *   Lit.Room - true if room is unlit.

Sub Check.Lit.Room(Lit.Room)
 On Local Error Resume Next ' local error resume
 Lit.Room=False
 Get 3,Room,RoomRecord ' get room record
 Action.Number=RoomRecord.Action
 If Action.Number>False And Action.Number<=Lof(12)/Len(ActionRecord) Then
    Get 12,Action.Number,ActionRecord
    If (ActionRecord.Attribute1 And LitRoom)=LitRoom Then ' compare unlit flag
       Lit.Room=True ' set flag indicating room is unlit
    Else ' compare unlit flag
       Lit.Room=False ' flag for lit room
       Exit Sub ' exit routine
    Endif ' end compare unlit flag
 Endif
 For Array.Index=1 To 15 ' loop through all user inventory
    ' get user inventory treasure number
    Treasure.Number=UserRecord.Inv(Array.Index)
    If Treasure.Number Then ' compare user treasure number
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       If TreasureRecord.LightType Then ' check treasure item is a light
          ' check light is charged/lit
          If UserRecord.Charges(Array.Index)<False Then
             Lit.Room=False ' set flag for lit room
             Exit Sub ' exit routine
          Endif ' end check charged light
       Endif ' end check treasure is a light
    Endif ' end compare treasure number
 Next ' end loop through user inventory
 For Array.Index=1 To 10 ' loop through all treasure in room
    ' get room treasure number
    Treasure.Number=RoomRecord.Treasure(Array.Index)
    If Treasure.Number Then ' compare treasure number
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       If TreasureRecord.LightType Then ' compare treasure is a light
          ' compare light is charged
          If RoomRecord.TreCharges(Array.Index)<False Then
             Lit.Room=False ' set flag for lit room
             Exit Sub ' exit routine
          Endif ' end compare charged light
       Endif ' end compare treasure is a light
    Endif ' end compare treasure number
 Next ' end loop through room treasure
 For Array.Index=1 To 10 ' loop through all room objects
    If RoomRecord.Object(Array.Index) Then ' compare room object number
       Get 4,RoomRecord.Object(Array.Index),ObjectRecord ' get object record
       If ObjectRecord.LightRoom Then ' check object is a light
          If ObjectRecord.LightTime=False Then ' object lights at any time
             Lit.Room=False ' set flag for lit room
             Exit Sub ' exit routine
          Else ' light has light time restriction
             ' calculate seconds light from/to
             Start.Time!=Csng(ObjectRecord.FromHour*3600!+_
             ObjectRecord.FromMin*60!)
             End.Time!=Csng(ObjectRecord.ToHour*3600!+ObjectRecord.ToMin*60!)
             ' check valid light time
             If Start.Time!>False Or End.Time!>False Then
                ' compare times
                If Timer>=Start.Time! And Timer<=End.Time! Then
                   Lit.Room=False ' set room lit flag
                   Exit Sub ' exit routine
                Endif ' end compare times
             Endif ' end check valid light time
          Endif ' end check object light type
       Endif ' end check object is a light
    Endif ' end compare object number
 Next ' end loop through room objects
 For Array.Index=1 To 5 ' loop through all user object inventory
    If UserRecord.Object(Array.Index) Then ' compare user object number
       Get 4,UserRecord.Object(Array.Index),ObjectRecord ' get object record
       If ObjectRecord.LightRoom Then ' compare object is a light
          If ObjectRecord.LightTime=False Then ' check object lights any time
             Lit.Room=False ' set flag for lit room
             Exit Sub ' exit routine
          Else ' compare object light time restriction
             ' calculate seconds light from/to
             Start.Time!=Csng(ObjectRecord.FromHour*3600!+_
             ObjectRecord.FromMin*60!)
             End.Time!=Csng(ObjectRecord.ToHour*3600!+ObjectRecord.ToMin*60!)
             ' check valid light time
             If Start.Time!>False Or End.Time!>False Then
                ' compare times
                If Timer>=Start.Time! And Timer<=End.Time! Then
                   Lit.Room=False ' set lit room flag
                   Exit Sub ' exit routine
                Endif ' end compare times
             Endif ' end check valid light times
          Endif ' end compare object light type
       Endif ' end compare object is a light
    Endif ' end compare object number
 Next ' end loop through user objects
End Sub ' end routine to determine lit room

 Rem * routine to display all the player character statistics.

Sub Display.Stats
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Outpt=UserRecord.CodeName ' get user codename
 Call Decrypt(Outpt) ' decrypt codename
 Outpt=Rtrim$(Outpt) ' trim codename
 Outpt=Lcase$(Outpt) ' set codename to lowercase
 Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
 Outpt="Information: "+Outpt+". "+FNclock$+"." ' make information message
 Call IO.O ' send message
 Call Show.Align ' routine to display player alignment
 Call Show.Health ' routine to display player statistics
 Call Display.Info ' routine to display additional player information
 Call Display.Inventory ' routine to display player inventory
End Sub ' end routine to display all player character statistics

 Rem * routine to display player character inventory.

Sub Display.Inventory
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Outpt="You are carrying"+Str$(Weight)+" pounds of items:" ' weight message
 Call IO.O ' send output message
 Items.Displayed=False ' number of items displayed
 For Array.Index=1 To 15 ' loop through all player treasure inventory
    Treasure.Number=UserRecord.Inv(Array.Index) ' get treasure number
    If Treasure.Number Then ' compare number
       Carriage.Return=True ' disable return/linefeed
       Call IO.O ' send initial item
       Get 6,Treasure.Number,TreasureRecord ' get treasure record
       Outpts=TreasureRecord.TreasureName ' store treasure name
       Outpts=Rtrim$(Outpts) ' trim name
       If TreasureRecord.LightType Then ' check treasure is a light
          If UserRecord.Charges(Array.Index)<False Then ' check light charges
             Outpts=Outpts+" [lit]" ' append message
          Endif ' end check charges
       Endif ' end check light
       If TreasureRecord.Invisible Then ' check treasure is invisible
          Outpts=Outpts+" [inv]" ' append message
       Endif ' end check invisible
       Outpt=Outpts+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end compare treasure number
 Next ' end loop through inventory treasure
 For Array.Index=1 To 5 ' loop through player object inventory
    Object.Number=UserRecord.Object(Array.Index) ' get object number
    If Object.Number Then ' compare object number
       Carriage.Return=True ' disable return/linefeed
       Call IO.O ' send previous item
       Get 4,Object.Number,ObjectRecord ' get object record
       Outpts=ObjectRecord.ObjectName ' store object name
       Outpts=Rtrim$(Outpts) ' trim object name
       Outpt=Outpts+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end check object number
 Next ' end loop through object inventory
 For Array.Index=1 To 3 ' loop through all player character containers
    ' store container into record
    ContainerRec=UserRecord.Container(Array.Index)
    ' compare container name length
    If Rtrim$(ContainerRec.ShortName)<>Nul Then
       Carriage.Return=True ' disable retuen/linefeed
       Call IO.O ' send previous item
       Outpt=Rtrim$(ContainerRec.ContainerName) ' store container name
       If ContainerRec.Locked>False Then ' check container locked
          Outpt=Outpt+" [locked]" ' append message
       Else ' container not locked
          If ContainerRec.Closed>False Then ' check container closed
             Outpt=Outpt+" [closed]" ' append message
          Endif ' end check closed container
       Endif ' end check locked container
       If ContainerRec.Keyed Then ' check container key number
          Outpt=Outpt+" (#"+Right$(Str$(ContainerRec.Keyed+100000!),5)+")"
       Endif ' append container key number to message
       Outpt=Outpt+", " ' append comma
       Items.Displayed=Items.Displayed+1 ' increment item number
       If Items.Displayed=1 Then ' check first item
          Mid$(Outpt,1,1)=Ucase$(Mid$(Outpt,1,1)) ' uppercase first letter
       Endif ' end check first item
    Endif ' end compare container name length
 Next ' end loop through player containers
 If Items.Displayed=False Then ' compare items displayed
    Outpt="Nothing at all." ' display message
 Else ' some items displayed
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, append period
    If Items.Displayed>1 Then ' check more than one item displayed
       Outpt="and "+Outpt ' add to message
    Endif ' end check item numbers
 Endif ' end compare items
 Call IO.O ' send last item
 Call Display.Experience ' routine to display player experience/gold
End Sub ' end routine to display player inventory

 Rem * routine to display player character experience, and gold.
 Rem * routine notes:
 Rem *    although gold and experience required to reach the next level double
 Rem *    each player level, the experience and gold required for players over
 Rem *    level 10 only increase by 10,000 points per level over 10.

Sub Display.Experience
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Outpt="You have"+Str$(UserRecord.Gold)+" gold and"+_
 Str$(UserRecord.Experience)+" experience." ' make gold/experience message
 Call IO.O ' send output message
 Level=UserRecord.Level ' store player level
 If Level>False And Level<MaxInt Then ' compare level maximum
    Level=Level+1 ' increment next level needed
    ' routine to calculate gold required for next level
    Call Gold(Gold.Required#)
    Call Experience(Exp.Required#) ' routine to calculate experience needed
    Outpt="You need"+Str$(Gold.Required#)+" gold and"+Str$(Exp.Required#)+_
    " experience to reach level"+Str$(Level)+"." ' make message
    Call IO.O ' send output message
 Else ' compare level
    Outpt="There is no experience or gold at your level."
    Call IO.O
 Endif ' end compare level
End Sub

 Rem * routine to display player characteristics, and weapons, shields, armor,
 Rem * and rings being held/worn.

Sub Display.Info
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 If Sysop Then ' verify user is a sysop
    Outpt="You are a Sysop!" ' make message
    Call IO.O ' send message
 Endif ' end verify sysop
 If Dungeon.Master Then ' verify user is a DM
    Outpt="You are a Dungeon Master!" ' make message
    Call IO.O ' send message
 Endif ' end verify DM
 If Dungeon.Master.Assistant Then ' verify user is an Asst. DM
    Outpt="You are an Assistant Dungeon Master!" ' make message
    Call IO.O ' send message
 Endif ' end verify Asst. DM
 If Town.Mayor Then ' verify user is the mayor
    Outpt="You are the Town Mayor!" ' make message
    Call IO.O ' send message
 Endif ' end verify mayor
 If Governor Then ' verify user is governor
    Outpt="You are the Governor!" ' make message
    Call IO.O ' send message
 Endif ' end verify governor
 If Guild.Master Then ' verify user is guild master
    Outpt="You are the Guild Master!" ' make message
    Call IO.O ' send message
 Endif ' end verify guild master
 If UserRecord.Invisible Or Invisible Then ' check invisibility
    Outpt="You are invisible!" ' make message
    Call IO.O ' send message
 Endif ' end check invisibility
 If UserRecord.Poison Then ' check poisoned
    Outpt="You are poisoned!" ' make message
    Call IO.O ' send message
 Endif ' end check poisoned
 If Weapon1=False Then ' check wearing armor
    If Weapon7=False Then ' check wearing ring
       Outpt="You are wearing nothing." ' make message
       Call IO.O ' send message
    Endif ' end check ring
 Endif ' end check armor
 If Weapon2=False Then ' check holding weapon
    If Weapon3=False Then ' check holding shield
       Outpt="You are holding nothing." ' make message
       Call IO.O ' send message
    Endif ' end check shield
 Endif ' end check weapon
 Outpt=Nul ' clear display string
 If Weapon1 Or Weapon7 Then ' check either armor or ring being worn
    Outpt="You are wearing " ' initialize display string
    If Weapon1 Then ' check armor being worn
       Get 6,Abs(UserRecord.Inv(Weapon4)),TreasureRecord ' get armor treasure
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName) ' record, append name
    Endif ' end check armor worn
 Endif ' end check either being worn
 If Weapon7 Then ' check ring being worn
    Get 6,Abs(UserRecord.Inv(Weapon7)),TreasureRecord ' ring treasure record
    If Weapon1 Then ' check armor worn again
       Outpt=Outpt+" and "+Rtrim$(TreasureRecord.TreasureName)+"." ' append
       Call IO.O ' both items being worn
    Else ' armor not worn
       Outpt="You are wearing "+Rtrim$(TreasureRecord.TreasureName)+"."
       Call IO.O ' display only ring being worn
    Endif ' end check armor worn
 Else ' end check ring worn
    If Weapon1 Then ' check armor worn, ring not
       Outpt=Outpt+"." ' append period
       Call IO.O ' display only armor worn
    Endif ' end check armor, ring
 Endif ' end check ring worn
 Outpt=Nul ' clear display string
 If Weapon2 Or Weapon3 Then ' check either weapon or shield being held
    Outpt="You are holding " ' initialize display string
    If Weapon2 Then ' check weapon being held
       Get 6,Abs(UserRecord.Inv(Weapon6)),TreasureRecord ' get weapon treasure
       Outpt=Outpt+Rtrim$(TreasureRecord.TreasureName) ' record, append name
    Endif ' end check weapon held
 Endif ' end check either being held
 If Weapon3 Then ' check shield being held
    Get 6,Abs(UserRecord.Inv(Weapon5)),TreasureRecord ' shield treasure record
    If Weapon2 Then ' check weapon held again
       Outpt=Outpt+" and "+Rtrim$(TreasureRecord.TreasureName)+"." ' append
       Call IO.O ' both items being held
    Else ' weapon not held
       Outpt="You are holding "+Rtrim$(TreasureRecord.TreasureName)+"."
       Call IO.O ' display only shield being held
    Endif ' end check weapon held
 Else ' end check shield held
    If Weapon2 Then ' check weapon held, not shield
       Outpt=Outpt+"." ' append period
       Call IO.O ' display only weapon held
    Endif ' end check weapon, shield
 Endif ' end check shield held
End Sub ' end routine to display player characteristics

 Rem * routine to display player character alignment and health statistics.

Sub Display.Health
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Call Show.Align ' routine to display alignment
 Call Show.Health ' routine to display health statistics
End Sub ' end routine to display alignment/health

 Rem * routine to display health statistics, and weapon, shield, armor plus.

Sub Show.Health
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 ' health statistics line one contains vitals in form:
 ' Vitals: 10/10(+10) Fat  10/10 Vit  10/10 Mag  10/10 Psi
 If Weapon1 Or Weapon3 Then ' check armor, shield
    ' add pluses to message
    Weapon.Plus$="(+"+Mid$(Str$(Weapon1+Weapon3),2)+")"
 Else ' neither armor, shield
    Weapon.Plus$=Nul ' clear plusses message
 Endif ' end check armor, shield
 Outpt="Vitals:" ' initialize health one line
 ' append current fatigue and maximum fatigue
 Outpt=Outpt+Str$(UserRecord.Fatigue)+"/"+Mid$(Str$(UserRecord.FatigueMax),2)
 Outpt=Outpt+Weapon.Plus$ ' append plusses message
 Outpt=Outpt+" Fat " ' append fatigue abbreviation
 ' append current vitality and maximum vitality
 Outpt=Outpt+Str$(UserRecord.Vitality)+"/"+Mid$(Str$(UserRecord.VitalityMax),2)
 Outpt=Outpt+" Vit " ' append vitality abbreviation
 ' append current magic points and maximum magic points
 Outpt=Outpt+Str$(UserRecord.Magic)+"/"+Mid$(Str$(UserRecord.MagicMax),2)
 Outpt=Outpt+" Mag " ' append magic points abbreviation
 ' append current psionic points and maximum psionic points
 Outpt=Outpt+Str$(UserRecord.Psionic)+"/"+Mid$(Str$(UserRecord.PsionicMax),2)
 Outpt=Outpt+" Psi" ' append psionic points abbreviation
 Call IO.O ' display vitals message line
 ' health statistics line two contains vitals in form:
 ' Stats: Str 10(+10) Int 10 Wis 10 Dex 10 Con 10 Pie 10 Cha 10
 Outpt="Stats: " ' initialize vitals message
 For Array.Index=1 To 7 ' loop through all health statistics
    ' append first three letters of statistics name and player statistic value
    Outpt=Outpt+Left$(Stat(Array.Index),3)+Str$(UserRecord.Stats(Array.Index))
    If Array.Index=1 Then ' check strength selected
       If Weapon2 Then ' verify weapon being held
          Outpt=Outpt+"(+"+Mid$(Str$(Weapon2),2)+")" ' append weapon plus
       Endif ' end check weapon
    Endif ' end check strength
    Outpt=Outpt+" " ' append one space
 Next ' end loop through health statistics
 Call IO.O ' display vitals message line
 ' health statistics line three contains vitals in form:
 ' Weapons: Blunt> 0% Pole> 0% Sharp> 10% Thrusting> 0%
 Outpt="Weapons: " ' initialize vitals message
 For Weapon.Number=1 To 4 ' loop through all weapon classes
    ' append weapon class name
    Outpt=Outpt+Rtrim$(Weapon.Type.Name(Weapon.Number))+">"
    ' append player weapon class percentage value
    Outpt=Outpt+Str$(UserRecord.Weapons(Weapon.Number))+"% "
 Next ' loop through weapon classes
 Call IO.O ' display vitals message line
 ' display lady statistics
 If UserRecord.ClassType=Lady Then ' compare user class type to lady
    ' make message for lady statistics
    Outpt="Lady stats: Beauty:"+Str$(UserRecord.Beauty) ' append beauty value
    Outpt=Outpt+" Glamour:"+Str$(UserRecord.Glamour) ' append glamour value
    Call IO.O ' send lady statistics message
 Endif ' end compare user class type
End Sub ' end routine to display health statistics

 Rem * routine to display player character alignment.

Sub Show.Align
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 If UserRecord.Level<=False Then ' check user level
    Outpt="You are dead!" ' make user level message
    Call IO.O ' send output message
    Exit Sub ' exit routine
 Endif ' end check user level
 Outpt="You are a level"+Str$(UserRecord.Level) ' make user level message
 If UserRecord.Race<=False Then ' check valid user race
    UserRecord.Race=1 ' reset user race
 Endif ' end check valid user race
 Outpt=Outpt+" "+Rtrim$(Race(UserRecord.Race))+" " ' append user race name
 Inpt=UserRecord.ClassName ' store user class name
 Call Decrypt(Inpt) ' decrypt class name
 Outpt=Outpt+Inpt ' append classname
 Call IO.O ' send user type message
 Outpt="You are aligned " ' make aligned message
 ' append player alignment type name 1 through 3 (-1,0,1 plus 2) number 1
 Outpt=Outpt+Rtrim$(Alignment.Name1(UserRecord.Align1+2))+" "
 ' append player alignment type name 1 through 3 (-1,0,1 plus 2) number 2
 Outpt=Outpt+Rtrim$(Alignment.Name2(UserRecord.Align2+2))+"."
 Call IO.O ' send player alignment message
End Sub ' end routine to display player character alignment

 Rem * DM routine to display status of system memory.

Sub Display.Memory
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 ' make message with far memory
 Outpt="Free Dynamic Data and Array Space(Heap in Bytes):"+Str$(Fre(-1))+"."
 Call IO.O ' display message
 ' make message with near memory
 Outpt="Free Data Segment and String Space(Bytes):"+Str$(Fre(Segment$))+"."
 Call IO.O ' display message
 ' make message with stack memory
 Outpt="Free Stack Space(Bytes):"+Str$(Fre(-2))+"."
 Call IO.O ' display message
 Outpt="Total Available Memory(K):" ' make message with combined memory
 ' divide into kilobytes
 Total.KiloBytes=Int((Fre(Segment$)+Fre(-1)+Fre(-2))/1024)
 Outpt=Outpt+Str$(Total.KiloBytes)+"." ' append total KB memory value
 Call IO.O ' send message
End Sub ' end DM routine to display system memory

 Rem * routine to display extended information on an object, treasure,
 Rem * monster, or container using the identify command.

Sub Identify.Object
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' check non DM status
    If UserRecord.Level<=4 Then ' check player level
       Outpt="You are not high enough level!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check level
 Endif ' end check DM status
 Call Display.Information ' routine to display information on an item
End Sub ' end identify routine

 Rem * routine containing status line commands. status line toggle,
 Rem * initializing, clearing, and updating.
 Rem * input variables:
 Rem *   Status.Display -
 Rem *       -2 clear both status lines (rows 24, 25),
 Rem *       -1 toggle status line displaying remote user statistics, or
 Rem *          interactive console function key list,
 Rem *        0 update remote user status line statistics,
 Rem *        1 initialize both status lines.
 Rem * processing variables:
 Rem *   CursorX - temporary variable containing the cursor row position.
 Rem *   CursorY - temporary variable containing the cursor column position.
 Rem *   Statusline.Mode - static variable saved between calls containing the
 Rem *      toggle mode of the status line.
 Rem * notes on routine:
 Rem *   since the status line can be toggled while an online user is
 Rem *   entering input, the color of the screen is restored upon exit
 Rem *   from the routine. i.e. the status line toggles during any
 Rem *   character of i/o.

Sub Status.Line(Status.Display)
 On Local Error Resume Next ' local error resume
 Static Statusline.Mode ' status line toggle (variable saved between calls)
 If Status.Display=-1 Then ' compare to toggle command
    If Local.Mode Then ' compare local console logged in
       Exit Sub ' exit routine w/o toggling status line
    Endif ' end compare local mode
    Statusline.Mode=Not Statusline.Mode ' toggle status line
 Endif ' end compare toggle command
 If Status.Display=-2 Then ' compare to clear status line command
    For FunctionKeys=1 To 10 ' loop through all ten function keys
       Key FunctionKeys,Nul ' reset/disable function key
    Next ' end loop through function keys
    CursorX=Csrlin ' store current cursor row
    CursorY=Pos(0) ' store current cursor column
    Color 7,0 ' set color white on black non-intensity
    Locate 25,1 ' locate at bottom status line
    Print Space$(79); ' clear status line w/ blanks
    Locate 24,1 ' locate at second to bottom status line
    Print Space$(79); ' clear status line w/ blanks
    Locate CursorX,CursorY,1 ' relocate at stored cursor row, column
    Call Restore.Color ' subroutine to restore screen color
    Exit Sub ' exit routine
 Endif ' end compare clear status line command
 If Status.Display>0 Then ' compare to initialize status line command
    Statusline.Mode=False ' set the default status line mode
    If Local.Mode Then ' check console logged in
       If Normal.User=False Then ' verify user logged in is not DM/Sysop
          Statusline.Mode=True ' reset the default status line mode
       Endif ' end verify DM/Sysop
    Endif ' end check local mode
    Call Door.Status.Line ' initialize the door information status line
 Endif ' end compare initialize status line command
 If Statusline.Mode=False Then ' compare status line mode
    Call Make.Status.Line ' routine to update status line w/ player stats
 Else ' status line mode
    If Status.Display<>0 Then ' any status line command than update
       Call Sysop.Status.Line ' routine for sysop function key status line
    Endif ' end compare status line command
 Endif ' end compare status line command
End Sub ' end status line commands routine

 Rem * routine to make status line containing player character statistics.
 Rem * processing variables:
 Rem *   CursorX - contains the current cursor row.
 Rem *   CursorY - contains the current cursor column.

Sub Make.Status.Line
 On Local Error Resume Next ' local error resume
 Status$=UserRecord.CodeName ' store player codename
 Call Decrypt(Status$) ' decrypt codename
 Status$=Lcase$(Status$) ' set codename lowercase
 If Left$(Status$,9)=Deleted$ Then ' check codename is invalid/deleted
    Exit Sub ' exit routine
 Endif ' end check codename
 Mid$(Status$,1,1)=Ucase$(Mid$(Status$,1,1)) ' uppercase first codename letter
 If UserRecord.ClassType=MagicUser Then ' compare player class type to MU
    Status2$="MU" ' set status line player class name to MU abbreviation
 Else ' compare to non MU
    ' set status line player class name to left part of entire class name
    Status2$=Left$(Class.Name(UserRecord.ClassType),8)
 Endif ' end compare MU
 If Dungeon.Master.Assistant Then ' compare player class name to Asst. DM
    Status2$="ADM" ' set status line to Asst. DM abbreviation
 Endif ' end compare ADM
 If Dungeon.Master Then ' compare player class name to DM
    Status2$="DM" ' set status line to DM abbreviation
 Endif ' end compare DM
 If Sysop Then ' compare player to sysop
    Status2$="SYS" ' set status line to sysop abbreviation
 Endif ' end compare sysop
 Status$=Status$+" "+Status2$ ' combine player codename with class name
 Status$=Left$(Status$,39) ' truncate to left half
 Status$=Status$+Space$(39-Len(Status$)) ' append trailing blanks
 Status.Value=UserRecord.Fatigue ' store current player fatigue
 If Status.Value<False Then ' check validity of fatigue
    Status.Value=False ' reset to zero
 Endif ' end check validity
 Status$=Status$+" Fat:"+Mid$(Str$(Status.Value),2) ' append fatigue message
 Status.Value=UserRecord.Vitality ' store current player vitality
 If Status.Value<False Then ' check validity of vitality
    Status.Value=False ' reset to zero
 Endif ' end check validity
 Status$=Status$+" Vit:"+Mid$(Str$(Status.Value),2) ' append vitality message
 Status.Value=UserRecord.Magic ' store current player magic points
 If Status.Value<False Then ' check magic points validity
    Status.Value=False ' reset to zero
 Endif ' end check validity
 ' append magic points message
 Status$=Status$+" Mag:"+Mid$(Str$(Status.Value),2)
 Status.Value=UserRecord.Psionic ' store current player psionic points
 If Status.Value<False Then ' check psionic points validity
    Status.Value=False ' reset to zero
 Endif ' end check validity
 ' append psionic points message
 Status$=Status$+" Psi:"+Mid$(Str$(Status.Value),2)
 Status.Value=UserRecord.Level ' store player level
 If Status.Value<False Then ' compare level validity
    Status.Value=False ' reset to zero
 Endif ' end compare validity
 Status2$=" Lvl:"+Mid$(Str$(Status.Value),2) ' append level message
 ' verify string appended to status line
 If Len(Status$)+Len(Status2$)<=79 Then
    ' string is less than screen line length, and append
    Status$=Status$+Status2$
 Endif ' end verify status line length
 Status.Value=Room ' store current room number
 If Status.Value<False Then ' check validity of room number
    Status.Value=False ' reset to zero
 Endif ' end check validity
 Status2$=" Rm:"+Mid$(Str$(Status.Value),2) ' append room message
 ' verify string appended to status line
 If Len(Status$)+Len(Status2$)<=79 Then
    ' string is less than screen line length, and append
    Status$=Status$+Status2$
 Endif ' end verify status line length
 Status$=Left$(Status$,79) ' truncate status string length
 Status$=Status$+Space$(79-Len(Status$)) ' append blanks to status string
 CursorX=Csrlin ' store current cursor row
 CursorY=Pos(0) ' store current cursor column
 Locate 25,1 ' position cursor at row 25
 Color 14,1 ' color hi-intensity yellow on blue
 Print Status$; ' display the combined status string
 Locate CursorX,CursorY,1 ' restore cursor position
 Call Restore.Color ' routine to restore screen color
End Sub ' end routine to make and display status line

 Rem * routine to initialize the console function keys, initialize the
 Rem * DM/sysop status line with the function key names.
 Rem * processing variables:
 Rem *   CursorX, CursorY - contain the current cursor position.

Sub Sysop.Status.Line
 On Local Error Resume Next ' local error resume
 For FunctionKeys=1 To 10 ' loop through all ten function keys
    Key FunctionKeys,Nul ' clear the function key
 Next ' loop through keys
 If Local.Mode Then ' check console logged in
    If Normal.User=False Then ' check user is DM/sysop
       Key 1,"!EDIT"+Chr$(13) ' assign key 1
       Key 2,"!STA"+Chr$(13) ' assign key 2
       Key 3,"!DIS " ' assign key 3
       Key 4,"!REDU " ' assign key 4
       Key 5,"!CALL" ' assign key 5
       Key 6,"!KILL " ' assign key 6
       Key 7,"!TELE " ' assign key 7
       Key 8,"!INV"+Chr$(13) ' assign key 8
       Key 9,"!GET " ' assign key 9
       Key 10,"!LINK"+Chr$(13) ' assign key 10
    Endif ' end check DM
 Endif ' end check local mode
 CursorX=Csrlin ' store cursor row
 CursorY=Pos(0) ' store cursor column
 Color 14,1 ' set color to hi-intensity yellow on blue
 For FunctionKeys=1 To 10 ' loop through the ten function key numbers
    ' position the cursor at the function key column
    Locate 25,FunctionKeys*8-7
    ' display the function key and number
    Print "F"+Right$(Str$(FunctionKeys+10),1);
 Next ' end loop through function key numbers
 Color 15,1 ' set color to hi-intensity white on blue
 ' store function key names
 FunctionKeys$="EDITSTA DIS REDUCALLKILLTELEINV GET LINK"
 For FunctionKeys=1 To 10 ' loop through ten function key names
    ' position the cursor at the status function key name
    Locate 25,FunctionKeys*8-5
    ' make the function key name with DM prefix from the function string
    Status$="!"+Mid$(FunctionKeys$,(FunctionKeys-1)*4+1,4)
    If FunctionKeys<10 Then ' check for last key
       Status$=Status$+" " ' append space
    Endif ' end check last key
    Print Status$; ' display the function key name
 Next ' end loop through function key names
 Locate CursorX,CursorY,1 ' restore cursor position
 Call Restore.Color ' routine to restore screen color
End Sub ' end routine to initialize function keys and DM status line

 Rem * routine to display door information on the 24th status line.
 Rem * processing variables:
 Rem *   CursorX, CursorY - contains the cursor position.

Sub Door.Status.Line
 On Local Error Resume Next ' local error resume
 CursorX=Csrlin ' store cursor row
 CursorY=Pos(0) ' store cursor column
 Color 14,1 ' color hi-intensity yellow on blue
 Locate 24,1 ' position cursor
 Status2$=Left$(BBS.Name,19) ' get BBS name, truncate
 Status2$=Status2$+Space$(19-Len(Status2$)) ' append blanks
 Status3$=Left$(Door.Name,30) ' get name of user, truncate
 Status3$=Status3$+Space$(30-Len(Status3$)) ' append blanks
 Status4$=" Time on: "+Time.On ' get time user logged in
 Status$="BBS: "+Status2$+" Name: "+Status3$+Status4$ ' combine all strings
 Status$=Left$(Status$,79) ' truncate line to left
 Status$=Status$+Space$(79-Len(Status$)) ' append blanks to right
 Print Status$; ' display door information status line
 Locate CursorX,CursorY,1 ' restore cursor position
 Call Restore.Color ' restore screen color
End Sub ' end routine to display 24th line

 Rem * routine to restore current ansi color after status line is displayed.
 Rem * input variables:
 Rem *   Color.Code - contains current color in cycling.

Sub Restore.Color
 On Local Error Resume Next ' local error resume
 If Graphics.Off Then ' check color cycling
    Call Convert.Color(37) ' restore color to white
 Else ' color check
    Call Convert.Color(Color.Code) ' restore color
 Endif ' end check color cycling on
End Sub ' end routine to restore color

 Rem * routine to display current time, user's time on, and user's time left.
 Rem * input variables:
 Rem *   Time.On - containing the user time on in system time format hh:mm:ss.
 Rem *   Time.Left - containing the user's time limit in seconds from login.
 Rem * processing variables:
 Rem *   OnTime# - contains serial number format of time calculations.
 Rem *   Hours - contains hours since login.
 Rem *   Minutes - contains minutes since login.
 Rem *   Seconds - contains seconds since login.

Sub Time.Online 
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Outpt="It is now "+FNclock$+"." ' make display message
 Call IO.O ' send output message
 OnTime#=TimeValue#(Time$)-TimeValue#(Time.On) ' calculate time online
 If OnTime#<False Then ' check past midnight
    OnTime#=OnTime#+TimeValue#("12:00:00")*2 ' add 24 hours (86,400 seconds)
 Endif ' end check past midnight
 Outpt="You have been on for" ' format time display message
 Time.DIsplay$=Nul ' time display message
 Gosub Time.Display ' subroutine to display message
 Hours=Int(Time.Left/3600!) ' calculate hours of time limit
 Time.Calc=Time.Left-Hours*3600! ' calculate time minus hours
 Minutes=Int(Time.Calc/60!) ' calculate minutes of time limit
 Seconds=Time.Calc-Minutes*60! ' calculate seconds of time limit
 OnTime#=TimeSerial#(Hours,Minutes,Seconds)-OnTime# ' calculate time remaining
 Outpt="You have" ' format time display message
 Time.DIsplay$=" remaining" ' time display message
 Gosub Time.Display ' subroutine to display message
 Exit Sub ' exit routine

 ' subroutine to display time message
Time.Display:
 If Hour&(OnTime#)>0 Then ' compare hours of serial time variable
    Outpt=Outpt+Str$(Hour&(OnTime#))+" hours," ' append hours to string
 Endif ' end compare hours
 If Minute&(OnTime#)>0 Then ' compare minutes of serial time variable
    Outpt=Outpt+Str$(Minute&(OnTime#))+" minutes," ' append minutes to string
 Endif ' end compare minutes
 If Second&(OnTime#)>0 Then ' compare seconds of serial time variable
    Outpt=Outpt+Str$(Second&(OnTime#))+" seconds," ' append seconds to string
 Endif ' end compare seconds
 Outpt=Left$(Outpt,Len(Outpt)-1) ' trim trailing comma
 Outpt=Outpt+Time.DIsplay$+"." ' combine message
 Call IO.O ' send output message
 Return ' exit time display subroutine
End Sub ' end routine to display time on

 Rem * routine to display list of weapons for sale, the first 15 items in the
 Rem * treasure file.

Sub Weapon.List
 On Local Error Resume Next ' local error resume
 Outpt="The Blacksmith says: Here's a list of my inventory." ' message
 Call IO.O ' send output message
 Graphics.Off=True ' reset color
 Outpt="To purchase, type 'buy #', for example: Buy 12." ' make message
 Call IO.O ' send output message
 Call IO.O ' send blank line
 Outpt="###  Weapon.                 Wgt.    Plus." ' make message
 Outpt=Outpt+"            Gold." ' make message
 Call IO.O ' send output message
 Allow.Break=True ' allow control-k breaking
 Break=False ' reset control-k flag
 For List.Count=1 To 15 ' loop through the first 15 treasure items
    Get 6,List.Count,TreasureRecord ' get the next treasure record
    Item.Weight=TreasureRecord.Weight ' store the treasure item weight
    Gold.Value#=TreasureRecord.Gold ' store the treasure item gold value
    ' store the treasure name
    WeaponList.Output$=Left$(TreasureRecord.TreasureName,20)
    ' set first character uppercase
    Mid$(WeaponList.Output$,1,1)=Ucase$(Mid$(WeaponList.Output$,1,1))
    Weapon.Plus=False ' reset plus
    If TreasureRecord.Spell Then ' compare item to spell
       Get 9,TreasureRecord.Spell,SpellRecord ' get the spell record of item
       Weapon.Plus=SpellRecord.Level ' store spell level of item
    Else ' end compare spell item
       If TreasureRecord.Plus Then ' compare treasure item plus
          Weapon.Plus=Abs(TreasureRecord.Plus) ' store item plus
       Endif ' end compare treasure item plus
    Endif ' end compare item spell plus
    ' combine the treasure weight, gold value, and name with blanks imbedded
    Outpt=Mid$(Str$(List.Count),2) ' append item value
    Outpt=Outpt+Space$(6-Len(Str$(List.Count))) ' pad blanks
    Outpt=Outpt+WeaponList.Output$ ' append item value
    Outpt=Outpt+Space$(8-Len(Str$(Item.Weight))) ' pad blanks
    Outpt=Outpt+Str$(Item.Weight) ' append item value
    Outpt=Outpt+Space$(8-Len(Str$(Weapon.Plus))) ' pad blanks
    Outpt=Outpt+Str$(Weapon.Plus) ' append item value
    Outpt=Outpt+Space$(18-Len(Str$(Gold.Value#))) ' pad blanks
    Outpt=Outpt+Str$(Gold.Value#) ' append item value
    Call IO.O ' send message output
    If Break Then ' check break
       Exit For ' exit treasure file loop
    Endif ' end compare break
 Next ' end treasure file item display loop
 Allow.Break=False ' reset control-k breaking
 If Break Then ' check control-k flag
    Break=False ' reset control-k flag
    Outpt=Nul ' set output to null
    Call IO.O ' send empty return
 Endif ' end check control-k flag
End Sub ' end routine to list treasure items for sale

 Rem * routine to allow user to change password.

Sub Change.PassWord
 On Local Error Resume Next ' local error resume
 Graphics.Off=True ' reset color
 Outpt="Change your password(y/n)? " ' input prompt
 No.Input.Out="N" ' default input
 Call IO.I ' get user input
 If Yes Then ' compare input
    Outpt="Type in old password for verification:" ' input prompt
    Line.Length=20 ' line length for password
    Hide=True ' echo mask characters
    Call IO.I ' get user input
    Hide=False ' reset echo mask flag
    Inpt=Ltrim$(Inpt) ' trim entry password
    Inpt=Rtrim$(Inpt) ' trim entry password
    Inpt=Ucase$(Inpt) ' set entry password to uppercase
    Outpt=UserRecord.PassWord ' get user's current password
    Call Decrypt(Outpt) ' decrypt user password
    If Outpt=Nul Then ' verify password validity
       Outpt="This password has a checksum error!" ' make error message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end compare password validity
    Outpt=Rtrim$(Outpt) ' trim password
    If Outpt<>Inpt Then ' compare entered password to user password
       Outpt="Passwords don't match!" ' make error message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end compare passwords
    Outpt="Type in new password(20 char. max.)" ' format input message
    Call IO.O ' send output message
    Line.Length=20 ' set line length of new password
    Outpt="?" ' set input prompt
    Hide=True ' set echo mask character flag
    Call IO.I ' get user input
    Hide=False ' reset echo mask flag
    If No.Input Then ' check length of input
       Outpt="Password not changed." ' make error message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end compare length of input
    Inpt=Ltrim$(Inpt) ' trim new password
    Inpt=Rtrim$(Inpt) ' trim new password
    Inpt=Ucase$(Inpt) ' convert to uppercase
    Call Valid(Inpt,20) ' check validity of new password
    If Inpt=Nul Then ' compare validity of new password
       Outpt="Illegal characters in password!" ' make error message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end compare password validity
    Call Encrypt(Inpt,False) ' encrypt new password
    UserRecord.PassWord=Inpt ' store new password in user record
    Outpt="Password changed." ' make message
    Call IO.O ' send output message
    Exit Sub ' exit routine
 Endif ' end compare input
 Outpt="Password not changed." ' make message
 Call IO.O ' send output message
End Sub ' end routine to change password

 Rem * routine to change alignment once per player character.

Sub Align
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' compare to non DM
    If UserRecord.Flags And Alignmented Then ' compare user record flag
       Outpt="You've already changed alignment once!" ' message
       Call IO.O ' send output
       Exit Sub ' exit routine
    Endif ' end compare user record flag
 Endif ' end compare normal user
 Outpt="Change alignment(y/n)? " ' input prompt
 No.Input.Out="Y" ' default input
 Call IO.I ' get user input
 If Yes Then ' compare yes entered
    UserRecord.Flags=UserRecord.Flags Or Alignmented ' set user record flag
    Call Modify.Alignment ' routine to change alignment
    Outpt="Alignment is now " ' message with new alignment
    Outpt=Outpt+Rtrim$(Alignment.Name1(UserRecord.Align1+2))+" " ' message
    Outpt=Outpt+Rtrim$(Alignment.Name2(UserRecord.Align2+2)) ' message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare input
 Outpt="Alignment not changed!" ' make output message
 Call IO.O ' send output message
End Sub ' end routine to change alignment

 Rem * routine to allow user to change all statistics once per character.

Sub Reroll.Character
 On Local Error Resume Next ' local error resume
 If Normal.User Then ' compare to non DM
    If UserRecord.Flags And Rerolled Then ' check user record flag
       Outpt="You've already rerolled your character!" ' message
       Call IO.O ' send output
       Exit Sub ' exit routine
    Endif ' end compare user flag
 Endif ' end compare normal user
 Outpt="Reroll character(y/n)? " ' prompt user to reroll
 No.Input.Out="Y" ' set default input
 Call IO.I ' get user input
 If Yes Then ' compare yes entered
    UserRecord.Flags=UserRecord.Flags Or Rerolled ' set user record flag
    Do ' loop until changes completed
       Outpt="Character reroll:" ' message
       Call IO.O ' send output
       Outpt="Change class type/name(y/n)? " ' input prompt
       No.Input.Out="Y" ' set default input
       Call IO.I ' get user input
       If Yes Then ' compare yes entered
          Call Modify.Class ' routine to modify class type
       Endif ' end compare yes entered
       Outpt="Character reroll:" ' message
       Call IO.O ' send output
       Outpt="Change vital statistics(y/n)? " ' input prompt
       No.Input.Out="Y" ' set default input
       Call IO.I ' get user input
       If Yes Then ' compare yes entered
          Call Modify.Stats ' routine to modify statistics
       Endif ' end compare yes entered
       Outpt="Character reroll:" ' message
       Call IO.O ' send output
       Outpt="Change character race type/name(y/n)? " ' input prompt
       No.Input.Out="Y" ' set default input
       Call IO.I ' get user input
       If Yes Then ' compare yes entered
          Call Modify.Race ' routine to modify race
       Endif ' end compare yes entered
       Outpt="Character reroll:" ' message
       Call IO.O ' send output
       Outpt="Change weapon proficiency(y/n)? " ' input prompt
       No.Input.Out="Y" ' set default input
       Call IO.I ' get user input
       If Yes Then ' compare yes entered
          Call Modify.Proficiency ' routine to modify weapon proficiency
       Endif ' end compare yes entered
       Outpt="Character reroll:" ' message
       Call IO.O ' send output
       Outpt="Change character alignment(y/n)? " ' input prompt
       No.Input.Out="Y" ' set default input
       Call IO.I ' get user input
       If Yes Then ' compare yes entered
          Call Modify.Alignment ' routine to modify alignment
       Endif ' end compare yes entered
       Do ' loop until changes finished prompt
          Outpt="All changes finished(y/n)? " ' input prompt
          No.Input.Out="Y" ' set default input
          Call IO.I ' get user input
          If Yes Then ' compare yes entered
             Exit Sub ' exit routine
          Endif ' end compare
          If No Then ' compare no entered
             Exit Do ' exit changes loop
          Endif ' end compare
       Loop ' loop until yes or no entered
    Loop ' end loop until changes completed
    Exit Sub ' exit routine
 Endif ' end compare yes entered
 Outpt="Your character has not been rerolled!" ' make output message
 Call IO.O ' send output message
End Sub ' end routine to modify all statistics

 Rem * routine returns a prefix for monster name.
 Rem * output variables:
 Rem *   Prefix1 - monster name prefix.

Sub The.Or.An
 On Local Error Resume Next ' local error resume
 If MonsterArray(Monster.Number).Permanent<True Then ' check for nonplayer
    Prefix1="the " ' make prefix
 Else ' check monster type
    Prefix$=MonsterArray(Monster.Number).MonsterName ' get monster name
    Prefix$=Left$(Prefix$,1) ' get first letter of monster name
    If Instr("aeiou",Prefix$) Then ' check monster name vowel
       Prefix1="an " ' set prefix
    Else ' check vowel
       Prefix1="a " ' set prefix
    Endif ' end check monster name vowel
 Endif ' end check nonplayer
End Sub ' end routine to get monster name prefix

 Rem * routine for parsing numeric value from parameter.
 Rem * input variables:
 Rem *   Parsed.Command1 - string with imbedded pound sign to check.
 Rem * output variables:
 Rem *   Parse.Number - value of number after pound sign.
 Rem * work variables:
 Rem *   Delimit - position of # sign.

Sub Numeric
 On Local Error Resume Next ' local error resume
 Parse.Number=False ' reset numeric value
 Parse.Delimit=Instr(Parsed.Command1,"#") ' search parameter for # sign
 If Parse.Delimit Then ' check # sign in string
    ' store numeric value after #
    Parse.Number=Int(Val(Mid$(Parsed.Command1,Parse.Delimit+1)))
    ' trim # from string
    Parsed.Command1=Left$(Parsed.Command1,Parse.Delimit-1)
 Endif ' end check for # sign in string
End Sub ' end routine to parse part of parameter

 Rem * routine decrements parameter # value after calls to search routines.
 Rem * input variables:
 Rem *   Parse.Count - counter for search routines.
 Rem * output variables:
 Rem *   Parse.Number - decremented # sign value counter.

Sub Num
 On Local Error Resume Next ' local error resume
 If Parse.Number>False Then ' check counter
    ' decrement search routine value from counter
    Parse.Number=Parse.Number-Parse.Count
    If Parse.Number<False Then ' check counter
       Parse.Number=False ' reset counter
    Endif ' end check counter
 Endif ' end check counter
End Sub ' end routine to decrement # sign value counter

 Rem * routine to separate two parameters after command input.
 Rem * input variables:
 Rem *   Parsed.Command2 - first/second parameters combined.
 Rem * output variables:
 Rem *   Parsed.Command1 - first parsed parameter.
 Rem *   Parsed.Command2 - second parsed parameter.
 Rem * work variables:
 Rem *   Delimit - position of # sign.

Sub Parse
 On Local Error Resume Next ' local error resume
 ' find imbedded space in command parameter
 Parse.Delimit=Instr(Parsed.Command2," ")
 Parser=False ' reset position of space
 If Parse.Delimit Then ' check imbedded space
    ' store first parameter
    Parsed.Command1=Left$(Parsed.Command2,Parse.Delimit-1)
    ' store second parameter
    Parsed.Command2=Mid$(Parsed.Command2,Parse.Delimit+1)
    Parser=Parse.Delimit ' store parsed space position
 Endif ' end check for space
End Sub ' end routine to separate parameters

 Rem * routine to separate two parameters after command input in reverse order.
 Rem * input variables:
 Rem *   Parsed.Command2 - first/second parameters combined.
 Rem * output variables:
 Rem *   Parsed.Command1 - second parsed parameter.
 Rem *   Parsed.Command2 - first parsed parameter.
 Rem * work variables:
 Rem *   Delimit - position of # sign.

Sub ParseX
 On Local Error Resume Next ' local error resume
 ' find imbedded space in command parameter
 Parse.Delimit=Instr(Parsed.Command2," ")
 Parser=False ' reset position of space
 If Parse.Delimit Then ' check imbedded space
    ' store second parameter
    Parsed.Command1=Mid$(Parsed.Command2,Parse.Delimit+1)
    ' store first parameter
    Parsed.Command2=Left$(Parsed.Command2,Parse.Delimit-1)
    Parser=Parse.Delimit ' storeparsed space position
 Endif ' end check for space
End Sub ' end routine to separate parameters in reverse order

 Rem * routine computes gold player needs for next training level.
 Rem * output variables:
 Rem *   Gold.Required# - gold points.

Sub Gold(Gold.Required#)
 On Local Error Resume Next ' local error resume
 If UserRecord.Level<=10 Then ' check player level
    Gold.Required#=2^(UserRecord.Level+5) ' calculate gold
 Else ' player level over ten
    Gold.Required#=2^15+(UserRecord.Level-10)*10000! ' calculate gold
 Endif ' end check player level
End Sub ' end routine to calculate gold

 Rem * routine computes experience player needs for next training level.
 Rem * output variables:
 Rem *   Exp.Required# - experience points.

Sub Experience(Exp.Required#)
 On Local Error Resume Next ' local error resume
 If UserRecord.Level<=10 Then ' check player level
    Exp.Required#=2^(UserRecord.Level+6) ' calculate experience
 Else ' player level over ten
    Exp.Required#=2^16+(UserRecord.Level-10)*10000! ' calculate experience
 Endif ' end check player level
End Sub ' end routine to calculate experience

 Rem * routine returns range of numbers.
 Rem * input variables:
 Rem *   Upper.Range - contains upper range.
 Rem * output variables:
 Rem *   Start.Range - start of range.
 Rem *   End.Range - end of range.

Sub Get.Range(Upper.Range,Start.Range,End.Range)
 On Local Error Resume Next ' local error resume
 Range.Type$=Mid$(Str$(Upper.Range),2) ' convert upper range to string
 Outpt="From(1-"+Range.Type$+")? " ' make input prompt
 No.Input.Out="1" ' default input
 Call IO.I ' get input
 Start.Range=Int(Val(Inpt)) ' convert input to integer
 If Start.Range<1 Then ' check bounds of input
    Start.Range=1 ' reset input
 Endif ' end check bounds
 If Start.Range>Upper.Range Then ' check bounds of input
    Start.Range=Upper.Range ' reset input
 Endif ' end check bounds
 Outpt="To("+Mid$(Str$(Start.Range),2)+"-"+Range.Type$+")? " ' input prompt
 No.Input.Out=Range.Type$ ' default input
 Call IO.I ' get input
 End.Range=Int(Val(Inpt)) ' convert input to integer
 If End.Range<Start.Range Then ' check bounds
    End.Range=Start.Range ' reset input
 Endif ' end check bounds
 If End.Range>Upper.Range Then ' check bounds
    End.Range=Upper.Range ' reset input
 Endif ' end check bounds
End Sub ' end routine to get range of numbers

 Rem * routine returns range of numbers.
 Rem * input variables:
 Rem *   Start.Range - starting of range.
 Rem *   End.Range - end of range.
 Rem * output variables:
 Rem *   Upper.Range - contains upper range.

Sub Get.Range2(Start.Range,End.Range,Upper.Range)
 On Local Error Resume Next ' local error resume
 Start.Range$=Mid$(Str$(Start.Range),2) ' convert starting range to string
 End.Range$=Mid$(Str$(End.Range),2) ' convert upper range to string
 Outpt=Outpt+"("+Start.Range$+"-"+End.Range$+")? " ' make input prompt
 No.Input.Out=Start.Range$ ' default input
 Call IO.I ' get input
 Upper.Range=Int(Val(Inpt)) ' convert input to integer
 If Upper.Range<Start.Range Then ' check bounds of input
    Upper.Range=Start.Range ' reset input
 Endif ' end check bounds
 If Upper.Range>End.Range Then ' check bounds of input
    Upper.Range=End.Range ' reset input
 Endif ' end check bounds
End Sub ' end routine to get range of numbers

 Rem * routine returns the charges of an item of treasure.
 Rem * output variables:
 Rem *   Charges.Amount - stores treasure type charges.

Sub TreasureCharges(Charges.Amount)
 On Local Error Resume Next ' local error resume
 Charges.Amount=TreasureRecord.Charges ' store treasure charges
 If TreasureRecord.FuelType Then ' compare treasure to fuel
    Charges.Amount=TreasureRecord.FuelCharges ' reset treasure charges
 Endif ' end compare fuel charges
 If TreasureRecord.LightType Then ' compare vehicle to light
    Charges.Amount=False ' reset treasure charges
 Endif ' compare charges
 If TreasureRecord.Vehicle Then ' compare treasure to vehicle
    Charges.Amount=TreasureRecord.VehicleHits ' reset treasure charges
 Endif ' compare charges
End Sub ' end routine to return charges

 Rem * routine to wish for points or an item, or get an object or treasure.
 Rem * input variables:
 Rem *   Drop.Type - false to use normal drop routine, true for extended drop.

Sub Drop(Drop.Type)
 On Local Error Resume Next ' local error resume
 Wish.Points=1 ' store points number to wish for
 If Right$(Inpt,7)=" points" Then ' compare wish for two points
    Inpt=Left$(Inpt,Len(Inpt)-7) ' truncate wish parameter
    Wish.Points=2 ' store points number to wish for
 Endif ' end compare points wish
 For Stat.Number=1 To 7 ' loop through statistic names
    Outpts=Stat(Stat.Number) ' get statistic name
    Outpts=Rtrim$(Outpts) ' trim name
    Outpts=Lcase$(Outpts) ' lowercase name
    If Inpt=Outpts Then ' compare wish item to statistic name
       If Normal.User Then ' check non DM
          ' check point already wished for
          If (UserRecord.Flags And 2^Stat.Number) Then
             Goto Wish.Denied ' jump to wish denied subroutine
          Endif ' end check point wished for
       Endif ' end check normal player
       ' add player wish bitflag
       UserRecord.Flags=(UserRecord.Flags Or 2^Stat.Number)
       Wish.Points=Wish.Points*Int(Rnd*3+1) ' calculate points to add
       ' calculate new statistic
       New.Stat#=UserRecord.Stats(Stat.Number)+Wish.Points
       If New.Stat#>MaxInt Then ' compare maximum integer
          New.Stat#=MaxInt ' reset to maximum integer
       Endif ' end check maximum integer
       New.Stat=Cint(New.Stat#) ' store in integer
       If Normal.User Then ' check non DM
          If New.Stat>MaxStat Then ' check maximum statistic allowed
             Goto Wish.Denied ' jump to wish denied subroutine
          Endif ' end check maximum stat
       Endif ' end check normal player
       UserRecord.Stats(Stat.Number)=New.Stat ' increment point wished for
       Graphics.Off=True ' reset color
       Outpt="The Ghods Thunder..." ' make ghod message
       Call IO.O ' send message
       Outpt="   Your "+Outpts+" Has Been Raised!" ' make stat message
       Call IO.O ' send update stat message
       Graphics.Off=False ' reset color
       Exit Sub ' exit routine
    Endif ' end compare point wish
 Next ' end loop through statistic names
 If Drop.Type=False Then ' check drop type
    If Normal.User Then ' check normal player
       If UserRecord.Flags And Wished Then ' check player has already wished
          Goto Wish.Denied ' jump to wish denied subroutine
       Endif ' end check already wished
    Endif ' end check normal user
 Endif ' end check drop type
 UserRecord.Flags=UserRecord.Flags Or Wished ' set player wish bitflag
 Parse.Value=False ' item counter
 Wish.Charges=False ' item charges
 Wish.Index=False ' item index
 ' loop through treasure file
 For Treasure.Number=1 To Lof(6)/Len(TreasureRecord)
    Get 6,Treasure.Number,TreasureRecord ' get next record
    Outpts=TreasureRecord.TreasureName ' store treasure name
    Outpts=Left$(Outpts,Len(Inpt)) ' truncate name
    If Inpt=Outpts Then ' compare treasure name to wish item name
       Parse.Value=Parse.Value+1 ' increment item counter
       ' compare counters
       If Parse.Number=False Or Parse.Value=Parse.Number Then
          Wish.Index=Treasure.Number ' store treasure file number
          Call TreasureCharges(Wish.Charges) ' routine to get treasure charges
          Exit For ' exit loop through treasure file
       Endif ' end compare counters
    Endif ' end compare names
 Next ' end loop through treasure file
 If Wish.Index=False Then ' check no treasure match found
    If Normal.User=False Or Drop.Type Then ' compare DM/Sysop or drop type
       ' loop through object file
       For Object.Number=1 To Lof(4)/Len(ObjectRecord)
          Get 4,Object.Number,ObjectRecord ' get object record
          Outpts=ObjectRecord.ObjectName ' store object name
          Outpts=Left$(Outpts,Len(Inpt)) ' truncate object name
          If Inpt=Outpts Then ' compare object name to wish name
             Parse.Value=Parse.Value+1 ' increment counter
             ' compare counters
             If Parse.Number=False Or Parse.Value=Parse.Number Then
                ' store negation of object file index
                Wish.Index=-Object.Number
                Wish.Charges=False ' clear charges
                Exit For ' exit loop through object file
             Endif ' end compare counters
          Endif ' end compare names
       Next ' end loop through object file
    Endif ' end compare drop type/DM, Sysop
 Endif ' end check treasure found
 If Drop.Type=False Then ' check drop type
    If Wish.Index>False Then ' check treasure found
       If Normal.User Then ' check normal player/not DM
          If TreasureRecord.Container Then ' check treasure container
             Wish.Index=False ' clear treasure found
          Else ' check treasure
             If TreasureRecord.Vehicle Then ' check treasure vehicle
                Wish.Index=False ' clear treasure found
             Else ' check treasure
                Spell.Number=TreasureRecord.Spell ' get treasure spell
                ' check spell file bounds
                If Spell.Number>False And_
                Spell.Number<=Lof(9)/Len(SPellRecord) Then
                   Get 9,Spell.Number,SpellRecord ' get spell record
                   If SpellRecord.SpellType=4 Then ' check spell type wish
                      Wish.Index=False ' clear treasure found
                   Endif ' end check wish spell
                Endif ' end check spell file bounds
             Endif ' end check treasure
          Endif ' end check treasure
       Endif ' end check normal player
    Endif ' and check treasure found to drop
 Endif ' end check drop type
 Drop.Type=False ' clear drop flag
 Select Case Wish.Index ' selection of item type to drop
 Case Is<False ' check object being dropped
    ' add object to room
    Call Add.Room.Object(Abs(Wish.Index),Wish.Charges,Drop.Type)
 Case Is>False ' check treasure being dropped
    Select Case TreasureRecord.Container ' selection of container dropped
    Case False ' check treasure container
       ' add treasure to room
       Call Add.Room.Treasure(Wish.Index,Wish.Charges,False,Drop.Type)
    Case True ' check container
       ' check container name
       If Rtrim$(RoomRecord.Container.ShortName)=Nul Then
          Drop.Type=True ' set drop flag
          ' store container variables
          ContainerRec.Closed=TreasureRecord.Closed
          ContainerRec.ContainerName=TreasureRecord.TreasureName
          ContainerRec.Locked=TreasureRecord.Locked
          ContainerRec.Keyed=TreasureRecord.Keyed
          ContainerRec.ShortName=TreasureRecord.ShortName
          For Container.Count=1 To 5 ' loop through container contents
             ' clear container contents
             Call Clear.Container(Container.Count,False)
          Next ' end loop through container
          RoomRecord.Container=ContainerRec ' add container record to room
          Call Share.Record(3,Room) ' write room record
       Endif ' end check container
    End Select ' end select container
 End Select ' end select treasure
 If Drop.Type=False Then ' check drop flag
    Goto Wish.Denied ' jump to wish denied subroutine
 Endif ' end check drop flag
 Graphics.Off=True ' reset color
 Outpt="A Dark Cloud Passes Overhead..." ' make ghod message
 Call IO.O ' send message
 Outpt="   Some Treasure Falls From The Sky..." ' make ghod message
 Call IO.O ' send message
 Outpt="The Cloud Disappears..." ' make ghod message
 Call IO.O ' send message
 Graphics.Off=False ' reset color
 Exit Sub ' exit routine

Wish.Denied:
 Graphics.Off=True ' reset color
 Outpt="The Ghods Thunder..." ' make ghod message
 Call IO.O ' send message
 Outpt="   Your Wish Is Denied!" ' make ghod message
 Call IO.O ' send message
 Graphics.Off=False ' reset color
End Sub ' end routine to drop item to ground

 Rem * routine displays spell types.

Sub Spell.Types
 On Local Error Resume Next
 Graphics.Off=True ' reset color
 Outpt="[A]Enchant      [O]Psionic"
 Call IO.O ' send output
 Outpt="[B]Offense      [P]Detect Lock"
 Call IO.O ' send output
 Outpt="[C]Bless        [R]Detect Evil"
 Call IO.O ' send output
 Outpt="[D]Wish         [S]Detect Trap"
 Call IO.O ' send output
 Outpt="[E]Poison       [T]Intoxicate"
 Call IO.O ' send output
 Outpt="[F]Vigor        [U]Set Trap"
 Call IO.O ' send output
 Outpt="[G]Heal         [V]Hide"
 Call IO.O ' send output
 Outpt="[H]Curepoison   [W]Search"
 Call IO.O ' send output
 Outpt="[I]Level Drain  [X]Invisibility"
 Call IO.O ' send output
 Outpt="[J]Teleport     [Y]Identify"
 Call IO.O ' send output
 Outpt="[K]Befuddle     [Z]Enlighten"
 Call IO.O ' send output
 Outpt="[L]Turn Undead  [1]Illuminate"
 Call IO.O ' send output
 Outpt="[M]Pass Door    [2]Psyche"
 Call IO.O ' send output
 Outpt="[N]Conjure      [3]Telepathy"
 Call IO.O ' send output
End Sub
