
 Rem * Filename: dnds3.bas Version: v4.0 r1.0
 Rem * This subprogram contains most of the attack and player death routines.

 Rem $Include: 'dnddoor.inc'

 Rem * routine to attack a monster, or object.
 Rem * input variables:
 Rem *   Parsed.Command1 - contains the attack target.
 Rem *   Room - contains room number user is in.
 Rem * work variables:
 Rem *   Prefix1 - contains prefix to target (he/the/it).
 Rem *   (constants) - command numbers.

Sub Attack.Monster
 On Local Error Resume Next ' local error resume
 Prefix1=Nul ' reset target prefix
 Monster.Number=False ' reset monster target number
 If Room=51 Then ' compare room number
    Outpt="This is a safe haven!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare room number
 Call Check.Room.Objects ' verify target is an object in room
 If Index.Number Then ' compare object index
    If ObjectRecord.JailTrap Then ' check object jails attacker
       Call Jail ' routine to send player to jail room
    Else ' compare check jail object
       Outpt="Nothing happens.." ' make message
       Call IO.O ' send message
    Endif ' end compare jail object
    Exit Sub ' exit routine
 Endif ' end compare object index
 Previous.Command=False ' reset number of previous attack command
 If Intoxicated>False Then ' compare player is drunk
    Outpt="You are too drunk to fight!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare drunk player
 Call Check.Monster ' verify target is monster
 If Monster.Number=False Then ' check monster index
    Outpt="You can't attack that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end compare monster target
 If MonsterArray(Monster.Number).Jail Then ' verify monster jails attacker
    Call Jail ' routine to send player to jail room
    Exit Sub ' exit routine
 Endif ' end verify jail monster
 Call The.Or.An ' routine to get prefix
 Outpts=MonsterArray(Monster.Number).MonsterName ' store monster target name
 Outpts=Rtrim$(Outpts) ' trim monster name
 Outpts=Lcase$(Outpts) ' lowercase monster name
 Select Case Last.Command.Number ' make selection of attack command number
 Case Charm ' charm
    If UserRecord.ClassType=Lady Then ' compare class type of player
       If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check magic monster
       If Int(Rnd*10+4)>UserRecord.Beauty Then ' calculate lady hits
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate hits
       MonsterArray(Monster.Number).Magic=5 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare class type
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Beguile ' beguile
    If UserRecord.ClassType=Lady Then ' compare class type of player
       If Int(Rnd*12+5)>(UserRecord.Beauty+UserRecord.Glamour) Then ' calculate
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate monster death
       Call Monster.Died ' calculated monster died
       Exit Sub ' exit routine
    Endif ' end compare class type
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Circled ' circle
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    ' compute
    Calculate#=(Rnd*5+UserRecord.Level)>MonsterArray(Monster.Number).Level
    If Calculate# Then ' compare circle monster
       Previous.Command=True ' reset previous attack command number
       MonsterArray(Monster.Number).Magic=4 ' update befuddle monster rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare circled monster
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Feint ' feint
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    Calculate#=UserRecord.Stats(4)>(Rnd*5+MonsterArray(Monster.Number).Level/2)
    If Calculate# Then ' compare calculated befuddle
       Previous.Command=Last.Command.Number ' store last command number
       MonsterArray(Monster.Number).Magic=3 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare calculation
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Resist, Parry ' parry, resist
    Previous.Command=Last.Command.Number ' store last command number
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Turn ' turn
    Magic.Spell=12 ' force turn spell cast
 Case Bemuse ' bemuse
    If UserRecord.ClassType=Lady Then ' compare player class type
       If MonsterArray(Monster.Number).LevelDrain Then ' check monster type
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end compare class type
       If Int(Rnd*8+5)>UserRecord.Glamour Then ' calculate lady level drain
          Outpt="Didn't work!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end calculate level drain
       MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
       Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
       Call IO.O ' send message
       If MonsterArray(Monster.Number).Level<=False Then ' check monster level
          Outpt="You killed the "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Monster.Died ' routine for dead monster
          Exit Sub ' exit routine
       Endif ' end compare dead monster
    Endif ' end compare lady class
    Outpt="Your class does not allow that!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Befuddle ' befuddle
    If MonsterArray(Monster.Number).Magic<=True Then ' compare magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare magic monster
    If (UserRecord.Stats(3)+UserRecord.Stats(4))>_
    (Rnd*10+MonsterArray(Monster.Number).Level/2) Then ' calculate befuddle
       Previous.Command=True ' reset previous command number
       MonsterArray(Monster.Number).Magic=6 ' update monster befuddle rounds
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end calculate befuddle
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Lunge, Dodge ' lunge, dodge
    If Weapon5 Then ' verify player holding shield
       Weapon3=False ' reset shield
       Weapon5=False ' reset shield
       Outpt="You return your shield!" ' make message
       Call IO.O ' send message
    Endif ' end verify shield
 Case Beat, Punch ' beat, punch
    If Weapon6 Then ' verify holding weapon
       Weapon2=False ' reset weapon
       Weapon6=False ' reset weapon
       Weapon10=False ' reset weapon
       Outpt="You return your weapon!" ' make message
       Call IO.O ' send message
    Endif ' end verify weapon
 Case Shield, Guard ' shield, guard
    If Weapon3 Then ' verify holding shield
       Previous.Command=True ' reset previous command
       Outpt="It worked!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify shield
    Previous.Command=False ' reset previous command
    Outpt="You are not holding a shield!" ' make error message
    Call IO.O ' send message
    Exit Sub ' exit routine
 End Select ' end select command number
 Select Case Magic.Spell ' select attack of spell number
 Case Poison ' poison spell
    If MonsterArray(Monster.Number).Poison Then ' check monster is poisoned
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end random chance
    ' poison monster rounds
    MonsterArray(Monster.Number).Poison=UserRecord.Level
    Outpt="You poison the "+Outpts+"!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case LevelDrain ' leveldrain spell
    If MonsterArray(Monster.Number).LevelDrain Then ' check monster is undead
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check random chance
    MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
    Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
    Call IO.O ' send message
    If MonsterArray(Monster.Number).Level<=False Then ' check monster level
       Outpt="You killed the "+Outpts+"!" ' make message
       Call IO.O ' send message
       Call Monster.Died ' routine for dead monster
    Endif ' end check monster level
    Exit Sub ' exit routine
 Case Befuddled ' befuddle spell
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
    Endif ' end chance
    MonsterArray(Monster.Number).Magic=4 ' update monster befuddle rounds
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case TurnUndead ' turn undead spell
    ' check monster undead
    If MonsterArray(Monster.Number).LevelDrain=False Then
       Outpt="That's not undead!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check monster
    Calculate#=(Rnd*UserRecord.Level+2)>MonsterArray(Monster.Number).Level
    If Calculate# Then ' calculate cast spell
       Outpt="You damned the "+Outpts+"!" ' make message
       Call IO.O ' send message
       MonsterArray(Monster.Number).Level=MonsterArray(Monster.Number).Level-1
       Outpt="You drain a level from the "+Outpts+"!" ' decrement monster level
       Call IO.O ' send message
       If MonsterArray(Monster.Number).Level<=False Then ' check monster level
          Outpt="You killed the "+Outpts+"!" ' make message
          Call IO.O ' send message
          Call Monster.Died ' routine for dead monster
          Exit Sub ' exit routine
       Endif ' end check monster level
    Endif ' end calculate undead spell
    Outpt="Didn't work!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Case Intoxicate ' intoxicate spell
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Intoxicated=UserRecord.Level ' store intoxicated rounds counter
       Outpt="You just became very drunk!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
    If Rnd>.5 Then ' random chance
       Outpt="Didn't work!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check chance
    MonsterArray(Monster.Number).Magic=3 ' update monster befuddle rounds
    Outpt="It worked!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 End Select ' end selection of magic spell number
 If Magic.Spell=False Then ' compare spell being cast
    If UserRecord.Fatigue<=False Then ' check player fatigue
       UserRecord.Fatigue=False ' reset fatigue
       Outpt="You are too exhausted to fight!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check player fatigue
    ' normal attack can't hit magical monsters, only spells can
    If MonsterArray(Monster.Number).Magic<=True Then ' check magic monster
       Outpt="A magical force prevents your attack!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check magic monster
 Endif ' end compare spell being cast
 ' nonplayers can't be attacked by normal weapons or spells.
 ' check permanent nonplayer
 If MonsterArray(Monster.Number).Permanent<True Then
    Outpt="A mysterious force prevents your attack!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check nonplayer
 ' calculate miss on monster
 Calculate#=(Rnd*10+MonsterArray(Monster.Number).Level/10)>UserRecord.Stats(4)
 If Calculate# Then ' player missed
    If Magic.Spell Then ' check spell being cast
       Outpt="You missed!" ' spell missed message
       Call IO.O ' send output message
       Exit Sub ' exit routine
    Endif ' end check spell being cast
    ' attacking with a weapon
    Calculate#=(Rnd*10)>UserRecord.Stats(1) ' calculate fumble
    If Calculate# Then ' fumbled
       Call Fumble ' routine to drop weapon, shield
    Endif ' end fumble check
    Outpt="You missed the "+Outpts+"!" ' make miss message
    Call IO.O ' send output message
    Exit Sub ' exit routine
 Endif ' end check player missed
 ' calculate attack weapon bonus multiplier
 If Magic.Spell=False Then ' verify attack by weapon, not spell
    Outpt=Nul ' reset output string
    Multiplier=1 ' reset multiplier
    Select Case Weapon2 ' select type of weapon being held
    Case False ' no weapon being held
       Outpt="Punch!" ' punch with fists
    Case Else ' weapon is being held
       Select Case Rnd ' select random chance
       Case Is>.96 ' highest probability
          Outpt="Deathly damage!" ' make damage message
          Multiplier=4 ' set multiplier
       Case Is>.91 ' median probability
          Outpt="Triple damage!" ' make damage message
          Multiplier=3 ' set multiplier
       Case Is>.86 ' lowest probability
          Outpt="Double damage!" ' make damage message
          Multiplier=2 ' set multiplier
       End Select ' end selection of random chance for weapon
    End Select ' end selection of weapon type
 Endif ' end verify weapon attack
 Select Case Last.Command.Number ' selection of attack command number
 Case Killed ' kill
    If Outpt<>Nul Then ' check bonus hit string
       Call IO.O ' send bonus output message
    Endif ' end check bonus flag
 Case Lunge, Dodge ' lunge, dodge
    Multiplier=2 ' store lunge/dodge multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Backstab ' backstab
    If Hidden.Player Then ' verify player hidden for backstab
       Multiplier=Multiplier+1 ' increment hit multiplier
    Else ' player not hidden
       Outpt="The "+Outpts+" sees you!" ' make message
       Call IO.O ' send message
       Multiplier=Multiplier-1 ' decrement multiplier
    Endif ' end verify hidden player
 Case Thrust ' thrust
    Multiplier=Multiplier+1 ' increment hit multiplier for thrust
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Charge ' charge
    Outpt="Argh! You charge towards the "+Outpts+"!" ' make hit message
    Call IO.O ' send hit message
    Multiplier=Multiplier+1 ' increment hit multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Counter ' counter
    Multiplier=Multiplier+1 ' increment multiplier for counter attack
 Case Pummel ' pummel
    Outpt="Your fists fly at the monster!" ' make hit message
    Call IO.O ' send hit message
    Multiplier=2 ' set hit multiplier
 Case Beat, Punch ' beat, punch
    Multiplier=2 ' set hit multiplier
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Bewitch ' bewitch
    Multiplier=Multiplier+1 ' increment hit multiplier for bewitch attack
    Previous.Command=Last.Command.Number ' store last command attack number
 Case Bewilder ' bewilder
    Multiplier=Multiplier+1 ' increment hit multiplier for bewilder attack
    Previous.Command=Last.Command.Number ' store last command attack number
 End Select ' end selection of attack command number
 If Magic.Spell=False Then ' verify weapon being used, not spell cast
    If Weapon2 Then ' check player holding weapon
       ' decrement weapon strikes remaining.
       ' store weapon strikes remainig
       Charges.Number=UserRecord.Charges(Weapon6)
       If Charges.Number>False Then ' check weapon strikes remaining
          Charges.Number=Charges.NUmber-1 ' decrement weapon strikes
       Endif ' end check strikes remaining
       ' store weapon strikes in user record
       UserRecord.Charges(Weapon6)=Charges.Number
       If Charges.Number=False Then ' verify weapon strikes
          Get 6,UserRecord.Inv(Weapon6),TreasureRecord ' get weapon record
          Inpt=TreasureRecord.ShortName ' store weapon mnemonic
          Inpt=Rtrim$(Inpt) ' trim mnemonic
          Inpt=Lcase$(Inpt) ' lowercase mnemonic
          Outpt="Your "+Inpt+" breaks in half!" ' make weapon message
          Call IO.O ' send weapon message
          Call Discard.Inventory(Weapon6,False) ' weapon falls to ground
       Endif ' end verify remaining weapon strikes
    Endif ' end check player holding weapon
 Endif ' end verify weapon being used
 Magic.Spell=True ' reset spell cast flag
 Call Hit.Monster ' get actual hits on monster
End Sub ' end routine to attack monster

 Rem * routine to send player to jail room number.

Sub Jail
 On Local Error Resume Next ' local error resume
 Outpt="You were just thrown in jail!" ' make message
 Call IO.O ' send jail message
 Next.Room=124 ' reset player room number
 Call Enter.Room ' send player to jail room
End Sub ' end routine to jail player

 Rem * routine to decrease the number of monsters in the room.

Sub Reduce.Monsters
 On Local Error Resume Next ' local error resume
 Inpt=Parsed.Command1 ' store command parameter
 Inpt=Rtrim$(Inpt) ' trim command parameter
 New.Monsters=Int(Val(Inpt)) ' convert parameter to integer
 ' compare number to reduce
 If New.Monsters>=False And New.Monsters<Number.Monsters Then
    Number.Monsters=New.Monsters ' reduce monsters in room
    Outpt="Number of Monsters reduced to:"+Str$(Number.Monsters)+".."
    Call IO.O ' send monsters reduced message
 Endif ' end compare number to reduce
End Sub ' end routine to decrease monsters in room

 Rem * routine to kill off a monster.

Sub Kill.Monster
 On Local Error Resume Next ' local error resume
 Monster.Number=False ' reset monster number
 Call Check.Monster ' get monster number from command parameter
 If Monster.Number Then ' compare monster name found to kill
    Graphics.Off=True ' reset color
    Outpt="Evil Laughter Sounds From Above..." ' make message
    Call IO.O ' send message
    Outpt="   A Bolt Of Lightning Strikes..." ' make message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="The "+Outpts+" was just struck dead!" ' make monster died message
    Call IO.O ' send monster died message
    Call Monster.Died ' kill monster
    Exit Sub ' exit routine
 Endif ' end compare monster name
 Outpt="You can't kill that!" ' make error message
 Call IO.O ' send error message
End Sub ' end routine to kill monster

 Rem * routine to attack monster.
 Rem * input variables:
 Rem *   Monster.Number - number of monster in array to attack.
 Rem *   Outpts - name of monster being attacked.
 Rem * processing variables:
 Rem *   Calculate# - maximum possible hits on monster.

Sub Hit.Monster
 On Local Error Resume Next ' local error resume
 Hidden.Player=False ' reset hidden player
 If Last.Command.Number=PsiMode Then ' compare attack type
    ' calculate hits on monster for psionic attack
    Calculate#=Cdbl(Int(Rnd*UserRecord.Stats(2)+UserRecord.Stats(3)*_
    (Psi.Attack.Mode+Multiplier)))
 Else ' compare attack type
    ' calculate hits on monster for normal attack
    Calculate#=Cdbl(Int((Rnd*UserRecord.Stats(1)+UserRecord.Level/2)*_
    (Multiplier+(UserRecord.Weapons(UserRecord.Proficiency)/100))+Weapon2))
 Endif ' end compare attack type
 Magic.Spell=False ' reset magic spell being used to attack
 If Calculate#<=False Then ' check hits are zero
    Outpt="You missed!" ' make missed message
    Call IO.O ' send missed message
    Exit Sub ' exit routine
 Endif ' end check hits
 Outpt="You hit the "+Outpts+" for"+Str$(Calculate#)+" hits!" ' hits message
 Call IO.O ' send hits message
 Call Monster.Flees(Ran.Away) ' check if monster flees
 If Ran.Away Then ' compare flee
    Call Monster.Died ' routine for dead monster
    Exit Sub ' exit routine
 Endif ' end compare flee
 ' magical monsters don't attack until hit.
 ' check magical monster attacked
 If MonsterArray(Monster.Number).Magic=True Then
    MonsterArray(Monster.Number).Magic=-2 ' set magical monster to attack also
 Endif ' end check attacking a magical monster
 ' decrement the hits on the monster
 MonsterArray(Monster.Number).Hits=MonsterArray(Monster.Number).Hits-Calculate#
 If MonsterArray(Monster.Number).Hits<=False Then ' check monster still alive
    Outpt="You just killed the "+Outpts+"!" ' make message
    Call IO.O ' send message
    Call Monster.Died ' routine for dead monster
 Endif ' end check live monster
End Sub ' end routine to attack monster
 
 Rem * routine to calculate hits causes monster to run.
 Rem * output variables:
 Rem *   Ran.Away - true if monster flees.
 Rem * input variables:
 Rem *   Outpts - name of monster.

Sub Monster.Flees(Ran.Away)
 On Local Error Resume Next ' local error resume
 Ran.Away=False ' reset return variable
 If MonsterArray(Monster.Number).Magic>=False Then ' nonmagical monster
    If MonsterArray(Monster.Number).Permanent=False Then ' nonpermanent monster
       ' calculate hits on monster
       If MonsterArray(Monster.Number).Hits-Calculate#>False Then
          ' calculate 25% of hits
          If Calculate#>(MonsterArray(Monster.Number).Hits*.75) Then
             Outpt="The "+Outpts+" flees from your attack!" ' make message
             Call IO.O ' send message
             MonsterArray(Monster.Number).Experience=_
             Int(MonsterArray(Monster.Number).Experience/2) ' half experience
             Ran.Away=True ' reset return variable
          Endif ' end calculate hits on monster is 25%
       Endif ' end check if monster has hits remaining after attack
    Endif ' end verify permanent monster
 Endif ' end verify magical monster
End Sub ' end routine to check monster flees

 Rem * routine for dead monster.
 Rem * input variables:
 Rem *   Monster.Number - index of monster to array.
 Rem * processing variables:
 Rem *   Monsters.Killed - total monsters killed by player this session.
 Rem *   Choice - index of monster file.
 Rem *   Weapon2, Weapon10 - proficiency calculations.

Sub Monster.Died
 On Local Error Resume Next ' local error resume
 ' check permanent nonplayer
 If MonsterArray(Monster.Number).Permanent<True Then
    Call Remove.Monster ' nonplayer only leaves room
    Exit Sub ' exit routine
 Endif ' end check nonplayer
 Graphics.Off=True ' reset color
 Last.Command.Number=False ' reset last attack command number
 Outpt="On it you find " ' format message prefix
 Carriage.Return=True ' disable cr/lf
 Call IO.O ' send message prefix
 Number.Items=False ' number of items
 ' loop through monster array for all treasure to leave on ground
 For Treasure.Index=1 To 5 ' loop through monster inventory
    ' get next inventory
    Treasure.Number=MonsterArray(Monster.Number).Treasure(Treasure.Index)
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
       Get 6,Treasure.Number,TreasureRecord ' get the treasure record
       Call TreasureCharges(Charges.Amount) ' routine to get treasure charges
       ' add inventory to ground
       Call Add.Room.Treasure(Treasure.Number,Charges.Amount,False,Item.Added)
       If Item.Added Then ' compare return variable to add to room
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send message of previous treasure name
          ' format treasure name
          Outpt=Rtrim$(TreasureRecord.TreasureName)+", "
          Number.Items=Number.Items+1 ' increment number of items
       Endif ' end compare reutnr variable
    Endif ' end compare file bounds
 Next ' end loop through monster inventory
 If Number.Items=False Then ' compare number of items
    Outpt="nothing.." ' format message
 Else ' compare items
    Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' strip comma, add period
    If Number.Items>1 Then ' compare more than one item
       Outpt="and "+Outpt ' append to message
    Endif ' end compare number of items
 Endif ' end compare number of items
 Call IO.O ' send last part of message
 Call Share.Record(3,Room) ' write the room record
 Monsters.Killed=Monsters.Killed+1 ' increment player monsters killed session
 ' increment player record
 UserRecord.MonstersKilled=UserRecord.MonstersKilled+1
 Choice=MonsterIndex(Monster.Number) ' store monster record number
 If MonsterArray(Monster.Number).Permanent=True Then ' check permanent monster
    Get 5,Choice,MonsterRecord ' get permanent monster record
    MonsterRecord.Permanent=False ' clear permanent monster flag
    Call Share.Record(5,Choice) ' put permanent monster record
 Endif ' end check permanent monster
 If Weapon2 And Weapon10 Then ' check player is holding a weapon
    ' calculate difference between player and monster level
    Level=MonsterArray(Monster.Number).Level-UserRecord.Level
    If Level>False Then ' check level is positive
       ' store player weapon proficiency number
       Proficient.Weapon=UserRecord.Proficiency
       ' check player is holding a weapon in his weapon proficiency
       If Weapon10=Proficient.Weapon Then
          Level=Level*10 ' compute proficiency for kill
       Else ' compare weapon proficiency for weapon held
          Level=Level*5 ' compute proficiency for kill
       Endif ' end compare weapon proficiency held
       If Level>100 Then ' check calculated proficiency over 100 percent
          Level=100 ' reset to 100 percent
       Endif ' end check maximum proficiency percent
       ' compare to current
       If Level>UserRecord.Weapons(Proficient.Weapon) Then
          ' proficiency, store new percent
          UserRecord.Weapons(Proficient.Weapon)=Level
          Outpt="Your "+Weapon.Type.Name(Proficient.Weapon)+_
          " weapon proficiency is now"+Str$(Level)+" percent!" ' make message
          Call IO.O ' send weapon message
       Endif ' end check maximum percent
    Endif ' end check attack level
 Endif ' end check player holding weapon
 Exp.Points#=MonsterArray(Monster.Number).Experience ' store monster experience
 Gold.Points#=MonsterArray(Monster.Number).Gold ' store monster gold
 If Gold.Points#<=False Then ' compare monster gold
    Gold.Points#=10 ' set to minimum
 Endif ' end compare monster gold
 Outpt="You gained"+Str$(Exp.Points#)+" experience points" ' make message
 If Gold.Points#>False Then ' compare gold
    Outpt=Outpt+" and"+Str$(Gold.Points#)+" gold" ' append gold message
 Endif ' end compare gold
 Outpt=Outpt+"!" ' append message
 Call IO.O ' send experience and gold message
 UserRecord.Gold=UserRecord.Gold+Gold.Points# ' increment player gold
 ' increment player experience
 UserRecord.Experience=UserRecord.Experience+Exp.Points#
 Call Remove.Monster ' take monster out of active monster array
 If UserRecord.Level>False Then ' verify player level
    ' calculate experience needed to reach next level
    Call Experience(Exp.Required#)
    If UserRecord.Experience>=Exp.Required# Then ' compare player experience
       Call Gold(Gold.Required#) ' routine calculates gold needed for level
       If UserRecord.Gold>=Gold.Required# Then ' compare to player gold
          Call Train.Stats ' routine to train for next level
       Endif ' end check player gold required
    Endif ' end check player experience required
 Endif ' end check player level
End Sub ' end monster death routine

 Rem * routine to remove a monster from the monster arrays.
 Rem * input variables:
 Rem *   Monster.Number - number of monster to remove.
 Rem * output variables:
 Rem *   Number.Monsters - number of monster currently in room.

Sub Remove.Monster
 On Local Error Resume Next ' local error resume
 ' loop through monster array from monster to remove
 For Array.Index=Monster.Number To 19 ' pack array
    ' move next array element
    MonsterIndex(Array.Index)=MonsterIndex(Array.Index+1)
    ' move next array element
    MonsterArray(Array.Index)=MonsterArray(Array.Index+1)
 Next ' end loop through all monsters in arrays
 Number.Monsters=Number.Monsters-1 ' decrement number of monsters in room
 If Number.Monsters<False Then ' compare number of monsters in room
    Number.Monsters=False ' reset numberof monsters to zero
 Endif ' end compare number of monsters
End Sub ' end routine to remove a monster

 Rem * routine for monsters to attack player.

Sub Monster.Attack
 On Local Error Resume Next ' local error resume
 Monster.Cycle=Monster.Cycle+1 ' increment attack counter
 If Monster.Cycle>=Room.Monster.Rate Then ' compare attack counter to
    Monster.Cycle=False ' room monster attack rate counter, reset to zero
 Endif ' end compare rate counters
 If Number.Monsters=False Then ' check monsters in room
    Exit Sub ' exit routine if no monsters
 Endif ' end check monsters in room
 If Room=51 Then ' check player in safe room
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 For Monster.Number=1 To Number.Monsters ' loop through all monsters in room
    ' get monster befuddle rounds
    Inactive.Rounds=MonsterArray(Monster.Number).Magic
    If Inactive.Rounds>=False Then ' compare number of befuddle rounds
       If UserRecord.Stats(6)<=1 Then ' check player piety
          Inactive.Rounds=False ' monsters attack on sight for low piety
       Endif ' end check player piety
       ' compare inactive befuddle rounds for monster
       If Inactive.Rounds>False Then
          Inactive.Rounds=Inactive.Rounds-1 ' decrement befuddle rounds
       Endif ' end compare monster befuddle rounds
       ' store monster befuddle rounds
       MonsterArray(Monster.Number).Magic=Inactive.Rounds
    Endif ' end compare number of monster befuddle rounds
    If Inactive.Rounds<True Then ' check if magical monster is attacking
       ' reset befuddle rounds remaining for monster to zero
       Inactive.Rounds=False
    Endif ' end check magical monster is attacking
    ' routine for monster hit regeneration
    If MonsterArray(Monster.Number).Magic<=True Then ' check magical monster
       If MonsterArray(Monster.Number).Level>=15 Then ' check monster level
          If Monster.Cycle=False Then ' compare room monster update rate
             Calculate#=MonsterArray(Monster.Number).Hits ' store monster hits
             ' regenrate hits by ten percent
             Calculate#=Cdbl(Int(Calculate#+Calculate#*.1))
             ' store new monster hits
             MonsterArray(Monster.Number).Hits=Calculate#
          Endif ' end compare room monster update rate
       Endif ' end check monster level
    Endif ' end check magical monster
    ' continue with monster attack if player is not hidden,
    ' and monster is not befuddled.
    ' continue with monster attack
    If Hidden.Player=False And Inactive.Rounds=False Then
       Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
       Outpts=Rtrim$(Outpts) ' trim monster name
       Outpts=Lcase$(Outpts) ' lowercase monster name
       ' compute monster attack multiplier is monster level plus one
       Multiplier=MonsterArray(Monster.Number).Level+1 ' compute multiplier
       If MonsterArray(Monster.Number).Poison Then ' check monster is poisonous
          ' compute random chance of monster poison percent
          If Rnd<(MonsterArray(Monster.Number).PoisonPercent/100) Then
             Outpt="The "+Outpts+" casts a poison spell!" ' make message
             Call IO.O ' send poison message
             ' check player is wearing antipoison ring
             If Weapon8=1 Then ' check for ring
                Ring.Charges=UserRecord.Charges(Weapon7) ' store ring strikes
                ' decrement strikes
                Ring.Charges=Ring.Charges-MonsterArray(Monster.Number).Level
                If Ring.Charges<False Then ' compare strikes remaining
                   Ring.Charges=False ' store zero strikes
                Endif ' end compare strikes
                ' store strikes in record
                UserRecord.Charges(Weapon7)=Ring.Charges
                Outpt="Your ring absorbs the poison spell!" ' make message
                Call IO.O ' send ring protection message
                If Ring.Charges=False Then ' compare ring charges remaining
                   Outpt="Your ring disintegrated!" ' make message
                   Call IO.O ' send ring message
                   Call Discard.Inventory(Weapon7,True) ' ring falls to ground
                Endif ' end compare ring charges
             Else ' check for ring
                UserRecord.Poison=True ' reset user poisoned flag
                Outpt="You've been poisoned!" ' make message
                Call IO.O ' send poisoned message
             Endif ' end compare ring
          Endif ' end compute monster poisons
       Endif ' end compare monster is poisonous
       ' check monster is undead
       If MonsterArray(Monster.Number).LevelDrain Then
          ' compute random chance vs. undead monster leveldrain percent
          If Rnd<(MonsterArray(Monster.Number).DrainPercent/100) Then ' compute
             Outpt="The "+Outpts+" casts a level drain spell!" ' message
             Call IO.O ' send level drain message
             ' check player is wearing anti level drain ring
             If Weapon8=2 Then ' check for ring
                Ring.Charges=UserRecord.Charges(Weapon7) ' store ring strikes
                ' decrement ring charges
                Ring.Charges=Ring.Charges-MonsterArray(Monster.Number).Level
                If Ring.Charges<False Then ' compare strikes
                   Ring.Charges=False ' reset ring strikes
                Endif ' end compare strikes
                ' store srikes in record
                UserRecord.Charges(Weapon7)=Ring.Charges
                Outpt="Your ring absorbs the level drain!" ' make message
                Call IO.O ' send ring message
                If Ring.Charges=False Then ' check ring charges
                   Outpt="Your ring disintegrated!" ' make message
                   Call IO.O ' send ring charges message
                   Call Discard.Inventory(Weapon7,True) ' ring falls to ground
                Endif ' end check remaining ring charges
             Else ' check player wearing ring
                UserRecord.Level=UserRecord.Level-1 ' decrement player level
                Call New.Stats ' get updated statistics
                Outpt="You've been drained a level!" ' make message
                Call IO.O ' send leveldrain message
                If UserRecord.Level<=False Then ' compare player level to dead
                   UserRecord.Level=1 ' reset player level
                   Call The.Or.An ' get monster prefix
                   ' store message for death routine
                   Message1="You were just killed by "+Prefix1+" "+Outpts+"!"
                   Call Player.Died ' routine for dead player
                   Exit For ' exit monster attack loop
                Endif ' end compare player level
             Endif ' end check player has ring
          Endif ' end compute random chance
       Endif ' end check monster is undead
       Magic.Spell=False ' reset magic spell being cast
       ' get monster spell cast number
       Spell.Number=MonsterArray(Monster.Number).Spell
       ' file bounds
       If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
          Get 9,Spell.Number,SpellRecord ' get spell record
          Magic.Spell=SpellRecord.SpellType ' store monster spell cast type
          Multiplier=Int(MonsterArray(Monster.Number).Level) ' calculate spell
          Multiplier=Multiplier+Int(SpellRecord.Level/2+.5) ' attack multiplier
          If Magic.Spell=Offense Then ' compare spell type to offense attack
             ' compute random chance to monster spell percent
             If Rnd<(MonsterArray(Monster.Number).SpellPercent/100) Then
                ' make message of spell monster casts
                Outpt="The "+Outpts+" casts a "+_
                Rtrim$(SpellRecord.SpellName)+" spell!" ' message
                Call IO.O ' send cast message
                ' check player is wearing antispell ring
                If Weapon8=3 Then ' check ring
                   ' check ring is generic antispell or the spell cast
                   If Weapon9=True Or Weapon9=Spell.Number Then ' check ring
                      ' store ring strikes
                      Ring.Charges=UserRecord.Charges(Weapon7)
                      ' subtract spell level
                      Ring.Charges=Ring.Charges-SpellRecord.Level
                      If Ring.Charges<False Then ' compare strikes
                         Ring.Charges=False ' reset strikes
                      Endif ' end compare strikes
                      UserRecord.Charges(Weapon7)=Ring.Charges ' store strikes
                      Outpt="Your ring absorbs the spell!" ' make message
                      Call IO.O ' send ring message
                      ' check remaining ring charges
                      If Ring.Charges=False Then ' compare
                         Outpt="Your ring disintegrated!" ' make message
                         Call IO.O ' send ring message
                         Call Discard.Inventory(Weapon7,True) ' falls to ground
                      Endif ' end compare ring charges
                   Endif ' end ring type
                Endif ' end check ring
             Endif ' end computer random chance
          Endif ' end compare spell attack type
       Endif ' end check spell file bounds
       ' check if monster is poisoned
       If MonsterArray(Monster.Number).Poison>False Then ' check poisoned
          If Monster.Cycle=False Then ' compare rounds counter
             ' decrement monster poisoned rounds counter
             MonsterArray(Monster.Number).Poison=_
             MonsterArray(Monster.Number).Poison-1 ' decrement
             Outpt="Poison drains the "+Outpts+"!" ' make message
             Call IO.O ' send poisoned message
             ' calculate hits on monster from poison.
             ' store monster hits
             Monster.Hits#=MonsterArray(Monster.Number).Hits
             ' store monster level
             Monster.Level#=MonsterArray(Monster.Number).Level
             ' compute poison
             Poison.Hits#=Int(UserRecord.Level*UserRecord.Stats(7))
             ' compute poison
             Monster.Hits#=Int(Monster.Hits#-Poison.Hits#/Monster.Level#)
             ' store monster hits
             MonsterArray(Monster.Number).Hits=Monster.Hits#
             ' check monster hits
             If MonsterArray(Monster.Number).Hits<=False Then
                Outpt="The "+Outpts+" died from poison!" ' make message
                Call IO.O ' send died message
                Call Monster.Died ' routine for dead monster
                Exit For ' exit monster attack routine
             Endif ' end check monster hits
          Endif ' end compare rounds counter
       Endif ' end check monster is poisoned
       ' calculate monster misses
       Calculate#=(UserRecord.Stats(4)/2)>_
       (Rnd*10+MonsterArray(Monster.Number).Level/10) ' calculate miss
       If Calculate# Then ' compare miss equation
          Outpt="The "+Outpts+" fumbled!" ' make message
          Call IO.O ' send missed message
       Else ' compare miss
          If Previous.Command=True Then ' compare previous attack command type
             Multiplier=Multiplier-1 ' decrement monster multiplier
             Previous.Command=False ' reset last attack command type
          Endif ' end compare previous attack command type
          ' compare psionic monster
          If MonsterArray(Monster.Number).Psionic=False Then ' compare
             ' calculate normal hits on player
             Calculate#=Cdbl(Int(Rnd*(MonsterArray(Monster.Number).Hits/10-_
             (Weapon1+Weapon3)/2)*Multiplier))
          Else ' calculate psionic hits on player
             ' calculate psionic hits on player
             Calculate#=Cdbl(Int(Rnd*(MonsterArray(Monster.Number).Hits/10-_
             Psi.Defense.Mode)*MonsterArray(Monster.Number).Psionic))
          Endif ' end compare attack type
          Call The.Or.An ' get prefix of monster name
          Prefix1="The " ' reset prefix
          Call Get.Hits(Calculate#) ' routine to hit player
          If Calculate#=True Then ' return variable for dead player
             Exit For ' exit monster attack loop
          Endif ' end check dead player
       Endif ' end compare monster miss equation
    Endif ' end compare monster befuddle rounds
 Next ' end loop through all monsters in room
End Sub ' end routine for monster attacks

 Rem * routine to hit player.
 Rem * input variables:
 Rem *   Calculate# - actual hits.
 Rem * output variables:
 Rem *   Calculate# - true if player died.

Sub Get.Hits(Calculate#)
 On Local Error Resume Next ' local error resume
 ' selecting the previous attack command player used modifies the actual
 ' hits by the type of attack, and reduces or increases the actual hits
 Select Case Previous.Command ' select the previous attack command
 Case Lunge ' lunge
    Calculate#=Calculate#-UserRecord.Stats(4)/2-UserRecord.Stats(1)/2
 Case Dodge ' dodge
    Calculate#=Calculate#-(UserRecord.Stats(4)+UserRecord.Stats(1))/2
 Case Feint ' feint
    Calculate#=Calculate#-UserRecord.Stats(4)/2-UserRecord.Stats(1)
 Case Parry ' parry
    Calculate#=Calculate#-UserRecord.Stats(4)-UserRecord.Stats(1)
 Case Thrust ' thrust
    Calculate#=Calculate#+UserRecord.Stats(4)/2+UserRecord.Stats(1)
 Case Charge ' charge
    Calculate#=Calculate#+UserRecord.Stats(4)+UserRecord.Stats(1)
 Case Resist ' resist
    Calculate#=Calculate#-UserRecord.Stats(1)/2
 Case Beat ' beat
    Calculate#=Calculate#+UserRecord.Stats(4)/2+UserRecord.Stats(1)/2
 Case Punch ' punch
    Calculate#=Calculate#+(UserRecord.Stats(4)+UserRecord.Stats(1))/2
 Case Bewitch ' bewitch
    Calculate#=Int(Calculate#/2)-UserRecord.Beauty
 Case Bewilder ' bewilder
    Calculate#=Int(Calculate#/2)-UserRecord.Glamour
 End Select ' end selection of previous attack command
 If Calculate#<=False Then ' compare hits on player to miss
    Outpt=Prefix1+Outpts+" missed!" ' make message
    Call IO.O ' send miss message
    Calculate#=False ' return value for live player
    Exit Sub ' exit routine
 Endif ' end compare hits to miss
 If Monster.Number Then ' check monster is attacking
    If Magic.Spell=False Then ' check monster using spell
       Outpt=Prefix1+Outpts+" attacks you" ' make attack message
       ' check monster using psionic
       If MonsterArray(Monster.Number).Psionic Then
          Outpt=Outpt+" with psionics" ' append psionic attack message
       Endif ' end compare monster using psionics
       Outpt=Outpt+"!" ' append exclamation
       Call IO.O ' send attack message
    Endif ' end compare monster using spell
 Endif ' end compare monster attacking
 If UserRecord.Invisible Then ' check player is invisible
    Outpt="Your invisibility protects you!" ' make message
    Call IO.O ' send invisible message
    Calculate#=False ' return value for live player
    Exit Sub ' exit routine
 Endif ' end compare invisible player
 If Vehicle2 Then ' check if player is using a vehicle
    If Rnd>.75 Then ' random chance vehicle is hit
       Get 6,Vehicle3,TreasureRecord ' get vehicle treasure record
       Inpt=TreasureRecord.ShortName ' store vehicle name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt=Prefix1+Outpts+" hits your "+Inpt+" for"+Str$(Calculate#)+" hits!"
       Call IO.O ' send message of hits on vehicle
       Vehicle2=Vehicle2-Calculate# ' decrement vehicle hits
       If Vehicle2<=False Then ' compare remaining vehicle hits
          RoomRecord.Treasure(Vehicle1)=Vehicle3 ' put vehicle in room
          RoomRecord.Treasure(Vehicle1)=False ' reset vehicle hits
          Vehicle2=False ' remove vehicle from player
          Vehicle3=False ' remove vehicle from player
          Outpt=Prefix1+Outpts+" damaged your "+Inpt+"!" ' make message
          Call IO.O ' send vehicle message
       Endif ' end compare vehicle hits
    Endif ' end random chance to hit vehicle
    Calculate#=False ' return value for live player
    Exit Sub ' exit routine
 Endif ' end check player using vehicle
 Outpt=Prefix1+Outpts+" hits you for"
 Call Hit.Player(Calculate#) ' routine to decrement hits on player statistics
 If UserRecord.Vitality=False Then ' check player vitality remaining
    Calculate#=True ' set player died flag
    Exit Sub ' exit routine
 Endif ' end check player died
 Calculate#=False ' return value for live player
 If Weapon3 Then ' check player holding shield
    ' store shield strikes remaining
    Charges.Number=UserRecord.Charges(Weapon5)
    If Charges.Number>False Then ' check shield strikes
       Charges.Number=Charges.Number-1 ' decrement shield strikes
    Endif ' end check shield strikes
    ' store shield strikes in user record
    UserRecord.Charges(Weapon5)=Charges.Number
    If Charges.Number=False Then ' compare shield charges
       ' get shield treasure record
       Get 6,UserRecord.Inv(Weapon5),TreasureRecord
       Inpt=TreasureRecord.ShortName ' store treasure name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt="Your "+Inpt+" breaks in half!" ' make message
       Call IO.O ' send weapon message
       Call Discard.Inventory(Weapon5,False) ' shield falls to ground
    Endif ' end compare remaining shield charges
 Endif ' end check player holding shield
 If Weapon1 Then ' check player is holding a armor
    Charges.Number=UserRecord.Charges(Weapon4) ' store armor strikes remaining
    If Charges.Number>False Then ' compare armor strikes
       Charges.Number=Charges.Number-1 ' decrement armor strikes
    Endif ' end compare armor strikes
    ' store armor strikes in user record
    UserRecord.Charges(Weapon4)=Charges.Number
    If Charges.Number=False Then ' check armor strikes remaining
       ' get treasure armor record
       Get 6,UserRecord.Inv(Weapon4),TreasureRecord
       Inpt=TreasureRecord.ShortName ' store treasure name
       Inpt=Rtrim$(Inpt) ' trim name
       Inpt=Lcase$(Inpt) ' lowercase name
       Outpt="Your "+Inpt+" crumbles!" ' make message
       Call IO.O ' send armor message
       Call Discard.Inventory(Weapon4,False) ' falls to ground
    Endif ' end compare remaining armor charges
 Endif ' end check player holding armor
End Sub ' end routine to get hits on player

 Rem * routine to decrement hits on player from fatigue and vitality.
 Rem * input variables:
 Rem *   Hit.Points - hits to subtract, positive from fatigue,
 Rem *   negative from vitality.

Sub Hit.Player(Hit.Points#)
 On Local Error Resume Next ' local error resume
 If Hit.Points#>False Then ' check decrement from fatigue
    If UserRecord.Fatigue-Hit.Points#>=False Then ' compare the decrement
       ' subtract from fatigue
       UserRecord.Fatigue=UserRecord.Fatigue-Hit.Points#
       Outpt=Outpt+Str$(Hit.Points#)+" fatigue points!" ' make message
       Call IO.O ' send hits message
       Exit Sub ' exit routine
    Endif ' end compare the decrement
    ' get the difference from hits on fatigue
    Hit.Points#=Hit.Points#-UserRecord.Fatigue
    If UserRecord.Fatigue>False Then ' compare hits to fatigue remaining
       Outpt=Outpt+Str$(UserRecord.Fatigue)+" fatigue and" ' make message
    Endif ' end compare fatigue message, remaining difference hits vitlaity
    UserRecord.Fatigue=False ' reset player fatigue to zero
 Endif ' end decrement from fatigue
 Hit.Points#=Abs(Hit.Points#) ' convert hits on vitality to positive integer
 If Hit.Points#>False Then ' compare vitiality hits
    Outpt=Outpt+Str$(Hit.Points#)+" vitality points!" ' make message
    Call IO.O ' send hits message
    If UserRecord.Vitality-Hit.Points#<=False Then ' compare the decrement
       UserRecord.Vitality=False ' reset vitality
       Message1="You were just killed!" ' make died routine message
       Call Player.Died ' routine for dead player
       Exit Sub ' exit routine
    Endif ' end compare vitality decrement
    ' decrement player vitality
    UserRecord.Vitality=UserRecord.Vitality-Hit.Points#
 Endif ' end compare vitality hits
End Sub ' end routine to decrement hits on player

 Rem * routine to fumble weapon and shield from player to ground.

Sub Fumble
 On Local Error Resume Next ' local error resume
 If Weapon2 Or Weapon3 Then ' check if holding weapon or shield
    Outpt="You fumbled! " ' make first message
    Inpt="You dropped your " ' make second part of message
    Graphics.Off=True ' reset color
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send first fumble message
    If Weapon3 Then ' check shield being held
       ' get shield treasure record
       Get 6,UserRecord.Inv(Weapon5),TreasureRecord
       Treasure.Name$=TreasureRecord.ShortName ' get treasure name
       Treasure.Name$=Rtrim$(Treasure.Name$) ' trim name
       Treasure.Name$=Lcase$(Treasure.Name$) ' lowercase name
       Call Discard.Inventory(Weapon5,False) ' falls to ground
       If Weapon2 Then ' check weapon also being held
          Outpt=" and "+Treasure.Name$ ' make next part of message
       Else ' check weapon
          Outpt=Inpt+Treasure.Name$+"!" ' make message for shield only
       Endif ' end check weapon being held
    Endif ' end check shield held
    If Weapon2 Then ' check weapon being held
       ' get weapon treasure record
       Get 6,UserRecord.Inv(Weapon6),TreasureRecord
       Treasure.Name$=TreasureRecord.ShortName ' get treasure name
       Treasure.Name$=Rtrim$(Treasure.Name$) ' trim name
       Treasure.Name$=Lcase$(Treasure.Name$) ' lowercase name
       Outpt=Inpt+Treasure.Name$+Outpt+"!" ' make last part of message
       Call Discard.Inventory(Weapon6,False) ' falls to ground
    Endif ' end check weapon held
    Call IO.O ' send fumble message
    Graphics.Off=False ' reset color
 Endif
End Sub ' end routine to fumble weapon and shield

 Rem * routine to get permanent monster encounters in a room.
 Rem * input variables:
 Rem *   Room - number of room player is currently in.

Sub Encounter.Permanent
 On Local Error Resume Next ' local error resume
 ' loop through all nonplayer records
 For Monster.Index=1 To Lof(2)/Len(MonsterRecord)
    Get 2,Monster.Index,MonsterRecord ' get nonplayer record
    ' store nonplayer room
    Monster.Rooms$=","+Rtrim$(MonsterRecord.PluralName)+","
    Player.Room$=","+Mid$(Str$(Room),2)+"," ' store current room
    ' verify nonplayer in current room
    If Instr(Monster.Rooms$,Player.Room$) Then
       If Number.Monsters<20 Then ' check maximum monsters in room
          Number.Monsters=Number.Monsters+1 ' increment monsters in room
          MonsterIndex(Number.Monsters)=Monster.Index ' store nonplayer index
          MonsterArray(Number.Monsters)=MonsterRecord ' store nonplayer record
          MonsterArray(Number.Monsters).Magic=True ' set magical monster
          MonsterArray(Number.Monsters).Permanent=-2 ' set nonplayer flag
       Endif ' end check maximum monsters
    Endif ' end verify current room
 Next ' end loop through nonplayer records
 If RoomRecord.MonsterClass Then ' check room monster class number
    For Monsters=1 To 10 ' loop through room monsterclass monsters
       ' get monster number
       Choice=Monster.Class(RoomRecord.MonsterClass,Monsters)
       If Choice>False And Choice<=Lof(5)/Len(MonsterRecord) Then ' bounds
          Get 5,Choice,MonsterRecord ' get monster record
          If MonsterRecord.Permanent=True Then ' check if monster permanent
             Number.Appearing=1 ' set number of monsters to appear to one
             Call Get.Monster.Stats ' get the monster
          Endif ' end check permanent monster
       Endif ' end check file bounds
    Next ' end loop through room monsterclass
 Endif ' end check room monster class number
End Sub ' end routine to get permanent monsters

 Rem * routine to get one monster.
 Rem * input variables:
 Rem *   Parsed.Command1 - name or number of monster.
 Rem * working variables:
 Rem *   Choice - is the monster number.

Sub Summon.Monster
 On Local Error Resume Next ' local error resume
 If Room=51 Then ' check player in safe room
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 Choice=False ' reset monster number
 Inpt=Parsed.Command1 ' store command parameter
 Call Parse.Num(Inpt,Parse.Value) ' parse number
 Parse.Count=False ' reset monster found counter
 For Monster.Index=1 To Lof(5)/Len(MonsterRecord) ' loop through monster file
    Get 5,Monster.Index,MonsterRecord ' get monster record
    ' compare monster record name to input monster name,
    ' truncated to input length
    If Left$(MonsterRecord.MonsterName,Len(Inpt))=Inpt Then ' compare
       Parse.Count=Parse.Count+1 ' increment monster found counter
       ' compare parsed number of monster to search for
       If Parse.Value=False Or Parse.Count=Parse.Value Then ' compare
          Exit For ' exit routine
       Endif ' end compare counters
    Endif ' end compare monster names
 Next ' end loop through monster file
 If Parse.Count=False Then ' check monster found
    Monster.Index=Int(Val(Inpt)) ' convert input to integer
    ' file bounds
    If Monster.Index>False And Monster.Index<=Lof(5)/Len(MonsterRecord) Then
       Choice=Monster.Index ' store monster number
    Endif ' end check file bounds
 Else ' check file bounds
    Choice=Monster.Index ' store monster number
 Endif  ' end check file bounds
 If Choice>False Then ' check monster number found
    Call Get.Monster ' get the monster
 Endif ' end check monster number found
End Sub ' end routine to get a monster

 Rem * routine to get a random monster.
 Rem * processing variables:
 Rem *   Choice - is the monster number.

Sub Call.Monster
 On Local Error Resume Next ' local error resume
 If Room=51 Then ' check player in safe room
    Exit Sub ' exit routine for safe room
 Endif ' end check player in safe room
 If RoomRecord.MonsterClass Then ' check room monster class
    If RoomRecord.MonsterClass<=Monclass.Max Then ' check monsterclass bounds
       ' calculate a random monster from the room monsterclass
       Choice=Monster.Class(RoomRecord.MonsterClass,Int(Rnd*10+1)) ' random
       Call Get.Monster ' get the monster
    Endif ' end check monsterclass bounds
 Endif ' end check room monster class
End Sub ' end routine to get a random monster

 Rem * routine to get a random monster from the room monster class, cmoputed
 Rem * from the monster encounter round rate counter, and the monster
 Rem * percentage.
 Rem * input variables:
 Rem *   Room - number of the current room.
 Rem *   Monster.Rate1 - counter of rounds from file.
 Rem *   Monster.Rate2 - counter of rounds for monster rate.

Sub Encounter.Monster
 On Local Error Resume Next ' local error resume
 If Room=51 Then ' check safe room
    Exit Sub ' exit routine
 Endif ' end check safe room
 Monster.Class=RoomRecord.MonsterClass ' store room monster class
 ' check monster class
 If Monster.Class>False And Monster.Class<=Monclass.Max Then
    If Monster.Rate1=MaxInt Then ' check rate counter maximum integer
       Monster.Rate1=1 ' reset rate counter
    Else ' check rate
       Monster.Rate1=Monster.Rate1+1 ' increment rate
    Endif ' end check room monster counter rate
    For Monsters=1 To 10 ' loop through monsters with specified percentages
       If Monster.Rate(Monster.Class,Monsters) Then ' check monster rate
          ' verify monster rate equals room rate
          If Monster.Rate1/Monster.Rate(Monster.Class,Monsters)=_
          Int(Monster.Rate1/Monster.Rate(Monster.Class,Monsters)) Then
             ' verify random monster rate percentage
             If Rnd<(Monster.Percent(Monster.Class,Monsters)/100) Then ' verify
                ' store monster number
                Choice=Monster.Class(Monster.Class,Monsters)
                Call Get.Monster ' get the monster
             Endif ' end verify random rate
          Endif ' end verify monster rate percent
       Endif ' end check monster rate
    Next ' end loop through monster percentages
    Monster.Rate2=Monster.Rate2+1 ' increment monster rate for room
    If Monster.Rate2>=Room.Monster.Rate Then ' check monster rate
       Monster.Rate2=False ' reset monster rate
       Choice=Monster.Class(Monster.Class,Int(Rnd*10+1)) ' get random monster
       If MonsterRecord.Rate=False Then ' verify monster has specific rate
          If Rnd<.5 Then ' random chance for encounter
             Call Get.Monster ' get the monster
          Endif ' end random chance
       Endif ' end verify monster specific rate
    Endif ' end monster rate
 Endif ' end check room has monster class
End Sub ' end routine to random monster from rates and percentages

 Rem * routine to get monsters.
 Rem * input variables:
 Rem *   Choice - the number of the monster record.
 Rem * processing variables:
 Rem *   Number.Appearing - number of monsters to encounter.

Sub Get.Monster
 On Local Error Resume Next ' local error resume
 If Choice>False And Choice<=Lof(5)/Len(MonsterRecord) Then ' file bounds
    Get 5,Choice,MonsterRecord ' get the monster record
    If MonsterRecord.Permanent=False Then ' verify monster not permanent
       ' calculate random number of monsters to encounter
       Number.Appearing=Int(Rnd*MonsterRecord.NumberAppearing)+1 ' calculate
       While Number.Appearing+Number.Monsters>20 ' loop to compare maximum
          Number.Appearing=Number.Appearing-1 ' monsters in room, decrementing
       Wend ' number appearing while room maximum is not exceeded
       Select Case Number.Appearing ' selection of number encountered
       Case 0 ' number appearing is greater than room can hold
          Exit Sub ' exit routine
       Case 1 ' format message for one monster
          ' compare monster name starting with a vowel
          If Instr("aeiou",Left$(MonsterRecord.MonsterName,1)) Then
             Outpt="an " ' format prefix to monster name
          Else ' check vowel
             Outpt="a " ' format prefix to monster name
          Endif ' end compare monster name
          Outpt=" "+Outpt+Rtrim$(MonsterRecord.MonsterName)
       Case Else ' format message for many monsters
          Outpt=Str$(Number.Appearing)+" "+Rtrim$(MonsterRecord.PluralName)
       End Select ' end selection of monsters appearing
       Outpt="You encounter"+Outpt+"!" ' make message
       Call IO.O ' send encounter message
       Call Get.Monster.Stats ' add the monster to the arrays
    Endif ' end verify not permanent
 Endif ' end check file bounds
End Sub ' end routine to get monsters

 Rem * routine to store monster statistics for encountered monster number.
 Rem * input variables:
 Rem *   Choice - is the monster number to the monster file.
 Rem *   Number.Appearing - the number of monsters of type choice to encounter.

Sub Get.Monster.Stats
 On Local Error Resume Next ' local error resume
 If Number.Monsters>=20 Then ' check room is full of monsters
    Exit Sub ' exit routine
 Endif ' end check room full
 For Monsters=1 To Number.Appearing ' loop through all number appearing
    If Number.Monsters<20 Then ' check room full of monsters
       Number.Monsters=Number.Monsters+1 ' increment the number of monsters
       MonsterIndex(Number.Monsters)=Choice ' store the monster record choice
       MonsterArray(Number.Monsters)=MonsterRecord ' store the monster record
       If MonsterArray(Number.Monsters).Psionic Then ' verify psionic monster
          ' get monster psionic spell number
          Spell.Number=MonsterArray(Number.Monsters).PsionicSpell
          MonsterArray(Number.Monsters).Psionic=False ' spell from array and
          If Spell.Number>False And_
          Spell.Number<=Lof(9)/Len(SpellRecord) Then ' reset with
             ' psionic spell number from spell file
             Get 9,Spell.Number,SpellRecord
             If SpellRecord.Psionic Then ' check spell record is psionic
                If SpellRecord.PsionicMode=1 Then ' check psionic is offense
                   ' store the psionic spell level in the monster array
                   MonsterArray(Number.Monsters).Psionic=SpellRecord.Level
                Endif ' end check spell psionic type
             Endif ' end check spell is psionic
          Endif ' end check spell file bounds
       Endif ' end check monster is psionic
       If MonsterArray(Number.Monsters).Permanent=False Then ' check permanent
          For Treasure.Index=1 To 5 ' loop through all monster inventory
             If Rnd>.75 Then ' random chance
                ' clear monster treasure element
                MonsterArray(Number.Monsters).Treasure(Treasure.Index)=False
             Endif ' end random chance
          Next ' end loop through monster inventory
       Endif ' end check nonpermanent monster
    Endif ' end check maximum room monsters
 Next ' end loop through number appearing of monster type choice
 Action.Number=RoomRecord.Action ' store room action number
 ' check file bounds
 If Action.Number>False And Action.Number<=Lof(12)/Len(ActionRecord) Then
    Get 12,Action.Number,ActionRecord ' read action record
    ' check room action to monster choice
    If ActionRecord.MonsterTrigger=Choice Then
       ' check room action not talk activated
       If ActionRecord.MonsterTalk=False Then
          Action1$="As you step forward," ' make action message one
          Action2$="The monster hits you for" ' make action message two
          ' routine to activate actions by specific trigger
          Call Actions(Action1$,Action2$)
       Endif ' end check room action
    Endif ' end check room has monster trigger
 Endif ' end check file bounds
End Sub ' end routine to store encountered monster statistics

 Rem * routine for dead player.

Sub Player.Died
 On Local Error Resume Next ' local error resume
 UserRecord.Poison=False ' reset player poisoned
 Vehicle2=False ' reset vehicle
 Vehicle3=False ' reset vehicle
 Weapon1=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon2=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon3=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon4=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon5=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon6=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon7=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon8=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon9=False ' reset weapons, shield, armor, and rings being held/worn
 Weapon10=False ' reset weapons, shield, armor, and rings being held/worn
 UserRecord.MonstersKilled=False ' reset user score
 If Normal.User=False Then ' check player is Asst. DM or DM or Sysop
    Outpt=Message1 ' copy death message
    Call IO.O ' send death message
    Outpt="You were resurrected!" ' make message
    Call IO.O ' send message
    Next.Room=51 ' reset room number
    Number.Monsters=False ' reset number of monsters in room
    Call Enter.Room ' send player to room one
    Exit Sub ' exit routine
 Endif ' end compare normal user type
 ' rest of death routine for normal users
 Stat.Amount=UserRecord.Stats(5) ' store player constitution
 If Stat.Amount>1 Then ' check constitution positive
    UserRecord.Stats(5)=Stat.Amount-1 ' store decremented player constitution
 Endif ' end check constitution
 Stat.Amount=UserRecord.Stats(6) ' store player piety
 If Stat.Amount>1 Then ' check piety positive
    UserRecord.Stats(6)=Stat.Amount-1 ' store player decremented piety
 Endif ' end check piety
 If Rnd>.5 Then ' random chance for statistic decrement
    Stat.Number=Int(Rnd*4+1) ' choose random statistic to decrement
    Stat.Amount=UserRecord.Stats(Stat.Number) ' store random statistic
    If Stat.Amount>1 Then ' compare to positive value
       ' store player decremented statistic
       UserRecord.Stats(Stat.Number)=Stat.Amount-1
    Endif ' end compare value
 Endif ' end random chance
 Number.Monsters=False ' reset room monsters
 UserRecord.Poison=False ' reset player poisoned flag
 Weight=False ' reset player inventory weight
 For Array.Index=1 To 15 ' loop through player inventory
    Charges.Number=UserRecord.Charges(Array.Index) ' store inventory charges
    Index.Number=UserRecord.Inv(Array.Index) ' store inventory number
    If Index.Number Then ' verify inventory
       ' falls to ground
       Call Add.Room.Treasure(Index.Number,Charges.Number,False,Item.Added)
       If Item.Added=False Then ' return variable for full room
          Exit For ' exit inventory loop
       Endif ' end check return variable
    Endif ' end check inventory
 Next ' end loop through player inventory
 For Array.Index=1 To 15 ' loop through player inventory
    UserRecord.Inv(Array.Index)=False ' set inventory to zero
    UserRecord.Charges(Array.Index)=False ' set inventory to zero
 Next ' end loop through inventory
 Room=51 ' reset player room number
 Next.Room=51 ' reset next room entry number
 Outpt=Message1 ' copy death message
 Call IO.O ' send death message
 ' calculate player constitution roll
 Level=UserRecord.Level ' store user level
 Calculate#=(Int(Rnd*10+10)+UserRecord.Stats(5))>20 ' calculate
 If Calculate#=False Then ' compare constitution roll
    Outpt="Constitution roll failed!" ' make message
    Call IO.O ' send fail message
    Outpt="You were not resurrected!" ' make message
    Call IO.O ' send fail message
    Level=Int(Level/2-.5) ' player loses half levels
 Else ' end compare constitution roll
    ' player survives constitution roll
    Outpt="You were resurrected!" ' make message
    Call IO.O ' send message
    If UserRecord.Stats(6)<=1 Then ' compare piety
       Outpt="Except your piety failed!" ' player loses roll anyway
       Call IO.O ' send fail message
       Level=Int(Level/2-.5) ' player loses half levels
    Else ' compare piety
       Level=Level-1 ' decrement player level by one
    Endif ' end compare piety
 Endif ' end compare constitution roll
 If Level<False Then ' compare level
    Level=False ' reset level
 Endif ' end compare level
 UserRecord.Level=Level ' store user level
 Call Zero.Stats ' routine to clear player statistics
 Call More.Prompt ' pause for next screen
 Call Enter.Room ' routine to move player to room number
End Sub ' end routine for dead player

 Rem * routine to clear player statistics for death.

Sub Zero.Stats
 On Local Error Resume Next ' local error resume
 Call Experience(Calculate#) ' calculate new experience
 Calculate#=Calculate#-Int(Calculate#/10) ' calculate decremented experience
 If Calculate#<UserRecord.Experience Then ' compare new experience
    UserRecord.Experience=Calculate# ' reset experience
 Endif ' end compare new experience
 Call Gold(Calculate#) ' calculate new gold
 Calculate#=Calculate#-Int(Calculate#/10) ' calculate decremented gold
 If Calculate#<UserRecord.Gold Then ' compare new gold
    UserRecord.Gold=Calculate# ' reset player gold
 Endif ' end compare new gold
 Call New.Stats ' get new statistics for level
 UserRecord.Flags=UserRecord.Flags And Not Rerolled ' clear player flags
 UserRecord.Flags=UserRecord.Flags And Not Alignmented ' clear player flags
 For Stats=1 To 7 ' loop through player statistics
    If UserRecord.Stats(Stats)<=False Then ' compare statistcis to zero
       UserRecord.Stats(Stats)=1 ' reset statistic
    Endif ' end compare player statistics
 Next ' end loop through player statistics
 Call Put.User.Record ' store player record
End Sub ' end routine to clear dead player

 Rem * routine for player to learn a spell chant.
 Rem * processing variables:
 Rem *   Learned.Spells - array of 0s and 1s of learned spells.
 Rem * input variables:
 Rem *   Parsed.Command1 - contains name of spell to learn.

Sub Learn.Spell
 On Local Error Resume Next ' local error resume
 Spell.Found=False ' flag for spell name found
 For Spell.Number=1 To Lof(9)/Len(SpellRecord) ' loop through all spells
    Get 9,Spell.Number,SpellRecord ' get next spell record
    ' compare spell name with command parameter
    If Rtrim$(SpellRecord.SpellName)=Lcase$(Parsed.Command1) Then ' compare
       Spell.Found=True ' set spell flag found
       Exit For ' exit spell file loop
    Endif ' end compare spell names
 Next ' end loop through spell file
 If Spell.Found=False Then ' compare spell flag
    Outpt="You can't learn that spell!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end compare spell flag
 Outpt="Enter chant to learn: " ' format input prompt
 Call IO.I ' get input spell chant
 Inpt=Ucase$(Inpt) ' uppercase spell chant input
 If Rtrim$(SpellRecord.Chant)<>Inpt Then ' compare spell chant entered
    Outpt="Wrong spell chant!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end compare spell chants
 ' check length of learned spell flags
 If Spell.Number>Len(Learned.Spells) Then
    ' append 0s to learned spells
    Learned.Spells=Learned.Spells+String$(Spell.Number-Len(Learned.Spells),"0")
 Endif ' end check length of learned spells flags
 Mid$(Learned.Spells,Spell.Number,1)="1" ' set flag for spell learned
 Outpt="You now memorize the spell!" ' make message
 Call IO.O ' send spell message
End Sub ' end routine to learn spell

 Rem * routine for preprocessing spell casting.
 Rem * input variables:
 Rem *   Require.Chant - set to true if entering the spell chant is required.
 Rem * output variables:
 Rem *   Spell.Cast.Type - set to 1=use command, 2=scroll used, 4=cast command.
 Rem *   Spell.Number - number of the spell being used.
 Rem *   Spell.Chant - true if spell being used w/o chant.

Sub Cast.Spell(Require.Chant)
 On Local Error Resume Next ' local error resume
 If Weapon2 Then ' check player is holding a weapon
    Outpt="You must return your weapon first!" ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check weapon held
 Spell.Cast.Type=False ' reset casting variables
 Spell.Number=False ' reset casting variables
 Spell.Chant=False ' reset casting variables
 If Require.Chant Then ' check if chant required
    If UserRecord.Magic=False Then ' verify spell points remaining
       Outpt="You have no more spell points!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify spell points
    Outpt="Chant? " ' format input prompt
    Call IO.I ' get player input
    Inpt=Ucase$(Inpt) ' uppercase input
    Chant.Found=False ' set spell chant found flag
    ' loop through all spell records
    For Spell.Number=1 To Lof(9)/Len(SpellRecord)
       Get 9,Spell.Number,SpellRecord ' get spell record
       Spell.Chant$=SpellRecord.Chant ' store spell chant
       Spell.Chant$=Rtrim$(Spell.Chant$) ' trim chant
       Spell.Chant$=Ucase$(Spell.Chant$) ' uppercase chant
       If Spell.Chant$=Inpt Then ' compare chants
          If SpellRecord.Psionic=False Then ' check for psionic spell
             Chant.Found=True ' set spell chant found flag
             Exit For ' exit spell file loop
          Endif ' end check psionic spell
       Endif ' end compare chants
       Spell.Chant$=SpellRecord.SpellName ' store spell name
       Spell.Chant$=Rtrim$(Spell.Chant$) ' trim name
       Spell.Chant$=Ucase$(Spell.Chant$) ' uppercase name
       If Spell.Chant$=Inpt Then ' compare spell names
          If SpellRecord.Psionic=False Then ' check for psionic spell
             ' check learned spells bounds
             If Spell.Number<=Len(Learned.Spells) Then
                ' check learned flag
                If Mid$(Learned.Spells,Spell.Number,1)="1" Then
                   Chant.Found=True ' set spell chant found flag
                   Exit For ' exit spell file loop
                Endif ' end check learned flag
             Endif ' end check bounds
          Endif ' end check for psionic spell
       Endif ' end compare spell names
    Next ' end loop through spell file
    If Chant.Found=False Then ' check spell chant found flag
       Outpt="Wrong spell chant!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check spell chant flag
    Spell.Cast.Type=Cast.Spell.Type ' store spell type being used
 Else ' compare chant required
    Call Find.Inventory ' check magic device being used
    If Index.Number=False Then ' verify device used
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end verify device
    If TreasureRecord.Potion Then ' check device type
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check device type
    If TreasureRecord.Edible Then ' check device type
       Outpt="You can't use that!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check device
    If TreasureRecord.Scroll Then ' check device type
       Outpt="The scroll disintegrated!" ' make message
       Call IO.O ' send message
       Call Discard.Inventory(Array.Number,True) ' remove item from inventory
       Spell.Cast.Type=Scroll.Spell.Type ' store spell type being used
    Else ' check device type
       If TreasureRecord.Spell=False Then ' check device type spell type
          Outpt="That's not a magical device!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check device/spell type
       If UserRecord.Charges(Array.Number)=False Then ' compare spell charges
          Outpt="You can't, it's empty!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check spell charges
       Charges.Number=UserRecord.Charges(Array.Number) ' store spell charges
       Charges.Number=Charges.Number-1 ' decrement charges
       If Charges.Number<False Then ' compare zero
          Charges.Number=False ' set to zero
       Endif ' end compare zero
       UserRecord.Charges(Array.Number)=Charges.Number ' store spell charges
       Spell.Cast.Type=Use.Spell.Type ' store spell type being used
    Endif ' end compare device type
    Spell.Number=TreasureRecord.Spell ' store spell type
    Spell.Chant=True ' no chant required flag
 Endif ' end compare chant required
 Get 9,Spell.Number,SpellRecord ' get the spell record being used
 Magic.Spell=SpellRecord.SpellType ' store the spell type being used
 Multiplier=SpellRecord.Level ' store the spell level
 Index.Number=False ' reset target variable
 If Parser Then ' check for second command parameter
    Parsed.Command1=Parsed.Command2 ' store second parameter
    Call Numeric ' get pound sign number
    Call Examine.Treasure ' check for treasure target
    If Index.Number=False Then ' treasure target found
       Call Num ' decrement target number
       Call Examine.Objects ' check for object target
       If Index.Number>False Then ' check object target found
          Outpt="Wrong spell target for chant" ' make message
          Call IO.O ' send message
          Exit Sub ' exit sub
       Endif ' end check object target
    Endif ' end check target
 Endif ' end check second parameter
 Call Magic(Spell.Chant) ' routine to use the magic spell
End Sub ' end spell preprocessing routine

 Rem * routine to cast a magic spell.
 Rem * input variables:
 Rem *   Magic.Spell - number of the spell type.
 Rem *   Chant.Used - true if spell being used w/o chant
 Rem *   Spell.Cast.Type - set to 1=use command, 2=scroll used, 4=cast command.
 Rem *   Spell.Number - number of the spell being used.
 Rem *   Index.Number - type of spell target.

Sub Magic(Chant.Used)
 On Local Error Resume Next ' local error resume
 Select Case Index.Number ' selection of the target type
 Case Is>False ' target is an item of treasure
    Select Case Magic.Spell ' selection of spell type for target of treasure
    Case Enchant ' enchant
       If TreasureRecord.Spell=False Then ' check treasure target spell type
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target spell type
    Case Vigor  ' vigor
       If TreasureRecord.Vehicle=False Then ' check treasure target vehicle
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target vehicle type
    Case Else ' check target type
       If Magic.Spell<>Hiding Then ' check spell type on treasure target
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check treasure target type
    End Select ' end selection of target spell type
 Case False ' target is not an item of treasure
    If Parser Then ' check target parameter flag
       Select Case Magic.Spell ' selection of spells w/ targets
       Case Offense, Poison, LevelDrain, Befuddled, TurnUndead, Intoxicate
          Index.Number=False
       Case Else ' spell w/o target
          Outpt="Wrong spell target for chant!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       End Select ' end spell type selection
    Endif ' end check target parameter
 End Select ' end target selection type
 If Chant.Used=False Then ' check spell usage type
    If Multiplier>UserRecord.Level Then ' compare spell level to player level
       Outpt="You are not high enough level to cast the spell!" ' message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check spell/player levels
    If UserRecord.Magic=False Then ' check player magic points remaining
       Outpt="You have no more spell points!" ' make message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check player magic points
    ' verify spell can be cast by player class type
    If (SpellRecord.ClassType And 2^UserRecord.ClassType)=False Then ' verify
       If Normal.User=True Then ' check player is Asst. DM/DM/Sysop
          Outpt="Your class can't cast that spell!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end check player type
    Endif ' end verify spell type
    Charges.Number=UserRecord.Magic ' get player magic points
    ' decrement magic points by spell level
    Charges.Number=Charges.Number-Multiplier
    If Charges.Number<False Then ' check zero
       Charges.Number=False ' set to zero
    Endif ' end compare zero
    UserRecord.Magic=Charges.Number ' store player magic points remaining
 Endif ' end check spell usage type
 ' check spell ingredients.
 ' verify spell type uses ingredients
 If SpellRecord.SpellFlag And Spell.Cast.Type Then
    For Spell.Index=1 To 5 ' loop through spell ingredients
       ' get treasure ingredient number
       Ingredient.Number=SpellRecord.Ingred(Spell.Index)
       If Ingredient.Number>False And_
       Ingredient.Number<=Lof(6)/Len(TreasureRecord) Then ' file bounds
          Player.Ingredient=False ' player has ingredient flag
          For Array.Index=1 To 15 ' loop through player inventory
             ' check player inventory
             If UserRecord.Inv(Array.Index)=Ingredient.Number Then
                Player.Ingredient=True ' set ingredient flag
                Exit For ' exit player inventory loop
             Endif ' end check player inventory is ingredient
          Next ' end loop through player inventory
          ' get treasure ingredient record
          Get 6,Ingredient.Number,TreasureRecord
          If Player.Ingredient=False Then ' check player has ingredient flag
             Outpt="You don't have the correct spell ingredients!" ' message
             Call IO.O ' send message
             Inpt=TreasureRecord.TreasureName ' get treasure name
             Inpt=Rtrim$(Inpt) ' trim name
             Inpt=Lcase$(Inpt) ' lowercase name
             Outpt="You need "+Inpt+"!" ' make message
             Call IO.O ' send ingredient message
             Exit Sub ' exit routine
          Endif ' end check player ingredient flag
          ' check ingredient charges
          If UserRecord.Charges(Array.Index)=False Then
             Inpt=TreasureRecord.ShortName ' get treasure name
             Inpt=Rtrim$(Inpt) ' trim name
             Inpt=Lcase$(Inpt) ' lowercase name
             Outpt="The "+Inpt+" are used up!" ' make message
             Call IO.O ' send ingredient message
             Exit Sub ' exit routine
          Endif ' end check inrgedient charges
          ' decrement player ingredient charges
          UserRecord.Charges(Array.Index)=UserRecord.Charges(Array.Index)-1
       Endif ' end check file bounds
    Next ' end loop through spell ingredients
 Endif ' end verify spell requires ingredients
 Spell.Name$=SpellRecord.SpellName ' get spell name being cast
 Spell.Name$=Rtrim$(Spell.Name$) ' trim name
 Spell.Name$=Lcase$(Spell.Name$) ' lowercase name
 If Instr("aeiou",Left$(Spell.Name$,1)) Then ' check spell vowel
    Spell.Name$=" an "+Spell.Name$ ' append vowel
 Else ' check vowel
    Spell.Name$=" a "+Spell.Name$ ' append vowel
 Endif ' end check vowel spelling
 Outpt=SpellRecord.Desc ' get spell long cast description
 Outpt=Rtrim$(Outpt) ' trim description
 If Outpt=Nul Then ' check description length
    Outpt="You cast"+Spell.Name$+" spell!" ' make default cast description
 Endif ' end check description length
 Call IO.O ' send spell cast message
 Get 3,Room,RoomRecord ' get current room record
 Action.Number=RoomRecord.Action ' get room action number
 ' check file bounds
 If Action.Number>False And Action.Number<=Lof(12)/Len(ActionRecord) Then
    Get 12,Action.Number,ActionRecord ' read action record
    If ActionRecord.SpellTrigger=Spell.Number Then ' check for spell trigger
       Action1$="As the spell is cast," ' action message
       Action2$="You are hit for" ' action message
       Call Actions(Action1$,Action2$) ' routine for activated action
    Endif ' end check room for action triggered
 Endif ' end check file bounds
 ' check for magic traps in room
 For Array.Index=1 To 10 ' loop through room treasure
    If RoomRecord.Flags(Array.Index)=Magic.Trap Then ' check room for trap
       If RoomRecord.Treasure(Array.Index)=True Then ' check trap triggered
          If UserRecord.Stats(2)<Int(Rnd*6+10) Then ' random chance for trap
             ' hits on player for magical trap
             Calculate#=Cdbl(Int(Rnd*10+UserRecord.Level)*_
             RoomRecord.TreCharges(Array.Index))
             RoomRecord.Treasure(Array.Index)=False ' reset room trap
             RoomRecord.TreCharges(Array.Index)=False ' reset room trap
             RoomRecord.Flags(Array.Index)=False ' reset room trap
             Call Share.Record(3,Room) ' write new room record
             Outpt="You triggered a magical trap!" ' message
             Call IO.O ' send trap message
             Outpt="The trap hit you for" ' hits message
             Call Hit.Player(Calculate#) ' routine to hit player
             Exit For ' exit room trap loop
          Endif ' end random chance
       Endif ' end trap trigger
    Endif ' end room trap
 Next ' end loop through room
 ' selections of the actual spell cast subroutines
 Select Case Magic.Spell ' select the spell type number
 Case Offense, Poison, LevelDrain, Befuddled, TurnUndead, Intoxicate
   Call Attack.Monster ' spell cast on monster target
 Case Enchant ' enchant (heal magic points)
    If Index.Number>False Then ' enchant on a target
       Get 9,TreasureRecord.Spell,SpellRecord ' get target spell record
       If SpellRecord.SpellType=4 Then ' compare target to wish device
          Outpt="You can't recharge that!" ' make message
          Call IO.O ' send message
          Exit Sub ' exit routine
       Endif ' end compare wish item
       Calculate#=UserRecord.Charges(Array.Number) ' get charges of item
       Calculate#=Calculate#+UserRecord.Level ' calculate new item charges
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' reduce to maximum integer
       Endif ' end compare maximum integer
       ' compare maximum treasure charges
       If Calculate#>TreasureRecord.Charges Then
          ' reduce to maximum treasure charges
          Calculate#=TreasureRecord.Charges
       Endif ' end compare charges
       UserRecord.Charges(Array.Number)=Cint(Calculate#) ' store new charges
       Outpt="You recharge it!" ' make message
       Call IO.O ' send message
    Else ' compare enchant on a target
       ' calculate player enchant
       Calculate#=UserRecord.Magic+UserRecord.Level+Multiplier ' calculate
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' set to maximum integer
       Endif ' end compare maximum integer
       UserRecord.Magic=Cint(Calculate#) ' store player magic points
       Call New.Stats ' update player statistics
       Outpt="You now have"+Str$(UserRecord.Magic)+" magic points!" ' message
       Call IO.O ' send message
    Endif ' end compare enchant target
 Case Bless ' bless (heal piety)
    Outpt="Nothing happened.." ' default bless message
    If UserRecord.Stats(6)<MaxStat Then ' compare player piety points
       UserRecord.Stats(6)=UserRecord.Stats(6)+1 ' increment player piety
       Outpt="You feel a magical glow about you!" ' message
    Endif ' end compare piety
    Call IO.O ' send piety message
 Case Wish ' wish
    ' compare spell cast type
    If Spell.Cast.Type=Use.Spell.Type Or Spell.Cast.Type=_
    Scroll.Spell.Type Then ' compare
       ' reset player wish flag
       UserRecord.Flags=UserRecord.Flags And Not Wished ' reset
    Endif ' end compare spell cast type
    Graphics.Off=True ' reset color
    Outpt="The Ghods thunder.." ' message
    Call IO.O ' send ghod message
    Outpt="   What do you wish for?" ' format input prompt
    Graphics.Off=False ' reset color
    Call IO.I ' get player input
    Stored.Parsed.Command2=Inpt ' store item wish name
    Parsed.Command1=Stored.Parsed.Command2 ' store item wish name
    Call Numeric ' parse out pound sign
    Inpt=Parsed.Command1 ' store parsed item wish name
    Inpt=Lcase$(Inpt) ' lowercase item
    Call Drop(False) ' routine to get item from treasure file
 Case Vigor ' vigor (heal fatigue)
    If Index.Number>False Then ' check treasure target
       Get 3,Room,RoomRecord ' get current room
       Calculate#=RoomRecord.TreCharges(Array.Number) ' get vehicle hits
       Calculate#=Calculate#+UserRecord.Level*2 ' increment vehicle hits
       If Calculate#>MaxInt Then ' compare maximum integer
          Calculate#=MaxInt ' reset to maximum integer
       Endif ' end compare maximum integer
       Vehicle.Hits=Cint(Calculate#) ' convert to integer
       ' compare maximum vehicle hits
       If Vehicle.Hits>TreasureRecord.VehicleHits Then
          ' reset to maximum vehicle hits
          Vehicle.Hits=TreasureRecord.VehicleHits
       Endif ' end compare vehicle hits
       ' store new vehicle hits
       RoomRecord.TreCharges(Array.Number)=Vehicle.Hits
       Call Share.Record(3,Room) ' write room record
       Outpts=TreasureRecord.ShortName ' get vehicle name
       Outpts=Rtrim$(Outpts) ' trim name
       Outpts=Lcase$(Outpts) ' lowercase name
       Outpt="The "+Outpts+" now has"+Str$(Vehicle.Hits)+" hits!" ' message
       Call IO.O ' send healed vehicle message
    Else ' compare target
       ' calculate player fatigue increase
       Calculate#=UserRecord.Fatigue+UserRecord.Level+Multiplier ' calculate
       If Calculate#>MaxInt Then ' compare to max integer
          Calculate#=MaxInt ' set to max integer
       Endif ' end compare max integer
       UserRecord.Fatigue=Cint(Calculate#) ' set player fatigue to new value
       Call New.Stats ' routine to update player statistics
       Outpt="You now have"+Str$(UserRecord.Fatigue)+" fatigue points!"
       Call IO.O ' send vigor message
    Endif ' end compare target
 Case Heal ' (heal vitality)
    ' calculate player vitality increase
    Calculate#=UserRecord.Vitality+UserRecord.Level+Multiplier ' calculate
    If Calculate#>MaxInt Then ' compare to max integer
       Calculate#=MaxInt ' set to max integer
    Endif ' end compare max integer
    UserRecord.Vitality=Cint(Calculate#) ' store new vitality
    Call New.Stats ' routine to update player statistics
    Outpt="You now have"+Str$(UserRecord.Vitality)+" vitality points!"
    Call IO.O ' send new vitality message
 Case CurePoison ' cure poison
    Outpt="Nothing happened.." ' default message
    If UserRecord.Poison Then ' check player is poisoned
       UserRecord.Poison=False ' clear player poisoned flag
       Outpt="The poison disappeared!" ' message
    Endif ' end check player poisoned
    Call IO.O ' send poison message
 Case Teleport ' teleport spell
    Next.Room=SpellRecord.Teleport ' copy teleportation room ro next room
    Teleported=True ' set teleporting flag
    Call Enter.Room ' routine to move player to new room
 Case PassDoor ' open nearby doors
    Pass.Door=True ' set passdoor flag
    Outpt="You hear a click!" ' passdoor message
    Call IO.O ' send passdoor message
 Case Conjure ' call up random monster
    For Array.Index=1 To Monclass.Max ' loop through all monster classes
       ' get a random monster choice
       Choice=Monster.Class(Array.Index,Int(Rnd*10+1))
       If Choice Then ' verify choice exists
          Get 5,Choice,MonsterRecord ' get monster record
          ' compare monster to player level
          If MonsterRecord.Level=UserRecord.Level Then ' compare
             Call Get.Monster ' get the monster
             Exit Sub ' exit routine
          Endif ' end compare levels
       Endif ' end verify choice
    Next ' end loop through monster classes
    Outpt="Nothing conjures.." ' default message
    Call IO.O ' send message
 Case Psionic ' psionics
    Outpt="You can't cast a psi spell!" ' error message
    Call IO.O ' send error message
 Case DetectLock ' detect hidden or invisible doors
    For Array.Index=1 To 10 ' loop through room objects
       Object.Number=RoomRecord.Object(Array.Index) ' get room object nummber
       If Object.Number>False And_
       Object.Number<=Lof(4)/Len(ObjectRecord) Then ' file bounds
          Get 4,Object.Number,ObjectRecord ' get object record
          ' compare object invisible or hidden
          If ObjectRecord.Invisible Or ObjectRecord.Hidden Then ' compare
             Outpt="You detect hidden objects here!" ' display message
             Call IO.O ' send message
             Exit Sub ' exit routine
          Endif ' end compare object type
       Endif ' end check file bounds
    Next ' end loop through room objects
    Outpt="You detect nothing.." ' default message
    Call IO.O ' send message
 Case DetectEvil ' determine which direction the highest class monsters are
    High.Class=False ' highest monster class so far
    Monster.Direction=False ' direction of monster class
    For Direction.Number=1 To 11 ' loop through all room directions
       Get 3,Room,RoomRecord ' get current room record
       ' get next room direction
       Next.Direction=RoomRecord.Direct(Direction.Number)
       If Next.Direction Then ' compare room direction
          Get 3,Next.Direction,RoomRecord ' get next room record
          ' compare monster class higher
          If RoomRecord.MonsterClass>High.Class Then ' compare
             High.Class=RoomRecord.MonsterClass ' store higher monster class
             Monster.Direction=Direction.Number ' store direction
          Endif ' end compare monster class
       Endif ' end compare room direction
    Next ' end loop through room directions
    Get 3,Room,RoomRecord ' get current room number
    If Monster.Direction Then ' verify room direction found w/ monsters
       ' make display message with room direction
       Outpt="You detect evil going "+Rtrim$(Direction(Monster.Direction))+"!"
    Else ' verify direction
       Outpt="You detect no evil presence.." ' make display message
    Endif ' end verify room direction
    Call IO.O ' send display message
 Case DetectTrap ' find traps in room objects
    For Array.Index=1 To 10 ' loop through room objects
       Object.Number=RoomRecord.Object(Array.Index) ' get object number
       If Object.Number>False And_
       Object.Number<=Lof(4)/Len(ObjectRecord) Then ' file bounds
          Get 4,Object.Number,ObjectRecord ' get object record
          If ObjectRecord.Trap Then ' verify object is a trap
             Outpt="You detect traps here!" ' make display message
             Call IO.O ' send display message
             Exit Sub ' exit routine
          Endif ' end verify object trap
       Endif ' end check file bounds
    Next ' end loop through room objects
    Outpt="You detect nothing.." ' make default display message
    Call IO.O ' send default message
 Case SetTrap ' sets a magical trap in room
    Trap.Set=False ' room full flag
    For Treasure.Number=1 To 10 ' loop through room treasure
       ' check empty treasure in room
       If RoomRecord.Treasure(Treasure.Number)=False Then
          Trap.Set=True ' set room full flag
          Exit For ' exit loop
       Endif ' end check empty treasure
    Next ' end loop room
    If Trap.Set=False Then ' check room full flag
       Outpt="You didn't set the trap!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check room flag
    If UserRecord.Stats(2)<Int(Rnd*5+5) Then ' calculate random percent
       Outpt="You didn't set the trap!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end calculate percent
    ' calculate trap percent
    If UserRecord.Stats(2)+UserRecord.Stats(3)<Int(Rnd*10+5) Then ' calculate
       Outpt="The trap explodes in your face!" ' make display message
       Call IO.O ' send message
       Calculate#=Cdbl(Int(Rnd*10+2)*UserRecord.Level) ' get hits on player
       Outpt="The trap hit you for" ' death message
       Call Hit.Player(Calculate#) ' routine to hit player
       Exit Sub ' exit routine
    Endif ' end trap percent
    RoomRecord.Treasure(Treasure.Number)=True ' set the trap activated
    RoomRecord.TreCharges(Treasure.Number)=UserRecord.Level ' set trap level
    RoomRecord.Flags(Treasure.Number)=Magic.Trap ' set trap flag
    Call Share.Record(3,Room) ' write room record
    Outpt="You set a magical trap!" ' make display message
    Call IO.O ' send message
 Case Hiding ' spell to hide an item in room
    Item.Hidden=False ' room full flag
    For Array.Index=1 To 10 ' loop through room treasure
       ' found empty room treasure
       If RoomRecord.Treasure(Array.Index)=False Then
          Item.Hidden=True ' set room full flag
          Exit For ' exit loop
       Endif ' end check empty treasure
    Next ' end loop through room
    If Item.Hidden=False Then ' check room full flag
       Outpt="You didn't hide the object!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end check room full flag
    If UserRecord.Stats(2)<Int(Rnd*5+4) Then ' calculate random percent
       Outpt="You didn't hide the object!" ' make display message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end random percent
    ' remove item from player inventory
    Call Discard.Inventory(Array.Number,True)
    RoomRecord.Treasure(Array.Index)=Index.Number ' add item to room
    ' add item charges to room
    RoomRecord.TreCharges(Array.Index)=Charges.Number
    RoomRecord.Flags(Array.Index)=Magically.Hidden ' set magically hidden flag
    Call Share.Record(3,Room) ' write room record
    Outpt="You hide the object magically!" ' make display message
    Call IO.O ' send message
 Case Search ' displays magically hidden objects in room
    Graphics.Off=True ' reset color
    Outpt="You find " ' make first string part
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send output
    Items.Displayed=False ' items displayed counter
    Item.Displayed=False ' item displayed flag
    Outpt=Nul ' reset output string
    For Array.Index=1 To 10 ' loop through room treasure
       Inpt=Nul ' next item string
       ' check hidden flag
       If RoomRecord.Flags(Array.Index)=Magically.Hidden Then
          ' store treasure number
          Treasure.Number=RoomRecord.Treasure(Array.Index)
          If Treasure.Number>False And_
          Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' bounds
             Get 6,Treasure.Number,TreasureRecord ' get treasure record
             Inpt=TreasureRecord.TreasureName ' store treasure name
             Inpt=Rtrim$(Inpt)+" [inv]" ' append treasure name
          Endif ' end check file bounds
       Endif ' end check treasure magically hidden flag
       If Outpt<>Nul And Inpt<>Nul Then ' check next output item
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item to output
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check output item
       If Inpt<>Nul Then ' check last item output
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check items
    Next ' end loop through room
    If Item.Displayed=False Then ' check item displayed flag
       Outpt="nothing special.." ' default display message
    Endif ' end check item flag
    If Item.Displayed And Outpt<>Nul Then ' check item flag
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items displayed
          Outpt="and "+Outpt ' append to string
       Endif ' end check item number
    Endif ' end check items
    Call IO.O ' send output
    Graphics.Off=False ' reset color
 Case Invisibility ' normal player invisibility spell
    Level=Int((UserRecord.Level+2)/Room.Health.Rate) ' calculate percent
    If Level>False Then ' check percent for invisibility
       Invisible=Level ' set invisibility counter
       UserRecord.Invisible=True ' set player record invisible flag
       Outpt="You are now invisible!" ' make display message
    Else ' check invisible percent
       Outpt="Didn't work!" ' default display message
    Endif ' end check invisible percent
    Call IO.O ' send display message
 Case Identify ' spell to display monster stattistics
    Parsed.Command1=Last.Monster ' get parameter in monster name
    Call Check.Monster ' check monster name
    If Monster.Number=False Then ' compare monster number found
       Outpt="You are not fighting a monster now!" ' make error message
       Call IO.O ' send message
       Exit Sub ' exit routine
    Endif ' end compare monster number
    Graphics.Off=True ' reset color
    Call The.Or.An ' get prefix
    Outpts=MonsterArray(Monster.Number).MonsterName ' store monster name
    Outpts=Rtrim$(Outpts) ' trim name
    Outpts=Lcase$(Outpts) ' lowercase name
    Level=MonsterArray(Monster.Number).Level ' store monster level
    ' format message with monster to player level
    Outpt="You are fighting "+Prefix1+Outpts+_
    " (level"+Str$((Level-1)*2+1)+" to"+Str$(Level*2)+")"
    Call IO.O ' send level message
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Hits)+" hits."
    Call IO.O ' display message of monster hit points
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Experience)+" experience."
    Call IO.O ' display message of monster experience
    Outpt="It has"+Str$(MonsterArray(Monster.Number).Gold)+" gold."
    Call IO.O ' display message of monster gold
    Spell.Number=MonsterArray(Monster.Number).Spell ' get monster spell type
    ' file bounds
    If Spell.Number>False And Spell.Number<=Lof(9)/Len(SpellRecord) Then
       Get 9,Spell.Number,SpellRecord ' get spell record
       ' format message with spell monster can cast
       Outpt="It can cast "+Rtrim$(SpellRecord.SpellName)+" spells."
       Call IO.O ' send spell message
    Endif ' end check file bounds
    If MonsterArray(Monster.Number).Poison Then ' check poisonous monster
       Outpt="It can poison." ' make message
       Call IO.O ' send message
    Endif ' end check poisonous monster
    If MonsterArray(Monster.Number).LevelDrain Then ' check undead monster
       Outpt="It can drain levels." ' make message
       Call IO.O ' send message
    Endif ' end check undead monster
    If MonsterArray(Monster.Number).Psionic Then ' check psionic monster
       Outpt="It can cast psi spells." ' make message
       Call IO.O ' send message
    Endif ' end check psionic monster
    If MonsterArray(Monster.Number).Magic Then ' compare magical monster
       Outpt="It's magical." ' make message
       Call IO.O ' send message
    Endif ' end check magical monster
    If MonsterArray(Monster.Number).Block Then ' check monster blocks
       Outpt="It blocks exits." ' make message
       Call IO.O ' send message
    Endif ' end check monster blocks
    If MonsterArray(Monster.Number).Prevent Then ' check monster takes
       Outpt="It prevents treasure take." ' make message
       Call IO.O ' send message
    Endif ' end check monster takes
    If MonsterArray(Monster.Number).Follow Then ' check monster follows
       Outpt="It follows users." ' make message
       Call IO.O ' send message
    Endif ' end check monster follows
    If MonsterArray(Monster.Number).Jail Then ' check monster jails
       Outpt="It jails attacker." ' make message
       Call IO.O ' send message
    Endif ' end check monster jails
    If MonsterArray(Monster.Number).Teleport Then ' check monster teleports
       Outpt="It can teleport." ' make message
       Call IO.O ' send message
    Endif ' end check monster teleports
    Graphics.Off=False ' reset color
 Case Enlighten ' locates hidden objects in room
    Graphics.Off=True ' reset color
    Outpt="You see " ' make first output string
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' output first string
    Items.Displayed=False ' items displayed counter
    Item.Displayed=False ' item displayed flag
    Outpt=Nul ' reset output string
    For Array.Index=1 To 10 ' loop through room treasure
       Inpt=Nul ' reset last item string
       ' compare item hidden
       If RoomRecord.Flags(Array.Index)=Hidden.Object Then
          ' store treasure number
          Treasure.Number=RoomRecord.Treasure(Array.Index)
          If Treasure.Number>False And_
          Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' bounds
             Get 6,Treasure.Number,TreasureRecord ' get treasure record
             Inpt=TreasureRecord.TreasureName ' get treasure name
             Inpt=Rtrim$(Inpt)+" [inv]" ' append to name
          Endif ' end check file bounds
       Endif ' end compare hidden item
       If Outpt<>Nul And Inpt<>Nul Then ' check next item display
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item display
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check items
       If Inpt<>Nul Then ' check last item displayed
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check item
    Next ' end loop through room
    If Item.Displayed=False Then ' check item displayed flag
       Outpt="nothing special.." ' make message
    Endif ' end check item display flag
    If Item.Displayed And Outpt<>Nul Then ' check items displayed
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items
          Outpt="and "+Outpt ' append to string
       Endif ' end check number of items
    Endif ' end check items
    Call IO.O ' send last output string
    Graphics.Off=False ' reset color
 Case Illuminate ' searches room for magic traps
    Graphics.Off=True ' reset color
    Outpt="You see " ' set first output string
    Carriage.Return=True ' disable cr/lf
    Call IO.O ' send first string
    Items.Displayed=False ' set items displayed counter
    Item.Displayed=False ' set item displayed flag
    Outpt=Nul ' reset first item string
    For Array.Index=1 To 10 ' loop through all room treasure
       Inpt=Nul ' set next item displayed
       ' compare treasure magic trap
       If RoomRecord.Flags(Array.Index)=Magic.Trap Then
          If RoomRecord.Treasure(Array.Index)=True Then ' check trap active
             Inpt="a magical trap " ' make display message
             ' append magic trap hits to message
             Inpt=Inpt+"["+_
             Mid$(Str$(RoomRecord.TreCharges(Array.Index)),2)+" hits]"
          Endif ' end check active trap
       Endif ' end compare magic trap
       If Outpt<>Nul And Inpt<>Nul Then ' check next item display
          Carriage.Return=True ' disable cr/lf
          Call IO.O ' send item output
          ' increment items displayed counter
          Items.Displayed=Items.Displayed+1
       Endif ' end check next item
       If Inpt<>Nul Then ' check items
          Item.Displayed=True ' set item displayed flag
          Outpt=Inpt+", " ' append comma
       Endif ' end check items
    Next ' end loop through room
    If Item.Displayed=False Then ' compare item displayed flag
       Outpt="nothing special.." ' make display message
    Endif ' end check item displayed flag
    If Outpt<>Nul Then ' check last item
       Outpt=Left$(Outpt,Len(Outpt)-2)+"." ' trim comma, add period
       If Items.Displayed>1 Then ' check number of items displayed
          Outpt="and "+Outpt ' append to string
       Endif ' end check number of items
    Endif ' end check items
    Call IO.O ' send last string
    Graphics.Off=False ' reset color
 Case Psyche ' heal psionic points
    ' calculate psionic points
    Calculate#=UserRecord.Psionic+UserRecord.Level+Multiplier ' calculate
    If Calculate#>MaxInt Then ' check max integer
       Calculate#=MaxInt ' set to max integer
    Endif ' end check max integer
    UserRecord.Psionic=Cint(Calculate#) ' store players new psionic points
    Call New.Stats ' routine to update player statistics
    Outpt="You now have"+Str$(UserRecord.Psionic)+" psionic points!" ' message
    Call IO.O ' send display message
 Case Else ' any other spell type
    Outpt="You can't cast that spell!" ' make error message
    Call IO.O ' send message
 End Select ' end selection of spell type number
End Sub ' end routine to cast magic spell

 Rem * routine to use psionic spell.
 Rem * processing variables:
 Rem *   Psi.Mode.Type - psi mode 1 or 2 (attack/defense).
 Rem * output variables:
 Rem *   Psi.Attack.Mode - level of psi spell.
 Rem *   Psi.Defense.Mode - level of psi spell.

Sub Psi.Mode
 On Local Error Resume Next ' local error resume
 Select Case Lcase$(Parsed.Command1) ' selection of command parameter
 Case "attack" ' attack command
    Psi.Mode.Type=PsiAttack ' store psi attack
 Case "defense" ' defense command
    Psi.Mode.Type=PsiDefense ' store psi defense
 Case Else ' other
    Outpt="You can only use psi mode attack or defense!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 End Select ' end psi type selection
 Outpt="Psi spell? " ' format input prompt
 Call IO.I ' get input
 Inpt=Ucase$(Inpt) ' uppercase input
 Inpt=Rtrim$(Inpt) ' trim input
 Spell.Found=False ' psi spell found flag
 ' loop through all spell records
 For Spell.Number=1 To Lof(9)/Len(SpellRecord)
    Get 9,Spell.Number,SpellRecord ' get spell record
    Outpt=SpellRecord.Chant ' store spell chant
    Outpt=Rtrim$(Outpt) ' trim chant
    If Outpt=Inpt Then ' compare chant to input chant
       If SpellRecord.Psionic Then ' check spell is psi spell
          Spell.Found=True ' set psi spell flag found
          Exit For ' exit spell file loop
       Endif ' end check psi spell
    Endif ' end check chants
 Next ' end spell file loop
 If Spell.Found=False Then ' check psi spell found flag
    Outpt="Unknown psi spell!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check psi spell flag
 Spell.Name$=SpellRecord.SpellName ' store psi spell name
 Spell.Name$=Rtrim$(Spell.Name$) ' trim name
 Spell.Name$=Lcase$(Spell.Name$) ' lowercase name
 If Psi.Mode.Type<>SpellRecord.PsionicMode Then ' verify psi spell mode
    Outpt="Incorrect spell for psi mode!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end verify psi spell mode
 Level=SpellRecord.Level ' store psi spell level
 If UserRecord.Psionic<=False Then ' check player psionic points remaining
    Outpt="You have no more psi points!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check player psionic points
 Charges.Number=UserRecord.Psionic ' store player psionic points remaining
 ' decrement player psionic points by level of psi spell
 Charges.Number=Charges.Number-Level
 If Charges.Number<False Then ' compare to zero
    Charges.Number=False ' reset to zero
 Endif ' end compare zero
 UserRecord.Psionic=Charges.Number ' store player psionic points remaining
 Outpt="You cast a "+Spell.Name$+" psi spell!" ' make message
 Call IO.O ' send psi spell cast message
 Select Case Psi.Mode.Type ' selection of psi spell type
 Case PsiAttack ' attack mode
    Psi.Attack.Mode=Level ' set psi attack mode to psi spell level
    Parsed.Command1=Last.Monster ' store last monster attacked
    Call Attack.Monster ' attack monster
 Case PsiDefense ' defense mode
    Psi.Defense.Mode=Level ' set psi defense mode to psi spell level
    Outpt="Your psi defense mode is now active!" ' make message
    Call IO.O ' send psi message
 End Select ' end selection of psi spell type
End Sub ' end routine to cast a psi spell

 Rem * routine for monsters to talk.
 Rem * input variables:
 Rem *   Parsed.Command1 - command parameter of monster name.

Sub Talk.To.Monster
 On Local Error Resume Next ' local error resume
 Call Check.Monster ' get monster number
 If Monster.Number=False Then ' check monster found
    Outpt="You can't talk to that!" ' make message
    Call IO.O ' send error message
    Exit Sub ' exit routine
 Endif ' end check monster number
 ' get random number of monster variable of monster talk record file
 Talk.Number=MonsterArray(Monster.Number).Talk(Int(Rnd*5+1))
 Outpt=Nul ' reset talk response string
 ' check bounds
 If Talk.Number>False And Talk.Number<=Lof(7)/Len(MonsterTalkRecord) Then
    Get 7,Talk.Number,MonsterTalkRecord ' get the random record talk string
    Outpt=Rtrim$(MonsterTalkRecord.TalkMessage) ' trim talk response
 Endif ' end check monster talk file bounds
 If Outpt=Nul Then ' compare to length of string
    Outpt="The monster doesn't reply!" ' set string
 Endif ' end check string length
 Call IO.O ' send response
 Get 3,Room,RoomRecord ' get current room record
 ' compare monster number to room record talk action number
 Action.Number=RoomRecord.Action ' store room action number
 ' check file bounds
 If Action.Number>False And Action.Number<=Lof(12)/Len(ActionRecord) Then
    Get 12,Action.Number,ActionRecord ' read action record
    If MonsterIndex(Monster.Number)=ActionRecord.MonsterTalk Then ' compare
       Action1$="As you begin to speak," ' format action string one
       Action2$="The monster hits you for" ' format action string two
       ' routine to activate actions by specific trigger
       Call Actions(Action1$,Action2$)
    Endif ' end compare room monster talk action
 Endif ' end check file bounds
End Sub ' end routine to talk to monster

 Rem * routine to rust some item of player.
 Rem * input variables:
 Rem *   Room.Rust.Rate - number of rounds for rusting.
 Rem *   Rust.Rate - counter of rounds for rusting.

Sub Rust.Weapon
 On Local Error Resume Next ' local error resume
 If Room.Rust.Rate=False Then ' check room has rust rate
    Exit Sub ' exit routine
 Endif ' end check room rust rate
 Rust.Rate=Rust.Rate+1 ' increment rust rate counter
 If Rust.Rate<Room.Rust.Rate Then ' check rust rate counter
    Exit Sub ' exit routine
 Endif ' end check rust rate counter
 Rust.Rate=False ' reset rust rate counter
 Call Rust.Inventory(Weapon4) ' routine to rust armor
 Call Rust.Inventory(Weapon5) ' routine to rust shield
 Call Rust.Inventory(Weapon6) ' routine to rust weapon
 Call Rust.Inventory(Weapon7) ' routine to rust ring
End Sub ' end rust routine

 Rem * routine to rust item.
 Rem * input variables:
 Rem *   Weapon.Number - array index to treasure file record.

Sub Rust.Inventory(Weapon.Number)
 On Local Error Resume Next ' local error resume
 If Weapon.Number>False Then ' check treasure index
    ' store index to treasure file
    Treasure.Number=UserRecord.Inv(Weapon.Number)
    If Treasure.Number>False And_
    Treasure.Number<=Lof(6)/Len(TreasureRecord) Then ' compare bounds
       Get 6,Treasure.Number,TreasureRecord ' get treasure record of item
       If TreasureRecord.Rustable=True Then ' verify item can rust
          If Rnd<(TreasureRecord.RustPercent/100) Then ' check rust percent
             Outpt=TreasureRecord.ShortName ' store treasure name
             Outpt=Rtrim$(Outpt) ' trim name
             Outpt=Lcase$(Outpt) ' lowercase name
             Outpt="Your "+Outpt+" rusts!" ' make message
             Call IO.O ' send rust message
             ' remove item from inventory
             Call Discard.Inventory(Weapon.Number,True)
          Endif ' end check random rust percent
       Endif ' end verify item rusts
    Endif ' end compare file bounds
 Endif ' end check treasure index
End Sub ' end routine to rust items

 Rem * routine for monster to steal item from player inventory.
 Rem * input variables:
 Rem *   Room.Steal.Rate - number of rounds for stealing.
 Rem *   Steal.Rate - counter of rounds for stealing.

Sub Steal.Treasure
 On Local Error Resume Next ' local error resume
 If Room.Steal.Rate=False Then ' check room has steal rate
    Exit Sub ' exit routine
 Endif ' end check room steal rate
 Steal.Rate=Steal.Rate+1 ' increment steal rate counter
 If Steal.Rate<Room.Steal.Rate Then ' compare steal rates
    Exit Sub ' exit routine
 Endif ' end compare steal rates
 Steal.Rate=False ' reset steal rate counter
 If Number.Monsters=False Then ' check monsters in room
    Exit Sub ' exit routine
 Endif ' end compare monsters in room
 For Array.Index=1 To 15 ' loop through player inventory
    If UserRecord.Inv(Array.Index) Then ' check player has inventory
       Get 6,UserRecord.Inv(Array.Index),TreasureRecord ' get treasure record
       If TreasureRecord.Stealable=True Then ' verify item can be stolen
          ' check random percentage item can be stolen
          If Rnd<(TreasureRecord.StealPercent/100) Then
             For Monster.Number=1 To Number.Monsters ' loop through monsters
                ' check permanent
                If MonsterArray(Monster.Number).Permanent=False Then
                   For Array.Number=1 To 5 ' loop through monsters inventory
                      ' locate empty inventory in monster
                      If MonsterArray(Monster.Number).Treasure(Array.Number)=_
                      False Then
                         ' store player inventory in monster inventory
                         MonsterArray(Monster.Number).Treasure(Array.Number)=_
                         UserRecord.Inv(Array.Index) ' store
                         ' monster name
                         Outpt=MonsterArray(Monster.Number).MonsterName
                         Outpt=Rtrim$(Outpt) ' trim name
                         Inpt=TreasureRecord.ShortName ' store treasure name
                         Inpt=Rtrim$(Inpt) ' trim name
                         Inpt=Lcase$(Inpt) ' lowercase name
                         Outpt="The "+Outpt+" steals your "+Inpt+"!" ' message
                         Call IO.O ' send stolen message
                         ' remove inventory from player
                         Call Discard.Inventory(Array.Index,True) ' remove
                         Exit Sub ' exit routine
                      Endif ' end locate emtpt monster inventory
                   Next ' end loop through monster inventory array
                Endif ' end check permanent monster
             Next ' end loop through monsters in room
          Endif ' end random percentage for stealing inventory
       Endif ' end verify item can be stolen
    Endif ' end check player inventory
 Next ' end loop through player inventory
End Sub ' end routine to steal item from player

 Rem * routine to edit messages files.

Sub Edit.Mail
 On Local Error Resume Next ' local error resume
 Do ' loop through mail edit menu
    Graphics.Off=False ' reset color
    Outpt="Mail edit:" ' make display message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[C]hange" ' make display message
    Call IO.O ' send message
    Outpt="[D]elete" ' make display message
    Call IO.O ' send message
    Outpt="[L]ist" ' make display message
    Call IO.O ' send message
    Outpt="[P]ack" ' make display message
    Call IO.O ' send message
    Outpt="[U]ndelete" ' make display message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Message edit option(q to quit)? " ' make input prompt
    No.Input.Out="Q" ' default input
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' select option
    Case "C" ' change option
       Call Change.Message ' routine to change message
    Case "D" ' delete option
       Call Delete.Message ' routine to delete message
    Case "L" ' list option
       Call List.Messages ' routine to list messages
    Case "P" ' pack option
       Call Pack.Messages ' routine to pack messages
    Case "U" ' undelete option
       Call Undelete.Message ' routine to undelete message
    Case "Q" ' exit mail edit menu option
       Exit Do ' exit edit mail menu
    End Select ' end mail edit option selection
 Loop ' end mail edit menu loop
End Sub ' end mail edit menu routine

 Rem * routine changes message.

Sub Change.Message
 On Local Error Resume Next ' local error resume
 Do ' loop through message changing
    Graphics.Off=False ' reset color
    Max.Messages=Lof(10)/Len(TableRecord) ' store length of message table
    Outpt="Message number to edit" ' make range input prompt
    Call Get.Range2(1,Max.Messages,Message.Number) ' routine to get number
    Get 10,Message.Number,TableRecord ' read table record
    Graphics.Off=False ' reset color
    Outpt="Edit message header(y/n)? " ' make input prompt
    No.Input.Out="N" ' default input
    Call IO.I ' get user input
    If Yes Then ' check nput response
       Call Message.Header(Message.Number) ' routine to display header
       Graphics.Off=False ' reset color
       Outpt="Enter new message header:" ' make display message
       Call IO.O ' send message
       Graphics.Off=True ' reset color
       Outpt="From(press <enter> for Sysop)? " ' make input prompt
       No.Input.Out="Sysop" ' default input
       Call IO.I ' get user input
       TableRecord.From=Inpt ' store message from
       Outpt="To(press <enter> for ALL)? " ' make input prompt
       Call IO.I ' get user input
       TableRecord.To=Ucase$(Inpt) ' store message to
       Outpt="Subject? " ' make input prompt
       Call IO.I ' get user input
       TableRecord.Subject=Lcase$(Inpt) ' store message subject
       Call Share.Record(10,Message.Number) ' routine to write table record
    Endif ' end check response
    Do ' loop through message text editing
       Graphics.Off=False ' reset color
       Outpt="Edit more message text(y/n)? " ' make input prompt
       No.Input.Out="N" ' default input
       Call IO.I ' get user input
       If No Then ' check input response
          Exit Do ' exit message editing loop
       Endif ' end check response
       Call Read.Message(Message.Number,True) ' routine to display message
       Graphics.Off=False ' rset color
       MessageRec.Length=TableRecord.Length ' store message length
       Outpt="Line number to edit" ' make range input prompt
       ' routine to get number
       Call Get.Range2(0,MessageRec.Length,Message.Line)
       If Message.Line>False Then ' check range
          Outpt="New message text:" ' make display message
          Call IO.O ' send message
          Graphics.Off=True ' reset color
          Outpt="?" ' make input prompt
          Call IO.I ' get user input
          Call Valid(Inpt,80) ' validate input
          Call Encrypt(Inpt,True) ' encrypt input
          MessageRecord.Message=Inpt ' store new message text
          MessageRec.Number!=Csng(TableRecord.Start+Message.Line-1)
          Put 11,MessageRec.Number!,MessageRecord ' write message record
       Endif ' end check range
    Loop ' end loop through editing
    Graphics.Off=False ' reset color
    Outpt="Edit another message(y/n)? " ' make input prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get user input
    If No Then ' check input response
       Exit Sub ' exit routine
    Endif ' end check response
 Loop ' end loop through editing
End Sub ' end message editing routine

 Rem * routine to delete message.

Sub Delete.Message
 On Local Error Resume Next ' local error resume
 Do ' loop through delete routine
    Max.Messages=Lof(10)/Len(TableRecord) ' store length of table file
    Outpt="Message number to delete" ' make range input prompt
    Call Get.Range2(1,Max.Messages,Message.Number) ' routine to get number
    Get 10,Message.Number,TableRecord ' read table record
    If TableRecord.Killed Then ' check deleted message flag
       Outpt="Message"+Str$(Message.Number)+" is already deleted." ' message
    Else ' check deleted message
       TableRecord.Killed=True ' set deleted message flag
       Call Share.Record(10,Message.Number) ' routine to write table record
       Outpt="Message"+Str$(Message.Number)+" deleted." ' make deleted message
    Endif ' end check deleted message flag
    Call IO.O ' send message
    Graphics.Off=False ' rset color
    Outpt="Delete more messages(y/n)? " ' make input prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get user input
    If No Then ' check input response
       Exit Sub ' exit routine
    Endif ' end check response
 Loop ' end loop through deleting
End Sub ' end delete message routine

 Rem * routine to list range of messages.

Sub List.Messages
 On Local Error Resume Next ' local error resume
 Messages.Max=Lof(10)/Len(TableRecord) ' store length of table
 ' routine to get range of numbers
 Call Get.Range(Messages.Max,Messages1,Messages2)
 For Message.List=Messages1 To Messages2 ' loop through range of messages
    Get 10,Message.List,TableRecord ' read table record
    Call Read.Message(Message.List,False) ' routine to display message
    Graphics.Off=False ' reset color
    Outpt="Read more(y/n)? " ' make prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get player input
    If No Then ' check input response
       Exit Sub ' exit routine
    Endif ' end check response
 Next ' end message display loop
End Sub ' end message list routine

 Rem * routine to undelete messages.

Sub Undelete.Message
 On Local Error Resume Next ' local error resume
 Do ' loop through undeleting
    Max.Messages=Lof(10)/Len(TableRecord) ' store table length
    Outpt="Message number to undelete" ' make range input prompt
    Call Get.Range2(1,Max.Messages,Message.Number) ' routine to get number
    Get 10,Message.Number,TableRecord ' read table record
    If TableRecord.Killed=False Then ' check deleted message
       Outpt="Message"+Str$(Message.Number)+" is not deleted." ' make message
    Else ' check deleted message
       TableRecord.Killed=False ' set deleted message flag
       Call Share.Record(10,Message.Number) ' routine to write table record
       Outpt="Message"+Str$(Message.Number)+" undeleted." ' make message
    Endif ' end check undeleted message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Undelete more messages(y/n)? " ' make input prompt
    No.Input.Out="Y" ' default input
    Call IO.I ' get user input
    If No Then ' check input response
       Exit Sub ' exit routine
    Endif ' end check input
 Loop ' end undeleting loop
End Sub ' end undelete routine

 Rem * routine to pack messages files.

Sub Pack.Messages
 On Local Error Resume Next ' local error resume
 Outpt="Pack messages(y/n)? " ' make input prompt
 No.Input.Out="N" ' default input
 Call IO.I ' get user input
 If Yes Then ' check response
    Outpt="Packing messages.." ' make message
    Call IO.O ' send message
    Call Share.Record(1,User.Index) ' store user record
    Max.Users=Lof(1)/Len(UserRecord) ' store length of user file
    ' dimension working array
    Dim ArrayX(1 To Max.Users) As Integer
    ' packing pass 1
    For User.Number=1 To Max.Users ' loop through user file
       Get 1,User.Number,UserRecord ' get next user file record
       ArrayX(User.Number)=UserRecord.LastMessage ' store last message number
    Next ' end user file loop
    For Message.Number=1 To Lof(10)/Len(TableRecord) ' loop through table file
       Get 10,Message.Number,TableRecord ' read table record
       If TableRecord.Killed Then ' check for deleted message
          For User.Number=1 To Max.Users ' loop through user array
             Last.Message=ArrayX(User.Number) ' store last message
             If Last.Message<=Message.Number Then ' check last message
                Last.Message=Last.Message-1 ' decrement last message read
                ArrayX(User.Number)=Last.Message ' store last message read
             Endif ' end check last message
          Next ' end user array loop
       Endif ' end check deleted message
    Next ' end message pack loop
    For User.Number=1 To Max.Users ' loop through user file
       Get 1,User.Number,UserRecord ' get next user file record
       UserRecord.LastMessage=ArrayX(User.Number) ' store last message number
       Call Share.Record(1,User.Number) ' write user record
       Get 1,User.Index,UserRecord ' reread current player record
    Next ' end user file loop
    ' packing pass 2
    Max.Messages=Lof(10)/Len(TableRecord) ' store maximum table records
    Erase ArrayX ' remove temporary array
    ' dimension working array
    Dim ArrayX(1 To Max.Messages) As Integer
    For Message.Number=1 To Max.Messages ' loop through table file
       Get 10,Message.Number,TableRecord ' read table record
       ArrayX(Message.Number)=TableRecord.Thread ' store thread number
    Next ' end table file rad loop
    For Message.Number=1 To Max.Messages ' loop through table file
       Get 10,Message.Number,TableRecord ' read table record
       If TableRecord.Killed Then ' check for deleted message
          Thread.Number=ArrayX(Message.Number) ' store thread number
          ' search for forward thread
          For Message.Search=Message.Number+1 To Max.Messages
             ' verify forward message thread
             If ArrayX(Message.Search)=Message.Number Then
                ArrayX(Message.Search)=Thread.Number ' store thread number
                If Thread.Number=False Then ' check for thread start
                   ' search for end of thread
                   For Thread.Search=Message.Search+1 To Max.Messages
                      ' compare thread has another ending thread
                      If ArrayX(Thread.Search)=Message.Search Then
                         Exit For ' exit thread end loop
                      Endif ' end compare for end thread
                   Next ' end end thread search loop
                   If Thread.Search>Max.Messages Then ' compare end thread
                      Get 10,Message.Search,TableRecord ' read table
                      TableRecord.Reply=False ' reset thread reply start
                      Call Share.Record(10,Message.Search) ' write table
                   Endif ' end compare end thread
                Endif ' end check thread start
             Endif ' end verify forward message thread
          Next ' end forward message thread search loop
          ' search through all forward thread numbers
          For Message.Search=Message.Number+1 To Max.Messages
             Thread.Number=ArrayX(Message.Search) ' store thread number
             If Thread.Number>=Message.Number Then ' verify forward thread
                Thread.Number=Thread.Number-1 ' decrement thread number
                ArrayX(Message.Search)=Thread.Number ' store thread number
             Endif ' end verify forward message thread
          Next ' end forward message thread search loop
       Endif ' end check deleted message
    Next ' end message pack loop
    For Message.Number=1 To Max.Messages ' loop through table file
       Get 10,Message.Number,TableRecord ' read table record
       TableRecord.Thread=ArrayX(Message.Number) ' store thread number
       Call Share.Record(10,Message.Number) ' write table record
    Next ' end table file read loop
    Erase ArrayX ' remove temporary array
    ' packing pass 3
    Close #13 ' close temporary file
    FileName="MSGTABLE.BAK" ' get table filename
    If Dir$(FileName)=FileName Then ' check backup file exists
       Kill FileName ' remove temporary file
    Endif ' end check backup file exists
    ' open temporary backup file
    Open FileName For Random Shared As #13 Len=Len(TableRecord)
    For Message.Number=1 To Lof(10)/Len(TableRecord) ' loop through table
       Get 10,Message.Number,TableRecord ' read table record
       Put 13,Message.Number,TableRecord ' store table record
    Next ' end message pack loop
    Close #13 ' close temporary file
    FileName="MESSAGES.BAK" ' get table filename
    If Dir$(FileName)=FileName Then ' check backup file exists
       Kill FileName ' remove temporary file
    Endif ' end check backup file exists
    ' open temporary backup file
    Open FileName For Random Shared As #13 Len=Len(MessageRecord)
    For Message.Number=1 To Lof(11)/Len(MessageRecord) ' loop through message
       Get 11,Message.Number,MessageRecord ' read message record
       Put 13,Message.Number,MessageRecord ' store message record
    Next ' end message pack loop
    Close 10,11,13 ' close temporary and mail files
    FileName="MESSAGES.DAT" ' get mail filename
    If Dir$(FileName)=FileName Then ' check mail file exists
       Kill FileName ' remove mail file
    Endif ' end check mail file exists
    FileName="MSGTABLE.DAT" ' get mail filename
    If Dir$(FileName)=FileName Then ' check mail file exists
       Kill FileName ' remove mail file
    Endif ' end check mail file exists
    Open "msgtable.dat" For Random Shared As #10 Len=Len(TableRecord)
    Open "messages.dat" For Random Shared As #11 Len=Len(MessageRecord)
    Open "msgtable.bak" For Random Shared As #13 Len=Len(TableRecord)
    Open "messages.bak" For Random Shared As #14 Len=Len(MessageRecord)
    Table.Number=False ' reset table record number
    For Message.Number=1 To Lof(13)/Len(TableRecord) ' loop through table file
       Get 13,Message.Number,TableRecord ' read table record
       If TableRecord.Killed=False Then ' check for deleted message
          Message.Start!=TableRecord.Start ' store beginning
          Message.End!=Message.Start!+Csng(TableRecord.Length-1) ' store end
          Table.Number=Table.Number+1 ' increment next table record
          TableRecord.Start=Csng(Lof(11)/Len(MessageRecord)+1) ' store table
          Put 10,Table.Number,TableRecord
          For Message.Record!=Message.Start! To Message.End! ' message loop
             Get 14,Message.Record!,MessageRecord
             New.Message.Record!=Csng(Lof(11)/Len(MessageRecord)+1) ' store
             Put 11,New.Message.Record!,MessageRecord ' write message text
          Next ' end loop through message text array
       Endif ' end check deleted message
    Next ' end table file loop
    Close 13,14 ' close temporary files
 Endif ' end check response
End Sub ' end routine to pack messages

 Rem * routine to edit message text.
 Rem * output variables:
 Rem *   Message.Edit - true to continue, false to abort, 1 to store message.

Sub Edit.Message(Message.Edit)
 On Local Error Resume Next ' local error resume
 Do ' loop through message edit menu
    Graphics.Off=False ' reset color
    Outpt="Editing options:" ' make dislay message
    Call IO.O ' send message
    Graphics.Off=True ' reset color
    Outpt="[A]bort" ' make dislay message
    Call IO.O ' send message
    Outpt="[C]ontinue" ' make dislay message
    Call IO.O ' send message
    Outpt="[D]elete" ' make dislay message
    Call IO.O ' send message
    Outpt="[E]dit" ' make dislay message
    Call IO.O ' send message
    Outpt="[I]nsert" ' make dislay message
    Call IO.O ' send message
    Outpt="[L]ist" ' make dislay message
    Call IO.O ' send message
    Outpt="[R]eplace" ' make dislay message
    Call IO.O ' send message
    Outpt="[S]tore" ' make dislay message
    Call IO.O ' send message
    Graphics.Off=False ' reset color
    Outpt="Edit command? " ' make input prompt
    Call IO.I ' get user input
    Select Case Ucase$(Inpt) ' selection of edit option
    Case "C" ' option to continue message
       Message.Edit=True ' set return variable
       Exit Sub ' exit routine
    Case "R" ' option to replace line
       Call Replace.Line ' replace routine
    Case "E" ' option to edit line
       Call Edit.Line ' line edit routine
    Case "D" ' option to delete line
       Call Delete.Line ' delete routine
    Case "I" ' option to insert lines
       Call Insert.Lines ' insert routine
    Case "A" ' option to abort message
       Outpt="Are you sure(y/n)? " ' make input prompt
       No.Input.Out="N" ' default input
       Call IO.I ' get user input
       If Yes Then ' check input response
          Message.Edit=False ' set return variable
          Exit Sub ' exit routine
       Endif ' end check response
    Case "L" ' option to list lines
       Call List.Lines ' line list routine
    Case "S" ' option to store message
       Message.Edit=UnTrue ' set return variable
       Exit Sub ' exit routine
    End Select ' end selection of input
 Loop ' end loop through edit menu
End Sub ' end edit menu routine

 Rem * routine to store message.

Sub Store.Message
 On Local Error Resume Next ' local error resume
 Get 1,User.Index,UserRecord ' read user file
 Outpt=UserRecord.CodeName ' store codename
 Call Decrypt(Outpt) ' decrypt codename
 Inpt=Rtrim$(Outpt) ' store codename
 Inpt=Ucase$(Inpt) ' uppercase ccodename
 Outpts=Message.To ' store message header
 Outpts=Rtrim$(Outpts) ' trim header
 Outpts=Ucase$(Outpts) ' uppercase header
 If Inpt=Outpts Then ' compare codenames
    Message.To=Nul ' reset message header
 Endif ' end compare codenames
 TableRecord.ClassType=UserRecord.ClassType ' store user class type
 TableRecord.Clock=FNclock$ ' store message creation time
 TableRecord.Date=Date$ ' store system date
 TableRecord.Flags=UserRecord.Flags ' store user flags
 TableRecord.From=Outpt ' store user codename
 TableRecord.Killed=False ' reset deleted message flag
 TableRecord.Length=Message.Length ' store length of message
 TableRecord.Private=Private.Message ' store private message flag
 TableRecord.Received=False ' store flag for message received
 TableRecord.Reply=Message.Reply ' store message reply flag
 ' store message beginning
 TableRecord.Start=Csng(Lof(11)/Len(MessageRecord)+1)
 TableRecord.Subject=Subject ' store message subject
 TableRecord.Time=Time$ ' store system time
 TableRecord.Timer=Timer ' store system time in seconds
 TableRecord.TimesRead=False ' reset number of times message read
 TableRecord.To=Message.To ' store message to
 If Message.Reply Then ' check message type
    TableRecord.Thread=Message.Thread ' store message thread number
 Else ' check message
    TableRecord.Thread=False ' store thread number
 Endif ' end check message
 TableRec.Number=Lof(10)/Len(TableRecord)+1 ' store next table record number
 Call Share.Record(10,TableRec.Number) ' routine to write table record
 For Message.Number=1 To Message.Length ' loop through message text array
    Outpt=Array(Message.Number) ' store message text line
    Call Valid(Outpt,80) ' routine to validate text
    Call Encrypt(Outpt,True) ' encrypt text
    MessageRecord.Message=Outpt ' store text line
    ' store next message record number
    MessageRec.Number!=Csng(Lof(11)/Len(MessageRecord)+1)
    Put 11,MessageRec.Number!,MessageRecord ' write message text
 Next ' end loop through message text array
 Outpt="Message stored." ' make message
 Call IO.O ' send message
End Sub ' end routine to store message

 Rem * routine to check for new messages.

Sub Check.Mail
 On Local Error Resume Next ' local error resume
 New.Messages=False ' reset number of new messages
 Outpt=UserRecord.CodeName ' store codename
 Call Decrypt(Outpt) ' decrypt codename
 Outpt=Rtrim$(Outpt) ' trim codename
 Outpt=Lcase$(Outpt) ' lowercase codename
 Last.Message=UserRecord.LastMessage ' store last message number read
 Table.Number=Lof(10)/Len(TableRecord) ' store length of message table
 ' compare range of messages
 If Last.Message>False And Last.Message<=Table.Number Then
    For Table.Index=Last.Message To Table.Number ' loop through new messages
       Get 10,Table.Index,TableRecord ' read table record
       If TableRecord.Killed=False Then ' check deleted message
          Inpt=TableRecord.To ' store message to
          Inpt=Rtrim$(Inpt) ' trim message to
          Inpt=Lcase$(Inpt) ' lowercase message to
          If Inpt<>Nul Then ' check public message to
             If Inpt=Outpt Then ' compare codenames
                New.Messages=New.Messages+1 ' increment number of new message
             Endif ' end compare codenames
          Endif ' end check public message
       Endif ' end check deleted message
    Next ' end loop through new messages
 Endif ' end compare new message range
 Graphics.Off=True ' reset color
 If New.Messages>False Then ' check new messages
    Outpt="You have"+Str$(New.Messages)+" new messages." ' make message
 Else ' check new message variable
    Outpt="You have no new messages." ' make output message
 Endif ' end check new message variable
 Call IO.O ' send message
 Graphics.Off=False ' reset color
End Sub ' end routine to check for new mail

 Rem * routine to replace line of message text.

Sub Replace.Line
 On Local Error Resume Next ' local error resume
 Messages.Max=Message.Length ' store message length
 Outpt="Line number" ' store input range prompt
 Call Get.Range2(1,Messages.Max,Message.Number) ' routine to get number
 Outpt="Replacement line:" ' input prompt
 Call IO.O ' send prompt
 Outpt="?" ' input prompt
 Call IO.I ' get user input
 Inpt=Rtrim$(Inpt) ' trim input
 Inpt=Left$(Inpt,79) ' truncate input
 Array(Message.Number)=Inpt ' store new message line
 Outpt="Line number"+Str$(Message.Number)+" replaced." ' make display message
 Call IO.O ' send message
End Sub ' end routine to replace line of message text

 Rem * routine to edit a line of message text.

Sub Edit.Line
 On Local Error Resume Next ' local error resume
 Messages.Max=Message.Length ' store length of message
 Outpt="Line number" ' make input range prompt
 Call Get.Range2(1,Messages.Max,Message.Number) ' routine to get number
 Outpt="Replace what word? " ' make input prompt
 Call IO.I ' get user input
 If Inpt=Nul Then ' check input length
    Outpt="No replacements made." ' make display message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check input length
 Message.Number$=Inpt ' store input
 Outpt="Replace with what word? " ' make input prompt
 Call IO.I ' get user input
 If Inpt=Nul Or Inpt=Message.Number$ Then ' check input length, compare inputs
    Outpt="No replacements made." ' make display message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check inputs
 Edit.Replace$=Inpt ' store input
 Outpt="Replace all occurences? " ' make input prompt
 No.Input.Out="Y" ' default input
 Call IO.I ' get user input
 Replace.Word=1 ' reset string search index
 Replace.All=Yes ' store input response
 Replacements=False ' reset replacement flag
 EditLine$=Rtrim$(Array(Message.Number)) ' store message line to edit
 ' routine loop replaces Message.Number$ in EditLine$ with Edit.Replace$
 Do ' loop until replacements finished
    If EditLine$=Nul Then ' check length of message line
       Exit Do ' exit loop if line length reduced to null
    Endif ' end check length of message line
    ' get position of search string
    Replace=Instr(Replace.Word,EditLine$,Message.Number$)
    If Replace=False Then ' check search string exists
       Exit Do ' exit loop if search string not found
    Endif ' end check search string exists
    ' replace search string with replacement string
    EditLine$=Left$(EditLine$,Replace-1)+Edit.Replace$+_
    Mid$(EditLine$,Replace+Len(Message.Number$))
    EditLine$=Left$(EditLine$,79) ' truncate message line
    ' recalculate next position index for search
    Replace.Word=Replace+Len(Edit.Replace$)
    Replacements=Replacements+1 ' increment number of replacements made
    If Replacements=1 Then ' check first replacement
       If Replace.All=False Then ' check flag to replace all searches
          Exit Do ' exit loop after only one replacement made
       Endif ' end check replacement flag
    Endif ' end check replacement number
 Loop ' end replacement loop
 Array(Message.Number)=EditLine$ ' store edited message line
 Select Case Replacements ' selectionn of number of replacements made
 Case 0 ' no replacements
    Outpt="No replacements made." ' make display message
 Case 1 ' one replacement
    Outpt="One replacement made." ' make display message
 Case Else ' more than one replacement
    Outpt=Mid$(Str$(Replacements),2)+" replacements made." ' make message
 End Select ' end selection of number of replacements
 Call IO.O ' send display message
End Sub ' end routine to edit message line

 Rem * routine to delete range of lines from message text.

Sub Delete.Line
 On Local Error Resume Next ' local error resume
 Outpt="Enter line numbers:" ' make display message
 Call IO.O ' send message
 Messages.Max=Message.Length ' store length of message
 ' routine to get range of numbers
 Call Get.Range(Messages.Max,Message.Line1,Message.Line2)
 ' input prompt
 Outpt="Delete lines"+Str$(Message.Line1)+" to"+Str$(Message.Line2)+"(y/n)? "
 No.Input.Out="Y" ' default input
 Call IO.I ' get user input
 If No Then ' check input response
    Exit Sub ' exit routine
 Endif ' end check input response
 ' loop through the total number of lines to delete
 For Message.Index=1 To Message.Line2-Message.Line1+1
    Message.Length=Message.Length-1 ' decrement the length of message
    ' loop from the first line to delete
    For Array.Index=Message.Line1 To Message.Length
       Array(Array.Index)=Array(Array.Index+1) ' packing the remaining message
    Next ' end loop through deleted lines
 Next ' end loop through number of lines to delete
 If Message.Length=False Then ' check length of message
    Outpt="No message left." ' make error message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check message length
 Outpt="Line numbers"+Str$(Message.Line1)+" to"+_
 Str$(Message.Line2)+" deleted." ' make message
 Call IO.O ' send message
End Sub ' end routine to delete range of lines

 Rem * routine to insert lines into message text.

Sub Insert.Lines
 On Local Error Resume Next ' local error resume
 If Message.Length=64 Then ' check length of message
    Outpt="Message buffer full." ' make message
    Call IO.O ' send message
    Exit Sub ' exit routine
 Endif ' end check message length
 Messages.Max=Message.Length ' store message length
 Outpt="Before line number" ' make input range prompt
 Call Get.Range2(1,Messages.Max,Message.Line) ' routine to get number
 Graphics.Off=True ' reset color
 User.Word.Wrap=UserRecord.Wordwrap ' store user word wrap
 UserRecord.Wordwrap=False ' reset word wrap
 Do While Message.Length<64 ' loop while message length range
    Word.Wrap=True ' set word wrap flag
    Outpt="?" ' make input prompt
    Call IO.I ' get user input
    Word.Wrap=False ' reset word wrap flag
    If No.Input Then ' check length of input flag
       Exit Do ' exit message netry loop
    Endif ' end check input length
    ' loop backwards through message
    For Array.Index=Message.Length To Message.Line Step -1
       ' pack lines before inserted line
       Array(Array.Index+1)=Array(Array.Index)
    Next ' end backward loop
    Inpt=Rtrim$(Inpt) ' trim input
    Inpt=Left$(Inpt,79) ' truncate input
    Array(Message.Line)=Inpt ' store new inserted message line
    Message.Line=Message.Line+1 ' increment line number to insert before
    Message.Length=Message.Length+1 ' increment length of message
 Loop ' end message insert loop
 UserRecord.Wordwrap=User.Word.Wrap ' restore word wrap
 Graphics.Off=False ' reset color
 If Message.Length=64 Then ' compare length of message
    Outpt="Message buffer full." ' make buffer message
    Call IO.O ' send message
 Endif ' end check length of message
End Sub ' end insert routine

 Rem * routine to list range of message text lines.

Sub List.Lines
 On Local Error Resume Next ' local error resume
 Outpt="Enter line numbers:" ' make display message
 Messages.Max=Message.Length ' store length of message
 ' routine to get range of numbers
 Call Get.Range(Messages.Max,Message.Line1,Message.Line2)
 Outpt="Display line numbers(y/n)? " ' make input prompt
 No.Input.Out="Y" ' default input
 Call IO.I ' get user input
 ListLines=Yes ' store response
 Allow.Break=True ' turn on allow break flag
 Break=False ' reset control-k flag
 Continue=False ' reset continuous flag
 Page.Length=False ' reset page counter
 Graphics.Off=True ' reset color
 ' loop through range of message lines
 User.Line.Length=UserRecord.Linelength ' store user line length
 UserRecord.Linelength=False ' store line length
 For Message.Line=Message.Line1 To Message.Line2
    If ListLines Then ' check line number list flag
       Outpt=Mid$(Str$(Message.Line),2)+":" ' make line number
    Else ' check line number flag
       Outpt=Nul ' reset line number string
    Endif ' end check line number flag
    Outpt=Outpt+Array(Message.Line) ' make line display
    Outpt=Left$(Outpt,79) ' truncate line
    Call IO.O ' send line display
    If Break Then ' check control-k pressed
       Exit For ' exit text input loop
    Endif ' end check control-k
    Page.Length=Page.Length+1 ' increment page counter
    If Page.Length=UserRecord.Pagelength Then ' check page counter
       Page.Length=False ' reset page counter
       If Continue=False Then ' check continuous flag
          Call More.Prompt ' routine to pause
          If No Then ' check pause response
             Exit For ' exit routine
          Endif ' end check response
       ENdif ' end check continuous flag
    Endif ' end check page counter
 Next ' end loop through range of lines
 UserRecord.Linelength=User.Line.Length ' restore line length
 Allow.Break=False ' reset allow break flag
 If Break Then ' check control-k flag
    Break=False ' reset control-k flag
    Outpt=Nul ' set output to null
    Call IO.O ' send empty return
 Endif ' end check control-k flag
 If Page.Length Then ' recheck page counter
    Call More.Prompt ' pause routine
 Endif ' end recheck counter
End Sub ' end list lines routine
