' $linesize:132
' $title: 'RBBSSUB3.BAS 17.5, Copyright 1986 - 94 by D. Thomas Mack'
'  Copyright 1990 by D. Thomas Mack, all rights reserved.
'  Name ...............: RBBSSUB3.BAS
'  First Released .....: June 21, 1992
'  Subsequent Releases.:
'  Copyright ..........: 1986 - 1994
'  Purpose.............: The Remote Bulletin Board System for the IBM PC,
'     RBBS-PC.BAS utilizes a lot of common subroutines.  Those that do not
'     require error trapping are incorporated within RBBSSUB 2-7 as
'     separately callable subroutines in order to free up as much
'     code as possible within the 64K code segment used by RBBS-PC.BAS.
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine      Line       Function of Subroutine
'   Name          Number
' ----------      ------     ----------------------
'  AddCommas       58130     Format commands in the command prompt
'  AllCaps         58050     Convert a string to all upper case characters
'  AMorPM          41498     Calculate the current time as AM or PM
'  AskGraphics     43004     Determine users graphic default
'  BadFile         20747     Check for system crash attempt with bad device name
'  Carrier         42000     Test for whether to continue in RBBS
'  CheckRatio      20096     Test upload/download ratio
'  CheckTime       58070     Test to insure that users don't exceed their time
'  CheckCarrier    42005     Checks whether still have carrier
'  CheckNewBul     58110     Check for new bulletins based on their file creation date
'  CheckTimeRemain 41007     Set up to log off if time exceeded
'  CommInfo        44020     Get users baud rate and parity in a string format
'  CountLines      58160     Count categories a file can be classified into
'  CountNewFiles   58140     Check for number of files uploaded after a specific date
'  DelayTime       50495     Wait number of seconds specified before returning
'  DispCall        57001     Display callers file
'  DispTimeRemain  41032     Compute and display time remaining
'  DispUpDir       58165     Display the shared directory of the FMS mng. sys.
'  FileLock        21993     Allow files to be shared among multiple RBBS-PC's
'  FindFKey        30595     Handle local keyboard's function & ZSysop's keys
'  FindLast        58600     Finds last occurence of a string in a string
'  FlushKeys       35000     Completely flush all user input
'  Graphic         43031     Determines if graphic ver of file exists, opens as #2
'  GraphicX        43031     Determines if graphic ver of file exists, any file #
'  HashRBBS        58080     "Hash" to a user's record in the USERS file
'  InitFMS         58162     Initialize the RBBS-PC's File Management System
'  InitIBM         30000     Open/create NetBIOS semaphore file
'  LinesInFile     58161     Counts lines in a file
'  LoadNew         58140     Find the latest uploads (COMBINED WITH CountNewFiles)
'  ModemPut        52070     Write a modem command string to the modem
'  MultiFile       91000     Check user entry for a range of numbers
'  NameCaps        58060     Convert a string to Proper Case (for name output)
'  OpenMsg         30500     Open the messages file as file number 1
'  PageUp          33990     Display user info. on local screen for ZSysop
'  ReadProf        44000     Read user's profile on return from a "door"
'  SaveProf        43068     Save the user's provile when exiting to "doors" or DOS
'  SetOpts         58100     Set correct prompt line for each subsystem
'  SortString      58120     Sort characters in a string
'  TimeRemain      41010     Compute time remaining in minutes
'  UpdtUpload      20705     Updates upload directory file
'  XferType        21598     Identify the file transfer protocol
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
'
20705 ' $SUBTITLE: 'UpdtUpload -- Updates upload directory'
' $PAGE
'  NAME    -- UpdtUpload
'
'  INPUTS  -- PARAMETER             MEANING
'             WasFF               1 - GET DESCRIPTION
'                                 2 - TEST FILE AND UPDATE DIRECTORY
'                                 3 - UPDATE DIRECTORY WITH EXTENDED DESCRIPTION
'             ZFileName$
'             ZUpldDir$
'             ZFileNameHold$
'             ZShareIt
'             ZFMSDirectory$
'             ZWasQ!
'             ZSecsUsedSession!
'
'  OUTPUTS -- ZBytesInFile#
'             ZSecsPerSession!
'
'  PURPOSE -- Upon a successful upload, add entry to the upload
'             directory and give any session time credit.
'
      SUB UpdtUpload (ZCategoryName$(1),ZCategoryCode$(1), LinesInDesc,WasFF) STATIC
      ON WasFF GOTO 20710,20707,20706
20706 GOTO 20723
20707 GOSUB 20734
      IF ZHighSpeedTransfer OR ZWasBatchTransfer THEN _
         GOSUB 20738
      IF NOT ZAlreadyGiven AND NOT ZHighSpeedTransfer AND NOT ZWasBatchTransfer THEN
         CALL TimeRemain (MinsRemaining)
         IF ZPrivateDoor THEN _
            WasX! = ZUpldTimeFactor! * ZWasQ! _
         ELSE WasX! = ZUpldTimeFactor! * (ZSecsUsedSession! - ZWasQ!)
      END IF
      IF ZAbort = ZTrue THEN _
         EXIT SUB
      CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZFalse)
      WasX$ = ZDiskForDos$ + "TEST.BAT"
      CALL Graphic (WasX$,ZFalse)
      IF NOT ZOK THEN _
         WasX$ = ZDiskForDos$ + "T" + Ext$ + ".BAT" : _
         CALL Graphic (WasX$,ZFalse) : _
         IF NOT ZOK THEN _
            GOTO 20708
      CALL SkipLine (1)
      CALL QuickTPut1 (ZFG4$ + "Testing " + ZFGB$ + ZFileNameHold$ + _
                      ZFG4$ + "  Please Wait..." + ZEmphasizeOff$)
      CALL ReadDir (2,1)
      ZGSRAra$(2) = ZNodeWorkDrvPath$ + "VCHK" + ZNodeFileID$
      IF EOF(2) THEN _
         WasX$ = ZOutTxt$ : _
         ZGSRAra$(1) = ZFileName$ _
      ELSE _
         WasX$ = WasX$ + " " + ZFileName$ + " " + ZGSRAra$(2) + _
                  " " + ZComPort$ + " " + Ext$
      IF ZWasBatchTransfer OR ZHighSpeedTransfer THEN _
         CALL TimeBack (1)
      CALL ShellExit (WasX$)
      CALL FindIt (ZGSRAra$(2))
      IF ZOK THEN _
         IF LOF(2) > 2 THEN _
            ZBytesInFile# = 0.0 : _
            WasX$ = "Deleting BAD upload " + ZFileNameHold$ : _
            CALL QuickTPut1 (WasX$) : _
            CALL UpdtCalr (WasX$,2) : _
            CALL KillWork (ZFileName$) : _
            ZGetExtDesc = ZFalse : _
            CLOSE 2 : _
            CALL KillWork (ZGSRAra$(2)) : _
            EXIT SUB
      IF ZWasBatchTransfer OR ZHighSpeedTransfer THEN _
         CALL TimeBack (2)
20708 WasX$ = ZDiskForDos$ + "C" + Ext$ + ZDefaultExtension$ + ".BAT"
      CALL FindIt (WasX$)
      IF NOT ZOK THEN _
         IF ZGetDescAfterTransfer THEN _
            GOTO 20740 _
         ELSE _
            GOTO 20712
      ZOutTxt$ = "Converting"
      IF Ext$ = ZDefaultExtension$ THEN _
         ZOutTxt$ = "Re-" + ZOutTxt$
      CALL QuickTPut1 (ZOutTxt$ + " upload to "+ZDefaultExtension$+".  Please wait...")
      CALL ReadDir (2,1)
      IF EOF(2) THEN _
         WasX$ = ZOutTxt$
      ZGSRAra$(1) = ZFileName$
      CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZTrue)
      ZFileNameHold$ = Body$ + "." + ZDefaultExtension$
      ZUserIn$(0) = ZFileName$
      ZFileName$ = Pre$ + ZFileNameHold$
      CALL ShellExit (WasX$ + " " + Body$ + " " + ZNodeID$)
      CALL FindIt (ZFileName$)
      IF NOT ZOK THEN _
         ZFileName$ = ZGSRAra$(1) : _
         CALL FindIt (ZFileName$) : _
         ZFileNameHold$ = Body$ + Ext$ : _
         IF ZOK THEN _
            ZFileName$ = ZFileNameHold$
      IF ZGetDescAfterTransfer THEN _
         GOTO 20740
      GOTO 20712
20710 ZAlreadyGiven = ZFalse
      ZAbort = ZFalse
      UsingDIZ = ZFalse
      CALL QuickTPut1 (ZFGE$ + "Describe " + ZFGF$ + ZFileNameHold$ + ZEmphasizeOff$)
      ZOutTxt$ = ZFGE$ + "(Begin with '" + ZFGF$ + "/" + ZFGE$ + "' if for SysOp only)."
      IF NOT ZFoundExtra AND NOT ZGetDescAfterTransfer THEN _
         ZOutTxt$ = ZOutTxt$ + "  Enter" + ZFGF$ + " ABORT " + ZFGE$ + _
                    "to cancel." + ZEmphasizeOff$
      CALL QuickTPut1 (ZOutTxt$)
      CALL QuickTPut1 (ZFG1$ + LEFT$("          Min                                       ", _
                 ZMaxDescLen) + "Max" + ZEmphasizeOff$)
      CALL QuickTPut1 (ZFGE$ + LEFT$(" |----+---1+0---+---2+0---+---3+0---+---4+0---+----|", _
                 ZMaxDescLen) + "-|" + ZEmphasizeOff$)
      CALL QuickTPut (ZFG1$ + "? " + ZEmphasizeOff$,0)
      ZOutTxt$ = ""
      ZSubParm = 1
      ZParseOff = ZTrue
      CALL TGet
      CALL Carrier
      IF ZSubParm = -1 THEN _
         ZDesc$ = " >>> Description Unavailable <<< " : _
         ZUCat$ = "***" : _
         ZWhoTo$ = "SYSOP" : _
         GOTO 20722
      TempUserIn$ = ZUserIn$
      CALL AllCaps (TempUserIn$)
      IF TempUserIn$ = "ABORT" THEN _
         IF ZGetDescAfterTransfer THEN _
            GOTO 20710 _
         ELSE _
            ZAbort = ZTrue : _
            TempUserIn$ = "" : _
            EXIT SUB
      IF LEFT$(TempUserIn$,10) = "          " THEN _
         CALL SkipLine(1) : _
         CALL QuickTPut1 (ZFGF$ + "Blank Spaces " + ZFGC$ + _
                        "ARE NOT" + ZFGF$ + " a Description!" + _
                         ZEmphasizeOff$) : _
         CALL SkipLine (1) : _
         GOTO 20710
      IF LEN(ZUserIn$) > ZMaxDescLen OR LEN(ZUserIn$) < 10 THEN _
         CALL Skipline (1) : _
         CALL QuickTPut1 (ZFGC$ + "10" + ZFGF$ + " chars min," + _
                         ZFGE$ + STR$(ZMaxDescLen) + ZFGF$ + " max") : _
         CALL SkipLine (1) : _
         GOTO 20710
      GOTO 20713
20712 ZOK = 0
      CALL CheckNovell (ZOK)
      IF ZOK <> -1 THEN _
         CALL SetSharedAttr (ZFileName$, ZOK) : _
         IF ZOK <> 0 THEN _
            CALL PScrn ("Error setting to shared")
      UsingDIZ = ZFalse
      DIZTemp$ = ZNodeWorkDrvPath$ + "NODE" + ZNodeID$ + ".DIZ"
      IF ZWhoTo$ = "ALL" THEN
         CALL FindItX (DIZTemp$,7)
         IF ZOK THEN
            UsingDIZ = ZTrue
            ZGetExtDesc = ZTrue
            IF LEFT$(ZDesc$,1) <> "/" AND LEFT$(ZDesc$,1) <> "\" THEN
               LINE INPUT #7,Temp$
               CALL RemNonAlf (Temp$,31,166)
               DO WHILE LEN(Temp$) < ZMaxDescLen AND NOT EOF(7)
                  LINE INPUT #7,ZOutTxt$(1)
                  Temp$ = Temp$ + " " + ZOutTxt$(1)
                  CALL RemNonAlf (Temp$,31,166)
               LOOP
               IF LEN(Temp$) > ZMaxDescLen THEN
                  IF MID$(Temp$,ZMaxDescLen + 1,1) <> " " THEN
                     ZDesc$ = MID$(Temp$,1,ZMaxDescLen)
                     FOR X = ZMaxDescLen TO 1 STEP - 1
                     IF MID$(ZDesc$,X,1) <> " " THEN _
                        ZDesc$ = MID$(ZDesc$,1,X - 1) _
                     ELSE _
                        X = 1
                     NEXT
                  ELSE
                     ZDesc$ = MID$(Temp$,1,ZMaxDescLen)
                  END IF
                  IF LEN(ZDesc$) < 2 THEN _
                     ZDesc$ = MID$(Temp$,1,ZMaxDescLen)
               ELSE
                  ZDesc$ = Temp$
               END IF
            END IF
            WasLL = ZRightMargin
            ZRightMargin = 30 + ZMaxDescLen
            IF ZRightMargin > 74 THEN _
               ZRightMargin = 74
            LinesInDesc = 0
            WHILE NOT EOF(7) AND LinesInDesc < ZMaxExtendedLines
               LinesInDesc = LinesInDesc + 1
               LINE INPUT #7,ZOutTxt$(LinesInDesc)
               IF LinesInDesc = 1 THEN _
                  IF LEN(Temp$) > ZMaxDescLen THEN _
                     ZOutTxt$(LinesInDesc) = MID$(Temp$,LEN(ZDesc$) + 1) + " " + _
                                              ZOutTxt$(LinesInDesc)
               Temp$ = ZOutTxt$(LinesInDesc)
               I = 1
               L = LEN(Temp$)
               WHILE I <= L
                  C$ = MID$(Temp$,I,1)
                  IF ASC(C$) = 32 THEN
                     IF I = 1 THEN _
                        Temp$ = MID$(Temp$,2,L - 1) : _
                        L = L - 1 : _
                        I = I - 1 _
                     ELSE _
                        IF I = L THEN _
                           Temp$ = MID$(Temp$,1,L - 1) _
                     ELSE _
                        IF ASC(MID$(Temp$,I + 1,1)) < 33 OR _
                          ASC(MID$(Temp$,I + 1,1)) > 166 THEN _
                           Temp$ = MID$(Temp$,1,I - 1) + MID$(Temp$,I + 1,L - I) : _
                           L = L - 1 : _
                           I = I - 1
                     ZOutTxt$(LinesInDesc) = Temp$
                  ENDIF
                  IF ASC(C$) < 32 OR ASC(C$) > 166 THEN
                     IF I = 1 THEN _
                        Temp$ = MID$(Temp$,2,L - 1) : _
                        L = L - 1 : _
                        I = I - 1 _
                     ELSE _
                        IF I = L THEN _
                           Temp$ = MID$(Temp$,1,L - 1) _
                     ELSE _
                        Temp$ = MID$(Temp$,1,(I - 1)) + MID$(Temp$,(I + 1),(L - I)) : _
                        L = L - 1 : _
                        I = I - 1
                     ZOutTxt$(LinesInDesc) = Temp$
                  ENDIF
                  I = I + 1
               WEND
               IF LEN(ZOutTxt$(LinesInDesc)) < 1 THEN _
                  LinesInDesc = LinesInDesc - 1 _
               ELSE _
               IF LEN(ZOutTxt$(LinesInDesc - 1)) < (ZRightMargin - 10) AND _
                  LinesInDesc > 1 THEN _
                  ZOutTxt$(LinesInDesc - 1) = ZOutTxt$(LinesInDesc - 1) + _
                     " " + ZOutTxt$(LinesInDesc) : _
                  ZOutTxt$(LinesInDesc) = "" : _
                  ZOutTxt$(LinesInDesc + 1) = "" : _
                  LinesInDesc = LinesInDesc - 1
            WEND
            IF LinesInDesc = 0 AND LEN(ZDesc$) > 0 AND EOF(7) AND _
                LEN(Temp$) > ZMaxDescLen AND ZMaxExtendedLines > 0 THEN _
               LinesInDesc = 1 : _
               ZOutTxt$(LinesInDesc) = MID$(Temp$,LEN(ZDesc$) + 1)
            CLOSE 7
            CALL WordWrap (ZRightMargin,LinesInDesc,ZOutTxt$())
            CALL KillWork (DIZTemp$)
            IF ZGetDescAfterTransfer THEN _
               RETURN
            CALL QuickTPut1 (ZEmphasizeOn$ + _
               "Using Description contained within archive." + _
                ZEmphasizeOff$)
            GOSUB 20717
            ZGetExtDesc = ZFalse
            ZRightMargin = WasLL
            GOTO 20726
         END IF
      END IF
      CALL FindFile (DIZTemp$,ZOK)
      IF ZOK THEN _
         CALL KillWork (DIZTemp$)
      IF ZGetDescAfterTransfer THEN _
         RETURN
      IF ZGetExtDesc THEN _
         EXIT SUB
      GOSUB 20717
      GOTO 20726
20713 ZDesc$ = ZUserIn$
      IF NOT ZLimitSearchToFMS THEN
         IF ZFMSDirectory$ <> ZUpldDir$ THEN
            IF LEFT$(ZUserIn$,1) = "/" OR LEFT$ (ZUserIn$,1) = "\" THEN
               IF ZGetDescAfterTransfer THEN
                  GOTO 20722
               ELSE
                  GOSUB 20739
                  GOTO 20722
               END IF
            ELSE
               GOTO 20718
            END IF
         END IF
      END IF
20715 IF LEFT$(ZUserIn$,1) = "/" OR LEFT$(ZUserIn$,1) = "\" THEN _
         ZUCat$ = "***" : _
         IF ZGetDescAfterTransfer THEN _
            GOTO 20722 _
         ELSE _
            GOSUB 20739 : _
            GOTO 20722
      ZUCat$ = ZDefaultCatCode$
      GOTO 20718
20717 CALL FindItX (ZNodeWorkFile$,7)
      ZUserIn$ = ZDesc$
      WasX$ = DATE$
      ZWasZ$ = LEFT$(WasX$,6) + _
           RIGHT$(WasX$,2)
      NumPersonals = 0
      IF NOT ZOK THEN _
         GOTO 20723
      UserFileIndexSave = ZUserFileIndex
      UserRecordHold$ = ZUserRecord$
      WHILE NOT EOF(7)
         CALL ReadParmsX (7,ZWorkAra$(),2,1)
         IF LEFT$(ZWorkAra$(1),4) <> "ALL " AND ZWorkAra$(1) <> "ALL" THEN _
            ZWasEN$ = ZPersonalDir$ : _
            NumPersonals = NumPersonals + 1 : _
            ZUCat$ = ZWorkAra$(1) : _
            GOSUB 20737 : _
            GOSUB 20730 : _
            RcvrRecNum = VAL (ZWorkAra$(2)) : _
            CALL SetUserFlag (RcvrRecNum,4096,"file") : _
            ZWasY$ = ZFileNameHold$ + " ^Uploaded^ to " + ZWorkAra$(1) : _
            CALL UpdtCalr(ZWasY$,1)
      WEND
      CLOSE 7
      IF NumPersonals > 0 THEN _
         ZUserFileIndex = UserFileIndexSave : _
         LSET ZUserRecord$ = UserRecordHold$ : _
         NumPersonals = 0 : _
         GOTO 20726
      GOTO 20723
20718 IF NOT ZGetDescAfterTransfer THEN _
         GOSUB 20739
      IF ZSubParm = -1 OR _
         ZUserSecLevel < ZSLCategorizeUplds THEN _
         GOTO 20722
20719 IF ZWhoTo$ <> "ALL" THEN _
         GOTO 20722
      TempIndex = ZLastIndex
      CALL BufFile (ZUpcatHelp$,WasX,ZFalse)
      ZLastIndex = TempIndex
20720 ZOutTxt$= "Upload best fits what category (D=default,H=help)"
      ZSubParm = 1
      CALL TGet
      CALL AraAllCaps (ZUserIn$(),1)
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF ZUserIn$(1) = "D" THEN _
         ZUCat$ = ZDefaultCatCode$ : _
         GOTO 20722
      IF ZWasQ = 0 THEN _
         GOTO 20719
      IF ZUserIn$(1) = "H" OR _
         ZUserIn$(1) = "*" OR _
         ZUserIn$(1) = "?" THEN _
         GOTO 20719
      CALL SearchArray (ZUserIn$(1),ZCategoryName$(),ZNumCategories,Found)
      IF Found > 0 THEN _
         ZUCat$ = ZCategoryCode$(Found) : _
         IF LEN(ZUCat$) > 0 AND LEN(ZUCat$) < 4 AND INSTR(ZUCat$,",") = 0 THEN _
            GOTO 20722
      ZUCat$ = ""
      IF NOT ZLimitSearchToFMS THEN _
         StrewTo$ = ZDirPath$ + _
                     ZUserIn$(1) + _
                     "." + _
                     ZDirExtension$ : _
         CALL FindIt (StrewTo$) : _
         IF ZOK THEN _
            GOTO 20722 _
         ELSE CALL WordInFile (ZUpcatHelp$,ZUserIn$(1),ZOK) : _
              IF ZOK THEN _
                 GOTO 20722
      StrewTo$ = ""
      CALL QuickTPut1 ("No such category " + ZUserIn$(1))
      GOTO 20719
20722 IF NOT ZGetDescAfterTransfer THEN _
         IF ZUpBatchTransfer THEN _
            CALL FileLister (1) : _
            EXIT SUB _
         ELSE CALL FileLister (1)
      IF ZUserSecLevel >= ZAskExtendedDesc AND ZWhoTo$ = "ALL" AND _
         ZMaxExtendedLines > 0 AND ZSubParm <> -1 AND NOT ZFoundExtra AND _
             NOT UsingDIZ THEN
         ZOutTxt$ = "Add an extended description of " + _
              ZFileNameHold$ + " ([Y],N)"
         ZTurboKey = -ZTurboKeyUser
         ZSubParm = 1
         CALL TGet
         IF ZSubParm <> -1 THEN
            IF NOT ZNo THEN
               IF ZGetDescAfterTransfer THEN
                  ZGetExtDesc = ZTrue
               ELSE
                  CALL SkipLine (2)
                  CALL QuickTPut1 ( ZFG9$ + " Description will be entered " + _
                  ZFG7$ + "AFTER" + ZFG9$ + " the " + ZFG7$ + "UPLOAD" + ZFG9$ + _
                  " is completed" + ZEmphasizeOff$ + ZCrLF$)
                  CALL DelayTime (2)
                  ZGetExtDesc = ZTrue
               END IF
            END IF
         END IF
      END IF
      IF ZGetDescAfterTransfer THEN _
         RETURN _
      ELSE EXIT SUB
20723 ZUserIn$ = ZDesc$
      WasX$ = DATE$
      ZWasZ$ = LEFT$(WasX$,6) + _
           RIGHT$(WasX$,2)
      ZWasEN$ = StrewTo$
      GOSUB 20730
      ZWasEN$ = ZAllwaysStrewTo$
      GOSUB 20730
20725 IF ZPrivateDoor THEN _
         ZWasEN$ = ZUpldDoor$ _
      ELSE ZWasEN$ = ZUpldDir$
      GOSUB 20730
20726 ZWasDF$ = " >> uploaded << "
      CALL AMorPM
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)
      ZWasZ$ = WasX$ + Extension$ + ZWasDF$ + " at " + ZTime$ + _
               " using " + ZWasFT$ + STR$(ZBytesInFile#)
      CALL UpdtCalr (ZWasZ$,2)
      ZUplds = ZUplds + 1
      ZGlobalUplds = ZGlobalUplds + 1
      ZULBytes! = ZULBytes! + ZBytesInFile#
      ZGlobalULBytes! = ZGlobalULBytes! + ZBytesInFile#
      CALL Muzak (7)
      IF ZHighSpeedTransfer OR ZWasBatchTransfer THEN _
         ZAlreadyGiven = ZFalse
      IF NOT ZAlreadyGiven THEN
      CALL TimeRemain (MinsRemaining)
      MinsToAdd = WasX! / 60
      CALL ChkAddedTime (MinsToAdd)
      WasX! = MinsToAdd * 60!
      ZTimeCredits! = ZTimeCredits! + WasX!
      ZSecsPerSession! = ZSecsPerSession! + WasX!
      IF ZHighSpeedTransfer OR ZWasBatchTransfer THEN _
         WasX! = WasX! / 60.0 : _
         GOTO 20727
      IF ZPrivateDoor THEN _
         WasX! = (WasX! - ZWasQ!) / 60 _
      ELSE WasX! = (WasX! - ZSecsUsedSession! + ZWasQ!)/60.0
20727 WasX$ = STR$(FIX(WasX!*10.0))
      WasX$ = LEFT$(WasX$,LEN(WasX$)-1) + "." + RIGHT$(WasX$,1)
      IF WasX! > 1 THEN _
         IF ZHighSpeedTransfer THEN _
            CALL QuickTPut1 (ZFG9$ + "Upload Time Credit of " + WasX$ + _
                        " minutes returned." + ZEmphasizeOff$) _
         ELSE _
            CALL QuickTPut1 (ZFG9$ + "Increased session time by" + ZFG7$ + _
                        WasX$ + ZFG9$ + " minutes" + ZEmphasizeOff$)
      ZAlreadyGiven = ZTrue
      END IF
      CALL QuickTPut1 (ZFG8$ + "Thanks for the upload!" + ZEmphasizeOff$)
      ZMenuNewUpld = ZMenuNewUpld + 1
      ZGetExtDesc = ZFalse
      ZPrivateDoor = ZFalse
      EXIT SUB
20730 '          ---[ lock file ]---
      IF ZWasEN$ = "" THEN _
         RETURN
      FMSFormat = ZFalse
      IF (ZWasEN$ = ZFMSDirectory$ OR ZLimitSearchToFMS _
          OR NumPersonals > 0 OR (ZPrivateDoor AND ZFMSDoor)) THEN _
             FMSFormat = ZTrue _
      ELSE CALL FindIt (ZWasEN$) : _
           IF ZOK THEN _
              CALL ReadDir (2,1) : _
              IF ZErrCode = 0 THEN _
                 FMSFormat = (LEFT$(ZOutTxt$,4) = "\FMS")
      IF NOT FMSFormat THEN _
         ReadBackwards = ZFalse : _
         FixedLen = 0 : _
         ZUserIn$ = ZDesc$ : _
         GOTO 20731
      FixedLen = 34 + ZMaxDescLen
      IF NumPersonals > 0 THEN _
         WasX$ = "*" : _
         MaxLen = ZPersonalLen _
      ELSE MaxLen = 3 : _
           WasX$ = ""
      ZUCat$ = LEFT$(ZUCat$,MaxLen)
      ZUCat$ = ZUCat$ + SPACE$(MaxLen - LEN(ZUCat$))
      ZUserIn$ = ZDesc$ + _
                 SPACE$(ZMaxDescLen - LEN(ZDesc$)) + _
                 ZUCat$ + WasX$
      ReadBackwards = ZTrue
      CALL FindIt (ZWasEN$)
      IF ZOK THEN _
         CALL ReadDir (2,1) : _
         IF ZErrCode = 0 THEN _
            ReadBackwards = (INSTR(ZOutTxt$," TOP ") = 0)
20731 CALL LockAppend
      IF ZErrCode <> 0 THEN _
         GOTO 20732
      IF ReadBackwards THEN
         IF (ZNoWUW <> ZTrue) THEN _
            GOSUB 20745                   ' Uploaded by
         IF ZGetExtDesc THEN
            FOR WasI = LinesInDesc TO 1 STEP -1
                GOSUB 20733
            NEXT
         END IF
         GOSUB 20746
      ELSE
         GOSUB 20746
         IF ZGetExtDesc THEN
            FOR WasI = 1 TO LinesInDesc
                GOSUB 20733
            NEXT
         END IF
         IF (ZNoWUW <> ZTrue) THEN _
            GOSUB 20745                   ' Uploaded by
      END IF
20732 CALL UnLockAppend
      FixedLen = 0
      RETURN
20733 WasX$ = ZOutTxt$(WasI)
      CALL Trim (WasX$)
      IF WasX$ = "" THEN _
         RETURN
      IF NOT FMSFormat THEN _
         PRINT #2,"  ";ZOutTxt$(WasI) : _
         RETURN
      IF FixedLen > LEN(ZOutTxt$(WasI)) THEN _
         WasX$ = SPACE$(FixedLen - 1 - LEN(ZOutTxt$(WasI))) + "." _
      ELSE WasX$ = ""
      PRINT #2, "  ";LEFT$(ZOutTxt$(WasI),FixedLen);WasX$
      RETURN
20734 CALL FindIt (ZFileName$)
20736 IF NOT ZOK THEN _
         ZBytesInFile# = 0.0 _
      ELSE ZBytesInFile# = LOF(2)
      IF ZBytesInFile# < 2.0 THEN _
         ZGetExtDesc = ZFalse : _
         CLOSE 2 : _
         EXIT SUB
      CLOSE 2
      RETURN
20737 CALL CheckInt (ZUCat$)
      IF ZTestedIntValue > 0 THEN _
         ZUCat$ = " " + ZUCat$
      RETURN
20738 WasX! = ZBytesInFile# / _
        (VAL(MID$("00000300045012002400480072009601200144016801920216024002640288038405760", -4 * ZCBPS,4)) * ZSpeedFactor!)
      IF ZHighSpeedTransfer THEN _
         HSFactor = ZUpldTimeFactor! - 1 _
      ELSE _
         HSFactor = ZUpldTimeFactor!
      IF HSFactor < 0 THEN _
         HSFactor = 0
      WasX! = FIX(WasX!) * HSFactor
      RETURN
20739 IF NOT ZWhoToSet THEN
         ZWhoTo$ = ""
         WasY$ = ZFileName$
         CALL KillWork (ZNodeWorkfile$)
         CALL CmdStackPushPop (1)
         ZLastIndex = 0
         IF ZUserSecLevel >= ZMinSecPersUpld THEN _
            CALL SetWhoTo (ZTrue,ZWhoTo$,"",RcvrRecNum,Found,ZTrue,_
                           FirstLineText$,SecondLineText$,AddressLine) _
         ELSE ZWhoTo$ = "ALL"
         CALL CmdStackPushPop (2)
         ZWhoToSet = ZTrue
         ZFileName$ = WasY$
      END IF
      IF ZWhoTo$ <> "ALL" AND NOT ZAddingDescOnly AND NOT ZGetDescAfterTransfer THEN _
         ZUpldSubDir$ = ZPersonalDrvPath$ : _
         CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZTrue) : _
         ZFileName$ = ZUpldSubDir$ + Body$ + Ext$
      RETURN
20740 ZWhoToSet = ZFalse
      ZWhoTo$ = ""
      ZGetExtDesc = ZFalse
      GOSUB 20739
      GOSUB 20712
      IF UsingDIZ THEN _
         ZUserIn$ = ZDesc$ : _
         GOSUB 20713 _
      ELSE _
         GOSUB 20710
      IF ZGetExtDesc AND NOT UsingDIZ THEN
         ZMsgHeader$ = "Extended Description for " + ZFileNameHold$
         ZSysopComment = ZTrue
         WasLL = ZRightMargin
         ZRightMargin = 30 + ZMaxDescLen
         IF ZRightMargin > 74 THEN _
            ZRightMargin = 74
         ZMaxMsgLines = ZMaxExtendedLines
         MParm = 12
         CALL MsgSys (MParm,ActionFlag,LogOff$,LogonMailNew,UtilMarginChange,MsgSec,UserCanReadMsg)
         ZMaxMsgLines = ZMaxMsgLinesDef
         ZRightMargin = WasLL
         GOTO 20723
      END IF
      IF UsingDIZ THEN _
         CALL QuickTPut1 (ZEmphasizeOn$ + _
               "Using Description contained within archive." + _
                  ZEmphasizeOff$) : _
         ZMaxMsgLines = ZMaxMsgLinesDef : _
         ZRightMargin = WasLL
      GOTO 20717
20745 IF ZWhoToSet = ZTrue THEN _
         RETURN
      CALL FindFile (ZDirPath$ + "WUW.DEF",Found)
      IF Found THEN _
         CALL OpenWork (10,ZDirPath$ + "WUW.DEF",ZFalse) : _
         LINE INPUT #10,WasX$ : _
         CALL Trim (WasX$) : _
         CALL SmartText (WasX$,ZTrue,ZFalse) : _
         WasX$ = "  " + WasX$ + " " : _
         CLOSE 10 _
      ELSE WasX$ = "  Uploaded by:  "
      PRINT #2, using LEFT$("\                             " _
                          + "                              " _
                          + "                    ", _
                          ZMaxDescLen + 32) + "\  ."; _
                          WasX$ + ZActiveUserName$
      RETURN
20746 PRINT #2,USING "\           \########  &  &"; _
                     ZFileNameHold$; _
                     ZBytesInFile#; _
                     ZWasZ$; _
                     ZUserIn$
      RETURN
      END SUB
'
20747 ' $SUBTITLE: 'BadFile - subroutine to find bad file names'
' $PAGE
'
'  NAME    -- BadFile
'
'  INPUTS  --   PARAMETER                 MEANING
'               ZViolation$
'               ZViolationsThisSession
'               FilName$                  NAME OF FILE
'
'  OUTPUTS -- Result                      1 = FILE NAME IS OK
'                                         2 = CHARACTER NOT ALLOWED
'                                         3 = SYSTEM CRASH ATTEMPT
'             ZViolationsThisSession      NUMBER OF VIOLATIONS
'             FilName$                    GETS CAPITALIZED
'
'  PURPOSE -- To protect RBBS-PC against the use of bad file names
'             to either crash the system or to breach RBBS-PC's security.
'
' *  TEST FOR INVALID CHARACTERS IN FILENAME
'
      SUB BadFile (FilName$,Result) STATIC
      Result = 2
      IF LEN(FilName$) < 1 THEN _
         EXIT SUB
      CALL BadFileChar (FilName$,ZOK)
      IF NOT ZOK THEN _
         EXIT SUB
      CALL AllCaps (FilName$)
      WasXX = INSTR(FilName$,".")
      IF WasXX > 0 THEN _
         IF WasXX < LEN(FilName$) THEN _
            WasXX = INSTR(WasXX + 1,FilName$,".") : _
            IF WasXX > 0 THEN _
               EXIT SUB
      WasXX = LEN(FilName$)
      IF WasXX => 3 THEN _
         IF INSTR("PRN:CON:AUX:NUL:",FilName$) THEN _
            GOTO 20748
      IF WasXX => 4 THEN _
         IF INSTR("COM1:COM2:COM3:COM4:LPT1:LPT2:LPT3:SCRN:KYBD:CONS:",FilName$) THEN _
            GOTO 20748
      CALL BreakFileName (FilName$,Pre$,Body$,Ext$,ZFalse)
      IF LEN(Pre$) > 64 OR LEN(Body$) > 8 OR LEN(Body$) < 1 OR LEN(Ext$) > 3 THEN _
         EXIT SUB
      WasXX = LEN(Body$)
      IF WasXX => 3 THEN _
         IF INSTR("PRN:CON:AUX:NUL:",Body$) THEN _
            GOTO 20748
      IF WasXX => 4 THEN _
         IF INSTR("COM1:COM2:COM3:COM4:LPT1:LPT2:LPT3:SCRN:KYBD:CONS:",Body$) THEN _
            GOTO 20748
      Result = 1
      IF NOT ZSysOp AND ZViolation$ = "Upload " THEN _
         CALL DGSChkBadExt(Ext$, Body$,  Result)
      EXIT SUB
20748 ZViolationsThisSession = ZMaxViolations
      ZViolation$ = ZViolation$ + _
                   FilName$
      Result = 3
      END SUB
'
20750 ' Subroutine to Read the file BADEXTS located in the same dir
      ' as the .HLP files.  When the .EXT matches an extension in
      ' the BADEXTS file, call the DGSBadFileDisp routine to display
      ' the BADHELP?.HLP files
      '
      SUB DGSChkBadExt(DGSExt$,DGSBody$, DGSResult) STATIC
      DGSBadFileName$ = ZHelpPath$ + "BADEXTS"
      CALL FindIt (DGSBadFileName$)
      IF NOT ZOK THEN _
         ZOutTxt$ = DGSBadFileName$ + " NOT Found! - Extension Not Checked" : _
         CALL UpdtCalr(ZOutTxt$,1) : _
         EXIT SUB
      DGSFile = 2
20751 ZErrCode = 0
      Call OpenWork (DGSFile,DGSBadFileName$,ZFalse)
      WHILE NOT EOF(DGSFile)
            INPUT #DGSFile, DGSSecChk, DGSBadExt$, DGSDispFile$
            IF DGSExt$ = DGSBadExt$ AND ZUserSecLevel < DGSSecChk THEN _
               CLOSE DGSFile : _
               CALL DGSBadFileDisp (DGSResult, DGSDispFile$) : _
               ZOutTxt$ = "Attempted bad upload " + DGSBody$ + "." + DGSExt$ : _
               CALL UpdtCalr (ZOutTxt$,1) : _
               EXIT SUB
      WEND
      DGSResult = 1
      CLOSE DGSFile
      EXIT SUB
      END SUB
'
20775 ' Sub to display filename that is listed as 2nd parameter in
      ' the file BADEXTS.  This filename has to be 7 characters or
      ' less so that RBBS can call the normal, ascii or color file.
      ' These file are to be located in same directory as .hlp files
      '
      SUB DGSBadFileDisp(DGSResult2, DGSDisp$) STATIC
      ZFFileName$ = ZHelpPath$ + DGSDisp$
      CALL FindIt (ZFFileName$)
      IF NOT ZOK THEN _
         ZFFileName$ = "BADFILE.HLP" : _
         CALL FindIt (ZFFileName$) : _
         IF NOT ZOK THEN _
            ZOutTxt$ = "Cannot find " + ZHelpPath$ + "BADFILE.HLP" : _
            CALL UpdtCalr (ZOutTxt$,1) : _
            EXIT SUB
      CALL Graphic (ZFFileName$,ZTrue)
      ZNonStop = ZTrue
      CALL BufFile (ZFFileName$, ZWasX,ZFalse)
      DGSResult2 = 2
      END SUB
'
21598 ' $SUBTITLE: 'XferType - sub to identify file xfer protocol'
' $PAGE
'
'  NAME    -- XferType
'
'  INPUTS  --     PARAMETER                    MEANING
'               Index            = 1       MANUAL SELECT FOR UP/DOWNLOAD
'                                = 2       DEFAULT SELECT
'                                = 3       SET TRANSFER DEFAULT
'               ZOutTxt$
'               ZUserIn$(1)
'               ZWasQ
'               ZReliableMode
'               ZTransferOption$
'               ZUserXferDefault$
'               ZXferSupport
'
'  OUTPUTS   -- ZCheckSum
'               ZFLen
'               ZWasFT$
'
'  PURPOSE -- To identify the file transfer protocol (either
'             from the user's default or via explicit selection)
'
      SUB XferType (Index,SkipHelp) STATIC
      IF ZTransferOption$ = "" OR ZUserSecLevel <> PrevUSL OR PrevDef$ <> ZProtoDef$ OR ZHighSpeedTransfer THEN _
         CALL Protocol : _
         PrevDef$ = ZProtoDef$ : _
         PrevUSL = ZUserSecLevel
      WasX$ = ZOutTxt$ + "Protocol"
      ON Index GOTO 21600,21620,21600
'
' *  MANUAL SELECT OF Transfer Protocol
'
21600 IF SkipHelp THEN _
         GOTO 21604
21602 CALL BufFile (ZHelpPath$ + "UF" + ZHelpExtension$,WasX,ZFalse)
      IF ZSubParm = -1 THEN _
         EXIT SUB
21604 ZStopInterrupts = ZTrue
      IF Index = 3 THEN _
         IF ZAnsIndex < ZLastIndex THEN _
            GOTO 21605
      CALL QuickTPut1 (WasX$)
      CALL BufString (ZTransferOption$,4096,WasX)
      CALL QuickTPut (MID$("?!",1-ZTurboKeyUser,1)+" ",0)
21605 ZOutTxt$ = ""
      ZTurboKey = -ZTurboKeyUser
      ZMacroMin = 2
      ZSubParm = 1
      ZSuspendAutoLogoff = ZTrue
      ZStackC = ZTrue
      IF Index = 3 THEN _
         CALL PopCmdStack : _
         WasX = ZAnsIndex _
      ELSE ZSubParm = 1 : _
           CALL TGet : _
           WasX = 1
      ZSuspendAutoLogoff = ZFalse
      IF ZSubParm = -1 THEN _
         EXIT SUB
'
' * USE [ENTER] to Cancel instead on "N"one
'
      IF ZWasQ = 0 THEN
          ZAnsIndex = 1
          WasX = 1
          ZWasZ$ = ZUserXferDefault$
          ZUserIn$(WasX) = "N"
          GOTO 21610
      END IF
21606 ZWasZ$ = ZUserIn$(WasX)
'
' *  DEFAULT SELECT OF Transfer Protocol
'
21610 CALL AllCaps (ZWasZ$)
      ZFF = INSTR(ZDefaultXfer$,ZWasZ$)
      IF ZFF > 0 THEN _
         GOTO 21612
      IF INSTR("H?",ZWasZ$) > 0 THEN _
         GOTO 21602
      GOTO 21600
21612 ZWasFT$ = MID$(ZDefaultXfer$,ZFF,1)
      ZInternalProt$ = MID$(ZInternalEquiv$,ZFF,1)
      GOTO 21621
21620 ZFF = -1
      IF ZCmdTransfer$ <> "" THEN _
         ZWasZ$ = ZCmdTransfer$ : _
         GOTO 21610
      WasX = INSTR(ZDefaultXfer$,ZUserXferDefault$)
      IF WasX > 0 THEN _
         IF MID$(ZInternalEquiv$,WasX,1) <> "N" THEN _
            ZWasZ$ = ZUserXferDefault$ : _
            GOTO 21610
      ZProtoPrompt$ = "None"
      ZFF = 0
      EXIT SUB
21621 IF ZFF = PrevFF AND PrevProtoDef$ = ZProtoDef$ THEN _
         ZProtoPrompt$ = PrevProtoPrompt$ : _
         EXIT SUB
      PrevFF = ZFF
      PrevProtoDef$ = ZProtoDef$
      ZInternalProt$ = MID$(ZInternalEquiv$,ZFF,1)
      ZCheckSum = (ZInternalProt$ = "X")
      CALL FindIt (ZProtoDef$)
      IF ZOK THEN _
         GOTO 21623
      WasX = INSTR("AXCYN",ZInternalProt$)
      IF WasX < 1 THEN _
         ZInternalProt$ = "N"
      ZProtoPrompt$ = MID$("Ascii     Xmodem    Xmodem/CRCYmodem    None",10*INSTR("AXCYN",ZInternalProt$)-9,10)
      CALL TrimTrail (ZProtoPrompt$," ")
      ZCheckSum = (ZInternalProt$ = "X")
      ZFLen = 128 - 896 * (ZInternalProt$ = "Y")
      ZBlockSize = ZFLen
      IF ZInternalProt$ = "Y" THEN _
         ZSpeedFactor! = 0.87 _
      ELSE IF ZInternalProt$ = "A" THEN _
         ZSpeedFactor! = 0.92 _
      ELSE ZSpeedFactor! = 0.78
      GOTO 21625
21623 CALL ReadParms (ZWorkAra$(),13,ZFF)
      IF ZErrCode > 0 THEN _
         ZFF = LEN(ZDefaultXfer$) : _
         ZProtoPrompt$ = "None" : _
         GOTO 21625
      ZProtoPrompt$ = ZWorkAra$(1)
      IF LEN(ZProtoPrompt$) > 2 THEN _
         IF MID$(ZProtoPrompt$,2,1) = ")" THEN _
            ZProtoPrompt$ = LEFT$(ZProtoPrompt$,1) + MID$(ZProtoPrompt$,3)
      WasX = INSTR(ZProtoPrompt$+ZCrLf$,ZCrLf$)
      ZProtoPrompt$ = LEFT$(ZProtoPrompt$,WasX-1)
      CALL Trim (ZProtoPrompt$)
      ZProtoMethod$ = ZWorkAra$(3)
      CALL AllCaps (ZProtoMethod$)
      ZReq8Bit = (LEFT$(ZWorkAra$(4),1) = "8")
      ZDownTemplate$ = ZWorkAra$(12)
      ZUpTemplate$ = ZWorkAra$(13)
      WasX$ = ZWorkAra$(11)
      WasX = INSTR(WasX$,"=")
      ZAdvanceProtoWrite = ZFalse
      IF WasX < 2 OR WasX >= LEN(WasX$) THEN
         ZFailureParm = 4
         ZFailureString$ = "F"
      ELSE ZFailureParm = VAL(LEFT$(WasX$, WasX - 1))
           IF INSTR(WasX$, "-") THEN
              ZFailureString$ = MID$(WasX$, WasX + 1, INSTR(WasX$, "-") - (WasX + 1))
              ZFilePosition = VAL(MID$(WasX$, INSTR(WasX$, "-") + 1, LEN(WasX$)))
           ELSE
              ZFailureString$ = MID$(WasX$, WasX + 1)
              ZFilePosition = 11
           END IF
           WasX = INSTR(ZFailureString$, "=")
           IF WasX > 0 THEN
              ZAdvanceProtoWrite = (MID$(ZFailureString$, WasX, 2) = "=A")
              ZFailureString$ = LEFT$(ZFailureString$, WasX - 1)
           END IF
      END IF
      ZProtoMacro$ = ZWorkAra$(10)
      ZFakeXRpt = (LEFT$(ZWorkAra$(8),1) = "F")
      ZBatchProto = (LEFT$(ZWorkAra$(6),1) = "B")
      ZHighSpeedTransfer = (LEFT$(ZWorkAra$(5),1) = "H")
      ZExtFileSysProcessor = (RIGHT$(ZWorkAra$(5),1) = "N")
      IF ZExtFileSysProcessor THEN _
         ZGetDescAfterTransferSave = ZGetDescAfterTransfer : _
         ZGetDescAfterTransfer = ZTrue
      ZSpeedFactor! = VAL(ZWorkAra$(9))
      IF ZSpeedFactor! < 0.1 THEN _
         ZSpeedFactor! = 0.87
      ZBlockSize = VAL(ZWorkAra$(7))
      ZFLen = ZBlockSize
      IF ZFLen < 1 THEN _
         ZFLen = 128
21625 PrevProtoPrompt$ = ZProtoPrompt$
      END SUB
'
21993 ' $SUBTITLE: 'FileLock - subroutine to share RBBS-PC files'
' $PAGE
'
'  NAME    -- FileLock
'
'  INPUTS  --     PARAMETER                    MEANING
'             ZSubParm               = 1 UNLOCK USERS AND MESSAGES
'                                      2 FLUSH MESSAGE RECORD TO DISK
'                                        AND UNLOCK MESSAGES
'                                      3 LOCK MESSAGE FILE
'                                      4 UNLOCK MESSAGE FILE
'                                      5 LOCK USER FILE
'                                      6 LOCK 4 RECORD BLOCK IN USER
'                                        FILE
'                                      7 UNLOCK USER FILE
'                                      8 UNLOCK 4 RECORD BLOCK IN USER
'                                        FILE
'                                      9 LOCK UPLOAD DIRECTORY OR
'                                        COMMENTS FILE
'                                     10 UNLOCK UPLOAD DIRECTORY OR
'                                        COMMENTS FILE
'               Active.Message.File$     NAME OF MESSAGE FILE
'               ZActiveUserFile$         NAME OF USER FILE
'               Config.File.Name$        FILE NAME TO FLUSH RECORD FROM
'               ZWasEN$                  UPLOAD DIRECTORY OR COMMENTS
'                                        FILE NAME TO LOCK/UNLOCK
'               ZNetworkType             TYPE OF NETWORK LOCKING TO USE
'
'  OUTPUTS -- ZSubParm              = -1 TERMINATE RBBS-PC IMMEDATELY
'             ZBlk
'             ZLockDrive
'             ZLockFileName$
'             ZLockStatus$
'             ZMsgFileLock
'             ZUserBlockLock
'             ZUserFileLock
'             ZUserFileIndex
'
'  PURPOSE -- To lock and unlock the shared RBBS-PC files when
'             multiple copies of RBBS-PC are sharing the same
'             files in either a multi-tasking DOS environment or
'             in a local area network environment
'
      SUB FileLock STATIC
      ON ZSubParm GOSUB 21995,21996,22000,25000,26000, _
                                    26500,27000,27500,29000,29500
      EXIT SUB
'
'
' *  UNLOCK USERS AND MESSAGES
'
'
21995 GOSUB 27000
      GOSUB 25000
      RETURN
'
'
' *  FLUSH MESSAGE FILE DATA TO DISK BY OPENING DUMMY FILE # 1
'
'
21996 CLOSE 1
      IF ZShareIt THEN _
         OPEN ZConfigFileName$ FOR INPUT SHARED AS #1 _
      ELSE OPEN "I",1,ZConfigFileName$
'
'
' *  UNLOCK MESSAGES
'
'
      GOSUB 25000
      CALL OpenMsg
      RETURN
'
'
' *  LOCK MESSAGE FILE
'
'
22000 IF ZMsgFileLock = ZTrue THEN _
         RETURN
      ZMsgFileLock = ZTrue
      MID$(ZLockStatus$,1,2) = "LM"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZActiveMessageFile$
      ON ZNetworkType GOTO 22100,22200,22300,22400,22500,29700,29700
      RETURN
'
'
' *  LOCK MESSAGE FILE (MULTI-LINK)
'
'
22100 RETURN
'
'
' *  LOCK MESSAGE FILE (OMNINET)
'
'
22200 CALL BreakFileName (ZActiveMessageFile$,Drive$,Prefix$,Ext$,ZFalse)
      WasCC$ = CHR$(1) + _
            LEFT$(Prefix$ + SPACE$(8),8)
      GOSUB 28000
      IF WasCT = 0 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 22200
'
'
' *  LOCK MESSAGE FILE (ORCHID PC-NET)
' *  LOCK USER FILE (ORCHID PC-NET)
' *  LOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (ORCHID PC-NET)
'
'
22300 GOSUB 28100
      CALL LPLKIT(ZLockDrive,ZLockFileName$,ZWasA)
      RETURN
'
'
' *  LOCK SYSTEM (DESQview)
'
'
22400 CALL DVLock("MESSAGE")
      RETURN
'
'
' *  LOCK MESSAGE FILE (10 NET)
' *  LOCK USER FILE (10 NET)
' *  LOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (10 NET)
'
'
22500 GOSUB 28100
      CALL LPLK10(ZLockDrive,ZLockFileName$,ZWasA)
      RETURN
'
'
' *  UNLOCK MESSAGE FILE
'
'
25000 IF NOT ZMsgFileLock THEN _
         RETURN
      ZMsgFileLock = ZFalse
      MID$(ZLockStatus$,1,2) = "UM"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZActiveMessageFile$
      ON ZNetworkType GOTO 25100,25200,25300,25400,25500,29800,29800
      RETURN
'
'
' *  UNLOCK MESSAGE FILE (MULTI-LINK)
'
'
25100 RETURN
'
'
' *  UNLOCK MESSAGE FILE (OMNINET)
'
'
25200 CALL BreakFileName (ZActiveMessageFile$,Drive$,Prefix$,Ext$,ZFalse)
      WasCC$ = CHR$(17) + _
            LEFT$(Prefix$ + SPACE$(8),8)
      GOSUB 28000
      IF WasCT = 128 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 25200
'
'
' *  UNLOCK MESSAGE FILE (ORCHID PC-NET)
' *  UNLOCK USER FILE (ORCHID PC-NET)
' *  UNLOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (ORCHID PC-NET)
'
'
25300 GOSUB 28100
      CALL UNLOKIT(ZLockDrive,ZLockFileName$,ZWasA)
      RETURN
'
'
' *  UNLOCK MESSAGE FILE (DESQVIEW)
'
'
25400 CALL DVUnlock("MESSAGE")
      RETURN
'
'
' *  UNLOCK MESSAGE FILE (10 NET)
' *  UNLOCK USER FILE (10 NET)
' *  UNLOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (10 NET)
'
'
25500 GOSUB 28100
      CALL UNLOK10(ZLockDrive,ZLockFileName$,ZWasA)
      RETURN

'
'
' *  LOCK USER FILE
'
'
26000 IF ZUserFileLock = ZTrue THEN _
         RETURN
      ZUserFileLock = ZTrue
      MID$(ZLockStatus$,4,2) = "LU"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZActiveUserFile$
      ON ZNetworkType GOTO 26100,26200,22300,26300,22500,29720,29720
      RETURN
'
'
' *  LOCK USER FILE (MULTI-LINK)
'
'
26100 RETURN
'
'
' *  LOCK USER FILE (OMNINET)
'
'
26200 CALL BreakFileName (ZActiveUserFile$,Drive$,Prefix$,Ext$,ZFalse)
      WasCC$ = CHR$(1) + _
            LEFT$(Prefix$ + SPACE$(8),8)
      GOSUB 28000
      IF WasCT = 0 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 26200
'
'
' *  LOCK USER FILE (DESQVIEW)
'
'
26300 CALL DVLock("USER")
      RETURN
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE
'
'
26500 IF ZUserBlockLock = ZTrue THEN _
         RETURN
      ZUserBlockLock = ZTrue
      ZBlk = (ZUserFileIndex / 4) + .26
      MID$(ZLockStatus$,7,2) = "LB"
      ZSubParm = 2
      CALL Line25
      ON ZNetworkType GOTO 26600,26700,26800,26750,26900,29730,29730
      RETURN
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE (MULTI-LINK)
'
'
26600 RETURN
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE (OMNINET)
'
'
26700 WasCC$ = CHR$(1) + _
            "BLK" + _
            RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOSUB 28000
      IF WasCT = 0 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 26700
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE (DESKVIEW)
'
'
26750 CALL DVLock("BLK" + RIGHT$("0000" + MID$(STR$(ZBlk),2),5))
      RETURN
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE (ORCHID PC-NET)
'
'
26800 ZLockFileName$ = LEFT$(ZActiveUserFile$,2) + _
                        "BLK" + _
                        RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOTO 22300
'
'
' *  LOCK 4 RECORD BLOCK IN USER FILE (10 NET)
'
'
26900 ZLockFileName$ = LEFT$(ZActiveUserFile$,2) + _
                        "BLK" + _
                        RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOTO 22500
'
'
' *  UNLOCK USER FILE
'
'
27000 IF NOT ZUserFileLock THEN _
         RETURN
      ZUserFileLock = ZFalse
      MID$(ZLockStatus$,4,2) = "UU"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZActiveUserFile$
      ON ZNetworkType GOTO 27100,27200,25300,27300,25500,29820,29820
      RETURN
'
'
' *  UNLOCK USER FILE (MULTI-LINK)
'
'
27100 RETURN
'
'
' *  UNLOCK USER FILE (OMNINET)
'
'
27200 CALL BreakFileName (ZActiveUserFile$,Drive$,Prefix$,Ext$,ZFalse)
      WasCC$ = CHR$(17) + _
            LEFT$(Prefix$ + SPACE$(8),8)
      GOSUB 28000
      IF WasCT = 128 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 27200
'
'
' *  UNLOCK USER FILE (DESQVIEW)
'
'
27300 CALL DVUnlock("USER")
      RETURN
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE
'
'
27500 IF NOT ZUserBlockLock THEN _
         RETURN
      ZUserBlockLock = ZFalse
      ZBlk = (ZUserFileIndex / 4) + .26
      MID$(ZLockStatus$,7,2) = "UB"
      ZSubParm = 2
      CALL Line25
      ON ZNetworkType GOTO 27600,27700,27800,27750,27900,29830,29830
      RETURN
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE (MULTI-LINK)
'
'
27600 RETURN
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE (OMNINET)
'
'
27700 WasCC$ = CHR$(17) + _
            "BLK" + _
            RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOSUB 28000
      IF WasCT = 128 THEN _
         RETURN
      CALL DelayTime (1)
      GOTO 27700
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE (DESQVIEW)
'
'
27750 CALL DVUnlock("BLK" + RIGHT$("0000" + MID$(STR$(ZBlk),2),5))
      RETURN
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE (ORCHID PC-NET)
'
'
27800 ZLockFileName$ = LEFT$(ZActiveUserFile$,2) + _
                        "BLK" + _
                        RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOTO 25300
'
'
' *  UNLOCK 4 RECORD BLOCK IN USER FILE (10-NET)
'
'
27900 ZLockFileName$ = LEFT$(ZActiveUserFile$,2) + _
                        "BLK" + _
                        RIGHT$("0000" + MID$(STR$(ZBlk),2),5)
      GOTO 25500
'
'
' *  CORVUS OMNINET INTERFACE
'
'
28000 WasCC$ = ZLineFeed$ + _
            CHR$(0) + _
            CHR$(11) + _
            WasCC$
      CALL CDSend(WasCC$)
      CALL CDRecv(ZWasCN$)
      WasCT = ASC(MID$(ZWasCN$,3,1))
      IF WasCT => 128 THEN _
         CALL LPrnt("CORVUS LOCK FAIL",1) : _
         ZSubParm = -1
28010 WasCT = ASC(MID$(ZWasCN$,4,1))
      IF WasCT => 129 THEN _
         CALL LPrnt("CORVUS FULL",1) : _
         ZSubParm = -1
      RETURN
'
'
' *  ORCHID PC-NET & 10 NET INTERFACE
'
'
28100 CALL AllCaps (ZLockFileName$)
      ZLockDrive = ASC(LEFT$(ZLockFileName$,1)) - ASC("A")
      ZLockFileName$ = ZLockFileName$ + _
                        STRING$(32 - LEN(ZLockFileName$),0)
      ZWasA = 0
      RETURN
'
'
' *  LOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$
'
'
29000 IF LockedEn$ = ZWasEN$ THEN _
         RETURN
      LockedEn$ = ZWasEN$
      MID$(ZLockStatus$,10,2) = "LD"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZWasEN$
      ON ZNetworkType GOTO 29100,29010,22300,29300,22500,29710,29710
29010 RETURN
'
'
' *  LOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (MULTI-LINK)
'
'
29100 RETURN
'
'
' *  LOCK UPLOAD DIRECTORY AND COMMENTS (DESQVIEW)
'
'
29300 CALL DVLock("MISC")
      RETURN
'
'
' *  UNLOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$
'
'
29500 IF LockedEn$ <> ZWasEN$ THEN _
         RETURN
      LockedEn$ = ""
      MID$(ZLockStatus$,10,2) = "UD"
      ZSubParm = 2
      CALL Line25
      ZLockFileName$ = ZWasEN$
      ON ZNetworkType GOTO 29600,29510,25300,29650,25500,29810,29810
29510 RETURN
'
'
' *  UNLOCK UPLOAD DIRECTORY OR COMMENTS BASED ON ZWasEN$ (MULTI-LINK)
'
'
29600 EXIT SUB
'
'
' *  UNLOCK UPLOAD DIRECTORY AND COMMENTS (DESQVIEW)
'
'
29650 CALL DVUnlock("MISC")
      RETURN
'
'
' *  NetBIOS SEMAPHORE LOCK MECHANISM
' *     Only the USERS file is actually locked.  All other files are locked
' *     by means of the semaphore file IBMFLAGS.  Each IBMFLAGS record is a
' *     file semaphore as follows:
' *        RECORD 1 = MESSAGES file lock status
' *        RECORD 2 = Comments/Upload dir locked
' *        RECORD 3 = entire USERS file lock
'
'
' * Lock MESSAGES
29700 CALL NetBIOS (1,6,1)
      RETURN

' * Lock Comments/Upload dir
29710 CALL NetBIOS (1,6,2)
      RETURN

' * Lock USERS file
29720 CALL NetBIOS (1,6,3)
      RETURN

' * Lock single USERS record
29730 CALL NetBIOS (1,6,3)
      RETURN

' * UNLOCK MESSAGES
29800 CALL NetBIOS (0,6,1)
      RETURN

' * UNLOCK Comments/Upload dir
29810 CALL NetBIOS (0,6,2)
      RETURN

' * UNLOCK USERS file
29820 CALL NetBIOS (0,6,3)
      RETURN

' * UNLOCK single USERS record
29830 CALL NetBIOS (0,6,3)
      RETURN
      END SUB
'
30000 ' $SUBTITLE: 'InitIBM - sub to create/open NetBIOS semaphore file'
' $PAGE
'
'  NAME    -- InitIBM   (Written by Doug Azzarito)
'
'  INPUTS  -- NONE
'
'  OUTPUTS -- ZSubParm = -1   Abort RBBS
'
'  PURPOSE -- Open semaphore file "IBMFLAGS" on default drive as file #6
'             Create file if it does not exits.
'
      SUB InitIBM
'
' *  SEE IF FILE EXISTS
'
      ZShareIt = ZTrue
      CALL BreakFileName (ZMainMsgFile$,IBMFlagFile$,Dummy$,Dummy$,ZTrue)
      IBMFlagFile$ = IBMFlagFile$ + _
                       "IBMFLAGS"
      CALL FindIt (IBMFlagFile$)
      CLOSE 2
      IF ZOK THEN _
         GOTO 30020
'
'
' *  CREATE A NEW FILE, EACH RECORD IS A SEMAPHORE
'
'
      OPEN IBMFlagFile$ ACCESS WRITE AS #6 LEN=2
      FIELD 6, 2 AS LockBuf$
      LSET LockBuf$ = MKI$(0)
      FOR WasI = 1 TO 3
         PUT 6
      NEXT
      CLOSE #6
30020 OPEN IBMFlagFile$ ACCESS READ WRITE SHARED AS #6 LEN=2
      END SUB
'
30500 ' $SUBTITLE: 'OpenMsg - open the MESSAGES file'
' $PAGE
'
'  NAME    -- OpenMsg
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZActiveMessageFile$
'              ZShareIt
'
'  OUTPUTS --  ZMsgRec$
'
      SUB OpenMsg
'
'
' *  OPEN AND DEFINE MESSAGE FILE
'
'
      CLOSE 1
      IF ZShareIt THEN _
         OPEN ZActiveMessageFile$ ACCESS READ WRITE SHARED AS #1 _
      ELSE OPEN "R",1,ZActiveMessageFile$
      FIELD 1,128 AS ZMsgRec$
      END SUB
'
30595 ' $SUBTITLE: 'FindFKey - sub to handle local keyboard functions'
' $PAGE
'
'  NAME    -- FindFKey
'
'  INPUTS  --  PARAMETER                 MEANING
'             ZActiveMenu$              INDICATOR OF ACTIVE MENU
'             ZAdjustedSecurity         SWITCH INDICATING TEMP. SECURITY CHANGE
'             ZAutoDownDesired          USER'S PREFERENCE FOR AUTODOWNLOADING
'             ZCallersFile$             NAME OF CALLERS FILE
'             ZChatAvail                TOGGLE INDICATING IF SYSOP WILL CHAT
'             ZCheckBulletLogon         USER'S PREFERENCE FOR BULLETIN CHECK
'             ZConfMode                 INDICATOR THAT USER IS IN A CONFERENCE
'             ZCursorLine               LINE THAT THE CURSOR IS AT
'             ZCursorRow                ROW THAT THE CURSOR IS AT
'             ZDiskForDos$              DISK TO LOAD COMMAND.COM FROM
'             ZDiskFullGoOffline        INDICATOR OF WHAT TO DO WHEN DISK FULL
'             ZExitToDoors              FLAG INDICATING EXITING TO DOORS
'             ZExpertUser               FLAG FOR EXPERT/NOVICE USER MODE
'             ZFirstName$               LOGGED ON USER'S FIRST NAME
'             ZF1Key                    FUNCTION KEY ONE VALUE
'             ZF10Key                   FUNCTION KEY TEN VALUE
'             ZWasGR                    GRAPHICS PREFERENCE OF USER
'             ZLineFeeds                SWITCH FOR USER'S LINE FEED PREFERENCE
'             ZLocalUser                FLAG INDICATING USER IS LOCAL
'             ZMinLogonSec              MINIMUM SECURITY TO LOGON
'             ZModemGoOffHookCmd$       COMMAND TO TAKE MODEM OFF-HOOK
'             ZModemInitBaud$           BAUD TO INITIALIZE MODEM AT
'             ZNodeID$                  NODE IDENTIFIER
'             ZNodeRecIndex             NODE RECORD INDEX FOR THIS NODE
'             ZNulls                    SWITCH FOR USER'S PREFERENCE FOR NULLS
'             ZPrinter                  TOGGLE INDICATING PRINTER IS AVAILABLE
'             ZPromptBell               USER'S PREFERENCE FOR BELLS ON PROMPTS
'             SECONDS.PER.SESSION       TIME LEFT IN CURRENT USER SESSION
'             ZSkipFilesLogon           USER'S LOGON NOTIFICIATION PREFERENCE
'             ZSnoop                    TOGGLE INDICATING SNOOP STATUS
'             ZSubParm                  -8  = SYSOP'S OPTION 6 REMOTELY
'                                       -9  = GOT TO DOS
'                                       -10 = SYSOP GET'S SYSTEM NEXT
'             ZSysop                    INDICATOR THAT USER IS SYSOP
'             ZSysopAnnoy               TOGGLE INDICATING SYSOP IS AVAILABLE
'             ZSysopNext                TOGGLE SO SYSOP GETS SYSTEM NEXT
'             ZUpperCase                USER'S PREFERENCE FOR UPPER/LOWER CASE
'             ZUserFileIndex            INDEX INTO THE USER FILE FOR CALLER
'             ZUserSecLevel             USER'S SECURITY LEVEL
'             USERT.TRANSFER.DEFAULT    USER'S FILE TRANSFER DEFAULT PREFERENCE
'
'  OUTPUTS --
'             ZAdjustedSecurity         SWITCH INDICATING TEMP. SECURITY CHANGE
'             ZChatAvail                TOGGLE INDICATING IF SYSOP WILL CHAT
'             ZFunctionKey              VALUE 1 TO 10 CORRESPONDING TO
'                                       THE FUNCTION KEY THAT WAS PRESSED
'             ZKeyPressed$              CHARACTER STRING GENERATED BY KEY
'             ZPrinter                  TOGGLE INDICATING PRINTER IS AVAILABLE
'             ZSnoop                    TOGGLE INDICATING SNOOP STATUS
'             ZSysop                    INDICATOR THAT USER IS SYSOP
'             ZSysopAnnoy               TOGGLE INDICATING SYSOP IS AVAILABLE
'             ZSysopNext                TOGGLE SO SYSOP GETS SYSTEM NEXT
'             ZSubParm                  -1 CARRIER LOST
'                                       -2 CHAT MODE ACTIVATED
'                                       -3 FORCE CALLER ON-LINE
'                                       -4 EXIT TO SYSTEM IMMEDIATELY
'                                       -5 EXIT TO SYSTEM AFTER MULTI-LINK CALL
'                                       -6 TELL USER ACCESS IS DENIED
'                                       -7 UPDATE CALLERS FILE AND DENY ACCESS
'             ZUserSecLevel             USER'S SECURITY LEVEL
'
'  PURPOSE -- To determine if a function has been pressed on
'             the PC'S keyboard that is running RBBS-PC.
'
      SUB FindFKey STATIC
      LookUp = ZSubParm
      ForceLineChat = ZFalse
      IF ZSubParm < -1 THEN _
         ZSubParm = 0 : _
         IF LookUp = - 8 THEN _
            GOTO 33070 _
         ELSE IF LookUp = - 9 THEN _
                 GOTO 31000 _
              ELSE IF LookUp = - 10 THEN _
                      GOTO 33090
'
' *  TEST FOR FUNCTION KEY PRESSED
'
30600 IF ZKeyboardStack$ = "" THEN _
         ZKeyPressed$ = INKEY$ _
      ELSE ZKeyPressed$ = ZKeyboardStack$ : _
           ZKeyboardStack$ = ""
      ZFunctionKey = 0
      IF LEN(ZKeyPressed$) <> 2 THEN _
         GOTO 33970
      ZKeyPressed = ASC(RIGHT$(ZKeyPressed$,1))
      IF ZLocalUser AND NOT ZSysop THEN _
         ZKeyPressed$ = "" : _
         GOTO 33970
      IF ZKeyPressed => ZF1Key AND _
         ZKeyPressed <= ZF10Key THEN _
             ZFunctionKey = ZKeyPressed - 58 : _
             GOTO 30610
      SELECT CASE ZKeyPressed
         CASE 117                    'Ctrl-End
            ZFunctionKey = 11
         CASE 73                     'PgUp
            ZFunctionKey = 12
         CASE 72                     'up arrow
            ZFunctionKey = 13
         CASE 80                     'Down arrow
            ZFunctionKey = 14
         CASE 81                     'PgDn
            ZFunctionKey = 15
         CASE 75                     'left arrow
            ZFunctionKey = 16
         CASE 77                     'Right arrow
            ZFunctionKey = 17
         CASE 141                    'CTRL-up arrow
            ZFunctionKey = 18
         CASE 132                    'CTRL-PgUp (same as CTRL-UP)
            ZFunctionKey = 18
         CASE 145                    'CTRL-down arrow
            ZFunctionKey = 19
         CASE 118                    'CTRL-PgDn (same as CTRL-DOWN)
            ZFunctionKey = 19
         CASE 115                    'CTRL-left arrow
            ZFunctionKey = 20
         CASE 116                    'CTRL-right arrow
            ZFunctionKey = 21
         CASE 79                     'End (a nice way to kick user off)
            ZFunctionKey = 22
         CASE 94                     'CTRL-F1 (kick off twit - SysOp config)
            ZFunctionKey = 23
         CASE 113                    'ALT-F10 - Force LINE Chat
            ZFunctionKey = 24
      END SELECT
30610 ZKeyPressed$ = ""
      IF ZFunctionKey < 1 OR ZFunctionKey > 24 THEN _
         GOTO 33970
      IF ZFunctionKey < 10 AND (ZFunctionKey <> 8) THEN _
         GOTO 30620
      IF ZToggleOnly THEN _
         ZSubParm = 1 : _
         GOTO 33970
30620 ON ZFunctionKey GOTO  31000, _            '  1 =  F1
                            32000, _            '  2 =  F2
                            33000, _            '  3 =  F3
                            33040, _            '  4 =  F4
                            33060, _            '  5 =  F5
                            33070, _            '  6 =  F6
                            33090, _            '  7 =  F7
                            33110, _            '  8 =  F8
                            33130, _            '  9 =  F9
                            33150, _            ' 10 = F10
                            31398, _            ' 11 = CTRL END
                            33200, _            ' 12 = PGUP
                            33170, _            ' 13 = UP ARROW
                            33180, _            ' 14 = DOWN ARROW
                            33220, _            ' 15 = PGDN
                            33240, _            ' 16 = LEFT ARROW
                            33250, _            ' 17 = RIGHT ARROW
                            33170, _            ' 18 = CTRL-UP ARROW
                            33180, _            ' 19 = CTRL-DOWN
                            33245, _            ' 20 = CTRL-LEFT
                            33255, _            ' 21 = CTRL-RIGHT
                            31398, _            ' 22 = END
                            31398, _            ' 23 = CTRL-F1
                            31400               ' 24 = FORCE LINE CHAT
'
'
' * F1 - COMMAND FROM LOCAL KEYBOARD (IMMEDIATE EXIT TO DOS)
'
'
31000 ZSubParm = -10
      CALL Carrier
      IF ZSubParm = 0 THEN _
         GOTO 33970
      ZFileName$ = ZNodeWorkDrvPath$ + "RBF1" + ZNodeFileID$ + ".DEF"
      CLOSE 2
      CALL OpenOutW (ZFileName$)
      PRINT #2,MID$(ZFileName$,3,7)
      IF ZExitToDoors THEN _
         ZSubParm = -4 : _
         GOTO 33970
      CALL OpenCom(ZModemInitBaud$,",N,8,1")
      CALL TakeOffHook
      ZSubParm = -5
      GOTO 33970
'
'
' *  END KEY - FORCE CURRENT USER OFF AND LOCK THEM OUT
'
'
31398 IF NOT ZLocalUser THEN _
         CALL Carrier : _
         IF ZSubParm = -1 THEN _
            GOTO 33970
      IF INSTR("MUF",ZActiveMenu$) > 0 THEN _
         GOTO 31399
      ZCursorLine = CSRLIN
      ZCursorRow = POS(0)
      LOCATE 25,1
      WasD$ = SPACE$(79)
      GOSUB 33210
      LOCATE 25,1
      WasD$ ="Cannot FORCE OFF until user reaches MAIN menu"
      GOSUB 33210
      CALL DelayTime (1)
      LOCATE ZCursorLine,ZCursorRow
      ZSubParm = 1
      CALL Line25
      GOTO 33970
31399 IF ZFunctionKey = 22 THEN                     ' END
         ZFileName$ = ZNeedSysMsg$
         CALL FindFile (ZNeedSysMsg$,Found)
         IF Found THEN _
            GOSUB 31405 : _
            GOTO 33970 _
         ELSE _
            CALL QuickTPut1 ("Sorry, " + ZFirstName$ + ", SysOp needs the system") : _
            GOSUB 31410 : _
            GOTO 33970
      ENDIF
      IF ZFunctionKey = 23 THEN                     ' CTRL-F1
         ZFileName$ = ZHelpPath$ + "TWIT.MSG"
         CALL FindFile (ZFileName$,Found)
         IF Found THEN _
            GOSUB 31405 : _
            GOTO 33970 _
         ELSE _
            GOSUB 31415 : _
            GOTO 33970
      ENDIF
      ZFileName$ = ZHelpPath$ + "KICKOFF.MSG"
      CALL Findfile (ZFileName$,Found)
      IF Found THEN _
         GOSUB 31405 : _
         GOTO 33970
      CALL QuickTPut1 (ZFirstName$ + ", goodbye and don't call back")
      CALL DelayTime (8 + ZBPS) : _
      IF ZUserFileIndex < 1 THEN _
         ZSubParm = -6 : _
         GOTO 33970
      ZUserSecLevel = ZMinLogonSec - 1
      CALL DenyAccess
      ZSubParm = -7
      GOTO 33970
31400 ForceLineChat = ZTrue
      GOTO 33150
31405 CALL Graphic (ZFileName$,ZTrue)
      ZNonStop = ZTrue
      CALL BufFile (ZFileName$,ZWasX,ZFalse)
31410 CALL DelayTime (8 + ZBPS)
31415 CALL UpdtCalr ("Logged off by SysOp",1)
      ZSubParm = -6
      RETURN
'
'
' * F2 - COMMAND FROM LOCAL KEYBOARD (SYSOP EXIT TO DOS AND RETURN)
'
'
32000 IF NOT ZLocalUser THEN _
         CALL SkipLine (1) : _
         CALL QuickTPut1 ("Sysop exiting to DOS. Please wait...") : _
         ZFunctionKey = 0 : _
         CALL DelayTime (3)
      CALL ShellExit (ZDiskForDos$ + "COMMAND")
      CLS
      IF NOT ZLocalUser THEN _
         CALL Carrier : _
         IF ZSubParm = -1 THEN _
            GOTO 33970
      ZSubParm = 2
      CALL Line25
      CALL QuickTPut1 ("Sysop back from DOS.  Returning control to you.")
      ZCommPortStack$ = ZCarriageReturn$
      GOTO 33970
'
'
' * F3 - COMMAND FROM LOCAL KEYBOARD (PRINTER TOGGLE)
'
'
33000 ZPrinter = NOT ZPrinter
      ChangeValue = ZPrinter
      FieldPosition = 38
      GOTO 33950
'
'
' * F4 - COMMAND FROM LOCAL KEYBOARD (SYSOP ANNOY)
'
'
33040 ZSysopAnnoy = NOT ZSysopAnnoy
      ChangeValue = ZSysopAnnoy
      FieldPosition = 34
      GOTO 33950
'
'
' * F5 - COMMAND FROM LOCAL KEYBOARD (FORCE CALLER ONLINE)
'
'
33060 Call Carrier
      IF ZSubParm = 0 THEN _
         ZFunctionKey = 0 : _
         ZKeyPressed$ = "" : _
         GOTO 33970
      ZFunctionKey = 0
      ZSubParm = -3
      GOTO 33970
'
'
' * F6 - COMMAND FROM LOCAL KEYBOARD (SYSOP AVAILABLE TOGGLE)
' *  6 - COMMAND FROM SYSOP MENU (SYSOP AVAILABLE TOGGLE)
'
'
33070 ZSysopAvail = NOT ZSysopAvail
      ChangeValue = ZSysopAvail
      FieldPosition = 32
      GOTO 33950
'
'
' * F7 - COMMAND FROM LOCAL KEYBOARD (SYSOP GETS SYSTEM NEXT)
'
'
33090 IF ERR=61 AND NOT ZDiskFullGoOffline THEN _
         GOTO 33970
      ZSysopNext = NOT ZSysopNext
      ChangeValue = ZSysopNext
      FieldPosition = 36
      GOTO 33950
'
'
' * F8 - COMMAND FROM LOCAL KEYBOARD (ASSIGN USER TEMPORARY SYSOP SECURITY)
'
'
33110 ZSysop = NOT ZSysop
      ZCursorLine = CSRLIN
      ZCursorRow = POS(0)
      LOCATE 25,1
      WasD$ = SPACE$(79)
      NumReturns = 0
      CALL LPrnt (WasD$,NumReturns)
      LOCATE 25,1
      ZUserSecLevel = (1 + ZSysop) * _
                            ZUserSecSave  - _
                            ZSysop * _
                            ZSysopSecLevel
      WasD$ = "Sysop Privileges " + FNOffOn$(ZSysop)
      CALL LPrnt (WasD$,NumReturns)
      CALL DelayTime (3)
      LOCATE ZCursorLine,ZCursorRow
      ZSubParm = 1
      CALL Line25
      CALL SetPrompt
      GOTO 33970
'
'
' * F9 - COMMAND FROM LOCAL KEYBOARD (SNOOP TOGGLE)
'
'
33130 IF NOT ZSnoop THEN _
         ZSnoop = ZTrue : _
         LOCATE 24,1,0 : _
         WasD$ = "SNOOP ON" : _
         NumReturns = 0 : _
         CALL LPrnt (WasD$,NumReturns) : _
         ZSubParm = 2 : _
         CALL Line25 _
      ELSE LOCATE ,,0 : _
           ZSnoop = ZFalse : _
           CLS
33140 ChangeValue = ZSnoop
      FieldPosition = 58
      GOTO 33950
'
'
' * F10 - COMMAND FROM LOCAL KEYBOARD (FORCE CHAT WITH USER)
'
'
33150 GOTO 33160
33155 ZSubParm = 1
      CALL Line25
      GOTO 33970
33160 CALL UpdtCalr ("Sysop began chat",1)
      ZPageStatus$ = ""
      IF ZRIPTest THEN _
         CALL QuickTPut1 (ZRIPReset$)
      IF (ZANSITest = ZTrue OR ZWasGR > 1) AND ZDosANSI AND _
             ForceLineChat = ZFalse THEN _
         CALL TimeBack (1) : _
         CALL SysopChat (2) _
      ELSE _
         CALL SkipLine (1) : _
         CALL QuickTPut1 ("Hi " + _
              ZFirstName$ + _
              ", this is " + _
              ZSysopFirstName$ + _
              " " + _
              ZSysopLastName$ + _
              ".  Sorry to break in to CHAT but..") : _
              CALL TimeBack (1) : _
              CALL SysopChat (1)
      CALL TimeBack (2)
      ZCommPortStack$ = CHR$(13)
      IF ZSubParm < 0 THEN _
         GOTO 33970
      GOTO 33155
'
'
' * UP / CTRL-UP: INCREASE THE ON-LINE USER'S SECURITY BY ONE / FIVE
'
'
33170 ZUserSecLevel = ZUserSecLevel +  1 - 4 * (ZFunctionKey = 18)
      GOTO 33190
'
'
' * DOWN / CTRL-DOWN: DECREASE THE ON-LINE USER'S SECURITY BY ONE / FIVE
'
'
33180 ZUserSecLevel = ZUserSecLevel - _
                            1 + 4 * (ZFunctionKey = 19)
33190 ZAdjustedSecurity = ZTrue
      ZUserSecSave = ZUserSecLevel
      IF (NOT ZConfMode) AND (NOT ZSubBoard) THEN _
         ZOrigSec = ZUserSecLevel
      ZSubParm = 2
      CALL Line25
      CALL SetPrompt
      GOTO 33970
'
' * PGUP DISPLAY USER PROFILE
'
33200 IF NOT ZLocalUser THEN _
         CALL Carrier : _
         IF ZSubParm = -1 THEN _
            GOTO 33970
      IF ZVoiceType <> 0 THEN _
         ZTalkAll = ZTrue
      CALL PageUp
      WasD$ = MID$("NoviceExpert",1 -6 * ZExpertUser,6)
      GOSUB 33210
      WasD$ = "Graphics   : " + _
           MID$("None AsciiColor",ZWasGR * 5 + 1,5)
      GOSUB 33210
      WasD$ = "Protocol   : " + _
           ZUserXferDefault$
      GOSUB 33210
      WasD$ = "Upper Case " + _
           MID$("and lowerOnly", 1 - 9 * ZUpperCase,9)
      GOSUB 33210
      WasD$ = "Line Feeds " + FNOffOn$(ZLineFeeds)
      GOSUB 33210
      WasD$ = "Nulls " + FNOffOn$(ZNulls)
      GOSUB 33210
      WasD$ = "Prompt Bell " + FNOffOn$(ZPromptBell)
      GOSUB 33210
      WasD$ = MID$("Skip Check",1 -5 * ZCheckBulletLogon,5)
      WasD$ = RTRIM$(WasD$) + " old Bulletins on logon."
      GOSUB 33210
      WasD$ = MID$("CheckSkip ",1 -5 * ZSkipFilesLogon,5)
      WasD$ = RTRIM$(WasD$) + " new files on logon."
      GOSUB 33210
      ZTalkAll = ZFalse
      GOTO 33970
33210 NumReturns = 1
      CALL LPrnt(WasD$,NumReturns)
      RETURN
'
'
' * PGDN CLEAR DISPLAY OF USER'S PROFILE
'
'
33220 IF NOT ZLocalUser THEN _
         CALL Carrier : _
         IF ZSubParm = -1 THEN _
            GOTO 33970
      CLS
      GOTO 33155
'
'
' * LEFT ARROW - DECREASE THE ON-LINE USER'S TIME BY ONE MINUTE
'
'
33240 IF ZSecsPerSession! > 120 THEN _
         ZSecsPerSession! = ZSecsPerSession! - 60
      GOTO 33970
'
'
' * CTRL-LEFT ARROW - DECREASE THE ON-LINE USER'S TIME BY FIVE MINUTES
'
'
33245 IF ZSecsPerSession! > 360 THEN _
         ZSecsPerSession! = ZSecsPerSession! - 300
      GOTO 33970
'
'
' * RIGHT ARROW - INCREASE THE ON-LINE USER'S TIME BY ONE MINUTE
'
'
33250 IF ZSecsPerSession! < 86280 THEN _
         ZSecsPerSession! = ZSecsPerSession! + 60
      ZTimeLockSet = 0
      GOTO 33970
'
'
' * CTRL-RIGHT ARROW - INCREASE THE ON-LINE USER'S TIME BY FIVE MINUTES
'
'
33255 IF ZSecsPerSession! < 86040 THEN _
         ZSecsPerSession! = ZSecsPerSession! + 300
      ZTimeLockSet = 0
      GOTO 33970
'
'
' * UPDATE NODE RECORD WITH LOCAL FUNCTION KEY ACTIVITY
'
'
33950 IF ZSnoop THEN _
         ZSubParm = 1 : _
         CALL Line25
33960 IF ZConfMode = ZTrue THEN _
         IF ZLocalUser THEN _
            GOTO 33970 _
         ELSE WasD$ = "Cannot change status during Conference!" : _
              GOSUB 33210 : _
              GOTO 33970
      ZSubParm = 3
      CALL FileLock
      IF ZSubParm = -1 THEN _
         GOTO 33970
      CALL OpenMsg
      FIELD 1,128 AS ZMsgRec$
      GET 1,ZNodeRecIndex
      MID$(ZMsgRec$,FieldPosition,2) = STR$(ChangeValue)
      CALL SaveProf (2)
      FIELD 1, 128 AS ZMsgRec$
33970 IF ZFunctionKey < 23 AND ZFunctionKey > 15 THEN _
         MinsRemaining = (ZSecsPerSession! - ZSecsUsedSession!) / 60 : _
         CALL Line25
      END SUB
'
33990 ' $SUBTITLE: 'PageUp - Display user profile to Sysop'
' $PAGE
'
'  NAME    -- PageUp
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZActiveUserName$       CURRENT USER NAME
'                 ZDnlds                 # OF FILES DOWNLOADED
'                 ZExpirationDate$       REGISTRATION EXPIRATION
'                 ZLastDateTimeOnSave$   Last DATE & TIME ON SYSTEM
'                 ZLastMsgRead           Last MESSAGE READ BY USER
'                 ZPswdSave$             USERS PASSWORD
'                 ZTimesLoggedOn         TIMES USER HAS LOGGED ON
'                 ZUplds                 # OF FILES UPLOADED
'                 ZUserSecSave           USERS SECURITY LEVEL
'
'  OUTPUTS -- ZMsgRec$
'
      SUB PageUp
      CALL LPrnt (" ",1)
      CALL LPrnt ("User Name  : " + ZActiveUserName$,1)
      CALL LPrnt ("Security   :" + STR$(ZUserSecSave),1)
      CALL LPrnt ("Password   : " + ZPswdSave$,1)
      CALL LPrnt ("Read Msg.  :" + STR$(ZLastMsgRead),1)
      CALL LPrnt ("Times On   :" + STR$(ZTimesLoggedOn),1)
      CALL LPrnt ("Last On    : " + ZLastDateTimeOnSave$,1)
      CALL LPrnt ("Drp Carrier:" + STR$(ZGlobalDropTimes),1)
      CALL LPrnt ("Downloads  :" + STR$(ZDnlds),1)
      CALL LPrnt ("Uploads    :" + STR$(ZUplds),1)
      IF ZEnforceRatios THEN _
         CALL LPrnt ("DL-Bytes   :" + STR$(ZDLBytes!),1) : _
         CALL LPrnt ("UL-Bytes   :" + STR$(ZULBytes!),1)
      IF ZRestrictByDate THEN _
         CALL LPrnt ("Expiration : " + ZExpirationDate$,1)
      CALL LPrnt ("-== USER'S PROFILE ==-",1)
      END SUB
'
35000 ' $SUBTITLE: 'FlushKeys - Completely flush all user input'
' $PAGE
'
'  NAME    -- FlushKeys
'
      SUB FlushKeys
      CALL FlushCom (ZWasY$)
      ZLastIndex = 0
      REDIM ZUserIn$(ZMsgDim)
      END SUB
'
41007 ' $SUBTITLE: 'CheckTimeRemain - Kicks off if no time remaining'
' $PAGE
'
'  NAME    -- CheckTimeRemain
'
'  INPUTS  -- PARAMETER                 MEANING
'
'  OUTPUTS -- PARAMETER                 MEANING
'             MinsRemaining         TIME IN MINUTES LEFT IN SESSION
'             ZSecsUsedSession!     TIME USED IN SECONDS
'             ZSubParm              -1 IF NO TIME LEFT
'
      SUB CheckTimeRemain (MinsRemaining) STATIC
      CALL TimeRemain (MinsRemaining)
      IF ZBypassTimeCheck THEN _
         EXIT SUB
      IF MinsRemaining < 1 THEN
         IF ZBankTime < 1 THEN _
            ZSubParm = -1 : _
            EXIT SUB
         TimeAdd = 1
         CALL ChkAddedTime (TimeAdd)
         IF ZTimeBankInActive OR TimeAdd = 0 THEN _
            CALL QuickTPut1 (" Your Time has Expired") : _
            CALL QuickTPut1 ("Bank Unavailable at this time") : _
            ZSubParm = - 1 : _
            EXIT SUB
         CALL Carrier
         IF ZSubParm = -1 THEN _
            EXIT SUB
         ZOutTxt$ = ZFG7$ + " Your Time has Expired" + ZFG5$ + _
                    " - Use Time Bank ([Y]" + ZFG5$ + ",N) " + ZEmphasizeOff$
         ZTurboKey = -ZTurboKeyUser
         CALL TGet
         IF ZSubParm = -1 THEN _
            EXIT SUB
         IF ZNO THEN _
            ZSubParm = -1 : _
            EXIT SUB
         CALL BankTime
         CALL TimeRemain (MinsRemaining)
         IF MinsRemaining <= 0 THEN _
            ZSubParm = -1
         IF ZCurrHourDGS = 1 THEN _
             CALL QuickTPut ("Sorry " + ZFirstName$ + _
             " Board Access Restricted During Current Hours",1)
         EXIT SUB
      END IF
      IF MinsRemaining <= 3 AND NOT ZNonStop THEN
         IF MinsRemaining > 0 THEN
            IF MinsRemainingTemp <> MinsRemaining THEN
               MinsRemainingTemp = MinsRemaining
               CALL QuickTPut1 (ZEmphasizeOn$ + "ALERT:" + ZFGE$ + _
                    " Auto-Disconnect in (" + ZFGF$ + _
                    STR$(MinsRemaining) + ZFGE$ + ") min.!" + _
                    ZEmphasizeOff$)
               CALL DelayTime(1)
            END IF
         END IF
      END IF
      END SUB
'
41010 ' $SUBTITLE: 'TimeRemain - calculates time remaining in a session'
' $PAGE
'
'  NAME    -- TimeRemain
'
'  INPUTS  -- PARAMETER                 MEANING
'             ZUserLogonTime!          WHEN DID THE CALLER GET HERE
'             ZSecsPerSession!         HOW LONG MAY THE CALLER STAY ON
'             ZTimeToDropToDos!        WHEN ARE WE DOING OUR DAILY EVENT
'             ZBypassTimeCheck         DO WE CARE HOW LONG THEY CAN STAY
'
'  OUTPUTS -- PARAMETER                 MEANING
'             MinsRemaining            TIME IN MINUTES LEFT IN SESSION
'             ZSecsUsedSession!        TIME USED IN SECONDS
'
      SUB TimeRemain (MinsRemaining) STATIC
      TOA! = FRE("A")
      IF ZBypassTimeCheck THEN _
         MinsRemaining = ZSecsPerSession! / 60 : _
         EXIT SUB
      CALL CheckTime (ZUserLogonTime!, ZSecsUsedSession!, 2)
      IF ZTimeToDropToDos! = 0 OR _
         ZOldDate$ = DATE$ THEN _
         GOTO 41020
      CALL CheckTime (ZTimeToDropToDos!, HowMuchTimeLeft!, 1)
      IF HowMuchTimeLeft! < -60 THEN _
         HowMuchTimeLeft! = (HowMuchTimeLeft! * -1) + 43200
      IF (ZSecsPerSession! - ZSecsUsedSession!) > HowMuchTimeLeft! THEN _
         ZSecsPerSession! = HowMuchTimeLeft! + ZSecsUsedSession! : _
         IF NOT ToldShort THEN _
            ToldShort = ZTrue : _
            ZOutTxt$ = "Shortened session time to" + _
                STR$(INT((ZSecsPerSession! - ZSecsUsedSession!) / 60)) + _
                " min for scheduled event" : _
            CALL RingCaller
41020 MinsRemaining = INT((ZSecsPerSession! - ZSecsUsedSession!) / 60)
      END SUB
'
41032 ' $SUBTITLE: 'DispTimeRemain - Display users time remaining'
' $PAGE
'
'  NAME    -- DispTimeRemain
'
'  INPUTS  --     PARAMETER                    MEANING
'              MinsRemaining
'
'  OUTPUTS --     PARAMETER                    MEANING
'                MinsRemaining               TIME IN MINUTES LEFT IN SESSION
'
      SUB DispTimeRemain (MinsRemaining)
      CALL TimeRemain (MinsRemaining)
      CALL QuickTPut1 (ZEmphasizeOff$ + STR$(MinsRemaining) + " min left")
      END SUB
'
41498 ' $SUBTITLE: 'AMorPM - give time of day in AM/PM format'
' $PAGE
'
'  NAME    -- AMorPM
'
'  INPUTS  --     PARAMETER                    MEANING
'
'  OUTPUTS -- ZCurDate$                 CURRENT DATE (MM-DD-YY)
'             ZTime$                    CURRENT TIME (I.E. 1:13 PM)
'
'  PURPOSE -- To set the time and date and
'             describe the time as "AM" or "PM."
'
      SUB AMorPM
'
'
' *  CALCULATE CURRENT TIME FOR AM OR PM
'
'
41500 ZCurDate$ = DATE$
      ZCurDate$ = LEFT$(ZCurDate$ ,6) + _
                      RIGHT$(ZCurDate$ ,2)
41510 ZTime$ = TIME$
      IF VAL(MID$(ZTime$,1,2)) = 12 THEN _
         MID$(ZTime$,1,2) = RIGHT$(STR$(VAL(MID$(ZTime$,1,2))),2) : _
         ZTime$ = LEFT$(ZTime$,5) + _
                " PM" : _
         EXIT SUB
      IF VAL(MID$(ZTime$,1,2)) > 11 THEN _
         MID$(ZTime$,1,2) = RIGHT$(STR$(VAL(MID$(ZTime$,1,2))-12),2) : _
         ZTime$ = LEFT$(ZTime$,5) + _
                " PM" : _
         EXIT SUB
      ZTime$ = LEFT$(ZTime$,5) + _
             " AM"
      END SUB
'
42000 ' $SUBTITLE: 'Carrier - sub to monitor carrier on comm. port'
' $PAGE
'
'  NAME    -- Carrier
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZAutoLogoffReq                  -1 IF IN AUTOLOGOFF REQUEST
'
'  OUTPUTS --  ZSubParm = 0                    CONTINUE
'              ZSubParm = -1                   TERMINATE (No Carrier)
'
'  PURPOSE --  To test whether should continue in RBBS.  Reasons
'              NOT to continue are:  autologoff, out of time, or
'              carrier dropped.
'
      SUB Carrier
      CALL CheckCarrier
      END SUB
'
42005 ' $SUBTITLE: 'CheckCarrier - monitors carrier on comm. port'
' $PAGE
'
'  NAME    -- CheckCarrier
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZLocalUser = 0               REMOTE USER
'              ZLocalUser = -1              LOCAL KEYBOARD USER
'              ZModemStatusReg              ADDRESS OF THE COMMUNI-
'                                           CATIONS PORT'S REGISTER
'              ZSubParm = -9                DON'T WRITE TO CALLERS
'              ZSubParm = -10               SAME AS -9, BUT DON'T
'                                           DELAY
'
'  OUTPUTS --  ZSubParm = 0                 CARRIER STILL PRESENT
'              ZSubParm = -1                CARRIER NOT PRESENT
'
'  PURPOSE --  To test if carrier is present (i.e. the user
'              is still on line).  Ignores whether in autologoff.
'
      SUB CheckCarrier STATIC
      IF ZSubParm = -1 THEN _
         EXIT SUB
      Speedy = ZSubParm
      ZSubParm = 0
'
'
' * TEST FOR CARRIER PRESENT (DROP CALLER IF CARRIER NOT PRESENT)
'
'
      IF ZLocalUser THEN _
         EXIT SUB
      IF ZFossil THEN _
         CALL FosStatus(ZComPort,Status) : _
         Status = Status AND &H0080 : _
         IF Status = &H0080 THEN _
            EXIT SUB _
         ELSE GOTO 42015
42010 IF INP(ZModemStatusReg) > 127 THEN _
         EXIT SUB
'
'
' * IN CASE USER IS 2400 BAUD, PAUSE A SECOND AND CHECK AGAIN FOR CARRIER
' * DETECT.  SOME 2400 BAUD MODEMS TAKE A WHILE TO SYNCHRONIZE THE CARRIER,
' * HENCE A THREE-SECOND PAUSE BEFORE CHECKING AGAIN.
'
'
42015 IF Speedy = -10 THEN _
         GOTO 42020
      CALL DelayTime (ZModemInitWaitTime)
      IF ZFossil THEN _
         CALL FosStatus(ZComPort,Status) : _
         Status = Status AND &H0080 : _
         IF Status = &H0080 THEN _
            EXIT SUB _
         ELSE GOTO 42020
      IF INP(ZModemStatusReg) > 127 THEN _
         EXIT SUB
42020 ZSubParm = -1
      IF Speedy < -8 THEN _
         EXIT SUB
      IF AlreadyWritten = -9 THEN _
         EXIT SUB
      CALL TakeOffHook
      ZModemOffHook = -1
      AlreadyWritten = -9
      IF ZDoorCarrierDropOK$ = "Y" THEN _
         CALL UpdtCalr ("Logged Off from Door",1) : _
         EXIT SUB
      CALL UpdtCalr ("Carrier dropped",1)
      CALL SkipLine (1)
      PRINT "Carrier Dropped!"
      CALL DropCarrier
      END SUB
'
43004 ' $SUBTITLE: 'AskGraphics -- sub to ask users graphic preference'
' $PAGE
'
'  NAME    -- AskGraphics
'
'  INPUTS  --    PARAMETER                    MEANING
'                ZUserGraphicDefault$        USER GRAPHIC DEFAULT
'
'  OUTPUTS --
'
'  PURPOSE --  To determine users graphics default
'
      SUB AskGraphics STATIC
      IF ZExpertUser THEN _
         GOTO 43007
43006 ZFileName$ = ZHelp$(9)
      CALL BufFile (ZFileName$,WasX,ZFalse)
      IF ZSubParm = -1 THEN _
         EXIT SUB
43007 CALL QuickTPut1 ("GRAPHICS for text files and menus")
      ZOutTxt$ = "Change from " + MID$("NAC",ZWasGR+1,1) + " to N)one, A)scii-IBM, C)olor-IBM, H)elp" + ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm = -1 THEN _
         EXIT SUB
      IF ZWasQ = 0 THEN _
         CALL QuickTPut1 ("Unchanged") : _
         EXIT SUB
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
      ZWasGR = INSTR("NAC",ZUserIn$(ZAnsIndex))
      IF ZWasGR = 2 AND NOT ZEightBit THEN _
         CALL QuickTPut1 ("Ascii unavailable.  Requires 8 bit") : _
         GOTO 43007
      IF ZWasGR = 0 THEN _
         GOTO 43006
      ZWasGR = ZWasGR - 1
      CALL SetGraphic (ZWasGR)
      END SUB
'
43031 ' $SUBTITLE: 'GraphicX - sub to find graphic version of a file'
' $PAGE
'
'  NAME    -- GraphicX
'
'  INPUTS  --     PARAMETER                    MEANING
'                 Default$              USERS GRAPHIC DEFAULT
'                 ZWasGR                WHETHER GRAPHICS ARE AVAILABLE
'                 FilName$              FILE TO CHECK
'                 FileNum               # OF FILE TO USE
'                 GMode                 DETERMINES WHETHER TO USE
'                                       FINDITX OR FINDFILE
'                                       ZFALSE = FINDITX  ZTRUE = FINDFILE
'
'                                 NOTE: FINDITX OPENS THE FILE
'                                 NOTE: FINDFILE DOES NOT OPEN FILE
'
'  OUTPUTS --     FilName$              SUBSTITUTES NAME OF GRAPHICS
'                                       FILE (IF IT EXISTS).
'
'  PURPOSE -- Checks whether there is a graphics version of
'             a file, based on users graphics perference.
'             Sets file name to graphics file if it exists,
'             Otherwise leaves file name intact.  Returns file
'             name to use.
'
      SUB GraphicX (FilName$,FileNum,GMode) STATIC
      ZOK = ZFalse
      IF ZWasGR THEN
         CALL BreakFileName (FilName$,DR$,WasX$,Extension$,ZTrue)
         IF LEN(WasX$) < 8 THEN
            Temp$ = ZUserGraphicDefault$
43033       ZWasDF$ = DR$ + WasX$ + Temp$ + Extension$
            CALL FindFile(ZWasDF$,ZOK)
            IF NOT GMode THEN _
               CALL FindItX (ZWasDF$,FileNum) _
            ELSE CALL FindFile(ZWasDF$,ZOK)
            IF Temp$ = "R" AND NOT ZOK THEN _
               Temp$ = "C" : _
               GOTO 43033
            IF ZOK THEN _
               FilName$ = ZWasDF$ : _
               IF ZUserGraphicDefault$ = "C" OR ZUserGraphicDefault$ = "R" THEN _
                  ZLinesPrinted = 0
         END IF
      END IF
      IF NOT ZOK THEN _
         IF NOT GMode THEN _
            CALL FindItX (FilName$,FileNum) _
         ELSE CALL FindFile (FilName$,ZOK)
      END SUB
'
' Sets Graphic version but uses file # 2 always
'
      SUB Graphic (FilName$,GMode)
      CALL GraphicX (FilName$,2,GMode)
      END SUB
'
43068 ' $SUBTITLE: 'SaveProf - subroutine to read a user profile'
' $PAGE
'
'  NAME    -- SaveProf
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZBPS
'              ZEightBit
'              ZExitToDoors
'              ZWasGR
'              ZMsgRec$
'              ZNodeRecIndex
'              ZSysop
'              ZUpperCase
'              ZTimeLoggedOn$
'              ZPrivateDoor
'              ZReliableMode
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- Saves a user's options and communications parameters
'             in the node record when a user exits to a "door" so
'             that he is in the same status as when he exited.
'
      SUB SaveProf (IParm) STATIC
      ON IParm GOTO 43070,43080
43070 ZActiveMessageFile$ = ZOrigMsgFile$
      ZSubParm = 3
      CALL FileLock
      CALL OpenMsg
      FIELD 1, 128 AS ZMsgRec$
      GET 1,ZNodeRecIndex
      IF ZGlobalSysop THEN _
         MID$(ZMsgRec$,1,30) = "SYSOP" + SPACE$(25)
      MID$(ZMsgRec$,40,2) = STR$(ZExitToDoors)
      MID$(ZMsgRec$,42,2) = STR$(ZEightBit)
      MID$(ZMsgRec$,44,2) = RIGHT$(STR$(-ZBPS),2)
      MID$(ZMsgRec$,46,2) = STR$(ZUpperCase)
      MID$(ZMsgRec$,48,5) = MKS$(ZNumDnldBytes!) + MID$(STR$(-ZBatchTransfer),2)
      MID$(ZMsgRec$,53,2) = STR$(ZWasGR)
      MID$(ZMsgRec$,55,2) = STR$(ZSysop)
      MID$(ZMsgRec$,65,3) = CHR$(VAL(LEFT$(ZOrigTimeLoggedOn$,2))) + _
                            CHR$(VAL(MID$(ZOrigTimeLoggedOn$,4,2))) + _
                            CHR$(VAL(MID$(ZOrigTimeLoggedOn$,7,2)))
      MID$(ZMsgRec$,72,2) = STR$(ZPrivateDoor)
      MID$(ZMsgRec$,74,1) = MID$(STR$(ZTransferFunction),2,1)
      MID$(ZMsgRec$,75,1) = ZWasFT$
      MID$(ZMsgRec$,113,2) = MKI$(CINT(ZTimeCredits!)/60)
      MID$(ZMsgRec$,91,2) = STR$(ZReliableMode)
      CALL BreakFileName (ZCurPUI$,ZOutTxt$,ZUserIn$,ZWasZ$,ZFalse)
      MID$(ZMsgRec$,93,8) = ZUserIn$ + SPACE$(8 - LEN(ZUserIn$))
      IF ZLocalUser THEN _
         ZWasZ$ = ZCarriageReturn$ + ZCarriageReturn$ _
      ELSE ZWasZ$ = " 0"
      MID$(ZMsgRec$,101,2) = ZWasZ$
      MID$(ZMsgRec$,103,2) = STR$(ZLocalUserMode)
      ZConfName$ = LEFT$(ZConfName$,INSTR(ZConfName$ + " "," ") - 1)
      MID$(ZMsgRec$,105,8) = ZConfName$ + SPACE$(8 - LEN(ZConfName$))
      MID$(ZMsgRec$,115,1) = MID$(STR$(ZAutoLogoffReq),2,1)
      MID$(ZMsgRec$,117,2) = STR$(ZMenuIndex)
      MID$(ZMsgRec$,119,2) = LEFT$(DATE$,2)
      MID$(ZMsgRec$,121,2) = MID$(DATE$,4,2)
      MID$(ZMsgRec$,123,2) = RIGHT$(DATE$,2)
      MID$(ZMsgRec$,125,2) = LEFT$(TIME$,2)
      MID$(ZMsgRec$,127,2) = MID$(TIME$,4,2)
' ***   Save additional parameters for door restoral
      CALL OpenOutW (ZNodeWorkDrvPath$+"DRST"+ZNodeFileID$+".DEF")
      CALL PrintWork (2,STR$(ZLimitMinsPerSession),ZFalse)
      CALL PrintWork (2,ZWasNG$,ZFalse)
      CALL PrintWork (2,ZIndivValue$,ZFalse)
      CALL PrintWork (2,ZOrigDateTimeOn$,ZFalse)
      CALL PrintWork (2,ZOrigTimeLoggedOn$,ZFalse)
      CALL PrintWork (2,STR$(ZUserFileIndex),ZFalse)
      CALL PrintWork (2,ZUpldDir$,ZFalse)
      ZOutTxt$ = STR$(ZUpldDir$ = ZFMSDirectory$ OR ZLimitSearchToFMS)
      CALL PrintWork (2,ZOutTxt$,ZFalse)
      CALL PrintWork (2,ZCBaud$,ZFalse)
      CALL PrintWork (2,STR$(ZGetExtDesc),ZFalse)
      CALL PrintWork (2,STR$(ZAutoLogoffReq),ZFalse)
      CALL PrintWork (2,STR$(ZHighSpeedTransfer),ZFalse)
      IF ZExtFileSysProcessor THEN _
         ZWasBatchTransfer = ZFalse
      CALL PrintWork (2,STR$(ZWasBatchTransfer),ZFalse)
      CALL PrintWork (2,ZWhoTo$,ZFalse)
      CALL PrintWork (2,STR$(ZAlreadyGiven),ZFalse)
      CALL PrintWork (2,STR$(ZSpeedFactor!),ZFalse)
      CALL PrintWork (2,ZMenuNewDate$,ZFalse)
      CALL PrintWork (2,ZMenuNewTime$,ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewUpld),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewUsers),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewCalls),ZFalse)
      CALL PrintWork (2,STR$(ZMenuNewSysop),ZFalse)
      CALL PrintWork (2,STR$(ZRIPTest),ZFalse)
      CALL PrintWork (2,ZUpldSubDir$,ZFalse)
      CALL PrintWork (2,STR$(ZGetDescAfterTransfer),ZFalse)
      CALL PrintWork (2,STR$(ZExtFileSysProcessor),ZFalse)
      CALL PrintWork (2,STR$(ZCDRom),ZFalse)
      CALL PrintWork (2,ZDooredTo$,ZFalse)
      CALL PrintWork (2,STR$(ZPersonalDnld),ZFalse)
      CALL PrintWork (2,CURDIR$,ZFalse)
      CLOSE 2
      IF ZMarkedFiles$ <> "" THEN _
         CALL OpenOutW (ZNodeWorkDrvPath$+"MARK"+ZNodeID$+".LST") : _
         CALL PrintWork (2,ZMarkedFiles$,ZFalse) : _
         CLOSE 2
43080 PUT 1,ZNodeRecIndex
      ZSubParm = 2
      CALL FileLock
      CALL OpenMsg
      END SUB
'
44000 ' $SUBTITLE: 'ReadProf - subroutine to restore a user profile'
' $PAGE
'
'  NAME    -- ReadProf
'
'  INPUTS  --     PARAMETER                    MEANING
'              ZNodeRecIndex               NODE RECORD TO USE
'              ZSysopPswd1$               SYSOP'S PSEUDONYM 1
'              ZSysopPswd2$               SYSOP'S PSEUDONYM 2
'
'  OUTPUTS -- USER'S OPTIONS AND COMMUNICATIONS PARAMETERS
'             UPON EXITING RBBS-PC TO A "DOOR"
'
'  PURPOSE -- Reset a user's options and communications parameters
'             that were saved in the node record when a user exited
'             to a "door" so that he is in the same status as when
'             he exited.
'
      SUB ReadProf STATIC
      FIELD 1, 128 AS ZMsgRec$
      GET 1,ZNodeRecIndex
      ZReliableMode = VAL(MID$(ZMsgRec$,91,2))
      MID$(ZMsgRec$,40,2) = "00"
      ZEightBit = VAL(MID$(ZMsgRec$,42,2))
      ZBPS = -VAL(MID$(ZMsgRec$,44,2))
      CALL CommInfo
      ZBaudTest! = VAL(MID$(ZBaudRates$,(-5 * ZBPS),5))
      ZUpperCase = VAL(MID$(ZMsgRec$,46,2))
      ZNumDnldBytes! = CVS(MID$(ZMsgRec$,48,4))
      ZBatchTransfer = (MID$(ZMsgRec$,52,1) = "1")
      ZWasGR = VAL(MID$(ZMsgRec$,53,2))
      HourLoggedOn$ = RIGHT$("0"+MID$(STR$(ASC(MID$(ZMsgRec$,65,1))),2),2)
      MinLoggedOn$  = RIGHT$("0"+MID$(STR$(ASC(MID$(ZMsgRec$,66,1))),2),2)
      SecLoggedOn$  = RIGHT$("0"+MID$(STR$(ASC(MID$(ZMsgRec$,67,1))),2),2)
      ZTimeLoggedOn$ = HourLoggedOn$ + _
                        ":" + _
                        MinLoggedOn$ + _
                        ":" + _
                        SecLoggedOn$
      ZTransferFunction = VAL(MID$(ZMsgRec$,74,1))
      ZWasFT$ = MID$(ZMsgRec$,75,1)
      ZTimeCredits! = 60!*CVI(MID$(ZMsgRec$,113,2))
      ZMenuIndex = VAL(MID$(ZMsgRec$,117,2))
      ZCurPUI$ = MID$(ZMsgRec$,93,8)
      CALL Remove (ZCurPUI$," ")
      IF ZCurPUI$ <> "" THEN _
         CALL BreakFileName (ZMainPUI$,ZOutTxt$,ZUserIn$,ZWasZ$,ZTrue) : _
         ZCurPUI$ = ZOutTxt$ + ZCurPUI$ + ZWasZ$
      ZCustomPUI = (ZCurPUI$ <> "")
      ZLocalUser = (MID$(ZMsgRec$,101,2) = ZCarriageReturn$ + ZCarriageReturn$)
      ZLocalUserMode = VAL(MID$(ZMsgRec$,103,2))
      ZHomeConf$ = MID$(ZMsgRec$,105,8)
      ZAutoLogoffReq = (VAL(MID$(ZMsgRec$,115,1)) <> 0)
      CALL Trim (ZHomeConf$)
      IF ZHomeConf$ = "MAIN" THEN _
         ZHomeConf$ = ""
      IF ZRequiredRings > 0 AND _
         INSTR(ZModemInitCmd$,"S0=255") THEN _
         COLOR 7,0,0 _
      ELSE COLOR ZFG,ZBG,ZBorder
      IF ZLocalUserMode THEN _
         GOTO 44003
      CALL SetBaud
44003 ZUserLogonTime! = VAL(HourLoggedOn$) * 3600! + _
                        VAL(MinLoggedOn$) * 60! + _
                        VAL(SecLoggedOn$)
      HourLoggedOn$ = ""
      MinLoggedOn$ = ""
      SecLoggedOn$ = ""
      IF ZMinsPerSession < 1 THEN _
         ZMinsPerSession = 3
      IF NOT ZEightBit THEN _
         OUT ZLineCntlReg,&H1A
      IF LEFT$(ZMsgRec$,7) = "SYSOP  " THEN _
         ZFirstName$ = ZSysopPswd1$ : _
         ZActiveUserName$ = ZSecretName$ _
      ELSE ZFirstNameEnd = INSTR(ZMsgRec$," ") : _
           ZLastNameEnd = INSTR(ZFirstNameEnd + 1,ZMsgRec$ + " ","  ") : _
           ZFirstName$ = LEFT$(ZMsgRec$,ZFirstNameEnd-1) : _
           ZLastName$ = MID$(ZMsgRec$,ZFirstNameEnd + 1,ZLastNameEnd - (ZFirstNameEnd + 1)) : _
           ZActiveUserName$ = MID$(ZFirstName$ + " " + ZLastName$,1,31)
      ZWasZ$ = ZFirstName$
      CALL OpenWork (2,ZNodeWorkDrvPath$+"DRST"+ZNodeFileID$+".DEF",ZFalse)
      CALL ReadDir (2,1)
      ZLimitMinsPerSession = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZWasNG$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZIndivValue$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZOrigDateTimeOn$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZOrigTimeLoggedOn$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZUserFileIndex = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZUpldDoor$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZFMSDoor = VAL(ZOutTxt$)
      CALL ReadDir (2,1)
      ZCBaud$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZGetExtDesc = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZAutoLogoffReq = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZHighSpeedTransfer = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZWasBatchTransfer = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZWhoTo$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZAlreadyGiven = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZSpeedFactor! = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewDate$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZMenuNewTime$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZMenuNewUpld = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewUsers = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewCalls = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZMenuNewSysop = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZRIPTest = VAL (ZOutTxt$)
      CALL ReadDir (2,1)
      ZUpldSubDir$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZGetDescAfterTransfer = (VAL(ZOutTxt$) <> 0)
      CALL ReadDir (2,1)
      ZExtFileSysProcessor = (VAL(ZOutTxt$) <> 0)
      CALL ReadDir (2,1)
      ZCDRom = (VAL(ZOutTxt$) <> 0)
      CALL ReadDir (2,1)
      ZDooredTo$ = ZOutTxt$
      CALL ReadDir (2,1)
      ZPersonalDnld = (VAL(ZOutTxt$) <> 0)
      CALL ReadDir (2,1)
      IF CURDIR$ <> ZOutTxt$ THEN
         IF LEFT$(CURDIR$,2) <> LEFT$(ZOutTxt$,2) THEN
            CHDRIVE LEFT$(ZOutTxt$,2)
         END IF
         CHDIR ZOutTxt$
      END IF
      IF ZExitToDoors AND ZDooredTo$ <> "" THEN
         CALL OpenWork (2,ZDoorsDef$,ZFalse)
         IF ZErrCode = 0 THEN
            CALL ReadParms (ZOutTxt$(),12,1)
            WHILE ZErrCode = 0 AND ZOutTxt$(1) <> ZDooredTo$
               CALL ReadParms (ZOutTxt$(),12,1)
            WEND
            IF ZOutTxt$(1) = ZDooredTo$ THEN _
               ZDoorSkipsPswd = (ZOutTxt$(6) <> "Y")
            ZDoorCarrierDropOK$ = ZOutTxt$(10)
            ZDoorDropFile$ = ZOutTxt$(11)
            ZRegDateChg = VAL(ZOutTxt$(12))
         END IF
      END IF
      CLOSE 2
      ZErrCode = 0
      CALL FindFile (ZNodeWorkDrvPath$+"MARK"+ZNodeID$+".LST",ZOK)
      IF ZOK THEN
         ZMarkedFiles$ = ""
         CALL OpenWork (2,ZNodeWorkDrvPath$+"MARK"+ZNodeID$+".LST",ZFalse)
         IF ZErrCode <> 0 THEN _
            ZErrCode = 0 : _
            GOTO 44010
         CALL ReadDir(2,1)
         DO
           CALL Trim(ZOutTxt$)
           ZMarkedFiles$ = ZMarkedFiles$ + ZOutTxt$ + _
                    ZCarriageReturn$
           CALL ReadDir(2,1)
         LOOP WHILE NOT EOF(2)
         CLOSE 2
         CALL KillWork (ZNodeWorkDrvPath$+"MARK"+ZNodeID$+".LST")
      END IF
44010 CALL DoorReturn
      END SUB
'
44020 ' $SUBTITLE: 'CommInfo - sub for variable of users baud/parity'
' $PAGE
'
'  NAME    -- CommInfo
'
'  INPUTS  --     PARAMETER                    MEANING
'                 ZBPS                BAUD RATE INDICATOR
'                 ZEightBit           INDICATE FOR N/8/1
'
'  OUTPUTS -- ZBaudParity$
'
'  PURPOSE -- Create a string that shows a users baud rate and parity
'
      SUB CommInfo
'
'
' *  DETERMINE BAUD AND PARITY
'
'
  IF ZReliableMode THEN _
     ReliableMode$ = "-R," _
  ELSE ReliableMode$ = ","
  ZBaudParity$ = MID$(ZBaudRates$,(-5 * ZBPS),5) + _
                 " BPS" + _
                 ReliableMode$ + _
                 MID$("N,8,1E,7,1",6 + 5 * ZEightBit,5)
  ZBaudTest! = VAL(ZBaudParity$)
  END SUB
'
50495 ' $SUBTITLE: 'DelayTime - sub to wait number of seconds specified'
' $PAGE
'
'  NAME    -- DelayTime
'
'  INPUTS  --     PARAMETER                    MEANING
'                 DelaySecs           NUMBER OF SECONDS TO DELAY
'                                      (0 TO 3,600)
'
'  OUTPUTS -- NONE
'
'  PURPOSE -- To wait the number of seconds indicated before
'             returning control to the calling routine.
'
      SUB DelayTime (DelaySecs)
      IF DelaySecs < 1 THEN _
         EXIT SUB
      ZDelay! = TIMER + DelaySecs
50500 CALL CheckTime(ZDelay!, TempElapsed!, 1)
      IF TempElapsed! > 0 THEN _
         CALL GoIdle : _
         GOTO 50500
      END SUB
'
52070 ' $SUBTITLE: 'ModemPut - sub to write modem commands to modem'
' $PAGE
'
'  SUBROUTINE NAME    -- ModemPut
'
'  INPUT PARAMETERS   --     PARAMETER               MEANING
'                            Strng$                MODEM COMMAND
'                            ZCmdsBetweenRings     INDICATOR TO WAIT FOR
'                                                  MODEM TO STOP RINGING
'                                                  BEFORE ISSUING COMMANDS
'                            ZDumbModem            INDICATOR THAT MODEM WOULD
'                                                  NOT UNDERSTAND COMMANDS
'
'  OUTPUT PARAMETERS  -- NONE
'
'  SUBROUTINE PURPOSE -- TO ISSUE MODEM COMMANDS TO THE MODEM
'
      SUB ModemPut (Strng$) STATIC
'
'
' *  SEND MODEM COMMAND
'
'
      IF ZDumbModem THEN _
         EXIT SUB
      IF NOT ZCmdsBetweenRings OR _
         NOT (INP(ZModemStatusReg) AND &H40) THEN _
         GOTO 52080
      ConnectDelay! = TIMER + 7
52072 IF (INP(ZModemStatusReg) AND &H40) > 0 THEN _
         CALL CheckTime(ConnectDelay!, TempElapsed!, 1) : _
         IF ZSubParm = 2 THEN _
            GOTO 52080
      GOTO 52072
52080 CALL DelayTime (ZModemCmdDelayTime)
      WasX$ = " "
      FOR WasI = 1 TO LEN(Strng$)
         LSET WasX$ = MID$(Strng$,WasI,1)
         ON INSTR("{~",WasX$) GOTO 52082,52084
            GOTO 52085
52082       LSET WasX$ = ZCarriageReturn$
            GOTO 52085
52084       CALL DelayTime (1)
            GOTO 52086
52085    CALL CommPut (WasX$)
52086 NEXT
      CALL CommPut (ZCarriageReturn$)
      END SUB
'
57001 ' $SUBTITLE: 'DispCall - subroutine to display callers file'
' $PAGE
'
'  NAME    -- DispCall
'
'  INPUTS  --     PARAMETER           MEANING
'
'  OUTPUTS --  (NONE)
'
'  PURPOSE -- Displays callers file to sysops and callers
'
      SUB DispCall STATIC
      IF ZCallersFilePrefix$ = "" THEN _
         EXIT SUB
      PrevCal$ = ZCallersFile$
      OrigCal$ = ZCallersFile$
      FullDisplay = ZSysOp OR (RIGHT$(ZLastCommand$,1) = "2")
      IF NOT FullDisplay THEN _
         GOTO 57004
      CALL LinesInFile (ZCallersLst$,NumItems)
      IF NumItems < 1 THEN _
         GOTO 57004
      IF ZAnsIndex < ZLastIndex THEN _
         GOTO 57003
57002 CALL QuickTPut1 ("Caller's logs available are:")
      ZNo = ZFalse
      LineCt = 0
      CALL OpenWork (2, ZCallersLst$,ZFalse)
      WHILE (NOT ZNo) AND (NOT EOF(2))
         LineCt = LineCt + 1
         CALL ReadDir (2,1)
         Temp = INSTR(ZOutTxt$," ")
         IF Temp = 0 THEN _
            ZOutTxt$ = " ???" _
         ELSE ZOutTxt$ = MID$(ZOutTxt$,Temp)
         ZOutTxt$ = "  " + STR$(LineCt) + "  - " + ZOutTxt$
         ZSubParm = 5
         CALL TPut
         CALL AskMore ("",ZTrue,ZTrue,WasX,ZTrue)
      WEND
57003 ZOutTxt$ = "# of caller's log ([Q]uit, L)ist, 1,...," + _
                 MID$(STR$(NumItems),2) + ")"
      CALL PopCmdStack
      WasDF$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasDF$)
      IF WasDF$ = "L" THEN _
         GOTO 57002
      CALL CheckInt (WasDF$)
      IF ZTestedIntValue <= 0 THEN _
         GOTO 57102
      IF ZTestedIntValue > NumItems THEN _
            GOTO 57003
      CALL OpenWork (2,ZCallersLst$,ZFalse)
      CALL ReadDir (2, ZTestedIntValue)
      ZCallersFile$ = LEFT$(ZOutTxt$,INSTR(ZOutTxt$+" "," ")-1)
      CALL FindIt (ZCallersFile$)
      CLOSE 2
      IF NOT ZOK THEN _
         Call QuickTPut1 ("No caller's log <"+ZCallersFile$+"> found") : _
         ZCallersFile$ = PrevCal$ : _
         GOTO 57003
      IF PrevCal$ <> ZCallersFile$ THEN _
         CALL SetCall
57004 CallersFileIndexTemp! = ZCallersFileIndex!
      CLOSE 4
      IF ZShareIt THEN _
         OPEN ZCallersFile$ FOR RANDOM SHARED AS #4 LEN=64 _
      ELSE OPEN "R",4,ZCallersFile$,64
      FIELD 4,64 AS ZCallersRecord$
      ZJumpSupported = ZTrue
      ZJumpSearching = ZFalse
      ZJumpLast$ = ""
57005 IF CallersFileIndexTemp! < 1 OR ZRet THEN _
         GOTO 57101
57010 GET 4,CallersFileIndexTemp!
      ZOutTxt$ = ZCallersRecord$
      IF LEFT$(ZOutTxt$,3) = "   " OR _
         INSTR(ZOutTxt$,"on at") = 0 THEN _
         GOTO 57030
57025 CallersFileIndexTemp! = CallersFileIndexTemp! - 1
      GET 4,CallersFileIndexTemp!
      WasZ = INSTR(ZCallersRecord$,"{")
      IF WasZ < 1 OR WasZ > 15 THEN _
         WasZ = 15
      IF FullDisplay OR _
         LEFT$(ZOutTxt$,3) <> "   " THEN _
         ZOutTxt$ = ZOutTxt$ + LEFT$(ZCallersRecord$,WasZ - 1)
      GOSUB 57100
      IF FullDisplay THEN _
         IF ZSysOp OR LEFT$(ZOutTxt$,6) <> "SYSOP " THEN _
            ZOutTxt$ = MID$(ZCallersRecord$,WasZ) : _
            GOSUB 57100
      GOTO 57045
57030 IF FullDisplay THEN _
         GOSUB 57100
57045 CallersFileIndexTemp! = CallersFileIndexTemp! -1
      GOTO 57005
57100 IF INSTR(ZOutTxt$,"LOGON DENIED") OR INSTR(ZOutTxt$,"Lvl ")THEN _
         IF NOT ZSysOp THEN _
            RETURN
      IF ZJumpSearching THEN _
         ZWasDF$ = ZOutTxt$ : _
         CALL AllCaps (ZWasDF$) : _
         IF INSTR(ZWasDF$,ZJumpTo$) = 0 THEN _
            RETURN _
         ELSE CALL CheckColor (ZOutTxt$,ZJumpTo$,"") : _
              ZJumpSearching = ZFalse
      ZSubParm = 5
      CALL TPut
      WasX = 1
      CALL AskMore ("",ZTrue,ZTrue,WasX,ZFalse)
      IF ZSubParm = -1 THEN _
         GOTO 57102 _
      ELSE IF ZNo THEN _
         GOTO 57101
      RETURN
57101 IF WasX < 999 AND FullDisplay AND NumItems > 1 THEN _
         PrevCal$ = ZCallersFile$ : _
         GOTO 57003
57102 ZJumpSupported = ZFalse
      IF OrigCal$ <> ZCallersFile$ THEN _
         ZCallersFile$ = OrigCal$ : _
         CALL SetCall
      IF NOT ZExpertUser THEN _
         CALL AskMore ("",ZTrue,ZFalse,WasX,ZTrue)
      END SUB
'
58050 ' $SUBTITLE: 'AllCaps - sub to convert string to upper case'
' $PAGE
'
'  NAME    -- AllCaps
'
'  INPUTS  --     PARAMETER           MEANING
'              ConvertField$    STRING TO MAKE UPPER CASE
'
'  OUTPUTS --  ConvertField$    CONVERTED STRINGS
'
'  PURPOSE -- Subroutine to convert a string to upper case
'
      SUB AllCaps (ConvertField$)
      ConvertField$ = UCASE$(ConvertField$)
      END SUB
'
58060 ' $SUBTITLE: 'NameCaps - sub to convert name string to Proper Case'
' $PAGE
'
'  NAME    -- NameCaps
'
'  INPUTS  --     PARAMETER           MEANING
'              ConvertField$    STRING TO CONVERT
'
'  OUTPUTS --  ConvertField$    CONVERTED STRINGS
'
'  PURPOSE -- Subroutine to convert a string to Proper Case (1st char upper)
'
      SUB NameCaps (ConvertField$)
      CALL AllCaps(ConvertField$)
      FOR WasZ = 2 TO LEN(ConvertField$)
         IF MID$(ConvertField$,WasZ,1) > "@" AND _
            MID$(ConvertField$,WasZ,1) < "[" AND _
            MID$(ConvertField$,WasZ-1,1) <> " " THEN _
            MID$(ConvertField$,WasZ,1) = CHR$(ASC(MID$(ConvertField$,WasZ,1)) OR 32)
      NEXT
      END SUB
'
58070 ' $SUBTITLE: 'CheckTime - sub to see how much time is remaining'
' $PAGE
'
'  NAME    -- CheckTime
'
'  INPUTS  -- PARAMETER               MEANING
'             TargetTime              TARGET TIME
'             ChectimeOption      1 = TELL US TIME REMAINING BETWEEN CURRENT
'                                     TIME AND TARGETTIME
'                                 2 = TELL US TIME ELAPSED BETWEEN TARGETTIME
'                                     AND CURRENT TIME
'
'  OUTPUTS -- PARAMETER               MEANING
'             TimeRemaining!      POSITIVE OR NEGATIVE NUMBER INDICATING
'                                 TIME REMAINING OR ELAPSED.  VALUE MAY BE
'                                 TESTED FOR "TIME EXPIRED".  NEGATIVE
'                                 OR ZERO, AND THE TIME HAS BEEN REACHED.
'                                 ELAPSED TIME CAN BE 0 TO 86400 (24 HRS)
'                                 TIME REMAINING CAN BE 0 TO 43200 OR
'                                  -43200 TO 0 (+ OR - 12 HRS)
'             ZSubParm (Option 1 ONLY!)
'                                 1 = Time REMAINING is > 0
'                                 2 = Time REMAINING is <= 0
'
'
'  PURPOSE -- Subroutine to provide time measurement functions.  Will
'             determine whether a target time has been reached, how much
'             time is remaining, or how much time has elapsed.
'
      SUB CheckTime (TargetTime!, TimeRemaining!, CkOption)
      IF TargetTime! > 86400 THEN _
         TestTime! = 86400 : _
         OverTime! = TargetTime! - 86400 _
      ELSE _
         TestTime! = TargetTime! : _
         OverTime! = 0
      TimeRemaining! = (TestTime! - TIMER) + OverTime!
      IF CkOption = 2 THEN GOTO 58072
      IF TimeRemaining! < -43200 THEN _
         TimeRemaining! = TimeRemaining! + 86400
      IF TimeRemaining! > 43200 THEN _
         TimeRemaining! = TimeRemaining! - 86400
      IF TimeRemaining! >= 0 THEN _
         ZSubParm = 1 _
      ELSE _
         ZSubParm = 2
      EXIT SUB
58072 IF TimeRemaining! > 0 THEN _
         TimeRemaining! = 86400 - TimeRemaining! _
      ELSE _
         TimeRemaining! = -(TimeRemaining!)
      END SUB
'
58080 ' $SUBTITLE: 'HashRBBS - sub to determine where to look for user'
' $PAGE
'
'  NAME    -- HashRBBS
'
'  INPUTS  --     PARAMETER           MEANING
'               StringToHash$    USER NAME TO LOCATE
'               MaxPosition      MAXIMUM # USERS
'
'  OUTPUTS --     PrimeHash       WHERE TO LOOK First
'                SecondHash       LOOK THIS FAR AHEAD
'
'  PURPOSE -- Where to look for a user in users file
'             Look first at prime position, then add
'             SecondHash until find or find unused record
'
      SUB HashRBBS (StringToHash$,MaxPosition,PrimeHash,SecondHash)
      SecondHash = (ASC(MID$(StringToHash$,2,1)) * 10  + 7) MOD _
           MaxPosition
      PrimeHash = _
           ((ASC(StringToHash$) * 100  + _
             ASC(MID$(StringToHash$,(LEN(StringToHash$) / 2) + .1,1)) * _
             10  + _
             ASC(RIGHT$(StringToHash$,1))) _
             MOD MaxPosition) + 1
      END SUB
'
58100 ' $SUBTITLE: 'SetOpts - sub to set prompts based on user security'
' $PAGE
'
'  NAME    -- SetOpts
'
'  INPUTS  --     PARAMETER           MEANING
'                   First             POSITION WHERE START LOOKING
'                   Last              POSITION WHERE QUIT LOOKING
'                   ZUserSecLevel     SECURITY OF USER
'
'  OUTPUTS -- Options$              LIST OF COMMANDS USER CAN DO
'
'  PURPOSE -- String together what commands user can do in a section
'
      SUB SetOpts (Options$,InvalidOptions$,First,Last)
      Options$ = ""
      InvalidOptions$ = ""
      FOR WasI = First TO Last
         IF ZUserSecLevel < ZOptSec(WasI) THEN _
            InvalidOptions$ = InvalidOptions$ + _
                               MID$(ZAllOpts$,WasI,1) _
         ELSE IF MID$(ZAllOpts$,WasI,1) <> " " THEN _
                 Options$ = Options$ + _
                            MID$(ZAllOpts$,WasI,1)
      NEXT
      CALL SortString (Options$)
      CALL SortString (InvalidOptions$)
      END SUB
'
58110 ' $SUBTITLE: 'CheckNewBul - sub to check whether got new bulletins'
' $PAGE
'
'  NAME    -- CheckNewBul
'
'  INPUTS  --     PARAMETER           MEANING
'                 LastOn$           LAST DATE OF LOGON
'                                   FORMAT MM/DD/YY
'                 ZActiveBulletins  # OF BULLETING
'                 ZBulletinPrefix$  FILESPEC FOR BULLETINS
'
'  OUTPUTS --     NumNewBullets     NUMBER OF NEW BULLETINS
'                 NewBullets$       LIST OF NEW BULLET #'S
'                 ZWasQ             WHERE LAST BULLETIN STORED
'                                   IN ZUserIn$()
'                 ZOutTxt$()        BULLETINS #'S THAT ARE NEW
'                                    (2,3,4,...)
'
'  PURPOSE -- Checks how many bulletins have system date
'             at or later than date caller last logged on
'
      SUB CheckNewBul (LastOn$,NumNewBullets,NewBullets$) STATIC
      IF ZExitToDoors OR ZBulletinPrefix$ = ZPrevPrefix$ THEN _
         EXIT SUB
      ZPrevPrefix$ = ZBulletinPrefix$
      NumNewBullets = 0
      NewBullets$ = ""
      BaseDate# = VAL(MID$(LastOn$,4,2)) + (100 * VAL(MID$(LastOn$,1,2))) + _
                   (10000# * (1900 + VAL(MID$(LastOn$,7,2))))
      CALL FindIt (ZBulletinPrefix$ + ".FCK")
      WasX = 0
      CALL SkipLine(1)
      CALL QuickTPut (ZFG9$ + "Checking new bulletins" + ZEmphasizeOff$,0)
      IF ZOK THEN _
         WHILE NOT EOF(2) : _
            INPUT #2,WasBN$ : _
            GOSUB 58112 : _
         WEND _
      ELSE FOR WasI = 1 TO ZActiveBulletins : _
              WasBN$ = MID$(STR$(WasI),2) : _
              GOSUB 58112 : _
           NEXT
      CALL QuickTPut(ZBackSpace$ + " " + ZBackSpace$,0)
      ZWasQ = NumNewBullets + 1
      IF NumNewBullets < 1 THEN _
         NewBullets$ = ""
      CALL SkipLine (1)
      IF NumNewBullets > 0 THEN _
         ZOutTxt$ = ZFG4$ + "There Are" + ZFGB$ + STR$(NumNewBullets) + _
           ZFG4$ + " New bulletin(s) since last call" + ZEmphasizeOff$ _
      ELSE _
         ZOutTxt$ = ZFG4$ + "There Are" + ZFGB$ + " NO" + _
           ZFG4$ + " New bulletin(s) since last call" + ZEmphasizeOff$
      CALL QuickTPut1 (ZOutTxt$)
      IF ZTurboLogon THEN _
         ZLinesPrinted = 0
      CALL BufString (NewBullets$,4096,WasX)
      CALL SkipLine (1)
      EXIT SUB
58112 FirstWord$ = WasBN$
      CALL Trim (FirstWord$)
      FirstWord$ = LEFT$(FirstWord$,INSTR(FirstWord$+" "," ")-1)
      IF FirstWord$ = "N" THEN _
         WasX$ = ZNewsFileName$ + CHR$(0) _
      ELSE WasX$ = ZBulletinPrefix$ + FirstWord$ + CHR$(0)
      CALL MarkTime (WasX)
      CALL RBBSFind (WasX$,WasIX,TYear,WasMM,WasDD)
      IF WasIX = 0 THEN _
         FDate# = WasDD + (100 * WasMM) + (10000# * (TYear + 1980)) : _
         IF BaseDate# <= FDate# THEN _
            NumNewBullets = NumNewBullets + 1 : _
            ZOutTxt$(NumNewBullets + 1) = FirstWord$ : _
            NewBullets$ = NewBullets$ + " " + WasBN$
      RETURN
      END SUB
'
58120 ' $SUBTITLE: 'SortString - sub to sort characters in a string'
' $PAGE
'
'  NAME    -- SortString
'
'  INPUTS  --     PARAMETER           MEANING
'                 Strng$           STRING TO SORT
'
'  OUTPUTS --     Strng$           SORTED STRING
'
'  PURPOSE -- Sorts characters in passed string.
'
      SUB SortString (Strng$) STATIC
      Sort0 = LEN(Strng$)
      Sort1 = Sort0
      WasX$ = "!"
58122 Sort1 = Sort1\2
      IF Sort1 = 0 THEN _
         EXIT SUB
      Sort2 = Sort0 - Sort1
      FOR Sort3 = 1 TO Sort2
         Sort4 = Sort3
58124    Sort5 = Sort4 + Sort1
         IF MID$(Strng$,Sort4,1) > MID$(Strng$,Sort5,1) THEN _
            LSET WasX$ = MID$(Strng$,Sort4,1) : _
            MID$(Strng$,Sort4,1) = MID$(Strng$,Sort5,1) : _
            MID$(Strng$,Sort5,1) = WasX$ : _
            Sort4 = Sort4 - Sort1 : _
            IF Sort4 > 0 THEN _
               GOTO 58124
      NEXT
      GOTO 58122
      END SUB
'
58130 ' $SUBTITLE: 'AddCommas - sub to format commands in command prompt'
' $PAGE
'
'  NAME    -- AddCommas
'
'  INPUTS  --     PARAMETER           MEANING
'                 Strng$           STRING TO REPLACE
'
'  OUTPUTS --     Strng$           REPLACED STRING
'
'  PURPOSE -- Inserts commands between each letter in Strng$
'             and encloses in pointed brackets
'
      SUB AddCommas (Strng$)
      WasL = LEN(Strng$)
      IF WasL < 1 THEN _
         EXIT SUB
      LSET ZLineMes$ = " <" + _
                      LEFT$(Strng$,1)
      FOR WasK = 2 TO WasL
         MID$(ZLineMes$,2 * WasK,2) = "," + _
                                  MID$(Strng$,WasK,1)
      NEXT
      Strng$ = LEFT$(ZLineMes$,2 * WasL + 1) + _
               ">"
      END SUB
'
58140 ' $SUBTITLE: 'CountNewFiles - subroutine to get latest uploads'
' $PAGE
'
'  NAME    --     CountNewFiles
'
'  INPUTS  --     PARAMETER           MEANING
'                 LastOn$             DATE OF LAST LOGON
'                 UPLDS$              LATEST UPLOADS
'
'  OUTPUTS --     NumNewFiles         HOW MANY AFTER LAST LOGON
'                 RptPrefix$          SET TO "At least " IF
'                                       ABOVE IS A MINIMUM
'
'  PURPOSE -- Checks how many files were uploaded on or
'             after date of last logon that the user can
'             download
'
      SUB CountNewFiles (LastOn$,NumUserFiles,RptPrefix$) STATIC
      IF ZFMSDirectory$ = "" THEN _
         EXIT SUB
      ZPrevBase$ = ""
      ZTurboBase = ZFalse
      FirstWarning = ZTrue
      IF PrevLoadNew$ = ZFMSDirectory$ THEN _
         FileDate = 0 : _
         EXIT SUB
      BaseDate = 372 * (VAL(MID$(LastOn$,7,2)) - 80) + _
                  31 * (VAL(MID$(LastOn$,1,2))) + _
                  VAL(MID$(LastOn$,4,2))
      NumNewFiles = 1
      NumUserFiles = 0
      CALL SkipLine(1)
      CALL QuickTPut (ZFG4$ + "Checking for " + ZFGB$ + "NEW" + ZFG4$ + _
                     " files " + ZEmphasizeOff$,0)
58141 PrevLoadNew$ = ZFMSDirectory$
      CALL OpenFMS (LastRec,WasL)
      FIELD 2, 23 AS PreDate$, _
                2 AS WasMM$, _
                1 AS Fill1$, _
                2 AS WasDD$, _
                1 AS Fill2$, _
                2 AS Year$, _
                (2 + ZMaxDescLen) AS Desc$, _
                3 AS Category$, _
                2 AS Fill4$
      MaxRecs = ZMaxNewFiles
      WasL = 0
      WasK = LastRec
      NumDots = 0
      WHILE WasK > 0 AND (NumNewFiles < MaxRecs OR NumUserFiles < MaxRecs)
         CALL MarkTime (NumDots)
         GET #2,WasK
         IF INSTR("*\ ",LEFT$(PreDate$,1)) > 0 THEN _
            WasK = WasK - 1 : _
            GOTO 58142
         IF (ZCanDnldFromUp OR Category$ <> ZDefaultCatCode$) THEN _
            IF VAL(Year$) > 79 THEN _
               WasL = WasL + 1 : _
               FileDate = 372! * (VAL(Year$) - 80!) + 31! * VAL(WasMM$) + VAL(WasDD$) _
            ELSE IF FirstWarning THEN _
                    FirstWarning = ZFalse : _
                    ZWasZ$ = "Invalid FMS format " + ZFMSDirectory$ : _
                    ZSnoop = ZTrue : _
                    CALL LPrnt (ZWasZ$,1) : _
                    CALL UpdtCalr (ZWasZ$,2)
         IF NOT ZCanDnldFromUp THEN _
            WasX = ZMinSecToView _
         ELSE IF Category$ = "***" THEN _
                 WasX = ZSysopSecLevel _
              ELSE IF Category$ = ZDefaultCatCode$ THEN _
                      WasX = ZMinSecToView _
              ELSE IF LEFT$(PreDate$,1) = "=" THEN _
                      CALL CheckInt (Desc$) : _
                      WasX = ZTestedIntValue _
              ELSE WasX = ZOptSec(19)
         FileSec = WasX
         WasK = WasK - 1
         IF BaseDate <= FileDate AND FileDate > 0 THEN
            IF ZUserSecLevel => FileSec THEN _
               NumUserFiles = NumUserFiles + 1
            NumNewFiles = NumNewFiles + 1
         ELSE
            GOTO 58143
         END IF
         IF FileDate < 1 THEN _
            NumNewFiles = NumNewFiles - 1
         IF BaseDate <= FileDate AND NumNewFiles > 0 THEN _
            RptPrefix$ = " At least" _
         ELSE RptPrefix$ = ""
58142 WEND
58143 CLOSE 2
      CALL QuickTPut(ZBackSpace$ + " " + ZBackSpace$,0)
      WasX$ = ZBackSpace$ + " " + ZBackSpace$
      IF ZUpInc > 0 AND ZChainedDir$ <> "" THEN _
         ZActiveFMSDir$ = ZChainedDir$ : _
         GOTO 58141
      END SUB
'
58160 ' $SUBTITLE: 'CountLines - sub to determine file categories '
' $PAGE
'
'  NAME    -- CountLines
'
'  INPUTS  -- PARAMETER             MEANING
'             ZDirCatFile$          NAME OF THE FILE THAT HAS THE
'                                   NUMBER OF CATEGORIES IN IT.
'
'  OUTPUTS -- MaxEntries           NUMBER OF FILE CATEGORIES
'
'  PURPOSE -- Subroutine to count the number of categories that a
'             file can be classified into.
'
      SUB CountLines (MaxEntries)
      CALL LinesInFile (ZDirCatFile$,MaxEntries)
      MaxEntries = MaxEntries + 4
      IF MaxEntries < 10 THEN _
         MaxEntries = 10
      END SUB
'
58161 ' $SUBTITLE: 'LinesInFile - sub to determine lines in file '
' $PAGE
'
'  NAME    -- LinesInFile
'
'  INPUTS  -- PARAMETER             MEANING
'             FilName$              NAME OF FILE TO USE
'
'  OUTPUTS -- LineCount             COUNT OF # OG LINES IN FILE
'
'  PURPOSE -- Subroutine to count the number of lines in a file
'
      SUB LinesInFile (FilName$,LineCount)
      CALL FindIt (FilName$)
      LineCount = 0
      IF ZOK THEN _
         WHILE NOT EOF(2) : _
            LineCount = LineCount + 1 : _
            LINE INPUT #2,ZOutTxt$ : _
         WEND
      CLOSE 2
      END SUB
'
58162 ' $SUBTITLE: 'InitFMS - sub to initialize file management system'
' $PAGE
'
'  NAME    -- InitFMS
'
'  INPUTS  -- PARAMETER             MEANING
'             ZFMSDirectory$
'
'  OUTPUTS -- ZCategoryName$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryCode$()  ELEMENTS 1,2, POSSIBLY MORE
'             ZCategoryDesc$()  ELEMENTS 1,2, POSSIBLY MORE
'             CategoryIndex     COUNT OF # ELEMENTS IN THE FILE
'                               MANAGMENT SYSTEM
'
'  PURPOSE -- Subroutine to initialize the RBBS-PC File Management System
'
      SUB InitFMS (CategoryIndex) STATIC
      Blank$ = " "
      CategoryIndex = 1
      ZCategoryName$(1) = "P"
      ZCategoryCode$(1) = "P"
      ZCategoryDesc$(1) = "Personals"
      IF ZFMSDirectory$ <> "" THEN _
         CategoryIndex = CategoryIndex + 1 : _
         CatN$ = ZCategoryName$(CategoryIndex) : _
         CALL BreakFileName (ZFMSDirectory$,DrvPath$,CatN$,Extension$,ZFalse) : _
         ZCategoryName$(CategoryIndex) = CatN$ : _
         ZCategoryCode$(CategoryIndex) = "" : _
         ZCategoryDesc$(CategoryIndex) = "All uploads"_
      ELSE ZLimitSearchToFMS = ZFalse : _
           EXIT SUB
      IF ZLimitSearchToFMS OR ZMasterDirName$ = ZMainFMSDir$ THEN _
         CategoryIndex = CategoryIndex + 1 : _
         ZCategoryName$(CategoryIndex) = "ALL" : _
         ZCategoryCode$(CategoryIndex) = "" : _
         ZCategoryDesc$(CategoryIndex) = "All files"
      CALL FindIt (ZDirCatFile$)
      IF NOT ZOK THEN _
         EXIT SUB
      WHILE NOT EOF(2)
         CALL ReadParms (ZWorkAra$(),3,1)
         IF ZErrCode > 0 THEN _
            ZErrCode = 0 : _
            CALL PScrn (ZDirCatFile$+" invalid.  Line" + STR$(CategoryIndex) + " needs 3 parms") : _
            CALL DelayTime (4) _
         ELSE CategoryIndex = CategoryIndex + 1 : _
              ZCategoryName$(CategoryIndex) = ZWorkAra$(1) : _
              CALL AraAllCaps (ZCategoryName$(),CategoryIndex) : _
              ZCategoryCode$(CategoryIndex) = ZWorkAra$(2) : _
              ZCategoryDesc$(CategoryIndex) = ZWorkAra$(3) : _
              CatR$ = ZCategoryCode$(CategoryIndex) : _
              CALL Remove (CatR$,Blank$) : _
              ZCategoryCode$(CategoryIndex) = CatR$
      WEND
      CLOSE 2
      END SUB
'
58165 ' $SUBTITLE: 'DispUpDir - sub to display FMS directory'
' $PAGE
'
'  NAME    -- DispUpDir
'
'  INPUTS  -- PARAMETER             MEANING
'             PassedCats$         FILE "CATEGORIES" TO BE INCLUDED IN
'                                 THE SEARCH.
'             SearchString$       STRING TO SEARCH ON WITHIN THE
'                                 FILE "CATEGORIES" SELECTED
'             SearchDate$         DATE EQUAL TO OR GREATER THAN TO BE
'                                 SEARCHED FOR WITH THE "CATEGORIES"
'                                 AND THE STRING TO SEARCH.
'             DnldFlag            SET TO RECORD # OF LINE TO BEGIN
'                                 VIEWING - 0 IF AT END
'
'  OUTPUTS -- DnldFlag            WHENEVER DOWNLOAD REQUESTED, SETS
'                                 TO 1.  OTHERWISE LEAVES AT ZERO
'  PURPOSE -- Display the files that meet the criteria selected in
'             RBBS-PC upload management system on the users screen.
'
      SUB DispUpDir (PassedCats$,SearchString$, _
                    SearchDate$,DnldFlag,AbortIndex) STATIC
      IF AtEndList THEN _
         AtEndList = ZFalse : _
         IF DnldFlag > 0 THEN _
            GOSUB 58185 : _              '  OPEN THE FMS FILE - CALL OpenFMS
            GOTO 58184
      IF ZRIPTest THEN _
         ZTurboKeyUser = ZFalse
      CALL FindLast (ZMarkedFiles$,ZCarriageReturn$,Temp,ZNumMarked)
      CALL SetExpert (ZTrue)
      ZFileNumberCount = 1
      ZMarkFileNumber$ = ""
      FirstTime = ZTrue
      TextWrap$ = ""
      PartHold$ = ""
      CALL AllCaps (SearchString$)
      Blank$ = " "
      ZStopInterrupts = ZFalse
      Categories$ = "," + _
                    PassedCats$ + _
                    ","
      IF ZMenuIndex = 6 THEN _
         CanDnld = (ZUserSecLevel => ZOptSec(41)) : _
         CanView = (ZUserSecLevel => ZOptSec(45)) _
      ELSE _
         CanDnld = (ZUserSecLevel => ZOptSec(19)) : _
         CanView = (ZUserSecLevel => ZOptSec(26))
      ZJumpSupported = ZTrue
      ZJumpSearching = ZFalse
      GOSUB 58185                        '  OPEN THE FMS FILE - CALL OpenFMS
      OrigDir$ = ZActiveFMSDir$
      InList = (RelistAt > 0 AND ReListAt <= LastRec)
      IF InList AND DnldFlag > 0 THEN _
         UpldIndex = RelistAt : _
         DnldFlag = 0 : _
         GOTO 58179
      ZJumpLast$ = ""
      SearchFor$ = SearchString$
      ExtraPrompt$ = LEFT$(",V)iew",-(6+4*ZExpertUser)*CanView)
      IF ZPersonalDnld THEN _
         ExtraPrompt$ = ExtraPrompt$ + ",*)new"
      IF CanDnld THEN _
         ExtraPrompt$ = ExtraPrompt$ + ",M)ark,D)nld"
      MaxPrint = ZPageLength - 1
      BelowMinSec = (ZUserSecLevel < ZMinSecToView)
      ZNonStop = ZNonStop OR (ZPageLength < 1)
      FMSCheckPoint = 0
      WildSearch = (INSTR(SearchString$,"?") > 0) _
                     OR (INSTR(SearchString$,"*") > 0)
      CALL AraAllCaps (ZUserIn$(),ZAnsIndex)
'print "zansindex=";zansindex;" zlastindex=";zlastindex;:for ii=zansindex to zlastindex: print "<";zuserin$(ii);">";:next:print " zlc=<";zlastcommand$;">";:print:INPUT XXX$
     IF ZAnsIndex > 0 THEN _
        IF ZLastCommand$ = "FP" AND INSTR("Ll",ZUserIn$(ZLastIndex)) = 0 THEN _
            ZUserIn$(ZAnsIndex) = "D" : _
            IF (UpldIndex > 0 AND UpldIndex <= LastRec) THEN _
               GOTO 58180 _
            ELSE Temp$ = "" : _
                 GOTO 58196
58167 IF PartHold$ <> "" THEN
         FIELD 2, EndDesc AS PartToPrint$, _
                  CatLen AS Category$, _
                  StatLen AS PersonalStatus$, _
                  2 AS Filler$
         PartHold$ = ""
         GOTO 58168
      END IF
      UpldIndex = UpldIndex + ZUpInc
      CALL CheckKBStop
      IF ZRet THEN _
         ZLinesPrinted = 999 : _
         GOTO 58178
      IF UpldIndex = CutoffRec THEN _
         GOTO 58184
      If ZActiveFMSDir$ = ZPersonalDir$ AND _
         ZViolation$ = "View ARC" THEN _
         GOTO 58198
      GET #2,UpldIndex                    ' Get FMS Record
      MarkFileHold$ = ZMarkedFiles$
      FMSCheckPoint = FMSCheckPoint + 1
58168 ON INSTR("\* =",LEFT$(PartToPrint$,1)) GOTO 58167,58171,58170,58169
      IF TextWrap$ <> "" AND NOT ZExtendedOff THEN
         PartHold$ = PartToPrint$
         PartToPrint$ = "  " + TextWrap$
         TextWrap$ = ""
         GOTO 58175
      END IF
      GOTO 58172
58169 CALL CheckInt (MID$(PartToPrint$,34))
      IF ZUserSecLevel < ZTestedIntValue THEN _
         LastOK = ZFalse : _
         FailedSearch = ZFalse : _
         GOTO 58167
      MID$(PartToPrint$,1,13) = MID$(PartToPrint$,2,12) + " "
      ZWasA = LEN(STR$(ZTestedIntValue))
      MID$(PartToPrint$,34) = MID$(PartToPrint$,34 + ZWasA) + SPACE$(ZWasA)
      GOTO 58172
58170 IF ZExtendedOff THEN _              ' Extended description
         GOTO 58167 _
      ELSE IF LastOK THEN _
         GOTO 58175 _
      ELSE IF ZJumpSearching THEN _
              GOTO 58187 _
           ELSE IF SearchString$ <> "" AND (NOT WildSearch) AND FailedSearch THEN _
                   GOTO 58187 _
                ELSE GOTO 58167
58171 IF Category$ = "***" THEN _
         GOTO 58176 _
      ELSE HoldCat$ = "," + Category$ + "," : _
           IF INSTR(Categories$,HoldCat$) > 0 THEN _
              GOTO 58176 _
           ELSE GOTO 58167
58172 LastOK = ZFalse                     ' normal file entry display
      FailedSearch = ZFalse
      LastFName = UpldIndex
      IF Category$ = "***" THEN _
         IF NOT ZSysop THEN _
            GOTO 58178
      IF Category$ = ZDefaultCatCode$ THEN _
         IF BelowMinSec THEN _
            GOTO 58178
58173 IF LEN(Categories$) > 2 THEN _
         GOSUB 58191 : _
         IF NOT CanGet THEN _
            IF CatLen < 4 OR NOT ZGlobalSysOp THEN _
               GOTO 58178
      IF ZJumpSearching OR SearchString$ <> "" THEN _
         ZOutTxt$ = PartToPrint$ : _
         IF WildSearch THEN _
            Temp$ = LEFT$(PartToPrint$,INSTR(PartToPrint$," ")-1) : _
            Temp$ = MID$(Temp$,1-(LEFT$(Temp$,1)="=")) : _
            CALL WildFile (SearchString$,Temp$,ZOK) : _
            IF ZOK THEN _
               FoundString$ = SearchString$ : _
               GOTO 58175 _
            ELSE GOTO 58178 _
         ELSE CALL AllCaps (ZOutTxt$) : _
              HiLitePos = INSTR(ZOutTxt$,SearchFor$) : _
              IF HiLitePos = 0 THEN _
                 FailedSearch = ZTrue : _
                 GOTO 58178 _
              ELSE HiLiteRec = UpldIndex : _
                   FoundString$ = SearchFor$ : _
                   IF ZJumpSearching THEN _
                      ZJumpSearching = ZFalse : _
                      SearchFor$ = PrevSearch$
58174 IF SearchDate$ <> "" THEN
         HoldCat$ = MID$(PartToPrint$,30,2) + _
                MID$(PartToPrint$,24,2) + _
                MID$(PartToPrint$,27,2)
         IF HoldCat$ < SearchDate$ THEN
            IF ZDateOrderedFMS THEN _
               GOTO 58184 _
            ELSE GOTO 58167
         END IF
      END IF
'
' * Allow the FMS to be both fast and interruptable if a local
' * user or there is nothing in the input buffer by using QuickTPut.
'
58175 LastOK = ZTrue
58176 ZWasA = EndDesc
      ZOutTxt$ = PartToPrint$
      IF LEFT$(ZOutTxt$,5) = "     " THEN _
         GOTO 58178
      IF TextWrap$ <> "" AND PartHold$ = "" AND INSTR(UCASE$(PartToPrint$),"UPLOADED BY") > 0 THEN
         ZOutTxt$ = "  " + LTRIM$(TextWrap$) + SPACE$(EndDesc - (LEN(TextWrap$) + 2))
         TextWrap$ = LTRIM$(PartToPrint$)
      ELSE
         IF TextWrap$ <> "" AND PartHold$ = "" AND LEFT$(ZOutTxt$,1) = " " THEN _
            ZOutTxt$ = "  " + LTRIM$(TextWrap$) + " " + LTRIM$(ZOutTxt$) : _
            TextWrap$ = ""
      END IF
      IF PersonalStatus$ = "*" AND LEFT$(ZOutTxt$,1) <> " " THEN _
         MID$(ZOutTxt$, INSTR(ZOutTxt$," ")) = "*"
      CALL TrimTrail (ZOutTxt$," ")
      IF LEFT$(ZOutTxt$,1) = " " THEN _
         WrapPoint = 0 _
      ELSE WrapPoint = 6
      IF LEN(ZOutTxt$) > (EndDesc - WrapPoint) THEN _
         CALL FileNumberWrap (TextWrap$)
      IF LEFT$(ZOutTxt$,1) <> " " AND NOT ZNonStop THEN _
         CALL FileNumbers (ZOutTxt$,OutTxtTemp$)
      CALL ColorDir (ZOutTxt$,"Y")
      IF ZHiLiteOff AND ZWasGR > 1 THEN _
         ZOutTxt$ = ZEscape$ + "[0m" + OutTxtTemp$ + ZOutTxt$ _
      ELSE ZOutTxt$ = OutTxtTemp$ + ZOutTxt$
      OutTxtTemp$ = ""
      IF UpldIndex = HiLiteRec THEN _
         HiLiteRec = -1 : _
         HiLitePos = 0 : _
         CALL CheckColor (ZOutTxt$,FoundString$,"")    ' HiLite found string
58177 IF ZLocalUser THEN _
         CALL QuickTPut1 (ZOutTxt$) : _         ' display to local
         GOTO 58178
      CALL EofComm (Char)
      IF Char = -1 THEN _
         CALL QuickTPut1 (ZOutTxt$) _           ' display local, not out com port
      ELSE ZSubParm = 5 : _
           CALL TPut : _                        ' display to user
           IF ZRet THEN _
              GOTO 58198                        ' Exit Subroutine
58178 IF PartHold$ <> "" THEN _
         PartToPrint$ = PartHold$
      IF ZLinesPrinted <= MaxPrint AND (FMSCheckPoint MOD 1000 <> 0) THEN _
         GOTO 58167
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         GOTO 58198
      CALL TimeRemain (MinsRemaining)
      IF MinsRemaining <= 0 THEN _
         ZSubParm = -1 : _
         GOTO 58198
      IF ZNonStop THEN _
         GOTO 58167
      IF ZLinesPrinted <= MaxPrint AND LEFT$(PartToPrint$,1) <> " " THEN _
         IF ZDateOrderedFMS AND ZMenuIndex <> 6 THEN _
            CALL QuickTPut1 (ZEmphasizeOff$ + _
               "Files checked thru " + MID$(PartToPrint$,24,8)) _
         ELSE _
            CALL QuickTPut1 (ZEmphasizeOff$ + STR$(FMSCheckPoint) + _
               " files checked")
58179 InList = (UpldIndex > 0 AND UpldIndex <= LastRec)
58180 WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF InList AND (ZAnsIndex >= ZLastIndex OR WasX$ <> "D") THEN
         ZTurboKey = -ZTurboKeyUser
         ZStackC = ZTrue
         IF MarkFileHold$ <> ZMarkedFiles$ THEN _
            CALL SetExpert (ZTrue)
         CALL AskMore (ExtraPrompt$,ZTrue,ZFalse,AbortIndex,ZFalse)
         IF ZAnsIndex = 32000 THEN _
            WasI = ZAnsIndex : _
            ZAnsIndex = 1 _
         ELSE WasI = 0 : _
              TempAns = ZAnsIndex
         IF UCASE$(ZUserIn$(ZAnsIndex)) <> "M" AND _
                 UCASE$(ZUserIn$(ZAnsIndex)) <> "V" AND _
                 UCASE$(ZUserIn$(ZAnsIndex)) <> "D" AND _
                 MarkFileHold$ <> ZMarkedFiles$ AND _
                 NOT ZPersonalDnld THEN
            WasAns$ = ZUserIn$(ZAnsIndex)
            Start = 1
            Count = 1
            Temp2$ = ""
            DO WHILE Start < LEN(ZMarkedFiles$)
                Temp = INSTR(Start,ZMarkedFiles$,ZCarriageReturn$)
                Temp$ = MID$(ZMarkedFiles$,Start,Temp-Start)
                IF INSTR(MarkFileHold$,Temp$) = 0 THEN
                   Temp2$ = Temp2$ + Temp$ + ZCarriageReturn$
                   ZUserIn$(Count) = Temp$
                   Count = Count + 1
                END IF
                Start = Temp + 1
            LOOP
            ZAnsIndex = 1
            ZLastIndex = Count - 1
            CALL MarkItems (ZTrue,Temp2$,"File",ZPersonalDnld)
            CALL SkipLine(1)
            ZWasQ = 0
            ZAnsIndex = TempAns
            ZUserIn$(ZAnsIndex) = WasAns$
            ZWasA = UpldIndex
            GOSUB 58185                   '  OPEN THE FMS FILE - CALL OpenFMS
            UpldIndex = ZWasA
         END IF
         IF WasI THEN _
            ZAnsIndex = WasI : _
            WasI = 0
         FirstTime = ZFalse
         IF ZSubParm = -1 THEN _
            EXIT SUB _
         ELSE ZLastIndex = ZWasQ :_
              IF NOT ZNo THEN _
                 ZAnsIndex = 1
      END IF
      IF ZSubParm = -1 THEN _
         GOTO 58198
      IF ZNo THEN _
         ZLastIndex = 0 : _
         GOTO 58198
      WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
      WasXX$ = WasX$

'
'print "WASX$=<";WASX$;"> zansindex=";zansindex;" zlastindex=";zlastindex;:for ii=zansindex to zlastindex: print "<";zuserin$(ii);">";:next:print:INPUT XXX$
'print "wasx$=<";wasx$;"> candnld=";candnld;" zlc=<";zlastcommand$;"> inlist=";inlist
'
58181 IF WasX$ <> "M" AND WasX$ <> "D" AND WasX$ <> "V" AND _
             VAL(WasX$) = 0 AND NOT FirstTime AND _
             (FMSCheckPoint MOD 1000 <> 0) THEN _
         IF ZFileNumberCount > 99 THEN _
            ZMarkFileNumber$ = "" : _
            ZFileNumberCount = 1
      MarkingFiles = ZFalse
      IF ((WasX$ = "D" OR WasX$ = "M") AND CanDnld) OR (WasX$ = "V" AND CanView) THEN
         MarkingFiles = (WasX$ = "M")
         IF MarkingFiles THEN
            ReListAt = UpldIndex
            IF NOT ZNulls THEN _
               ZNoAdvance = ZTrue
         END IF
         CALL AskItems ("DMV",WasX$,ZTrue,"#s or file",ZMarkedFiles$,ZPersonalDnld)
         IF ZWasQ = 0 AND NOT MarkingFiles THEN
            GOTO 58183
         END IF
         IF WasX$ = "M" THEN
            CALL WipeLine (79)
            IF NOT InList AND ZActiveFMSDir$ = ZPersonalDir$ THEN
               InList = ZTrue
               ZLastIndex = ZAnsIndex
               ZUserIn$(ZAnsIndex) = WasX$
            END IF
            ZAnsIndex = TempAns
            ZWasA = UpldIndex
            GOSUB 58185                   '  OPEN THE FMS FILE - CALL OpenFMS
            UpldIndex = ZWasA
            GOTO 58180
         END IF
      END IF
      IF WasX$ = "*" THEN IF ZPersonalDnld THEN _
         GOTO 58193
58183 IF ZJumpSearching THEN _
         PrevSearch$ = SearchFor$ : _
         SearchFor$ = ZJumpTo$ _
      ELSE SearchFor$ = SearchString$ : _
           IF NOT ZYes AND CanDnld THEN _
              GOSUB 58188 : _     ' This checks for single letters for protos
              IF WasX$ = "V" AND CanView AND ZLastIndex >= ZAnsIndex THEN _
                 ZAnsIndex = ZAnsIndex - 1 : _
                 CALL GetArc : _
                 ZWasA = UpldIndex : _
                 GOSUB 58185 : _               '  OPEN THE FMS FILE - CALL OpenFMS
                 UpldIndex = ZWasA : _
                 ZJumpSupported = ZTrue : _
                 GOTO 58180 _
              ELSE IF WasX$ <> "L" AND ZLastIndex >= ZAnsIndex AND NOT MarkingFiles THEN _
                 CALL SkipLine (1) : _
                 DnldFlag = 1 : _
                 ReListAt = UpldIndex : _
                 EXIT SUB _                        ' EXIT FOR DOWNLOADING!!
              ELSE IF UpldIndex = CutoffRec THEN _
                      GOTO 58184
      IF ZNonStop THEN IF UpldIndex > 999 THEN _
         IF (SearchDate$ = "" OR NOT ZExpertUser) THEN _
            ZOutTxt$ = STR$(UpldIndex) + _
               " lines left to search.  Really go non-stop? (Y,[N])" : _
            ZNoAdvance = ZTrue : _
            ZTurboKey = -ZTurboKeyUser : _
            ZSubParm = 1 : _
            CALL TGet : _
            CALL WipeLine (79) : _
            ZNonStop = ZYes
      GOTO 58167                     ' get next record
58184 IF ZChainedDir$ <> "" THEN _
         ZActiveFMSDir$ = ZChainedDir$ : _
         GOSUB 58185 : _
         LastFName = 0 : _
         GOTO 58167
'print "58184 ZNo=";zno;" zlistonly=";zlistonly
      IF ZNo THEN _
         GOTO 58198
      Temp$ = "End list. "
      AtEndList = ZTrue
      UpldIndex = CutOffRec - ZUpInc
      ZLastIndex = 0
      GOTO 58196
58185 IF PassedCats$ = "P" THEN _
         ZActiveFMSDir$ = ZPersonalDir$
      CALL OpenFMS (UpldIndex,CatLen)
      LastRec = UpldIndex
      EndDesc = 33 + ZMaxDescLen
      IF CatLen > 3 THEN
         IF ZActiveUserName$ <> ZOrigUserNameDGS$ THEN
            Categories$ = ZOrigUserNameDGS$
         ELSE
            Categories$ = ZActiveUserName$
         END IF
         CALL Trim (Categories$)
         Categories$ = "," + Categories$ + "," + LEFT$(",SYSOP,",-7*ZSysOp)
         CanDnld = ZTrue
         StatLen = 1
      ELSE
         StatLen = 0
      END IF
'print "58185 enddesc=";enddesc;" catlen=";catlen;" statlen=";statlen
      FIELD 2, EndDesc AS PartToPrint$, _
               CatLen AS Category$, _
               StatLen AS PersonalStatus$, _
               2 AS Filler$
      PrevFMS$ = ZActiveFMSDir$
58186 IF ZUpInc = -1 THEN _
         CutoffRec = 0 : _
         UpldIndex = LastRec + 1 _
      ELSE CutoffRec = LastRec + 1 : _
           UpldIndex = 0
      RETURN
58187 ZOutTxt$ = PartToPrint$
      CALL AllCaps (ZOutTxt$)
      HiLitePos = INSTR(ZOutTxt$,SearchFor$)
      IF HiLitePos < 1 THEN _
         GOTO 58167
      HiLiteRec = UpldIndex
      IF LastFName > 0 THEN _
         UpldIndex = LastFName
      GET 2,UpldIndex
      FoundString$ = SearchFor$
      IF ZJumpSearching THEN _
         SearchFor$ = PrevSearch$
      GOTO 58175
58188 IF ProcessedNew OR MarkingFiles OR NOT ZListOnly THEN _
         ProcessedNew = ZFalse : _
         RETURN
      ZUserIn$(0) = ""
      WasI = ZAnsIndex              ' check whether in dir
      WHILE WasI <= ZLastIndex
         CALL AraAllCaps (ZUserIn$(),WasI)
         ZWasZ$ = ZUserIn$(WasI)
         IF LEN(ZUserIn$(WasI)) < 4 THEN _
            CALL NumberCheck(ZUserIn$(WasI),FileHasLetter) _
         ELSE FileHasLetter = ZTrue
         IF ZMarkFileNumber$ <> "" AND NOT FileHasLetter THEN _
            CALL FindFileNumber (ZUserIn$(WasI),MarkFileName$,NumFound)
         IF NumFound THEN _
            ZUserIn$(WasI) = MarkFileName$
         CALL UnMarkItems (ZMarkedFiles$,WasI,ZLastIndex,WasX,ZTrue)
         Temp$ = ZUserIn$(WasI)
         CALL AllCaps (Temp$)
'print "wasi=";wasi;" temp$=<";temp$;"> Zdef=<";zdefaultxfer$;">"
         IsProto = (LEN(Temp$) = 1 AND _
                    INSTR(ZDefaultXfer$,Temp$) > 0)
         ZOK = IsProto
         WasJ = LastRec + 1
         WasX = INSTR(Temp$,".")
         AltTemp$ = ""
         IF NOT IsProto THEN _
            IF WasX = 0 THEN _
               AltTemp$ = Temp$ + "." + ZDefaultExtension$ _
            ELSE IF WasX = LEN(Temp$) THEN _
                    AltTemp$ = LEFT$(Temp$,WasX-1)
'print "58188 b4 while zok=";zok;" wasj=";wasj;" looking for <";temp$;">"
         WHILE WasJ > 1 AND NOT ZOK
            WasJ = WasJ - 1
            GET #2,WasJ
            GOSUB 58191
'print "bk 58191 canget=";catget;" ptp<";parttoprint$;">";:input xx$
            IF CanGet THEN _
               MID$(PartToPrint$,13,1) = " " : _
               ZWasY$ = LEFT$(PartToPrint$,INSTR(PartToPrint$," ") - 1) : _
               ZOK = (Temp$ = ZWasY$) : _
               IF NOT ZOK THEN _
                  IF AltTemp$ <> "" THEN _
                     ZOK = (AltTemp$ = ZWasY$)
         WEND
'print "58188 aft while zok=";zok;" wasj=";wasj;" looking for <";temp$;">":input xxx$
         IF ZOK THEN _
            GOSUB 58189 : _
            IF ZOK OR IsProto THEN _
               ZWasY$ = MID$(STR$(WasJ),2) : _
               ZUserIn$(0) = ZUserIn$(0) + _
                       ZWasY$ + _
                       SPACE$(5 - LEN(ZWasY$))
         IF NOT ZOK AND NOT IsProto THEN _
            CALL SkipLine (1) : _
            ZOutTxt$ = ZFGA$ + ZWasZ$ + ZFG1$ + _
                  " not found in Personal Files - omitted" + ZEmphasizeOff$ : _
            CALL RingCaller : _
            CALL DelayTime(1) : _
            FOR WasK = WasI + 1 TO ZLastIndex : _
               ZUserIn$(WasK - 1) = ZUserIn$(WasK) : _
            NEXT : _
            ZLastIndex = ZLastIndex - 1 : _
            WasI = WasI - 1
         WasI = WasI + 1
      WEND
      ZWasQ = ZLastIndex
'print "end 58188 zlastindex=";zlastindex;" zok=";zok
      RETURN
58189 IF IsProto THEN _
         RETURN
'
'  If not a protocol letter look for the file in the PERSONAL DIRECTORY
'
      ZUserIn$(WasI) = LEFT$(PartToPrint$,INSTR(PartToPrint$," ")-1)
      CALL FindFile (ZPersonalDrvPath$ + ZUserIn$(WasI),ZOK)
      IF ZOK THEN _
         ZUserIn$(WasI) = ZPersonalDrvPath$ + ZUserIn$(WasI) _
      ELSE CALL RotorsDir (ZUserIn$(WasI),ZSubDir$(),ZSubDirCount + _
                      ((ZUserSecLevel < ZMinSecToView) OR _
                       NOT ZCanDnldFromUp),ZTrue,"D") : _
           GOSUB 58185
      RETURN
58191 IF LEN(Categories$) < 3 THEN _
         CanGet = ZTrue : _
         RETURN
      HoldCat$ = Category$
' holdcat    = category in pers
' categories = username
      CALL TrimTrail (HoldCat$," ")
      CALL AllCaps (HoldCat$)
      HoldCat$ = "," + HoldCat$ + ","
      CanGet = (INSTR(Categories$,HoldCat$) > 0)
      IF NOT CanGet THEN _
         IF ZPersonalDnld AND ZGlobalSysOp THEN _
            CanGet = ZTrue
      IF NOT CanGet THEN _
         IF ASC(Category$) = 32 THEN _
            IF LEN(HoldCat$) > 2 THEN _
               CALL CheckInt (Category$) : _
               CanGet = (ZUserSecLevel >= ZTestedIntValue)
      RETURN
58193 GOSUB 58185                ' handle new files/personals
      PersIndex = LastRec
      ProcessedNew = ZTrue
      ZLastIndex = 0
      ZUserIn$(0) = ""
      WHILE PersIndex > 0 AND  ZLastIndex < UBOUND(ZUserIn$)
         GET 2,PersIndex
         GOSUB 58191
         IF NOT CanGet THEN _
            GOTO 58194
         IF PersonalStatus$ <> "*" THEN _
            GOTO 58194
         ZLastIndex = ZLastIndex + 1
         WasI = ZLastIndex
         GOSUB 58189
         IF ZOK THEN _
            WasX$ = MID$(STR$(PersIndex),2) : _
            ZUserIn$(0) = ZUserIn$(0) + _
                    WasX$ + _
                    SPACE$(5 - LEN(WasX$)) _
         ELSE ZLastIndex = ZLastIndex - 1
58194    PersIndex = PersIndex - 1
      WEND
      IF ZLastIndex = 0 THEN _
         ZOutTxt$ = "No new files for you" : _
         CALL QuickTPut1 (ZOutTxt$) : _
         GOTO 58183
      ZAnsIndex = 1
      GOTO 58183
58196 CALL QuickTPut (ZEmphasizeOff$,0)
      ZOutTxt$ = Temp$ + "L)ist,A)bort," + _
                 LEFT$("*)dnld new,",-11*ZPersonalDnld) + _
                 "M)ark" + LEFT$(",D)nld",-6*CanDnld) + _
                 LEFT$(",V)iew",-6*CanView) + ZPressEnterExpert$
      ZTurboKey = -ZTurboKeyUser
      IF NOT ZNulls THEN _
         ZNoAdvance = ZTrue
      CALL PopCmdStack
      WasX$ = ZUserIn$(ZAnsIndex)
      CALL AllCaps (WasX$)
      IF WasX$ = "A" THEN _
         ZRet = ZTrue
      IF ZWasQ = 0 OR ZRet OR ZSubParm < 0 THEN _
         CALL SkipLine(1) : _
         GOTO 58198
      CALL WipeLine(79)
      IF WasX$ = "L" THEN _
         ZActiveFMSDir$ = OrigDir$ : _
         GOSUB 58185 : _
         AtEndList = ZFalse : _
         GOTO 58167
      ZYes = ZFalse
      GOTO 58181
58198 CLOSE 2
      ZNonStop = (ZPageLength < 1)
      ZStopInterrupts = ZFalse
      ZOutTxt$ = ""
      ZActiveFMSDir$ = ""
      ZJumpSupported = ZFalse
      DnldFlag = 0
      EXIT SUB
      END SUB
'
91000 ' $SUBTITLE: 'MultiFile - Check user entry for a range of numbers'
' $PAGE
'
'  NAME    -- WildMark
'                                  MEANING
'
'  INPUTS  -- ZUserIn$()           USER ENTERED DATA IN THIS ARRAY
'             ZAnsIndex            STARTING NUMBER OF ARRAY VALUES
'             ZLastIndex           ENDING NUMBER OF ARRAY VALUES
'
'  OUTPUTS -- ZUserIn$()           MODIFIED ARRAY OF DATA
'             ZLastIndex           MODIFIED TO REFLECT TRUE
'                                  NUMBER OF ARRAY VALUES
'
'  PURPOSE --  To process user input (when marking files) in
'              wildcard downloading to see if one of the entries
'              is for a range of files (ex. 2-12 would be to mark
'              files 2 through 12 inclusive).
'
      SUB MultiFile
      HoldInfo$ = ""
      FOR Count = ZAnsIndex TO ZLastIndex
          HyphLoc = INSTR(ZUserIn$(Count),"-")
          IF HyphLoc > 1 THEN
             StartNum = VAL(MID$(ZUserIn$(Count),1,HyphLoc-1))
             EndNum = VAL(MID$(ZUserIn$(Count),HyphLoc+1))
             IF EndNum > StartNum THEN
                FOR Count2 = StartNum TO EndNum
                    HoldInfo$ = HoldInfo$ + STR$(Count2) + ZCarriageReturn$
                NEXT
             END IF
          ELSE
             HoldInfo$ = HoldInfo$ + ZUserIn$(Count) + ZCarriageReturn$
          END IF
      NEXT
      StartFile = 1
      EndFile = LEN (HoldInfo$)
      Count = 1
      ZUserIn$ = ""
      WHILE StartFile < EndFile
        Temp = INSTR(StartFile,HoldInfo$,ZCarriageReturn$)
        Temp$ = MID$(HoldInfo$,StartFile,Temp-StartFile)
        ZUserIn$(Count) = Temp$
        Count = Count + 1
        StartFile = Temp + 1
      WEND
      ZAnsIndex = 1
      ZLastIndex = Count - 1
      END SUB

