{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'load.int'}
{$include: 'utils.int'}
{$include: 'database.int'}
{$include: 'funs.int'}

IMPLEMENTATION OF funs;

USES types,globals,load,utils,database;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***INTERFACE TO THE COM_PAX2 ASYNCHRONOUS COMMUNICATIONS PACKAGE***}
{$include: 'com_pax2.int'}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

{***Interface to MS Pascal library***}
function freect(size:word) : word; EXTERN;

var
  cancelled [EXTERN] : boolean;
  bs_local [EXTERN] : byte;

procedure secs2time(secs : integer4; var tt : lstring);
var
  s,m : integer4;
begin
  copylst(ss[19],tt); {00:00:00}
  if secs>0 then
    [s:=secs mod 60;
     secs:=secs div 60;
     m:=secs mod 60;
     secs:=secs div 60;
     if secs<100 then
       [tt[1]:=chr(ord('0')+ord(secs div 10));
        tt[2]:=chr(ord('0')+ord(secs mod 10));
        tt[4]:=chr(ord('0')+ord(m div 10));
        tt[5]:=chr(ord('0')+ord(m mod 10));
        tt[7]:=chr(ord('0')+ord(s div 10));
        tt[8]:=chr(ord('0')+ord(s mod 10))]
     else
       [tt[1]:='9'; tt[2]:='9';
        tt[4]:='5'; tt[5]:='9';
        tt[7]:='5'; tt[8]:='9']];
end {secs2time};

procedure make12(var tt : lstring);
var
  h : integer;
begin
  if tt.len=8
    then tt.len:=5
    else return;
  h:=10*(ord(tt[1])-ord('0')) + (ord(tt[2])-ord('0'));
  if h=0 then
    [tt[1]:='1'; tt[2]:='2';
     concat(tt,' '); concat(tt,ss[24])] {AM}
  else if h<12 then
    [concat(tt,' '); concat(tt,ss[24])] {AM}
  else if h=12 then
    [concat(tt,' '); concat(tt,ss[25])] {PM}
  else
    [h:=h-12;
     tt[1]:=chr(ord('0')+ord(h div 10));
     tt[2]:=chr(ord('0')+ord(h mod 10));
     concat(tt,' '); concat(tt,ss[25])]; {PM}
end {make12};

function match_pc(const toi : member_record) : integer;
var
  pc,m,f,temp,i,j,wt1,wt2 : integer;
begin
{not relevant until logged in}
  if not q[wx].logged_in then
    [match_pc:=0; return];
{match perfectly to oneself}
  if ivalue(toi.userid) = q[wx].userid then
    [match_pc:=100; return];
{gender & orientation}
  if q[wx].my.pref[1]=mn[3][1] {S} then
    [if toi.pref[1]=mn[3][1] {S} then
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=0 else pc:=100]
     else if toi.pref[1]=mn[3][3] {G} then
       pc:=0
     else {B}
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=0 else pc:=70]]
  else if q[wx].my.pref[1]=mn[3][3] {G} then
    [if toi.pref[1]=mn[3][1] {S} then
       pc:=0
     else if toi.pref[1]=mn[3][3] {G} then
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=100 else pc:=0]
     else {B}
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=90 else pc:=0]]
  else {b}
    [if toi.pref[1]=mn[3][1] {S} then
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=0 else pc:=70]
     else if toi.pref[1]=mn[3][3] {G} then
       [if q[wx].my.gender[1]=toi.gender[1]
          then pc:=90 else pc:=0]
     else {B}
       pc:=100];
  if pc=0 then [match_pc:=0; return];
{propinquity}
  if q[wx].my.state=toi.state then
    [if q[wx].my.city[1]<>toi.city[1] then pc:=pc-10]
  else
    pc:=pc-20;
{age};
  m:=ivalue(q[wx].my.age); f:=ivalue(toi.age);
  if q[wx].my.gender[1]=mn[2][2] {F} and then
     toi.gender[1]=mn[2][1] {M} then
    [temp:=m; m:=f; f:=temp];
  if m<60 and then q[wx].my.gender[1]<>toi.gender[1]
    then pc:=pc-5*abs(((3*m+14) div 4)-f)
    else pc:=pc-5*abs(m-f);
{height}
  if q[wx].my.gender[1]=mn[2][1] {M}
    then m:=hvalue(q[wx].my.height)
    else
      [if metric
         then m:=hvalue(q[wx].my.height)+13
	 else m:=hvalue(q[wx].my.height)+5];
  if toi.gender[1]=mn[2][1] {M}
    then f:=hvalue(toi.height)
    else [if metric
     	    then f:=hvalue(toi.height)+13
	    else f:=hvalue(toi.height)+5];
  if metric
    then pc:=pc-2*abs(m-f)
    else pc:=pc-4*abs(m-f);
{weight}
  wt1:=ivalue(q[wx].my.weight);
  wt2:=ivalue(toi.weight);
  if metric then {convert kg to lb}
    [wt1:=(wt1*22) div 10;
     wt2:=(wt2*22) div 10];
  if wt1<100 then wt1:=250; {lying about weight}
  if wt2<100 then wt2:=250;
  temp:=(wt1+wt2-300) div 3; {lb}
  if wt1>200 and then wt2>200 then {both fat}
    temp:=temp div 2;
  if temp>0 then pc:=pc-temp;
{weight difference}
  if q[wx].my.gender[1]=mn[2][1] {M} and then
     toi.gender[1]=mn[2][2] {F} and then
     ivalue(q[wx].my.weight)<ivalue(toi.weight) then
    temp:=ivalue(toi.weight)-ivalue(q[wx].my.weight)
  else if q[wx].my.gender[1]=mn[2][2] {F} and then
     toi.gender[1]=mn[2][1] {M} and then
     ivalue(q[wx].my.weight)>ivalue(toi.weight) then
    temp:=ivalue(q[wx].my.weight)-ivalue(toi.weight)
  else temp:=0;
  if metric
    then pc:=pc-2*temp
    else pc:=pc-temp;
{multiple choice questions}
  for i:=1 to 2 do {based on just the first two questionnaires}
    for j:=1 to number_of_answers do
      if q[wx].my.mult_answer[i][j]<>' ' and then
         q[wx].my.mult_answer[i][j]=toi.mult_answer[i][j] then
        pc:=pc+1;
  pc:=pc-5; {allow for random hits}
{limit range}
  if pc<11 then
    match_pc:=11
  else if pc>100 then
    match_pc:=100
  else
    match_pc:=pc;
end {match_pc};

type
 jtype = (left,right,vari,vari_tr);
 wtype = (my,your,xmy,xyour,usrlog);
 ttype = (mins,hms);

var
  arg : -1..99;
  just : jtype;
  whose : wtype;
  plural : boolean;
  time_f : ttype;
  time_f2 : integer;
  min_mem : integer4;
  jlen : word;

value
  min_mem := 1048576;

procedure init_fx;
begin
  arg:=-1;
  just:=vari;
  whose:=my;
  plural:=true;
  time_f:=mins;
  time_f2:=24;
  jlen:=0;
end {init_fx};

function funx{col : integer; c1,c2 : char; var s : lstring} {boolean};
var
  cap1,cap2,ok,special : boolean;
  mrp : adr of member_record;
  qrp : adr of q_record;
  wrp : ads of window;
  i,j,k : integer;
  i4,j4 : integer4;
  qst : questions;
  p : para;
  nl : word;
  str : lstring(screen_cols+40);
  mh : mailhead;
  o2 : char;
  kill : boolean;
label
  skipcase;

  procedure expand_macro(p : para);
  var
    xarg : -1..99;
    xjust : jtype;
    xwhose : wtype;
    xplural : boolean;
    xtime_f : ttype;
    xtime_f2 : integer;
    xmin_mem : integer4;
    xjlen : word;
  begin
{save state}
    xarg:=arg; xjust:=just; xwhose:=whose; xplural:=plural;
    xtime_f:=time_f; xtime_f2:=time_f2; xmin_mem:=min_mem; xjlen:=jlen;
    macro_depth := macro_depth + 1;
{expand}
    arg:=-1; just:=vari; jlen:=0;
    copylst(p^.msg,str); delete(str,1,4);
    eval(substitute(str)); stripx(str,s);
{restore state}
    macro_depth := macro_depth - 1;
    arg:=xarg; just:=xjust; whose:=xwhose; plural:=xplural;
    time_f:=xtime_f; time_f2:=xtime_f2; min_mem:=xmin_mem; jlen:=xjlen;
  end {expand_macro};

begin
  kill:=false;
  o2:=c2;
  s.len:=0;
  if c1>='A' and then c1<='Z'
    then cap1:=true
    else cap1:=false;
  if c2>='A' and then c2<='Z'
    then cap2:=true
    else cap2:=false;
  c1:=uc(c1); c2:=uc(c2);
  wrp:=ads w^[wx]; qrp:=adr q[wx]; mrp:=adr q[wx].my;
  case whose of
    my : ;
    your : [mrp:=adr q[wx].your;
            i:=on_line(ivalue(mrp^.userid));
            if i>=0 then mrp:=adr q[i].my];
    xmy : if q[wx].index>=0 and then q[wx].index<=number_of_lines and then
             w^[q[wx].index].active and then
             w^[q[wx].index].state=going and then
             q[q[wx].index].logged_in
            then [mrp:=adr q[q[wx].index].my; qrp:= adr q[q[wx].index];
                  wrp:=ads w^[q[wx].index]]
            else kill:=true;
    xyour : if q[wx].index>=0 and then q[wx].index<=number_of_lines and then
               w^[q[wx].index].active and then
               w^[q[wx].index].state=going and then
               q[q[wx].index].logged_in
              then [mrp:=adr q[q[wx].index].your;
                    if mrp^.active[1]<>'T' then kill:=true]
              else [kill:=true; mrp:=adr q[wx].your];
    usrlog : mrp:=adr userlog_buffer;
  end {case};
  ok:=true;
  special:=false;
  nl:=0;
  p := macro_txt;
  while p<>nill do begin
    if p^.msg[2]=c1 and then p^.msg[3]=c2 and then macro_depth<6 then
      [expand_macro(p); goto skipcase];
    p := p^.link;
  end {while};
  case c1 of
    'A' : case c2 of
            '1'..'5' : {actual answer string}
                       [i:=ord(c2)-ord('0'); qst:=qair[i]; j:=0; k:=0;
                        while qst<>nil do begin
                          j:=j+1;
                          if arg=j then
			    [str.len:=wrd(qst^.nans);
			     for j:=1 to qst^.nans do
                               str[j]:=mrp^.mult_answer[i][k+j];
			     stripx(str,s);
                             break];
			  k:=k+qst^.nans;
                          qst:=qst^.link;
                        end {while}];
	    'C' : {no. of answer characters allowed}
                  [if whose=my or else whose=xmy then
		     [if qrp^.qs<>nil then
			eval(encode(s,qrp^.qs^.nans:1))]];
            'G' : {age} [stripx(mrp^.age,s); nl:=UPPER(mrp^.age)];
           {&AH shows up in uuencoded GIF files!  Hmmm}
            'N' : {allow new users} if allow_new then copylst(mn[8][2],s);
	    'S' : {multiple answer}
	    	  if whose=my and then qrp^.qa<>nill then
		    copylst(qrp^.qa^.msg,s);
            otherwise ok:=false;
          end {case};
    'B' : case c2 of
            '1' : {bump count 1 (bumpmax)}
                  [nl:=5;
                   eval(encode(s,bumpct1:1))];
            '2' : {bump count 2 (lines full)}
                  [nl:=5;
                   eval(encode(s,bumpct2:1))];
            '3' : {bump count 3 (rejects due to prime time)}
                  [nl:=5;
                   eval(encode(s,bumpct3:1))];
            'A' : {baud rate}
                  [nl:=5;
                   if whose=my or else whose=xmy then
                     eval(encode(s,wrp^.baud:1))
                   else if whose=your or else whose=xyour then
                     [i:=on_line(ivalue(mrp^.userid));
                      if i>=0 then eval(encode(s,w^[i].baud:1))]
                   else if whose=usrlog then
                     [str.len:=5;
                      movel(adr mrp^.mult_answer[5][17],adr str[1],5);
                      stripx(str,s)]];
            {&bg default macro}
	    'P' : {beep the console}
	    	  [if beep_length>0 then
		     [if arg>0
		        then [beep_on(arg*10); arg:=-1]
		        else beep_on(440);
		      clock_reset; while clock<beep_length do ;
		      beep_off];
		   special:=true];
            'T' : {bytes transferred so far or database matches}
                  [nl:=7;
                   if whose=my or else whose=xmy then
                     eval(encode(s,qrp^.count4:1))];
            'X' : {XMODEM/YMODEM blocks to download}
                  [nl:=5;
                   if whose=my or else whose=xmy then
                     [i:=ord(wrp^.ch0 div 128);
                      if (wrp^.ch0 mod 128) <> 0 then i:=i+1;
		      if (qrp^.xfermode and f128)=0 then
                        i:=(i div 8)+(i mod 8);
                      eval(encode(s,i:1))]];
            otherwise ok:=false;
          end {case};
    'C' : case c2 of
            'A' : {library category name}
                  if whose=my or else whose=xmy then
                    [stripx(qrp^.pathname,s); nl:=12;
                     for i:=ord(s.len) downto 1 do
                       if s[i]='\' or else s[i]=':' then
                         [delete(s,1,i); break]];
	    'C' : {force control-c}
	          [if whose=my then
                     [if wx=0 then cancelled:=true else force_cancel;
		      special:=true]];
	    'H' : {Open Forum channel}
                  [nl:=2;
                   if whose=my or else whose=xmy then
                     eval(encode(s,qrp^.channel:1))];
            'I' : {city} [stripx(mrp^.city,s); nl:=UPPER(mrp^.city)];
            'N' : {call number}
                  [nl:=7;
                   if whose=my or else whose=xmy then
                     eval(encode(s,qrp^.callno:1))
                   else if whose=usrlog then
                     [movel(adr mrp^.pw,adr str[1],8); str.len:=8;
                      stripx(str,s)]];
            'O' : {connect time}
                  if whose=my or else whose=xmy then
                    [i4:=jt-wrp^.connect_sec0;
                     if i4<0 then i4:=i4+one_day;
                     qrp^.minutes_on:=ord(i4 div 60);
                     if time_f=hms
                       then [secs2time(i4,s); nl:=8]
                       else [eval(encode(s,ord(i4 div 60):1)); nl:=3]]
                  else if whose=usrlog then
                    [s.len:=8;
                     movel(adr mrp^.mult_answer[5][9],adr s[1],8);
                     i4:=time2secs(s)-time2secs(mrp^.last_called_time);
                     if i4<0 then i4:=i4+one_day;
                     if time_f=hms
                       then [secs2time(i4,s); nl:=8]
                       else [eval(encode(s,ord(i4 div 60):1)); nl:=3]];
            'R' : {connect time remaining}
                  [i:=on_line(ivalue(mrp^.userid));
                   if i>=0 then [wrp:=ads w^[i]; qrp:=adr q[i]];
                   if whose=my or else whose=xmy or else i>=0 then
		     [i4:=jt-wrp^.connect_sec0;
		      if i4<0 then i4:=i4+one_day;
		      qrp^.minutes_on:=ord((i4+30) div 60);
		      j4:=qrp^.minutes_2day;      i4:=i4+60*j4;
		      j4:=time_limit[qrp^.level]; j4:=60*j4-i4;
		      if j4<0 then j4:=0;
		      if time_f=hms
		        then [secs2time(j4,s); nl:=8]
		        else [eval(encode(s,ord((j4+29) div 60):1)); nl:=3]]
                   else
		     [i4:=jd-date2jd(mrp^.last_called_date);
		      j4:=time_limit[ivalue(mrp^.userlevel)];
		      if i4=0 then
			[i4:=ivalue(mrp^.minutes_today); j4:=j4-i4];
                      if time_f=hms
                        then [j4:=60*j4; secs2time(j4,s); nl:=8]
                        else [eval(encode(s,ord(j4):1)); nl:=3]]];
            'S' : {chat status}
                  [nl:=12;
                   if mrp^.chat_ok[1]='N' then
                     stripx(ss[11],s) {NoChat}
                   else if mrp^.chat_ok[1]='L' then
                     stripx(ss[15],s) {LoginsOff}
                   else if mrp^.chat_ok[1]='P' then
                     stripx(ss[12],s) {PageOff}
                   else
                     stripx(ss[13],s); {ChatOK}
                   if whose=my or else whose=xmy then
                     [if wrp^.chat>=0 then
                        stripx(ss[5],s) {Chatting}
                      else if qrp^.group_chat then
                        stripx(ss[35],s) {OpenForum}
		      else if (not qrp^.logged_in) or else
		              qrp^.state in [news..msgs_4u,
		      			  mail_gimme1..mail_gimme1j] or else
                              ((qrp^.state=display_file) and
			       (qrp^.return_state=whoelse)) then
                        stripx(ss[32],s) {Logging On}
                      else if qrp^.state in [questionnaire..filing_it,
                                             bio..bio4] then
                        stripx(ss[8],s) {Q-aire}
		      else if qrp^.state>=ordr and then qrp^.state<=ordr6 then
		        stripx(ss[50],s) {Ordering}
		      else if qrp^.state2>0 or else
		              ((qrp^.state>=libr_transfer) and
		      	       (qrp^.state<=libr_post_up)) then
                        stripx(ss[9],s) {Library}
                      else if qrp^.state in
                                [sendmail_prompt..sendmail_cancel,
				 pubmail_send1..pubmail_send2,
				 snip..dummy] then
                        stripx(ss[10],s) {Mail}
                      else if (not chat_repeats) and then
                              ((qrp^.userid=q[wx].last_chat) or
                               (qrp^.last_chat=q[wx].userid)) then
                        stripx(ss[6],s) {NoRepeat}
                      else if qrp^.level<priv_bchatted then
                        stripx(ss[7],s) {NotChat}]];
            'T' : {count} 
                  [nl:=5;
                   if whose=my or else whose=xmy then
                     eval(encode(s,qrp^.count:1))];
            'U' : {connect time used}
                  [i:=on_line(ivalue(mrp^.userid));
                   if i>=0 then [wrp:=ads w^[i]; qrp:=adr q[i]];
                   if i>=0 and then qrp^.state>greet_user then
		     [i4:=jt-wrp^.connect_sec0;
		      if i4<0 then i4:=i4+one_day;
		      qrp^.minutes_on:=ord((i4+30) div 60);
		      j4:=qrp^.minutes_2day; i4:=i4+60*j4;
                      if time_f=hms
                        then [secs2time(i4,s); nl:=8]
                        else [eval(encode(s,ord((i4+30) div 60):1)); nl:=3]]
                   else
		     [i4:=jd-date2jd(mrp^.last_called_date);
		      if i4=0
			then j4:=ivalue(mrp^.minutes_today)
			else j4:=0;
                      if time_f=hms
                        then [j4:=60*j4; secs2time(j4,s); nl:=8]
                        else [eval(encode(s,ord(j4):1)); nl:=3]]];
            otherwise ok:=false;
          end {case};
    'D' : case c2 of
            'A' : {date} [stripx(mydate,s); nl:=UPPER(mydate)];
            'F' : {download file size in bytes}
                  [nl:=6;
                   if whose=my or else whose=xmy then
                     eval(encode(s,wrp^.ch0:1))];
            'M' : {download time in minutes}
                  [nl:=5;
                   if whose=my or else whose=xmy then
		     [i:=ord(wrp^.ch0 div (6*wrp^.baud)); {raw bandwidth}
		      i:=((i*3) div 2)+1; {overhead}
                      eval(encode(s,i:1))]];
	    'S' : {days since last call}
                  [i4:=jd-date2jd(mrp^.last_called_date);
                   eval(encode(s,i4:1)); nl:=4];
	    'W' : {day of the week 0=Monday 1=Tuesday etc.}
	          [nl:=1; eval(encode(s,(jd mod 7):1))];
            otherwise ok:=false;
          end {case};
    'E' : case c2 of
            'D' : {DOS error codes}
                  if whose=my or else whose=xmy then
                    [case qrp^.dos_err of
                       -1 : copylst('file in use',s);
                       0 : copylst('disk',s);
                       2 : copylst('file not found',s);
                       3 : copylst('path not found',s);
                       4 : copylst('too many open files',s);
                       5 : copylst('access denied',s);
		       7,8,9 : copylst('corrupt memory',s);
		       otherwise copylst('unknown',s);
                     end {case};
                     concat(s,' error, code ');
		     eval(encode(str,qrp^.dos_err:1));
		     concat(s,str)];
            'S' : {plural (es)} if plural then stripx(ss[55],s); {es}
            otherwise ok:=false;
          end {case};
    'F' : case c2 of
            'D' : {library file description}
                  [nl:=brief_len;
                   if whose=my or else whose=xmy then
                     if qrp^.xstr<>nill then
                       stripx(qrp^.xstr^.msg,s)];
            'M' : {free space in large heap -- min this bootup}
                  [i4:=mem_avl - lhc_max;
                   j4:=mbi; i4:=i4-j4;
                   eval(encode(s,i4:1)); nl:=6];
            'N' : {file number}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.userid:1))
                     else stripx(mrp^.userid,s);
                   nl:=5];
            'S' : {free space in large heap}
                  [i4:=mem_avl - lhc;
                   j4:=mbi; i4:=i4-j4;
                   eval(encode(s,i4:1)); nl:=6];
            otherwise ok:=false;
          end {case};
    'G' : case c2 of
            'E' : {gender}
                  [stripx(mrp^.gender,s); nl:=1];
	    'O' : {got order}
                  [eval(encode(s,GotOrdr:1)); nl:=1];
            {&gz default macro}
            otherwise ok:=false;
          end {case};
    'H' : case c2 of
            'A' : {handle}
                  [i:=xopen(0,'DLX.EXE'); if i>5 then mail_close(i);
                   eval(encode(s,i:1)); nl:=2];
            {&he default macro}
            {&hs default macro}
            'T' : {height} [stripx(mrp^.height,s); nl:=5];
            otherwise ok:=false;
          end {case};
    'I' : case c2 of
            'N' : {index}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.index:1));
                   nl:=5];
            otherwise ok:=false;
          end {case};
    'J' : case c2 of
	    'D' : {Julian day number}
		  [eval(encode(s,jd:1)); nl:=7];
            'K' : {junk mail pending}
                  [stripx(mrp^.junk,s); nl:=1];
            otherwise ok:=false;
          end {case};
   {'K' series used as example macros in the manual}
    'L' : case c2 of
            'C' : {library category}
                  if whose=my or else whose=xmy
                    then stripx(qrp^.pathname,s);
            'D' : {last called date}
                  [stripx(mrp^.last_called_date,s);
                   nl:=8];
            'F' : {library filename}
                  [if whose=my or else whose=xmy
                     then stripx(qrp^.filename,s);
                   nl:=12];
            'I' : {lines per message}
                  [eval(encode(s,msg_line_limit:1)); nl:=3];
	    'J' : {last called Julian date number}
		  [eval(encode(s,ord(date2jd(mrp^.last_called_date)):1));
		   nl:=7];
            'L' : {last line typed}
                  if whose=my or else whose=xmy then
                    kopylst(wrp^.strx,s);
            'M' : {largest member number ever used}
                  [eval(encode(s,largest_member_number:1)); nl:=5];
            'N' : {message line}
                  if whose=my or else whose=xmy then
                    if qrp^.msg_ptr<>nill then kopylst(qrp^.msg_ptr^.msg,s);
	    'O' : {force logoff/logout}
	          if whose=my then
		    [if wrp^.chat=0 then bs_local:=1;
                     wrp^.state:=stopping; special:=true];
            'T' : {last called time}
                  [nl:=8;
                   stripx(mrp^.last_called_time,s);
                   if time_f2=12 then make12(s)];
            'V' : {user level} [stripx(mrp^.userlevel,s); nl:=1];
            'X' : {X login}
                  [nl:=1;
                   if whose=my or else whose=xmy then
                     [if qrp^.xcall then copylst(mn[5][4],s)] {X}
                   else if whose=usrlog then
                     stripx(mrp^.active,s)];
            {&lz default macro}
            otherwise ok:=false;
          end {case};
    'M' : case c2 of
            'C' : {match last called}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.last_called:1));
                   nl:=3];
            'D' : {message date}
                  [if whose=my or else whose=xmy then
                     if qrp^.msg_date<>nill then
                       stripx(qrp^.msg_date^.msg,s);
                   nl:=8];
            'F' : {message from}
                  if whose=my or else whose=xmy then
                    if qrp^.msg_from<>nill then
                      stripx(qrp^.msg_from^.msg,s);
            'G' : {match gender}
                  [if whose=my or else whose=xmy
                     then stripx(qrp^.match_gender,s);
                   nl:=1];
            'H' : {match highest age}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.high_age:1));
                   nl:=3];
            'L' : {match lowest age}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.low_age:1));
                   nl:=3];
	    'M' : {max msg number used in private mail}
                  [nl:=3; stripx(mrp^.mbx_count,s)];
            'N' : {message number} 
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.current_msg:1));
                   nl:=2];
            'O' : {match sexual orientation - single letter}
                  [copylst(qrp^.match_pref,s); nl:=1];
            {&mp default macro}
            'Q' : {match least times called}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.least_times:1));
                   nl:=1];
            'S' : {message subject}
                  if whose=my or else whose=xmy then
                    if qrp^.msg_subject<>nill then   
                      stripx(qrp^.msg_subject^.msg,s);
            'T' : {message to}
                  if whose=my or else whose=xmy then
                    if qrp^.msg_to<>nill then
                      stripx(qrp^.msg_to^.msg,s);
            'U' : {bytes of heap memory in use}
                  [i4:=lhc; j4:=mbi; i4:=i4+j4;
                   eval(encode(s,i4:1)); nl:=6];
            {&mw default macro}
            {&mx default macro}
            {&mz default macro}
            otherwise ok:=false;
          end {case};
    'N' : case c2 of
            'A' : {name} [stripx(mrp^.name,s); nl:=name_width];
            'C' : {number of callers}
                  [eval(encode(s,number_of_calls:1)); nl:=7];
            'G' : {number of people in Open Forum/group chat}
                  [j:=0;
                   for i:=0 to number_of_lines do
                     if i<>wx and then gc(i) then
		       [if arg<1 or else arg>channels or else
		       	   arg=ord(q[i].channel) then
		          j:=j+1];
                   eval(encode(s,j:1)); nl:=2];
            'H' : {number here in this Open Forum channel}
                  [j:=0;
                   for i:=0 to number_of_lines do
                     if gc(i) and then qrp^.channel=q[i].channel then
		       j:=j+1;
                   eval(encode(s,j:1)); nl:=2];
            'M' : {number of messages}
                  [nl:=3;
                   i:=on_line(ivalue(mrp^.userid));
                   if i>=0 then
                     [j:=0; mh:=q[i].mbx_first;
                      while mh<>nil do
                        [if not mh^.deleted then j:=j+1;
                         mh:=mh^.head_link];
                      eval(encode(s,j:1))]
                   else
                     stripx(mrp^.mbx_count,s)];
            'O' : {number of people online}
                  [j:=0;
                   for i:=1 to number_of_lines do
		     if w^[i].active and then w^[i].state=going then j:=j+1;
                   eval(encode(s,j:1)); nl:=2];
            'U' : {number of users}
                  [eval(encode(s,number_of_members:1)); nl:=5];
            {&nw default macro}
            {&nz default macro}
            otherwise ok:=false;
          end {case};
    'O' : case c2 of
            'D' : {last logoff date}
                  [nl:=8;
                   if whose=my or else whose=xmy then
                      stripx(mydate,s)
                   else if whose=usrlog then
                     [s.len:=8;
                      movel(adr mrp^.mult_answer[5][1],adr s[1],8)]];
	    'F' : {open forum line}
                  if whose=my or else whose=xmy then
                    if qrp^.xstr<>nill then
                      copylst(qrp^.xstr^.msg,s);
            'T' : {last logoff time}
                  [nl:=8;
                   if whose=my or else whose=xmy then
                      stripx(mytime,s)
                   else if whose=usrlog then
                     [s.len:=8;
                      movel(adr mrp^.mult_answer[5][9],adr s[1],8)];
                   if time_f2=12 then make12(s)];
            otherwise ok:=false;
          end {case};
    'P' : case c2 of
            'C' : {match percentage}
                  [eval(encode(s,(match_pc(mrp^)):1));
                   nl:=3];
            'D' : {pubmail category date}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
                     stripx(qrp^.pm^.date,s);
                   nl:=8];
            'F' : {sexual preference - single letter}
                  [copylst(mrp^.pref,s); nl:=1];
	    'G' : {page size (for pausing)}
	    	  [if whose<>usrlog then
		     stripx(mrp^.pagesize,s);
                   nl:=2];
            'H' : {phone line}
                  [if whose=my then
                     eval(encode(s,wx:1))
                   else if whose=xmy then
                     eval(encode(s,q[wx].index:1))
                   else if whose=your or else whose=xyour then
                     [i:=on_line(ivalue(mrp^.userid));
                      if i>=0 then eval(encode(s,i:1))]
                   else if whose=usrlog then
                     stripx(mrp^.mbx_max,s);
                   nl:=2];
            'J' : {pubmail category Julian day number}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
		     eval(encode(s,ord(date2jd(qrp^.pm^.date)):1));
                   nl:=7];
            'L' : {pubmail category letter}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
                     stripx(qrp^.pm^.letter,s);
                   nl:=1];
            'M' : {pubmail category moderator}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
                     [stripx(qrp^.pm^.member,s);
		      if s<>null then
		        [concat(s,' '); eval(encode(str,qrp^.pm^.memberid:1));
			 concat(s,str)]];
                   nl:=namnumlen];
            'N' : {pubmail category name}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
                     stripx(qrp^.pm^.name,s);
                   nl:=UPPER(qrp^.pm^.name)];
	    'P' : {prevent page pause}
	          [if whose=my then [wrp^.more:=-MAXINT; special:=true]];
            'Q' : {pubmail number of messages}
                  [if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
                     eval(encode(s,qrp^.pm^.msgs:1));
                   nl:=4];
            {&pr default macro}
            {&ps default macro}
            'T' : {pubmail category time}
                  [nl:=8;
                   if ((whose=my) or (whose=xmy)) and then qrp^.pm<>nil then
		     [if qrp^.pm^.anon then
		        [if arg=1 then
		     	   copylst(ss[19],s)
			 else if arg=2 then
                           stripx(qrp^.pm^.time,s)]
                      else
		        stripx(qrp^.pm^.time,s)];
                   if time_f2=12 then make12(s)];
            {&pv default macro}
	    'X' : {password (encrypted form)}
                  [if q[wx].level=9 then stripx(mrp^.pw,s);
                   nl:=4];
            {&py default macro -- new}
            {&pz default macro}
            otherwise ok:=false;
          end {case};
    'Q' : case c2 of
            '1'..'5' : {multiple choice answer}
                       [i:=ord(c2)-ord('0'); qst:=qair[i]; j:=0;
                        while qst<>nil do begin
                          j:=j+qst^.nans;
                          if arg<=j then
                            [p:=get_answer(mrp^.mult_answer[i][arg],qst^.qna);
                             if p<>nill then
                               [stripx(p^.msg,s); dispara(p)];
                             break];
                          qst:=qst^.link;
                        end {while}];
            'R' : {multiple choice questionnaire number}
                  [if whose=my or else whose=xmy
                     then eval(encode(s,qrp^.qr:1));
                   nl:=1];
            otherwise ok:=false;
          end {case};
    'R' : case c2 of
            'H' : {room in (small) heap}
                  [i4:=freect(para_size)*para_size;
                   if i4<min_mem then min_mem:=i4;
                   eval(encode(s,i4:1)); nl:=4];
            'M' : {room in (small) heap -- minimum seen this bootup}
                  [i4:=freect(para_size)*para_size;
                   if i4<min_mem then min_mem:=i4;
                   eval(encode(s,min_mem:1)); nl:=5];
	    'N' : {random number}
	          [eval(encode(s,rand:1)); nl:=5];
	    'P' : {reset page pause count}
	          [if whose=my then [wrp^.more:=0; special:=true]];
            otherwise ok:=false;
          end {case};
    'S' : case c2 of
            'F' : {slots free in mailbox}
                  [if mrp^.userlevel[1]='9' then
                     i:=max_max_mbx
                   else
                     [i:=on_line(ivalue(mrp^.userid));
                      if i>=0 then
                        [j:=0; mh:=q[i].mbx_first;
                         while mh<>nil do
                           [if not mh^.deleted then j:=j+1;
                            mh:=mh^.head_link];
                         i:=ivalue(mrp^.mbx_max)-j; if i<0 then i:=0]
                      else
                        i:=ivalue(mrp^.mbx_max)-ivalue(mrp^.mbx_count)];
                   if whose<>usrlog then eval(encode(s,i:1)); nl:=3];
            'L' : {status line}
                  if whose=my then
                    stripx(wrp^.stat_char^.msg,s)
                  else if whose=xmy and then q[wx].index>=0 and then
                          q[wx].index<=number_of_lines then
                    [stripx(w^[q[wx].index].stat_char^.msg,s); kill:=false];
            'M' : {slots max in mailbox}
	          [if whose<>usrlog then
                     stripx(mrp^.mbx_max,s);
		   nl:=3];
            'Q' : {who's squelched}
                  [if whose=my or else whose=xmy then
                     eval(encode(s,qrp^.squelch:1));
                   nl:=5];
	    'S' : {plural (s)} if plural then stripx(ss[54],s); {s}
            'T' : {state} [stripx(mrp^.state,s); nl:=UPPER(mrp^.state)];
            otherwise [if plural then stripx(ss[54],s); {s}
                       s.len:=s.len+1; s[ord(s.len)]:=o2];
          end {case};
    'T' : case c2 of
            '0'..'9' : {time limit for each level}
                       [eval(encode(s,time_limit[ord(c2)-ord('0')]:1));
                        nl:=3];
            'C' : {times called}
                  [stripx(mrp^.times_called,s); nl:=5];
            'I' : {time}
                  [nl:=8; stripx(mytime,s);
                   if time_f2=12 then make12(s)];
            'M' : {total memory} [eval(encode(s,mem_avl:1)); nl:=6];
            {&tz default macro}
            otherwise ok:=false;
          end {case};
    'W' : case c2 of
            'T' : {weight} [stripx(mrp^.weight,s); nl:=UPPER(mrp^.weight)];
            otherwise ok:=false;
          end {case};
   {'X' codes forbidden due to conflict with &X}
    'Y' : case c2 of
            'M' : {ASCII/XMODEM/YMODEM protocols}
                  if whose=my or else whose=xmy then
                    [if qrp^.xfermode = fAscii then
		       stripx(ss[43],s)			{ASCII}
		     else if (qrp^.xfermode and fYmodem)<>0 then
                       stripx(ss[15],s)			{YMODEM}
		     else
                       [if (qrp^.xfermode and f128)<>0
		          then stripx(ss[17],s)		{XMODEM}
		          else stripx(ss[18],s)];	{XMODEM-1K}
                     if (qrp^.xfermode and fNak)<>0 then
		       [concat(s,ss[16]); stripx(s,s)]];{-G}
            otherwise ok:=false;
          end {case};
    'Z' : case c2 of
            'S' : {internal state}
                  [if whose=my then
                     eval(encode(s,ord(q[wx].state):1))
                   else if whose=xmy then
                     eval(encode(s,ord(q[q[wx].index].state):1));
                   nl:=3];
            'X' : {internal state2}
                  [if whose=my then
                     eval(encode(s,q[wx].state2:1))
                   else if whose=xmy then
                     eval(encode(s,q[q[wx].index].state2:1));
                   nl:=3];
            otherwise ok:=false;
          end {case};
{special}
    '&' : {literal ampersand}
          [s.len:=2; s[1]:='&'; s[2]:=o2; special:=true];
    '@' : {tab} [if arg=-1 then arg:=(((col-1) div 8)+1)*8+1;
                 if arg>col then
                   [s.len:=wrd(arg-col); fillc(adr s[1],s.len,' ')];
                 s.len:=s.len+1; s[ord(s.len)]:=o2; arg:=-1; special:=true];
    '0'..'9' : case c2 of
                 '0'..'9' : {arg}
                            [arg:=10*(ord(c1)-ord('0')) + (ord(c2)-ord('0'));
                             special:=true];
                 otherwise {packed single digit arg}
                       [arg:=ord(c1)-ord('0'); special:=true;
                        s.len:=1; s[1]:=o2];
               end {case};
{justifify}
    '<' : {left justify}   [just:=left; special:=true; s.len:=1; s[1]:=o2;
                            if arg>=0 then [jlen:=wrd(arg); arg:=-1]];
    '>' : {right justify}  [just:=right; special:=true; s.len:=1; s[1]:=o2;
                            if arg>=0 then [jlen:=wrd(arg); arg:=-1]];
    '~' : {variable width} [just:=vari; special:=true; s.len:=1; s[1]:=o2;
                            if arg>=0 then [jlen:=wrd(arg); arg:=-1]];
    '.' : {vari/truncate}  [just:=vari_tr; special:=true; s.len:=1; s[1]:=o2;
                            if arg>=0 then [jlen:=wrd(arg); arg:=-1]];
{whose}
    '[' : {my data} [whose:=my; special:=true; s.len:=1; s[1]:=o2];
    ']' : {your data} [whose:=your; special:=true; s.len:=1; s[1]:=o2];
    '{' : {indexed my} [whose:=xmy; special:=true; s.len:=1; s[1]:=o2];
    '}' : {indexed your} [whose:=xyour; special:=true; s.len:=1; s[1]:=o2];
    ':' : {userlog data} [whose:=usrlog; special:=true; s.len:=1; s[1]:=o2];
{time formats}
    '''': {time in minutes} [time_f:=mins; special:=true; s.len:=1; s[1]:=o2];
    '"' : {time in hh:mm:ss} [time_f:=hms; special:=true; s.len:=1; s[1]:=o2];
    '+' : {24 hour clock} [time_f2:=24; special:=true; s.len:=1; s[1]:=o2];
    '-' : {12 hour clock} [time_f2:=12; special:=true; s.len:=1; s[1]:=o2];
    otherwise ok:=false;
  end {case};
skipcase:
  if ok and then (not special) then begin
    if kill then s.len:=0;
    if s.len=1 and then s[1]='1' then plural:=false else plural:=true;
    if cap1 then
      [if cap2 then ucs(s,s) else if s.len>=1 then s[1]:=uc(s[1])]
    else if cap2 then
      lcs(s,s)
    else if o2>='0' and then o2<='9' then
      [if s.len>=1 then s[1]:=lc(s[1])];
    if jlen=0 then
      [if s.len>nl then jlen:=s.len else jlen:=nl];
    case just of
      left : [if s.len<jlen then
                fillc(adr s[ord(s.len)+1],jlen-s.len,' ');
              s.len:=jlen];
      right : [if s.len>jlen then
                 delete(s,1,ord(s.len-jlen))
               else if s.len<jlen then
                 [mover(adr s[1],adr s[ord(jlen)-ord(s.len)+1],s.len);
                  fillc(adr s[1],jlen-s.len,' ')];
               s.len:=jlen];
      vari : ;
      vari_tr : if s.len>jlen then
                  s.len:=jlen;
    end {case};
    jlen:=0;
  end {if};
  funx:=ok;
end {funx};

END.
