{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'load.int'}
{$include: 'loadinit.int'}

IMPLEMENTATION OF loadinit;

USES types,globals,utils,load;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the PASASM assembler utilities package***}
{$include: 'newasm.int'}

function get_para(var f : text) : para;
var
  s : lstring(long_line);
  p,tail,top : para;
  i : integer;
  newlines : byte;
begin
{0 lines}
  get_para:=nill;
  top:=nill;
  newlines:=0;
  repeat
    if f.errs<>0 or else eof(f) then return;
    readln(f,s); expand_tabs(s);
  until s.len<3 or else s[1]<>'&' or else s[2]<>'-' or else s[3]<>'-';
{at least one line}
  while s.len<2 or else s[1]<>'&' or else uc(s[2])<>'X' do begin
    if s=null then
      [if newlines<255 then
         newlines:=newlines+1]
    else begin
      p:=newpara(s);
      p^.crlfs:=newlines;
      newlines:=0;
      if top=nill
        then [get_para:=p; top:=p; tail:=p]
	else [tail^.link:=p; tail:=p];
      if not top^.amper then
	for i:=1 to ord(s.len) do
	  if s[i]='&' then [top^.amper:=true; break];
    end {if};
    repeat
      if f.errs<>0 or else eof(f) then return;
      readln(f,s); expand_tabs(s);
    until s.len<3 or else s[1]<>'&' or else s[2]<>'-' or else s[3]<>'-';
  end {while};
{possible blank lines at end}
  if newlines>0 then begin
    p:=newpara(null);
    p^.crlfs:=newlines-1;
    if top=nill
      then get_para:=p
      else tail^.link:=p;
  end {if};
end {get_para};

function load_qaire(const file_name : lstring) : questions;
var
  f : text;
  qs1,qs2 : questions;
  p : para;
  n : integer;
  str : lstring(30);
begin
  load_qaire:=nil;
  f.trap:=true; f.errs:=0;
  assign(f,file_name); reset(f);
  if f.errs<>0 or else eof(f) then return;
  close(f);
  f.trap:=false;
  assign(f,file_name); reset(f);
  qs1:=nil; n:=0;
  while not eof(f) do begin
    new(qs2); qs2^.link:=nil;
    readln(f,str);
    case str[str.len] of
      'N','n' : [qs2^.kind := num; str.len := str.len-1];
      'A','a' : [qs2^.kind := alf; str.len := str.len-1];
      otherwise qs2^.kind := mult;
    end {case};
    if not decode(str,qs2^.nans) then [dispose(qs2); break];
    if (n+qs2^.nans)>number_of_answers then
      qs2^.nans:=number_of_answers-n;
    n:=n+qs2^.nans;
    qs2^.qna:=get_para(f);  
    if qs1=nil
      then load_qaire:=qs2
      else qs1^.link:=qs2;
    qs1:=qs2;
    if n>=number_of_answers then break;
  end {while};
  close(f);
end {load_qaire};

function load_essay(const file_name : lstring) : essays;
var
  f : text;
  qs1,qs2 : essays;
  p : para;
  n : integer;
begin
  load_essay:=nil;
  f.trap:=true; f.errs:=0;
  assign(f,file_name);
  reset(f);
  if f.errs<>0 or else eof(f) then return;
  qs1:=nil;
  n:=0;
  while f.errs=0 and then (not eof(f)) do begin
    new(qs2); qs2^.link:=nil;
    qs2^.qna:=get_para(f);  
    if qs1=nil
      then load_essay:=qs2
      else qs1^.link:=qs2;
    qs1:=qs2;
  end {while};
  close(f);
end {load_essay};

procedure load_ss;
var
  f : text;
  i,j : integer;
  str : lstring(10);
begin
  f.trap:=true; f.errs:=0;
  assign(f,'STRINGS');
  reset(f);
  if f.errs<>0 or else eof(f) then
    [writeln('STRINGS file missing'); ret2dos(4)];
  for i:=1 to UPPER(ss) do begin
    if f.errs<>0 or else eof(f) then
      [writeln('Too few strings!'); ret2dos(4)];
    readln(f,ss[i]);
    for j:=1 to ord(ss[i].len) do
      if ss[i][j]='{' then ss[i].len:=wrd(j-1);
    while ss[i].len>0 and then ss[i][ord(ss[i].len)]=' ' do
      ss[i].len:=ss[i].len-1;
  end {for};
  for i:=37 to 39 do {can't version off}
    if ss[i].len=7 and then crc_ls(ss[i])=16#EA31 then ss[i].len:=0;
  if not eof(f) then
    writeln('Too many strings!');
  close(f);
end {load_ss};

procedure load_mn;
var
  f : text;
  i,j : integer;
  str : lstring(10);
begin
  f.trap:=true; f.errs:=0;
  assign(f,'MENUS');
  reset(f);
  if f.errs<>0 or else eof(f) then
    [writeln('MENUS file missing'); ret2dos(4)];
  for i:=1 to UPPER(mn) do begin
    if f.errs<>0 or else eof(f) then
      [writeln('Too few menus!'); ret2dos(4)];
    readln(f,mn[i]);
    for j:=1 to ord(mn[i].len) do
      if mn[i][j]='{' then mn[i].len:=wrd(j-1);
  end {for};
  if not eof(f) then
    writeln('Too many menus!');
  close(f);
end {load_mn};

procedure load_macros;
var
  f : text;
  s : lstring(long_line);
  p,tail : para;
begin
  macro_txt := nill;
  f.trap:=true; f.errs:=0;
  assign(f,'MACROS');
  reset(f);
  while f.errs=0 and then not eof(f) do begin
    readln(f,s); expand_tabs(s);
    if eq2(s,'&--') then cycle;
    for var i:=1 to ord(s.len)-2 do
      if s[i]='&' and then s[i+1]='-' and then s[i+2]='-' then
        [s.len:=wrd(i-1); break];
    while s.len>0 and then s[s.len]=' ' do s.len:=s.len-1;
    if s.len<4 or else s[1]<>'&' or else s[4]<>'=' then
      [if s=null
         then cycle
         else [writeln; writeln('Bad macro: ',s); ret2dos(4)]];
    s[2]:=uc(s[2]); s[3]:=uc(s[3]);
    p := newpara(s);
    if macro_txt=nill
      then macro_txt:=p
      else tail^.link:=p;
    tail:=p;
  end {while};
  close(f);
end {load_macros};

procedure load_script;
var
  f : text;
  i : integer;
  str : lstring(10);
  p : ads of para;
begin
  str:='MULTIPLE.0';
  for i:=1 to number_of_qaires do
    [str[10]:=chr(ord('0')+i);
     qair[i]:=load_qaire(str)];
  essay:=load_essay('ESSAY');
  order:=load_essay('ORDER');
  f.trap:=true; f.errs:=0;
  assign(f,'PROMPTS');
  reset(f);
  if f.errs<>0 or else eof(f) then
    [writeln('PROMPTS file missing'); ret2dos(4)];
  null_txt:=newpara(null);
  p:=ads top_txt;
  while p.r <= (ads pub_del_txt).r do begin
    p^:=get_para(f);
    p.r:=p.r+sizeof(p^);
  end {while};
  if pub_del_txt=nill then
    [writeln('Too few prompts!'); ret2dos(4)];
  close(f);
end {load_script};

END.
