// sample.prg
//
// This programs shows how easy it is to add pull down menus to any application

#include "inkey.ch"

STATIC slEnableOption3 := .T.                    // Is Menu 1, Option 3 enabled

function MAIN()

	LOCAL pulldown := array(4)
	LOCAL aSub1 := array(2)

   setblink(.F.)
	clear screen

	// SUB MENU SETUP
	aSub1 :=	{{{"",0,.T.},"",00,""},;
	   {{" SubMenu Option 1 ",17,.T.},"",00,"SubMenu Option 1"},;
		{{" SubMenu Option 2 ",17,.T.},"",00,"Submenu Option 2"}}

		// PULLDOWN MENU SETUP

	pulldown[1]:= {{{"  Menu 1  ",8,.T.},"",K_ALT_F,""},;
		{{" Option 1           ",2,.T.},"",00,"Menu 1, Option 1"},;
		{{" Sub-Menu, Option 2 ",2,.T.},aSub1,00,"Menu 1, Option 2 (Sub-Menu Example)"},;
		{{" Option 3           ",3,{|| check_option3() }},"",00,"Menu 1, Option 3 (Runtime enabled/disabled)"}}
	pulldown[2]:= {{{"  Menu 2  ",3,.T.},"",K_ALT_R,""},;
		{{" [a] Option A ",3,.T.},"",00,"Menu 2, Option A"},;
		{{" ------------ ",1,.F.},"",00,""},;
		{{" [b] Menu Toggle ",3,.T.},{|| menu_toggle() },00,"Toggle functionality of Menu 1, Option 3"}}
	pulldown[3]:= {{{"  About  ",3,.T.},{||about()},00,"About PDM"}}
	pulldown[4]:= {{{"  eXit  ",4,.T.},{||pdmexitprog()},K_ESC,"Exit application and return to DOS"}}

	// CLEAR SCREEN
	setcolor("w/n")
	@ 00,00,24,79 box ""

	// SETUP MENU
	pdmshow(pulldown,.T.,"SAMPLE.INI")

	// TURN OVER CONTROL TO PDM
	pdmsystem(pulldown,1,K_ALT_F)
	
	setcolor("w/n")
	clear screen
return(NIL)


function about()
	LOCAL nTop := 06, nLeft := 16, nBottom := 15, nRight := 63
	LOCAL cScreen := savescreen(01,00,23,79)

	setcolor("bg+/b")
	@ nTop,nLeft clear to nBottom,nRight+1
	@ nTop,nLeft to nBottom,nRight+1
	pdmshadow(nTop,nLeft,nBottom,nRight+1,08)
	@ nTop+02,nLeft+02 say 'PDM - Pull Down Menu System'
	@ nTop+04,nLeft+02 say 'Two Guys Software'
	inkey(0)
	restscreen(01,00,23,79,cScreen)
return(NIL)


function menu_toggle()
	// This function toggles the state of menu 1, option 3
	slEnableOption3 := !slEnableOption3
return(NIL)


function check_option3()
	// This function checks the state of menu 1, option 3
return(slEnableOption3)
