# MAKE file for EEREM using Watcom 9.5 WMAKE.  You may have to change
#  the paths to the AutoCAD files here and in the .LNK files; my AutoCAD
#  DOS is in C:\ACAD12 and my AutoCAD Windos is in D:\ACAD12_W.

# Usage:
#  WMAKE /f eerem system=DOS
#        or
#  WMAKE /f eerem system=WIN
#        For debuggin, add DEBUG=TRUE to the end of the command line

# Pointers to AutoCAD; assuming each has an ADS subdirectory and the Windows
#  version has an ADS\WIN subdirectory.

acad_dos_path=d:\acad12\
acad_win_path=d:\acad12_w\

# Set up for Windows or DOS:

!ifeq system WIN
!ifeq DEBUG TRUE
wcc_command=/d2 /DWIN=1 /DWATWIN=1 /s /j /fpi87 /3s /zW /oiltpm
wlink_command=DEBUG ALL LIBPATH $(acad_win_path)ADS @eeremwin.lnk FILE $(acad_win_path)ADS\WINADS.OBJ
!endif
!ifneq DEBUG TRUE
wcc_command=/DWIN=1 /DWATWIN=1 /s /j /fpi87 /3s /zW /oiltpm
wlink_command=LIBPATH $(acad_win_path)ADS @eeremwin.lnk FILE $(acad_win_path)ADS\WINADS.OBJ
!endif
wbind_command=wbind eerem -R /v /i$(acad_win_path)ads\win eerem.rc eerem.exe
final_ext=EXE
object_files=eer_core.obj eer_dlg.obj eer_intf.obj eer_main.obj eer_util.obj $(acad_win_path)ADS\WINADS.OBJ
!endif

!ifeq system DOS
!ifeq DEBUG TRUE
wcc_command=/fpi87 /s /3s /oiltpm /d2
wlink_command=DEBUG ALL LIBPATH $(acad_dos_path)ads @eeremdos.lnk
!endif
!ifneq DEBUG TRUE
wcc_command=/fpi87 /s /3s /oiltpm
wlink_command=LIBPATH $(acad_dos_path)ads @eeremdos.lnk
!endif
wbind_command=
final_ext=EXP
object_files=eer_core.obj eer_dlg.obj eer_intf.obj eer_main.obj eer_util.obj
!endif

# Use implicit rule for .C extensions

.c.obj:
        wcc386 $[* $(wcc_command) 

# Define how to link

eerem.$(final_ext) : $(object_files)
        wlink $(wlink_command)
!ifeq system WIN
        $(wbind_command)
!endif

# Define dependencies for compiling

eer_core.obj : eer_core.c eerem.h

eer_dlg.obj : eer_dlg.c eerem.h

eer_intf.obj : eer_intf.c eerem.h

eer_main.obj : eer_main.c eerem.h

eer_util.obj : eer_util.c eerem.h



