/* ***************************************************************

An AutoCAD ADS program to remove "extra entities"

This module contains the interface function EEREM that may be
called from ADS or LISP

Jon Fleming    CIS 70334,2443    July 19, 1994

Public Domain; Please give me credit if you use this or any
significant portion of it

Revision history:

July 19, 1994  Version 1.0 Initial release

*********************************************************** */

#include  "adslib.h"
#include "eerem.h"

/* Indicators for whether to consider layer, linetype, and/or color */

extern int CheckLayer, CheckLType, CheckColor;

/* Tolerance within which numbers are considered equal (at least, that's
   approximately what this is; see below for more detail)  */

extern ads_real Tolerance;

/* Function prototypes */

int eerem ();

/* Function to perform Extra Entity Removal on a supplied selection
   set.  Callable from AutoLISP or another ADS app.

   AutoLISP usage:

   (eerem sel_set checklayer checkltype checkcolor tolerance)

   where:

   sel_set is a selection set, and is required.

   checklayer is NIL to count entities on different layers as the same,
   non-NIL to count entities on different layers as different.  checklayer
   is optional (default NIL) unless one or more of the following arguments
   are supplied.

   checkltype is NIL to count entities with different linetypes as the same,
   non-NIL to count entities with different linetypes as different.  checkltype
   is optional (default NIL) unless one or more of the following arguments
   are supplied.

   checkcolor is NIL to count entities with different colors as the same,
   non-NIL to count entities with different colors as different.  checkcolor
   is optional (default NIL) unless one or more of the following arguments
   are supplied.

   tolerance is a real number that measures how close points must be to be
   considered the same (well, approximately; see the DOC file for more
   detail).  tolerance is optional.  The default is 0.00001.

   ADS usage:

   Call eerem through ads_invoke with a list corresponding to the AutoLISP
   parameters.

   Return value:

   NIL / RSERR if an error was detected

   T / RSRSLT otherwise
*/

int eerem () {

   struct resbuf *Argument = NULL;

   int ArgNum = 1, stat = RSRSLT;

   ads_name SelSet;

   /* Assume the worst */

   ads_retnil();

   if ((Argument = ads_getargs()) == NULL) {
      ads_printf("\nEEREM error:  no arguments\n");
      return (RSERR);
   }

   if (Argument->restype != RTPICKS) {
      ads_printf("\nEEREM error:  first argument must be a selection set\n");
      return (RSERR);
   }

   ads_name_set(Argument->resval.rlname, SelSet);

   while ((Argument = Argument->rbnext) != NULL) {

      /* Arguments 2 through 4 we don't care about the type unless they're
         NIL.  Argument 5 must be a real */

      switch (ArgNum = ++ArgNum) {
         case 2: {
            CheckLayer = (Argument->restype == RTNIL) ? FALSE : TRUE;
            break;
         }
         case 3: {
            CheckLType = (Argument->restype == RTNIL) ? FALSE : TRUE;
            break;
         }
         case 4: {
            CheckColor = (Argument->restype == RTNIL) ? FALSE : TRUE;
            break;
         }
         case 5: {
            if (Argument->restype == RTREAL) {
               Tolerance = Argument->resval.rreal;
               break;
            }
            else {
               ads_printf("\nEEREM error:  fifth argument must be a real number\n");
               return (RSERR);
            }
         }
         default: {
            ads_printf("\nEEREM error: too many arguments\n");
            return (RSERR);
         }
      }
   }

   DoEntityRemoval (SelSet);

   ads_rett();

   return (RSRSLT);

}
