/* ***************************************************************

An AutoCAD ADS program to remove "extra entities"

This module contains the main routine and the global variables
used by multiple modules

Jon Fleming    CIS 70334,2443    July 19, 1994

Public Domain; Please give me credit if you use this or any
significant portion of it

Revision history:

July 19, 1994  Version 1.0 Initial release

*********************************************************** */

#include  <stdio.h>
#include  "adslib.h"
#include "eerem.h"

extern int eerem ();
extern int ddeerem ();

/* Indicators for whether to consider layer, linetype, and/or color */

int CheckLayer = FALSE, CheckLType = FALSE, CheckColor = FALSE;

/* Tolerance within which numbers are considered equal (at least, that's
   approximately what this is; see the documentation and core module for
   more detail)  */

ads_real Tolerance = 0.00001;


/* The constant 2*pi */

ads_real TwoPi;

void main(argc, argv)
  int argc;
  char *argv[];
{
   int stat;
   short scode = RSRSLT;             /* This is the default result code */


   ads_init(argc, argv);             /* Initialize the interface */


   for ( ;; ) {

      if ((stat = ads_link(scode)) < 0) {
         /* Can't use ads_printf to display 
            this message, because the link failed */
         printf("O-PROJ: bad status from ads_link() = %d\n", stat);
         fflush(stdout);
         exit(1);
      }

         scode = RSRSLT;               /* Default return value */

         switch (stat) {

            case RQXLOAD:              /* Define our functions to AutoLISP
                                          and ADS */

               scode = ads_defun("eerem", 0) ? RSRSLT : RSERR;

               if (scode != RSERR)
                  scode = ads_regfunc (eerem, 0) ? RSRSLT : RSERR;

               if (scode != RSERR)
                  scode = ads_defun("ddeerem", 1) ? RSRSLT : RSERR;

               if (scode != RSERR)
                  scode = ads_regfunc (ddeerem, 0) ? RSRSLT : RSERR;

               if (scode != RSERR)
                  scode = ads_defun("C:ddeerem", 2) ? RSRSLT : RSERR;

               break;

            case RQSUBR:               /* Execute a function */

               switch (ads_getfuncode()) {
                  case 0:
                     /* Non-dialog version called from ADS or AutoLISP */
                     eerem();
                     break;
                  case 1:
                     /* Dialog box version called from ADS or AutoLISP */
                     ddeerem();
                     break;
                  case 2:
                     /* Dialog box version called from command line */
                     ddeerem();
                     break;
               }
               break;

            default:
               break;
            }
      }
}
