/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: /usr/fsys/odin/a/vern/flex/RCS/flex.skel,v 2.16 90/08/03 14:09:36 vern Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif	/* __GNUC__ */

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_PROTOS
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#define const
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()

#ifdef __TURBOC__
#include <alloc.h>
#include <io.h>
#else
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
char *malloc();
int free();
int read();
#endif
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, yytext is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
	    YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		YY_FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do \
		{ \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void )) 

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR char
#define INITIAL 0
/**************************************************************************/
/*    MODULE: bat2csh.l                                                   */
/*   PURPOSE: converts dos batch files to unix csh files                  */
/*    AUTHOR: Bill Pierpoint                                              */
/*       LEX: FLEX Version 2.3.7                                          */
/*  COMPILER: Borland C Version 3.1                                       */
/* COPYRIGHT: None.  Public Domain.                                       */
/*   VERSION: 1.00                                                        */
/*   RELEASE: January 12, 1994                                            */
/**************************************************************************/
#include <stdc.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif

#define putstr(s)	fputs((s),  stdout)
#define puttab()	fputc('\t', stdout)
#define putln()		fputc('\n', stdout)
#define token(t)	(t)
#define ckeol(t)	do { if((t)==EOL) { puts(" ### SYNTAX ERROR ###"); \
                          errorcount++; return;} } while(0)
#define cktok(t, x)	do { if((t)!=(x)) { puts(" ### SYNTAX ERROR ###"); \
                          errorcount++; eattokens(); return;} } while(0)

typedef struct
{
	int token;
	void (*fn)(void);
} FNTBL;

#define STRBUFSIZE	129
char textbuf[STRBUFSIZE];

/**************************************************************************/
/* token enumeration                                                      */
/**************************************************************************/
enum {
	OTHER=1,
	EOL,
	SPACE,
	VARIABLE,
	PARAMETER,
	WORD,
	INIT_CALL,
	INIT_ECHO,
	INIT_FOR,
	INIT_GOTO,
	INIT_IF,
	INIT_PATH,
	INIT_PAUSE,
	INIT_REM,
	INIT_SET,
	INIT_SHIFT,
	INIT_LABEL,
	INIT_COMMAND,
	ECHO_ON,
	ECHO_OFF,
	ECHO_DOT,
	IF_NOT,
	IF_ERRORLEVEL,
	IF_EXIST,
	FOR_VARIABLE,
	FOR_IN,
	FOR_WORDLIST,
	FOR_DO
};

/**************************************************************************/
/* function prototypes                                                    */
/**************************************************************************/
/* support functions */
char *cvt_parameter(char *s);
char *cvt_variable(char *s);
char *cvt_for_variable(char *s);
char *cvt_set_variable(int token);
char *cvt_token(int token, char *s);
int dispatch(void);
void indent(void);
int lex(void);
void putbacktoken(void);
void puttokln(int token, char *start, char *end);
int  reporterrors(void);
void terminate(void);
char *tr(char *s, int oldch, int newch);

/* keyword functions */
void kw_call(void);
void kw_command(void);
void kw_echo(void);
void kw_for(void);
void kw_goto(void);
void kw_if(void);
void kw_label(void);
void kw_ln(void);
void kw_path(void);
void kw_pause(void);
void kw_remark(void);
void kw_set(void);
void kw_shift(void);

#define ECHOS 1
#define TEXT 2
#define FOR 3

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = yy_bp; \
	yyleng = yy_cp - yy_bp; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do \
		{ \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;	

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 33
typedef int yy_state_type;
static const short int yy_accept[94] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   33,   31,
       29,   28,   14,   14,   14,   14,   14,   14,   14,   14,
       14,   13,    1,   30,   17,   30,   21,   31,   30,   30,
       31,   31,   31,   31,   29,   14,   14,   14,   14,   14,
        6,   14,   14,   14,   14,   12,   30,   30,   15,   21,
        0,    0,   23,   30,   30,   30,    0,   26,   25,   14,
       14,    4,   14,   14,   14,    8,    9,   14,   16,   22,
       24,   30,   30,   18,   27,    2,    3,    5,   10,   14,
       14,   30,   30,    7,   11,   30,   20,   30,   30,   30,
       30,   19,    0

    } ;

static const YY_CHAR yy_ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    4,    4,    6,    4,    5,    7,
        8,    5,    5,    5,    4,    9,    5,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   11,    2,    5,
        2,    5,    5,   12,   13,    4,   14,   15,   16,   17,
       18,   19,   20,    4,    4,   21,   22,   23,   24,   25,
        4,   26,   27,   28,   29,   30,    4,   31,    4,    4,
        5,    5,    5,    5,    5,    5,   13,    4,   14,   15,

       16,   17,   18,   19,   20,    4,    4,   21,   22,   23,
       24,   25,    4,   26,   27,   28,   29,   30,    4,   31,
        4,    4,    4,    5,    4,    4,    1
    } ;

static const YY_CHAR yy_meta[32] =
    {   0,
        1,    1,    1,    2,    3,    4,    2,    5,    3,    2,
        3,    3,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2
    } ;

static const short int yy_base[102] =
    {   0,
        0,   21,   33,   57,   81,  104,  126,  145,  112,  200,
      109,  200,    0,   96,   94,   79,   78,   84,   87,   83,
       21,    0,  200,    0,    0,   21,   96,   35,   17,   72,
       89,    0,   70,   70,   90,    0,   70,   71,   63,   60,
        0,   18,   64,   57,   60,    0,    0,   62,    0,   76,
       71,    0,   70,   49,   54,   45,   64,  200,  200,   50,
       46,    0,   45,   49,   40,    0,    0,   48,    0,  200,
        0,   40,   35,    0,  200,    0,    0,    0,    0,   45,
       28,   29,   26,    0,    0,   32,    0,   36,   21,   34,
       28,    0,  200,  165,  170,  174,  178,  182,  186,  191,

      194
    } ;

static const short int yy_def[102] =
    {   0,
       93,    1,   94,   94,   94,   94,   95,   95,   93,   93,
       93,   93,   96,   96,   96,   96,   96,   96,   96,   96,
       96,   97,   93,   98,   98,   98,   93,   99,   98,   98,
       93,  100,   93,   93,   93,   96,   96,   96,   96,   96,
       96,   96,   96,   96,   96,   97,   98,   98,   98,   93,
       99,  101,   99,   98,   98,   98,  100,   93,   93,   96,
       96,   96,   96,   96,   96,   96,   96,   96,   98,   93,
      101,   98,   98,   98,   93,   96,   96,   96,   96,   96,
       96,   98,   98,   96,   96,   98,   98,   98,   98,   98,
       98,   98,    0,   93,   93,   93,   93,   93,   93,   93,

       93
    } ;

static const short int yy_nxt[232] =
    {   0,
       10,   11,   12,   13,   10,   10,   13,   13,   10,   13,
       10,   10,   13,   14,   13,   15,   16,   17,   13,   18,
       13,   13,   13,   13,   19,   20,   21,   13,   13,   13,
       13,   22,   23,   10,   11,   12,   44,   48,   10,   45,
       52,   25,   54,   49,   53,   64,   65,   55,   92,   91,
       90,   89,   88,   87,   86,   85,   26,   10,   11,   12,
       84,   83,   10,   82,   81,   25,   80,   79,   78,   77,
       76,   75,   74,   73,   72,   70,   70,   50,   69,   68,
       26,   10,   27,   12,   67,   66,   28,   63,   62,   61,
       60,   35,   59,   58,   52,   56,   29,   50,   43,   42,

       41,   40,   39,   30,   10,   27,   12,   38,   37,   28,
       35,   93,   93,   93,   93,   93,   93,   93,   93,   29,
       93,   93,   93,   93,   93,   93,   30,   11,   12,   93,
       93,   31,   32,   93,   93,   93,   93,   93,   93,   93,
       33,   93,   93,   93,   93,   34,   11,   12,   93,   93,
       31,   32,   93,   93,   93,   93,   93,   93,   93,   33,
       93,   93,   93,   93,   34,   24,   24,   24,   24,   24,
       10,   10,   10,   10,   10,   36,   93,   93,   36,   46,
       93,   93,   46,   47,   47,   93,   47,   51,   93,   51,
       51,   57,   57,   57,   57,   71,   93,   93,   71,    9,

       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93
    } ;

static const short int yy_chk[232] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    2,    3,    3,    3,   21,   26,    3,   21,
       28,    3,   29,   26,   28,   42,   42,   29,   91,   90,
       89,   88,   86,   83,   82,   81,    3,    4,    4,    4,
       80,   73,    4,   72,   68,    4,   65,   64,   63,   61,
       60,   57,   56,   55,   54,   53,   51,   50,   48,   45,
        4,    5,    5,    5,   44,   43,    5,   40,   39,   38,
       37,   35,   34,   33,   31,   30,    5,   27,   20,   19,

       18,   17,   16,    5,    6,    6,    6,   15,   14,    6,
       11,    9,    0,    0,    0,    0,    0,    0,    0,    6,
        0,    0,    0,    0,    0,    0,    6,    7,    7,    0,
        0,    7,    7,    0,    0,    0,    0,    0,    0,    0,
        7,    0,    0,    0,    0,    7,    8,    8,    0,    0,
        8,    8,    0,    0,    0,    0,    0,    0,    0,    8,
        0,    0,    0,    0,    8,   94,   94,   94,   94,   94,
       95,   95,   95,   95,   95,   96,    0,    0,   96,   97,
        0,    0,   97,   98,   98,    0,   98,   99,    0,   99,
       99,  100,  100,  100,  100,  101,    0,    0,  101,   93,

       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93,   93,   93,   93,   93,   93,   93,   93,   93,   93,
       93
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start;
	if ( yy_bp[-1] == '\n' )
	    ++yy_current_state;
yy_match:
	do
	    {
	    register YY_CHAR yy_c = yy_ec[*yy_cp];
	    if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = yy_def[yy_current_state];
		if ( yy_current_state >= 94 )
		    yy_c = yy_meta[yy_c];
		}
	    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	    ++yy_cp;
	    }
	while ( yy_base[yy_current_state] != 200 );

yy_find_action:
	yy_act = yy_accept[yy_current_state];

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
;
	YY_BREAK
case 2:
return token(INIT_CALL);
	YY_BREAK
case 3:
return token(INIT_ECHO);
	YY_BREAK
case 4:
return token(INIT_FOR);
	YY_BREAK
case 5:
return token(INIT_GOTO);
	YY_BREAK
case 6:
return token(INIT_IF);
	YY_BREAK
case 7:
return token(INIT_PAUSE);
	YY_BREAK
case 8:
return token(INIT_REM);
	YY_BREAK
case 9:
return token(INIT_SET);
	YY_BREAK
case 10:
return token(INIT_PATH);
	YY_BREAK
case 11:
return token(INIT_SHIFT);
	YY_BREAK
case 12:
return token(INIT_LABEL);
	YY_BREAK
case 13:
return token(INIT_REM);
	YY_BREAK
case 14:
return token(INIT_COMMAND);
	YY_BREAK
case 15:
return token(ECHO_ON);
	YY_BREAK
case 16:
return token(ECHO_OFF);
	YY_BREAK
case 17:
return token(ECHO_DOT);
	YY_BREAK
case 18:
return token(IF_NOT);
	YY_BREAK
case 19:
return token(IF_ERRORLEVEL);
	YY_BREAK
case 20:
return token(IF_EXIST);
	YY_BREAK
case 21:
return token(SPACE);
	YY_BREAK
case 22:
return token(VARIABLE);
	YY_BREAK
case 23:
return token(PARAMETER);
	YY_BREAK
case 24:
return token(FOR_VARIABLE);
	YY_BREAK
case 25:
return token(FOR_IN);
	YY_BREAK
case 26:
return token(FOR_DO);
	YY_BREAK
case 27:
return token(FOR_WORDLIST);
	YY_BREAK
case 28:
return token(EOL);
	YY_BREAK
case 29:
;
	YY_BREAK
case 30:
return token(WORD);
	YY_BREAK
case 31:
return token(OTHER);
	YY_BREAK
case 32:
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(ECHOS):
case YY_STATE_EOF(TEXT):
case YY_STATE_EOF(FOR):
    yyterminate();

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    register YY_CHAR *yy_bp = yytext;

    yy_current_state = yy_start;
    if ( yy_bp[-1] == '\n' )
	++yy_current_state;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
	if ( yy_accept[yy_current_state] )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	    {
	    yy_current_state = yy_def[yy_current_state];
	    if ( yy_current_state >= 94 )
		yy_c = yy_meta[yy_c];
	    }
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	}

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
	{
	yy_last_accepting_state = yy_current_state;
	yy_last_accepting_cpos = yy_cp;
	}
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	{
	yy_current_state = yy_def[yy_current_state];
	if ( yy_current_state >= 94 )
	    yy_c = yy_meta[yy_c];
	}
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_base[yy_current_state] == 200);

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

#ifdef __cplusplus
		    return ( yyinput() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
		    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }


#ifdef __BORLANDC__
#pragma option -w
#endif

/**************************************************************************/
/* global variables                                                       */
/**************************************************************************/
int cmdtoken;         /* first token in each batch line */
int errorcount=0;     /* syntax error counter */
int errorlevelflag=0; /* control use of "set errorlevel=$status" */
int indentlevel=0;    /* indent level of output */

/**************************************************************************/
/* support functions                                                      */
/**************************************************************************/
/* report any errors */
int reporterrors()
{
    char s[7];

    if (errorcount) {
        itoa(errorcount, s, 10);
        fputs("\n\nNUMBER OF ERRORS = ", stderr);
        fputs(s, stderr);
        fputs("\n\n", stderr);
        return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
}

/* abnormal termination */
void terminate(void)
{
    putln();
    puts(" ### PREMATURE END-OF-FILE ###");
    errorcount++;
    exit(reporterrors());
}

/* wrapper for yylex */
int lex(void)
{
    int result;         /* return result */
    static int count=0; /* count number of times yylex returns 0 */
    
    result = yylex();
    if (!result) {
        if (count==1) {
            terminate();
        } else {    /* handle possible premature eof */
            count++;
            result = EOL;
        }
    }
    return result;
}

/* indent output based on global indentlevel */
void indent(void)
{
    int i;
    
    for (i=0; i<indentlevel; i++) puttab();
}

/* put token back to input stream */
/* note: flex 2.3.7 yyless(0) not available in section 3 */
void putbacktoken(void)
{
    int i;

    for (i=yyleng-1; i>=0; i--) {
        unput(yytext[i]);
    }
}

/* translate character in string s */
char *tr(char *s, int oldch, int newch)
{
    char *sp = s;

    do {
        if (*sp==oldch) *sp=newch;
    } while (*sp++);
    return s;
}

/* convert replaceable parameter, e.g. %1 -> $1 */
char *cvt_parameter(char *s)
{
    strcpy(textbuf, s);
    *textbuf='$';
    return textbuf;
}

/* convert variable, e.g. %PATH% -> ${path} */
char *cvt_variable(char *s)
{
    char *sp;

    strcpy(textbuf, "${");
    sp = s;
    sp++;
    strncat(textbuf, sp, yyleng-2);
    strcat(textbuf, "}");
    return strlwr(textbuf);
}

/* convert variable used with 'for' keyword, e.g. %%F -> ${f} */
char *cvt_for_variable(char *s)
{
    char *sp;

    strcpy(textbuf, "${");
    sp = s;
    sp += 2;
    strncat(textbuf, sp, yyleng-2);
    strcat(textbuf, "}");
    return strlwr(textbuf);
}

/* convert variable used with set keyword, e.g. ${f} -> f */ 
char *cvt_set_variable(int token)
{
    int len;

    switch(token) {
    case VARIABLE:
    case FOR_VARIABLE:
        len = strlen(textbuf)-2;
        memmove(textbuf, textbuf+2, len);
        textbuf[len-1]='\0';
        break;
    default:
        break;
    }
    return textbuf;
}

/* convert from batch format to csh format */
char *cvt_token(int token, char *s)
{
    char *sp, *tp=textbuf;

    switch(token) {
    case PARAMETER:
        if (s) cvt_parameter(s);
        else   cvt_parameter(yytext);
        break;
    case VARIABLE:
        if (s) cvt_variable(s);
        else   cvt_variable(yytext);
        break;
    case FOR_VARIABLE:
        if (s) cvt_for_variable(s);
        else   cvt_for_variable(yytext);
        break;
    case SPACE:
        if (s) strcpy(textbuf, s);
        else   strcpy(textbuf, yytext);
        /* translate delimiter if set or path */
        if (cmdtoken==INIT_SET || cmdtoken==INIT_PATH)
            tr(textbuf, ';', ' ');
        break;
    default:
        if (s) strcpy(textbuf, s);
        else   strcpy(textbuf, yytext);
        tr(textbuf, '/', '-');      /* translate options specifier */
        tr(textbuf, '\\', '/');     /* translate directory separator */
        sp = strchr(textbuf, ':');  /* skip over drive specifier */
        if (sp) { 
            tp = ++sp;
        }
        /* convert to lower case unless remark or echo */
        if (!(cmdtoken==INIT_REM || cmdtoken==INIT_ECHO) || 
              strchr(tp, '/') || strchr(textbuf, ':')) {
            strlwr(tp);
        }
        break;
    }
    return tp;
}

/* print text associated with remaining tokens on line */
void puttokln(int token, char *start, char *end)
{
   char *tp;

   BEGIN(TEXT);
   ckeol(token);
   if (start) {
        tp = cvt_token(token, start);
        /* translate names of common commands */
        if (!strcmp(tp, "chdir")) strcpy(tp, "cd");
        else if (!strcmp(tp, "cls")) strcpy(tp, "clear");
        else if (!strcmp(tp, "command")) strcpy(tp, "csh");
        else if (!strcmp(tp, "copy")) strcpy(tp, "cp");
        else if (!strcmp(tp, "del")) strcpy(tp, "rm");
        else if (!strcmp(tp, "dir")) strcpy(tp, "ls");
        else if (!strcmp(tp, "erase")) strcpy(tp, "rm");
        else if (!strcmp(tp, "md")) strcpy(tp, "mkdir");
        else if (!strcmp(tp, "move")) strcpy(tp, "mv");
        else if (!strcmp(tp, "print")) strcpy(tp, "pr");
        else if (!strcmp(tp, "rd")) strcpy(tp, "rmdir");
        else if (!strcmp(tp, "ren")) strcpy(tp, "mv");
        else if (!strcmp(tp, "rename")) strcpy(tp, "mv");
        else if (!strcmp(tp, "time")) strcpy(tp, "date");
        else if (!strcmp(tp, "type")) strcpy(tp, "cat");
        else if (!strcmp(tp, "xcopy /s")) strcpy(tp, "cp -r");
        else if (!strcmp(tp, "xcopy")) strcpy(tp, "cp");
        putstr(tp);
   }
   while ((token=lex())!=EOL) {
       putstr(cvt_token(token, NULL));
   }
   if (end) {
       putstr(end);
   }
   putln();
}

/* eat remainder of line */
void eattokens(void)
{
   BEGIN(TEXT);
   while (lex()!=EOL) ;
}

/**************************************************************************/
/* batch keyword functions                                                */
/**************************************************************************/
void kw_call(void)
{
    errorlevelflag=0;
    indent();
    puttokln(INIT_CALL, "csh ", NULL);
}

void kw_command(void)
{
    int token;

    errorlevelflag=0;
    putbacktoken();
    BEGIN(TEXT);
    token = lex();
    indent();
    puttokln(token, yytext, NULL);
}

void kw_echo(void)
{
    int token;
    
    BEGIN(ECHOS);
    token = lex();
    switch(token) {
    case ECHO_ON:
        eattokens();
        break;
    case ECHO_OFF:
        eattokens();
        break;
    case ECHO_DOT:
        indent();
        puts("echo ''");
        eattokens();
        break;
    case EOL:
        break;
    default:
        indent();
        putstr("echo ");
        putbacktoken();
        puttokln(INIT_ECHO, NULL, NULL);
        break;
    }
}

void kw_for(void)
{
    int token;
    
    BEGIN(FOR);
    indent();
    putstr("foreach ");

    /* get variable */
    token = lex();
    ckeol(token);
    cktok(token, FOR_VARIABLE);
    if (yyleng>2) putstr(yytext+2);

    /* check for "in" keyword */
    token = lex();
    ckeol(token);
    cktok(token, FOR_IN);
    putstr(" ");

    /* get wordlist */
    token = lex();
    ckeol(token);
    cktok(token, FOR_WORDLIST);
    putstr(yytext);

    /* check for "do" keyword */
    token = lex();
    ckeol(token);
    cktok(token, FOR_DO);
    putln();

    /* process command */
    indentlevel++;
    if (dispatch()==EOF) terminate();
    indentlevel--;

    /* end foreach */
    indent();
    puts("end");
}

void kw_goto(void)
{
    indent();
    puttokln(INIT_GOTO, yytext, NULL);
}

void kw_if(void)
{
    int token;
    int not = 0;
    char *sp, strbuf[STRBUFSIZE];

    BEGIN(TEXT);
    for (;;) {
        while ((token=lex())==SPACE) ;
        ckeol(token);
        switch (token) {
        case IF_NOT:
            not = !not;
            continue;
        case IF_ERRORLEVEL:
            if (errorlevelflag==0) {
                errorlevelflag=1;
                indent();
                puts("set errorlevel=$status");
            }
            while ((token=lex())==SPACE) ;
            ckeol(token);
            indent();
            if (not) {
                putstr("if (${errorlevel} < ");
            } else {
                putstr("if (${errorlevel} >= ");
            }
            do {
                putstr(cvt_token(token, NULL));
            } while (!((token=lex())==SPACE||token==EOL));
            break;
        case IF_EXIST:
            while ((token=lex())==SPACE) ;
            indent();
            if (not) {
                putstr("if (! ");
            } else {
                putstr("if (");
            }
            ckeol(token);
            /* get file or directory name */
            strcpy(strbuf, "");
            do {
                strcat(strbuf, cvt_token(token, NULL));
            } while (!((token=lex())==SPACE||token==EOL));
            sp = strstr(strbuf, "/nul");
            if (sp && sp==strbuf+strlen(strbuf)-4) { /* directory */
                putstr("-d \"");
                *sp = '\0';
            } else {       /* file */
                putstr("-f \"");
            }
            /* print file or directory name */
            putstr(strbuf);
            putstr("\"");
            break;
        default:    /* must be string comparison */
            indent();
            putstr("if (");
            do {
                putstr(cvt_token(token, NULL));
            } while (!((token=lex())==SPACE||token==EOL));
            if (not) {
                putstr(" != ");
            } else {
                putstr(" == ");
            }
            ckeol(token);
            while ((token=lex())==SPACE) ;
            ckeol(token);
            do {
                putstr(cvt_token(token, NULL));
            } while (!((token=lex())==SPACE||token==EOL));
            break;
        }
    break;
    }
    putstr(")");
    ckeol(token);
    puts(" then");

    /* process command */
    indentlevel++;
    if (dispatch()==EOF) terminate();
    indentlevel--;

    /* end if */
    indent();
    puts("endif");
}

void kw_label(void)
{
    strcpy(textbuf, yytext+1);
    strcat(textbuf, ":");
    puts(strlwr(textbuf));
    eattokens();
}

void kw_ln(void)
{
    putln();
}

void kw_path(void)
{
    int token;

    BEGIN(TEXT);
    while ((token=lex())==SPACE) ;
    indent();
    if (token==EOL) {
        putstr("unset path");
        putln();
    } else {
        putstr("set path=(");
        puttokln(token, yytext, ")");
    }
    indent();
    puts("rehash");
}

void kw_pause(void)
{
    indent();
    puts("echo -n 'Press the Enter key to continue...'");
    indent();
    puts("echo -n $?");
    eattokens();
}

void kw_remark(void)
{
    puttokln(INIT_REM, "#", NULL);
}

void kw_set(void)
{
    int token;

    BEGIN(TEXT);
    while ((token=lex())==SPACE) ;
    if (token==EOL) { 
       indent();
       puts("set"); 
       return;
    }
    cvt_token(token, NULL);
    cvt_set_variable(token);
    if (!stricmp(textbuf, "path")) {
        kw_path();
        return;
    }

    /* variable name in textbuf, variable contents in yytext */
    while ((token=lex())==SPACE) ;
    indent();
    if (token==EOL) {
        putstr("unset ");
        putstr(textbuf);
        putln();
    } else {
        putstr("set ");
        putstr(textbuf);
        putstr("=\"");
        puttokln(token, yytext, "\"");
    }
}

void kw_shift(void)
{
    indent();
    puttokln(INIT_SHIFT, "shift ", NULL);
}

/**************************************************************************/
/* keyword function table                                                 */
/**************************************************************************/
FNTBL fntbl[] =
{
        {token(INIT_CALL),	kw_call},
        {token(INIT_COMMAND),	kw_command},
        {token(INIT_ECHO),	kw_echo},
        {token(INIT_FOR),	kw_for},
        {token(INIT_GOTO),	kw_goto},
        {token(INIT_IF),	kw_if},
        {token(INIT_LABEL),	kw_label},
        {token(EOL),		kw_ln},
        {token(INIT_PATH),	kw_path},
        {token(INIT_PAUSE),	kw_pause},
        {token(INIT_REM),	kw_remark},
        {token(INIT_SET),	kw_set},
        {token(INIT_SHIFT),	kw_shift}
};

#define N_FNTBL sizeof(fntbl)/sizeof(fntbl[0])

/**************************************************************************/
/* function dispatcher                                                    */
/**************************************************************************/
int dispatch(void) /* returns 0=success; EOF=end of file */
{
    int i, token;

    BEGIN(INITIAL);
    token = yylex();
    if (token) {
        for (i = 0; i < N_FNTBL; i++) {
            if (token == fntbl[i].token) {
                cmdtoken = token;
                fntbl[i].fn();
                return 0;
            }
        }

        /* no match, call kw_command() */
        cmdtoken = INIT_COMMAND;
        kw_command();
        return 0;
    }
    return EOF;
}

/**************************************************************************/
/* main function                                                          */
/**************************************************************************/
int main()
{
    puts("#! /bin/csh");
    while (dispatch()!=EOF) ;
    return reporterrors();
}
