{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/10/07.  First public release.  DDA
v1.01  : 1993/10/22.  Fix: wasn't deleting a temporary file.  DDA
                      Changed RDUPSORT.BAT to comply with RPSORT, which is
                        an excellent and fast freeware sorter.  DDA
                        RPSRT102 is on Channel 1, the FHOF BBS, and elsewhere.
v1.02  : 1993/10/26.  All dups placed in a report file, "rdup_del.dat".  DDA
v1.03  : 1993/12/20.  Now checks original directory for RDUPSORT.BAT, and
                      runs that copy it if it exists.  DDA
v1.04  : 1994/06/14.  Now should be able to handle over 2 million lines. DDA

------------------------------------------------------------------------------}

{$M 4096, 0, 0}
uses dos,crt;
const
  temp_file= 'rwgibber';
  file_header = '![... The following is a new filename:';
  num_length = 7;

procedure showhelp (errornum : byte);
const
  progdata = 'RDUP- Free DOS utility: delete duplicate lines across multiple files.';
  progdat2 = 'v1.04: June 14, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
   usage   = 'Usage:  RDUP file_spec [/i (=case Insensitive)]';
var
  message : string [60];
begin
  writeln (progdata);
  writeln (progdat2);
  writeln;
  writeln (usage);
  writeln;

  case errornum of
    1 : message := 'invalid number of command line parameters.';
    2 : message := 'unable to create or use storage directory.';
    3 : message := 'no files found to process.';
    4 : message := 'sorting/ numbering problem.  Too many lines?';
  end;
  writeln ('ERROR: (#',errornum,') - ', message);
  halt (errornum);
end;

function converttoupper(w : string) : string;
var
  cp  : integer;        {the position of the character to change.}
begin
  for cp := 1 to length(w) do
    w[cp] := upcase(w[cp]);
  converttoupper := w;
end;

function normalizecase (s : string) : string;
var
  strpos : integer;
begin
  for strpos := 1 to length(s) do
    s[strpos] := upcase(s[strpos]);
  normalizecase := s;
end;

function leadingzero (w : word) : string;
var
  s : string;
begin
  str (w:0,s);
  while (length (s) < num_length) do
    s := '0' + s;
  leadingzero := s;
end;

procedure makedir (tdir : string);
var
  resp : char;
begin
  {$I-}
  mkdir (tdir);
  if (IOResult <> 0) then begin
     writeln ('Storage directory ',tdir,' already exists!');
     write ('Press "y" to use, any other key to abort: ');
     resp := readkey;
     writeln (resp);
     if (upcase (resp) <> 'Y') then showhelp (2);
  end;
  {$I+}
end;

procedure combine (opath, tagfiles, mfile : string);
var
  dirinfo : searchrec;
  tagline : string;
  alltg,
  tagfile : text;
begin
  findfirst ((opath+tagfiles), archive, dirinfo);
  if (doserror = 0) then begin
     assign (alltg, mfile);
     rewrite (alltg);
     repeat
       assign (tagfile,opath+dirinfo.name);
       reset  (tagfile);
       writeln (alltg,file_header+' ][ '+dirinfo.name);
       writeln ('Assimilating: ',opath+dirinfo.name);
       while   (not (eof (tagfile))) do begin
         readln (tagfile, tagline);
         writeln (alltg, tagline);
       end;
       close  (tagfile);
       findnext (dirinfo);
     until (doserror <> 0);
     close (alltg);
  end
  else
    showhelp (3);
end;

procedure separate (fname: string);
var
  tagfiles, tagline : string;
  alltg,
  tagfile           : text;
begin
  assign (alltg, fname);
  reset (alltg);
  readln (alltg, tagline);
  if ((copy (tagline,1,length(file_header))) <> file_header) then
    showhelp (4)
  else begin
    tagline := (copy
               (tagline,length(file_header)+5,
               (length (tagline)-(length(file_header)+4))));
    assign (tagfile, tagline);
    rewrite (tagfile);
    writeln ('De-Assimilating: ',tagline);
  end;
  while (not (eof (alltg))) do begin
    readln (alltg, tagline);
    if ((copy (tagline,1,length(file_header))) = file_header) then begin
      close  (tagfile);
      tagline := (copy
                 (tagline,length(file_header)+5,
                 (length (tagline)-(length(file_header)+4))));
      assign (tagfile,tagline);
      rewrite (tagfile);
      writeln ('De-Assimilating: ',tagline);
    end
    else
      writeln (tagfile, tagline);
  end;
  close (tagfile);
  close (alltg);
end;

procedure putnumb (fname : string);
var
  numb  : longint;
  source,
  dest  : text;
  linec : string;
begin
  assign (source, fname);
  reset  (source);
  assign (dest, temp_file);
  rewrite (dest);
  numb := 0;
  repeat
    readln (source,linec);
    inc (numb);
    writeln (dest, leadingzero(numb)+' ', linec);
  until eof (source);
  close (source);
  close (dest);
  erase (source);
  rename (dest, fname);
end;

procedure rmvnumb (fname : string);
var
  source,
  dest  : text;
  linec : string;
begin
  assign (source, fname);
  reset  (source);
  assign (dest, temp_file);
  rewrite (dest);
  repeat
    readln (source, linec);
    delete (linec,1,(num_length+1));
    writeln (dest,linec);
  until eof (source);
  close (source);
  close (dest);
  erase (source);
  rename (dest, fname);
end;

procedure dduplins (fname : string);
const
  deleted_tags= 'rdup_del.dat';
var
  source_file,
  stat_file,
  dest_file  : text;
  line_current, line_current_temp,
  line_next, line_next_temp : string;
  ignore_case : boolean;
  ic : string [4];

begin
  if (paramcount = 2) then
     ignore_case := ((converttoupper (paramstr (2))) = '/I')
  else ignore_case := false;
  if ignore_case
     then ic := ''
     else ic := 'not ';

  writeln ('Deleting duplicates now, and ',ic,'ignoring case.');

  assign (stat_file, deleted_tags); rewrite (stat_file);
  assign (source_file, fname);      reset   (source_file);
  assign (dest_file, temp_file);    rewrite (dest_file);

  readln  (source_file,line_next);
  line_next_temp := line_next;
  delete (line_next_temp,1,num_length+1);
  if ignore_case then begin
     line_next_temp := normalizecase (line_next_temp)
  end;

  while not eof (source_file) do
  begin
    line_current := line_next;
    line_current_temp := line_next_temp;

    readln  (source_file,line_next);
    line_next_temp := line_next;

    delete  (line_next_temp,1,num_length+1);
    if ignore_case then begin
       line_next_temp := normalizecase (line_next_temp)
    end;

    if (line_next_temp <> line_current_temp) then
       writeln (dest_file,line_current)
    else
       writeln (stat_file, copy (line_current, (num_length+2),
                         length (line_current)-(num_length+1)));
  end;
  writeln (dest_file,line_next);

  close (source_file);
  close (dest_file);
  close (stat_file);
  erase (source_file);
  rename (dest_file, fname);
end;

procedure getpath (var org_path, inf : string);
var
  rdir    : dirstr;
  rname   : namestr;
  rext    : extstr;
begin
  fsplit ((fexpand (inf)),rdir,rname,rext);
  org_path := rdir;
  inf := rname+rext;
end;

const
  temp_dir = 'rdup#dir';
  master_file = 'rdup#fil';
var
  tags,
  org_path : string;
  opath   : string[3];
  alltags : text;
  dirinfo : searchrec;

begin
  findfirst ('RDUPSORT.B*', archive, dirinfo);
  if (doserror = 0) then opath:='..\' else opath:='';
  checkbreak := false;
  if (paramcount < 1)
  or (paramcount > 2)
     then showhelp (1);
  makedir (temp_dir);
  tags := paramstr (1);
  getpath (org_path, tags);

  clrscr;
  writeln ('Start!');
  writeln ('Constructing master file.');
  combine (org_path, tags, temp_dir+'\'+master_file);
  chdir (temp_dir);
  writeln ('Adding line numbers.');
  putnumb (master_file);

  writeln ('Shelling out to sort.');
   swapvectors;
     exec (getenv ('COMSPEC'),' /c '+opath+'rdupsort '+master_file+' >nul');
   swapvectors;

  dduplins (master_file);

  writeln ('Shelling out to sort.');
   swapvectors;
     exec (getenv ('COMSPEC'),' /c '+opath+'rdupsort '+master_file+' /u >nul');
   swapvectors;

  writeln ('Removing line numbers.');
  rmvnumb (master_file);
  writeln ('Destroying master file.');
  separate (master_file);
  assign (alltags,master_file);
  erase (alltags);
  writeln ('Finish!');
end.
