function [y] = invhilb(n) 
%invhilb create Inverse Hilbert matrix (a badly conditioned matrix)

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

% set up factors
mv_p  = zeros(1,n);
mv_p(1) = n;
for ix=2:n
  mv_p(ix)=((n-ix+1)*mv_p(ix-1)*(n+ix-1))/(ix-1)^2;
end

% initialize matrix
nv = 1:n;
y = diag( (mv_p.^2) ./ (2*nv-1) );

% do it
for ix = 1:n-1               % for all rows
  mv_r=mv_p(ix)^2;
  for jx=ix+1:n           % for elements above the diagonal
    mv_r *= -((n-jx+1)*(n+jx-1))/(jx-1)^2;
    y(ix,jx) = mv_r/(ix+jx-1);
    y(jx,ix) = y(ix,jx);
  end
end
