/*
	Scan the netmail directory for messages adressed to one of the users
	at one of your AKA's. If they are not in transit and they appear to
	be encrypted, attempt to decrypt	them with PGP.

	Scan the netmail directory for messages from one of your users at one
	of your AKA's that are not send. If they have one of the magic phrases
	on the beginning of the message, encrypt them.

	Tuned for optimal performance with InterMail 2.25 or higher.

	(c) 1993-1994, Michiel van der Vlist, PA0MMV */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <alloc.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <time.h>
#include <values.h>
#include <fcntl.h>
#include <process.h>
#include <share.h>
#include <sys\stat.h>

#define MYNAMEANDNUMBER "(c) 1994, Michiel van der Vlist, PA0MMV (2:500/9.5)"
#define TRUE 1
#define FALSE 0
#define CR 0x0D
#define LF 0x0A
#define ESC 0x1B
#define SR 0x8D
#define NAMELENG 36
#define VERSION "1.02"

#define LOGFILE "IMCRYPT.LOG"
#define CONFIGFILE "IMCRYPT.CFG"
#define IMSYSFILE "FD.SYS"
#define FDSYSFILE "SETUP.FD"
#define SERVERNAME "PGPSERVER"

#define UNDEFINED 0
#define INTERMAIL 1
#define FRONTDOOR 2

#define PRIVATE 0x0001
#define RECEIVED 0x0004
#define SEND 0x0008
#define INTRANSIT 0x0020
#define KILLSEND 0x0080
#define LOCAL 0x0100

#define KEYNOTFOUND 21


typedef unsigned char boolean;
typedef unsigned char byte;
typedef char string[NAMELENG];
typedef char longstring[80];
typedef char verylongstring[256];

typedef struct { unsigned int zone,net,node,point; } fido_address;

fido_address aka[21];
string users[10], version, forcedtoname;
int firstfreeaka=0, firstfreeuser=0, errornumber=0;
unsigned int lastread[10];
long nextmes=-1;
int mailertype=UNDEFINED, verbose=0;
boolean killflag=TRUE, errabort=FALSE, zeroflag=FALSE;
boolean holdflag=FALSE, downflag=FALSE, logflag=FALSE;
boolean plus,minus,encryptflag=TRUE,decryptflag=TRUE;
boolean keepflag=FALSE, batchmode=TRUE, serverflag=TRUE;
boolean askedpass=FALSE, querypassfrase=FALSE;
int shareflag=0;
FILE *infile,*outfile,*message,*log,*mbody,*mbody1;
longstring tempdir,maildir,sysdir,semadir,pgppath,logfile,pstr;
char confignr=0;
verylongstring pgppass;
struct date datum;
struct time timep;
const char *monthn[]={"***","Jan","Feb","Mar","Apr","May","Jun",
									"Jul","Aug","Sep","Oct","Nov","Dec"};
const char *dow[] = {   "Sun","Mon","Tue","Wed","Thu","Fri","Sat"};

char getcommands(int argc, char *argv[]);
char scanoption(char *s);
char readconfig(char *imcpath, char cnr);
void timestamp(FILE *f,int s);
char *Fgets(char *s,int n, FILE *fp);
void Error(int er, char *s);
void help(void);
void pstring(char *st,int n);
void reportmes(long i, char *from, fido_address *fromnr, char *to,
											 fido_address *tonr, int crf, int flags);
void show_path(void);
void querypass(void);
int getchbeep(int maxtime, boolean no_echo);
long findfirstfreemessage(void);
long findfirstmessage(struct ffblk *infoblk);
long findnextmessage(struct ffblk *infoblk);
void findfdsys(char *path);
void getshareinfo(void);
int lockbase(void);
void unlockbase(int fhandle);
boolean isaka(fido_address *nr);
int isuser(string nam);
long int scanmes(FILE *p,string toname,string fromname,fido_address *nr
					,fido_address *tonr,int *cf,unsigned int *flags, boolean *empty);
int Fscans(FILE *fp,char *s, int len);
char *getname(char *dest, char *src, int attrib, int max_len);
void request_imrescan(void);
void request_ierescan(void);
int de_crypt(FILE *fp,long int pos, long *curm, int cf, long mesnr);
int en_crypt(FILE *fp,long int pos,long curm,char *fromname,char *toname,int cf,boolean *dflag);
int sendkey(FILE *fp,long curm,char *fromname,char *toname,fido_address *fromnr,fido_address *tonr);
unsigned int matchzone(unsigned int net,unsigned int node,unsigned int point);

/************************** Main ********************/

int main(int argc, char *argv[])
{
	int i,nrcrypts=0,nrdecrypts=0,keyssend=0,resultcode,lockhandle;
	long curmes;
	char c, *p, *impath, number[10];
	longstring message;
	boolean empty,delmes,delflag;
	string toname, fromname;
	unsigned int flags;
	long int cpos;
	fido_address nr, tonr;
	int cryptflag;
	struct ffblk infoblk;
	struct tm *local;
	time_t l;

	strcpy(version,VERSION);
	printf("\nImCrypt %s, Netmail PGP handler and key server.\n",version);
	printf(MYNAMEANDNUMBER);
	printf("\nNoncommercial use for FidoNet (tm) and other FTN networks allowed.\n");

	for (i=0;i<(sizeof(users)/sizeof(users[0]));i++) users[i][0]=0;
	for (i=0;i<(sizeof(aka)/sizeof(fido_address));i++)
	{
		aka[i].zone=aka[i].net=aka[i].node=aka[i].point=0;
	}

	if (argc==2 && (argv[1][0]=='?' || toupper(argv[1][0])=='H'))
	{
		help();
		exit(0);
	}
	if (argc>=2)
	{
		for(i=1;i<argc;i++) if (isdigit(argv[i][0])) confignr=argv[i][0];
	}

	maildir[0]=0; pgppath[0]=0;

	impath=getenv("IM");			           		/* try to find a path to */
	if (impath!=NULL)                         /* FD.SYS via the environment */
	{
		mailertype=INTERMAIL;
	}
	else
	{
		impath=getenv("FD");
		if (impath!=NULL) mailertype=FRONTDOOR;
	}
	if (impath!=NULL) findfdsys(impath);      /* and try to read FD.SYS */
	else
	{
		mailertype=UNDEFINED;
	}
	for (i=0;i<sizeof(aka)/sizeof(fido_address);i++) { if (aka[i].zone) firstfreeaka++; }
	for (i=0;i<sizeof(users)/sizeof(users[0]);i++) { if (users[i][0]!=0) firstfreeuser++; }

	if ((c=readconfig(argv[0],confignr))!=0)
	{
		printf("\Error reading config file, unknown option '%c'",c);
		exit(23);
	}

	if (argc>1)
	{
		if ((c=getcommands(argc, argv))!=0)
		{
			printf("\nUnknown option '%c'",c);
			exit(20);
		}
	}
	if (logflag)
	{
		if (logflag==2) log=fopen(logfile,"wt"); else log=fopen(logfile,"at");
		if (log==NULL) Error(4,logfile);
		else
		{
			time(&l);
			local = localtime(&l);
			fprintf(log,"\n----------  %s %02d %s %d, ImCrypt v %s\n",
			dow[local->tm_wday], local->tm_mday, monthn[local->tm_mon + 1],
												(local->tm_year+1900)%100, version);
		}
	}
	if (firstfreeaka==0) Error(11,NULL);
	if (firstfreeuser==0) Error(12,NULL);
	if (maildir[0]==0) Error(19,NULL);

	/* The stategie for locating PGP.EXE is as follows:
		First check if a path is specified with the 'p' option. If so
		take this path, add a backslash if there isn't one and than
		add "PGP.EXE" to obtain the full path and file name.

		Otherwise check the DOS path. If PGP.EXE is found, take it from
		there. If not, assume PGP.EXE is in the path specified in the
		"PGPPATH" environment variable. If this environment variable is
		not defined, assume PGP.EXE is in the current directory, whatever
		that may be. */

	if (pgppath[0]==0)                          /* PGP path not specified ? */
	{
		p=searchpath("PGP.EXE");                 /* PGP in DOS path ? */
		if (p!=NULL) strcpy(pgppath,p);
		else
		{
			p=getenv("PGPPATH");							/* environment defined ? */
			if (p!=NULL)
			{
				strcpy(pgppath,p);
				if (pgppath[strlen(pgppath)-1]!='\\') strcat(pgppath,"\\");
				strcat(pgppath,"PGP.EXE");
			}
			else strcpy(pgppath,"PGP.EXE");
		}
	}
	else
	{
		if (pgppath[strlen(pgppath)-1]!='\\') strcat(pgppath,"\\");
		strcat(pgppath,"PGP.EXE");
	}

	p=getenv("TMP");
	if (p==NULL && tempdir[0]==0) strcpy(tempdir,semadir);
	else
	{
		if (tempdir[0]==0) strcpy(tempdir,p);
		if (tempdir[strlen(tempdir)-1] !='\\') strcat(tempdir,"\\");
	}
	getshareinfo();		/* try to establish if renum semaphore shareble */

	if (verbose>=1) show_path();		/* some debug */
	curmes=nextmes=findfirstfreemessage();

	if (verbose>=1)
	{
		sprintf(pstr,"highest message %ld\n",nextmes-1);
		pstring(pstr,3);
	}

	/* ok, here goes, scan the netmail directory for unread messages */
	/* see if they need and can be (de)crypted */

	if ((l=findfirstmessage(&infoblk))>0)
	{
		lockhandle=lockbase();
		do
		{
			delflag=delmes=FALSE;
			sprintf(number,"%ld",l);
			strcpy(message,maildir);
			strcat(message,number);
			strcat(message,".MSG");
			infile=fopen(message,"r+b");
			if (infile==NULL) { Error(3,message); continue; }
			cpos=scanmes(infile,toname,fromname,&nr,&tonr,&cryptflag,&flags,&empty);

			if (verbose>=2) reportmes(l,fromname,&nr,toname,&tonr,cryptflag,flags);
			if (encryptflag && cryptflag>0 && !(flags&(SEND|INTRANSIT)) &&
														 isaka(&nr) && isuser(fromname)>=0)
			{
				if (verbose<2) reportmes(l,fromname,&nr,toname,&tonr,cryptflag,flags);
				resultcode=en_crypt(infile,cpos,curmes,fromname,toname,cryptflag,&delflag);
				if (resultcode==0) nrcrypts++;
				curmes++;
			}
			if (decryptflag && cryptflag<0 && !(flags & (SEND|INTRANSIT)) &&
														 isaka(&tonr) && isuser(toname)>=0)
			{
				if (verbose<2) reportmes(l,fromname,&nr,toname,&tonr,cryptflag,flags);
				resultcode=de_crypt(infile,cpos,&curmes,cryptflag,l);
				if (resultcode==0) nrdecrypts++;
			}
			if ((stricmp(toname,SERVERNAME)==0 || stricmp(toname,"IMCRYPT")==0)
				 && serverflag && !(flags & (RECEIVED|INTRANSIT)) && isaka(&tonr))
			{
				if (verbose<2) reportmes(l,fromname,&nr,toname,&tonr,cryptflag,flags);
				resultcode=sendkey(infile,curmes,users[0],fromname,&tonr,&nr);
				if (resultcode==0) { keyssend++; delmes=TRUE; }
				curmes++;
			}
			fclose(infile);
			if ((delmes && !keepflag && empty) || (resultcode==0 && delflag))
			{
				remove(message);
				strcat(message, " removed.\n");
				pstring(message,0);
			}
		}	while ((l=findnextmessage(&infoblk))>0);

		unlockbase(lockhandle);
		if (nrcrypts>0 || nrdecrypts>0) {request_imrescan(); request_ierescan();}
	}
	else
	{
		sprintf(pstr,"Netmail directory is empty.\n");
		pstring(pstr,0);
		errornumber=0;
	}

	/********************   All done, clean up and exit  **************/

	sprintf(pstr,"%d messages decrypted, %d messages encrypted, %d keys served.\n",nrdecrypts,nrcrypts,keyssend);
	pstring(pstr,0);

	printf("Ready...\n\n");
	if (logflag)
	{
		timestamp(log,0);
		fprintf(log,"ImCrypt completed.\n");
		fclose(log);
	}
	return(errornumber);
}

/* if the environment variable for the pass phrase is not set and
	the query flag is set or we are in batchmode, ask for the pass
	phrase, if that has not been done already */

void querypass(void)
{
	int i;
	char c;

	if ((batchmode || querypassfrase) && !askedpass && (getenv("PGPPASS")==NULL))
	{
		printf("I may need your pass phrase now.\n");
		printf("Enter PGP pass phrase: ");
		i=0;
		while ((c=getchbeep(600,TRUE))!='\r' && i<sizeof(pstr)-2)
		{
			if (c==0) { Error(1,NULL); return; }
			if (c=='\b' && i>0) i--; else pstr[i++]=c;
		}
		pstr[i]=0;
		printf("\n");
		strcpy(pgppass,"PGPPASS=");
		strcat(pgppass,pstr);
		putenv(pgppass);						/* tnx B.V. ;-) */
		askedpass=TRUE;
	}
}

/* report some things about the message being handled */

void reportmes(long i, char *from, fido_address *fromnr, char *to,
												 fido_address *tonr, int crf, int flags)
{
	char nr1[10],nr2[10],nr3[10],nr4[10],*s;
	char ss[4][4]={"   ","<*<",">*>","-!-"};

	if (fromnr->zone==0) nr1[0]=0; else sprintf(nr1,"%u:",fromnr->zone);
	if (fromnr->point==0) nr2[0]=0; else sprintf(nr2,".%u",fromnr->point);
	if (tonr->zone==0) nr3[0]=0; else sprintf(nr3,"%u:",tonr->zone);
	if (tonr->point==0) nr4[0]=0; else sprintf(nr4,".%u",tonr->point);
	s=ss[0];
	if (crf!=0)
	{
		s=ss[3];
		if (!(flags & (SEND|INTRANSIT)))
		{
			if (crf>0) s=ss[1];
			if (crf<0) s=ss[2];
		}
	}
	sprintf(pstr,"Msg %ld from %s (%s%u/%u%s)\n",i,from,nr1,fromnr->net,fromnr->node,nr2);
	pstring(pstr,0);
	sprintf(pstr,"%s      to %s (%s%u/%u%s)\n",s,to,nr3,tonr->net,tonr->node,nr4);
	pstring(pstr,0);
}

/* show some path info for debug purposes */

void show_path(void)
{
	char *s;
	int i;

	sprintf(pstr,"Mailertype: ");
	switch(mailertype)
	{
		case UNDEFINED	:	strcat(pstr,"Undefined"); break;
		case INTERMAIL	:	strcat(pstr,"InterMail"); break;
		case FRONTDOOR	:	strcat(pstr,"FrontDoor"); break;
	}
	strcat(pstr,"\n");
	pstring(pstr,3);
	sprintf(pstr,"Netmail   : %s\n",maildir);
	pstring(pstr,3);
	sprintf(pstr,"Semaphore : %s\n",semadir);
	pstring(pstr,3);
	sprintf(pstr,"TMP files : %s\n",tempdir);
	pstring(pstr,3);
	sprintf(pstr,"PGP.EXE   : %s\n",pgppath);
	pstring(pstr,3);
	s=getenv("PGPPATH");
	if (s!=NULL)
	{
		sprintf(pstr,"PGP Keys  : %s\n",s);
		pstring(pstr,3);
	}
	s=getenv("PGPPASS");
	if (s!=NULL)
	{
		sprintf(pstr,"Pass phrase: Ja dat zou je wel willen:-))\n");
		pstring(pstr,3);
	}
	i=0;
	while (aka[i].zone!=0 && i<=sizeof(aka)/sizeof(fido_address))
	{
		sprintf(pstr,"AKA %2d :  %u:%u/%u.%u\n",i,aka[i].zone,aka[i].net,aka[i].node,aka[i].point);
		pstring(pstr,3);
		i++;
	}
	i=0;
	while (users[i][0]!=0 && i<sizeof(users)/sizeof(users[0]))
	{
		sprintf(pstr,"User %d : %s\n",i,users[i]);
		pstring(pstr,3);
		i++;
	}
}

/* prompt for a key with a bit of noise */

int getchbeep(int maxtime, boolean no_echo)
{

	time_t secsnow, secs, secs1;

	secs=secs1=time(&secsnow)-7;
	while (!kbhit())
	{
		time(&secsnow);
		if ((secsnow-secs1)>maxtime) return(0);
		if (secsnow-secs>15)
		{
			sound(600);
			delay(300);
			if (kbhit()) break;
			sound(800);
			delay(300);
			if (kbhit()) break;
			sound(1000);
			delay(300);
			nosound();
			secs=secsnow;
		}
	}
	nosound();
	if (no_echo) return(getch()); else return(getche());
}

/* same as fgets except that it advances pointer to EOL
	after coping as many chars as possible  */

char *Fgets(char *s,int n, FILE *fp)
{
	char cc;
	int ii,jj=0;

	for (ii=0;ii<n-1;ii++)
	{
		cc=fgetc(fp);
		if (cc=='\r') continue;
		if (cc=='\n' || cc==EOF) break;
		s[jj++]=cc;
	}
	s[jj]=0;
	while (cc!='\n' && cc!=EOF) cc=fgetc(fp);
	if (cc==EOF) return(NULL); else return(s);
}

/* Extract a well formed name from a source to destination */

char *getname(char *dest, char *src, int attrib, int max_len)
{
#define ON_PREV_FIELD 1    /* start of source is on a previous field */
#define ALLOW_PAREN 2      /* allow source encapsulated in parenthesis */
#define NO_ENCAP 4         /* do not ecapsulate dest in double quotes */

	int i=0,j=0;

	if (!(attrib & NO_ENCAP)) dest[j++]='\"';		/* starting qoutes */

	if (attrib & ON_PREV_FIELD) while (!isspace(src[i]) && src[i]) i++;
	while (isspace(src[i])) i++;		/* position on field of interest */

	switch(src[i])
	{
		case '\"':	i++;
						while (src[i]!='\"' && src[i])	/* copy until qoute */
						{
							dest[j++]=src[i++];
							if (j>=max_len) break;
						}
						break;
		case '('	:	if (attrib & ALLOW_PAREN)
						{
							i++;
							while (src[i]!=')' && src[i])	/* copy until closing p.*/
							{
								dest[j++]=src[i++] ;
								if (j>=max_len) break;
							}
							break;
						} 	/* if no parenthesis allowed drop through to default */
		default	:  while isgraph(src[i])		/* copy until whitespace */
						{
							if (src[i]=='_') dest[j]=' ';	else dest[j]=src[i];
							i++; j++;
							if (j>=max_len) break;
						}
						break;
	}
	if (!(attrib & NO_ENCAP)) dest[j++]='\"'; /* terminating qoutes */
	dest[j]=0;       									/* terminate dest */
	if (strcmp(dest,"\"\"")==0) dest[0]=0;		/* zero empty name */
	return(dest);
}

/* read the ImCrypt config file if present */
/* first try the current dir, then the dir where ImCrypt is located */

char readconfig(char *imcpath, char cnr)
{
	FILE *f;
	longstring s,d;
	char e[15];
	char c;

	strcpy(e,CONFIGFILE);
	if (cnr) e[strlen(e)-1]=cnr;	/* patch number of cfg if appilicable */
	strcpy(d,e);
	if ((f=fopen(d,"rt"))==NULL)	/* if no config in current dir */
	{
		fnsplit(imcpath,d,s,NULL,NULL);	/* get drive and path for ImCrypt */
		strcat(d,s);
		strcat(d,e);
		if ((f=fopen(d,"rt"))==NULL) return(0);/* if no config in ImCrypt dir */
	}
	printf("\nReading %s\n",d);
	while (Fgets(s,sizeof(s)-1,f)!=NULL)
	{
		if ((c=scanoption(s))!=0) { fclose(f); return(c); }
	}
	fclose(f);
	return(0);
}

/* scan the command line for options and filenames */

char getcommands(int argc, char *argv[])
{
	int i;
	char c;

	for (i=1;i<argc;i++)
	{
		if ((c=scanoption(argv[i]))!=0) return(c);
	}
	return(0);
}

char scanoption(char *s)
{
	int i,j;
	char c,d,r=0;

	plus=minus=FALSE; j=0;
	if (s[0]==';' || s[0]=='\r' || s[0]=='\n') return(0);

	while ((c=toupper(s[j++]))!=0)
	{
		if (c=='/') continue;
		if (c=='-') { minus=TRUE; continue; }
		if (c=='+') { plus=TRUE; continue; }
		d=toupper(s[j]);
		if (d=='=' || d==':') d=toupper(s[++j]);
		switch (c)
		{
			case	'0':	case '1': case '2': case '3': case '4':
			case	'5':	case '6': case '7': case '8': case '9':
							break;
			case	'A':	if (firstfreeaka<21)
							{
								if	(sscanf(&s[j],"%u:%u/%u.%u",&aka[firstfreeaka].zone,
											&aka[firstfreeaka].net,&aka[firstfreeaka].node,
											&aka[firstfreeaka].point) ==4)
								{
									firstfreeaka++;
								}
								else
								{
									if	(sscanf(&s[j],"%u:%u/%u",&aka[firstfreeaka].zone,
										&aka[firstfreeaka].net,&aka[firstfreeaka].node) ==3)
									{
										firstfreeaka++;
									}
									else Error(13,NULL);
								}
							}
							break;
			case	'B':	batchmode=!minus; break;
			case	'D':	decryptflag=!minus; break;
			case	'E':	encryptflag=!minus; break;
			case	'K':	keepflag=!minus; break;
			case	'L':  if (minus) logflag=2; else logflag=TRUE;
							if (d=='*') break;
							if (d) strcpy(logfile,&s[j]);
							else strcpy(logfile,LOGFILE);
							break;
			case	'M':	if (d)
							{
								strcpy(maildir,&s[j]);
								if (maildir[strlen(maildir)-1]!='\\')
																		strcat (maildir,"\\");
							}
							break;
			case	'P':	if (d) strcpy(pgppath,&s[j]); break;
			case	'Q':	querypassfrase=!minus; break;
			case	'S':	if (minus) shareflag=-1;
							if (plus) shareflag=1; break;
			case	'T':	if (d) strcpy(tempdir,&s[j]); break;
			case	'U':  if (minus)
							{
								for (i=0;i<10;i++) users[i][0]=0;
								firstfreeuser=0;
							}
							if (d && firstfreeuser<10)
							{
								getname(users[firstfreeuser],&s[j],NO_ENCAP,sizeof(string)-1);
								firstfreeuser++;
							}
							break;
			case	'V':	if (d) sscanf(&s[j],"%d",&verbose);
							else verbose=1;
							break;
			case	'X':	serverflag=!minus; break;
			case	'Z':	if (d)
							{
								getname(pstr,&s[j],NO_ENCAP,sizeof(pstr)-1);
							}
							else pstr[0]=0;
							strcpy(pgppass,"PGPPASS=");
							strcat(pgppass,pstr);
							putenv(pgppass);
							break;
			default	:	r=c; break;
		}
		break;
	}
	return(r);
}

/* timestamp to log file */

void timestamp(FILE *f, int s)
{
	const char ind[]={'#','!','?','$','*',':','+','-','%','~','='};
	time_t l;
	struct tm *loc;

	time(&l);
	loc=localtime(&l);
	fprintf(f,"%c %2d:%02d:%02d  ",ind[s],loc->tm_hour,loc->tm_min,loc->tm_sec);
}

/* Error handler */

void Error(int er, char *s)
{
	char line[80];

	line[0]=0;

	switch(er)
	{
		case 1	:	strcat(line,"Timeout on query for pass phrase."); break;
		case 2	:	strcat(line,"Can't open LASTREAD."); break;
		case 3	:	strcat(line,"Can not open message: "); break;
		case 4	:	strcat(line,"Error opening logfile.");break;
		case 8	:	strcat(line,"Error calling PGP. The shell reports error "); break;
		case 9	:	strcat(line,"Encryption failed. PGP reports error "); break;
		case 11  :	strcat(line,"FD.SYS/SETUP.FD not found and no address specified."); break;
		case 12	:	strcat(line,"FD.SYS/SETUP.FD not found and/or no user name specified."); break;
		case 13	:	strcat(line,"Error reading node number provided wit 'A' option.");  break;
		case 14	:	strcat(line,"Failed to open temporary file."); break;
		case 15	:	strcat(line,"Timeout or user break waiting for renumber semaphore to clear."); break;
		case 16	:	strcat(line,"Can't open new message. ");break;
		case 18	:	strcat(line,"FD.SYS not found and F option specified without name."); break;
		case 19	:	strcat(line,"FD.SYS/SETUP.FD not found and no netmail directory specified."); break;
		case 20	:	strcat(line,"Dos reports: "); break;
		case 21	:	strcat(line,"Can not open file: "); break;
		case 22	:	strcat(line,"PGP exits with errorlevel "); break;
		case 98  :  strcat(line,"User abort or timeout."); break;
		case 99	:	strcat(line,"Not enough memory."); break;
		default	:	;
	}
	if (s!=NULL) strcat(line,s);
	strcat(line,"\n");
	pstring(line,2);
	if (er>=10)
	{
		sprintf(pstr,"ImCrypt aborted.\n"); pstring(pstr,2);
		if (logflag) fclose(log);
		exit(er);
	}
}

/* string output to screen and to log */

void pstring(char *st,int n)
{
	printf("%s",st);
	if (logflag)
	{
		if (n>=0) timestamp(log,n);
		fprintf(log,"%s",st);
	}
}

/* print short helptext */

void help(void)
{
	printf("\n\n");
	printf("IMCRYPT [0-9] [a=aka] [-b] [-d] [-e] [k] [[-]l[=logfile] [m=mailpath] [p=pgppath]\n");
	printf("        [q] [[+|-]s] [t=tempdir] [[-]u=username] [v[=1|2]] [-x] [z=passphrase]\n\n");
	printf("  0-9 change the name of IMCRYPT.CFG to IMCRYPT.CFx.\n");
	printf("  a  specify an extra addres.\n");
	printf(" -b  disable batch mode, PGP is called in interactive mode.\n");
	printf(" -d  suppresses the decryption pass.\n");
	printf(" -e  supresses the encryption pass.\n");
	printf("  k  keep originals of decrypted messages.\n");
	printf("  l  specify logfile. l=* defaults to the main mailer logfile.\n");
	printf("  m  specify the path of the netmail.\n");
	printf("  p  specify path where PGP.EXE is located.\n");
	printf("  q  force querying for pass phrase when not in batchmode.\n");
	printf(" +s  enables IMRENUM.NOW semaphore, overrides autodetect of share status.\n");
	printf(" -s  disables use of IMRENUM.NOW semaphore.\n");
	printf("  t  specify directory for tempfiles. Defaults to semaphore dir.\n");
	printf("  u  specify an extra user name.\n");
	printf(" -u  clear all user names and specify a new user name.\n");
	printf("  v  set verbosity for debug purposes.\n");
	printf(" -x  disable the key server function.\n");
	printf("  z  specify pgp passphrase.\n");
	printf("\n");
}

long findfirstmessage(struct ffblk *infoblk)
{
	char far *dtasave;
	longstring match;
	char namef[MAXFILE];
	long l=0;
	int k;
	boolean nummeric=TRUE;

	strcpy(match,maildir);
	strcat(match,"*.MSG");
	dtasave = getdta();				/* Save het org. disk transfer adres. */
	if (findfirst(match,infoblk,0)==0)
	{
		fnsplit(infoblk->ff_name,NULL,NULL,namef,NULL);
		for (k=0;k<MAXFILE-1;k++)
		{
			if (namef[k]==0) break;
			if (!isdigit(namef[k])) {nummeric=FALSE; break; }
		}
		if (nummeric) sscanf(namef,"%ld",&l);
		else
		{
			while (findnext(infoblk)==0)
			{
				nummeric=TRUE;
				fnsplit(infoblk->ff_name,NULL,NULL,namef,NULL);
				for (k=0;k<MAXFILE-1;k++)
				{
					if (namef[k]==0) break;
					if (!isdigit(namef[k])) {nummeric=FALSE; break; }
				}
				if (nummeric) { sscanf(namef,"%ld",&l); break; }
				else l=0;
			}
		}
	}
	setdta(dtasave);              /* org disk transfer adres herstellen */
	return(l);
}

long findnextmessage(struct ffblk *infoblk)
{
	char far *dtasave;
	char namef[MAXFILE];
	long l=0;
	int k;
	boolean nummeric;

	dtasave = getdta();				/* Save het org. disk transfer adres. */

	while (findnext(infoblk)==0)
	{
		nummeric=TRUE;
		fnsplit(infoblk->ff_name,NULL,NULL,namef,NULL);
		for (k=0;k<MAXFILE-1;k++)
		{
			if (namef[k]==0) break;
			if (!isdigit(namef[k])) {nummeric=FALSE; break; }
		}
		if (nummeric) { sscanf(namef,"%ld",&l); break;}
		else l=0;
	}
	setdta(dtasave);              /* org disk transfer adres herstellen */
	return(l);
}


long findfirstfreemessage(void)
{
	struct ffblk infoblk;
	char far *dtasave;
	longstring match;
	char namef[MAXFILE];
	long i=-1,j=0,ret=0;
	int k;
	boolean nummeric=TRUE;

	strcpy(match,maildir);
	strcat(match,"*.MSG");
	dtasave = getdta();				/* Save het org. disk transfer adres. */
	if (findfirst(match,&infoblk,0)==0)
	{
		fnsplit(infoblk.ff_name,NULL,NULL,namef,NULL);
		for (k=0;k<MAXFILE-1;k++)
		{
			if (namef[k]==0) break;
			if (!isdigit(namef[k])) {nummeric=FALSE; break; }
		}
		if (nummeric) sscanf(namef,"%ld",&i);

		while (findnext(&infoblk)==0)
		{
			nummeric=TRUE;
			fnsplit(infoblk.ff_name,NULL,NULL,namef,NULL);
			for (k=0;k<MAXFILE-1;k++)
			{
				if (namef[k]==0) break;
				if (!isdigit(namef[k])) {nummeric=FALSE; break; }
			}
			if (nummeric) sscanf(namef,"%ld",&j); else j=-1;
			if (j>i) i=j;
		}
		ret=i;
	}
	setdta(dtasave);              /* org disk transfer adres herstellen */
	return(ret+1);
}

/* search for FD.SYS / SETUP.FD in Intermail and Frodo path.
	read sysop name, main AKA and maildir path from it, if found */

void findfdsys(char *path)
{
	longstring fdsys;
	FILE *f;
	int i,j;

	strcpy(fdsys,path);
	if (fdsys[strlen(fdsys)-1]!='\\') strcat(fdsys,"\\");
	switch (mailertype)
	{
		case INTERMAIL :	strcat(fdsys,IMSYSFILE); break;
		case FRONTDOOR :	strcat(fdsys,FDSYSFILE); break;
	}
	f=fopen(fdsys,"rb");
	if (f==NULL) return;

	fseek(f,11,SEEK_SET);				/* postion to logfile name */
	for (i=0;i<sizeof(logfile)-2;i++)
	{
		logfile[i]=fgetc(f);
		if (logfile[i]==0) break;
	}

	fseek(f,0x24BE,SEEK_SET);				/* postion to system dir field */
	for (i=0;i<sizeof(sysdir)-2;i++)
	{
		sysdir[i]=fgetc(f);
		if (sysdir[i]==0) break;
	}
	if (sysdir[strlen(sysdir)-1] !='\\') strcat(sysdir,"\\");

	fseek(f,0x2505,SEEK_SET);				/* postion to maildir field */
	for (i=0;i<sizeof(maildir)-2;i++)
	{
		maildir[i]=fgetc(f);
		if (maildir[i]==0) break;
	}
	if (maildir[strlen(maildir)-1] !='\\') strcat(maildir,"\\");

	if ((j=fseek(f,0x2593,SEEK_SET))==0)
	{													/* position to semaphore dir */
		for (i=0;i<sizeof(semadir)-2;i++)
		{
			semadir[i]=fgetc(f);
			if (semadir[i]==0) break;
		}
	}
	if (j!=0 || semadir[0]==0) strcpy(semadir,sysdir);
	if (semadir[strlen(semadir)-1] !='\\') strcat(semadir,"\\");

	/* N.B. the new 20 aka long list is at 0x3605 */
	/* the old list is at 0x26F8 */

	switch (mailertype)
	{
		case INTERMAIL :	fseek(f,0x3605,SEEK_SET);	/* postion to aka field */
								j=20;								/* 20 aka's for IM */
								break;
		case FRONTDOOR :	fseek(f,0x26F8,SEEK_SET);
								j=10;								/* 10 aka's for FD */
								break;
	}
	for (i=0;i<=j;i++)
	{
		aka[i].zone=fgetc(f)+(256*fgetc(f));
		aka[i].net=fgetc(f)+(256*fgetc(f));
		aka[i].node=fgetc(f)+(256*fgetc(f));
		aka[i].point=fgetc(f)+(256*fgetc(f));
	}
	fseek(f,0x2755,SEEK_SET);				/* postion to users name field */
	for (i=0;i<(sizeof(users)/sizeof(string));i++)
	{
		fread(users[i],36,1,f);
		fseek(f,9,SEEK_CUR);
	}
	fclose(f);
}

boolean isaka(fido_address *nr)
{
	int i,j;
	boolean r=FALSE;

	j=(sizeof(aka)/sizeof(fido_address));

	for (i=0;i<j;i++)
	{
		if ((nr->zone==0 || aka[i].zone==nr->zone) && aka[i].net==nr->net &&
			 aka[i].node==nr->node && aka[i].point==nr->point) {r=TRUE; break;}
	}
	return(r);
}

int isuser(string nam)
{
	int i, r=-1;

	for (i=0;i<(sizeof(users)/sizeof(users[0]));i++)
	{
		if (stricmp(users[i],nam)==0) {r=i; break; }
	}
	return(r);
}

/* scan the message for PGP headers, kludges etc. */

long int scanmes(FILE *p,string toname,string fromname,fido_address *nr
				,fido_address *tonr, int *cf,unsigned int *flags, boolean *empty)
{
	char c,d=CR,kludge[128];
	unsigned int temp;
	int i;
	int lookpos[5]={0,9,10,6,14};
	boolean firstline=TRUE;
	long int r=0, fpos=190;

	*cf=0; *empty=TRUE;
	forcedtoname[0]=0;					/* init forced to name */
	fseek(p,0,SEEK_SET);					/* goto FromUser field */
	fread(fromname,36,1,p);
	fseek(p,36,SEEK_SET);				/* goto ToUserName field */
	fread(toname,36,1,p);					/* read name */
	fseek(p,166,SEEK_SET);				/* goto dest node field */
	tonr->node=fgetc(p)+(256*fgetc(p));
	fseek(p,168,SEEK_SET);				/* goto orig node field */
	nr->node=fgetc(p)+(256*fgetc(p));
	fseek(p,172,SEEK_SET);				/* goto orig net field */
	nr->net=fgetc(p)+(256*fgetc(p));
	fseek(p,174,SEEK_SET);				/* goto dest net field */
	tonr->net=fgetc(p)+(256*fgetc(p));
	nr->zone=nr->point=0;
	tonr->zone=tonr->point=0;
	fseek(p,186,SEEK_SET);				/* goto attribute field */
	*flags=fgetc(p)+(256*fgetc(p));
	fseek(p,190,SEEK_SET);				/* goto start of text */
	while ((c=fgetc(p))!=0 && c!=EOF)
	{
		kludge[0]=0;
		if (c==LF) continue;
		if (isprint(c) && c!='-') *empty=FALSE;
		if (toupper(c)=='P' && d==CR && *cf==0 && firstline)
		{
			fpos=ftell(p)-1;
			Fscans(p,kludge,sizeof(kludge)); c=d=CR;
			if (strnicmp(kludge,"GP CLEARSIG",11)==0)	*cf=2; 			/* clearsign ? */
			if (strnicmp(kludge,"GP SIGN ENCRYPT",15)==0) *cf=4;		/* cryptsign ? */
			if (strnicmp(kludge,"GP ENCRYPT SIGN",15)==0) *cf=4;		/* cryptsign ? */
			if ((*cf==0)&&(strnicmp(kludge,"GP ENCRYPT",10)==0)) *cf=1;	/* crypt ? */
			if ((*cf==0)&&(strnicmp(kludge,"GP SIGN",7)==0)) *cf=3;	/* sign ? */

			if (*cf>0)
			{
				getname(forcedtoname,&kludge[lookpos[*cf]],ON_PREV_FIELD,sizeof(forcedtoname)-2);
				fpos=ftell(p);
				firstline=FALSE;
				continue;
			}
		}
		if (c=='-' && d==CR && *cf==0)
		{
			fpos=ftell(p)-1;
			Fscans(p,kludge,sizeof(kludge)); c=d=CR;
			if (strncmp(kludge,"----BEGIN PGP ",14)==0)	/* PGP block header ? */
			{
				if (strncmp(&kludge[14],"MESSAGE",7)==0) *cf=-1;
				if (strncmp(&kludge[14],"SIGNED MES",10)==0) *cf=-2;
				if (strncmp(&kludge[14],"SIGNED KEY",10)==0) *cf=-3;
				if (strncmp(&kludge[14],"PUBLIC KEY",10)==0) *cf=-4;
			}
			if (*cf>0) { firstline=FALSE; continue; }
		}
		if (c==1 && d==CR)
		{
			Fscans(p,kludge,sizeof(kludge)); c=d=CR;
			if (strnicmp(kludge,"FMPT",4)==0)	/* FMPT kludge ? */
			{
				sscanf(&kludge[5],"%u",&temp);
				nr->point=temp;
			}
			else
			{
				if (strnicmp(kludge,"TOPT",4)==0)	/* TOPT kludge ? */
				{
					sscanf(&kludge[5],"%u",&temp);
					tonr->point=temp;
				}
				else
				{
					if (strnicmp(kludge,"INTL",4)==0)   /* INTL kludge ? */
					{
						sscanf(&kludge[5],"%u",&temp);
						tonr->zone=temp;			/* dest zone */
						i=5;
						while(kludge[i]!=' ') i++;
						sscanf(&kludge[i+1],"%u",&temp);
						nr->zone=temp;				/* orig zone */
					}
					else
					{
						if (*cf==0 && strnicmp(kludge,"PGP ",4)==0) /* PGP kludge?*/
						{
							if (strnicmp(&kludge[4],"ENCRYPT",7)==0) *cf=1;	   	/* crypt ? */
							if (strnicmp(&kludge[4],"CLEARSIG",8)==0)	*cf=2; 		/* clearsign ? */
							if (strnicmp(&kludge[4],"SIGN ENCRYPT",12)==0) *cf=4;	/* cryptsign ? */
							if ((*cf==0) && (strnicmp(&kludge[4],"SIGN",4)==0)) *cf=3;        	/* sign ? */
						}
					}
				}
			}
		}
		else firstline=FALSE;

		d=c;
	}
	if (*cf!=0) r=fpos;
	return(r);
}

int Fscans(FILE *fp,char *s, int len)
{
	int i;
	char c;

	for (i=0;i<len-1;i++)
	{
		c=fgetc(fp);
		if (c==CR) {s[i]=0; break;}
		s[i]=c;
	}
	s[len-1]=0;
	if ((c=fgetc(fp))!=LF) fseek(fp,-1,SEEK_CUR);
	return(i);
}

void request_imrescan(void)
{
	longstring temp;
	FILE *fp;

	if (mailertype==UNDEFINED) return;
	strcpy(temp,semadir);
	if (mailertype==FRONTDOOR) strcat(temp,"FDRESCAN.NOW");
	else	strcat(temp,"IMRESCAN.NOW");
	fp=fopen(temp,"wb");
	fclose(fp);
}

void request_ierescan(void)
{
	longstring temp;
	FILE *fp;

	if (mailertype==UNDEFINED) return;
	strcpy(temp,semadir);
	if (mailertype==FRONTDOOR) strcat(temp,"FDRESCAN.NOW");
	else strcat(temp,"IERESCAN.NOW");
	fp=fopen(temp,"wb");
	fclose(fp);
}

void getshareinfo(void)
{
	boolean network=FALSE;
	struct REGPACK regs;
	char c;

	if (shareflag==0)
	{
		regs.r_ax=0x1000;
		intr(0x2F,&regs);		/* test if SHARE installed */
		if ((regs.r_ax & 0xFF)==0xFF) { shareflag=1; return; }

		regs.r_ax=0x0000;		/* test if Microsoft NETWORK or Lantastic */
		intr(0x2A,&regs);		/* and also for Starlan Extended Netbios */
		if ((regs.r_ax & 0xFF) !=0) network=TRUE;
		else
		{
			regs.r_ax=0x7A00;	/* test for IPX installed */
			intr(0x2F,&regs);
			if((regs.r_ax & 0xFF)==0xFF) network=TRUE;
		}
	}
	if (network)
	{
		c=toupper(semadir[0]);
		if (semadir[1]==':' && isalpha(c) && c>='F')
		{
			printf("Semaphore dir %s probably on network.\n",semadir);
			shareflag=1;
		}
	}
}

/* try to lock the message base, timeout after 5 minutes or ESC */

int lockbase(void)
{
	string temp;
	int fhandle;
	time_t timer,timer1;
	boolean first=TRUE;

	if (shareflag!=1 || mailertype!=INTERMAIL) return(-1);
		/* skip rest if file not shareable  or mailer is not IM */

	time(&timer);
	timer1=timer;
	strcpy(temp,semadir);
	strcat(temp,"IMRENUM.NOW");

	fhandle=open(temp,O_CREAT|O_RDWR|O_DENYNONE,S_IREAD|S_IWRITE);
	if (fhandle==-1) return(fhandle);
	while (lock(fhandle,1000,1)!=0)
	{
		if (first)
		{
			printf("Waiting for renumber semaphore to clear....  (ESC to abort)\n");
			first=FALSE;
		}
		time(&timer);
		if (((timer-timer1)>300) || (kbhit() && getch()==ESC))
		{
			close(fhandle);
			Error(15,NULL);
			break;
		}
	}
	return(fhandle);
}

void unlockbase(int fhandle)
{
	if (fhandle==-1 || mailertype!=INTERMAIL) return;
	unlock(fhandle,1000,1);
	close(fhandle);
}

int de_crypt(FILE *fp,long int pos,long *curm, int cf, long mesnr)
{
	longstring tempfilein, tempfileout, kludgefile, viafile, mesfile;
	char command[128], errlev[25];
	FILE *tempin, *tempout, *kfile, *vfile, *mes;
	int c, d=CR, result;
	long i,fpos,fleng;
	boolean ok=FALSE;

	if (cf>=0 || cf<-2) return(0);

	strcpy(tempfilein,tempdir);
	strcat(tempfilein,"$$PGP_$$.ASC");
	strcpy(tempfileout,tempdir);
	strcat(tempfileout,"$$PGP_$$");
	strcpy(kludgefile,tempdir);
	strcat(kludgefile,"$$KLUDGE.TMP");
	strcpy(viafile,tempdir);
	strcat(viafile,"$$VIAS.TMP");
	tempin=fopen(tempfilein,"wb");
	if (tempin==NULL) Error(14,tempfilein);
	kfile=fopen(kludgefile,"wb");
	if (kfile==NULL) Error(14,kludgefile);
	vfile=fopen(viafile,"wb");
	if (vfile==NULL) Error(14,viafile);
	fseek(fp,190,SEEK_SET);

	while ((c=fgetc(fp))!=0 && c!=EOF)		/* copy message body to temp file */
	{                                      /* isolating the kludges and */
														/* the via kludges and write them */
		if (c==LF || c==SR) continue;       /* to two temp files */
		if (c==1 && d==CR)
		{
			Fscans(fp,command,sizeof(command)-2);
			if (strnicmp(command,"ENC: PGP",8)!=0)	/* but skip ENC: PGP kludges */
			{
				if (strnicmp(command,"VIA",3)==0) /* the via's go somewhere else */
				{
					fputc(1,vfile);
					fprintf(vfile,"%s\r\n",command);
				}
				else
				{
					fputc(1,kfile);
					fprintf(kfile,"%s\r\n",command);
				}
			}
			c=d=CR;
		}
		else
		{
			fputc(c,tempin);
			if (c==CR) fputc(LF,tempin);
			d=c;
		}
	}
	fclose(tempin);
	fclose(kfile);
	fclose(vfile);

	if (cf==-1) querypass();	/* ask pass frase, if we may need it */
	if (batchmode)
	{
		result=spawnl(P_WAIT,pgppath,pgppath,"+BATCHMODE","+FORCE",tempfilein,NULL);
	}
	else
	{
		result=spawnl(P_WAIT,pgppath,pgppath,"+FORCE",tempfilein,NULL);
	}
	sprintf(errlev,"Errorlevel %d",result);
	if (result>1) Error(22,errlev);
	else if (result<0) Error(8,errlev); else ok=TRUE;
	if (cf==-1)        					/* signed and|or encrypted mes */
	{
		tempout=fopen(tempfileout,"rb");
		if (tempout==NULL) Error(14,tempfileout);
		kfile=fopen(kludgefile,"rb");
		if (kfile==NULL) Error(14,kludgefile);
		vfile=fopen(viafile,"rb");
		if (vfile==NULL) Error(14,viafile);

		if (keepflag)
		{
			sprintf(mesfile,"%s%ld.MSG",maildir,*curm);
			mes=fopen(mesfile,"wb");
			if (mes==NULL) Error(16,mesfile);
			fseek(fp,0,SEEK_SET);
			for (i=0;i<190;i++) { c=fgetc(fp); fputc(c,mes); }
		}
		else
		{
			mes=fp;
			pos = 190;  /* added by Barto Veldhuis 1 jun 94 */
			fseek(mes,pos,SEEK_SET);
		}
		while ((c=fgetc(kfile))!=EOF) fputc(c,mes); /* first copy kludges then */
		fclose(kfile);
		fprintf(mes," * PGP decrypted message. ImCrypt %s\r\n",version);
		if (result==0) fprintf(mes," * Message has good signature.\r\n");
		fprintf(mes,"\r\n");
		while ((c=fgetc(tempout))!=0 && c!=EOF)	/* copy into message body */
		{
			fputc(c,mes);
		}
		fprintf(mes,"\r\n");
		while ((c=fgetc(vfile))!=EOF) fputc(c,mes); /* then copy the via's */
		fputc(0,mes);
		fclose(vfile);
		if (keepflag)
		{
			fseek(mes,184,SEEK_SET);
			fputc((int)(mesnr&0xFF),mes);
			fputc(((int)(mesnr>>8)&0xFF),mes);	/* update reply link */
			fclose(mes);
			fseek(fp,188,SEEK_SET);
			fputc((int)((*curm)&0xFF),fp);
			fputc(((int)((*curm)>>8)&0xFF),fp);	/*update reply link */
			fseek(fp,pos,SEEK_SET);
			fputc('*',fp);				/* mangle PGP header to avoid decrypt */
											/* at next pass */
			sprintf(pstr,"Plaintext written to msg %ld.\n",*curm);
			pstring(pstr,0);
			(*curm)++;
		}
		else
		{           		/* fill excess length of file with zero's */
			fpos=ftell(fp);
			fleng=filelength(fileno(fp));
			if (fleng>fpos) for (i=0;i<fleng-fpos;i++) fputc(0,fp);
			fclose(mes);
			sprintf(pstr,"Plaintext has overwritten msg. %ld.\n",mesnr);
			pstring(pstr,0);
		}
		fclose(tempout);
		remove(tempfileout);
	}
	if (cf==-2)							/* clearsigned message */
	{
		fseek(fp,pos,SEEK_SET);		/* mangle PGP header to avoid decrypt */
		fputc('*',fp);             /* at next pass */
		fseek(fp,-1,SEEK_END);
		fprintf(fp," * Signature verification ");
		if (ok) fprintf(fp,"Ok!\r\n");
		else fprintf(fp,"FAILED!\r\n");
		fputc(0,fp);
	}
	remove(tempfilein);
	remove(kludgefile);
	remove(viafile);
	if (result==1) return(0); else return(result);
}

int en_crypt(FILE *fp,long int pos,long curm,char *fromname,char *toname,int cf,boolean *dflag)
{
	longstring tempfilein, tempfileout, message, kludgefile;
	char command[128],number[10],Fromname[40],Toname[40],InetAddress[128]={0};
	FILE *tempin, *tempout, *mes, *kfile;
	boolean uucpflag=FALSE, firstchar=TRUE;
	int c,d=CR;
	int i,j,result;
	unsigned int flags,oldflags;
	int try_it_again = 0;   /* try_it_again trick supplied by Barto Veldhuis */

	sprintf(Toname,"\"%s\"",toname);			/* provide names in qoutes */
	if (forcedtoname[0]) strcpy(Toname,forcedtoname); /* if toname forced */
	sprintf(Fromname,"\"%s\"",fromname);
	if (stricmp(toname,"UUCP")==0) uucpflag=TRUE;

	fseek(fp,186,SEEK_SET);			/* position to flags field */
	oldflags=flags=fgetc(fp)+(256*fgetc(fp));
	if (flags & KILLSEND) *dflag=TRUE;
	fseek(fp,186,SEEK_SET);
	oldflags=oldflags | SEND;			/* set send flag in old mes */
	fputc(oldflags & 0xFF,fp); fputc(oldflags>>8,fp);
	strcpy(tempfilein,tempdir);
	strcat(tempfilein,"$$PGP_$$.TXT");
	strcpy(tempfileout,tempdir);
	strcat(tempfileout,"$$PGP_$$.ASC");
	tempin=fopen(tempfilein,"wb");
	if (tempin==NULL) Error(14,tempfilein);
	strcpy(kludgefile,tempdir);
	strcat(kludgefile,"$$KLUDGE.TMP");
	kfile=fopen(kludgefile,"wt");
	if (kfile==NULL) Error(14,kludgefile);

	fseek(fp,190,SEEK_SET);			/* start of message body */

	while ((c=fgetc(fp))!=0 && c!=EOF)
	{
		if (c==SR || c==LF) continue;
		if (c==1 && d==CR)						/* isolate the kludges */
		{
			Fscans(fp,command,sizeof(command)-2);
			if (strnicmp(command,"PGP",3)!=0
				|| strnicmp(command,"ENC: PGP",8)==0) /* if PGP kludge skip it */
			{
				fputc(1,kfile);
				fprintf(kfile,"%s\n",command); /* and write to a temp */
			}
			c=d=CR;
		}
		else d=c;
	}

	fseek(fp,pos,SEEK_SET);						/* goto line after "PGP ..." */
	d=CR;

	while ((c=fgetc(fp))!=0 && c!=EOF)		/* copy message body to temp file */
	{
		if (c==SR || c==LF) continue;
		if (c==1 && d==CR)						/* isolate the kludges */
		{
			while((c=fgetc(fp))!=0 && c!=EOF && c!=CR) ; /* strip kludges */
			c=d=CR;
		}
		else
		{
			 if (uucpflag && firstchar && toupper(c)=='T')
			 {
				Fscans(fp,command,sizeof(command)-2);	/* get the internet adds */
				i=2;
				while (command[i]==' ' && command[i]) i++; /* skip to Inet addr */
				j=0;
				while (command[i]!=' ' && command[i])
				{              					/* copy InterNet addres to toname */
					Toname[j]=command[i];
					j++; i++;
				}
				Toname [j]=0;
				sprintf(InetAddress,"To: %s",Toname);		/* save it in a string */
				while (isspace(command[i])) i++;		 /* skip to next field if any */
				if (command[i]) getname(Toname,&command[i],ALLOW_PAREN,sizeof(Toname)-2);
				Fscans(fp,command,sizeof(command)-2);  /* skip empty line */
			 }
			 else
			 {
				fputc(c,tempin);
				if (c==CR) fputc(LF,tempin);
				d=c;
			 }
		}
		firstchar=FALSE;
	}
	fclose(tempin);
	fprintf(kfile,"\001ENC: PGP\n");					/* add a ENC: PGP kludge */
	fclose(kfile);

	/*	1 = encrypt
		2 = clearsign
		3 = armor sign
		4 = sign and encrypt */
	do
	{
		if (try_it_again) /* change name with points to name without  */
		{                 /* them or vise versa */
			sprintf(pstr,"%s not found in public keyring\n", Toname);
			pstring(pstr,2);
			if (strchr(Toname,'.'))
	 		{
				for (i=0; Toname[i] != '\0'; i++)
				if (Toname[i] == '.') Toname[i] = 0x20;
			}
			else
			{
				for (i=0,j=0; Toname[i] != '\0'; i++)
				if (Toname[i] == 0x20) { if (j) Toname[i] = '.'; else j=1; }
			}
			sprintf(pstr,"Trying %s\n", Toname);
			pstring(pstr,2);
		}
		switch(cf)
		{
			case 1:	result = spawnl(P_WAIT,pgppath,pgppath,"-eta",batchmode ? "+BATCHMODE +FORCE":"+FORCE",tempfilein,Toname,NULL);
				break;
			case 2: querypass();
				result = spawnl(P_WAIT,pgppath,pgppath,"-sta",batchmode?"+BATCHMODE +CLEARSIG=ON":"+CLEARSIG=ON",tempfilein,Fromname,NULL);
				break;
			case 3: querypass();
				result = spawnl(P_WAIT,pgppath,pgppath,"-sa",batchmode?"+BATCHMODE +FORCE":"+FORCE",tempfilein,Fromname,NULL);
				break;
			case 4: querypass(); /* Attention! Fromname is commented out to make sure an 21 error is given if Toname is not found in the public keyring */
				result = spawnl(P_WAIT,pgppath,pgppath,"-esa",batchmode?"+BATCHMODE +FORCE":"+FORCE",tempfilein,Toname/*,Fromname*/,NULL);
				break;
		}
	}
	while(result==KEYNOTFOUND && (++try_it_again==1) && !uucpflag);

	sprintf(number,"%d",result);
	if (result<0) { Error(8,number); return(result); }
	if (result>0) { Error(9,number); return(result); }

	sprintf(message,"%s%ld.MSG",maildir,curm);
	mes=fopen(message,"wb");
	if (mes==NULL) Error(21,message);
	fseek(fp,0,SEEK_SET);
	for (j=0;j<186;j++) {c=fgetc(fp); fputc(c,mes);}
	flags=flags | KILLSEND;
	fputc(flags & 0xFF,mes); fputc(flags>>8,mes);
	fseek(fp,188,SEEK_SET);
	for (i=188;i<190;i++) {c=fgetc(fp); fputc(c,mes);}
	tempout=fopen(tempfileout,"rb");
	if (tempout==NULL) Error(14,tempfileout);
	kfile=fopen(kludgefile,"rb");
	if (kfile==NULL) Error(14,kludgefile);
	while ((c=fgetc(kfile))!=EOF) fputc(c,mes);	/* first the kludges */
	fclose(kfile);                               /* then the "To:" if uucp */
	if (uucpflag && InetAddress[0]) fprintf(mes,"%s\r\n\r\n",InetAddress);
	while ((c=fgetc(tempout))!=EOF && c!=0) fputc(c,mes); /* then the body */
	fputc(0,mes);			/* closing zero */
	fclose(mes);
	fclose(tempout);
	remove(tempfilein);
	remove(tempfileout);
	remove(kludgefile);
	sprintf(pstr,"Armortext written to msg %ld.\n",curm);
	pstring(pstr,0);
	return(result);
}


int sendkey(FILE *fp, long curm, char *fromname, char *toname,
											fido_address *fromnr,fido_address *tonr)
{
	longstring tempfileout, message;
	char command[128],number[10],Fromname[40];
	FILE *tempout, *mes;
	int c;
	int i,result,year;
	unsigned int flags,destnode,destnet,myzone;
	time_t l;
	struct tm *loc;

	sprintf(Fromname,"\"%s\"",fromname);	/* name in qoutes */
	strcpy(tempfileout,tempdir);
	strcat(tempfileout,"$$PGP_$$.ASC");

	if (batchmode) result=spawnl(P_WAIT,pgppath,pgppath,"-kxa","+BATCHMODE",
									Fromname,tempfileout,NULL);
	else result=spawnl(P_WAIT,pgppath,pgppath,"-kxa",Fromname,tempfileout,NULL);


	sprintf(number,"%d",result);
	if (result<0) { Error(8,number); return(result); }
	if (result>0) { Error(9,number); return(result); }

	sprintf(message,"%s%ld.MSG",maildir,curm);
	mes=fopen(message,"wb");
	if (mes==NULL) Error(21,message);

	for (i=0;i<36;i++)                  /* from */
	{
		if (fromname[i]==0) break;
		if (fromname[i]=='_') fputc(' ',mes); else fputc(fromname[i],mes);
	}
	for (;i<36;i++) fputc(0,mes);

	for (i=0;i<36;i++)                  /* to */
	{
		if (toname[i]==0) break;
		if (toname[i]=='_') fputc(' ',mes); else fputc(toname[i],mes);
	}
	for (;i<36;i++) fputc(0,mes);

	fseek(fp,72,SEEK_SET);		/* get subject line in orig mes */
	for (i=0;i<72;i++) fputc(fgetc(fp),mes); /* and copy */

	time(&l);                    /* date and time */
	loc=localtime(&l);

	gettime(&timep);
	year=loc->tm_year % 100;
	i=loc->tm_mon+1; if (i<1 || i>12) i=0;
	fprintf(mes,"%02d %s %02d  %02d:%02d:%02d%c",loc->tm_mday,monthn[i],
									year,loc->tm_hour,loc->tm_min,loc->tm_sec,0);

	fputc(0,mes); fputc(0,mes); 	/* times read = 0 */

	if (tonr->zone && fromnr->zone && tonr->zone!=fromnr->zone)
	{ destnet=fromnr->zone; destnode=tonr->zone; } 		/* via zonegate */
	else { destnet=tonr->net; destnode=tonr->node; }   /* own zone */
	fputc(destnode & 0xFF,mes); fputc(destnode>>8,mes); /* dest node */
	fputc(fromnr->node & 0xFF,mes);fputc(fromnr->node>>8,mes); /* orig node */
	fputc(0,mes); fputc(0,mes); 	/* cost 0 */
	fputc(fromnr->net & 0xFF,mes);fputc(fromnr->net>>8,mes); /* orig net */
	fputc(destnet & 0xFF,mes); fputc(destnet>>8,mes); /* dest net */
	for (i=0;i<10;i++) fputc(0,mes); 	/* 8 byte fill + replyto */

	flags=(LOCAL | PRIVATE);
	if (killflag) flags=(flags | KILLSEND);
	fputc(flags & 0xFF,mes);	fputc(flags>>8,mes);

	fputc(0,mes); fputc(0,mes); 	/* nextreply=0 */
	if (fromnr->zone!=tonr->zone) fprintf(mes,"\001INTL %u:%u/%u %u:%u/%u\r\n",
								tonr->zone,tonr->net,tonr->node,fromnr->zone,fromnr->net,fromnr->node);
	if (fromnr->point!=0) fprintf(mes,"\001FMPT %u\r\n",fromnr->point);
	if (tonr->point!=0)  fprintf(mes,"\001TOPT %u\r\n",tonr->point);
	if (fromnr->zone==0) myzone=matchzone(fromnr->net,fromnr->node,fromnr->point);
	else myzone=fromnr->zone;
	time(&l);
	fprintf(mes,"\001MSGID: %u:%u/%u.%u %08lx\r\n",myzone,fromnr->net,fromnr->node,fromnr->point,l);
	fprintf(mes,"\001PID: ImCrypt %s\r\n",version);		/* PID kludge */
	fprintf(mes,"You asked for the public key of %s.\n",fromname);
	fprintf(mes," Here it is:\r\n\r\n");
	tempout=fopen(tempfileout,"rb");
	if (tempout==NULL) Error(14,tempfileout);
	while ((c=fgetc(tempout))!=EOF && c!=0) fputc(c,mes); /* then the body */
	fputc(0,mes);			/* closing zero */
	fclose(mes);
	fclose(tempout);
	remove(tempfileout);
	fseek(fp,186,SEEK_SET);			/* position to flags field */
	flags=fgetc(fp)+(256*fgetc(fp));
	fseek(fp,186,SEEK_SET);
	flags=flags | RECEIVED;			/* set recvd flag in orig mes */
	fseek(fp,186,SEEK_SET);			/* position to flags field */
	fputc(flags & 0xFF,fp); fputc(flags>>8,fp);
	if (tonr->zone!=0)
	{
		sprintf(command,"Key served to %s (%u:%u/%u.%u) Msg %ld.\n",toname,
								myzone,tonr->net,tonr->node,tonr->point,curm);
	}
	else
	{
		sprintf(command,"Key served to %s (%u/%u.%u) Msg %ld.\n",toname,
												tonr->net,tonr->node,tonr->point,curm);
	}
	pstring(command,0);
	return(result);
}

unsigned int matchzone(unsigned int net,unsigned int node,unsigned int point)
{
	int i;

	for (i=0;i<sizeof(aka)/sizeof(fido_address);i++)
	{
		if (aka[i].net==net && aka[i].node==node && aka[i].point==point)
			 return(aka[i].zone);
	}
	return(0);
}


/* that's it folks */
