PROGRAM setfiletime;
USES dos;
{------------------------------------------------------------------------------

                                REVISION HISTORY

v1.00  : 1993/07/14.  First public release (as REDATE!).  DDA
v1.10  : 1993/09/07.  Added support for single field specification,
                            suggestion and assistance from Don Dougherty.  DDA
                      Added support for century.
                        (In DOS, SET century=20 for 20th century dates.)  DDA
v1.10a : 1993/09/09.  Now specifying seconds is optional, default is :00  DDA
v1.11  : 1993/09/13.  Added "/p": prompt for date, time doesn't change.  DDA
v1.15  : 1993/09/28.  Increased date & time specification flexibility.  DDA
v1.20  : 1993/10/20.  Now can stamp files not in current directory.  DDA
v1.21  : 1994/02/17.  Overlooked portion of code in making prior enhancement,
                      now fixed.  NO PUBLIC RELEASE.  DDA
v1.22  : 1994/05/22.  New name (DT), fully tested, & (hopefully) debugged. DDA
v1.23  : 1994/05/23.  Minor documentation corrections.  NO PUBLIC RELEASE. DDA
v1.24  : 1994/08/09.  Optimized source code, plus minor fixes.  DDA

------------------------------------------------------------------------------}

VAR
  cdt : longint;
PROCEDURE showhelp (errornum :byte);
CONST
  progdesc = 'DT- Free DOS utility: file date/time stamper.';
  author   = 'v1.24: August 9, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';

  usage   = 'Usage: DT file(s) [mm/dd/yy (or) mm-dd-yy] [hh:mm[:ss]]';
  usage2  = '  or : DT file(s) /p  (prompt for date, time doesn''t change)';
VAR
  message : STRING [80];
BEGIN
  CASE (errornum) OF
    1 : message:='you must specify -exactly- one filespec (wildcards are OK).';
    2 : message:='too many parameters.';
    3 : message:='non-numeric found in a date or time string!';
  END;
  writeln (progdesc);  writeln (author);   writeln;
  writeln (usage);     writeln (usage2);   writeln;
  writeln ('ERROR: (#', errornum, ') - ', message);
  halt (errornum);
END;

FUNCTION leadingzero (w :word) : STRING;
VAR
  s : STRING;
BEGIN
  str (w :0, s);
  IF (length (s) = 1) THEN
    s:='0'+s;
  leadingzero:=s;
END;

PROCEDURE parsedate (dates :STRING);
VAR
  date_time : datetime;
  ve,
  v1,v2,v3  : integer;
  century   : byte;
BEGIN
  val (getenv ('century') , century, ve);
  IF (ve <> 0) THEN century:=19;
  IF (length (dates) = 7) THEN
    dates:='0'+dates;
  unpacktime (cdt, date_time);
  WITH date_time DO BEGIN
    val (copy (dates, 1, 2), month, v1);
    val (copy (dates, 4, 2), day, v2);
    val (copy (dates, 7, 2), year, v3);
    IF ((v1+v2+v3) <> 0) THEN showhelp (3);
    year:=century*100+year;
  END;
  packtime (date_time, cdt);
END;

PROCEDURE parsetime (times :STRING);
VAR
  date_time : datetime;
  v1,v2,v3  : integer;
BEGIN
  case length(times) of
    4 : times:='0'+times+':00';
    5 : times:=times+':00';
    7 : times:='0'+times;
  end;
  unpacktime (cdt, date_time);
  WITH date_time DO BEGIN
    val (copy (times, 1, 2), hour, v1);
    val (copy (times, 4, 2), min, v2);
    val (copy (times, 7, 2), sec, v3);
    IF ((v1+v2+v3) <> 0) THEN showhelp (3);
  END;
  packtime (date_time, cdt);
END;

PROCEDURE get_dt;
VAR
  y,mo,d,w,
  h,mi,s,u  : word;
  date_time : datetime;
BEGIN
  getdate (y, mo, d, w);
  gettime (h, mi, s, u);
  WITH date_time DO BEGIN
    YEAR:=y;  MONTH:=mo;  DAY:=d;
    HOUR:=h;  MIN:=mi;  SEC:=s;
  END;
  packtime (date_time, cdt);
END;

FUNCTION get_fdate (fd, fname :STRING) : STRING;
VAR
  afile : FILE;
  fdate : longint;
  dtt   : datetime;
BEGIN
  assign (afile, fd+fname);
  {$I-} reset (afile);                 {$I+}
  IF (ioresult = 0) THEN BEGIN
    getftime (afile, fdate);
    close (afile);
    unpacktime (fdate, dtt);
    WITH dtt DO BEGIN
      get_fdate:=leadingzero (month)+'/'+
        leadingzero (day)+'/'+
        (copy ((leadingzero (year)), 3, 2));
    END;
  END
  ELSE
    get_fdate:='01/01/80';
END;

FUNCTION get_ftime (fd, fname :STRING) : STRING;
VAR
  afile : FILE;
  ftime : longint;
  dtt   : datetime;
BEGIN
  assign (afile, fd+fname);
  {$I-} reset (afile);                 {$I+}
  IF (ioresult = 0) THEN BEGIN
    getftime (afile, ftime);
    close (afile);
    unpacktime (ftime, dtt);
    WITH dtt DO BEGIN
      get_ftime:=leadingzero (hour)+':'+
        leadingzero (min)+':'+
        leadingzero (sec);
    END;
  END
  ELSE
    get_ftime:='00:00:00';
END;

PROCEDURE stampfile (fname :STRING);
VAR
  afile : FILE;
BEGIN
  assign (afile, fname);
  {$I-} reset (afile);                 {$I+}
  IF (ioresult = 0) THEN BEGIN
    setftime (afile,cdt);
    close (afile);
    write ('.');
  END;
END;

PROCEDURE todaysdate (fd :STRING; VAR di :searchrec);
BEGIN
  get_dt;
  WHILE (doserror = 0) DO BEGIN
    stampfile (fd+di.name);
    findnext (di);
  END;
END;

PROCEDURE justdate (fd :STRING; VAR di :searchrec; datestr :STRING);
BEGIN
  parsedate (datestr);
  WHILE (doserror = 0) DO BEGIN
    parsetime (get_ftime (fd, di.name));
    stampfile (fd+di.name);
    findnext (di);
  END;
END;

PROCEDURE justtime (fd :STRING; VAR di :searchrec; timestr :STRING);
BEGIN
  parsetime (timestr);
  WHILE (doserror = 0) DO BEGIN
    parsedate (get_fdate (fd, di.name));
    stampfile (fd+di.name);
    findnext (di);
  END;
END;

PROCEDURE newdate (fd :STRING; VAR di :searchrec; datestr, timestr :STRING);
BEGIN
  parsedate (datestr);
  parsetime (timestr);
  WHILE (doserror = 0) DO BEGIN
    stampfile (fd+di.name);
    findnext (di);
  END;
END;

VAR
  dirinfo : searchrec;
  ps1     : pathstr;
  rdir    : dirstr;
  rname   : namestr;
  rext    : extstr;
  ps2     : STRING;

BEGIN
  ps1:=(fexpand (paramstr (1)));
  fsplit (ps1, rdir, rname, rext);
  findfirst (ps1, archive, dirinfo);
  IF (doserror <> 0) THEN
    showhelp (1);
  write ('Working ');
  
  CASE (paramcount) OF
    1 : todaysdate (rdir, dirinfo);
    2 : BEGIN 
          ps2:=paramstr (2);
          IF (ps2[2] IN ['p', 'P']) THEN BEGIN
            WHILE (length (ps2) < 8) DO BEGIN
              writeln;
              writeln ('Enter a date in the format mm/dd/yy:');
              readln (ps2);
            END;
            justdate (rdir, dirinfo, ps2);
          END
          ELSE BEGIN
            IF ((ps2[length (ps2)-2] IN ['-', '/'])
            { 12/45/78 }) THEN justdate (rdir, dirinfo, ps2)
            ELSE justtime (rdir, dirinfo, ps2);
          END;
        END;
    3 : newdate (rdir, dirinfo, paramstr (2), paramstr (3));
    ELSE
      showhelp (2);
  END;                                 { case }

  writeln (' done!');
END.


writeln(times);
writeln(dates);
VAR
  dt_int : longint;
  dt_int:=0;
VAR
  dt_int  : longint;
  dt_int:=0;
VAR
  dt_int  : longint;
  dt_int:=0;


