#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#define NUMBERS 10 
#define INVOCATION_ERROR 20
#define FILENAME argv[1]
#define TRUE 1
#define FALSE 0
#define NUMCVT 48
#define PARAM_NO 2
#define APOSTROPHE 39
#define DOLLAR_SIGN '$'


const char *Table [NUMBERS] = {
				  "ZERO",
				  "ONE",
				  "TWO",
				  "THREE",
				  "FOUR",
				  "FIVE",
				  "SIX",
				  "SEVEN",
				  "EIGHT",
				  "NINE"
				  };


long code( char *filename );





void main( int argc, char **argv )
{
   long no;

	 if( argc != PARAM_NO )
	    {
	    printf( "\nForm: cvt FILENAME." );
	    exit( INVOCATION_ERROR );
	    }

	 no = code( FILENAME );

	 printf( "\n%ld characters converted in the file %s.", no, FILENAME );


}




long code( char *filename )
{

   register int c;
   long number = 0;

   FILE *plaintxt,
	   *cvtfile;


	plaintxt = fopen( filename, "r" );
	cvtfile = fopen( "file.cvt", "w" );





   while(  EOF != ( c = fgetc( plaintxt ) ) )
	 {
	  if( isdigit( c ) )
		{
		c -= NUMCVT;
		fputs( Table [c], cvtfile );
		}

	  else
	    if( c == '$' )
		  fputs( "DOLLARSIGN", cvtfile );

	  else
		if( ispunct( c ) )
		   switch( c )
			 {
			 case '.':
			    fputs( "PERIOD", cvtfile );
			    break;
			 case ',':
			    fputs( "COMMA", cvtfile );
			    break;
			 case ':':
			    fputs( "COLON", cvtfile );
			    break;
			 case ';':
			    fputs( "SEMICOLON", cvtfile );
			    break;
			 case '"':
			    fputs( "QUOTE", cvtfile );
			    break;
			 case '!':
			    fputs( "EXCLAMATIONPOINT", cvtfile );
			    break;
			 case APOSTROPHE:
			    fputs( "APOSTROPHE", cvtfile );
			    break;
			 }

	  else
		fputc( c, cvtfile );

	  number++;

	   }

   fcloseall();

   return( number );

}


