/*************************************************************************/
/*          CREATES RANDOM CODE.KEY FILE FOR BINARY FILE ENCODING        */
/*                   range of random numbers 0 - 255                     */
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <io.h>

#define INVOCATION_ERROR 5
#define FILE_ERR 10
#define ARGCOUNT 2
#define FILENAME argv[1]
#define RANGE 255
// ***        ^^^ range of random "shifts" ***

int create_file( char *filename, long int count );

void main( int argc, char **argv )
{
   long len;
   FILE *f;

	 if( argc != ARGCOUNT )
	    {
	    puts(
	    "Form: ffcr FILE_NAME, where FILE_NAME is the file to be encoded."
	    );

	    exit ( INVOCATION_ERROR );
	    }

	 f = fopen( FILENAME, "r" );


	 len = filelength( fileno( f ) );
	 printf( "\n\nCreating a CODE.KEY file at least %ld bytes long.\n", len );
	 create_file( "code.key", len );

	 fclose ( f );


}

int create_file( char *filename, long int count )
{
   register int r;
   long n;
   FILE *fp;

	 randomize();

	 if( NULL == ( fp = fopen( filename, "w" ) ) )
	   {
	   printf( "\nCannot open file %s\n", filename );         
	   exit ( FILE_ERR );
	   }

	 for( n = 0; n < count; n++ )
	    {
	    r = random( RANGE );
	    fputc( r, fp );
	    }

	 fclose( fp );

	 return ( n );

}
