
/* file RIP.H */

/* RIP.CPP and RIP.H have problems with the "parameter not used"
   warning.  The author is working on this... */

#ifndef _RIP_H_
#define _RIP_H_

/********************************************************
 *                                                      *
 *            C++ interface for QRIP/TSR                *
 *              by Shane Hathaway, 1994                 *
 *                                                      *
 *       Absolutely public domain - modify and          *
 *         distribute this C++ module freely!           *
 *                                                      *
 ********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <conio.h>
#include <string.h>
#include <conio.h>

#ifndef _KEYS_H_
#include "keys.h"
#endif

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))

#define qripflags_ansi        = 0x0001,
#define qripflags_rip         = 0x0002,
#define qripflags_gr_on       = 0x0004,
#define qripflags_text_on     = 0x0008,
#define qripflags_at_vars     = 0x0010,
#define qripflags_scene_wait  = 0x0020,
#define qripflags_antistrip   = 0x0040,
#define qripflags_sound       = 0x0080,
#define qripflags_filter      = 0x0100,
#define qripflags_displayonly = 0x0200,
#define qripflags_suppress    = 0x0400

#define qripmode_sbaron       = 0;
#define qripmode_sbaroff      = 1;
#define qripmode_vt102on      = 2;
#define qripmode_vt102off     = 3;
#define qripmode_doorwayon    = 4;
#define qripmode_doorwayoff   = 5;
#define qripmode_hotkeyson    = 6;
#define qripmode_hotkeysoff   = 7;
#define qripmode_tabkeyon     = 8;
#define qripmode_tabkeyoff    = 9;

#define QRIP_MODES 10


// class qrip provides low-level access to the TSR.

class qrip
{
  int qrip_installed;

protected:
  unsigned short call_qrip(char funcno);

public:
  union REGS regs;

  qrip(void);

  int qrip_resident(void) { return qrip_installed; }
};


// rip_module accesses keyboard_driver instead of kbhit() and getch().

class keyboard_driver
{
public:
  virtual int lowlevel_kbhit(void) { return kbhit(); }
  virtual int lowlevel_getch(void) { return getch(); }
};


// RIP special events handler

class rip_events
{
public:

// 'virtual takeover' functions...

  virtual void statbar_on(void)    {}
  virtual void statbar_off(void)   {}
  virtual void vt102_on(void)      {}
  virtual void vt102_off(void)     {}
  virtual void doorway_on(void)    {}
  virtual void doorway_off(void)   {}
  virtual void hotkeys_on(void)    {}
  virtual void hotkeys_off(void)   {}
  virtual void tabkey_on(void)     {}
  virtual void tabkey_off(void)    {}

  virtual void execute_app(int n)  {}
  virtual void rightbutton(void)   {}
  virtual void middlebutton(void)  {}
  virtual void cue_blockmode(void) {}
  virtual void do_xoff(void)       {}
  virtual void do_xon(void)        {}
};


// RIP modes handler

class rip_modes : private rip_events
{
  int
    statbar,
    vt102,
    doorway,
    hotkeys,
    tabkey;

protected:
  void cue_change(int i);  // function only accessible to rip_module.

  // protected constructor: required to be inherited.
  rip_modes(void) : statbar(0), vt102(0), doorway(0), hotkeys(0), tabkey(0) {}

public:
  int query_statbar(void) { return statbar; }
  int query_vt102(void)   { return vt102; }
  int query_doorway(void) { return doorway; }
  int query_hotkeys(void) { return hotkeys; }
  int query_tabkey(void)  { return tabkey; }
};


// RIP block transfer mode information

struct rip_blockinfo
{
  int protocol;
  int uploading;
  int filetype;
  char far *filename;

/* Protocols:

   0     Xmodem (checksum)          Yes
   1     Xmodem (CRC)               Yes
   2     Xmodem-1K                  Yes
   3     Xmodem-1K (G)              Yes
   4     Kermit                     Yes
   5     Ymodem (batch)             No
   6     Ymodem-G                   No
   7     Zmodem (crash recovery)    No
*/

/* File types:

   0     RIP file sequence (display it, don't store)
   1     RIP file sequence (store them in ICONS subdirectory)
   2     ICN file sequence (store them in ICONS subdirectory)
   3     HLP file sequence (store it, and auto-load if needed)
   4     COMPOSITE DYNAMIC file sequence (batch protocols only)
   5     ACTIVE DYNAMIC file sequence (batch protocols only)

*/

  void fillblock(union REGS regs);
};


// rip_module gives access to all of QRIP.

class rip_module : public qrip, private keyboard_driver, public rip_modes
{
  int str_waiting;

  void set_qrip_str(char *s, int fn);
  void signify_change(int num) { regs.x.bx = num; call_qrip(0x16); }
  unsigned char ret_key(void);
public:
  rip_module(void) : str_waiting(0) {}

  // Input / output.

  virtual void outs(char far *s);           // Send a string.
  virtual unsigned char outs1(char far *s); // Send a string and return a key.
  virtual unsigned char getkey(void) { call_qrip(0x06); return ret_key(); }
  virtual char far *getkeystr(int &len);    // Use a reference to ENSURE no null pointers.
  virtual void sendkey(unsigned short k) { regs.x.bx = k; call_qrip(0x18); }

  // The QRIP control functions

  unsigned short changeflags(unsigned short f_on, unsigned short f_off)
    { regs.x.bx = f_on; regs.x.cx = f_off; call_qrip(0x01); return regs.x.bx; }

  void graphics_on(void) { call_qrip(0x03); }
  void graphics_off(void) { call_qrip(0x02); }

  void setfonts(char *s) { set_qrip_str(s, 0); }
  void seticons(char *s) { set_qrip_str(s, 1); }

  void protect_on(int lines, int attr)
    { regs.x.bx = attr; regs.x.cx = lines; call_qrip(0x0d); }
  void protect_write(int x, int y, char *s);
  void protect_scroll(int x1, int y1, int x2, int y2, int lines);
  void protect_color(unsigned char attr)
    { regs.x.bx = attr; call_qrip(0x10); }
  void protect_fullscreen(void) { call_qrip(0x11); }
  void protect_off(void) { protect_on(0, 7); }

  void popup_on(void) { call_qrip(0x12); }
  void popup_off(void) { call_qrip(0x13); }

  void graph_save(void) { call_qrip(0x14); }
  void graph_restore(void) { call_qrip(0x15); }

  // Miscellaneous

  void end_keywait(void) { signify_change(0); }
  void changemode(int modenum)
    { if (modenum < QRIP_MODES) signify_change(modenum + 1); }
  void callfile(char *s)
    { regs.x.bx = FP_OFF(s); regs.x.dx = FP_SEG(s); call_qrip(0x17); }
  void hangup(void) { call_qrip(0x19); }
  void blockmode_info(rip_blockinfo *rbi) { call_qrip(0x1a); rbi->fillblock(regs); }
  void sysfont(int n) { regs.x.bx = n; call_qrip(0x1b); }
  int strwait(void) { return str_waiting; }
};


class farcharbuffer
{
  char far *buf;
  int size, head;
public:
  farcharbuffer(void) : buf(NULL), size(0), head(0) {}
  farcharbuffer(int sz) : buf(NULL), size(0), head(0)
    { setup_buffer(sz); }
  ~farcharbuffer(void) { farfree(buf); }

  int setup_buffer(int sz);

  void push(char c);
  char far *popstr(void);
  char popchr(void);
  int holding(void) { return head; }
  int full(void) { return (head >= size); }
};


class buffered_rip : public rip_module
{
  farcharbuffer chrsout, keysin;

  // Hide these functions now - the new ones are MUCH better!

  void outs(char far *s) {}
  unsigned char outs1(char far *s) { return 0; }
  unsigned char getkey(void) { return 0; }
  char far *getkeystr(int &len) { return NULL; }
  void sendkey(unsigned char k) {}
public:
  buffered_rip(void) : chrsout(1024), keysin(256) {}
  int set_buffers(int outsize, int insize)
    { return (chrsout.setup_buffer(outsize) && keysin.setup_buffer(insize)); }

  void outstr(char *s);
  void outchr(char c);
  int kbhit(void)
    { return (qrip_resident() ? keysin.holding() : lowlevel_kbhit()); }
  int getch(void)
    { return (qrip_resident() ? keysin.popchr() : lowlevel_getch()); }

  // Here's the key to buffered_rip.  It doesn't transfer between QRIP
  // and the program until there's a useful amount of information;
  // thus it speeds up the program by not requiring DOS to switch
  // PSP's and DTA's quite so often.

  void update(int minchrs);
};


class term_emu : public buffered_rip
{
  int rdetect;
public:
  term_emu(void);

  void outstr(char *s);
  void outchr(char c);
  void clrscrn(void);

  virtual void ansi_outstr(char *s) { puts(s); }
  virtual void ansi_outchr(char c) { putchar(c); }
  virtual void ansi_clrscrn(void) { clrscr(); }
};


#endif // _RIP_H_

