;**************************************************************************
; STANDARD INCLUDE FILE FOR MASM 5.1 MODULES LINKED WITH 'C' PROGRAMS
;  defines common equates
;**************************************************************************

;  Mike Dumdei,  6 Holly Lane,  Texarkana TX  75503

IFNDEF ??version
 IF1START EQU <IF1>
 IF1END EQU <ENDIF>
ELSE
 IF1START EQU <>
 IF1END EQU <>
ENDIF

% IF1START

;------ Define external procedures/variables macros -----

IMPORT  macro   typ, list
ifdifi  <typ>,<PTRS>
        irp     x,<list>
        extrn   x:typ
        endm
endif
ifidni  <typ>,<PTRS>
  if @DataSize
        irp     x,<list>
        extrn   x:DWORD
        endm
  else
        irp     x,<list>
        extrn   x:WORD
        endm
  endif
endif
        endm

GLOBE   macro   typ, list
ifidni      <typ>,<BYTE>
        irp     x,<list>
  x     LABEL   typ
        public  x
        db      0
        endm
elseifidni  <typ>,<WORD>
        irp     x,<list>
  x     LABEL   typ
        public  x
        dw      0
        endm
else
        irp     x,<list>
  x     LABEL   typ
        public  x
        endm
endif
        endm

;------- Mixed memory model macros ----------------------
;  Compatible with MicroSoft's MIXED.INC macros except
; this ifFP works with multiple operand instructions.
; Also an ifNP (if Near Pointers) macro is added.
IF @DataSize                ;FAR DATA MODEL
    FP      EQU     <es:>
    ifFP    MACRO   a,b,c,d,e
            IFNB <c>
        a b,c d e
            ELSE
        a b
            ENDIF
            ENDM
    ifNP    MACRO   a,b,c,d,e
            ENDM
    pLes    MACRO   a,b
        les     a,b
            ENDM
    pLds    MACRO   a,b
        lds     a,b
            ENDM
ELSE                        ;NEAR DATA MODEL
    FP      EQU     <>
    ifFP    MACRO   a,b,c,d,e
            ENDM
    ifNP    MACRO   a,b,c,d,e
            IFNB <c>
        a b,c d e
            ELSE
        a b
            ENDIF
            ENDM
    pLes    MACRO   a,b
        mov     a,b
            ENDM
    pLds    MACRO   a,b
        mov     a,b
            ENDM
ENDIF

;--- Macro to fix problem with naming the code segment --
_CODE   MACRO   textname
IF @CodeSize
        ASSUME cs:textname
        .CODE   textname
ELSE
        .CODE
ENDIF
        ENDM

;------- Procedure macros -------------------------------
PUBLICPROC      MACRO   PNAME
        PUBLIC  PNAME
IF @CodeSize
PNAME           LABEL   FAR
ELSE
PNAME           LABEL   NEAR
ENDIF
        ENDM

LOCALPROC       MACRO   PNAME
PNAME           LABEL   NEAR
        ENDM

LOCPUBPROC      MACRO   PNAME
        PUBLIC  PNAME
PNAME           LABEL   NEAR
        ENDM

calln           MACRO   TNAME
        call    Near Ptr TNAME
        ENDM

callf           MACRO TNAME
        call    Far Ptr TNAME
        ENDM

IF @CodeSize
 BOFST  =       6
ELSE
 BOFST  =       4
ENDIF

;------- USEFUL EQUATES -------------------------------
s       EQU     <SHORT>
n       EQU     <NOT>
OFST    EQU     <OFFSET>
BPTR    EQU     <Byte Ptr>
WPTR    EQU     <Word Ptr>
bBP     EQU     <Byte Ptr [BP]>
wBP     EQU     <Word Ptr [BP]>
bBX     EQU     <Byte Ptr [BX]>
wBX     EQU     <Word Ptr [BX]>
bSI     EQU     <Byte Ptr [SI]>
wSI     EQU     <Word Ptr [SI]>
bDI     EQU     <Byte Ptr [DI]>
wDI     EQU     <Word Ptr [DI]>
bDG     EQU     <Byte Ptr DGROUP>
wDG     EQU     <Word Ptr DGROUP>
ofDG    EQU     <OFFSET DGROUP>
DG      EQU     <DGROUP>

% IF1END
