/* Icon Heaven installation script */
/* (C)Copyright 1993-1994 by The Frobozz Magic Software Company */
Call RxFuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

app = 'IHeaven'
key = 'INSTDIR'

'@echo off'

Call SysCls

say 'Frobozz Icon Heaven installation utility version 1.02'
say '(C)Copyright 1993-1994 by the Frobozz Magic Software Company'
/* check to see if Icon Heaven is installed, if so update it */

res = SysIni(, app, key)

if res <> 'ERROR:' then do
	instdir = res
	call update
	exit
end

ini = value('USER_INI',,'OS2ENVIRONMENT')

tDrive = left(ini,1)

instdir=tDrive':\IHeaven'

dll=tDrive':\os2\dll\fim.dll'

res=stream(dll,'c','query exists')

if res<>'' then do
	call update100
	exit
end


say 'Please enter the path where Icon Heaven will be installed'
say 'Press [enter] to select the default path ['instdir']'
pull newdir

if newdir <> '' then
	instdir = newdir

say 'Icon Heaven will be installed in ['instdir']'
'pause'

res = mkdir(instdir)

if res <> 0 then do
	say 'The directory ['instdir'] you specified cannot be created'
	say 'installation aborted'
	exit
end

/* say 'copying fim.dll to 'instdir */
'copy fim.dll 'instdir' >nul'

if SysRegisterObjectClass('FIMTransIcon', instdir'\fim.dll') then
	say 'FIMTransIcon registered'
else do
	say 'FIMTransIcon registration failed'
	exit
end

if SysRegisterObjectClass('FIMFolder', instdir'\fim.dll') then
	say 'FIMFolder registered'
else do
	say 'FIMFolder registration failed'
	call SysDeregisterObjectClass 'FimTransIcon'
	
	exit
end

/* say 'copying fim.hlp to 'instdir */
'copy fim.hlp 'instdir' >nul'
'copy fim.ico 'instdir' >nul'
'copy iconlib.exe 'instdir' >nul'
'copy iconlib.ico 'instdir' >nul'
'copy deinstal.cmd 'instdir' >nul'
'copy replace.exe 'instdir' >nul'
'copy readme.1st 'instdir' >nul'

retval = SysCreateObject('WPFolder', 'Icon Heaven', '<WP_DESKTOP>', 'OBJECTID=<FIM_ICONS>;ICONFILE='instdir'\fim.ico', 'U')
retval = SysCreateObject('WPProgram', 'Icon Librarian', '<FIM_ICONS>', 'PROGTYPE=WINDOWABLEVIO;ASSOCFILTER=*.FIM;EXENAME='instdir'\iconlib.exe;ICONFILE='instdir'\iconlib.ico', 'U')
retval = SysCreateObject('WPProgram', 'De-Install', '<FIM_ICONS>', 'PROGTYPE=WINDOWABLEVIO;EXENAME='instdir'\deinstal.cmd', 'U')
retval = SysCreateObject('WPProgram', 'Read Me', '<FIM_ICONS>', 'PROGTYPE=PM;EXENAME=e.exe;PARAMETERS='instdir'\readme.1st', 'U')

call instlibs '.'

res = SysIni(, app, key, instdir)

say 'Installation has been succesfully completed.'
say 'Do you wish me to clean up the installation directory? [N/y]'
pull reply
if left(reply, 1) = 'Y' then do
	call cleanup
end

Exit


instlibs:

dir=ARG(1)


call SysFileTree dir'\*.fim', 'file.', 'FO'

say 'Installing icon libraries'

Do i=1 to file.0
	targ = instdir'\'filespec('n',file.i)
	'copy' file.i targ '>nul'
	cookie1 = charin(targ)
	cookie2 = charin(targ)
	if cookie1 = 'L' & cookie2 = 'I' then do
		dum = charin(targ,,8)
		n = ''
		c = charin(targ)
		do until c2d(c) = 0
			n = n''c
			c= charin(targ)
		end
		retval = SysCreateObject('FIMFolder', n, '<FIM_ICONS>', 'ICONLIBRARY='targ, 'U')
		say 'Library 'n' added'
		call stream targ,'C','CLOSE'
	end
	else do
		call stream targ,'C','CLOSE'
		'del 'targ
	end
End

return


cleanup:

'del *.fim'
'del fim.ico'
'del fim.hlp'
'del fim.dll'
'del iconlib.exe'
'del iconlib.ico'
'del readme.1st'
'del install.cmd'
'del deinstal.cmd'

return


update100:

/* update from 1.00 */

say ''
say 'Icon Heaven is installed in directory ['instdir']'
say 'Do you wish me to update it ? [Y/n]'
pull reply

if left(reply,1)='N' then return

/* use default directory */

res = SysIni(, app, key, instdir)

'copy fim.dll 'instdir' >nul'
'copy fim.hlp 'instdir' >nul'
'copy fim.ico 'instdir' >nul'
'copy iconlib.exe 'instdir' >nul'
'copy iconlib.ico 'instdir' >nul'
'copy readme.1st 'instdir' >nul'
'copy replace.exe 'instdir' >nul'
'copy deinstal.cmd 'instdir' >nul'

retval = SysCreateObject('WPProgram', 'Icon Librarian', '<FIM_ICONS>', 'PROGTYPE=WINDOWABLEVIO;ASSOCFILTER=*.FIM;EXENAME='instdir'\iconlib.exe;ICONFILE='instdir'\iconlib.ico', 'U')
retval = SysCreateObject('WPProgram', 'De-Install', '<FIM_ICONS>', 'PROGTYPE=WINDOWABLEVIO;EXENAME='instdir'\install.cmd', 'U')
retval = SysCreateObject('WPProgram', 'Read Me', '<FIM_ICONS>', 'PROGTYPE=PM;EXENAME=e.exe;PARAMETERS='instdir'\readme.1st', 'U')

'replace 'dll' 'instdir'\fim.dll'
'del 'dll
'del 'tDrive':\os2\help\fim.hlp'

say 'Icon Heaven has been updated.'
say 'You will need to reboot to make it available'

return

mkdir: procedure expose (Globals)
parse arg dir
if (length(dir) > 2) then do
	call mkdir(substr(dir,1,lastpos('\',dir)-1))
	res = SysMkDir(dir)
end	
if res = 5 then res = 0
return res

update:

say ''
say 'Icon Heaven is installed in directory ['instdir']'
say 'Do you wish me to update it ? [Y/n]'
pull reply

if left(reply,1)='N' then return

dll=instdir'\fim.dll'
tmp=instdir'\t\fim.dll'

'md 'instdir'\t'
'copy 'dll tmp' >nul'
'replace 'dll tmp
'copy fim.dll 'dll' >nul'
'replace 'tmp dll
'del 'tmp
'rd 'instdir'\t'
'copy fim.hlp 'instdir' >nul'
'copy fim.ico 'instdir' >nul'
'copy iconlib.exe 'instdir' >nul'
'copy iconlib.ico 'instdir' >nul'
'copy readme.1st 'instdir' >nul'
'copy replace.exe 'instdir' >nul'
'copy deinstal.cmd 'instdir' >nul'

say 'Icon Heaven has been updated, '
say 'You will need to reboot to make it available'

return
