 /******************************************************
*  DOSCALL.HPP - Query Process Status                   *
 ******************************************************/

#ifndef   DOSCALL_CLASS
#define   DOSCALL_CLASS                               // doscall class

#define   NOPID          0L                           // process ID

#pragma   pack(1)                                     // byte packing

TYPEDEF   STRUCT        _SYSTEMINFO                   // system info
{
          ULONG          threadCount;                 // number of threads
          ULONG          processCount;                // number of processes
          ULONG          moduleCount;                 // number of modules

} SYSTEMINFO, *PSYSTEMINFO;                           // system info

TYPEDEF   STRUCT        _THREADINFO                   // thread info
{
          ULONG          recType;                     // record type (thread = 100)
          USHORT         withinProcess;               // TID within process
          USHORT         slot;                        // unique thread slot number
          ULONG          blockId;                     // block ID thread is sleeping on
          ULONG          priority;                    // priority
          ULONG          sysTime;                     // thread system time
          ULONG          userTime;                    // thread user time
          UCHAR          state;                       // 1=ready,2=blocked,5=running
          UCHAR          reserved1;                   // reserved field
          USHORT         reserved2;                   // reserved field

} THREADINFO, *PTHREADINFO;                           // thread info

TYPEDEF   STRUCT        _PROCESSINFO                  // process info
{
          ULONG          endIndicator;                // end indicator
          PTHREADINFO    threadInfo;                  // thread information
          USHORT         processID;                   // process ID
          USHORT         parentPID;                   // parent process ID
          ULONG          processType;                 // process type
          ULONG          processStatus;               // process status
          ULONG          sessionID;                   // session ID
          USHORT         moduleRef;                   // module reference
          USHORT         threadCount;                 // number of threads
          ULONG          reserved1;                   // reserved field
          ULONG          reserved2;                   // reserved field
          USHORT         sem16Count;                  // number of semaphores
          USHORT         dllCount;                    // number of DLLs
          USHORT         shrMemHandles;               // shared memory handles
          USHORT         reserved3;                   // reserved field
          PUSHORT        sem16Table;                  // semaphore table
          PUSHORT        dllTable;                    // DLL table
          PUSHORT        shrMemTable;                 // shared memory table

} PROCESSINFO, *PPROCESSINFO;                         // process info

TYPEDEF   STRUCT        _SEMAPHOREINFO                // semaphore info
{
          STRUCT
         _SEMAPHOREINFO *nextSemaphore;               // semaphore info
          ULONG          owningThread;                // ID of owning thread
          UCHAR          semaphoreFlags;              // semaphore flags
          UCHAR          referenceCount;              // number of references
          UCHAR          requestCount;                // number of requests
          UCHAR          reserved1;                   // reserved field
          ULONG          reserved2;                   // reserved field
          ULONG          reserved3;                   // reserved field
          CHAR           semName[1];                  // semaphore name

} SEMAPHOREINFO, *PSEMAPHOREINFO;                     // semaphore info

TYPEDEF   STRUCT        _SHAREDMEMINFO                // sharedmem info
{
          STRUCT
         _SHAREDMEMINFO *nextSharedMem;               // shared information
          USHORT         memHandle;                   // shared memory handle
          SEL            selector;                    // segment selector
          USHORT         referenceCount;              // number of references
          CHAR           memName[1];                  // shared memory name

} SHREDMMEMINFO, *PSHAREDMEMINFO;                     // sharedmem info

TYPEDEF   STRUCT        _MODULEINFO                   // module info
{
          STRUCT
         _MODULEINFO    *nextModule;                  // next module
          USHORT         moduleRef;                   // module reference
          USHORT         moduleType;                  // (0=16bit,1=32bit)
          ULONG          referenceCount;              // reference count
          ULONG          segmentCount;                // segment count
          ULONG          reserved1;                   // reserved field
          PSZ            moduleName;                  // qualified name
          USHORT         handleRef[1];                // handle reference

} MODULEINFO, *PMODULEINFO;                           // module info

TYPEDEF   STRUCT        _HEADERINFO                   // header info
{
          PSYSTEMINFO    systemInfo;                  // system info
          PPROCESSINFO   processInfo;                 // process info
          PSEMAPHOREINFO semaphoreInfo;               // semaphore info
          PVOID          reserved1;                   // reserved info
          PSHAREDMEMINFO sharedMemInfo;               // sharedmem info
          PMODULEINFO    moduleInfo;                  // module info
          PVOID          reserved2;                   // reserved info
          PVOID          reserved3;                   // reserved info

} HEADERINFO, *PHEADERINFO;                           // header info

#pragma   pack()

extern "C" {
#undef    PASCAL                                      // make undefined
#define   PASCAL         USHORT _Far16 _Pascal        // pascal linkage
PASCAL    DosQProcStatus(PVOID statusBuffer, USHORT bufferSize);
}

#endif                                                // doscall class

