 /******************************************************
*  PROCESS.CPP - if process is active                   *
 ******************************************************/

#include "defines.hpp"                                // type defines
#include "process.hpp"                                // process class

CHAR      PROCESS::queryBuffer[BUFFER_SIZE];          // query buffer

 /******************************************************
*  PROCESS::queryStatus - query status                  *
 ******************************************************/

NOLINE BOOL PROCESS::queryStatus(PVOID statusBuffer, USHORT bufferSize)

{
     BOOL   returnCode;                               // return code

     returnCode = ((::DosQProcStatus(statusBuffer, bufferSize) != 0) ? FALSE : TRUE);

     return returnCode;                               // return code
}

 /******************************************************
*  PROCESS::listProcess - list process                  *
 ******************************************************/

NOLINE BOOL PROCESS::listProcess(PHEADERINFO headerInfo)

{
     PMODULEINFO  moduleInfo  = NULL;                 // module info

     PPROCESSINFO processInfo = headerInfo->processInfo;

     if (processInfo != NULL) {                       // process info

          while (processInfo->endIndicator != END_PROCESS) {

               moduleInfo = headerInfo->moduleInfo;   // module info

               if (moduleInfo != NULL) {              // module info

                    printModule(moduleInfo, processInfo);
               }
               // assume next PROCESSINFO structure is found by taking
               // the address of the first THREADINFO structure of the
               // current PROCESSINFO structure and adding the size of
               // the THREADINFO structure times the number of threads

               processInfo = (PPROCESSINFO)           // process info

              (processInfo->threadInfo + processInfo->threadCount);
          }
     }
     return TRUE;                                     // return code
}

 /******************************************************
*  PROCESS::printModule - print module                  *
 ******************************************************/

NOLINE VOID PROCESS::printModule(PMODULEINFO moduleInfo, PPROCESSINFO processInfo)

{
     while (moduleInfo != NULL) {                     // module info

          if (moduleInfo->moduleRef == processInfo->moduleRef) {

               printf(" %5lu   %5lu   %5lu   %5lu   %s\n",

               (ULONG) processInfo->processID,        // process ID

               (ULONG) processInfo->parentPID,        // parent PID

               (ULONG) processInfo->sessionID,        // session ID

               (ULONG) processInfo->threadCount,      // thread count

               moduleInfo->moduleName);               // module name

               break;                                 // done printing
          }
          moduleInfo = moduleInfo->nextModule;        // next module
     }
}

 /******************************************************
*  PROCESS::listRunning - list running                  *
 ******************************************************/

NOLINE BOOL PROCESS::listRunning(VOID)

{
     BOOL   returnCode;                               // return code

     printf("PROCESS PARENT  SESSION  # OF    MODULE \n");
     printf("  ID      ID      ID    THREADS   NAME  \n");
     printf("------- ------- ------- -------  --------------------------------------------\n");

     returnCode = queryStatus(queryBuffer, BUFFER_SIZE);

     if (returnCode == TRUE) {                        // return code

          PHEADERINFO headerInfo = (PHEADERINFO) queryBuffer;

          if (headerInfo != NULL) {                   // header info

               returnCode = listProcess(headerInfo);  // list process
          }
     }
     return returnCode;                               // return code
}

