 /******************************************************
*  PROCESS.HPP - Process Class                          *
 ******************************************************/

#ifndef   PROCESS_CLASS
#define   PROCESS_CLASS                               // process class

#include "doscall.hpp"                                // doscall class

CONST     ULONG       BUFFER_SIZE = 0xFFFFU;          // status buffer
CONST     ULONG       END_PROCESS = 0x0003U;          // end indicator

CLASS     PROCESS {                                   // process class
PUBLIC:
UNIQUE                PROCESS(VOID);                  // a constructor
UNIQUE               ~PROCESS(VOID);                  // a ~destructor
PRIVATE:
STATIC    CHAR        queryBuffer[BUFFER_SIZE];       // query buffer
PRIVATE:
UNIQUE    BOOL        queryStatus(PVOID statusBuffer, USHORT bufferSize);
UNIQUE    BOOL        listProcess(PHEADERINFO headerInfo);
UNIQUE    VOID        printModule(PMODULEINFO moduleInfo, PPROCESSINFO processInfo);
PUBLIC:
UNIQUE    BOOL        listRunning(VOID);              // list processes
};

 /******************************************************
*  PROCESS::PROCESS - a constructor                     *
 ******************************************************/

INLINE PROCESS::PROCESS(VOID)

{
}

 /******************************************************
*  PROCESS::~PROCESS - a destructor                     *
 ******************************************************/

INLINE PROCESS::~PROCESS(VOID)

{
}

#endif                                                // process class

